/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.NewOrgUnitFacadeFactory;
import com.kingdee.eas.basedata.org.NewOrgViewHelper;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgViewType;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.scm.common.IReasonCodeType;
import com.kingdee.eas.basedata.scm.common.IRowType;
import com.kingdee.eas.basedata.scm.common.ReasonCodeTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.app.BaseFrameService;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.ISCMBillCommonFacade;
import com.kingdee.eas.scm.common.ISCMGroupFacade;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.SCMParamFacadeFactory;
import com.kingdee.eas.scm.common.loadmass.PurEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.util.OrgUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurOrderEditUIHandler;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import java.sql.Timestamp;

public class PurOrderEditUIHandler
extends AbstractPurOrderEditUIHandler {
    protected void _handleInit(RequestContext request, ResponseContext response, Context context) throws Exception {
        OrgUnitInfo currentMainOrg = (OrgUnitInfo)context.get((Object)OrgType.Purchase);
        request.setOrg((IObjectPK)new ObjectUuidPK(currentMainOrg.getId().toString()));
        request.put("_SCMMAINORGTYPE", (Object)OrgType.Purchase);
        request.put("_SCMPERMISSIONITEM", (Object)"purorder_addnew");
        PurOrderInfo info = new PurOrderInfo();
        if (request.getValue() == null) {
            if (request.getState() == null || request.getState().equals("ADDNEW")) {
                if (request.getBotpValue() != null) {
                    request.setValue((CoreBaseInfo)request.getBotpValue());
                } else {
                    info = (PurOrderInfo)this.createNewData(request, response, context);
                }
            } else {
                String id = request.getId();
                if (id != null) {
                    info = (PurOrderInfo)PurOrderFactory.getLocalInstance(context).getValue((IObjectPK)new ObjectUuidPK(id), request.getSelectorItemCollection());
                }
            }
            request.setValue((CoreBaseInfo)info);
        } else {
            info = (PurOrderInfo)request.getValue();
        }
        super._handleInit(request, response, context);
        if (!(BatchActionEnum.AUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.UNAUDIT.equals(request.get("BATCH_ACTION")) || BatchActionEnum.SUBMIT.equals(request.get("BATCH_ACTION")))) {
            this.prepareData(request, response, context);
        }
        ObjectStringPK pk = new ObjectStringPK("00000000-0000-0000-0000-000000000003A5CCD5DC");
        ObjectStringPK pk2 = new ObjectStringPK("00000000-0000-0000-0000-000000000001A5CCD5DC");
        IReasonCodeType iReasonCodeType = ReasonCodeTypeFactory.getLocalInstance((Context)context);
        iReasonCodeType.getReasonCodeTypeInfo((IObjectPK)pk);
        iReasonCodeType.getReasonCodeTypeInfo((IObjectPK)pk2);
        String[] keys = new String[]{"PURORDERPRICE001", "isUpdateExForOrder", "isCanSplitOnAlter"};
        SCMParamFacadeFactory.getLocalInstance((Context)context).getScmSpecialParams(keys);
        PurchaseOrgUnitInfo purchaseInfo = info.getPurchaseOrgUnit();
        if (purchaseInfo == null) {
            return;
        }
        NewOrgUnitFacadeFactory.getLocalInstance((Context)context).checkIsOUSealUp(info.getPurchaseOrgUnit().getId().toString(), 3);
        IOrgUnitRelation iUnitRel = OrgUnitRelationFactory.getLocalInstance((Context)context);
        OrgUnitCollection orgCol2 = iUnitRel.getFromUnit(purchaseInfo.getId().toString(), 3, 4);
        OrgUtils.getSortData((OrgUnitCollection)orgCol2);
        OrgUnitInfo orgInfo = (OrgUnitInfo)context.get((Object)OrgType.Storage);
        if (orgInfo != null && orgInfo.isIsStorageOrgUnit() && orgInfo.getBoolean("isBizUnit")) {
            ObjectUuidPK idpk = new ObjectUuidPK(orgInfo.getId());
            StorageOrgUnitFactory.getLocalInstance((Context)context).getStorageOrgUnitInfo((IObjectPK)idpk);
        }
        iUnitRel.getToUnit(purchaseInfo.getId().toString(), 3, 4);
    }

    protected void loadFields(RequestContext request, ResponseContext response, Context context) throws Exception {
        PurEntryDataVO inDataVO;
        super.loadFields(request, response, context);
        SCMBizDataVO bizDataVO = super.loadSCMBizData(request, response, context);
        String state = request.getState();
        String copy = (String)request.get("copy");
        boolean isCopy = false;
        if (copy != null) {
            isCopy = true;
        }
        PurOrderInfo purInfo = (PurOrderInfo)request.getValue();
        String viewNav = (String)request.get("viewNav");
        if (viewNav != null) {
            inDataVO = this.getInDataVO(request, bizDataVO, context);
            request.put("__SCMENTRYDATA", (Object)inDataVO);
            this.loadComplexData(request, response, context);
        }
        if (purInfo != null && purInfo.getPurchaseOrgUnit() != null) {
            OrgUnitRelationFactory.getLocalInstance((Context)context).getFromUnit(purInfo.getPurchaseOrgUnit().getId().toString(), 3, 4);
        }
        inDataVO = this.getInDataVO(request, bizDataVO, context);
        request.put("__SCMENTRYDATA", (Object)inDataVO);
        this.loadComplexData(request, response, context);
        ISCMGroupFacade groupFacade = SCMGroupFacadeFactory.getLocalInstance((Context)context);
        PurEntryDataVO entryDataVo = groupFacade.loadPurComplexData(inDataVO);
        BaseFrameService.getMultiKey((ResponseContext)response, ISCMGroupFacade.class, (String)"loadPurComplexData", (Class[])new Class[]{PurEntryDataVO.class}, (Object[])new Object[]{inDataVO}, (Object)entryDataVo);
        OrgViewType ovt = NewOrgViewHelper.convert((OrgType)OrgType.Purchase);
        IObjectPK userPK = request.getUserPK();
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgViewType)ovt));
        PermissionFactory.getLocalInstance((Context)context).getAuthorizedOrgs(userPK, OrgType.Purchase, (IObjectPK)treePK, null, null);
    }

    public void handleRemove(RequestContext request, ResponseContext response, Context context) throws Exception {
        if (request == null || request.getOldId() == null) {
            throw new PurOrderException(PurOrderException.DATANOTEXISTS);
        }
        super.handleRemove(request, response, context);
        this.loadComplexData(request, response, context);
        this.switchRequestOrg(request, response, context);
    }

    @Override
    protected void _handleActionFreezed(RequestContext request, ResponseContext response, Context context) throws Exception {
        String[] selIDs = (String[])request.get("entryIDs");
        if (selIDs == null) {
            throw new PurOrderException(PurOrderException.ORDER_MUSTSELECT_ONEENTRY, new String[]{PurUtil.getUIResource("OPERATOR_FREEZED")});
        }
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(context);
        iPurOrderEntry.canFreezed(pks);
        String[] reasonCodeInfos = new String[selIDs.length];
        Object reasonCodeInfo = request.get("reasonCodeInfo");
        if (reasonCodeInfo == null) {
            return;
        }
        int num = selIDs.length;
        for (int i = 0; i < num; ++i) {
            reasonCodeInfos[i] = reasonCodeInfo.toString();
        }
        iPurOrderEntry.freezed(pks, reasonCodeInfos);
    }

    protected void _handleActionRevoke(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionUnfreezed(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionPerfromInstance(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionPurpriceRecord(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionViewVersion(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleDeleteEntryAction(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    @Override
    protected void _handleActionUnclose(RequestContext request, ResponseContext response, Context context) throws Exception {
        String[] entryIDs = (String[])request.get("entryIDs");
        if (entryIDs == null) {
            throw new PurOrderException(PurOrderException.ORDER_MUSTSELECT_ONEENTRY, new String[]{PurUtil.getUIResource("OPERATOR_UNCLOSE")});
        }
        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(context);
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])entryIDs);
        iPurOrderEntry.handleUnclose(pks);
    }

    protected void _handleActionClose(RequestContext request, ResponseContext response, Context context) throws Exception {
        String[] selIDs = (String[])request.get("sellIDs");
        if (selIDs == null) {
            throw new PurOrderException(PurOrderException.ORDER_MUSTSELECT_ONEENTRY, new String[]{PurUtil.getUIResource("OPERATOR_CLOSE")});
        }
        super._handleActionClose(request, response, context);
        IObjectPK[] pks = SCMUtils.convertStringToObjectPK((String[])selIDs);
        String[] reasonCodeInfos = new String[selIDs.length];
        Object reasonCodeInfo = request.get("reasonCodeInfo");
        if (reasonCodeInfo == null) {
            return;
        }
        int num = selIDs.length;
        for (int i = 0; i < num; ++i) {
            reasonCodeInfos[i] = reasonCodeInfo.toString();
        }
        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(context);
        iPurOrderEntry.canHandClose(pks);
        iPurOrderEntry.handClose(pks, reasonCodeInfos);
    }

    protected void _handleActionSave(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionSave(request, response, context);
    }

    protected void _handleActionSubmit(RequestContext request, ResponseContext response, Context context) throws Exception {
        try {
            PurOrderInfo orderInfo = (PurOrderInfo)request.getValue();
            if (request.getState().equals("ALERT")) {
                IPurOrder iPurOrder = PurOrderFactory.getLocalInstance(context);
                ObjectUuidPK pk = new ObjectUuidPK(orderInfo.getId().toString());
                iPurOrder.alter((IObjectPK)pk, orderInfo);
            } else {
                super._handleActionSubmit(request, response, context);
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((String)"ddd", (Throwable)e);
        }
    }

    protected void _handleActionAddNew(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionAddNew(request, response, context);
    }

    public void _handleActionEdit(RequestContext request, ResponseContext response, Context context) throws Exception {
        super._handleActionEdit(request, response, context);
        OrgViewType ovt = NewOrgViewHelper.convert((OrgType)OrgType.Sale);
        IObjectPK userPK = request.getUserPK();
        ObjectUuidPK treePK = new ObjectUuidPK(NewOrgViewHelper.convert2TreeId((OrgViewType)ovt));
        PermissionFactory.getLocalInstance((Context)context).getAuthorizedOrgs(userPK, OrgType.Sale, (IObjectPK)treePK, null, null);
    }

    protected void _handleActionAudit(RequestContext request, ResponseContext response, Context context) throws Exception {
        PurOrderInfo orderInfo = (PurOrderInfo)request.getValue();
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance(context);
        ObjectUuidPK pk = new ObjectUuidPK(orderInfo.getId().toString());
        if (orderInfo.getBaseStatus().getValue() == -2) {
            iPurOrder.agreeAlter((IObjectPK)pk);
        } else {
            iPurOrder.audit((IObjectPK)pk);
        }
    }

    private PurEntryDataVO getInDataVO(RequestContext request, SCMBizDataVO bizDataVO, Context context) throws BOSException, EASBizException {
        PurEntryDataVO inDataVO = new PurEntryDataVO();
        PurOrderInfo purOrderInfo = (PurOrderInfo)request.getValue();
        if (purOrderInfo == null) {
            return inDataVO;
        }
        PurOrderEntryCollection entryCollection = purOrderInfo.getEntries();
        int num = entryCollection.size();
        MaterialInfo[] materialInfos = new MaterialInfo[num];
        MeasureUnitInfo[] measureUnitInfos = new MeasureUnitInfo[num];
        MeasureUnitInfo[] measureBaseUnitInfos = new MeasureUnitInfo[num];
        MeasureUnitInfo[] measureAssistUnitInfos = new MeasureUnitInfo[num];
        PurOrderEntryInfo entryInfo = null;
        for (int i = 0; i < num; ++i) {
            entryInfo = entryCollection.get(i);
            materialInfos[i] = entryInfo.getMaterial();
            measureUnitInfos[i] = entryInfo.getUnit();
            measureBaseUnitInfos[i] = entryInfo.getBaseUnit();
            measureAssistUnitInfos[i] = entryInfo.getAssistUnit();
        }
        inDataVO.setMaterialInfos(materialInfos);
        inDataVO.setMeasureUnitInfos(measureUnitInfos);
        inDataVO.setBaseMeasureUnitInfos(measureBaseUnitInfos);
        inDataVO.setAssistMeasureUnitInfos(measureAssistUnitInfos);
        inDataVO.setMainOrg((OrgUnitInfo)purOrderInfo.getPurchaseOrgUnit());
        inDataVO.setMainOrgType(OrgType.Purchase);
        CurrencyInfo currencyInfo = null;
        CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)bizDataVO.getDefaultDelegatedOrg().get(OrgType.Company);
        ICurrency ic = CurrencyFactory.getLocalInstance((Context)context);
        currencyInfo = ic.getCurrencyInfo((IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId()));
        inDataVO.setBaseCurrencyInfo(currencyInfo);
        inDataVO.setCurrencyInfo(purOrderInfo.getCurrency());
        inDataVO.setCompanyOrgUnitInfo(companyOrgUnitInfo);
        inDataVO.setIsLoadingMmuPrecision(true);
        inDataVO.setIsLoadingMou(true);
        inDataVO.setIsLoadingCurrency(true);
        if (request.getState().equals("EDIT")) {
            inDataVO.setIsLoadingSupplierRelative(true);
        }
        return inDataVO;
    }

    public void _handleActionCopy(RequestContext request, ResponseContext response, Context context) throws Exception {
        ISCMBillCommonFacade iSCMBillCommonFacade = SCMBillCommonFacadeFactory.getLocalInstance((Context)context);
        Timestamp timestamp = iSCMBillCommonFacade.getServerDate();
        PurOrderInfo purOrderInfo = (PurOrderInfo)request.getValue();
        purOrderInfo.setCreateTime(timestamp);
        purOrderInfo.setBizDate(timestamp);
        super._handleActionCopy(request, response, context);
    }

    protected IObjectValue createNewData(RequestContext request, ResponseContext response, Context context) throws Exception {
        super.createNewData(request, response, context);
        ObjectStringPK pk = new ObjectStringPK("00000000-0000-0000-0000-0000000000017C7DC4A3");
        IRowType irowtype = RowTypeFactory.getLocalInstance((Context)context);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("destinationType"));
        sic.add(new SelectorItemInfo("requestOrgType"));
        sic.add(new SelectorItemInfo("isHasMaterialNumber"));
        sic.add(new SelectorItemInfo("precision"));
        irowtype.getRowTypeInfo((IObjectPK)pk, sic);
        Boolean isUseAgent = (Boolean)request.get("isUseAgent");
        PurOrderInfo orderInfo = (PurOrderInfo)PurOrderFactory.getLocalInstance(context).createNewData(isUseAgent);
        OrgUnitInfo orgUnitInfo = this.getDefaultMainBizOrg(request, response, context);
        if (orgUnitInfo instanceof PurchaseOrgUnitInfo) {
            orderInfo.setPurchaseOrgUnit((PurchaseOrgUnitInfo)orgUnitInfo);
        }
        request.setValue((CoreBaseInfo)orderInfo);
        return orderInfo;
    }

    @Override
    protected void _handleActionGetSupplierPrice(RequestContext request, ResponseContext response, Context context) throws Exception {
    }

    private void prepareData(RequestContext request, ResponseContext response, Context ctx) throws Exception {
        ParamControlFactory.getLocalInstance((Context)ctx).getParamValue(null, "PURREQ002");
    }
}

