/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ObjectNotFoundException;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.service.IServiceContext;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.bizprocess.processorbuilder.SCMBusinessProcessorBuilder4common;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.IPurRequestEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurOrderEntryControllerBean;
import com.kingdee.eas.scm.sm.pur.app.PurOrderUtils;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurOrderEntryControllerBean
extends AbstractPurOrderEntryControllerBean
implements IBatchExecute {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurOrderEntryControllerBean");

    protected void changeOrderEntryStatus(IPurOrderEntry iPurOrderEntry, IObjectPK pk, EntryBaseStatusEnum newStatus) throws EASBizException, BOSException {
        this.changeOrderEntryStatus(iPurOrderEntry, pk, newStatus, null);
    }

    protected void changeOrderEntryStatus(IPurOrderEntry iPurOrderEntry, IObjectPK pk, EntryBaseStatusEnum newStatus, Object reasonCodeInfo) throws EASBizException, BOSException {
        PurOrderEntryInfo purOrderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo(pk);
        purOrderEntryInfo.setBaseStatus(newStatus);
        if (reasonCodeInfo instanceof IObjectValue) {
            purOrderEntryInfo.setReason(((ReasonCodeInfo)reasonCodeInfo).getName());
        } else if (reasonCodeInfo instanceof String) {
            purOrderEntryInfo.setReason((String)reasonCodeInfo);
        } else {
            purOrderEntryInfo.setReason(null);
        }
        iPurOrderEntry.update(pk, (CoreBaseInfo)purOrderEntryInfo);
    }

    private void changePurOrderStatus(Context ctx, IObjectPK entryPk, BillBaseStatusEnum newStatus) throws EASBizException, BOSException {
        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
        PurOrderEntryInfo purOrderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo(entryPk);
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance(ctx);
        ObjectUuidPK orderPK = new ObjectUuidPK(purOrderEntryInfo.getParent().getId());
        PurOrderInfo purOrderInfo = iPurOrder.getPurOrderInfo((IObjectPK)orderPK);
        purOrderInfo.setBaseStatus(newStatus);
        iPurOrder.update((IObjectPK)new ObjectUuidPK(purOrderInfo.getId()), (CoreBaseInfo)purOrderInfo);
    }

    private boolean checkAllEntryStatus(Context ctx, IObjectPK entryPk, BillBaseStatusEnum targeStatus) throws EASBizException, BOSException {
        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
        PurOrderEntryInfo purOrderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo(entryPk);
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance(ctx);
        ObjectUuidPK orderPK = new ObjectUuidPK(purOrderEntryInfo.getParent().getId());
        PurOrderInfo purOrderInfo = iPurOrder.getPurOrderInfo((IObjectPK)orderPK);
        PurOrderEntryCollection purOrderCollenction = purOrderInfo.getEntries();
        int num = purOrderCollenction.size();
        for (int i = 0; i < num; ++i) {
            if (purOrderCollenction.get(i).getBaseStatus().getValue() == targeStatus.getValue()) continue;
            return false;
        }
        return true;
    }

    public void checkPurOrderEntryHandClose(Context ctx, IObjectPK entryPK) throws EASBizException, BOSException {
        PurOrderEntryInfo poEntryInfo = this.getPurOrderEntryInfo(ctx, entryPK);
        if (poEntryInfo.getBaseStatus().getValue() != 4) {
            throw new PurOrderException(PurOrderException.ORDER_ENTRY_CANNOT_CLOSE);
        }
    }

    protected void checkPurOrderEntryHandClose(Context ctx, IObjectPK[] entryPKs) throws EASBizException, BOSException {
        if (entryPKs != null && entryPKs.length > 0) {
            int n = entryPKs.length;
            for (int i = 0; i < n; ++i) {
                try {
                    this.checkPurOrderEntryHandClose(ctx, entryPKs[i]);
                    continue;
                }
                catch (PurOrderException e) {
                    if (n > 1) {
                        throw new PurOrderException(PurOrderException.ORDER_PARTCANNOT_OPERATOR, new String[]{PurUtil.getUIResource("OPERATOR_CLOSE")});
                    }
                    throw e;
                }
            }
        }
    }

    @Override
    protected void _canHandClose(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkPurOrderEntryHandClose(ctx, pks);
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK[] pks, IObjectValue[] reasonCodes) throws BOSException, EASBizException {
        this.checkPurOrderEntryHandClose(ctx, pks);
        PurOrderEntryInfo[] purOrderEntryInfos = null;
        if (pks != null) {
            purOrderEntryInfos = new PurOrderEntryInfo[pks.length];
            IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
            ObjectUuidPK parentOrderPK = null;
            ObjectUuidPK orderPK = null;
            IObjectPK parentEntryPK = null;
            PurOrderEntryInfo purOrderEntryInfo = null;
            ReasonCodeInfo reasonCodeInfo = null;
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                reasonCodeInfo = reasonCodes == null ? null : (ReasonCodeInfo)reasonCodes[i];
                this.changeOrderEntryStatus(iPurOrderEntry, pks[i], EntryBaseStatusEnum.CLOSED, reasonCodeInfo);
                purOrderEntryInfos[i] = purOrderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo(pks[i]);
                orderPK = new ObjectUuidPK(purOrderEntryInfo.getParent().getId());
                if (parentOrderPK == null) {
                    parentOrderPK = orderPK;
                    parentEntryPK = pks[i];
                    continue;
                }
                if (parentOrderPK.equals((Object)orderPK)) continue;
                if (this.checkAllEntryStatus(ctx, parentEntryPK, BillBaseStatusEnum.CLOSED)) {
                    this.changePurOrderStatus(ctx, parentEntryPK, BillBaseStatusEnum.CLOSED);
                }
                parentOrderPK = orderPK;
                parentEntryPK = pks[i];
            }
            if (parentEntryPK != null && this.checkAllEntryStatus(ctx, parentEntryPK, BillBaseStatusEnum.CLOSED)) {
                this.changePurOrderStatus(ctx, parentEntryPK, BillBaseStatusEnum.CLOSED);
            }
            if (purOrderEntryInfos != null && purOrderEntryInfos.length > 0) {
                IPurOrder iPurOrder = PurOrderFactory.getLocalInstance(ctx);
                PurOrderInfo purOrderInfo = null;
                ArrayList<Object> params = new ArrayList<Object>();
                java.util.Date now = new java.util.Date();
                params.add(new Date(now.getTime()));
                StringBuffer ps = new StringBuffer();
                int num2 = purOrderEntryInfos.length;
                for (int i = 0; i < num2; ++i) {
                    orderPK = new ObjectUuidPK(purOrderEntryInfos[i].getParent().getId());
                    purOrderInfo = iPurOrder.getPurOrderInfo((IObjectPK)orderPK);
                    if (purOrderEntryInfos[i] != null) {
                        params.add(purOrderEntryInfos[i].getId().toString());
                        if (i != 0) {
                            ps.append(",");
                        }
                        ps.append("?");
                    }
                    if (!SCMUtils.isBotpBill((SCMBillBaseInfo)purOrderInfo, (String)"510b6503-0105-1000-e000-0107c0a812fd463ED552") || !purOrderInfo.getBizType().getId().toString().equalsIgnoreCase("d8e80652-0106-1000-e000-04c5c0a812202407435C")) continue;
                    this.writebackPurRequestByHandleClose(ctx, purOrderEntryInfos[i], purOrderEntryInfos[i]);
                }
                DbUtil.execute((Context)ctx, (String)("Update T_SM_PurOrderEntry Set FCloseDate =? Where FID In (" + ps.toString() + ")"), (Object[])params.toArray());
            }
        }
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK[] pks, String[] reasonCodes) throws BOSException, EASBizException {
        this.checkPurOrderEntryHandClose(ctx, pks);
        PurOrderEntryInfo[] purOrderEntryInfos = null;
        if (pks != null) {
            purOrderEntryInfos = new PurOrderEntryInfo[pks.length];
            IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
            ObjectUuidPK parentOrderPK = null;
            ObjectUuidPK orderPK = null;
            IObjectPK parentEntryPK = null;
            PurOrderEntryInfo purOrderEntryInfo = null;
            String reasonCodeInfo = null;
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                reasonCodeInfo = reasonCodes == null ? null : reasonCodes[i];
                this.changeOrderEntryStatus(iPurOrderEntry, pks[i], EntryBaseStatusEnum.CLOSED, reasonCodeInfo);
                purOrderEntryInfos[i] = purOrderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo(pks[i]);
                orderPK = new ObjectUuidPK(purOrderEntryInfo.getParent().getId());
                if (parentOrderPK == null) {
                    parentOrderPK = orderPK;
                    parentEntryPK = pks[i];
                    continue;
                }
                if (parentOrderPK.equals((Object)orderPK)) continue;
                if (this.checkAllEntryStatus(ctx, parentEntryPK, BillBaseStatusEnum.CLOSED)) {
                    this.changePurOrderStatus(ctx, parentEntryPK, BillBaseStatusEnum.CLOSED);
                }
                parentOrderPK = orderPK;
                parentEntryPK = pks[i];
            }
            if (parentEntryPK != null && this.checkAllEntryStatus(ctx, parentEntryPK, BillBaseStatusEnum.CLOSED)) {
                this.changePurOrderStatus(ctx, parentEntryPK, BillBaseStatusEnum.CLOSED);
            }
            if (purOrderEntryInfos != null && purOrderEntryInfos.length > 0) {
                IPurOrder iPurOrder = PurOrderFactory.getLocalInstance(ctx);
                PurOrderInfo purOrderInfo = null;
                ArrayList<Object> params = new ArrayList<Object>();
                java.util.Date now = new java.util.Date();
                params.add(new Date(now.getTime()));
                StringBuffer ps = new StringBuffer();
                int num2 = purOrderEntryInfos.length;
                for (int i = 0; i < num2; ++i) {
                    orderPK = new ObjectUuidPK(purOrderEntryInfos[i].getParent().getId());
                    purOrderInfo = iPurOrder.getPurOrderInfo((IObjectPK)orderPK);
                    if (purOrderEntryInfos[i] != null) {
                        params.add(purOrderEntryInfos[i].getId().toString());
                        if (i != 0) {
                            ps.append(",");
                        }
                        ps.append("?");
                    }
                    if (!SCMUtils.isBotpBill((SCMBillBaseInfo)purOrderInfo, (String)"510b6503-0105-1000-e000-0107c0a812fd463ED552") || !purOrderInfo.getBizType().getId().toString().equalsIgnoreCase("d8e80652-0106-1000-e000-04c5c0a812202407435C")) continue;
                    this.writebackPurRequestByHandleClose(ctx, purOrderEntryInfos[i], purOrderEntryInfos[i]);
                }
                DbUtil.execute((Context)ctx, (String)("Update T_SM_PurOrderEntry Set FCloseDate =? Where FID In (" + ps.toString() + ")"), (Object[])params.toArray());
            }
        }
    }

    protected void writebackPurRequestByHandleClose(Context ctx, PurOrderEntryInfo purOrderEntryInfo, PurOrderEntryInfo newPurOrderEntryInfo) throws EASBizException, BOSException {
        if (purOrderEntryInfo == null && newPurOrderEntryInfo == null) {
            return;
        }
        PurRequestEntryInfo purReqEntry = this.getWritebackPurRequestInfo(ctx, purOrderEntryInfo, newPurOrderEntryInfo, 3);
        if (purReqEntry != null) {
            IPurRequestEntry iPurRequestEntry = PurRequestEntryFactory.getLocalInstance(ctx);
            ObjectUuidPK purReqPK = null;
            if (purReqEntry.getBaseStatus().getValue() == 7) {
                purReqEntry.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                purReqPK = new ObjectUuidPK(purReqEntry.getParent().getId());
            }
            iPurRequestEntry.update((IObjectPK)new ObjectUuidPK(purReqEntry.getId()), (CoreBaseInfo)purReqEntry);
            if (purReqPK != null) {
                IPurRequest iPurRequest = PurRequestFactory.getLocalInstance(ctx);
                iPurRequest.update((IObjectPK)purReqPK, iPurRequest.getValue((IObjectPK)purReqPK));
            }
        }
    }

    protected PurRequestEntryInfo getWritebackPurRequestInfo(Context ctx, PurOrderEntryInfo purOrderEntryInfo, PurOrderEntryInfo newPurOrderEntryInfo, int writebackType) throws EASBizException, BOSException {
        if (purOrderEntryInfo == null && newPurOrderEntryInfo == null) {
            return null;
        }
        PurRequestEntryInfo purReqEntryInfo = null;
        if (purOrderEntryInfo != null && newPurOrderEntryInfo != null) {
            IPurRequestEntry iPurRequestEntry = PurRequestEntryFactory.getLocalInstance(ctx);
            ObjectUuidPK purReqEntryPK = new ObjectUuidPK(newPurOrderEntryInfo.getSourceBillEntryId());
            purReqEntryInfo = iPurRequestEntry.getPurRequestEntryInfo((IObjectPK)purReqEntryPK);
            purReqEntryInfo = PurOrderUtils.handleWritebackInfo(ctx, purReqEntryInfo, newPurOrderEntryInfo, writebackType, 1);
            purReqEntryInfo = PurOrderUtils.handleWritebackInfo(ctx, purReqEntryInfo, purOrderEntryInfo, writebackType, 2);
        } else if (purOrderEntryInfo != null) {
            IPurRequestEntry iPurRequestEntry = PurRequestEntryFactory.getLocalInstance(ctx);
            ObjectUuidPK purReqEntryPK = new ObjectUuidPK(purOrderEntryInfo.getSourceBillEntryId());
            purReqEntryInfo = iPurRequestEntry.getPurRequestEntryInfo((IObjectPK)purReqEntryPK);
            purReqEntryInfo = PurOrderUtils.handleWritebackInfo(ctx, purReqEntryInfo, purOrderEntryInfo, writebackType, 2);
        } else {
            IPurRequestEntry iPurRequestEntry = PurRequestEntryFactory.getLocalInstance(ctx);
            ObjectUuidPK purReqEntryPK = new ObjectUuidPK(newPurOrderEntryInfo.getSourceBillEntryId());
            purReqEntryInfo = iPurRequestEntry.getPurRequestEntryInfo((IObjectPK)purReqEntryPK);
            purReqEntryInfo = PurOrderUtils.handleWritebackInfo(ctx, purReqEntryInfo, newPurOrderEntryInfo, writebackType, 1);
        }
        return purReqEntryInfo;
    }

    protected void checkPurOrderEntryFreezed(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks != null) {
            IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                try {
                    this.checkPurOrderEntryFreezed(ctx, iPurOrderEntry, pks[i]);
                    continue;
                }
                catch (PurOrderException ex) {
                    if (num > 1) {
                        throw new PurOrderException(PurOrderException.ORDER_PARTCANNOT_OPERATOR, new String[]{PurUtil.getUIResource("OPERATOR_FREEZED")});
                    }
                    throw ex;
                }
            }
        }
    }

    public void checkPurOrderEntryFreezed(Context ctx, IPurOrderEntry iPurOrderEntry, IObjectPK pk) throws EASBizException, BOSException {
        PurOrderEntryInfo purOrderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo(pk);
        if (purOrderEntryInfo.getBaseStatus().getValue() != 4) {
            throw new PurOrderException(PurOrderException.ONLYAUDITEDORDER_CANNOT_FREEZED);
        }
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK[] pks, IObjectValue[] reasonCode) throws BOSException, EASBizException {
        this.checkPurOrderEntryFreezed(ctx, pks);
        if (pks != null) {
            IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
            ReasonCodeInfo reasonCodeInfo = null;
            ObjectUuidPK parentOrderPK = null;
            ObjectUuidPK orderPK = null;
            IObjectPK parentEntryPK = null;
            PurOrderEntryInfo purOrderEntryInfo = null;
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                reasonCodeInfo = reasonCode == null || reasonCode[i] == null ? null : (ReasonCodeInfo)reasonCode[i];
                this.changeOrderEntryStatus(iPurOrderEntry, pks[i], EntryBaseStatusEnum.BLOCKED, reasonCodeInfo);
                purOrderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo(pks[i]);
                orderPK = new ObjectUuidPK(purOrderEntryInfo.getParent().getId());
                if (parentOrderPK == null) {
                    parentOrderPK = orderPK;
                    parentEntryPK = pks[i];
                    continue;
                }
                if (parentOrderPK.equals((Object)orderPK)) continue;
                if (this.checkAllEntryStatus(ctx, parentEntryPK, BillBaseStatusEnum.BLOCKED)) {
                    this.changePurOrderStatus(ctx, parentEntryPK, BillBaseStatusEnum.BLOCKED);
                }
                parentOrderPK = orderPK;
                parentEntryPK = pks[i];
            }
            if (parentEntryPK != null && this.checkAllEntryStatus(ctx, parentEntryPK, BillBaseStatusEnum.BLOCKED)) {
                this.changePurOrderStatus(ctx, parentEntryPK, BillBaseStatusEnum.BLOCKED);
            }
        }
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK[] pks, String[] reasonCode) throws BOSException, EASBizException {
        this.checkPurOrderEntryFreezed(ctx, pks);
        if (pks != null) {
            IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
            String reasonCodeInfo = null;
            ObjectUuidPK parentOrderPK = null;
            ObjectUuidPK orderPK = null;
            IObjectPK parentEntryPK = null;
            PurOrderEntryInfo purOrderEntryInfo = null;
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                reasonCodeInfo = reasonCode == null || reasonCode[i] == null ? null : reasonCode[i];
                this.changeOrderEntryStatus(iPurOrderEntry, pks[i], EntryBaseStatusEnum.BLOCKED, reasonCodeInfo);
                purOrderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo(pks[i]);
                orderPK = new ObjectUuidPK(purOrderEntryInfo.getParent().getId());
                if (parentOrderPK == null) {
                    parentOrderPK = orderPK;
                    parentEntryPK = pks[i];
                    continue;
                }
                if (parentOrderPK.equals((Object)orderPK)) continue;
                if (this.checkAllEntryStatus(ctx, parentEntryPK, BillBaseStatusEnum.BLOCKED)) {
                    this.changePurOrderStatus(ctx, parentEntryPK, BillBaseStatusEnum.BLOCKED);
                }
                parentOrderPK = orderPK;
                parentEntryPK = pks[i];
            }
            if (parentEntryPK != null && this.checkAllEntryStatus(ctx, parentEntryPK, BillBaseStatusEnum.BLOCKED)) {
                this.changePurOrderStatus(ctx, parentEntryPK, BillBaseStatusEnum.BLOCKED);
            }
        }
    }

    protected void checkPurOrderEntryUnFreezed(Context ctx, IObjectPK[] pks) throws EASBizException, BOSException {
        if (pks != null) {
            IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                try {
                    this.checkPurOrderEntryUnFreezed(ctx, iPurOrderEntry, pks[i]);
                    continue;
                }
                catch (PurOrderException ex) {
                    if (num > 1) {
                        throw new PurOrderException(PurOrderException.ORDER_PARTCANNOT_OPERATOR, new String[]{PurUtil.getUIResource("OPERATOR_UNFREEZED")});
                    }
                    throw ex;
                }
            }
        }
    }

    public void checkPurOrderEntryUnFreezed(Context ctx, IPurOrderEntry iPurOrderEntry, IObjectPK pk) throws EASBizException, BOSException {
        PurOrderEntryInfo purOrderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo(pk);
        if (purOrderEntryInfo.getBaseStatus().getValue() != 6) {
            throw new PurOrderException(PurOrderException.ONLYBLOCKEDDORDER_CANNOT_UNFREEZED);
        }
    }

    @Override
    protected void _unFreezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkPurOrderEntryUnFreezed(ctx, pks);
        if (pks != null) {
            IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
            IPurOrder iPurOrder = PurOrderFactory.getLocalInstance(ctx);
            ObjectUuidPK parentOrderPK = null;
            ObjectUuidPK orderPK = null;
            PurOrderInfo purOrderInfo = null;
            PurOrderEntryInfo purOrderEntryInfo = null;
            int num = pks.length;
            for (int i = 0; i < num; ++i) {
                this.changeOrderEntryStatus(iPurOrderEntry, pks[i], EntryBaseStatusEnum.AUDITED);
                purOrderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo(pks[i]);
                orderPK = new ObjectUuidPK(purOrderEntryInfo.getParent().getId());
                if (parentOrderPK != null && parentOrderPK.equals((Object)orderPK)) continue;
                purOrderInfo = iPurOrder.getPurOrderInfo((IObjectPK)orderPK);
                if (purOrderInfo.getBaseStatus().getValue() == 6) {
                    this.changePurOrderStatus(ctx, pks[i], BillBaseStatusEnum.AUDITED);
                }
                parentOrderPK = orderPK;
            }
        }
    }

    @Override
    protected void _canFreezed(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.checkPurOrderEntryFreezed(ctx, pks);
    }

    @Override
    protected void _handCloseWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _freezedWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _unFreezedWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurOrderEntryInfo info = (PurOrderEntryInfo)this.getValue(ctx, pk);
        PurOrderInfo sInfo = PurOrderFactory.getLocalInstance(ctx).getPurOrderInfo((IObjectPK)new ObjectUuidPK(info.getParent().getId()));
        return sInfo.getNumber() + "  " + info.getSeq();
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK pk, IObjectValue reasonCode) throws BOSException, EASBizException {
        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
        this.checkPurOrderEntryFreezed(ctx, iPurOrderEntry, pk);
        this.changeOrderEntryStatus(iPurOrderEntry, pk, EntryBaseStatusEnum.BLOCKED, (ReasonCodeInfo)reasonCode);
        if (this.checkAllEntryStatus(ctx, pk, BillBaseStatusEnum.BLOCKED)) {
            this.changePurOrderStatus(ctx, pk, BillBaseStatusEnum.BLOCKED);
        }
    }

    @Override
    protected void _freezed(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        this._freezed(ctx, new IObjectPK[]{pk}, new String[]{reason});
    }

    @Override
    protected void _unFreezed(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._unFreezed(ctx, new IObjectPK[]{pk});
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK pk, IObjectValue reasonCode) throws BOSException, EASBizException {
        this._handClose(ctx, new IObjectPK[]{pk}, new IObjectValue[]{reasonCode});
    }

    @Override
    protected void _handClose(Context ctx, IObjectPK billId, IObjectPK pk, String reason) throws BOSException, EASBizException {
        this._handClose(ctx, new IObjectPK[]{pk}, new String[]{reason});
    }

    @Override
    protected void _handleUnclose(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int length = pks.length;
        IObjectPK parentPK = null;
        HashMap map = new HashMap();
        ArrayList list = new ArrayList();
        for (int i = 0; i < length; ++i) {
            parentPK = this.handleEntryAndReturnParentPK(ctx, list, pks[i]);
            if (map.containsKey(parentPK)) continue;
            this.handleOrder(ctx, parentPK, map);
        }
        this.handleCanNotUncloseOrder(list);
    }

    private void handleOrder(Context ctx, IObjectPK parentPK, Map map) throws BOSException, EASBizException {
        SelectorItemInfo baseStatus = new SelectorItemInfo("baseStatus");
        SelectorItemCollection orderSic = new SelectorItemCollection();
        orderSic.add(baseStatus);
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance(ctx);
        PurOrderInfo purOrderInfo = (PurOrderInfo)iPurOrder.getValue(parentPK, orderSic);
        BillBaseStatusEnum orderStatus = purOrderInfo.getBaseStatus();
        if (orderStatus.equals((Object)BillBaseStatusEnum.CLOSED)) {
            map.put(parentPK, null);
            purOrderInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
            iPurOrder.updatePartial((CoreBaseInfo)purOrderInfo, orderSic);
        }
    }

    private IObjectPK handleEntryAndReturnParentPK(Context ctx, List list, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection entrySic = new SelectorItemCollection();
        entrySic.add(new SelectorItemInfo("baseStatus"));
        entrySic.add(new SelectorItemInfo("parent.id"));
        entrySic.add(new SelectorItemInfo("reason"));
        PurOrderEntryInfo purOrderEntryInfo = null;
        IPurOrderEntry iPurEntry = PurOrderEntryFactory.getLocalInstance(ctx);
        purOrderEntryInfo = (PurOrderEntryInfo)iPurEntry.getValue(pk, entrySic);
        ObjectUuidPK parentPK = new ObjectUuidPK(purOrderEntryInfo.getParent().getId());
        EntryBaseStatusEnum entryStatus = purOrderEntryInfo.getBaseStatus();
        if (entryStatus.equals((Object)EntryBaseStatusEnum.CLOSED)) {
            purOrderEntryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
            purOrderEntryInfo.setReason("");
            iPurEntry.updatePartial((CoreBaseInfo)purOrderEntryInfo, entrySic);
        } else {
            list.add(purOrderEntryInfo.getBaseStatus().getAlias());
        }
        return parentPK;
    }

    private void handleCanNotUncloseOrder(List list) throws PurOrderException {
        Iterator it = list.iterator();
        String s = "";
        if (it.hasNext()) {
            s = (String)it.next();
            throw new PurOrderException(PurOrderException.ORDER_ENTRY_CANNOT_UNCLOSE);
        }
    }

    @Override
    protected void _handleUnclose(Context ctx, IObjectPK billId, IObjectPK pk) throws BOSException, EASBizException {
        this._handleUnclose(ctx, new IObjectPK[]{pk});
    }

    public BatchActionResults batchHandClose(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        BatchActionResults results = this.batchExecute(ctx, entries, BatchActionEnum.CLOSE);
        return results;
    }

    public BatchActionResults batchFreezed(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        BatchActionResults results = this.batchExecute(ctx, entries, BatchActionEnum.FREEZE);
        return results;
    }

    public BatchActionResults batchUnFreezed(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        BatchActionResults results = this.batchExecute(ctx, entries, BatchActionEnum.UNFREEZE);
        return results;
    }

    public BatchActionResults batchHandleUnclose(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        BatchActionResults results = this.batchExecute(ctx, entries, BatchActionEnum.UNCLOSE);
        return results;
    }

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return null;
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, IObjectPK pk, SelectorItemCollection selector) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, pk, selector);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectValue _getValue(Context ctx, String oql) throws BOSException, EASBizException {
        try {
            return super._getValue(ctx, oql);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx) throws BOSException {
        try {
            return super._getCollection(ctx, svcCtx);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, EntityViewInfo view) throws BOSException {
        try {
            return super._getCollection(ctx, svcCtx, view);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    @Override
    protected IObjectCollection _getCollection(Context ctx, IServiceContext svcCtx, String oql) throws BOSException {
        try {
            return super._getCollection(ctx, svcCtx, oql);
        }
        catch (ObjectNotFoundException e) {
            logger.info((Object)e.getMessage());
            return null;
        }
    }

    private IRowSet getRowset(Context ctx, BatchActionResults batchResults, List entryIdList) throws BOSException {
        List entryidSet = null;
        entryidSet = entryIdList == null ? batchResults.getToDoIdsList() : entryIdList;
        String entryids = PurUtil.listToString(entryidSet);
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.fname_").append(ctx.getLocale()).append(" as orgname ,purorder.fnumber ,purorder.fid as orderid, purorder.FPurchaseOrgUnitID,");
        sql.append(" entry.fid,entry.fseq,entry.fbasestatus, entry.fIsManualClose  ");
        sql.append(" from T_sm_purorder as purorder ");
        sql.append("  inner join T_SM_purorderentry as entry on entry.fparentid = purorder.fid ");
        sql.append(" inner join T_ORG_Purchase as org on org.fid = purorder.FPurchaseOrgUnitID");
        sql.append("  where entry.fid in (").append(entryids);
        sql.append(") order by entry.fseq ");
        entryidSet.clear();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    public Set batchCheckPermission(Context ctx, String permission, IRowSet rs) throws BOSException, EASBizException, SQLException {
        HashSet<String> allOrgStringSet = new HashSet<String>();
        while (rs.next()) {
            allOrgStringSet.add(rs.getString("FPurchaseOrgUnitID"));
        }
        IObjectPK[] adllOrgs = new IObjectPK[allOrgStringSet.size()];
        Object[] objs = allOrgStringSet.toArray();
        for (int i = 0; i < allOrgStringSet.size(); ++i) {
            adllOrgs[i] = new ObjectUuidPK(objs[i].toString());
        }
        IObjectPK userPK = ctx.getCaller();
        IPermission iPer = PermissionFactory.getLocalInstance((Context)ctx);
        Set sucessOrg = iPer.checkBatchPermission(userPK, adllOrgs, permission);
        return sucessOrg;
    }

    private void addLogData(Map<String, String> map, IRowSet rs) throws SQLException {
        String parentid = rs.getString("orderid");
        String seq = rs.getString("fseq");
        String number = rs.getString("fnumber");
        if (map.containsKey(parentid)) {
            map.put(parentid, map.get(parentid) + " " + seq);
        } else {
            map.put(parentid, number + "\uff1a " + seq);
        }
    }

    private void setlogs(Context ctx, Map<String, String> error, Map<String, String> sucess, String logItem) {
        Iterator<String> iterror = error.keySet().iterator();
        StringBuffer errorlog = new StringBuffer();
        StringBuffer sucesslog = new StringBuffer();
        while (iterror.hasNext()) {
            String key = iterror.next().toString();
            errorlog.append(error.get(key)).append(" ");
        }
        Iterator<String> itsucess = sucess.keySet().iterator();
        while (itsucess.hasNext()) {
            String key = itsucess.next().toString();
            sucesslog.append(sucess.get(key)).append("; ");
        }
        if (sucesslog.length() > 0) {
            IObjectPK pklog = LogUtil.beginLog((Context)ctx, (String)"1", (BOSObjectType)this.getBOSType(), null, (String)sucesslog.toString(), (String)logItem);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
        }
    }

    public void batchCloseExcute(Context ctx, BatchActionResults batchResults, String reason) throws BOSException, EASBizException, SQLException {
        PurOrderInfo info = null;
        PurOrderEntryInfo entryInfo = null;
        PurOrderEntryCollection entryColl = null;
        HashSet<String> entryidSet = new HashSet<String>();
        ArrayList<Object> entryIdList = new ArrayList<Object>();
        for (int i = 0; i < batchResults.getParamEntries().length; ++i) {
            entryIdList.add(batchResults.getParamEntries()[i].get(1));
        }
        IRowSet rs = this.getRowset(ctx, batchResults, entryIdList);
        HashSet<String> sucessParentIDSet = new HashSet<String>();
        HashMap<String, String> error = new HashMap<String, String>();
        HashMap<String, String> sucess = new HashMap<String, String>();
        Set sucessOrg = this.batchCheckPermission(ctx, "purorder_close", rs);
        PermissionException permissionException = null;
        Object[] excetionobj = null;
        String notAuditMsg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"STATUS_NOT_AUDIT", (Locale)ctx.getLocale());
        String close = ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"OPERATOR_CLOSE", (Locale)ctx.getLocale());
        rs.beforeFirst();
        while (rs.next()) {
            String orgid = rs.getString("FPurchaseOrgUnitID");
            String parentid = rs.getString("orderid");
            String entryid = rs.getString("fid");
            int entrystatus = rs.getInt("fbasestatus");
            String orgname = rs.getString("orgname");
            if (!sucessOrg.contains(orgid)) {
                excetionobj = new Object[]{orgname, close};
                permissionException = new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, excetionobj);
                batchResults.addError(entryid, (Exception)permissionException);
                this.addLogData(error, rs);
                continue;
            }
            if (entrystatus != 4) {
                batchResults.addError(entryid, notAuditMsg);
                this.addLogData(error, rs);
                continue;
            }
            sucessParentIDSet.add(parentid);
            entryidSet.add(entryid);
            this.addLogData(sucess, rs);
        }
        String tableName = "T_SM_PurOrderEntry";
        if (entryidSet.size() == 0) {
            return;
        }
        Map map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryidSet);
        if (map.size() > 0) {
            HashSet set = new HashSet();
            for (Map.Entry entry : map.entrySet()) {
                set.add(entry.getValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filter);
            PurOrderCollection coll = PurOrderFactory.getLocalInstance(ctx).getPurOrderCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    info = coll.get(i);
                    entryColl = (PurOrderEntryCollection)((Object)info.getEntries().clone());
                    info.getEntries().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!map.containsKey(entryInfo.getId().toString())) continue;
                        info.getEntries().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.CLOSE);
                }
            }
        }
        StringBuffer sql = new StringBuffer();
        String entryids = PurUtil.setToString(entryidSet);
        sql.setLength(0);
        sql.append(" update T_sm_purorderentry set fIsManualClose = 1, Freason = '").append(reason);
        sql.append("', fbasestatus = ").append(7);
        sql.append(", fclosedate = getdate()");
        sql.append(" where fid in ").append(entryids);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        String parentids = PurUtil.setToString(sucessParentIDSet);
        sql.append(" update T_sm_purorder set fbasestatus = ").append(7);
        sql.append(" where fid in ").append(parentids);
        sql.append(" and fid not in (select fparentid from T_sm_purorderentry where fbasestatus<>7 and fparentid in");
        sql.append(parentids).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.setlogs(ctx, error, sucess, "scm_purReport_close");
    }

    public void batchUnCloseExcute(Context ctx, BatchActionResults batchResults, String reason) throws BOSException, EASBizException, SQLException {
        PurOrderInfo info = null;
        PurOrderEntryInfo entryInfo = null;
        PurOrderEntryCollection entryColl = null;
        HashSet<String> entryidSet = new HashSet<String>();
        ArrayList<Object> entryIdList = new ArrayList<Object>();
        for (int i = 0; i < batchResults.getParamEntries().length; ++i) {
            entryIdList.add(batchResults.getParamEntries()[i].get(1));
        }
        IRowSet rs = this.getRowset(ctx, batchResults, entryIdList);
        HashSet<String> sucessParentIDSet = new HashSet<String>();
        HashMap<String, String> error = new HashMap<String, String>();
        HashMap<String, String> sucess = new HashMap<String, String>();
        Set sucessOrg = this.batchCheckPermission(ctx, "purorder_unClose", rs);
        rs.beforeFirst();
        PermissionException permissionException = null;
        Object[] excetionobj = null;
        String notcloseMsg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"STATUS_NOT_CLOSE", (Locale)ctx.getLocale());
        String unclose = ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"OPERATOR_UNCLOSE", (Locale)ctx.getLocale());
        while (rs.next()) {
            String orgid = rs.getString("FPurchaseOrgUnitID");
            String parentid = rs.getString("orderid");
            String entryid = rs.getString("fid");
            String orgname = rs.getString("orgname");
            int n = rs.getInt("fbasestatus");
            if (!sucessOrg.contains(orgid)) {
                excetionobj = new Object[]{orgname, unclose};
                permissionException = new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, excetionobj);
                batchResults.addError(entryid, (Exception)permissionException);
                this.addLogData(error, rs);
                continue;
            }
            if (n != 7) {
                batchResults.addError(entryid, notcloseMsg);
                this.addLogData(error, rs);
                continue;
            }
            sucessParentIDSet.add(parentid);
            this.addLogData(sucess, rs);
            entryidSet.add(entryid);
        }
        String tableName = "T_SM_PurOrderEntry";
        if (entryidSet.size() == 0) {
            return;
        }
        Map map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryidSet);
        if (map.size() > 0) {
            HashSet set = new HashSet();
            for (Map.Entry entry : map.entrySet()) {
                set.add(entry.getValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filterInfo = new FilterInfo();
            filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filterInfo);
            PurOrderCollection coll = PurOrderFactory.getLocalInstance(ctx).getPurOrderCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    info = coll.get(i);
                    entryColl = (PurOrderEntryCollection)((Object)info.getEntries().clone());
                    info.getEntries().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!map.containsKey(entryInfo.getId().toString())) continue;
                        info.getEntries().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.UNCLOSE);
                }
            }
        }
        StringBuffer sql = new StringBuffer();
        String entryids = PurUtil.setToString(entryidSet);
        sql.setLength(0);
        sql.append(" update T_sm_purorderentry set fIsManualClose = 0, Freason = null");
        sql.append(",fbasestatus = ").append(4);
        sql.append(" where fid in ").append(entryids);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        String string = PurUtil.setToString(sucessParentIDSet);
        sql.append(" update T_sm_purorder set fbasestatus = ").append(4);
        sql.append(" where fid in ").append(string);
        sql.append(" and fid not in (select fparentid from T_sm_purorderentry where fbasestatus=");
        sql.append(-2).append(" and fparentid in");
        sql.append(string).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.setlogs(ctx, error, sucess, "scm_purReport_Unclose");
    }

    public void batchFreezedExcute(Context ctx, BatchActionResults batchResults, String reason) throws BOSException, EASBizException, SQLException {
        PurOrderInfo info = null;
        PurOrderEntryInfo entryInfo = null;
        PurOrderEntryCollection entryColl = null;
        HashSet<String> entryidSet = new HashSet<String>();
        IRowSet rs = this.getRowset(ctx, batchResults, null);
        Set sucessOrg = this.batchCheckPermission(ctx, "purorder_freeze", rs);
        HashMap<String, String> error = new HashMap<String, String>();
        HashMap<String, String> sucess = new HashMap<String, String>();
        HashSet<String> sucessParentIDSet = new HashSet<String>();
        PermissionException permissionException = null;
        Object[] excetionobj = null;
        String notAuditMsg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"STATUS_NOT_AUDIT", (Locale)ctx.getLocale());
        String freezed = ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"OPERATOR_FREEZED", (Locale)ctx.getLocale());
        rs.beforeFirst();
        while (rs.next()) {
            String orgid = rs.getString("FPurchaseOrgUnitID");
            String parentid = rs.getString("orderid");
            String entryid = rs.getString("fid");
            int entrystatus = rs.getInt("fbasestatus");
            if (!sucessOrg.contains(orgid)) {
                String orgname = rs.getString("orgname");
                excetionobj = new Object[]{orgname, freezed};
                permissionException = new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, excetionobj);
                batchResults.addError(entryid, (Exception)permissionException);
                this.addLogData(error, rs);
                continue;
            }
            if (entrystatus != 4) {
                batchResults.addError(entryid, notAuditMsg);
                this.addLogData(error, rs);
                continue;
            }
            sucessParentIDSet.add(parentid);
            entryidSet.add(entryid);
            this.addLogData(sucess, rs);
        }
        String tableName = "T_SM_PurOrderEntry";
        if (entryidSet.size() == 0) {
            return;
        }
        Map map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryidSet);
        if (map.size() > 0) {
            HashSet set = new HashSet();
            for (Map.Entry entry : map.entrySet()) {
                set.add(entry.getValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filter);
            PurOrderCollection coll = PurOrderFactory.getLocalInstance(ctx).getPurOrderCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    info = coll.get(i);
                    entryColl = (PurOrderEntryCollection)((Object)info.getEntries().clone());
                    info.getEntries().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!map.containsKey(entryInfo.getId().toString())) continue;
                        info.getEntries().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.FREEZE);
                }
            }
        }
        StringBuffer sql = new StringBuffer();
        String entryids = PurUtil.setToString(entryidSet);
        sql.setLength(0);
        sql.append(" update T_sm_purorderentry set Freason = '").append(reason);
        sql.append("',fbasestatus = ").append(6);
        sql.append(" where fid in ").append(entryids);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        String parentids = PurUtil.setToString(sucessParentIDSet);
        sql.append(" update T_sm_purorder set fbasestatus = ").append(6);
        sql.append(" where fid in ").append(parentids);
        sql.append(" and fid not in (select fparentid from T_sm_purorderentry where fbasestatus<>6 and fparentid in");
        sql.append(parentids).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.setlogs(ctx, error, sucess, "scm_purReport_freezed");
    }

    public void batchUnFreezedExcute(Context ctx, BatchActionResults batchResults, String reason) throws BOSException, EASBizException, SQLException {
        PurOrderInfo info = null;
        PurOrderEntryInfo entryInfo = null;
        PurOrderEntryCollection entryColl = null;
        HashSet<String> entryidSet = new HashSet<String>();
        IRowSet rs = this.getRowset(ctx, batchResults, null);
        Set sucessOrg = this.batchCheckPermission(ctx, "purorder_unfreeze", rs);
        HashMap<String, String> error = new HashMap<String, String>();
        HashMap<String, String> sucess = new HashMap<String, String>();
        HashSet<String> sucessParentIDSet = new HashSet<String>();
        PermissionException permissionException = null;
        Object[] excetionobj = null;
        PurOrderException unfreezedException = new PurOrderException(PurOrderException.ONLYBLOCKEDDORDER_CANNOT_UNFREEZED);
        String unfreezed = ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"OPERATOR_UNFREEZED", (Locale)ctx.getLocale());
        rs.beforeFirst();
        while (rs.next()) {
            String orgid = rs.getString("FPurchaseOrgUnitID");
            String parentid = rs.getString("orderid");
            String entryid = rs.getString("fid");
            int entrystatus = rs.getInt("fbasestatus");
            if (!sucessOrg.contains(orgid)) {
                String orgname = rs.getString("orgname");
                excetionobj = new Object[]{orgname, unfreezed};
                permissionException = new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, excetionobj);
                batchResults.addError(entryid, (Exception)permissionException);
                this.addLogData(error, rs);
                continue;
            }
            if (entrystatus != 6) {
                batchResults.addError(entryid, (Exception)((Object)unfreezedException));
                this.addLogData(error, rs);
                continue;
            }
            sucessParentIDSet.add(parentid);
            entryidSet.add(entryid);
            this.addLogData(sucess, rs);
        }
        String tableName = "T_SM_PurOrderEntry";
        if (entryidSet.size() == 0) {
            return;
        }
        Map map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryidSet);
        if (map.size() > 0) {
            HashSet set = new HashSet();
            for (Map.Entry entry : map.entrySet()) {
                set.add(entry.getValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filter);
            PurOrderCollection coll = PurOrderFactory.getLocalInstance(ctx).getPurOrderCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    info = coll.get(i);
                    entryColl = (PurOrderEntryCollection)((Object)info.getEntries().clone());
                    info.getEntries().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!map.containsKey(entryInfo.getId().toString())) continue;
                        info.getEntries().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.UNFREEZE);
                }
            }
        }
        StringBuffer sql = new StringBuffer();
        String entryids = PurUtil.setToString(entryidSet);
        sql.setLength(0);
        sql.append(" update T_sm_purorderentry set  Freason = '").append(reason);
        sql.append("',fbasestatus = ").append(4);
        sql.append(" where fid in ").append(entryids);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        String parentids = PurUtil.setToString(sucessParentIDSet);
        sql.append(" update T_sm_purorder set fbasestatus = ").append(4);
        sql.append(" where fid in ").append(parentids);
        sql.append(" and fid not in (select fparentid from T_sm_purorderentry where fbasestatus=");
        sql.append(-2).append(" and fparentid in");
        sql.append(parentids).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.setlogs(ctx, error, sucess, "scm_purReport_unFreezed");
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] params = batchResults.getParamEntries();
        BatchExecuteParamsEntry param = params[0];
        String reason = null;
        reason = param.getParamTypes().length < 2 || param.get(1) == null ? "" : (param.getParamTypes()[1].equals(IObjectValue.class) ? ((ReasonCodeInfo)param.get(1)).getName() : (batchAction == BatchActionEnum.CLOSE ? param.get(2).toString() : param.get(1).toString()));
        try {
            if (batchAction == BatchActionEnum.CLOSE) {
                this.batchCloseExcute(ctx, batchResults, reason);
            } else if (batchAction == BatchActionEnum.UNCLOSE) {
                this.batchUnCloseExcute(ctx, batchResults, reason);
            } else if (batchAction == BatchActionEnum.FREEZE) {
                this.batchFreezedExcute(ctx, batchResults, reason);
            } else if (batchAction == BatchActionEnum.UNFREEZE) {
                this.batchUnFreezedExcute(ctx, batchResults, reason);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessProcessor processor = this.buildProcessor(ctx, batchActionEnum);
        BatchActionResults results = new BatchActionResults();
        if (BatchActionEnum.CLOSE.equals((Object)batchActionEnum) || BatchActionEnum.UNCLOSE.equals((Object)batchActionEnum)) {
            if (entries != null && entries.length > 0) {
                int size = entries.length;
                for (int i = 0; i < size; ++i) {
                    results.addSuccess(entries[i].get(1).toString());
                }
                results.setParamEntries(entries);
            }
        } else {
            results = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])entries);
        }
        return processor.execute(results);
    }

    private IBusinessProcessor buildProcessor(Context ctx, BatchActionEnum batchActionEnum) throws BOSException, EASBizException {
        IBusinessProcessor processor;
        SCMBusinessProcessorBuilder4common builder = new SCMBusinessProcessorBuilder4common(batchActionEnum, this.getBOSType(), null);
        if (this.getXmlFileName(batchActionEnum) != null) {
            builder.pushXmlFile(this.getBOSType(), this.getXmlFileName(batchActionEnum));
        }
        if ((processor = builder.buildProcessor(ctx)) != null && this instanceof IBatchExecute) {
            processor.setBatchExecutor((IBatchExecute)this);
        }
        return processor;
    }
}

