/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurBusinessImpl;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PurPersonWorkBenchImpl
extends AbstractPurBusinessImpl<Map<String, Object>> {
    private static final String LINE = "\n";

    public PurPersonWorkBenchImpl(Context ctx, Object param) {
        super(ctx, param);
    }

    @Override
    protected Map<String, Object> execute() throws EASBizException, BOSException {
        HashMap<String, Object> map = null;
        String tempTable = "";
        Object[] params = (Object[])this.getParam();
        if (params == null || params.length == 0 || params.length != 4) {
            return null;
        }
        if (params[0] == null || params[1] == null || params[2] == null || params[3] == null) {
            return null;
        }
        String purOrgId = params[0].toString();
        String dateFilter = params[1].toString();
        int type = Integer.parseInt(params[2].toString());
        String billTypeNum = params[3].toString();
        try {
            IObjectPK upk = this.ctx.getCaller();
            StringBuilder sql = new StringBuilder();
            sql.append("select pp.FPersonID as FPersonID,pp.FPurGroupID as FPurGroupID from T_PM_USER u ").append(LINE);
            sql.append("inner join T_BD_Person p on p.FID = u.FPersonID ").append(LINE);
            sql.append("inner join T_BD_PurchasePerson pp on pp.FPersonID = p.FID ").append(LINE);
            sql.append("where u.FID = ? and pp.FDeletedStatus = 1");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString(), (Object[])new Object[]{upk.toString()});
            if (rs == null || rs.size() == 0) {
                Map<String, Object> map2 = null;
                return map2;
            }
            String purPersonId = "";
            HashSet<String> purGroupIdSet = new HashSet<String>();
            while (rs.next()) {
                purPersonId = rs.getString("FPersonID");
                purGroupIdSet.add(rs.getString("FPurGroupID"));
            }
            if (StringUtils.isEmpty((String)purPersonId) || purGroupIdSet.size() == 0) {
                Map<String, Object> map3 = null;
                return map3;
            }
            tempTable = this.createTempTable(this.ctx);
            this.insertDataIntoTable(this.ctx, tempTable, purGroupIdSet, purPersonId, purOrgId);
            this.insertBillDataIntoTable(this.ctx, tempTable, dateFilter, purOrgId, type);
            sql.setLength(0);
            sql.append("delete from ").append(tempTable).append(" where fid is null");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            sql.setLength(0);
            sql.append("select fid from ").append(tempTable);
            IRowSet rowSet = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
            String tableName = "T_SM_PurPersonWorkBench";
            sql.setLength(0);
            sql.append("delete from ").append(tableName).append(" where FType = ").append(type).append(" and FPurOrgID = '").append(purOrgId).append("'");
            sql.append(" and FPersonID = '").append(purPersonId).append("'");
            sql.append(" and FBillTypeNum = '").append(billTypeNum).append("'");
            DbUtil.execute((Context)this.ctx, (String)sql.toString());
            if (rowSet != null && rowSet.size() > 0) {
                map = new HashMap<String, Object>();
                map.put("count", rowSet.size());
                map.put("personId", purPersonId);
                sql.setLength(0);
                sql.append("insert into ").append(tableName).append(" (FID,FPurOrgID,FType,FPersonID,FBillTypeNum) ").append(LINE);
                sql.append("select temp.FID as FID,temp.FPurOrgID as FPurOrgID,").append(type).append(" as FType, '");
                sql.append(purPersonId).append("' as FPersonID, '").append(billTypeNum).append("' as FBillTypeNum");
                sql.append(" from ").append(tempTable).append(" temp ");
                DbUtil.execute((Context)this.ctx, (String)sql.toString());
            }
        }
        catch (SQLException e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new BOSException((Throwable)e);
        }
        finally {
            TempTablePool.getInstance((Context)this.ctx).releaseTable(tempTable);
        }
        return map;
    }

    @Override
    protected String getBusinessName() throws EASBizException, BOSException {
        return "purPersonWorkBench service";
    }

    private String createTempTable(Context ctx) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("create table paramTable ( ").append(LINE);
        sql.append("FID varchar(44),").append(LINE);
        sql.append("FDemandTypeID varchar(44),").append(LINE);
        sql.append("FPurOrgID varchar(44), \n").append(LINE);
        sql.append("FGroupStandardID varchar(44) \n,");
        sql.append("FMaterialGroupID varchar(44))");
        String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        return tempTable;
    }

    private void insertDataIntoTable(Context ctx, String tempTable, Set<String> purGroupIdSet, String purPersonId, String purOrgId) throws BOSException {
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(tempTable).append(" (FDemandTypeID,FPurOrgID,FGroupStandardID,FMaterialGroupID) ").append(LINE);
        sql.append("select dtd.FDemandTypeID as FDemandTypeID,dtd.FPurOrgUnitID as FPurOrgID,").append(LINE);
        sql.append("dtd.FMateiralGroupStandardID as FMaterialGroupStandardID,dtd.FMateiralGroupID as FMateiralGroupID ").append(LINE);
        sql.append("from T_SM_DemandTaskDistribution dtd ").append(LINE);
        sql.append("left join t_bd_purchaseperson pp on dtd.FPurPersonID = pp.fid ").append(LINE);
        sql.append("where dtd.FPurGroupID in ").append(SCMServerUtils.getInStringFromSet(purGroupIdSet)).append(LINE);
        sql.append(" and (dtd.FPurPersonID is null or pp.FPersonID = '").append(purPersonId).append("')").append(LINE);
        sql.append(" and dtd.FStatus = 1").append(LINE);
        sql.append(" and dtd.FPurOrgUnitID = '").append(purOrgId).append("'");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void insertBillDataIntoTable(Context ctx, String tempTable, String dateFilter, String purOrgId, int type) throws BOSException {
        StringBuilder allSql = new StringBuilder();
        allSql.append("insert into ").append(tempTable).append(" (FID,FDemandTypeID,FPurOrgID) ").append(LINE);
        StringBuilder sql = new StringBuilder();
        sql.append("select entry.FID as FID,temp.FDemandTypeID as FDemandTypeID,temp.FPurOrgID as FPurOrgID ").append(LINE);
        sql.append("from T_SM_PurRequestEntry entry ").append(LINE);
        sql.append("inner join T_SM_PurRequest bill on bill.FID = entry.FParentID ").append(LINE);
        StringBuilder materialSql = new StringBuilder();
        materialSql.append("inner join T_BD_Material m on m.FID = entry.FMaterialID ").append(LINE);
        materialSql.append("inner join ").append(tempTable).append(" temp on temp.FPurOrgID = entry.FPurchaseOrgUnitID and temp.FDemandTypeID = bill.FDemandTypeID ").append(LINE);
        materialSql.append("inner join T_BD_MaterialGroup mg on mg.FID = temp.FMaterialGroupID ").append(LINE);
        materialSql.append("inner join T_BD_MaterialGroupDetial mgd on mgd.fmaterialid = m.fid and mgd.FMaterialGroupStandardID = temp.FGroupStandardID ").append(LINE);
        materialSql.append("inner join T_BD_MaterialGroup mg1 on mg1.fid=mgd.FMaterialGroupID and CharIndex(mg.FLongNumber,mg1.FLongNumber)>0").append(LINE);
        if (type > 2 && type <= 5) {
            materialSql.append("inner join T_B2B_MaterialPermission mper on mper.FMaterialId = m.FID").append(LINE);
        }
        StringBuilder whereSql = new StringBuilder();
        whereSql.append("where entry.FBaseStatus = 4 ").append(LINE);
        if (type == 0) {
            whereSql.append(" and bill.FIsMergeBill = 0 and entry.FQty - entry.FassOrderQty >0 ").append(LINE);
            whereSql.append(" and bill.fid not in (select FSrcObjectID from T_BOT_Relation where ").append(LINE);
            whereSql.append(" FSRCENTITYID = '").append("25428F2E").append("')").append(LINE);
        } else if (type == 1) {
            whereSql.append(" and entry.FQty - entry.FassOrderQty >0 and (bill.FIsMergeBill = 1 ").append(LINE);
            whereSql.append(" or (bill.FIsMergeBill = 0 and bill.fid in (select FSrcObjectID from T_BOT_Relation where ").append(LINE);
            whereSql.append(" FSRCENTITYID = '").append("25428F2E").append("' and FDESTENTITYID <> '").append("25428F2E").append("')))").append(LINE);
        } else if (type == 2) {
            whereSql.append(" and entry.FQty - entry.FassOrderQty >0 ").append(LINE);
        } else if (type == 3) {
            whereSql.append(" and entry.FassOrderQty = 0 and mper.Fisallowed=1 and bill.FNetBuyOfferId is  null ").append(LINE);
        } else if (type == 4) {
            whereSql.append(" and entry.FassOrderQty = 0 and mper.Fisallowed=1 and bill.FNetBuyOfferId is not null ").append(LINE);
        } else if (type == 5) {
            whereSql.append(" and entry.FassOrderQty = 0 and mper.Fisallowed=1 ").append(LINE);
        } else if (type == 6) {
            whereSql.append(" and entry.FQty - entry.FassOrderQty >0 ").append(LINE);
        } else if (type == 7) {
            whereSql.append(" and entry.FQty - entry.FassOrderQty <=0 ").append(LINE);
        } else if (type == 8) {
            // empty if block
        }
        whereSql.append(" and ").append(dateFilter).append(LINE);
        whereSql.append(" and entry.FPurchaseOrgUnitID = '").append(purOrgId).append("'");
        StringBuilder groupSql = new StringBuilder();
        groupSql.append(" group by entry.FID,temp.FDemandTypeID,temp.FPurOrgID");
        allSql.append(sql.toString()).append(materialSql.toString()).append(whereSql.toString()).append(groupSql.toString()).append(LINE);
        if (type <= 2 || type > 5) {
            allSql.append(" union all ").append(LINE);
            allSql.append(sql.toString());
            allSql.append("inner join ").append(tempTable).append(" temp on temp.FPurOrgID = entry.FPurchaseOrgUnitID and temp.FDemandTypeID = bill.FDemandTypeID ").append(LINE);
            allSql.append(whereSql.toString());
            allSql.append("  and temp.FMaterialGroupID is null and entry.fmaterialid is null ");
            allSql.append(groupSql.toString());
        }
        logger.info((Object)("========pur person workbench sql:========" + allSql.toString()));
        DbUtil.execute((Context)ctx, (String)allSql.toString());
    }
}

