/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.bot.BOTMappingFactory;
import com.kingdee.bos.metadata.bot.BOTMappingInfo;
import com.kingdee.bos.metadata.entity.EntityObjectInfo;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.IExchangeRate;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.im.inv.InvException;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.app.IBusinessChainExecutor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ParamEntryExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.framework.util.CommonUtils;
import com.kingdee.eas.scm.sm.pur.ChangeTypeEnum;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderChangeInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeException;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestChangeInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurRequestChangeControllerBean;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.BaseException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurRequestChangeControllerBean
extends AbstractPurRequestChangeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurRequestChangeControllerBean");
    private static final BigDecimal BIGZERO = new BigDecimal("0.00");
    private static final BigDecimal oneHundred = new BigDecimal("100.0");

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        PurRequestChangeInfo purRequestChangeInfo = null;
        if (isUseAgent) {
            return null;
        }
        purRequestChangeInfo = new PurRequestChangeInfo();
        Calendar cal = Calendar.getInstance();
        Date curDate = cal.getTime();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        purRequestChangeInfo.setCreateTime(ts);
        purRequestChangeInfo.setBizDate(curDate);
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        purRequestChangeInfo.setCreator(userInfo);
        return purRequestChangeInfo;
    }

    protected String getBillTypeId() {
        return "+QOcupW6S8yzVP/aipU1DkY+1VI=";
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessChainExecutor executor = BusinessChainExecutorFactory.getBusinessChainExecutor();
        ParamEntryExecuteContext executeContext = new ParamEntryExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, entries);
        executeContext.setBillTypeID(this.getBillTypeId());
        BatchActionResults batchResults = executor.batchExecute((ExecuteContext)executeContext);
        if (batchResults == null) {
            batchResults = super.batchExecute(ctx, entries, batchActionEnum);
        }
        return batchResults;
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        super.batchExecute(ctx, batchAction, batchResults);
    }

    public BatchActionResults batchSubmitRelations(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        return super.batchSubmitRelations(ctx, entries);
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        PurRequestChangeInfo info = this.getPurRequestChangeInfo(ctx, (IObjectPK)new ObjectUuidPK(id), this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (ctx.get((Object)"CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        IObjectPK[] pks = new IObjectPK[]{pk};
        PurRequestChangeInfo model = PurRequestChangeFactory.getLocalInstance(ctx).getPurRequestChangeInfo(pk, this.getSelector());
        if (this.checkIsInWF(ctx, pks)) {
            this.passAudit(ctx, pk, (CoreBillBaseInfo)model);
        } else {
            this.passAudit(ctx, pk, (CoreBillBaseInfo)model);
        }
        model = PurRequestChangeFactory.getLocalInstance(ctx).getPurRequestChangeInfo(pk);
        PurRequestChangeEntryInfo entry = null;
        HashSet<String> purrequestIdSet = new HashSet<String>();
        for (int i = 0; i < model.getEntries().size(); ++i) {
            entry = model.getEntries().get(i);
            purrequestIdSet.add(entry.getPurRequest().getId().toString());
        }
        Connection con = null;
        Object updateOrderChangeStatement = null;
        PreparedStatement updateRequestChangeStatement = null;
        if (null != purrequestIdSet && purrequestIdSet.size() > 0) {
            con = this.getConnection(ctx);
            String updateRequestChangeSql = "update T_SM_PurRequest set FChangeType = ? where Fid = ?";
            try {
                updateRequestChangeStatement = con.prepareStatement(updateRequestChangeSql);
                for (String requestId : purrequestIdSet) {
                    updateRequestChangeStatement.setInt(1, 2);
                    updateRequestChangeStatement.setString(2, requestId);
                    updateRequestChangeStatement.addBatch();
                }
                updateRequestChangeStatement.executeBatch();
            }
            catch (SQLException sQLException) {
            }
            finally {
                SQLUtils.cleanup((Statement)updateRequestChangeStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
            }
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.batchExecute(ctx, pks, BatchActionEnum.AUDIT);
    }

    @Override
    protected boolean _checkEntryHasDestEntry(Context ctx, IObjectPK pk, IObjectPK entryPk) throws BOSException {
        boolean result = false;
        if (null == pk || null == entryPk) {
            return result;
        }
        String sql = "select fdestentityid,fdestobjectid from T_BOT_RELATION where FSrcObjectID = '" + pk.toString() + "'";
        IRowSet rowSet = DbUtil.executeQuery((Context)ctx, (String)sql);
        HashMap map = new HashMap();
        if (rowSet != null) {
            try {
                while (rowSet.next()) {
                    String fdestentityid = rowSet.getString("fdestentityid");
                    String fdestobjectid = rowSet.getString("fdestobjectid");
                    if (null != map.get(fdestentityid)) {
                        ((List)map.get(fdestentityid)).add(fdestobjectid);
                        continue;
                    }
                    ArrayList<Object> strings = new ArrayList<Object>();
                    strings.add(fdestobjectid);
                    map.put(fdestentityid, strings);
                }
                if (map.size() == 0) {
                    return result;
                }
                StringBuffer querySql = new StringBuffer();
                for (String fdestentityid : map.keySet()) {
                    EntityObjectInfo entryEntity;
                    List strings = (List)map.get(fdestentityid);
                    if (null == strings || strings.size() < 1) continue;
                    String ids = this.listToInString(strings);
                    EntityObjectInfo entityObjectInfo = CommonUtils.getEntityByBosType((Context)ctx, (String)fdestentityid);
                    if (null == entityObjectInfo || (entryEntity = CommonUtils.getEntryEntityObject((EntityObjectInfo)entityObjectInfo)) == null || entryEntity.getTable() == null) continue;
                    String entryTableName = entryEntity.getTable().getName();
                    querySql.append(" select FSourceBillEntryID from " + entryTableName + " where FParentID in (" + ids + ") and FSourceBillEntryID = ('" + entryPk + "') ");
                    querySql.append(" UNION ALL ");
                }
                if (querySql.length() == 0) {
                    return false;
                }
                IRowSet entrySet = DbUtil.executeQuery((Context)ctx, (String)(querySql = querySql.delete(querySql.length() - 10, querySql.length())).toString());
                if (entrySet != null && entrySet.size() > 0) {
                    return true;
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        return result;
    }

    private String listToInString(List<String> strings) {
        StringBuffer ids = new StringBuffer();
        for (String id : strings) {
            ids.append("'" + id + "',");
        }
        ids = ids.delete(ids.length() - 1, ids.length());
        return ids.toString();
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        PurRequestChangeInfo info = this.getPurRequestChangeInfo(ctx, pk, this.getSelector());
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        this.batchExecute(ctx, pks, BatchActionEnum.UNAUDIT);
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurRequestChangeInfo info = (PurRequestChangeInfo)this.getValue(ctx, pk);
        this.checkBeforeCancel(ctx, info);
        this.passCancellation(ctx, info, null);
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        PurRequestChangeInfo info = (PurRequestChangeInfo)this.getValue(ctx, pk);
        this.checkBeforeCancel(ctx, info);
        this.passCancellation(ctx, info, reason);
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK pk, IObjectValue reason) throws BOSException, EASBizException {
        PurRequestChangeInfo info = (PurRequestChangeInfo)this.getValue(ctx, pk);
        this.checkBeforeCancel(ctx, info);
        this.passCancellation(ctx, info, reason);
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK[] pks, String[] reasons) throws BOSException, EASBizException {
        int num = pks.length;
        for (int i = 0; i < num; ++i) {
            this._cancelWithReason(ctx, pks[i], reasons[0]);
        }
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK[] pks, IObjectValue[] reasons) throws BOSException, EASBizException {
        int num = pks.length;
        for (int i = 0; i < num; ++i) {
            this._cancelWithReason(ctx, pks[i], reasons[0]);
        }
    }

    private void checkBeforeCancel(Context ctx, PurRequestChangeInfo info) throws BOSException, EASBizException {
        if (info == null) {
            return;
        }
        if (info.getBaseStatus() != null) {
            if (info.getBaseStatus().getValue() == 3) {
                throw new PurReqException(PurReqException.CANCEL_IS_CANCEL);
            }
            if (info.getBaseStatus().getValue() == 4) {
                throw new PurReqException(PurReqException.CANCEL_IS_AUDIT);
            }
            if (info.getBaseStatus().getValue() == 7) {
                throw new PurReqException(PurReqException.CANCEL_IS_CLOSED);
            }
        }
    }

    protected void passCancellation(Context ctx, PurRequestChangeInfo info, Object reason) throws BOSException, EASBizException {
        String setReason = null;
        if (reason instanceof ReasonCodeInfo) {
            setReason = ((ReasonCodeInfo)reason).getName(ctx.getLocale());
        } else if (reason instanceof String) {
            setReason = reason.toString();
        }
        info.setBaseStatus(BillBaseStatusEnum.DELETED);
        if (info.getEntries() != null) {
            PurRequestChangeEntryCollection entries = info.getEntries();
            int len = entries.size();
            for (int i = 0; i < len; ++i) {
                entries.get(i).setBaseStatus(EntryBaseStatusEnum.DELETED);
                entries.get(i).setReason(setReason);
            }
        }
        super._update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (IObjectValue)info);
    }

    @Override
    protected void _handleWriteBackForPurReq(Context ctx, Map changeQtyMap, Map purReqIDMap, IObjectCollection col, boolean isCreatePurOrderChange) throws BOSException, EASBizException {
        if (isCreatePurOrderChange) {
            this.entryChange(ctx, changeQtyMap, purReqIDMap, col);
        }
        this.filedChange(ctx, changeQtyMap, purReqIDMap, col, isCreatePurOrderChange);
    }

    private void entryChange(Context ctx, Map changeQtyMap, Map purReqIDMap, IObjectCollection col) throws BOSException, EASBizException {
        StringBuffer purReqEntryIDStr = new StringBuffer();
        HashSet<String> purReqIDs = new HashSet<String>();
        HashMap qtyMap = new HashMap();
        HashMap baseQtyMap = new HashMap();
        HashMap<String, String> reqAndEntry = new HashMap<String, String>();
        ArrayList<String> reqIDList = new ArrayList<String>();
        Connection con = null;
        Statement srcRateStatement = null;
        Statement destRateStatement = null;
        for (int i = 0; i < col.size(); ++i) {
            PurRequestChangeInfo changeInfo = (PurRequestChangeInfo)col.getObject(i);
            if (!ChangeTypeEnum.entryChange.equals((Object)changeInfo.getChangeType())) continue;
            PurRequestChangeEntryCollection entries = changeInfo.getEntries();
            int size = entries.size();
            for (int j = size - 1; j >= 0; --j) {
                PurRequestChangeEntryInfo changeEntry = entries.get(j);
                purReqIDs.add(changeEntry.getPurRequest().getId().toString());
            }
        }
        if (purReqIDs.size() == 0) {
            return;
        }
        Map<String, PurRequestEntryInfo> purEntryMap = this.getPurReqEntryCol(ctx, purReqIDMap.keySet());
        Map<String, PurRequestInfo> purMap = this.getPurReqCol(ctx, purReqIDs);
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            srcRateStatement = con.createStatement();
            destRateStatement = con.createStatement();
            String updateReqChangeSql = "update T_SM_PurRequestChangeEntry set FrealChangeQty = FrealChangeQty + ?,FrealChangeBaseQty = FrealChangeBaseQty + ?,FAfterChangeQty = ?,FAfterChangeBaseQty = ?,FPurReqChangeQty = FPurReqChangeQty + ?,FPurReqChangeBaseQty = FPurReqChangeBaseQty + ?,FPurOrderChangeQty = FPurOrderChangeQty + ?,FPurOrderChangeBaseQty = FPurOrderChangeBaseQty + ?,FRealChangeDays = ?  where FID = ?";
            PreparedStatement updateReqChangeStatement = con.prepareStatement(updateReqChangeSql);
            HashMap<String, PurRequestChangeEntryInfo> infoMap = new HashMap<String, PurRequestChangeEntryInfo>();
            Map changeDaysMap = this.getChangeDays(col, infoMap);
            for (int i = 0; i < col.size(); ++i) {
                PurRequestChangeInfo changeInfo = (PurRequestChangeInfo)col.getObject(i);
                if (!ChangeTypeEnum.entryChange.equals((Object)changeInfo.getChangeType())) continue;
                PurRequestChangeEntryCollection entries = changeInfo.getEntries();
                int size = entries.size();
                for (int j = size - 1; j >= 0; --j) {
                    BigDecimal reqQty;
                    PurRequestInfo info = null;
                    PurRequestChangeEntryInfo changeEntry = entries.get(j);
                    PurRequestEntryInfo entry = purEntryMap.get(changeEntry.getPurRequestEntry().getId().toString());
                    PurRequestEntryInfo newEntry = (PurRequestEntryInfo)entry.clone();
                    newEntry.setId(BOSUuid.create((String)"2B7DD5E4"));
                    if (purReqEntryIDStr.length() != 0) {
                        purReqEntryIDStr.append(",");
                    }
                    purReqEntryIDStr.append("'");
                    purReqEntryIDStr.append(changeEntry.getPurRequestEntry().getId().toString());
                    purReqEntryIDStr.append("'");
                    info = purMap.get(changeEntry.getPurRequest().getId().toString());
                    Boolean flag = false;
                    BigDecimal realChangeQty = null;
                    BigDecimal realChangeBaseQty = null;
                    BigDecimal qty = null;
                    BigDecimal baseQty = null;
                    BigDecimal assistQty = null;
                    Object assOrderQty = null;
                    BigDecimal afterChangeQty = null;
                    BigDecimal afterChangeBaseQty = null;
                    Object afterChangereqQty = null;
                    BigDecimal purReqChangeQty = null;
                    BigDecimal purReqChangeBaseQty = null;
                    BigDecimal purOrderChangeQty = null;
                    BigDecimal purOrderChangeBaseQty = null;
                    Object assOrderBaseQty = null;
                    int realChangeDays = 0;
                    EntryBaseStatusEnum reqEntryStatus = EntryBaseStatusEnum.AUDITED;
                    String reqID = entry.getId().toString();
                    BigDecimal changeQty = changeEntry.getChangeQty();
                    int changeDays = 0;
                    if (null != changeEntry.getChangeDays()) {
                        changeDays = changeEntry.getChangeDays().intValue();
                    }
                    if (changeQty.compareTo(reqQty = entry.getQty().subtract(entry.getOrderedQty()).subtract(entry.getTotalReqQty())) > 0) {
                        throw new PurRequestChangeException(PurRequestChangeException.CHANGEQTY_BEYOND_ALLOWQTY);
                    }
                    if (changeQty.compareTo(reqQty) == 0) {
                        realChangeQty = reqQty;
                        qty = reqQty;
                        realChangeDays = changeDays;
                        reqEntryStatus = EntryBaseStatusEnum.CLOSED;
                        flag = true;
                    } else {
                        realChangeQty = changeQty;
                        qty = changeQty;
                        realChangeDays = changeDays;
                        flag = true;
                    }
                    String materialID = entry.getMaterial().getId().toString();
                    String unitID = entry.getUnit().getId().toString();
                    String baseUnitID = entry.getBaseUnit().getId().toString();
                    if (null != materialID) {
                        realChangeBaseQty = this.getBaseUnitQty(ctx, materialID, unitID, baseUnitID, realChangeQty);
                        baseQty = this.getBaseUnitQty(ctx, materialID, unitID, baseUnitID, qty);
                        if (null != entry.getAssistUnit() && !entry.getAssistUnit().getId().toString().equalsIgnoreCase("")) {
                            assistQty = this.getBaseUnitQty(ctx, materialID, unitID, entry.getAssistUnit().getId().toString(), qty);
                        }
                    } else {
                        realChangeBaseQty = realChangeQty;
                        baseQty = qty;
                    }
                    purReqChangeQty = realChangeQty;
                    purReqChangeBaseQty = baseQty;
                    purOrderChangeQty = BIGZERO;
                    purOrderChangeBaseQty = BIGZERO;
                    afterChangeQty = entry.getQty().subtract(realChangeQty);
                    afterChangeBaseQty = entry.getBaseQty().subtract(baseQty);
                    entry.setQty(afterChangeQty);
                    entry.setBaseQty(afterChangeBaseQty);
                    this.handRelationParams(ctx, entry);
                    entry.setBaseStatus(reqEntryStatus);
                    entry.setUnOrderedQty(entry.getUnOrderedQty().subtract(realChangeQty));
                    entry.setUnOrderedBaseQty(entry.getUnOrderedBaseQty().subtract(baseQty));
                    if (null != entry.getAssociateQty()) {
                        entry.setAssociateQty(entry.getAssociateQty().subtract(realChangeQty));
                    }
                    if (null != entry.getUnTotalReqQty()) {
                        entry.setUnTotalReqQty(entry.getUnTotalReqQty().subtract(changeQty));
                    }
                    if (null != entry.getAssistUnit() && !entry.getAssistUnit().getId().toString().equalsIgnoreCase("")) {
                        entry.setAssistQty(entry.getAssistQty().add(assistQty));
                    }
                    newEntry.setRequestQty(purReqChangeQty.abs());
                    newEntry.setQty(purReqChangeQty.abs());
                    newEntry.setBaseQty(purReqChangeBaseQty.abs());
                    this.handRelationParams(ctx, newEntry);
                    newEntry.setBaseStatus(EntryBaseStatusEnum.AUDITED);
                    newEntry.setUnOrderedQty(qty);
                    newEntry.setUnOrderedBaseQty(baseQty);
                    if (null != newEntry.getAssistUnit() && !newEntry.getAssistUnit().getId().toString().equalsIgnoreCase("")) {
                        newEntry.setAssistQty(assistQty);
                    }
                    newEntry.setRequirementDate(this.calchangeDate(newEntry.getRequirementDate(), changeDays));
                    newEntry.setProposePurchaseDate(this.calchangeDate(newEntry.getProposePurchaseDate(), changeDays));
                    newEntry.setProposeDeliveryDate(this.calchangeDate(newEntry.getProposeDeliveryDate(), changeDays));
                    newEntry.setSeq(info.getEntries().size() + 1);
                    newEntry.setParent(info);
                    newEntry.setTotalRequQty(BIGZERO);
                    newEntry.setOrderedQty(BIGZERO);
                    newEntry.setOrderedBaseQty(BIGZERO);
                    newEntry.setAssociateQty(changeQty);
                    newEntry.setUnTotalReqQty(realChangeQty);
                    newEntry.setAssOrderQty(BIGZERO);
                    newEntry.setAssOrderBaseQty(BIGZERO);
                    if (flag.booleanValue()) {
                        if (!reqIDList.contains(entry.getParent().getId().toString())) {
                            String ids = reqAndEntry.get(entry.getParent().getId().toString()) == null ? "" : (String)reqAndEntry.get(entry.getParent().getId().toString());
                            ids = ids.equalsIgnoreCase("") ? "'" + reqID + "'" : ids + ",'" + reqID + "'";
                            reqAndEntry.put(entry.getParent().getId().toString(), ids);
                        } else {
                            reqAndEntry.remove(entry.getParent().getId().toString());
                        }
                    } else {
                        reqIDList.add(entry.getParent().getId().toString());
                        reqAndEntry.remove(entry.getParent().getId().toString());
                    }
                    PurRequestEntryFactory.getLocalInstance(ctx).update((IObjectPK)new ObjectUuidPK(entry.getId()), (CoreBaseInfo)entry);
                    PurRequestEntryFactory.getLocalInstance(ctx).addnew((CoreBaseInfo)newEntry);
                    updateReqChangeStatement.setBigDecimal(1, realChangeQty);
                    updateReqChangeStatement.setBigDecimal(2, realChangeBaseQty);
                    updateReqChangeStatement.setBigDecimal(3, afterChangeQty);
                    updateReqChangeStatement.setBigDecimal(4, afterChangeBaseQty);
                    updateReqChangeStatement.setBigDecimal(5, purReqChangeQty);
                    updateReqChangeStatement.setBigDecimal(6, purReqChangeBaseQty);
                    updateReqChangeStatement.setBigDecimal(7, purOrderChangeQty);
                    updateReqChangeStatement.setBigDecimal(8, purOrderChangeBaseQty);
                    updateReqChangeStatement.setInt(9, realChangeDays);
                    updateReqChangeStatement.setString(10, purReqIDMap.get(reqID).toString());
                    updateReqChangeStatement.addBatch();
                    purReqIDMap.remove(entry.getId().toString());
                }
            }
            updateReqChangeStatement.executeBatch();
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private void filedChange(Context ctx, Map changeQtyMap, Map purReqIDMap, IObjectCollection col, boolean isCreatePurOrderChange) throws BOSException, EASBizException {
        if (purReqIDMap.keySet().size() == 0) {
            return;
        }
        StringBuffer purReqIDStr = new StringBuffer();
        HashMap<String, Object> qtyMap = new HashMap<String, Object>();
        HashMap<String, Object> baseQtyMap = new HashMap<String, Object>();
        HashMap<String, String> reqAndEntry = new HashMap<String, String>();
        ArrayList<String> reqIDList = new ArrayList<String>();
        Iterator iterator = purReqIDMap.keySet().iterator();
        while (iterator.hasNext()) {
            String purReqID = iterator.next().toString();
            if (purReqIDStr.length() != 0) {
                purReqIDStr.append(",");
            }
            purReqIDStr.append("'");
            purReqIDStr.append(purReqID);
            purReqIDStr.append("'");
        }
        Map<String, PurRequestEntryInfo> purEntryMap = this.getPurReqEntryCol(ctx, purReqIDMap.keySet());
        Connection con = null;
        Statement destRateStatement = null;
        try {
            con = SCMBizProcessorUtil.getConnection((Context)ctx);
            destRateStatement = con.createStatement();
            StringBuffer reqEntryBuffer = new StringBuffer();
            reqEntryBuffer.append("select entry.Fid,entry.Fqty,entry.ForderedQty,entry.FMaterialID,entry.FUnitID,entry.FBaseUnitID,entry.FParentID,entry.FTotalReqQty,entry.FAssistUnitID,entry.FBaseStatus").append(" from T_SM_PurRequestEntry entry").append(" where (entry.FbaseStatus = 4 or entry.FbaseStatus = 7)").append(" and entry.FID in(").append(purReqIDStr.toString()).append(")");
            ResultSet destRateSet = destRateStatement.executeQuery(reqEntryBuffer.toString());
            StringBuffer updateReqEntrySql = new StringBuffer();
            updateReqEntrySql.append("update T_SM_PurRequestEntry set FBaseStatus = ?,FQty = FQty+?,FBaseQty = FBaseQty+?,FUNORDEREDQTY = FUNORDEREDQTY+?,FUNORDEREDBASEQTY = FUNORDEREDBASEQTY+?,FAssistQty = FAssistQty+?,FDiscountAmount= ?,FTaxAmount =  ?,FLocalAmount =  ?,FLocalTaxAmount =  ?,FTax =  ?,FLocalTax =  ?,FAmount =  ?,FREQUIREMENTDATE= ADD_DAYS(FREQUIREMENTDATE, ?),FPROPOSEPURCHASEDATE= ADD_DAYS(FPROPOSEPURCHASEDATE, ?),FPROPOSEDELIVERYDATE= ADD_DAYS(FPROPOSEDELIVERYDATE, ?) ");
            if (isCreatePurOrderChange) {
                updateReqEntrySql.append(" ,FPurchaseGroupID = ? , FPurchasePersonID = ? , FRemark = ?");
            }
            updateReqEntrySql.append(" where Fid = ?");
            PreparedStatement updateReqEntryStatement = con.prepareStatement(updateReqEntrySql.toString());
            String updateReqSql = "update T_SM_PurRequest set FBaseStatus = ?  where Fid = ?";
            PreparedStatement updateReqStatement = con.prepareStatement(updateReqSql);
            String updateReqChangeSql = "update T_SM_PurRequestChangeEntry set FrealChangeQty = FrealChangeQty + ?,FrealChangeBaseQty = FrealChangeBaseQty + ?,FAfterChangeQty = ?,FAfterChangeBaseQty = ?,FPurReqChangeQty = FPurReqChangeQty + ?,FPurReqChangeBaseQty = FPurReqChangeBaseQty + ?,FPurOrderChangeQty = FPurOrderChangeQty + ?,FPurOrderChangeBaseQty = FPurOrderChangeBaseQty + ?,FRealChangeDays = ?  where FID = ?";
            PreparedStatement updateReqChangeStatement = con.prepareStatement(updateReqChangeSql);
            Map changeDaysMap = new HashMap();
            HashMap<String, PurRequestChangeEntryInfo> infoMap = new HashMap<String, PurRequestChangeEntryInfo>();
            if (isCreatePurOrderChange) {
                changeDaysMap = this.getChangeDays(col, infoMap);
            }
            while (destRateSet.next()) {
                Boolean flag = false;
                Object realChangeQty = null;
                Object realChangeBaseQty = null;
                BigDecimal qty = null;
                BigDecimal baseQty = null;
                BigDecimal assistQty = null;
                Object assOrderQty = null;
                BigDecimal afterChangeQty = null;
                BigDecimal afterChangeBaseQty = null;
                Object purReqChangeQty = null;
                BigDecimal purReqChangeBaseQty = null;
                Object purOrderChangeQty = null;
                BigDecimal purOrderChangeBaseQty = null;
                Object assOrderBaseQty = null;
                int realChangeDays = 0;
                int reqEntryStatus = 4;
                String reqID = destRateSet.getString(1);
                if (!BOSUuid.isValid((String)reqID, (boolean)true)) continue;
                BigDecimal changeQty = (BigDecimal)changeQtyMap.get(reqID);
                int changeDays = 0;
                if (isCreatePurOrderChange) {
                    changeDays = (Integer)changeDaysMap.get(reqID);
                }
                BigDecimal orderedQty = destRateSet.getBigDecimal(3) == null ? BigDecimal.ZERO : destRateSet.getBigDecimal(3);
                BigDecimal reqQty = destRateSet.getBigDecimal(2).subtract(orderedQty).subtract(destRateSet.getBigDecimal(8));
                if (isCreatePurOrderChange) {
                    if (changeQty.compareTo(BIGZERO) >= 0) {
                        realChangeQty = changeQty;
                        qty = changeQty;
                        realChangeDays = changeDays;
                        if (reqQty.compareTo(BIGZERO) == 0) {
                            flag = true;
                        }
                        if (changeQty.compareTo(BIGZERO) == 0) {
                            reqEntryStatus = destRateSet.getInt(10);
                        }
                    } else {
                        int entryStatus = destRateSet.getInt(10);
                        if (entryStatus != 7) {
                            if (changeQty.add(reqQty).compareTo(BIGZERO) > 0) {
                                realChangeQty = changeQty;
                                qty = changeQty;
                                realChangeDays = changeDays;
                            } else {
                                realChangeQty = reqQty.multiply(new BigDecimal("-1"));
                                qty = reqQty.multiply(new BigDecimal("-1"));
                                realChangeDays = changeDays;
                                reqEntryStatus = 7;
                                flag = true;
                            }
                        } else {
                            realChangeQty = BIGZERO;
                            qty = BIGZERO;
                            realChangeDays = changeDays;
                            reqEntryStatus = 7;
                            flag = true;
                        }
                    }
                } else {
                    realChangeQty = changeQty;
                    qty = changeQty;
                    realChangeDays = changeDays;
                    if (changeQty.add(reqQty).compareTo(BIGZERO) <= 0) {
                        flag = true;
                    }
                    if (changeQty.add(reqQty).compareTo(BIGZERO) == 0) {
                        reqEntryStatus = 7;
                    }
                }
                String materialID = destRateSet.getString(4);
                String unitID = destRateSet.getString(5);
                String baseUnitID = destRateSet.getString(6);
                String assistUnitID = destRateSet.getString(9);
                if (null != materialID) {
                    realChangeBaseQty = this.getBaseUnitQty(ctx, materialID, unitID, baseUnitID, (BigDecimal)realChangeQty);
                    baseQty = this.getBaseUnitQty(ctx, materialID, unitID, baseUnitID, qty);
                    if (null != assistUnitID && !assistUnitID.equalsIgnoreCase("")) {
                        assistQty = this.getBaseUnitQty(ctx, materialID, unitID, assistUnitID, qty);
                    }
                } else {
                    realChangeBaseQty = realChangeQty;
                    baseQty = qty;
                }
                if (isCreatePurOrderChange) {
                    purReqChangeQty = realChangeQty;
                    purReqChangeBaseQty = baseQty;
                    purOrderChangeQty = BIGZERO;
                    purOrderChangeBaseQty = BIGZERO;
                } else {
                    purReqChangeQty = BIGZERO;
                    purReqChangeBaseQty = BIGZERO;
                    purOrderChangeQty = realChangeQty;
                    purOrderChangeBaseQty = baseQty;
                }
                PurRequestEntryInfo entry = purEntryMap.get(reqID);
                afterChangeQty = entry.getQty().add((BigDecimal)realChangeQty);
                afterChangeBaseQty = entry.getBaseQty().add((BigDecimal)realChangeBaseQty);
                entry.setQty(afterChangeQty);
                entry.setBaseQty(afterChangeBaseQty);
                this.handRelationParams(ctx, entry);
                PurRequestChangeEntryInfo changeEntryInfo = (PurRequestChangeEntryInfo)infoMap.get(reqID);
                updateReqEntryStatement.setInt(1, reqEntryStatus);
                updateReqEntryStatement.setBigDecimal(2, qty);
                updateReqEntryStatement.setBigDecimal(3, baseQty);
                updateReqEntryStatement.setBigDecimal(4, qty);
                updateReqEntryStatement.setBigDecimal(5, baseQty);
                if (null != assistUnitID && !assistUnitID.equalsIgnoreCase("")) {
                    updateReqEntryStatement.setBigDecimal(6, assistQty);
                } else {
                    updateReqEntryStatement.setBigDecimal(6, BIGZERO);
                }
                updateReqEntryStatement.setBigDecimal(7, entry.getDiscountAmount());
                updateReqEntryStatement.setBigDecimal(8, entry.getTaxAmount());
                updateReqEntryStatement.setBigDecimal(9, entry.getLocalAmount());
                updateReqEntryStatement.setBigDecimal(10, entry.getLocalTaxAmount());
                updateReqEntryStatement.setBigDecimal(11, entry.getTax());
                updateReqEntryStatement.setBigDecimal(12, entry.getLocalTax());
                updateReqEntryStatement.setBigDecimal(13, entry.getAmount());
                updateReqEntryStatement.setInt(14, changeDays);
                updateReqEntryStatement.setInt(15, changeDays);
                updateReqEntryStatement.setInt(16, changeDays);
                if (isCreatePurOrderChange) {
                    String purchaseGroupID = null;
                    if (null != changeEntryInfo && null != changeEntryInfo.getPurchaseGroup()) {
                        purchaseGroupID = changeEntryInfo.getPurchaseGroup().getId().toString();
                    }
                    String purchasePersonID = null;
                    if (null != changeEntryInfo && null != changeEntryInfo.getPurchasePerson()) {
                        purchasePersonID = changeEntryInfo.getPurchasePerson().getId().toString();
                    }
                    String remark = changeEntryInfo.getRemark();
                    updateReqEntryStatement.setString(17, purchaseGroupID);
                    updateReqEntryStatement.setString(18, purchasePersonID);
                    updateReqEntryStatement.setString(19, remark);
                    updateReqEntryStatement.setString(20, reqID);
                } else {
                    updateReqEntryStatement.setString(17, reqID);
                }
                updateReqEntryStatement.addBatch();
                if (flag.booleanValue()) {
                    if (!reqIDList.contains(destRateSet.getString(7))) {
                        String ids = reqAndEntry.get(destRateSet.getString(7)) == null ? "" : (String)reqAndEntry.get(destRateSet.getString(7));
                        ids = ids.equalsIgnoreCase("") ? "'" + reqID + "'" : ids + ",'" + reqID + "'";
                        reqAndEntry.put(destRateSet.getString(7), ids);
                    } else {
                        reqAndEntry.remove(destRateSet.getString(7));
                    }
                } else {
                    reqIDList.add(destRateSet.getString(7));
                    reqAndEntry.remove(destRateSet.getString(7));
                }
                updateReqChangeStatement.setBigDecimal(1, (BigDecimal)realChangeQty);
                updateReqChangeStatement.setBigDecimal(2, (BigDecimal)realChangeBaseQty);
                updateReqChangeStatement.setBigDecimal(3, afterChangeQty);
                updateReqChangeStatement.setBigDecimal(4, afterChangeBaseQty);
                updateReqChangeStatement.setBigDecimal(5, (BigDecimal)purReqChangeQty);
                updateReqChangeStatement.setBigDecimal(6, purReqChangeBaseQty);
                updateReqChangeStatement.setBigDecimal(7, (BigDecimal)purOrderChangeQty);
                updateReqChangeStatement.setBigDecimal(8, purOrderChangeBaseQty);
                updateReqChangeStatement.setInt(9, realChangeDays);
                updateReqChangeStatement.setString(10, purReqIDMap.get(reqID).toString());
                updateReqChangeStatement.addBatch();
                qtyMap.put(purReqIDMap.get(reqID).toString(), realChangeQty);
                baseQtyMap.put(purReqIDMap.get(reqID).toString(), realChangeBaseQty);
            }
            updateReqEntryStatement.executeBatch();
            updateReqChangeStatement.executeBatch();
            Statement notCloseEntryStatement = con.createStatement();
            for (String key : reqAndEntry.keySet()) {
                StringBuffer notCloseEntryBuffer = new StringBuffer();
                int reqStatus = 4;
                if (!BOSUuid.isValid((String)key, (boolean)true)) continue;
                notCloseEntryBuffer.append("select FID from T_SM_PurRequestEntry where FParentID = '").append(key).append("' and FBaseStatus = 4");
                ResultSet notCloseEntryRateSet = notCloseEntryStatement.executeQuery(notCloseEntryBuffer.toString());
                if (!notCloseEntryRateSet.next()) {
                    reqStatus = 7;
                }
                updateReqStatement.setInt(1, reqStatus);
                updateReqStatement.setString(2, key);
                updateReqStatement.addBatch();
            }
            updateReqStatement.executeBatch();
            boolean isChangePurOrder = this.isChangePurOrder(ctx, col);
            if (isChangePurOrder) {
                this.createPurReq(ctx, col, qtyMap, baseQtyMap, purReqIDStr.toString(), purEntryMap);
            }
        }
        catch (Exception e) {
            throw new BOSException(e.getMessage());
        }
        finally {
            SQLUtils.cleanup((Connection)con);
        }
    }

    private boolean isChangePurOrder(Context ctx, IObjectCollection col) throws BOSException {
        StringBuffer ids = new StringBuffer();
        if (col != null) {
            for (int i = 0; i < col.size(); ++i) {
                PurRequestChangeInfo purReqChangeInfo = (PurRequestChangeInfo)col.getObject(i);
                for (int j = 0; j < purReqChangeInfo.getEntries().size(); ++j) {
                    PurRequestChangeEntryInfo purReqChangeEntry = purReqChangeInfo.getEntries().get(j);
                    if (j > 0) {
                        ids.append(",");
                    }
                    ids.append("'" + purReqChangeEntry.getPurRequestEntry().getId().toString() + "'");
                }
            }
            String sql = "select 1 from t_sm_purorderentry where FSOURCEBILLENTRYID in (" + ids.toString() + ")";
            IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql);
            if (rs.size() > 0) {
                return true;
            }
        }
        return false;
    }

    public Date calchangeDate(Date date, int changeDays) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        cal.add(5, changeDays);
        return cal.getTime();
    }

    private Map getChangeDays(IObjectCollection col, Map<String, PurRequestChangeEntryInfo> infoMap) {
        HashMap<String, Integer> materialCD = new HashMap<String, Integer>();
        for (int i = 0; i < col.size(); ++i) {
            PurRequestChangeInfo info = (PurRequestChangeInfo)col.getObject(i);
            PurRequestChangeEntryCollection entries = info.getEntries();
            int size = entries.size();
            for (int j = size - 1; j >= 0; --j) {
                PurRequestChangeEntryInfo entry = entries.get(j);
                int changeDays = 0;
                if (null != entry.getChangeDays()) {
                    changeDays = entry.getChangeDays().intValue();
                }
                String entryId = entry.getPurRequestEntry().getId().toString();
                materialCD.put(entryId, changeDays);
                infoMap.put(entryId, entry);
            }
        }
        return materialCD;
    }

    private BigDecimal getBaseUnitQty(Context ctx, String materialID, String unitID, String baseUnitID, BigDecimal qty) throws EASBizException, BOSException {
        MeasureUnitInfo unit = new MeasureUnitInfo();
        MeasureUnitInfo baseUnit = new MeasureUnitInfo();
        unit.setId(BOSUuid.read((String)unitID));
        baseUnit.setId(BOSUuid.read((String)baseUnitID));
        return SCMUtil.getExchangeQtyForClient((Context)ctx, (String)materialID, (MeasureUnitInfo)unit, (MeasureUnitInfo)baseUnit, (BigDecimal)qty);
    }

    private void createPurReq(Context ctx, IObjectCollection col, Map qtyMap, Map baseQtyMap, String purReqIDStr, Map reqEntryMap) throws BOSException, EASBizException {
        BOTMappingInfo botMappingInfo = null;
        try {
            botMappingInfo = BOTMappingFactory.getLocalInstance((Context)ctx).getBOTMappingInfo("where name ='PURC-POC001'");
        }
        catch (Exception e) {
            throw new PurReqException(InvException.BOTPERROR, new String[0]);
        }
        CoreBillBaseCollection botpCol = this.handlePurReqChangeForOrder(col, qtyMap, baseQtyMap);
        if (null != botpCol && botpCol.size() > 0) {
            this.isExistOrder(ctx, (IObjectCollection)botpCol);
            try {
                BTPTransformResult transformResult = BTPManagerFactory.getLocalInstance((Context)ctx).transform(botpCol, new PurOrderChangeInfo().getBOSType().toString(), (IObjectPK)new ObjectUuidPK(botMappingInfo.getId().toString()));
                IObjectCollection infos = transformResult.getBills();
                HashMap<String, String> reqCMap = new HashMap<String, String>();
                HashMap<String, String> purReqIDMap = new HashMap<String, String>();
                HashMap<String, String> PurReqNumberMap = new HashMap<String, String>();
                for (int i = 0; i < botpCol.size(); ++i) {
                    PurRequestChangeInfo purc = (PurRequestChangeInfo)botpCol.get(i);
                    PurReqNumberMap.put(purc.getId().toString(), purc.getNumber().toString());
                    if (null == purc.getEntries() || purc.getEntries().size() == 0) continue;
                    for (int j = 0; j < purc.getEntries().size(); ++j) {
                        PurRequestChangeEntryInfo entry = purc.getEntries().get(j);
                        reqCMap.put(entry.getId().toString(), entry.getPurRequestEntry().getId().toString());
                        purReqIDMap.put(entry.getPurRequestEntry().getId().toString(), entry.getPurRequest().getId().toString());
                    }
                }
                PurOrderChangeFactory.getLocalInstance(ctx).handleWriteForOrder(infos, reqCMap, purReqIDMap, PurReqNumberMap);
            }
            catch (Exception e) {
                throw new BOSException(e.getMessage());
            }
        }
    }

    private void isExistOrder(Context ctx, IObjectCollection col) throws PurReqException, BOSException {
        for (int i = 0; i < col.size(); ++i) {
            PurRequestChangeInfo purChangeInfo = (PurRequestChangeInfo)col.getObject(i);
            PurRequestChangeEntryCollection purReqChangeEntryCol = purChangeInfo.getEntries();
            for (int j = 0; j < purReqChangeEntryCol.size(); ++j) {
                PurRequestChangeEntryInfo purReqChangeEntry = purReqChangeEntryCol.get(j);
                String entryId = purReqChangeEntry.getPurRequestEntry().getId().toString();
                Boolean isExist = false;
                try {
                    isExist = PurOrderChangeFactory.getLocalInstance(ctx).isExistOrderStatusAudit("'" + entryId + "'");
                }
                catch (Exception e) {
                    throw new BOSException(e.getMessage());
                }
                if (isExist.booleanValue()) continue;
                throw new PurReqException(PurReqException.PURORDER_NOT_EXIST, new String[]{purChangeInfo.getNumber(), String.valueOf(purReqChangeEntry.getSeq())});
            }
        }
    }

    private CoreBillBaseCollection handlePurReqChangeForOrder(IObjectCollection col, Map qtyMap, Map baseQtyMap) {
        CoreBillBaseCollection botCol = new CoreBillBaseCollection();
        for (int i = 0; i < col.size(); ++i) {
            PurRequestChangeInfo info = (PurRequestChangeInfo)col.getObject(i);
            PurRequestChangeEntryCollection entries = info.getEntries();
            int size = entries.size();
            for (int j = size - 1; j >= 0; --j) {
                PurRequestChangeEntryInfo entry = entries.get(j);
                BigDecimal changeQty = entry.getChangeQty();
                BigDecimal realChangeQty = (BigDecimal)qtyMap.get(entry.getId().toString());
                BigDecimal realChangeBaseQty = (BigDecimal)baseQtyMap.get(entry.getId().toString());
                if (changeQty.compareTo(BIGZERO) < 0 && realChangeBaseQty.compareTo(BIGZERO) <= 0 && entry.getChangeBaseQty().compareTo(realChangeBaseQty) < 0) {
                    entry.setRealChangeQty(realChangeQty);
                    entry.setRealChangeBaseQty(realChangeBaseQty);
                    continue;
                }
                info.getEntries().removeObject((IObjectValue)entry);
            }
            if (info.getEntries().size() <= 0) continue;
            botCol.add((CoreBillBaseInfo)info);
        }
        return botCol;
    }

    protected SelectorItemCollection getSelector(boolean isNeedEntrySelector) {
        return SCMSelectorFactory.getPurRequestChangeSelector((boolean)isNeedEntrySelector);
    }

    private Map<String, PurRequestEntryInfo> getPurReqEntryCol(Context ctx, Set idSet) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("id", (Object)idSet, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("orderedQty"));
        sic.add(new SelectorItemInfo("unit.id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("demandQty"));
        sic.add(new SelectorItemInfo("qty"));
        sic.add(new SelectorItemInfo("requestQty"));
        sic.add(new SelectorItemInfo("storageOrgUnit.id"));
        sic.add(new SelectorItemInfo("adminOrgUnit.id"));
        sic.add(new SelectorItemInfo("companyOrgUnit"));
        sic.add(new SelectorItemInfo("assistQty"));
        sic.add(new SelectorItemInfo("price"));
        sic.add(new SelectorItemInfo("discountRate"));
        sic.add(new SelectorItemInfo("actualPrice"));
        sic.add(new SelectorItemInfo("taxRate"));
        sic.add(new SelectorItemInfo("taxPrice"));
        sic.add(new SelectorItemInfo("actualTaxPrice"));
        sic.add(new SelectorItemInfo("amount"));
        sic.add(new SelectorItemInfo("localAmount"));
        sic.add(new SelectorItemInfo("exchangeRate"));
        sic.add(new SelectorItemInfo("tax"));
        sic.add(new SelectorItemInfo("taxAmount"));
        sic.add(new SelectorItemInfo("discountAmount"));
        sic.add(new SelectorItemInfo("deliveryDate"));
        sic.add(new SelectorItemInfo("receiveOverRate"));
        sic.add(new SelectorItemInfo("receiveOwingRate"));
        sic.add(new SelectorItemInfo("deliverAdvanceDay"));
        sic.add(new SelectorItemInfo("deliverDeferralDay"));
        sic.add(new SelectorItemInfo("trackNumber"));
        sic.add(new SelectorItemInfo("baseQty"));
        sic.add(new SelectorItemInfo("totalReqQty"));
        sic.add(new SelectorItemInfo("totalReceiveQty"));
        sic.add(new SelectorItemInfo("totalReceiptQty"));
        sic.add(new SelectorItemInfo("totalReturnedQty"));
        sic.add(new SelectorItemInfo("totalInvoicedQty"));
        sic.add(new SelectorItemInfo("totalInvoicedAmount"));
        sic.add(new SelectorItemInfo("totalReqPayAmt"));
        sic.add(new SelectorItemInfo("totalPaidAmount"));
        sic.add(new SelectorItemInfo("totalExpense"));
        sic.add(new SelectorItemInfo("quantityUnCtrl"));
        sic.add(new SelectorItemInfo("timeUnCtrl"));
        sic.add(new SelectorItemInfo("totalReceiveBaseQty"));
        sic.add(new SelectorItemInfo("totalReceiptBaseQty"));
        sic.add(new SelectorItemInfo("totalReturnedBaseQty"));
        sic.add(new SelectorItemInfo("totalInvoicedBaseQty"));
        sic.add(new SelectorItemInfo("totalUnReturnBaseQty"));
        sic.add(new SelectorItemInfo("totalUnReceiveBaseQty"));
        sic.add(new SelectorItemInfo("totalUnReceiveQty"));
        sic.add(new SelectorItemInfo("deliveryAddress"));
        sic.add(new SelectorItemInfo("closeDate"));
        sic.add(new SelectorItemInfo("isSupInfo"));
        sic.add(new SelectorItemInfo("curSeOrderQty"));
        sic.add(new SelectorItemInfo("localTax"));
        sic.add(new SelectorItemInfo("localTaxAmount"));
        sic.add(new SelectorItemInfo("saleOrderNumber"));
        sic.add(new SelectorItemInfo("prepaidAmount"));
        sic.add(new SelectorItemInfo("requestOrgUnit.id"));
        sic.add(new SelectorItemInfo("requestCompanyOrgUnit.id"));
        sic.add(new SelectorItemInfo("reason"));
        sic.add(new SelectorItemInfo("isRequestToReceived"));
        sic.add(new SelectorItemInfo("totalMoveQty"));
        sic.add(new SelectorItemInfo("totalInvoicedAmt"));
        sic.add(new SelectorItemInfo("totalPrePayAmt"));
        sic.add(new SelectorItemInfo("prepayment"));
        sic.add(new SelectorItemInfo("preReceived"));
        sic.add(new SelectorItemInfo("unPrereceivedAm"));
        sic.add(new SelectorItemInfo("version"));
        sic.add(new SelectorItemInfo("version"));
        sic.add(new SelectorItemInfo("oldStatus"));
        sic.add(new SelectorItemInfo("canInvMoveQty"));
        sic.add(new SelectorItemInfo("unOrderedQty"));
        sic.add(new SelectorItemInfo("unOrderedBaseQty"));
        sic.add(new SelectorItemInfo("isBetweenCompanyRec"));
        sic.add(new SelectorItemInfo("rowType.id"));
        sic.add(new SelectorItemInfo("destinationType"));
        sic.add(new SelectorItemInfo("wareHouse.id"));
        sic.add(new SelectorItemInfo("materialName"));
        sic.add(new SelectorItemInfo("isReqComEqlRecCom"));
        sic.add(new SelectorItemInfo("planReceiveQty"));
        sic.add(new SelectorItemInfo("totalCacelledStockQty"));
        sic.add(new SelectorItemInfo("totalSupplyStockQty"));
        sic.add(new SelectorItemInfo("totalSupplyStockBaseQty"));
        sic.add(new SelectorItemInfo("isReqPrePayGTprePay"));
        sic.add(new SelectorItemInfo("noNumMaterialModel"));
        sic.add(new SelectorItemInfo("qcStandard"));
        sic.add(new SelectorItemInfo("project.id"));
        sic.add(new SelectorItemInfo("trackNo.id"));
        sic.add(new SelectorItemInfo("purContractID.id"));
        sic.add(new SelectorItemInfo("matchedAmount"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("purchaseOrgUnit"));
        sic.add(new SelectorItemInfo("useAdminOrgUnit"));
        sic.add(new SelectorItemInfo("reqAdminOrgUnit"));
        sic.add(new SelectorItemInfo("receivedOrgUnit"));
        sic.add(new SelectorItemInfo("person"));
        sic.add(new SelectorItemInfo("isQuantityUnCtrl"));
        sic.add(new SelectorItemInfo("requirementDate"));
        sic.add(new SelectorItemInfo("proposeDeliveryDate"));
        sic.add(new SelectorItemInfo("proposePurchaseDate"));
        sic.add(new SelectorItemInfo("currency.id"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("parent.companyOrgUnit.name"));
        sic.add(new SelectorItemInfo("parent.companyOrgUnit.baseCurrency.id"));
        sic.add(new SelectorItemInfo("parent.companyOrgUnit.baseCurrency.precision"));
        sic.add(new SelectorItemInfo("parent.isInTax"));
        sic.add(new SelectorItemInfo("parent.isPriceInTax"));
        sic.addObjectCollection((IObjectCollection)SCMSelectorFactory.getSCMBillBaseEntrySelector((String)""));
        view.setSelector(sic);
        view.setFilter(tmpFilter);
        PurRequestEntryCollection col = PurRequestEntryFactory.getLocalInstance(ctx).getPurRequestEntryCollection(view);
        HashMap<String, PurRequestEntryInfo> entryMap = new HashMap<String, PurRequestEntryInfo>();
        for (int i = 0; i < col.size(); ++i) {
            entryMap.put(col.get(i).getId().toString(), col.get(i));
        }
        return entryMap;
    }

    private Map<String, PurRequestInfo> getPurReqCol(Context ctx, Set purReqIDs) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo tmpFilter = new FilterInfo();
        tmpFilter.getFilterItems().add(new FilterItemInfo("id", (Object)purReqIDs, CompareType.INCLUDE));
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("bizDate"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("demandType.id"));
        view.setSelector(sic);
        view.setFilter(tmpFilter);
        PurRequestCollection col = PurRequestFactory.getLocalInstance(ctx).getPurRequestCollection(view);
        HashMap<String, PurRequestInfo> purMap = new HashMap<String, PurRequestInfo>();
        for (int i = 0; i < col.size(); ++i) {
            purMap.put(col.get(i).getId().toString(), col.get(i));
        }
        return purMap;
    }

    private void handRelationParams(Context ctx, PurRequestEntryInfo entry) throws EASBizException, BOSException {
        ExchangeRateInfo exchangeRateinfo = this.getExchangeRateInfo(ctx, entry);
        if (entry.getParent().isIsInTax()) {
            this.calDiscountAmountByTaxPrice(entry);
            this.calTaxAmountByTaxPrice(entry);
            this.calLocalTaxAmount(entry, exchangeRateinfo);
            this.calTax(entry);
            this.calLocalTax(entry, exchangeRateinfo);
            this.calAmount(entry);
            this.calLocalAmount(entry, exchangeRateinfo);
        } else {
            this.calAmount(entry);
            this.calLocalAmount(entry, exchangeRateinfo);
            this.calTax(entry);
            this.calLocalTax(entry, exchangeRateinfo);
            this.calTaxAmountByTaxPrice(entry);
            this.calLocalTaxAmount(entry, exchangeRateinfo);
            this.calDiscountAmountByTaxPrice(entry);
        }
    }

    private ExchangeRateInfo getExchangeRateInfo(Context ctx, PurRequestEntryInfo entry) throws EASBizException, BOSException {
        CurrencyInfo srcCurrInfo = entry.getCurrency();
        CompanyOrgUnitInfo ficompanyOrgInfo = entry.getParent().getCompanyOrgUnit();
        CurrencyInfo baseCurrInfo = entry.getParent().getCompanyOrgUnit().getBaseCurrency();
        if (ficompanyOrgInfo != null && srcCurrInfo != null && baseCurrInfo != null && !srcCurrInfo.equals((Object)baseCurrInfo)) {
            String key = ficompanyOrgInfo.getId().toString() + srcCurrInfo.getId().toString() + baseCurrInfo.getId().toString();
            ObjectUuidPK excTablepk = null;
            ObjectUuidPK sourceCurrPK = null;
            ObjectUuidPK destCurrPK = null;
            ExchangeTableInfo baseExchangeTableInfo = ficompanyOrgInfo.getBaseExchangeTable();
            if (baseExchangeTableInfo == null) {
                CompanyOrgUnitInfo icomUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getId()));
                baseExchangeTableInfo = icomUnit.getBaseExchangeTable();
            }
            if (baseExchangeTableInfo == null) {
                throw new PurOrderException(PurOrderException.EXCHANGETABLENULL);
            }
            excTablepk = new ObjectUuidPK(baseExchangeTableInfo.getId());
            sourceCurrPK = new ObjectUuidPK(srcCurrInfo.getId());
            destCurrPK = new ObjectUuidPK(baseCurrInfo.getId());
            IExchangeRate iexchangRate = ExchangeRateFactory.getLocalInstance((Context)ctx);
            ExchangeRateInfo tempexrateinfo = iexchangRate.getExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK, Calendar.getInstance().getTime());
            return tempexrateinfo;
        }
        return null;
    }

    public void calDiscountAmountByTaxPrice(PurRequestEntryInfo entry) {
        int amountPricision = entry.getCurrency().getPrecision();
        if (entry.getDiscountRate() == null) {
            return;
        }
        int scale = amountPricision;
        BigDecimal taxPrice = entry.getTaxPrice();
        BigDecimal qty = entry.getQty();
        BigDecimal discountRate = entry.getDiscountRate();
        BigDecimal oneHundred = new BigDecimal("100.0");
        taxPrice = this.validateNullValue(taxPrice);
        qty = this.validateNullValue(qty);
        discountRate = this.validateNullValue(discountRate);
        BigDecimal discountAmount = taxPrice.multiply(qty).multiply(discountRate.divide(oneHundred, 10, 4)).setScale(scale, 4);
        entry.setDiscountAmount(discountAmount);
    }

    public void calTaxAmountByTaxPrice(PurRequestEntryInfo entry) {
        int scale = entry.getCurrency().getPrecision();
        if (entry.getParent().isIsInTax()) {
            BigDecimal taxPrice = entry.getTaxPrice();
            BigDecimal qty = entry.getQty();
            BigDecimal discountAmount = entry.getDiscountAmount();
            taxPrice = this.validateNullValue(taxPrice);
            qty = this.validateNullValue(qty);
            discountAmount = this.validateNullValue(discountAmount);
            BigDecimal taxAmount = taxPrice.multiply(qty).subtract(discountAmount);
            taxAmount = taxAmount.setScale(scale, 4);
            entry.setTaxAmount(taxAmount);
        } else {
            BigDecimal amount = entry.getAmount();
            BigDecimal tax = entry.getTax();
            amount = this.validateNullValue(amount);
            tax = this.validateNullValue(tax);
            BigDecimal taxAmount = amount.add(tax);
            taxAmount = taxAmount.setScale(scale, 4);
            entry.setTaxAmount(taxAmount);
        }
    }

    public void calLocalTaxAmount(PurRequestEntryInfo entry, ExchangeRateInfo exchangeRateinfo) {
        int scale = entry.getParent().getCompanyOrgUnit().getBaseCurrency().getPrecision();
        BigDecimal taxAmount = entry.getTaxAmount();
        BigDecimal exchangerate = entry.getExchangeRate();
        taxAmount = this.validateNullValue(taxAmount);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(BIGZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entry.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4));
            } else {
                entry.setLocalTaxAmount(taxAmount.divide(exchangerate, scale, 4));
            }
        } else if (exchangeRateinfo == null && exchangerate.compareTo(BIGZERO) != 0) {
            entry.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4));
        } else {
            entry.setLocalTaxAmount(taxAmount);
        }
    }

    public void calTax(PurRequestEntryInfo entry) {
        int scale = entry.getCurrency().getPrecision();
        if (entry.getParent().isIsInTax()) {
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal taxAmount = entry.getTaxAmount();
            BigDecimal taxRate = entry.getTaxRate();
            taxAmount = this.validateNullValue(taxAmount);
            taxRate = this.validateNullValue(taxRate);
            BigDecimal tax = SysConstant.BIGZERO;
            BigDecimal oneHundred = new BigDecimal("100.0");
            if (taxAmount != null && taxRate != null) {
                taxRate = taxRate.divide(oneHundred, 10, 4);
                tax = taxAmount.divide(taxRate.add(one), 10, 4).multiply(taxRate);
                if (!entry.getParent().isIsPriceInTax()) {
                    tax = taxAmount.multiply(taxRate);
                }
                tax = tax.setScale(scale, 4);
            }
            entry.setTax(tax);
        } else {
            BigDecimal amount = entry.getAmount();
            amount = this.validateNullValue(amount);
            BigDecimal taxRate = entry.getTaxRate();
            BigDecimal tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)(taxRate = this.validateNullValue(taxRate)), (int)scale);
            if (tax != null) {
                entry.setTax(tax);
            } else {
                entry.setTax(SysConstant.BIGZERO);
            }
        }
    }

    public void calLocalTax(PurRequestEntryInfo entry, ExchangeRateInfo exchangeRateinfo) {
        int scale = entry.getParent().getCompanyOrgUnit().getBaseCurrency().getPrecision();
        BigDecimal tax = entry.getTax();
        BigDecimal exchangerate = entry.getExchangeRate();
        tax = this.validateNullValue(tax);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(BIGZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entry.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4));
            } else {
                entry.setLocalTax(tax.divide(exchangerate, scale, 4));
            }
        } else if (exchangeRateinfo == null && exchangerate.compareTo(BIGZERO) != 0) {
            entry.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4));
        } else {
            entry.setLocalTax(tax);
        }
    }

    public void calAmount(PurRequestEntryInfo entry) {
        int scale = entry.getCurrency().getPrecision();
        if (entry.getParent().isIsInTax()) {
            BigDecimal taxAmount = entry.getTaxAmount();
            BigDecimal tax = entry.getTax();
            taxAmount = this.validateNullValue(taxAmount);
            tax = this.validateNullValue(tax);
            entry.setAmount(SysConstant.BIGZERO);
            if (taxAmount != null && tax != null) {
                BigDecimal actualTaxPrice = taxAmount.subtract(tax);
                actualTaxPrice = actualTaxPrice.setScale(scale, 4);
                entry.setAmount(actualTaxPrice);
            }
        } else {
            BigDecimal price = entry.getPrice();
            BigDecimal discountRate = entry.getDiscountRate();
            BigDecimal qty = entry.getQty();
            BigDecimal one = new BigDecimal("1.0");
            BigDecimal oneHundred = new BigDecimal("100.0");
            price = this.validateNullValue(price);
            discountRate = this.validateNullValue(discountRate);
            qty = this.validateNullValue(qty);
            BigDecimal amount = qty.multiply(price).multiply(one.subtract(discountRate.divide(oneHundred, 10, 4)));
            amount = amount.setScale(scale, 4);
            entry.setAmount(amount);
        }
    }

    public void calLocalAmount(PurRequestEntryInfo entry, ExchangeRateInfo exchangeRateinfo) {
        int scale = entry.getParent().getCompanyOrgUnit().getBaseCurrency().getPrecision();
        BigDecimal amount = entry.getAmount();
        BigDecimal exchangerate = entry.getExchangeRate();
        amount = this.validateNullValue(amount);
        exchangerate = this.validateNullValue(exchangerate);
        if (exchangeRateinfo != null && exchangerate.compareTo(BIGZERO) != 0) {
            if (exchangeRateinfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entry.setLocalAmount(amount.multiply(exchangerate).setScale(scale, 4));
            } else {
                entry.setLocalAmount(amount.divide(exchangerate, scale, 4));
            }
        } else if (exchangeRateinfo == null && exchangerate.compareTo(BIGZERO) != 0) {
            entry.setLocalAmount(amount.multiply(exchangerate).setScale(scale, 4));
        } else {
            entry.setLocalAmount(amount);
        }
    }

    private BigDecimal validateNullValue(BigDecimal value) {
        if (value == null) {
            return BIGZERO;
        }
        return value;
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        if (ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION") == null || Boolean.FALSE.equals(ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION"))) {
            return null;
        }
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }
}

