/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.ma.nbudget.BudgetCtrlCallerProxyInstanceFactory;
import com.kingdee.eas.mm.planning.ReqPlanForSCMFacadeFactory;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.BizActionEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.common.SCMBillParamFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.bizprocess.processorbuilder.SCMBusinessProcessorBuilder4common;
import com.kingdee.eas.scm.sm.pur.IPurRequest;
import com.kingdee.eas.scm.sm.pur.IPurRequestEntry;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequestCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurRequestEntryControllerBean;
import com.kingdee.eas.scm.sm.pur.util.PurBgCtrlUtil;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurRequestEntryControllerBean
extends AbstractPurRequestEntryControllerBean
implements IBatchExecute {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurRequestEntryControllerBean");
    private static final long serialVersionUID = 1L;
    public static final String STR_VALUE = "1";

    @Override
    protected void _closeEntry(Context ctx, IObjectPK pk, String reasonCode) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("baseStatus"));
        selector.add(new SelectorItemInfo("reason"));
        selector.add(new SelectorItemInfo("parent"));
        PurRequestEntryInfo info = PurRequestEntryFactory.getLocalInstance(ctx).getPurRequestEntryInfo(pk, selector);
        info.setReason(reasonCode);
        this.checkBeforeClosed(ctx, (IObjectValue)info);
        this.passClosedEntry(ctx, pk, (IObjectValue)info);
        ArrayList<String> list = new ArrayList<String>();
        list.add(info.getParent().getId().toString());
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("510b6503-0105-1000-e000-0107c0a812fd463ED552", list, BizActionEnum.CLOSE);
        this.handleManualCloseOrUnClose(ctx, pk, false);
    }

    protected void passClosedEntry(Context ctx, IObjectPK pk, IObjectValue vo) throws BOSException, EASBizException {
        PurRequestEntryInfo info = (PurRequestEntryInfo)vo;
        info.setBaseStatus(EntryBaseStatusEnum.CLOSED);
        this.update(ctx, pk, (CoreBaseInfo)info);
        this.closeBillHead(ctx, pk);
        if (PurBgCtrlUtil.isNewPurBudget(ctx).booleanValue()) {
            IPurRequestEntry iPurRequestEntry = PurRequestEntryFactory.getLocalInstance(ctx);
            PurRequestEntryInfo purRequestEntryInfo = iPurRequestEntry.getPurRequestEntryInfo(pk);
            IPurRequest iPurRequest = PurRequestFactory.getLocalInstance(ctx);
            ObjectUuidPK billPK = new ObjectUuidPK(purRequestEntryInfo.getParent().getId());
            PurRequestInfo purRequestInfo = iPurRequest.getPurRequestInfo((IObjectPK)billPK);
            PurBgCtrlUtil.requestBudgetForPurReqestEntry(ctx, purRequestInfo, new String[]{pk.toString()}, null, false);
        }
    }

    private boolean checkAllEntryStatus(Context ctx, IObjectPK entryPk, EntryBaseStatusEnum targeStatus) throws EASBizException, BOSException {
        IPurRequestEntry iPurRequestEntry = PurRequestEntryFactory.getLocalInstance(ctx);
        PurRequestEntryInfo purRequestEntryInfo = iPurRequestEntry.getPurRequestEntryInfo(entryPk);
        IPurRequest iPurRequest = PurRequestFactory.getLocalInstance(ctx);
        ObjectUuidPK orderPK = new ObjectUuidPK(purRequestEntryInfo.getParent().getId());
        PurRequestInfo purOrderInfo = iPurRequest.getPurRequestInfo((IObjectPK)orderPK);
        PurRequestEntryCollection purOrderCollenction = purOrderInfo.getEntries();
        int num = purOrderCollenction.size();
        for (int i = 0; i < num; ++i) {
            if (purOrderCollenction.get(i).getBaseStatus().getValue() == targeStatus.getValue()) continue;
            return false;
        }
        return true;
    }

    private void checkBeforeClosed(Context ctx, IObjectValue vo) throws BOSException, EASBizException {
        PurRequestEntryInfo info = (PurRequestEntryInfo)vo;
        if (info.getBaseStatus() != null) {
            if (info.getBaseStatus().getValue() == 4) {
                return;
            }
            if (info.getBaseStatus().getValue() == 7) {
                throw new PurReqException(PurReqException.CLOSE_IS_CLOSE);
            }
            if (info.getBaseStatus().getValue() == 3) {
                throw new PurReqException(PurReqException.CLOSED_IS_CANCEL);
            }
            if (info.getBaseStatus().getValue() != 4) {
                throw new PurReqException(PurReqException.CLOSED_MUST_AUDIT);
            }
        }
    }

    @Override
    protected void _closeEntry(Context ctx, IObjectPK[] ids) throws BOSException, EASBizException {
        int num = ids.length;
        for (int i = 0; i < num; ++i) {
            this._closeEntry(ctx, ids[i], null);
        }
    }

    @Override
    protected void _closeEntry(Context ctx, IObjectPK[] pks, IObjectValue[] vos) throws BOSException, EASBizException {
        int num = pks.length;
        for (int i = 0; i < num; ++i) {
            this.closeEntryForReason(ctx, pks[i], vos[i]);
        }
    }

    protected void closeEntryForReason(Context ctx, IObjectPK pk, IObjectValue vo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("baseStatus"));
        selector.add(new SelectorItemInfo("reason"));
        selector.add(new SelectorItemInfo("parent"));
        PurRequestEntryInfo info = PurRequestEntryFactory.getLocalInstance(ctx).getPurRequestEntryInfo(pk, selector);
        this.checkBeforeClosed(ctx, (IObjectValue)info);
        this.passClosedEntryForReason(ctx, pk, (IObjectValue)info, vo);
        this.handleManualCloseOrUnClose(ctx, pk, false);
        ArrayList<String> list = new ArrayList<String>();
        list.add(info.getParent().getId().toString());
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("510b6503-0105-1000-e000-0107c0a812fd463ED552", list, BizActionEnum.CLOSE);
    }

    public void batchCloseExcute(Context ctx, BatchActionResults batchResults, String reason) throws BOSException, EASBizException, SQLException {
        PurRequestInfo info = null;
        PurRequestEntryInfo entryInfo = null;
        PurRequestEntryCollection entryColl = null;
        HashSet<String> entryidSet = new HashSet<String>();
        IRowSet rs = this.getRowset(ctx, batchResults);
        Set sucessOrg = this.batchCheckPermission(ctx, "purreq_close", rs);
        HashMap<String, String> error = new HashMap<String, String>();
        HashMap<String, String> sucess = new HashMap<String, String>();
        HashSet<String> sucessParentIDSet = new HashSet<String>();
        ArrayList<String> list = new ArrayList<String>();
        PermissionException permissionException = null;
        Object[] excetionobj = null;
        String notAuditMsg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"STATUS_NOT_AUDIT", (Locale)ctx.getLocale());
        String close = ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"OPERATOR_CLOSE", (Locale)ctx.getLocale());
        rs.beforeFirst();
        long starttime = System.currentTimeMillis();
        while (rs.next()) {
            String orgid = rs.getString("FCompanyOrgUnitID");
            String parentid = rs.getString("orderid");
            String entryid = rs.getString("fid");
            int entrystatus = rs.getInt("fbasestatus");
            String orgname = rs.getString("orgname");
            if (!sucessOrg.contains(orgid)) {
                excetionobj = new Object[]{orgname, close};
                permissionException = new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, excetionobj);
                batchResults.addError(entryid, (Exception)permissionException);
                this.addLogData(error, rs);
                continue;
            }
            if (entrystatus != 4) {
                batchResults.addError(entryid, notAuditMsg);
                this.addLogData(error, rs);
                continue;
            }
            sucessParentIDSet.add(parentid);
            entryidSet.add(entryid);
            if (!list.contains(parentid)) {
                list.add(parentid);
            }
            this.addLogData(sucess, rs);
        }
        long time1 = System.currentTimeMillis();
        logger.error((Object)("@@\u6743\u9650\u6821\u9a8c\uff1a" + (time1 - starttime)));
        if (entryidSet.size() == 0) {
            return;
        }
        String tableName = "T_SM_PurRequestEntry";
        Map map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryidSet);
        if (map.size() > 0) {
            HashSet set = new HashSet();
            for (Map.Entry entry : map.entrySet()) {
                set.add(entry.getValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filter);
            PurRequestCollection coll = PurRequestFactory.getLocalInstance(ctx).getPurRequestCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    info = coll.get(i);
                    entryColl = (PurRequestEntryCollection)((Object)info.getEntries().clone());
                    info.getEntries().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!map.containsKey(entryInfo.getId().toString())) continue;
                        info.getEntries().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.CLOSE);
                }
            }
        }
        starttime = System.currentTimeMillis();
        StringBuffer sql = new StringBuffer();
        String entryids = PurUtil.setToString(entryidSet);
        sql.setLength(0);
        sql.append(" update T_sm_purrequestentry set fIsManualClose = 1, Freason = '").append(reason);
        sql.append("', fbasestatus = ").append(7);
        sql.append(" where fid in ").append(entryids);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        time1 = System.currentTimeMillis();
        logger.error((Object)("@@\u66f4\u65b0\u5206\u5f55\u72b6\u6001\u548c\u539f\u56e0\uff1a" + (time1 - starttime)));
        starttime = System.currentTimeMillis();
        sql.setLength(0);
        String parentids = PurUtil.setToString(sucessParentIDSet);
        sql.append(" update T_sm_purrequest set fbasestatus = ").append(7);
        sql.append(" where fid in ").append(parentids);
        sql.append(" and fid not in (select fparentid from T_sm_purrequestentry where fbasestatus<>7 and fparentid in");
        sql.append(parentids).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        time1 = System.currentTimeMillis();
        logger.error((Object)("@@\u66f4\u65b0\u8868\u5934\u72b6\u6001\uff1a" + (time1 - starttime)));
        starttime = System.currentTimeMillis();
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("510b6503-0105-1000-e000-0107c0a812fd463ED552", list, BizActionEnum.CLOSE);
        time1 = System.currentTimeMillis();
        logger.error((Object)("@@\u5236\u9020\u63a5\u53e3\u65b9\u6cd5\uff1a" + (time1 - starttime)));
        this.setlogs(ctx, error, sucess, "scm_purRequest_close");
        Set entrySet = batchResults.getToDoIdsSet();
        for (Object id : entrySet) {
            ObjectUuidPK pk = new ObjectUuidPK(String.valueOf(id));
            if (!PurBgCtrlUtil.isNewPurBudget(ctx).booleanValue()) continue;
            IPurRequestEntry iPurRequestEntry = PurRequestEntryFactory.getLocalInstance(ctx);
            PurRequestEntryInfo purRequestEntryInfo = iPurRequestEntry.getPurRequestEntryInfo((IObjectPK)pk);
            IPurRequest iPurRequest = PurRequestFactory.getLocalInstance(ctx);
            ObjectUuidPK billPK = new ObjectUuidPK(purRequestEntryInfo.getParent().getId());
            PurRequestInfo purRequestInfo = iPurRequest.getPurRequestInfo((IObjectPK)billPK);
            PurBgCtrlUtil.requestBudgetForPurReqestEntry(ctx, purRequestInfo, new String[]{pk.toString()}, null, false);
        }
    }

    protected void closeEntryForReason(Context ctx, IObjectPK pk, String vo) throws BOSException, EASBizException {
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add(new SelectorItemInfo("id"));
        selector.add(new SelectorItemInfo("baseStatus"));
        selector.add(new SelectorItemInfo("reason"));
        selector.add(new SelectorItemInfo("parent"));
        PurRequestEntryInfo info = PurRequestEntryFactory.getLocalInstance(ctx).getPurRequestEntryInfo(pk, selector);
        this.checkBeforeClosed(ctx, (IObjectValue)info);
        this.passClosedEntryForReason(ctx, pk, (IObjectValue)info, vo);
    }

    protected void passClosedEntryForReason(Context ctx, IObjectPK pk, IObjectValue vo, IObjectValue reason) throws BOSException, EASBizException {
        PurRequestEntryInfo info = (PurRequestEntryInfo)vo;
        info.setBaseStatus(EntryBaseStatusEnum.CLOSED);
        info.setReason(((ReasonCodeInfo)reason).getName());
        super._update(ctx, pk, (IObjectValue)info);
        this.closeBillHead(ctx, pk);
        if (PurBgCtrlUtil.isNewPurBudget(ctx).booleanValue()) {
            IPurRequestEntry iPurRequestEntry = PurRequestEntryFactory.getLocalInstance(ctx);
            PurRequestEntryInfo purRequestEntryInfo = iPurRequestEntry.getPurRequestEntryInfo(pk);
            IPurRequest iPurRequest = PurRequestFactory.getLocalInstance(ctx);
            ObjectUuidPK billPK = new ObjectUuidPK(purRequestEntryInfo.getParent().getId());
            PurRequestInfo purRequestInfo = iPurRequest.getPurRequestInfo((IObjectPK)billPK);
            PurBgCtrlUtil.requestBudgetForPurReqestEntry(ctx, purRequestInfo, new String[]{pk.toString()}, null, false);
        }
    }

    protected void passClosedEntryForReason(Context ctx, IObjectPK pk, IObjectValue vo, String reason) throws BOSException, EASBizException {
        PurRequestEntryInfo info = (PurRequestEntryInfo)vo;
        info.setBaseStatus(EntryBaseStatusEnum.CLOSED);
        info.setReason(reason);
        super._update(ctx, pk, (IObjectValue)info);
        this.closeBillHead(ctx, pk);
    }

    private void closeBillHead(Context ctx, IObjectPK pk) throws EASBizException, BOSException {
        if (this.checkAllEntryStatus(ctx, pk, EntryBaseStatusEnum.CLOSED)) {
            IPurRequestEntry iPurRequestEntry = PurRequestEntryFactory.getLocalInstance(ctx);
            PurRequestEntryInfo purRequestEntryInfo = iPurRequestEntry.getPurRequestEntryInfo(pk);
            IPurRequest iPurRequest = PurRequestFactory.getLocalInstance(ctx);
            ObjectUuidPK orderPK = new ObjectUuidPK(purRequestEntryInfo.getParent().getId());
            PurRequestInfo purRequestInfo = iPurRequest.getPurRequestInfo((IObjectPK)orderPK);
            purRequestInfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
            iPurRequest.update((IObjectPK)new ObjectUuidPK(purRequestInfo.getId()), (CoreBaseInfo)purRequestInfo);
        }
    }

    @Override
    protected void _closeEntry(Context ctx, IObjectPK[] pk, String[] vos) throws BOSException, EASBizException {
        int num = pk.length;
        for (int i = 0; i < num; ++i) {
            this.closeEntryForReason(ctx, pk[i], vos[i]);
        }
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurRequestEntryInfo info = (PurRequestEntryInfo)this.getValue(ctx, pk);
        PurRequestInfo sInfo = PurRequestFactory.getLocalInstance(ctx).getPurRequestInfo((IObjectPK)new ObjectUuidPK(info.getParent().getId()));
        return sInfo.getNumber() + "  " + info.getSeq();
    }

    @Override
    protected void _submitToWf(Context ctx, IObjectValue model) throws BOSException {
    }

    protected void _auditForWf(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)"Update T_SM_PurRequestEntry Set FId = FId Where FparentId In (Select  FParentId From T_SM_PurRequestEntry where Fid =? )", (Object[])new Object[]{pk.toString()});
        DbUtil.execute((Context)ctx, (String)"update T_SM_PurRequestEntry set FBaseStatus = ? where FID = ? ", (Object[])new Object[]{new Integer(4), pk.toString()});
        StringBuffer strSQL = new StringBuffer();
        strSQL.append("Update T_SM_PurRequest set FBaseStatus = ? ,FAuditorId= ?, FAuditTime = getDate() ").append("Where FId In (Select FParentId from T_SM_PurRequestEntry Where FId = ? ) ").append("\t\tAnd FBaseStatus <> ? ").append("\t\tAnd Not Exists (Select FId From T_SM_PurRequestEntry Where FBaseStatus <> ? ").append("\t\t\t\t\t\t\tAnd FParentId In (Select FParentId from T_SM_PurRequestEntry Where FId = ? ))");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{new Integer(4), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), pk.toString(), new Integer(4), new Integer(4), pk.toString()});
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void _auditForWf(Context ctx, IObjectPK pk, IObjectPK parentpk) throws BOSException, EASBizException {
        DbUtil.execute((Context)ctx, (String)"Update T_SM_PurRequestEntry Set FId = FId Where FparentId =? ", (Object[])new Object[]{parentpk.toString()});
        isControlBudget = false;
        selector = PurUtil.getPurRequestSelector();
        iPurRequest = PurRequestFactory.getLocalInstance(ctx);
        purInfo = iPurRequest.getPurRequestInfo(parentpk, selector);
        if (!PurBgCtrlUtil.isNewPurBudget(ctx).booleanValue()) {
            scmParam = SCMBillParamFactory.getLocalInstance((Context)ctx);
            if (purInfo != null && purInfo.getCompanyOrgUnit() != null && purInfo.getBillType() != null && (strControlBudget = scmParam.getParamByBillTypeID("IsControlBudget", 1, purInfo.getCompanyOrgUnit().getId().toString(), purInfo.getBillType().getId().toString())) != null && strControlBudget.trim().length() != 0 && strControlBudget.trim().equalsIgnoreCase("1")) {
                isControlBudget = true;
            }
            if (isControlBudget && !purInfo.isIsMergeBill() && PurchaseTypeEnum.PURCHASE == purInfo.getPurchaseType()) {
                if (!BudgetCtrlCallerProxyInstanceFactory.createInstance((Context)ctx).checkBillInfo(parentpk.toString())) {
                    return;
                }
                if (!BudgetCtrlCallerProxyInstanceFactory.createInstance((Context)ctx).checkBudget((IObjectValue)purInfo)) {
                    return;
                }
            }
        }
        DbUtil.execute((Context)ctx, (String)"update T_SM_PurRequestEntry set FBaseStatus = ? where FID = ? ", (Object[])new Object[]{new Integer(4), pk.toString()});
        if (!PurBgCtrlUtil.isNewPurBudget(ctx).booleanValue()) {
            if (isControlBudget && !purInfo.isIsMergeBill() && PurchaseTypeEnum.PURCHASE == purInfo.getPurchaseType()) {
                sql = new StringBuffer();
                sql.append("Select FId From T_SM_PurRequestEntry Where FBaseStatus <> ? ").append(" And FParentId = ? ");
                params = new Object[]{new Integer(4), parentpk.toString()};
                rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString(), (Object[])params);
                try {
                    if (rs.next()) ** GOTO lbl36
                    BudgetCtrlCallerProxyInstanceFactory.createInstance((Context)ctx).requestBudget(purInfo.getId());
                }
                catch (SQLException e) {
                    throw new BOSException((Throwable)e);
                }
            }
        } else {
            PurBgCtrlUtil.requestBudgetForPurReqestEntry(ctx, purInfo, new String[]{pk.toString()}, null, false);
        }
lbl36:
        // 4 sources

        strSQL = new StringBuffer();
        strSQL.append("Update T_SM_PurRequest set FBaseStatus = ? ,FAuditorId= ?, FAuditTime = getDate() ").append("Where FId=? ").append("\tAnd FBaseStatus <> ? ").append("\tAnd Not Exists (Select FId From T_SM_PurRequestEntry Where FBaseStatus not in (?,?,?) ").append("\tAnd FParentId = ? )");
        DbUtil.execute((Context)ctx, (String)strSQL.toString(), (Object[])new Object[]{new Integer(4), ContextUtil.getCurrentUserInfo((Context)ctx).getId().toString(), parentpk.toString(), new Integer(4), new Integer(7), new Integer(6), new Integer(4), parentpk.toString()});
    }

    @Override
    protected void _unClose(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("seq"));
        sic.add(new SelectorItemInfo("baseStatus"));
        sic.add(new SelectorItemInfo("parent.id"));
        sic.add(new SelectorItemInfo("parent.number"));
        PurRequestEntryInfo entryInfo = this.getPurRequestEntryInfo(ctx, pk, sic);
        if (!entryInfo.getBaseStatus().equals((Object)EntryBaseStatusEnum.CLOSED)) {
            throw new PurReqException(PurReqException.UNCLOSE_IS_CLOSED, new String[]{entryInfo.getParent().getNumber(), String.valueOf(entryInfo.getSeq())});
        }
        entryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
        entryInfo.setReason(null);
        this.update(ctx, pk, (CoreBaseInfo)entryInfo);
        IPurRequest ipurreq = PurRequestFactory.getLocalInstance(ctx);
        PurRequestInfo info = ipurreq.getPurRequestInfo((IObjectPK)new ObjectUuidPK(entryInfo.getParent().getId()));
        if (!info.getBaseStatus().equals((Object)BillBaseStatusEnum.AUDITED) && !info.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED)) {
            info.setBaseStatus(BillBaseStatusEnum.AUDITED);
            ipurreq.update((IObjectPK)new ObjectUuidPK(info.getId()), (CoreBaseInfo)info);
        }
        ArrayList<String> list = new ArrayList<String>();
        list.add(info.getId().toString());
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("510b6503-0105-1000-e000-0107c0a812fd463ED552", list, BizActionEnum.UNCLOSE);
        this.handleManualCloseOrUnClose(ctx, pk, true);
        if (PurBgCtrlUtil.isNewPurBudget(ctx).booleanValue()) {
            IPurRequestEntry iPurRequestEntry = PurRequestEntryFactory.getLocalInstance(ctx);
            PurRequestEntryInfo purRequestEntryInfo = iPurRequestEntry.getPurRequestEntryInfo(pk);
            IPurRequest iPurRequest = PurRequestFactory.getLocalInstance(ctx);
            ObjectUuidPK billPK = new ObjectUuidPK(purRequestEntryInfo.getParent().getId());
            PurRequestInfo purRequestInfo = iPurRequest.getPurRequestInfo((IObjectPK)billPK);
            PurBgCtrlUtil.requestBudgetForPurReqestEntry(ctx, purRequestInfo, new String[]{pk.toString()}, null, false);
        }
    }

    @Override
    protected void _unClose(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int c = pks.length;
        for (int i = 0; i < c; ++i) {
            this._unClose(ctx, pks[i]);
        }
    }

    private void handleManualCloseOrUnClose(Context ctx, IObjectPK pk, boolean isUnClose) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update t_sm_PurRequestEntry set FIsManualClose = ");
        if (isUnClose) {
            sql.append("0");
        } else {
            sql.append(STR_VALUE);
        }
        sql.append(" where fid = ");
        sql.append("'").append(pk.toString()).append("'");
        DbUtil.execute((Context)ctx, (String)sql.substring(0, sql.length()));
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] params = batchResults.getParamEntries();
        BatchExecuteParamsEntry param = params[0];
        String reason = null;
        reason = param.getParamTypes().length < 2 || param.get(1) == null ? "" : (param.getParamTypes()[1].equals(IObjectValue.class) ? ((ReasonCodeInfo)param.get(1)).getName() : param.get(1).toString());
        try {
            if (batchAction == BatchActionEnum.CLOSE) {
                this.batchCloseExcute(ctx, batchResults, reason);
            } else if (batchAction == BatchActionEnum.UNCLOSE) {
                this.batchUnCloseExcute(ctx, batchResults, reason);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private IRowSet getRowset(Context ctx, BatchActionResults batchResults) throws BOSException {
        long starttime = System.currentTimeMillis();
        List entryidSet = batchResults.getToDoIdsList();
        String entryids = PurUtil.listToString(entryidSet);
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.fname_").append(ctx.getLocale()).append(" as orgname ,purrequest.fnumber ,purrequest.fid as orderid, purrequest.FCompanyOrgUnitID,");
        sql.append(" entry.fid,entry.fseq,entry.fbasestatus, entry.fIsManualClose  ");
        sql.append(" from T_sm_purrequest as purrequest ");
        sql.append("  inner join T_SM_purrequestentry as entry on entry.fparentid = purrequest.fid ");
        sql.append(" inner join T_ORG_Company as org on org.fid = purrequest.FCompanyOrgUnitID");
        sql.append("  where entry.fid in (").append(entryids);
        sql.append(") order by entry.fseq ");
        entryidSet.clear();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        long time1 = System.currentTimeMillis();
        logger.error((Object)("@@\u83b7\u53d6\u6570\u636e\u96c6\uff1a" + (time1 - starttime)));
        return rs;
    }

    public Set batchCheckPermission(Context ctx, String permission, IRowSet rs) throws BOSException, EASBizException, SQLException {
        HashSet<String> allOrgStringSet = new HashSet<String>();
        while (rs.next()) {
            allOrgStringSet.add(rs.getString("FCompanyOrgUnitID"));
        }
        IObjectPK[] adllOrgs = new IObjectPK[allOrgStringSet.size()];
        Object[] objs = allOrgStringSet.toArray();
        for (int i = 0; i < allOrgStringSet.size(); ++i) {
            adllOrgs[i] = new ObjectUuidPK(objs[i].toString());
        }
        IObjectPK userPK = ctx.getCaller();
        IPermission iPer = PermissionFactory.getLocalInstance((Context)ctx);
        Set sucessOrg = iPer.checkBatchPermission(userPK, adllOrgs, permission);
        return sucessOrg;
    }

    private void addLogData(Map<String, String> map, IRowSet rs) throws SQLException {
        String parentid = rs.getString("orderid");
        String seq = rs.getString("fseq");
        String number = rs.getString("fnumber");
        if (map.containsKey(parentid)) {
            map.put(parentid, map.get(parentid) + " " + seq);
        } else {
            map.put(parentid, number + " " + seq);
        }
    }

    private void setlogs(Context ctx, Map<String, String> error, Map<String, String> sucess, String logItem) {
        Iterator<String> iterror = error.keySet().iterator();
        while (iterror.hasNext()) {
            String key = iterror.next().toString();
            LogUtil.beginLog((Context)ctx, (String)STR_VALUE, (BOSObjectType)this.getBOSType(), null, (String)error.get(key), (String)logItem);
        }
        Iterator<String> itsucess = sucess.keySet().iterator();
        while (itsucess.hasNext()) {
            String key = itsucess.next().toString();
            IObjectPK pklog = LogUtil.beginLog((Context)ctx, (String)STR_VALUE, (BOSObjectType)this.getBOSType(), null, (String)sucess.get(key), (String)logItem);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
        }
    }

    public void batchUnCloseExcute(Context ctx, BatchActionResults batchResults, String reason) throws BOSException, EASBizException, SQLException {
        PurRequestInfo info = null;
        PurRequestEntryInfo entryInfo = null;
        PurRequestEntryCollection entryColl = null;
        HashSet<String> entryidSet = new HashSet<String>();
        IRowSet rs = this.getRowset(ctx, batchResults);
        HashSet<String> sucessParentIDSet = new HashSet<String>();
        HashMap<String, String> error = new HashMap<String, String>();
        HashMap<String, String> sucess = new HashMap<String, String>();
        ArrayList<String> list = new ArrayList<String>();
        Set sucessOrg = this.batchCheckPermission(ctx, "purreq_unclose", rs);
        rs.beforeFirst();
        PermissionException permissionException = null;
        Object[] excetionobj = null;
        String notcloseMsg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"STATUS_NOT_CLOSE", (Locale)ctx.getLocale());
        String unclose = ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"OPERATOR_UNCLOSE", (Locale)ctx.getLocale());
        long starttime = System.currentTimeMillis();
        while (rs.next()) {
            String orgid = rs.getString("FCompanyOrgUnitID");
            String parentid = rs.getString("orderid");
            String entryid = rs.getString("fid");
            String orgname = rs.getString("orgname");
            int entrystatus = rs.getInt("fbasestatus");
            if (!sucessOrg.contains(orgid)) {
                excetionobj = new Object[]{orgname, unclose};
                permissionException = new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, excetionobj);
                batchResults.addError(entryid, (Exception)permissionException);
                this.addLogData(error, rs);
                continue;
            }
            if (entrystatus != 7) {
                batchResults.addError(entryid, notcloseMsg);
                this.addLogData(error, rs);
                continue;
            }
            sucessParentIDSet.add(parentid);
            entryidSet.add(entryid);
            if (!list.contains(parentid)) {
                list.add(parentid);
            }
            this.addLogData(sucess, rs);
        }
        long time1 = System.currentTimeMillis();
        logger.error((Object)("@@\u6743\u9650\u6821\u9a8c\uff1a" + (time1 - starttime)));
        if (entryidSet.size() == 0) {
            return;
        }
        String tableName = "T_SM_PurRequestEntry";
        Map map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryidSet);
        if (map.size() > 0) {
            HashSet set = new HashSet();
            for (Map.Entry entry : map.entrySet()) {
                set.add(entry.getValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filter);
            PurRequestCollection coll = PurRequestFactory.getLocalInstance(ctx).getPurRequestCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    info = coll.get(i);
                    entryColl = (PurRequestEntryCollection)((Object)info.getEntries().clone());
                    info.getEntries().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!map.containsKey(entryInfo.getId().toString())) continue;
                        info.getEntries().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.UNCLOSE);
                }
            }
        }
        starttime = System.currentTimeMillis();
        StringBuffer sql = new StringBuffer();
        String entryids = PurUtil.setToString(entryidSet);
        sql.setLength(0);
        sql.append(" update T_sm_purrequestentry set fIsManualClose = 0, Freason = '").append(reason);
        sql.append("',fbasestatus = ").append(4);
        sql.append(" where fid in ").append(entryids);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        time1 = System.currentTimeMillis();
        logger.error((Object)("@@\u66f4\u65b0\u5206\u5f55\u72b6\u6001\u548c\u539f\u56e0\uff1a" + (time1 - starttime)));
        starttime = System.currentTimeMillis();
        sql.setLength(0);
        String parentids = PurUtil.setToString(sucessParentIDSet);
        sql.append(" update T_sm_purrequest set fbasestatus = ").append(4);
        sql.append(" where fid in ").append(parentids);
        sql.append(" and fid not in (select fparentid from T_sm_purrequestentry where fbasestatus=");
        sql.append(-2).append(" and fparentid in");
        sql.append(parentids).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        time1 = System.currentTimeMillis();
        logger.error((Object)("@@\u66f4\u65b0\u8868\u5934\u72b6\u6001\uff1a" + (time1 - starttime)));
        starttime = System.currentTimeMillis();
        ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("510b6503-0105-1000-e000-0107c0a812fd463ED552", list, BizActionEnum.CLOSE);
        time1 = System.currentTimeMillis();
        logger.error((Object)("@@\u5236\u9020\u63a5\u53e3\u65b9\u6cd5\uff1a" + (time1 - starttime)));
        this.setlogs(ctx, error, sucess, "scm_purRequest_unclose");
        Set entrySet = batchResults.getToDoIdsSet();
        for (Object id : entrySet) {
            ObjectUuidPK pk = new ObjectUuidPK(String.valueOf(id));
            if (!PurBgCtrlUtil.isNewPurBudget(ctx).booleanValue()) continue;
            IPurRequestEntry iPurRequestEntry = PurRequestEntryFactory.getLocalInstance(ctx);
            PurRequestEntryInfo purRequestEntryInfo = iPurRequestEntry.getPurRequestEntryInfo((IObjectPK)pk);
            IPurRequest iPurRequest = PurRequestFactory.getLocalInstance(ctx);
            ObjectUuidPK billPK = new ObjectUuidPK(purRequestEntryInfo.getParent().getId());
            PurRequestInfo purRequestInfo = iPurRequest.getPurRequestInfo((IObjectPK)billPK);
            PurBgCtrlUtil.requestBudgetForPurReqestEntry(ctx, purRequestInfo, new String[]{pk.toString()}, null, false);
        }
    }

    public BatchActionResults batchCloseEntry(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        long starttime = System.currentTimeMillis();
        BatchActionResults results = this.batchExecute(ctx, entries, BatchActionEnum.CLOSE);
        long time1 = System.currentTimeMillis();
        logger.error((Object)("@@\u6279\u91cf\u5173\u95ed\u5168\u90e8\u540e\u53f0\u65b9\u6cd5\uff1a" + (time1 - starttime)));
        return results;
    }

    public BatchActionResults batchUnClose(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        long starttime = System.currentTimeMillis();
        BatchActionResults results = this.batchExecute(ctx, entries, BatchActionEnum.UNCLOSE);
        long time1 = System.currentTimeMillis();
        logger.error((Object)("@@\u6279\u91cf\u53cd\u5173\u95ed\u5168\u90e8\u540e\u53f0\u65b9\u6cd5\uff1a" + (time1 - starttime)));
        return results;
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessProcessor processor = this.buildProcessor(ctx, batchActionEnum);
        BatchActionResults batchResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])entries);
        return processor.execute(batchResults);
    }

    private IBusinessProcessor buildProcessor(Context ctx, BatchActionEnum batchActionEnum) throws BOSException, EASBizException {
        IBusinessProcessor processor;
        SCMBusinessProcessorBuilder4common builder = new SCMBusinessProcessorBuilder4common(batchActionEnum, this.getBOSType(), null);
        if (this.getXmlFileName(batchActionEnum) != null) {
            builder.pushXmlFile(this.getBOSType(), this.getXmlFileName(batchActionEnum));
        }
        if ((processor = builder.buildProcessor(ctx)) != null && this instanceof IBatchExecute) {
            processor.setBatchExecutor((IBatchExecute)this);
        }
        return processor;
    }

    @Override
    protected Map _closeEntryForWeb(Context ctx, Set id, String reason) throws BOSException, EASBizException {
        PurRequestInfo info = null;
        PurRequestEntryInfo entryInfo = null;
        PurRequestEntryCollection entryColl = null;
        HashSet<String> entryidSet = new HashSet<String>();
        LinkedHashMap<String, String> errorMap = new LinkedHashMap<String, String>();
        IRowSet rs = this.getRowset(ctx, id);
        try {
            Set sucessOrg = this.batchCheckPermission(ctx, "purreq_close", rs);
            HashMap<String, String> error = new HashMap<String, String>();
            HashMap<String, String> sucess = new HashMap<String, String>();
            HashSet<String> sucessParentIDSet = new HashSet<String>();
            ArrayList<String> list = new ArrayList<String>();
            PermissionException permissionException = null;
            Object[] excetionobj = null;
            String notAuditMsg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"STATUS_NOT_AUDIT", (Locale)ctx.getLocale());
            String close = ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"OPERATOR_CLOSE", (Locale)ctx.getLocale());
            String notAuditMsgEntry = null;
            rs.beforeFirst();
            long starttime = System.currentTimeMillis();
            while (rs.next()) {
                String orgid = rs.getString("FCompanyOrgUnitID");
                String parentid = rs.getString("orderid");
                String entryid = rs.getString("fid");
                String seq = rs.getString("fseq");
                int entrystatus = rs.getInt("fbasestatus");
                String orgname = rs.getString("orgname");
                String string = rs.getString("fnumber");
                if (!sucessOrg.contains(orgid)) {
                    excetionobj = new Object[]{orgname, close};
                    permissionException = new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, excetionobj);
                    if (errorMap.size() == 0) {
                        errorMap.put(entryid, string + permissionException.getMessage());
                    }
                    this.addLogData(error, rs);
                    continue;
                }
                if (entrystatus != 4) {
                    notAuditMsgEntry = ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"ENTRY_NOT_CLOSE", (Locale)ctx.getLocale(), (Object[])new Object[]{seq, notAuditMsg});
                    errorMap.put(entryid, string + notAuditMsgEntry);
                    this.addLogData(error, rs);
                    continue;
                }
                sucessParentIDSet.add(parentid);
                entryidSet.add(entryid);
                if (!list.contains(parentid)) {
                    list.add(parentid);
                }
                this.addLogData(sucess, rs);
            }
            long time1 = System.currentTimeMillis();
            logger.error((Object)("@@\u6743\u9650\u6821\u9a8c\uff1a" + (time1 - starttime)));
            if (entryidSet.size() == 0) {
                return errorMap;
            }
            String tableName = "T_SM_PurRequestEntry";
            Map map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryidSet);
            if (map.size() > 0) {
                HashSet set = new HashSet();
                for (Map.Entry entry : map.entrySet()) {
                    set.add(entry.getValue());
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                view.setFilter(filterInfo);
                PurRequestCollection coll = PurRequestFactory.getLocalInstance(ctx).getPurRequestCollection(view);
                if (coll != null && coll.size() > 0) {
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        info = coll.get(i);
                        entryColl = (PurRequestEntryCollection)((Object)info.getEntries().clone());
                        info.getEntries().clear();
                        int n = entryColl.size();
                        for (int j = 0; j < n; ++j) {
                            entryInfo = entryColl.get(j);
                            if (!map.containsKey(entryInfo.getId().toString())) continue;
                            info.getEntries().add(entryInfo);
                        }
                        SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.CLOSE);
                    }
                }
            }
            starttime = System.currentTimeMillis();
            StringBuffer sql = new StringBuffer();
            String entryids = PurUtil.setToString(entryidSet);
            sql.setLength(0);
            sql.append(" update T_sm_purrequestentry set fIsManualClose = 1, Freason = '").append(reason);
            sql.append("', fbasestatus = ").append(7);
            sql.append(" where fid in ").append(entryids);
            DbUtil.execute((Context)ctx, (String)sql.toString());
            time1 = System.currentTimeMillis();
            logger.error((Object)("@@\u66f4\u65b0\u5206\u5f55\u72b6\u6001\u548c\u539f\u56e0\uff1a" + (time1 - starttime)));
            starttime = System.currentTimeMillis();
            sql.setLength(0);
            String string = PurUtil.setToString(sucessParentIDSet);
            sql.append(" update T_sm_purrequest set fbasestatus = ").append(7);
            sql.append(" where fid in ").append(string);
            sql.append(" and fid not in (select fparentid from T_sm_purrequestentry where fbasestatus<>7 and fparentid in");
            sql.append(string).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            time1 = System.currentTimeMillis();
            logger.error((Object)("@@\u66f4\u65b0\u8868\u5934\u72b6\u6001\uff1a" + (time1 - starttime)));
            starttime = System.currentTimeMillis();
            ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("510b6503-0105-1000-e000-0107c0a812fd463ED552", list, BizActionEnum.CLOSE);
            time1 = System.currentTimeMillis();
            logger.error((Object)("@@\u5236\u9020\u63a5\u53e3\u65b9\u6cd5\uff1a" + (time1 - starttime)));
            this.setlogs(ctx, error, sucess, "scm_purRequest_close");
            if (PurBgCtrlUtil.isNewPurBudget(ctx).booleanValue()) {
                PurBgCtrlUtil.requestBudgetForPurReqest(ctx, sucessParentIDSet, null, false);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return errorMap;
    }

    @Override
    protected Map _unCloseForWeb(Context ctx, Set id) throws BOSException, EASBizException {
        PurRequestInfo info = null;
        PurRequestEntryInfo entryInfo = null;
        PurRequestEntryCollection entryColl = null;
        HashSet<String> entryidSet = new HashSet<String>();
        LinkedHashMap<String, String> errorMap = new LinkedHashMap<String, String>();
        IRowSet rs = this.getRowset(ctx, id);
        HashSet<String> sucessParentIDSet = new HashSet<String>();
        HashMap<String, String> error = new HashMap<String, String>();
        HashMap<String, String> sucess = new HashMap<String, String>();
        ArrayList<String> list = new ArrayList<String>();
        try {
            Set sucessOrg = this.batchCheckPermission(ctx, "purreq_unclose", rs);
            rs.beforeFirst();
            PermissionException permissionException = null;
            Object[] excetionobj = null;
            String notcloseMsg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"STATUS_NOT_CLOSE", (Locale)ctx.getLocale());
            String unclose = ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"OPERATOR_UNCLOSE", (Locale)ctx.getLocale());
            String notcloseMsgentry = null;
            long starttime = System.currentTimeMillis();
            while (rs.next()) {
                String orgid = rs.getString("FCompanyOrgUnitID");
                String parentid = rs.getString("orderid");
                String entryid = rs.getString("fid");
                String orgname = rs.getString("orgname");
                String seq = rs.getString("fseq");
                String number = rs.getString("fnumber");
                int n = rs.getInt("fbasestatus");
                if (!sucessOrg.contains(orgid)) {
                    excetionobj = new Object[]{orgname, unclose};
                    permissionException = new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, excetionobj);
                    if (errorMap.size() == 0) {
                        errorMap.put(entryid, (String)number + permissionException.getMessage());
                    }
                    this.addLogData(error, rs);
                    continue;
                }
                if (n != 7) {
                    notcloseMsgentry = ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"ENTRY_NOT_CLOSE", (Locale)ctx.getLocale(), (Object[])new Object[]{seq, notcloseMsg});
                    errorMap.put(entryid, (String)number + notcloseMsgentry);
                    this.addLogData(error, rs);
                    continue;
                }
                sucessParentIDSet.add(parentid);
                entryidSet.add(entryid);
                if (!list.contains(parentid)) {
                    list.add(parentid);
                }
                this.addLogData(sucess, rs);
            }
            long time1 = System.currentTimeMillis();
            logger.error((Object)("@@\u6743\u9650\u6821\u9a8c\uff1a" + (time1 - starttime)));
            if (entryidSet.size() == 0) {
                return errorMap;
            }
            String tableName = "T_SM_PurRequestEntry";
            Map map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryidSet);
            if (map.size() > 0) {
                HashSet set = new HashSet();
                for (Map.Entry entry : map.entrySet()) {
                    set.add(entry.getValue());
                }
                EntityViewInfo view = new EntityViewInfo();
                FilterInfo filterInfo = new FilterInfo();
                filterInfo.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
                view.setFilter(filterInfo);
                PurRequestCollection coll = PurRequestFactory.getLocalInstance(ctx).getPurRequestCollection(view);
                if (coll != null && coll.size() > 0) {
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        info = coll.get(i);
                        entryColl = (PurRequestEntryCollection)((Object)info.getEntries().clone());
                        info.getEntries().clear();
                        int n = entryColl.size();
                        for (int j = 0; j < n; ++j) {
                            entryInfo = entryColl.get(j);
                            if (!map.containsKey(entryInfo.getId().toString())) continue;
                            info.getEntries().add(entryInfo);
                        }
                        SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.UNCLOSE);
                    }
                }
            }
            starttime = System.currentTimeMillis();
            StringBuffer sql = new StringBuffer();
            String entryids = PurUtil.setToString(entryidSet);
            sql.setLength(0);
            sql.append(" update T_sm_purrequestentry set fIsManualClose = 0, Freason = '").append("");
            sql.append("',fbasestatus = ").append(4);
            sql.append(" where fid in ").append(entryids);
            DbUtil.execute((Context)ctx, (String)sql.toString());
            time1 = System.currentTimeMillis();
            logger.error((Object)("@@\u66f4\u65b0\u5206\u5f55\u72b6\u6001\u548c\u539f\u56e0\uff1a" + (time1 - starttime)));
            starttime = System.currentTimeMillis();
            sql.setLength(0);
            String string = PurUtil.setToString(sucessParentIDSet);
            sql.append(" update T_sm_purrequest set fbasestatus = ").append(4);
            sql.append(" where fid in ").append(string);
            sql.append(" and fid not in (select fparentid from T_sm_purrequestentry where fbasestatus=");
            sql.append(-2).append(" and fparentid in");
            sql.append(string).append(")");
            DbUtil.execute((Context)ctx, (String)sql.toString());
            time1 = System.currentTimeMillis();
            logger.error((Object)("@@\u66f4\u65b0\u8868\u5934\u72b6\u6001\uff1a" + (time1 - starttime)));
            starttime = System.currentTimeMillis();
            ReqPlanForSCMFacadeFactory.getLocalInstance((Context)ctx).counteractFromInvBill("510b6503-0105-1000-e000-0107c0a812fd463ED552", list, BizActionEnum.CLOSE);
            time1 = System.currentTimeMillis();
            logger.error((Object)("@@\u5236\u9020\u63a5\u53e3\u65b9\u6cd5\uff1a" + (time1 - starttime)));
            this.setlogs(ctx, error, sucess, "scm_purRequest_unclose");
            if (PurBgCtrlUtil.isNewPurBudget(ctx).booleanValue()) {
                PurBgCtrlUtil.requestBudgetForPurReqest(ctx, sucessParentIDSet, null, false);
            }
        }
        catch (SQLException e) {
            throw new BOSException(e.getMessage());
        }
        return errorMap;
    }

    private IRowSet getRowset(Context ctx, Set set) throws BOSException {
        long starttime = System.currentTimeMillis();
        String entryids = PurUtil.setToString(set);
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.fname_").append(ctx.getLocale()).append(" as orgname ,purrequest.fnumber ,purrequest.fid as orderid, purrequest.FCompanyOrgUnitID,");
        sql.append(" entry.fid,entry.fseq,entry.fbasestatus, entry.fIsManualClose  ");
        sql.append(" from T_sm_purrequest as purrequest ");
        sql.append("  inner join T_SM_purrequestentry as entry on entry.fparentid = purrequest.fid ");
        sql.append(" inner join T_ORG_Company as org on org.fid = purrequest.FCompanyOrgUnitID");
        sql.append("  where entry.fid in ").append(entryids);
        sql.append(" order by entry.fseq ");
        set.clear();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        long time1 = System.currentTimeMillis();
        logger.error((Object)("@@\u83b7\u53d6\u6570\u636e\u96c6\uff1a" + (time1 - starttime)));
        return rs;
    }
}

