/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.base.log.LogUtil;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionException;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.dynbusiness.app.processor.IBusinessProcessor;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.bizprocess.processorbuilder.SCMBusinessProcessorBuilder4common;
import com.kingdee.eas.scm.sm.pur.PurRequirementCollection;
import com.kingdee.eas.scm.sm.pur.PurRequirementEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequirementEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequirementFactory;
import com.kingdee.eas.scm.sm.pur.PurRequirementInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurRequirementEntryControllerBean;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurRequirementEntryControllerBean
extends AbstractPurRequirementEntryControllerBean
implements IBatchExecute {
    private static final long serialVersionUID = 95259378045343136L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurRequirementEntryControllerBean");

    public BatchActionResults batchCloseEntryWithReason(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        long starttime = System.currentTimeMillis();
        BatchActionResults results = this.batchExecute(ctx, entries, BatchActionEnum.CLOSE);
        long time1 = System.currentTimeMillis();
        logger.error((Object)("@@\u9700\u6c42\u7533\u8bf7\u5355\u6279\u91cf\u5173\u95ed\u540e\u53f0\u65b9\u6cd5\u8017\u65f6\uff1a" + (time1 - starttime)));
        return results;
    }

    public BatchActionResults batchUnCloseEntry(Context ctx, BatchExecuteParamsEntry[] entries) throws EASBizException, BOSException {
        long starttime = System.currentTimeMillis();
        BatchActionResults results = this.batchExecute(ctx, entries, BatchActionEnum.UNCLOSE);
        long time1 = System.currentTimeMillis();
        logger.error((Object)("@@\u9700\u6c42\u7533\u8bf7\u5355\u6279\u91cf\u53cd\u5173\u95ed\u540e\u53f0\u65b9\u6cd5\u8017\u65f6\uff1a" + (time1 - starttime)));
        return results;
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessProcessor processor = this.buildProcessor(ctx, batchActionEnum);
        BatchActionResults batchResults = BatchActionResults.populateActionResults((BatchExecuteParamsEntry[])entries);
        return processor.execute(batchResults);
    }

    private IBusinessProcessor buildProcessor(Context ctx, BatchActionEnum batchActionEnum) throws BOSException, EASBizException {
        IBusinessProcessor processor;
        SCMBusinessProcessorBuilder4common builder = new SCMBusinessProcessorBuilder4common(batchActionEnum, this.getBOSType(), null);
        if (this.getXmlFileName(batchActionEnum) != null) {
            builder.pushXmlFile(this.getBOSType(), this.getXmlFileName(batchActionEnum));
        }
        if ((processor = builder.buildProcessor(ctx)) != null && this instanceof IBatchExecute) {
            processor.setBatchExecutor((IBatchExecute)this);
        }
        return processor;
    }

    protected String getXmlFileName(BatchActionEnum batchActionEnum) {
        return null;
    }

    public void batchExecute(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] params = batchResults.getParamEntries();
        BatchExecuteParamsEntry param = params[0];
        String reason = null;
        reason = param.getParamTypes().length < 2 || param.get(1) == null ? "" : (param.getParamTypes()[1].equals(IObjectValue.class) ? ((ReasonCodeInfo)param.get(1)).getName() : param.get(1).toString());
        try {
            if (batchAction == BatchActionEnum.CLOSE) {
                this.batchHandleClose(ctx, batchResults, reason);
            } else if (batchAction == BatchActionEnum.UNCLOSE) {
                this.batchHandleUnClose(ctx, batchResults);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    public void batchCheck(Context ctx, BatchActionEnum batchAction, BatchActionResults batchResults) throws BOSException, EASBizException {
    }

    public void batchHandleClose(Context ctx, BatchActionResults batchResults, String reason) throws BOSException, EASBizException, SQLException {
        PurRequirementInfo info = null;
        PurRequirementEntryInfo entryInfo = null;
        PurRequirementEntryCollection entryColl = null;
        HashSet<String> entryIdSet = new HashSet<String>();
        HashSet<String> sucessParentIDSet = new HashSet<String>();
        HashMap<String, String> error = new HashMap<String, String>();
        HashMap<String, String> sucess = new HashMap<String, String>();
        PermissionException permissionException = null;
        Object[] excetionobj = null;
        String notAuditMsg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"STATUS_NOT_AUDIT", (Locale)ctx.getLocale());
        String close = ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"OPERATOR_CLOSE", (Locale)ctx.getLocale());
        IRowSet rs = this.getRowset(ctx, batchResults);
        Set sucessOrg = this.batchCheckPermission(ctx, "prm_close", rs);
        rs.beforeFirst();
        while (rs.next()) {
            String orgid = rs.getString("companyId");
            String parentid = rs.getString("billId");
            String entryid = rs.getString("entryId");
            int entrystatus = rs.getInt("basestatus");
            String orgname = rs.getString("orgname");
            if (!sucessOrg.contains(orgid)) {
                excetionobj = new Object[]{orgname, close};
                permissionException = new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, excetionobj);
                batchResults.addError(entryid, (Exception)permissionException);
                this.addLogData(error, rs);
                continue;
            }
            if (entrystatus != 4) {
                batchResults.addError(entryid, notAuditMsg);
                this.addLogData(error, rs);
                continue;
            }
            sucessParentIDSet.add(parentid);
            entryIdSet.add(entryid);
            this.addLogData(sucess, rs);
        }
        String tableName = "T_SM_PurRequirementEntry";
        if (entryIdSet.size() == 0) {
            return;
        }
        Map map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryIdSet);
        if (map.size() > 0) {
            HashSet set = new HashSet();
            for (Map.Entry entry : map.entrySet()) {
                set.add(entry.getValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filter);
            PurRequirementCollection coll = PurRequirementFactory.getLocalInstance(ctx).getPurRequirementCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    info = coll.get(i);
                    entryColl = (PurRequirementEntryCollection)((Object)info.getEntries().clone());
                    info.getEntries().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!map.containsKey(entryInfo.getId().toString())) continue;
                        info.getEntries().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.CLOSE);
                }
            }
        }
        StringBuffer sql = new StringBuffer();
        String entryids = PurUtil.setToString(entryIdSet);
        sql.setLength(0);
        sql.append(" update T_SM_PurRequirementEntry set Freason = '").append(reason);
        sql.append("', fbasestatus = ").append(7);
        sql.append(" where fid in ").append(entryids);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        String parentids = PurUtil.setToString(sucessParentIDSet);
        sql.append(" update T_SM_PurRequirement set fbasestatus = ").append(7);
        sql.append(" where fid in ").append(parentids);
        sql.append(" and fid not in (select fparentid from T_SM_PurRequirementEntry where fbasestatus<>7 and fparentid in");
        sql.append(parentids).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.setlogs(ctx, error, sucess, "scm_purRequirement_close");
    }

    public void batchHandleUnClose(Context ctx, BatchActionResults batchResults) throws BOSException, EASBizException, SQLException {
        PurRequirementInfo info = null;
        PurRequirementEntryInfo entryInfo = null;
        PurRequirementEntryCollection entryColl = null;
        HashSet<String> entryIdSet = new HashSet<String>();
        HashSet<String> sucessParentIDSet = new HashSet<String>();
        HashMap<String, String> error = new HashMap<String, String>();
        HashMap<String, String> sucess = new HashMap<String, String>();
        PermissionException permissionException = null;
        Object[] excetionobj = null;
        String notAuditMsg = ResourceBase.getString((String)"com.kingdee.eas.scm.common.ActionResource", (String)"STATUS_NOT_CLOSE", (Locale)ctx.getLocale());
        String close = ResourceBase.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"OPERATOR_UNCLOSE", (Locale)ctx.getLocale());
        IRowSet rs = this.getRowset(ctx, batchResults);
        Set sucessOrg = this.batchCheckPermission(ctx, "prm_unclose", rs);
        rs.beforeFirst();
        while (rs.next()) {
            String orgid = rs.getString("companyId");
            String parentid = rs.getString("billId");
            String entryid = rs.getString("entryId");
            int entrystatus = rs.getInt("basestatus");
            String orgname = rs.getString("orgname");
            if (!sucessOrg.contains(orgid)) {
                excetionobj = new Object[]{orgname, close};
                permissionException = new PermissionException(PermissionException.HAS_NOT_ORG_FUNCTION_PERMISSION, excetionobj);
                batchResults.addError(entryid, (Exception)permissionException);
                this.addLogData(error, rs);
                continue;
            }
            if (entrystatus != 7) {
                batchResults.addError(entryid, notAuditMsg);
                this.addLogData(error, rs);
                continue;
            }
            sucessParentIDSet.add(parentid);
            entryIdSet.add(entryid);
            this.addLogData(sucess, rs);
        }
        String tableName = "T_SM_PurRequirementEntry";
        if (entryIdSet.size() == 0) {
            return;
        }
        Map map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, entryIdSet);
        if (map.size() > 0) {
            HashSet set = new HashSet();
            for (Map.Entry entry : map.entrySet()) {
                set.add(entry.getValue());
            }
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
            view.setFilter(filter);
            PurRequirementCollection coll = PurRequirementFactory.getLocalInstance(ctx).getPurRequirementCollection(view);
            if (coll != null && coll.size() > 0) {
                int size = coll.size();
                for (int i = 0; i < size; ++i) {
                    info = coll.get(i);
                    entryColl = (PurRequirementEntryCollection)((Object)info.getEntries().clone());
                    info.getEntries().clear();
                    int n = entryColl.size();
                    for (int j = 0; j < n; ++j) {
                        entryInfo = entryColl.get(j);
                        if (!map.containsKey(entryInfo.getId().toString())) continue;
                        info.getEntries().add(entryInfo);
                    }
                    SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.UNCLOSE);
                }
            }
        }
        StringBuffer sql = new StringBuffer();
        String entryids = PurUtil.setToString(entryIdSet);
        sql.setLength(0);
        sql.append(" update T_SM_PurRequirementEntry set Freason = null,fbasestatus = ").append(4);
        sql.append(" where fid in ").append(entryids);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        String parentids = PurUtil.setToString(sucessParentIDSet);
        sql.append(" update T_SM_PurRequirement set fbasestatus = ").append(4);
        sql.append(" where fid in ").append(parentids);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.setlogs(ctx, error, sucess, "scm_purRequirement_unclose");
    }

    private BatchExecuteParamsEntry[] buildBatchExecuteParamsEntry(IObjectPK[] pks, Object closeReason, BatchActionEnum action) {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[pks.length];
        Class[] parameterTypes = null;
        Object[] arrParamValue = null;
        String reason = null;
        if (BatchActionEnum.CLOSE.equals((Object)action)) {
            parameterTypes = new Class[]{IObjectPK.class, String.class};
            reason = closeReason != null && closeReason instanceof String ? closeReason.toString() : (closeReason != null && closeReason instanceof IObjectValue ? ((ReasonCodeInfo)closeReason).getName() : "");
        } else if (BatchActionEnum.UNCLOSE.equals((Object)action)) {
            parameterTypes = new Class[]{IObjectPK.class};
        }
        int size = pks.length;
        for (int i = 0; i < size; ++i) {
            if (BatchActionEnum.CLOSE.equals((Object)action)) {
                arrParamValue = new Object[]{pks[i], reason};
            } else if (BatchActionEnum.UNCLOSE.equals((Object)action)) {
                arrParamValue = new Object[]{pks[i]};
            }
            entries[i] = new BatchExecuteParamsEntry(parameterTypes, arrParamValue);
        }
        return entries;
    }

    @Override
    protected void _closeEntry(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = this.buildBatchExecuteParamsEntry(pks, null, BatchActionEnum.CLOSE);
        this.batchExecute(ctx, entries, BatchActionEnum.CLOSE);
    }

    @Override
    protected void _closeEntryWithReason(Context ctx, IObjectPK pk, IObjectValue reason) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = this.buildBatchExecuteParamsEntry(new IObjectPK[]{pk}, reason, BatchActionEnum.CLOSE);
        this.batchExecute(ctx, entries, BatchActionEnum.CLOSE);
    }

    @Override
    protected void _closeEntryWithReason(Context ctx, IObjectPK pk, String reason) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = this.buildBatchExecuteParamsEntry(new IObjectPK[]{pk}, reason, BatchActionEnum.CLOSE);
        this.batchExecute(ctx, entries, BatchActionEnum.CLOSE);
    }

    @Override
    protected void _closeEntryWithReason(Context ctx, IObjectPK[] pks, IObjectValue[] reasons) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = this.buildBatchExecuteParamsEntry(pks, reasons[0], BatchActionEnum.CLOSE);
        this.batchExecute(ctx, entries, BatchActionEnum.CLOSE);
    }

    @Override
    protected void _closeEntryWithReason(Context ctx, IObjectPK[] pks, String[] reasons) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = this.buildBatchExecuteParamsEntry(pks, reasons[0], BatchActionEnum.CLOSE);
        this.batchExecute(ctx, entries, BatchActionEnum.CLOSE);
    }

    @Override
    protected void _unCloseEntry(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = this.buildBatchExecuteParamsEntry(new IObjectPK[]{pk}, null, BatchActionEnum.UNCLOSE);
        this.batchExecute(ctx, entries, BatchActionEnum.UNCLOSE);
    }

    @Override
    protected void _unCloseEntry(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = this.buildBatchExecuteParamsEntry(pks, null, BatchActionEnum.UNCLOSE);
        this.batchExecute(ctx, entries, BatchActionEnum.UNCLOSE);
    }

    private IRowSet getRowset(Context ctx, BatchActionResults batchResults) throws BOSException {
        List entryidSet = batchResults.getToDoIdsList();
        String entryids = PurUtil.listToString(entryidSet);
        StringBuffer sql = new StringBuffer();
        sql.append(" select org.fname_").append(ctx.getLocale()).append(" as orgname ,purrequirement.fnumber as number,purrequirement.fid as billId, purrequirement.FCompanyOrgUnitID as companyId,");
        sql.append(" entry.fid as entryId,entry.fseq as seq,entry.fbasestatus as basestatus ");
        sql.append(" from T_SM_PurRequirement as purrequirement ");
        sql.append("  inner join T_SM_PurRequirementEntry as entry on entry.fparentid = purrequirement.fid ");
        sql.append(" inner join T_ORG_Company as org on org.fid = purrequirement.FCompanyOrgUnitID");
        sql.append("  where entry.fid in (").append(entryids);
        sql.append(") order by entry.fseq ");
        entryidSet.clear();
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        return rs;
    }

    public Set batchCheckPermission(Context ctx, String permission, IRowSet rs) throws BOSException, EASBizException, SQLException {
        HashSet<String> allOrgStringSet = new HashSet<String>();
        while (rs.next()) {
            allOrgStringSet.add(rs.getString("companyId"));
        }
        IObjectPK[] adllOrgs = new IObjectPK[allOrgStringSet.size()];
        Object[] objs = allOrgStringSet.toArray();
        for (int i = 0; i < allOrgStringSet.size(); ++i) {
            adllOrgs[i] = new ObjectUuidPK(objs[i].toString());
        }
        IObjectPK userPK = ctx.getCaller();
        IPermission iPerm = PermissionFactory.getLocalInstance((Context)ctx);
        Set sucessOrg = iPerm.checkBatchPermission(userPK, adllOrgs, permission);
        return sucessOrg;
    }

    private void addLogData(Map<String, String> map, IRowSet rs) throws SQLException {
        String parentid = rs.getString("billId");
        String seq = rs.getString("seq");
        String number = rs.getString("number");
        if (map.containsKey(parentid)) {
            map.put(parentid, map.get(parentid) + " " + seq);
        } else {
            map.put(parentid, number + "\uff1a " + seq);
        }
    }

    private void setlogs(Context ctx, Map<String, String> error, Map<String, String> sucess, String logItem) {
        Iterator<String> iterror = error.keySet().iterator();
        StringBuffer errorlog = new StringBuffer();
        StringBuffer sucesslog = new StringBuffer();
        while (iterror.hasNext()) {
            String key = iterror.next().toString();
            errorlog.append(error.get(key)).append(" ");
        }
        Iterator<String> itsucess = sucess.keySet().iterator();
        while (itsucess.hasNext()) {
            String key = itsucess.next().toString();
            sucesslog.append(sucess.get(key)).append("; ");
        }
        if (sucesslog.length() > 0) {
            IObjectPK pklog = LogUtil.beginLog((Context)ctx, (String)"1", (BOSObjectType)this.getBOSType(), null, (String)sucesslog.toString(), (String)logItem);
            LogUtil.afterLog((Context)ctx, (IObjectPK)pklog);
        }
    }
}

