/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.BizController;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeAuxInfo;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.ISupplierPurchaseInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeFactory;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IBizType;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.adv.chain.app.BusinessChainExecutorFactory;
import com.kingdee.eas.dynbusiness.adv.chain.app.IBusinessChainExecutor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ParamEntryExecuteContext;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.ISCMGroupFacade;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.SCMGroupFacadeFactory;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.loadmass.PurEntryDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMBizDataVO;
import com.kingdee.eas.scm.common.loadmass.SCMEntryDataVO;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMCommonUtil;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IPurInWarehsEntry;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.IPurReturns;
import com.kingdee.eas.scm.sm.pur.IPurReturnsEntry;
import com.kingdee.eas.scm.sm.pur.PriceSourceEnum;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurReturnsAgent;
import com.kingdee.eas.scm.sm.pur.PurReturnsCollection;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsException;
import com.kingdee.eas.scm.sm.pur.PurReturnsFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurReturnsControllerBean;
import com.kingdee.eas.scm.sm.pur.calculate.PurContractCal;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.util.BaseException;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class PurReturnsControllerBean
extends AbstractPurReturnsControllerBean {
    private static final long serialVersionUID = 3515890251366732046L;
    private static final BigDecimal ZERO = SCMConstant.BIGDECIMAL_ZERO;

    protected IObjectValue _createNewData(Context ctx, boolean isUseAgent) throws BOSException, EASBizException {
        PurReturnsInfo info = null;
        info = isUseAgent ? PurReturnsAgent.create() : new PurReturnsInfo();
        IBizType iBizType = BizTypeFactory.getLocalInstance((Context)ctx);
        BizTypeInfo bizTypeInfo = iBizType.getBizTypeInfo((IObjectPK)new ObjectUuidPK("d8e80652-0107-1000-e000-04c5c0a812202407435C"));
        if (bizTypeInfo != null) {
            info.setBizType(bizTypeInfo);
        }
        if (!this.isBizTypeValid(ctx, (IObjectValue)info, "50957179-0105-1000-e006-6152c0a812fd463ED552", bizTypeInfo).booleanValue()) {
            info.setBizType(null);
        }
        return info;
    }

    protected void _headClose(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        for (IObjectPK aPK : pk) {
            PurReturnsInfo info = (PurReturnsInfo)this.getValue(ctx, aPK);
            if (info.getBaseStatus().getValue() != 4) {
                throw new PurReturnsException(PurReturnsException.CLOSE_NEED_AUDIT);
            }
            info.setBaseStatus(BillBaseStatusEnum.CLOSED);
            PurReturnsEntryCollection entryInfos = info.getEntries();
            PurReturnsEntryInfo entry = null;
            int num = entryInfos.size();
            for (int j = 0; j < num; ++j) {
                entry = entryInfos.get(j);
                entry.setBaseStatus(EntryBaseStatusEnum.CLOSED);
            }
            super.update(ctx, aPK, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _close(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        this.canClose(ctx, pk);
        for (IObjectPK aPK : pk) {
            IPurReturnsEntry iPurReturnsEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
            PurReturnsEntryInfo entryInfo = iPurReturnsEntry.getPurReturnsEntryInfo(aPK);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
            entryInfo.setClosedDate(new Timestamp(System.currentTimeMillis()));
            iPurReturnsEntry.update(aPK, (CoreBaseInfo)entryInfo);
            IPurReturns iPurReturns = PurReturnsFactory.getLocalInstance(ctx);
            ObjectUuidPK returnsPK = new ObjectUuidPK(entryInfo.getParent().getId());
            PurReturnsInfo info = iPurReturns.getPurReturnsInfo((IObjectPK)returnsPK);
            this.reverseClose(ctx, (IObjectValue)info, (IObjectValue)entryInfo);
            this.autoClose(ctx, info);
        }
    }

    private void canClose(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        int n = pk.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pk[i];
            IPurReturnsEntry iPurReturnsEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
            PurReturnsEntryInfo entryInfo = iPurReturnsEntry.getPurReturnsEntryInfo(aPK);
            if (entryInfo.getId() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_ID);
            }
            if (entryInfo.getBaseStatus().getValue() == 4) continue;
            if (n > 1) {
                throw new PurReturnsException(PurReturnsException.PART_CANNOT_CLOSE);
            }
            throw new PurReturnsException(PurReturnsException.CLOSE_NEED_AUDIT);
        }
    }

    protected void autoClose(Context ctx, PurReturnsInfo purReturnsInfo) throws BOSException, EASBizException {
        PurReturnsInfo info = purReturnsInfo;
        ObjectUuidPK thePK = new ObjectUuidPK(info.getId());
        PurReturnsEntryCollection entryInfos = info.getEntries();
        PurReturnsEntryInfo entry = null;
        boolean closeFlag = true;
        int num = entryInfos.size();
        for (int j = 0; j < num; ++j) {
            entry = entryInfos.get(j);
            if (entry.getBaseStatus().getValue() == 7) continue;
            closeFlag = false;
        }
        if (closeFlag) {
            info.setBaseStatus(BillBaseStatusEnum.CLOSED);
            super.update(ctx, (IObjectPK)thePK, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _closeWithReason(Context ctx, IObjectPK[] pks, IObjectValue[] values) throws BOSException, EASBizException {
        this.canClose(ctx, pks);
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pks[i];
            ReasonCodeInfo reasonCodeInfo = (ReasonCodeInfo)values[i];
            IPurReturnsEntry iPurReturnsEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
            PurReturnsEntryInfo entryInfo = iPurReturnsEntry.getPurReturnsEntryInfo(aPK);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
            entryInfo.setClosedDate(new Timestamp(System.currentTimeMillis()));
            entryInfo.setReason(reasonCodeInfo.getName());
            iPurReturnsEntry.update(aPK, (CoreBaseInfo)entryInfo);
            IPurReturns iPurReturns = PurReturnsFactory.getLocalInstance(ctx);
            ObjectUuidPK returnsPK = new ObjectUuidPK(entryInfo.getParent().getId());
            PurReturnsInfo info = iPurReturns.getPurReturnsInfo((IObjectPK)returnsPK);
            entryInfo.put("parentNum", info.getNumber());
            super.closeWithLog(ctx, entryInfo);
            this.reverseClose(ctx, (IObjectValue)info, (IObjectValue)entryInfo);
            this.autoClose(ctx, info);
        }
    }

    @Override
    protected void _closeWithReason(Context ctx, IObjectPK[] pks, String[] reasons) throws BOSException, EASBizException {
        this.canClose(ctx, pks);
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pks[i];
            String reasonCodeInfo = reasons[i];
            IPurReturnsEntry iPurReturnsEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
            PurReturnsEntryInfo entryInfo = iPurReturnsEntry.getPurReturnsEntryInfo(aPK);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
            entryInfo.setClosedDate(new Timestamp(System.currentTimeMillis()));
            entryInfo.setReason(reasonCodeInfo);
            iPurReturnsEntry.update(aPK, (CoreBaseInfo)entryInfo);
            IPurReturns iPurReturns = PurReturnsFactory.getLocalInstance(ctx);
            ObjectUuidPK returnsPK = new ObjectUuidPK(entryInfo.getParent().getId());
            PurReturnsInfo info = iPurReturns.getPurReturnsInfo((IObjectPK)returnsPK);
            entryInfo.put("parentNum", info.getNumber());
            super.closeWithLog(ctx, entryInfo);
            this.reverseClose(ctx, (IObjectValue)info, (IObjectValue)entryInfo);
            this.autoClose(ctx, info);
        }
    }

    private void reverseClose(Context ctx, IObjectValue purReturnsInfo, IObjectValue purReturnsEntryInfo) throws BOSException, EASBizException {
        BigDecimal totalReturnedQty;
        BigDecimal qty;
        BigDecimal returnedQty;
        PurReturnsInfo pInfo = (PurReturnsInfo)purReturnsInfo;
        PurReturnsEntryInfo entryInfo = (PurReturnsEntryInfo)purReturnsEntryInfo;
        if (SCMUtils.isBotpBill((SCMBillBaseInfo)pInfo, (String)"510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
            IPurOrderEntry ipurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
            ObjectStringPK orderEntryPK = new ObjectStringPK(entryInfo.getSourceBillEntryId().toString());
            PurOrderEntryInfo orderEntryInfo = ipurOrderEntry.getPurOrderEntryInfo((IObjectPK)orderEntryPK);
            returnedQty = entryInfo.getReturnedQty();
            qty = entryInfo.getQty();
            totalReturnedQty = orderEntryInfo.getTotalReturnedQty();
            if (returnedQty.compareTo(ZERO) == 0) {
                return;
            }
            orderEntryInfo.setTotalReturnedQty(totalReturnedQty.subtract(qty.subtract(returnedQty)));
            ipurOrderEntry.update((IObjectPK)orderEntryPK, (CoreBaseInfo)orderEntryInfo);
        }
        if (SCMUtils.isBotpBill((SCMBillBaseInfo)pInfo, (String)"50957179-0105-1000-e000-015fc0a812fd463ED552")) {
            IPurInWarehsEntry ipurInWarehsEntry = PurInWarehsEntryFactory.getLocalInstance((Context)ctx);
            ObjectStringPK inWarehsEntryPK = new ObjectStringPK(entryInfo.getSourceBillEntryId().toString());
            PurInWarehsEntryInfo inWarehsEntryInfo = ipurInWarehsEntry.getPurInWarehsEntryInfo((IObjectPK)inWarehsEntryPK);
            returnedQty = entryInfo.getReturnedQty();
            qty = entryInfo.getQty();
            totalReturnedQty = inWarehsEntryInfo.getReturnsQty();
            if (returnedQty.compareTo(ZERO) == 0) {
                return;
            }
            inWarehsEntryInfo.setReturnsQty(totalReturnedQty.subtract(qty.subtract(returnedQty)));
            ipurInWarehsEntry.update((IObjectPK)inWarehsEntryPK, (CoreBaseInfo)inWarehsEntryInfo);
        }
    }

    protected void _headUnBlock(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        for (IObjectPK aPK : pk) {
            PurReturnsInfo info = (PurReturnsInfo)this.getValue(ctx, aPK);
            if (info.getBaseStatus().getValue() != 6) {
                throw new PurReturnsException(PurReturnsException.UNBLOCK_NEED_BLOCK);
            }
            info.setBaseStatus(BillBaseStatusEnum.AUDITED);
            PurReturnsEntryCollection entryInfos = info.getEntries();
            PurReturnsEntryInfo entry = null;
            int num = entryInfos.size();
            for (int j = 0; j < num; ++j) {
                entry = entryInfos.get(j);
                entry.setBaseStatus(EntryBaseStatusEnum.AUDITED);
            }
            super.update(ctx, aPK, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _unBlock(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        this.canUnBlock(ctx, pk);
        for (IObjectPK aPK : pk) {
            IPurReturnsEntry iPurReturnsEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
            PurReturnsEntryInfo entryInfo = iPurReturnsEntry.getPurReturnsEntryInfo(aPK);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.AUDITED);
            entryInfo.setReasonCode(null);
            entryInfo.setReason("");
            iPurReturnsEntry.update(aPK, (CoreBaseInfo)entryInfo);
            IPurReturns iPurReturns = PurReturnsFactory.getLocalInstance(ctx);
            ObjectUuidPK returnsPK = new ObjectUuidPK(entryInfo.getParent().getId());
            PurReturnsInfo info = iPurReturns.getPurReturnsInfo((IObjectPK)returnsPK);
            entryInfo.put("parentNum", info.getNumber());
            super.unblockWithLog(ctx, entryInfo);
            this.autoUnBlock(ctx, info);
        }
    }

    private void canUnBlock(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        int n = pk.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pk[i];
            IPurReturnsEntry iPurReturnsEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
            PurReturnsEntryInfo entryInfo = iPurReturnsEntry.getPurReturnsEntryInfo(aPK);
            if (entryInfo.getId() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_ID);
            }
            if (entryInfo.getBaseStatus().getValue() == 6) continue;
            if (n > 1) {
                throw new PurReturnsException(PurReturnsException.PART_CANNOT_UNBLOCK);
            }
            throw new PurReturnsException(PurReturnsException.UNBLOCK_NEED_BLOCK);
        }
    }

    protected void autoUnBlock(Context ctx, PurReturnsInfo purReturnsInfo) throws BOSException, EASBizException {
        PurReturnsInfo info = purReturnsInfo;
        ObjectUuidPK thePK = new ObjectUuidPK(info.getId());
        if (info.getBaseStatus().equals((Object)BillBaseStatusEnum.BLOCKED)) {
            info.setBaseStatus(BillBaseStatusEnum.AUDITED);
            super.update(ctx, (IObjectPK)thePK, (CoreBaseInfo)info);
        }
    }

    protected void _headBlock(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        for (IObjectPK aPK : pk) {
            PurReturnsInfo info = (PurReturnsInfo)this.getValue(ctx, aPK);
            if (info.getId() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ID);
            }
            if (info.getBaseStatus().getValue() != 4) {
                throw new PurReturnsException(PurReturnsException.BLOCK_NEED_AUDIT);
            }
            info.setBaseStatus(BillBaseStatusEnum.BLOCKED);
            PurReturnsEntryCollection entryInfos = info.getEntries();
            PurReturnsEntryInfo entry = null;
            int num = entryInfos.size();
            for (int j = 0; j < num; ++j) {
                entry = entryInfos.get(j);
                entry.setBaseStatus(EntryBaseStatusEnum.BLOCKED);
            }
            super.update(ctx, aPK, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _block(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        this.canBlock(ctx, pk);
        for (IObjectPK aPK : pk) {
            IPurReturnsEntry iPurReturnsEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
            PurReturnsEntryInfo entryInfo = iPurReturnsEntry.getPurReturnsEntryInfo(aPK);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.BLOCKED);
            iPurReturnsEntry.update(aPK, (CoreBaseInfo)entryInfo);
            IPurReturns iPurReturns = PurReturnsFactory.getLocalInstance(ctx);
            ObjectUuidPK returnsPK = new ObjectUuidPK(entryInfo.getParent().getId());
            PurReturnsInfo info = iPurReturns.getPurReturnsInfo((IObjectPK)returnsPK);
            this.autoBlock(ctx, info);
        }
    }

    private void canBlock(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        int n = pk.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pk[i];
            IPurReturnsEntry iPurReturnsEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
            PurReturnsEntryInfo entryInfo = iPurReturnsEntry.getPurReturnsEntryInfo(aPK);
            IPurReturns iPurReturns = PurReturnsFactory.getLocalInstance(ctx);
            PurReturnsInfo info = iPurReturns.getPurReturnsInfo((IObjectPK)new ObjectUuidPK(entryInfo.getParent().getId()));
            if (entryInfo.getId() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_ID);
            }
            if (info.getBaseStatus().getValue() == 4 && entryInfo.getBaseStatus().getValue() == 4) continue;
            if (n > 1) {
                throw new PurReturnsException(PurReturnsException.PART_CANNOT_BLOCK);
            }
            throw new PurReturnsException(PurReturnsException.BLOCK_NEED_AUDIT);
        }
    }

    protected void autoBlock(Context ctx, PurReturnsInfo purReturnsInfo) throws BOSException, EASBizException {
        PurReturnsInfo info = purReturnsInfo;
        ObjectUuidPK thePK = new ObjectUuidPK(info.getId());
        if (info.getId() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_ID);
        }
        if (info.getBaseStatus().getValue() != 4) {
            throw new PurReturnsException(PurReturnsException.BLOCK_NEED_AUDIT);
        }
        PurReturnsEntryCollection entryInfos = info.getEntries();
        PurReturnsEntryInfo entry = null;
        boolean closeFlag = true;
        int num = entryInfos.size();
        for (int j = 0; j < num; ++j) {
            entry = entryInfos.get(j);
            if (entry.getBaseStatus().getValue() == 6) continue;
            closeFlag = false;
        }
        if (closeFlag) {
            info.setBaseStatus(BillBaseStatusEnum.BLOCKED);
            super.update(ctx, (IObjectPK)thePK, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _blockWithReason(Context ctx, IObjectPK[] pks, IObjectValue[] values) throws BOSException, EASBizException {
        this.canBlock(ctx, pks);
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pks[i];
            ReasonCodeInfo reasonCodeInfo = (ReasonCodeInfo)values[i];
            IPurReturnsEntry iPurReturnsEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
            PurReturnsEntryInfo entryInfo = iPurReturnsEntry.getPurReturnsEntryInfo(aPK);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.BLOCKED);
            entryInfo.setReason(reasonCodeInfo.getName());
            iPurReturnsEntry.update(aPK, (CoreBaseInfo)entryInfo);
            IPurReturns iPurReturns = PurReturnsFactory.getLocalInstance(ctx);
            ObjectUuidPK returnsPK = new ObjectUuidPK(entryInfo.getParent().getId());
            PurReturnsInfo info = iPurReturns.getPurReturnsInfo((IObjectPK)returnsPK);
            entryInfo.put("parentNum", info.getNumber());
            super.blockWithLog(ctx, entryInfo);
            this.autoBlock(ctx, info);
        }
    }

    @Override
    protected void _blockWithReason(Context ctx, IObjectPK[] pks, String[] values) throws BOSException, EASBizException {
        this.canBlock(ctx, pks);
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pks[i];
            String reasonCodeInfo = values[i];
            IPurReturnsEntry iPurReturnsEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
            PurReturnsEntryInfo entryInfo = iPurReturnsEntry.getPurReturnsEntryInfo(aPK);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.BLOCKED);
            entryInfo.setReason(reasonCodeInfo);
            iPurReturnsEntry.update(aPK, (CoreBaseInfo)entryInfo);
            IPurReturns iPurReturns = PurReturnsFactory.getLocalInstance(ctx);
            ObjectUuidPK returnsPK = new ObjectUuidPK(entryInfo.getParent().getId());
            PurReturnsInfo info = iPurReturns.getPurReturnsInfo((IObjectPK)returnsPK);
            entryInfo.put("parentNum", info.getNumber());
            super.blockWithLog(ctx, entryInfo);
            this.autoBlock(ctx, info);
        }
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurReturnsInfo info = (PurReturnsInfo)this.getValue(ctx, pk);
        if (info.getId() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_ID);
        }
        if (info.getBaseStatus().getValue() != 2) {
            throw new PurReturnsException(PurReturnsException.CANCEL_NEED_SUBMIT);
        }
        info.setBaseStatus(BillBaseStatusEnum.DELETED);
        PurReturnsEntryCollection entryCol = info.getEntries();
        if (entryCol != null) {
            int size = entryCol.size();
            for (int j = 0; j < size; ++j) {
                PurReturnsEntryInfo entryInfo = entryCol.get(j);
                entryInfo.setBaseStatus(EntryBaseStatusEnum.DELETED);
            }
        }
        super.update(ctx, pk, (CoreBaseInfo)info);
    }

    @Override
    protected void _cancel(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        this.canCancel(ctx, pk);
        for (IObjectPK aPK : pk) {
            PurReturnsInfo info = (PurReturnsInfo)this.getValue(ctx, aPK);
            info.setBaseStatus(BillBaseStatusEnum.DELETED);
            PurReturnsEntryCollection entryCol = info.getEntries();
            if (entryCol != null) {
                int size = entryCol.size();
                for (int j = 0; j < size; ++j) {
                    PurReturnsEntryInfo entryInfo = entryCol.get(j);
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.DELETED);
                }
            }
            super.update(ctx, aPK, (CoreBaseInfo)info);
        }
    }

    private void canCancel(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        PurReturnsInfo info = null;
        if (pk == null || pk.length == 0) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        int n = pk.length;
        for (int i = 0; i < n; ++i) {
            idSet.add(pk[i].toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idSet, CompareType.INCLUDE));
        view.setFilter(filter);
        PurReturnsCollection coll = super.getPurReturnsCollection(ctx, view);
        if (coll != null && coll.size() > 0) {
            int n2 = coll.size();
            for (int i = 0; i < n2; ++i) {
                info = coll.get(i);
                if (info.getId() == null) {
                    throw new PurReturnsException(PurReturnsException.NULL_ID);
                }
                if (info.getBaseStatus().getValue() == 2 || info.getBaseStatus().getValue() == 1) continue;
                if (n2 > 1) {
                    throw new PurReturnsException(PurReturnsException.PART_CANNOT_CANCEL);
                }
                throw new PurReturnsException(PurReturnsException.CANCEL_NEED_SUBMIT);
            }
        }
    }

    private void canCancel(Context ctx, PurReturnsCollection coll) throws BOSException, EASBizException {
        PurReturnsInfo info = null;
        if (coll == null || coll.size() == 0) {
            return;
        }
        int n = coll.size();
        for (int i = 0; i < n; ++i) {
            info = coll.get(i);
            if (info.getId() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ID);
            }
            if (info.getBaseStatus().getValue() == 2 || info.getBaseStatus().getValue() == 1) continue;
            if (n > 1) {
                throw new PurReturnsException(PurReturnsException.PART_CANNOT_CANCEL);
            }
            throw new PurReturnsException(PurReturnsException.CANCEL_NEED_SUBMIT);
        }
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK[] pks, IObjectValue[] values) throws BOSException, EASBizException {
        if (pks == null || pks.length == 0 || values == null || values.length == 0) {
            return;
        }
        String[] reason = new String[values.length];
        int size = values.length;
        for (int i = 0; i < size; ++i) {
            ReasonCodeInfo reasonCodeInfo = (ReasonCodeInfo)values[i];
            reason[i] = reasonCodeInfo.getName();
        }
        this.cancel(ctx, pks, reason);
    }

    protected void cancel(Context ctx, IObjectPK[] pks, String[] values) throws EASBizException, BOSException {
        int i;
        int n;
        PurReturnsInfo info = null;
        if (pks == null || pks.length == 0) {
            return;
        }
        HashSet<String> set = new HashSet<String>();
        int n2 = pks.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            set.add(pks[i2].toString());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", set, CompareType.INCLUDE));
        view.setFilter(filter);
        PurReturnsCollection coll = super.getPurReturnsCollection(ctx, view);
        if (coll == null || coll.size() == 0) {
            return;
        }
        this.canCancel(ctx, coll);
        String tableName = "T_SM_PurReturnsEntry";
        Set idSet = SCMServerUtils.getHasBizFlowValueBillID((Context)ctx, (String)tableName, (IObjectPK[])pks);
        if (idSet.size() > 0) {
            n = coll.size();
            for (i = 0; i < n; ++i) {
                info = coll.get(i);
                if (!idSet.contains(info.getId().toString())) continue;
                SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)BatchActionEnum.CANCEL);
            }
        }
        n = coll.size();
        for (i = 0; i < n; ++i) {
            info = coll.get(i);
            String reasonCodeInfo = values[i];
            info.setBaseStatus(BillBaseStatusEnum.DELETED);
            PurReturnsEntryCollection entryCol = info.getEntries();
            if (entryCol != null) {
                int size = entryCol.size();
                for (int j = 0; j < size; ++j) {
                    PurReturnsEntryInfo entryInfo = entryCol.get(j);
                    entryInfo.setReason(reasonCodeInfo);
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.DELETED);
                }
            }
            super.cancelWithLog(ctx, info);
            super.update(ctx, (IObjectPK)new ObjectUuidPK(info.getId().toString()), (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK[] pks, String[] values) throws BOSException, EASBizException {
        this.cancel(ctx, pks, values);
    }

    protected void _delete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this.canDelete(ctx, pk);
        super._delete(ctx, pk);
    }

    private void canDelete(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurReturnsInfo info = (PurReturnsInfo)this.getValue(ctx, pk);
        if (info.getId() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_ID);
        }
        if (info.getBaseStatus().getValue() != 1 && info.getBaseStatus().getValue() != 2 && info.getBaseStatus().getValue() != 0) {
            throw new PurReturnsException(PurReturnsException.NEED_TEMPORY);
        }
    }

    @Override
    protected void _audit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurReturnsInfo info = this.getPurReturnsInfo(ctx, pk, SCMSelectorFactory.getPurReturnsSelector((boolean)true));
        this.passAudit(ctx, pk, (CoreBillBaseInfo)info);
    }

    @Override
    protected void _audit(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        this.canAudit(ctx, pk);
        IPurReturns iPurReturns = PurReturnsFactory.getLocalInstance(ctx);
        int n = pk.length;
        for (int i = 0; i < n; ++i) {
            iPurReturns.audit(pk[i]);
        }
    }

    private void canAudit(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        int n = pk.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pk[i];
            PurReturnsInfo info = (PurReturnsInfo)this.getValue(ctx, aPK);
            if (info.getId() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ID);
            }
            if (info.getBaseStatus().getValue() == 2) continue;
            if (n > 1) {
                throw new PurReturnsException(PurReturnsException.PART_CANNOT_AUDIT);
            }
            throw new PurReturnsException(PurReturnsException.AUDIT_NEED_SUBMIT);
        }
    }

    protected IObjectPK _submit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.submitWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSubmitRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected IObjectPK _save(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        if (model.get("CONTEXT_KEY_CALLBACK_4_DAO") != null) {
            return super.saveWithoutBusiness(ctx, model);
        }
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class})};
        entries[0].add((Object)model);
        this.batchSaveRelations(ctx, entries);
        return new ObjectUuidPK(((SCMBillBaseInfo)model).getId());
    }

    protected void checkValid(IObjectValue model) throws PurReturnsException {
        PurReturnsInfo info = (PurReturnsInfo)model;
        if (info.getSupplier() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_SUPPLIER);
        }
        if (info.getPurchaseOrgUnit() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_PURCHASEORGUNIT);
        }
        if (info.getBizType() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_BIZETYPE);
        }
        if (info.getCurrency() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_CURRENCY);
        }
        if (info.getExchangeRate() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_EXCHANGERATE);
        }
        if (info.getBaseStatus() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_BASTSTATE);
        }
        if (info.getEntries() != null) {
            this.checkEntriesValid(info.getEntries());
        } else if (info.getEntries() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_ENTRIES);
        }
    }

    private void checkEntriesValid(PurReturnsEntryCollection p) throws PurReturnsException {
        int count = p.size();
        if (count <= 0) {
            throw new PurReturnsException(PurReturnsException.NULL_ENTRIES);
        }
        for (int i = 0; i < count; ++i) {
            PurReturnsEntryInfo pEntryInfo = p.get(i);
            if (pEntryInfo.getMaterial() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_MATERIAL);
            }
            if (pEntryInfo.getUnit() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_MEASUREUNIT);
            }
            if (pEntryInfo.getQty() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_RETURNSQTY);
            }
            if (pEntryInfo.getPrice() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_PRICE);
            }
            if (pEntryInfo.getTaxPrice() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_TAXRATE);
            }
            if (pEntryInfo.getReturnsDate() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_RETURNSDATE);
            }
            if (pEntryInfo.getStorageOrgUnit() != null) continue;
            throw new PurReturnsException(PurReturnsException.NULL_ENTRY_STORAGEORGUNIT);
        }
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        return null;
    }

    protected boolean updateOrder(Context ctx, IObjectPK pk, IObjectValue info) throws BOSException, EASBizException {
        PurOrderEntryInfo orderEntryInfo;
        ObjectStringPK orderEntryPK;
        PurReturnsEntryInfo pEntryInfo;
        int i;
        boolean flagOrder = true;
        PurReturnsInfo returnInfo = (PurReturnsInfo)info;
        PurReturnsEntryCollection p = returnInfo.getEntries();
        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
        int size = p.size();
        for (i = 0; i < size; ++i) {
            BigDecimal qty;
            pEntryInfo = p.get(i);
            orderEntryPK = new ObjectStringPK(pEntryInfo.getSourceBillEntryId().toString());
            orderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo((IObjectPK)orderEntryPK);
            BigDecimal returnedQty = pEntryInfo.getBaseQty();
            if (returnedQty.compareTo(qty = orderEntryInfo.getTotalReceiptBaseQty().subtract(orderEntryInfo.getTotalReturnedBaseQty())) != 1) continue;
            flagOrder = false;
            return flagOrder;
        }
        size = p.size();
        for (i = 0; i < size; ++i) {
            MeasureUnitInfo orderUnit;
            pEntryInfo = p.get(i);
            orderEntryPK = new ObjectStringPK(pEntryInfo.getSourceBillEntryId().toString());
            orderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo((IObjectPK)orderEntryPK);
            BigDecimal qty = orderEntryInfo.getTotalReturnedQty();
            BigDecimal baseQty = orderEntryInfo.getTotalReturnedBaseQty();
            BigDecimal returnQty = pEntryInfo.getQty();
            IMeasureUnit iUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
            MeasureUnitInfo returnUnit = iUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(pEntryInfo.getUnit().getId()));
            if (!returnUnit.equals((Object)(orderUnit = iUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(orderEntryInfo.getUnit().getId()))))) {
                returnQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)orderEntryInfo.getMaterial().getId().toString(), (String)orderEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)pEntryInfo.getBaseQty(), (String)orderEntryInfo.getUnit().getId().toString());
            }
            if (qty.compareTo(ZERO) == 0) {
                orderEntryInfo.setTotalReturnedQty(returnQty);
                orderEntryInfo.setTotalReturnedBaseQty(pEntryInfo.getBaseQty());
            } else {
                orderEntryInfo.setTotalReturnedQty(qty.add(returnQty));
                orderEntryInfo.setTotalReturnedBaseQty(baseQty.add(pEntryInfo.getBaseQty()));
            }
            iPurOrderEntry.update((IObjectPK)orderEntryPK, (CoreBaseInfo)orderEntryInfo);
        }
        return flagOrder;
    }

    protected boolean updatePurInWarehsToOrder(Context ctx, IObjectPK pk, IObjectValue info) throws BOSException, EASBizException {
        PurInWarehsEntryInfo warehsEntryInfo;
        ObjectStringPK warehsEntryPK;
        PurReturnsEntryInfo pEntryInfo;
        int i;
        boolean flagInWares = true;
        PurReturnsInfo returnInfo = (PurReturnsInfo)info;
        PurReturnsEntryCollection p = returnInfo.getEntries();
        IPurInWarehsEntry iWarehsEntry = PurInWarehsEntryFactory.getLocalInstance((Context)ctx);
        IPurOrderEntry iPurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
        int size = p.size();
        for (i = 0; i < size; ++i) {
            BigDecimal qty;
            pEntryInfo = p.get(i);
            warehsEntryPK = new ObjectStringPK(pEntryInfo.getSourceBillEntryId().toString());
            warehsEntryInfo = iWarehsEntry.getPurInWarehsEntryInfo((IObjectPK)warehsEntryPK);
            BigDecimal returnsQty = pEntryInfo.getBaseQty();
            if (returnsQty.compareTo(qty = warehsEntryInfo.getBaseQty().subtract(warehsEntryInfo.getReturnBaseQty())) != 1) continue;
            flagInWares = false;
            return flagInWares;
        }
        size = p.size();
        for (i = 0; i < size; ++i) {
            MeasureUnitInfo orderUnit;
            pEntryInfo = p.get(i);
            warehsEntryPK = new ObjectStringPK(pEntryInfo.getSourceBillEntryId().toString());
            warehsEntryInfo = iWarehsEntry.getPurInWarehsEntryInfo((IObjectPK)warehsEntryPK);
            ObjectStringPK orderEntryPK = new ObjectStringPK(warehsEntryInfo.getPurOrderEntry());
            PurOrderEntryInfo orderEntryInfo = iPurOrderEntry.getPurOrderEntryInfo((IObjectPK)orderEntryPK);
            BigDecimal qty = orderEntryInfo.getTotalReturnedQty();
            BigDecimal baseQty = orderEntryInfo.getTotalReturnedBaseQty();
            BigDecimal returnQty = pEntryInfo.getQty();
            IMeasureUnit iUnit = MeasureUnitFactory.getLocalInstance((Context)ctx);
            MeasureUnitInfo returnUnit = iUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(pEntryInfo.getUnit().getId()));
            if (!returnUnit.equals((Object)(orderUnit = iUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(orderEntryInfo.getUnit().getId()))))) {
                returnQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)orderEntryInfo.getMaterial().getId().toString(), (String)orderEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)pEntryInfo.getBaseQty(), (String)orderEntryInfo.getUnit().getId().toString());
            }
            if (qty.compareTo(ZERO) == 0) {
                orderEntryInfo.setTotalReturnedQty(returnQty);
                orderEntryInfo.setTotalReturnedBaseQty(pEntryInfo.getBaseQty());
            } else {
                orderEntryInfo.setTotalReturnedQty(qty.add(returnQty));
                orderEntryInfo.setTotalReturnedBaseQty(baseQty.add(pEntryInfo.getBaseQty()));
            }
            iPurOrderEntry.update((IObjectPK)orderEntryPK, (CoreBaseInfo)orderEntryInfo);
            returnQty = pEntryInfo.getQty();
            MeasureUnitInfo warehsUnit = iUnit.getMeasureUnitInfo((IObjectPK)new ObjectUuidPK(warehsEntryInfo.getUnit().getId()));
            if (!returnUnit.equals((Object)warehsUnit)) {
                returnQty = SCMUtils.getExchangeQtyForServer((Context)ctx, (String)warehsEntryInfo.getMaterial().getId().toString(), (String)warehsEntryInfo.getBaseUnit().getId().toString(), (BigDecimal)pEntryInfo.getBaseQty(), (String)warehsEntryInfo.getUnit().getId().toString());
            }
            warehsEntryInfo.setReturnsQty(warehsEntryInfo.getReturnsQty().add(returnQty));
            warehsEntryInfo.setUnReturnedBaseQty((warehsEntryInfo.getUnReturnedBaseQty() == null ? warehsEntryInfo.getBaseQty() : warehsEntryInfo.getUnReturnedBaseQty()).subtract(pEntryInfo.getBaseQty()).abs());
            iWarehsEntry.update((IObjectPK)warehsEntryPK, (CoreBaseInfo)warehsEntryInfo);
        }
        return flagInWares;
    }

    protected CompanyOrgUnitInfo _getCompanyOrgUnit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        return null;
    }

    @Override
    protected void _closeWithLog(Context ctx, IObjectValue model) throws BOSException {
    }

    @Override
    protected void _cancelWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _blockWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _unblockWithLog(Context ctx, IObjectValue model) throws BOSException {
    }

    protected String _getBizUnitOrgID(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurchaseOrgUnitInfo unitInfo;
        if (model != null && (unitInfo = ((PurReturnsInfo)model).getPurchaseOrgUnit()) != null && unitInfo.getId() != null) {
            return unitInfo.getId().toString();
        }
        return null;
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK pk, String value) throws BOSException, EASBizException {
        super.cancelWithReason(ctx, new IObjectPK[]{pk}, new String[]{value});
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK pk, IObjectValue value) throws BOSException, EASBizException {
        this._cancelWithReason(ctx, new IObjectPK[]{pk}, new IObjectValue[]{value});
    }

    @Override
    protected void _unAudit(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        PurReturnsInfo info = this.getPurReturnsInfo(ctx, pk, SCMSelectorFactory.getPurReturnsSelector((boolean)true));
        entries[0] = new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{info});
        this.batchExecute(ctx, entries, BatchActionEnum.UNAUDIT);
    }

    protected void _unAudit(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            this._unAudit(ctx, pks[i]);
        }
    }

    protected String getBillTypeId() {
        return "50957179-0105-1000-e006-6152c0a812fd463ED552";
    }

    public void _handleAfterTransform(Context ctx, String action, IObjectCollection collection) throws EASBizException, BOSException {
        this.checkBillStatusForBotp(ctx, collection, new String[]{SCMConstant.BOSTYPE_PURINWAREHS, SCMConstant.BOSTYPE_PurOrder}, true);
        if ("NOTSAVE".equals(action)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("billType.id"));
            sic.add(new SelectorItemInfo("entries.material.id"));
            sic.add(new SelectorItemInfo("entries.material.name"));
            sic.add(new SelectorItemInfo("entries.material.number"));
            sic.add(new SelectorItemInfo("entries.material.model"));
            sic.add(new SelectorItemInfo("supplier.number"));
            sic.add(new SelectorItemInfo("supplier.name"));
            sic.add(new SelectorItemInfo("basestatus"));
            ctx.put((Object)"NOTSAVE_EDITUI_SELECTOR", (Object)sic);
        }
        SCMBizDataVO paramScmBizDataVO = null;
        SCMBizDataVO resultScmBizDataVO = null;
        PurReturnsInfo info = null;
        SupplierPurchaseInfoInfo supplierPurInfoInfo = null;
        SelectorItemCollection supplierPurInfoSelector = null;
        ISCMGroupFacade scmGroupFacade = SCMGroupFacadeFactory.getLocalInstance((Context)ctx);
        IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
        boolean isAdminOrgUnitByPerson = false;
        HashMap supplierMap = new HashMap();
        this.setSupplierCache(ctx, collection, supplierMap);
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            int j;
            info = (PurReturnsInfo)collection.getObject(i);
            if (info.getBaseStatus() == null || info.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD)) {
                info.setBaseStatus(BillBaseStatusEnum.ADD);
            }
            this.calByUnitSource(ctx, info, (IObjectCollection)info.getEntries());
            paramScmBizDataVO = this.getParamSCMBizDataVO(ctx, info);
            resultScmBizDataVO = scmGroupFacade.loadSCMBizDataVO(paramScmBizDataVO);
            if (resultScmBizDataVO != null && paramScmBizDataVO.getMainOrg() != null) {
                if (info.getSupplier() != null && (info.getPurchaseGroup() == null || info.getPurchasePerson() == null)) {
                    ISupplierPurchaseInfo iSupplierpurchase;
                    supplierPurInfoSelector = new SelectorItemCollection();
                    supplierPurInfoSelector.add(new SelectorItemInfo("defaultPurchaser.id"));
                    supplierPurInfoSelector.add(new SelectorItemInfo("defaultPurchaser.name"));
                    supplierPurInfoSelector.add(new SelectorItemInfo("defaultPurchaser.number"));
                    supplierPurInfoSelector.add(new SelectorItemInfo("purchaseGroup.id"));
                    supplierPurInfoSelector.add(new SelectorItemInfo("purchaseGroup.name"));
                    supplierPurInfoSelector.add(new SelectorItemInfo("purchaseGroup.number"));
                    if (info.getSupplier().getId() != null && paramScmBizDataVO.getMainOrg() != null && paramScmBizDataVO.getMainOrg().getId() != null && (supplierPurInfoInfo = (iSupplierpurchase = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx)).getPurChaseInfo((IObjectPK)new ObjectUuidPK(info.getSupplier().getId()), (IObjectPK)new ObjectUuidPK(paramScmBizDataVO.getMainOrg().getId().toString()), supplierPurInfoSelector)) != null) {
                        if (info.getPurchaseGroup() == null && supplierPurInfoInfo.getPurchaseGroup() != null) {
                            info.setPurchaseGroup(supplierPurInfoInfo.getPurchaseGroup());
                        }
                        if (info.getPurchasePerson() == null && supplierPurInfoInfo.getDefaultPurchaser() != null) {
                            info.setPurchasePerson(supplierPurInfoInfo.getDefaultPurchaser());
                        }
                    }
                }
                if (info.getAdminOrgUnit() == null && info.getPurchasePerson() != null && (isAdminOrgUnitByPerson = this.isIntPurParam("PURORDER001", 0, 0, resultScmBizDataVO.getParametersMap()))) {
                    AdminOrgUnitInfo aAdminOrgUnitInfo = iPerson.getPrimaryAdminOrgUnit(info.getPurchasePerson().getId());
                    info.setAdminOrgUnit(aAdminOrgUnitInfo);
                }
            }
            Object warehsInfo = null;
            Object materialInfo = null;
            HashSet<String> idsSet = new HashSet<String>();
            IMaterialInventory imaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)ctx);
            EntityViewInfo warehouseView = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            for (int row = 0; row < info.getEntries().size(); ++row) {
                idsSet.add(info.getEntries().get(row).getMaterial().getId().toString());
            }
            filter.getFilterItems().add(new FilterItemInfo("Material.id", idsSet, CompareType.INCLUDE));
            warehouseView.getSelector().add(new SelectorItemInfo("Material.id"));
            warehouseView.getSelector().add(new SelectorItemInfo("defaultWarehouse.*"));
            warehouseView.setFilter(filter);
            MaterialInventoryCollection collections = imaterialInventory.getMaterialInventoryCollection(warehouseView);
            for (int row = 0; row < info.getEntries().size(); ++row) {
                if (info.getEntries().get(row).getStorageOrgUnit() == null || info.getEntries().get(row).getWarehouse() != null) continue;
                for (j = 0; j < collections.size(); ++j) {
                    if (!info.getEntries().get(row).getMaterial().getId().equals((Object)collections.get(j).getMaterial().getId()) || collections.get(j).getDefaultWarehouse() == null || !collections.get(j).getDefaultWarehouse().getStorageOrg().getId().toString().equals(info.getEntries().get(row).getStorageOrgUnit().getId().toString())) continue;
                    info.getEntries().get(row).setWarehouse(collections.get(j).getDefaultWarehouse());
                }
            }
            int size = info.getEntries().size();
            for (int j2 = 0; j2 < size; ++j2) {
                PurReturnsEntryInfo entry = info.getEntries().get(j2);
                if ("NOTSAVE".equals(action)) {
                    entry.setBaseStatus(EntryBaseStatusEnum.ADD);
                }
                if (entry.getAssistQty() == null || entry.getAssistQty().compareTo(BigDecimal.ZERO) == 0) {
                    BigDecimal assistQty = entry.getAssistUnit() != null ? SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entry.getMaterial().getId().toString(), (String)entry.getUnit().getId().toString(), (BigDecimal)entry.getQty(), (String)entry.getAssistUnit().getId().toString()) : entry.getAssistQty();
                    entry.setAssistQty(assistQty);
                }
                BigDecimal baseQty = entry.getBaseUnit() != null ? SCMUtils.getExchangeQtyForServer((Context)ctx, (String)entry.getMaterial().getId().toString(), (String)entry.getUnit().getId().toString(), (BigDecimal)entry.getQty(), (String)entry.getBaseUnit().getId().toString()) : entry.getBaseQty();
                entry.setBaseQty(baseQty);
            }
            if (info.getSupplier() != null && info.getSupplier().getId() != null) {
                SupplierInfo supplierInCache = (SupplierInfo)supplierMap.get(info.getSupplier().getId().toString());
                for (j = 0; j < info.getEntries().size(); ++j) {
                    PurReturnsEntryInfo entryInfo = info.getEntries().get(j);
                    if (supplierInCache == null || entryInfo.getTaxRate() != null) continue;
                    entryInfo.setTaxRate(supplierInCache.getTaxRate());
                }
            }
            if (!PriceSourceEnum.PRICEFROMBOTP.equals((Object)info.getPriceSource())) continue;
            this.reCalcAmount(ctx, info, resultScmBizDataVO.getScmEntryDataVO(), resultScmBizDataVO.getScmEntryDataVO().getBaseCurrencyInfo());
        }
        if (info != null && info.get("") == null && BillBaseStatusEnum.AUDITED == info.getBaseStatus()) {
            info.setIsSysBill(true);
        }
        HashMap materialMap = new HashMap();
        this.setMaterialCache(ctx, collection, materialMap);
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        paramCol.setBillTypeId("50957179-0105-1000-e006-6152c0a812fd463ED552");
        if (info != null && (info.getPriceSource() == null || PriceSourceEnum.REFETCHPRICE.equals((Object)info.getPriceSource()))) {
            this.fetchPrice(ctx, paramCol, collection, materialMap);
        }
    }

    public boolean isIntPurParam(String key, int defaultValue, int trueValue, Map paramMap) {
        String strPurParam = (String)paramMap.get(key);
        if (strPurParam != null && strPurParam.trim().length() != 0) {
            int value = Integer.parseInt(strPurParam);
            return value == trueValue;
        }
        return defaultValue == trueValue;
    }

    private void fetchPrice(Context ctx, PurPriceParamCollection paramCol, IObjectCollection collection, Map materialMap) throws EASBizException, BOSException {
        int i;
        int orderBaseSeq = 10000;
        boolean calcPriceMode = false;
        PurReturnsInfo info = null;
        PurReturnsEntryInfo entryInfo = null;
        for (int i2 = 0; i2 < collection.size(); ++i2) {
            info = (PurReturnsInfo)collection.getObject(i2);
            if (info.getBizType() != null) {
                paramCol.setBizTypeId(info.getBizType().getId().toString());
            }
            for (int k = 0; k < info.getEntries().size(); ++k) {
                entryInfo = info.getEntries().get(k);
                if (entryInfo.getMaterial() == null || entryInfo.isIsPresent()) continue;
                int seq = orderBaseSeq * (i2 + 1) + k;
                PurPriceParam param = this.getPriceParam(seq, info, entryInfo);
                paramCol.addPurPriceParam(param);
            }
        }
        if (paramCol.size() > 0) {
            PurPriceInfoCollection cols = PurServiceFacadeFactory.getLocalInstance(ctx).fetchPrice(paramCol);
            for (i = 0; i < collection.size() && null != info; ++i) {
                for (int j = 0; j < info.getEntries().size(); ++j) {
                    entryInfo = info.getEntries().get(j);
                    int seq = orderBaseSeq * (i + 1) + j;
                    PurPriceInfo priceInfo = cols.getPurPriceInfoBySeq(seq);
                    PurContractCal purCal = new PurContractCal();
                    if (priceInfo != null && priceInfo.getPrice() != null) {
                        purCal.setInTax(priceInfo.isInTaxPrice());
                        this.setPrecision(materialMap, info, entryInfo);
                        if (priceInfo.isInTaxPrice()) {
                            entryInfo.setTaxPrice(this.preProcessPrice(priceInfo));
                            purCal.calByEntryTaxPriceChange(info, entryInfo);
                            continue;
                        }
                        entryInfo.setPrice(this.preProcessPrice(priceInfo));
                        purCal.calByEntryPriceChange(info, entryInfo);
                        continue;
                    }
                    if (priceInfo != null && priceInfo.getPrice() != null) continue;
                    purCal.setInTax(false);
                    entryInfo.setPrice(ZERO);
                    purCal.calByEntryPriceChange(info, entryInfo);
                }
            }
        }
        ISCMGroupFacade scmGroupFacade = SCMGroupFacadeFactory.getLocalInstance((Context)ctx);
        for (i = 0; i < collection.size(); ++i) {
            info = (PurReturnsInfo)collection.getObject(i);
            SCMBizDataVO paramScmBizDataVO = this.getParamSCMBizDataVO(ctx, info);
            SCMBizDataVO scmBizDataVO = scmGroupFacade.loadSCMBizDataVO(paramScmBizDataVO);
            PurEntryDataVO purEntryDataVO = (PurEntryDataVO)scmBizDataVO.getScmEntryDataVO();
            this.calcLocalAmount(ctx, info, purEntryDataVO);
        }
    }

    private BigDecimal preProcessPrice(PurPriceInfo priceInfo) {
        BigDecimal price = priceInfo.getPrice();
        BigDecimal discountRate = priceInfo.getDiscountRate();
        if (discountRate.compareTo(SCMConstant.BIGDECIMAL_ZERO) > 0) {
            discountRate = discountRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 4, 4);
            price = priceInfo.getPrice().multiply(SCMConstant.BIGDECIMAL_ONE.subtract(discountRate));
            price = price.setScale(priceInfo.getPricePrecision(), 4);
        }
        return price;
    }

    private PurPriceParam getPriceParam(int seq, PurReturnsInfo info, PurReturnsEntryInfo entryInfo) {
        PurPriceParam param = new PurPriceParam();
        param.setBillTypeId("50957179-0105-1000-e006-6152c0a812fd463ED552");
        param.setSeq(seq);
        param.setPurOrgUnitId(info.getPurchaseOrgUnit() != null ? info.getPurchaseOrgUnit().getId().toString() : null);
        param.setSupplierId(info.getSupplier() != null ? info.getSupplier().getId().toString() : null);
        param.setMaterialId(entryInfo.getMaterial() != null ? entryInfo.getMaterial().getId().toString() : null);
        param.setMaterialPurchaseType(0);
        param.setUnitId(entryInfo.getUnit() != null ? entryInfo.getUnit().getId().toString() : null);
        param.setCurrencyId(info.getCurrency() != null ? info.getCurrency().getId().toString() : null);
        param.setBizDate(info.getBizDate());
        if (entryInfo.getReturnsDate() == null) {
            param.setDeliveryDate(info.getBizDate());
        } else {
            param.setDeliveryDate(entryInfo.getReturnsDate());
        }
        param.setAssistPropertyId(entryInfo.getAssistProperty() != null ? entryInfo.getAssistProperty().getId().toString() : null);
        param.setQty(entryInfo.getQty());
        param.setBizTypeId(info.getBizType() != null ? info.getBizType().getId().toString() : null);
        param.setRecOrgUnitId(entryInfo.getStorageOrgUnit() != null ? entryInfo.getStorageOrgUnit().getId().toString() : null);
        return param;
    }

    private void calcByConfigPrice(PurReturnsInfo info, PurReturnsEntryInfo entryInfo, int calcPriceMode, Map materialMap) {
        PurContractCal purCal = new PurContractCal();
        MaterialInfo materialInfo = (MaterialInfo)materialMap.get(entryInfo.getMaterial().getId().toString());
        if (entryInfo.getPrice() == null && entryInfo.getTaxPrice() != null) {
            calcPriceMode = 1;
        }
        if (entryInfo.getPrice() != null && entryInfo.getTaxPrice() == null) {
            calcPriceMode = 0;
        }
        if (entryInfo.getPrice() != null && entryInfo.getTaxPrice() != null) {
            calcPriceMode = info.isIsInTax() ? 1 : 0;
        }
        BigDecimal zero = new BigDecimal("0.00000000");
        if (info.getCurrency() != null) {
            BigDecimal amountWithPrecision = zero.setScale(info.getCurrency().getPrecision(), 4);
            entryInfo.setTaxAmount(amountWithPrecision);
            entryInfo.setAmount(amountWithPrecision);
        }
        if (calcPriceMode == 1) {
            purCal.setInTax(true);
            entryInfo.setTaxPrice(entryInfo.getTaxPrice().setScale(materialInfo.getPricePrecision(), 4));
            entryInfo.setPrice(zero.setScale(materialInfo.getPricePrecision(), 4));
            purCal.calByEntryTaxPriceChange(info, entryInfo);
        } else {
            entryInfo.setPrice(entryInfo.getPrice().setScale(materialInfo.getPricePrecision(), 4));
            entryInfo.setTaxPrice(zero.setScale(materialInfo.getPricePrecision(), 4));
            purCal.calByEntryPriceChange(info, entryInfo);
        }
    }

    private void setMaterialCache(Context ctx, IObjectCollection collection, Map materialMap) throws BOSException {
        HashSet<String> materialIdSet = new HashSet<String>();
        PurReturnsInfo info = null;
        PurReturnsEntryInfo entryInfo = null;
        MaterialInfo materialInfo = null;
        int n = collection.size();
        for (int i = 0; i < n; ++i) {
            info = (PurReturnsInfo)collection.getObject(i);
            for (int j = 0; j < info.getEntries().size(); ++j) {
                entryInfo = info.getEntries().get(j);
                materialInfo = entryInfo.getMaterial();
                if (materialInfo == null) continue;
                materialIdSet.add(materialInfo.getId().toString());
            }
        }
        if (materialIdSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", materialIdSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("pricePrecision"));
            view.setSelector(selector);
            MaterialCollection materials = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
            for (int k = 0; k < materials.size(); ++k) {
                materialMap.put(materials.get(k).getId().toString(), materials.get(k));
            }
        }
    }

    private void setSupplierCache(Context ctx, IObjectCollection collection, Map supplierMap) throws BOSException {
        HashSet<String> supplierIds = new HashSet<String>();
        for (int i = 0; i < collection.size(); ++i) {
            PurReturnsInfo info = (PurReturnsInfo)collection.getObject(i);
            if (info.getSupplier() == null || info.getSupplier().getId() == null) continue;
            supplierIds.add(info.getSupplier().getId().toString());
        }
        if (supplierIds.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", supplierIds, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("taxRate"));
            view.setSelector(selector);
            SupplierCollection suppliers = SupplierFactory.getLocalInstance((Context)ctx).getSupplierCollection(view);
            for (int k = 0; k < suppliers.size(); ++k) {
                supplierMap.put(suppliers.get(k).getId().toString(), suppliers.get(k));
            }
        }
    }

    private void setPrecision(Map materialMap, PurReturnsInfo info, PurReturnsEntryInfo entryInfo) {
        BigDecimal zero = new BigDecimal("0.00000000");
        if (info.getCurrency() != null) {
            BigDecimal amountWithPrecision = zero.setScale(info.getCurrency().getPrecision(), 4);
            entryInfo.setTaxAmount(amountWithPrecision);
            entryInfo.setAmount(amountWithPrecision);
        }
        MaterialInfo materialInfo = (MaterialInfo)materialMap.get(entryInfo.getMaterial().getId().toString());
        entryInfo.setPrice(zero.setScale(materialInfo.getPricePrecision(), 4));
        entryInfo.setTaxPrice(zero.setScale(materialInfo.getPricePrecision(), 4));
    }

    protected void calcLocalAmount(Context ctx, PurReturnsInfo info, PurEntryDataVO vo) throws BOSException, EASBizException {
        if (vo == null) {
            return;
        }
        BigDecimal ZERO = SysConstant.BIGZERO;
        CurrencyInfo baseCurrencyInfo = vo.getBaseCurrencyInfo();
        CurrencyInfo currencyInfo = null;
        currencyInfo = info.getCurrency() != null ? info.getCurrency() : baseCurrencyInfo;
        BigDecimal exchangeRate = info.getExchangeRate();
        ExchangeAuxInfo exchangeAuxInfo = vo.getExchangeAuxInfo();
        if (baseCurrencyInfo == null) {
            baseCurrencyInfo = currencyInfo;
        }
        int localScale = baseCurrencyInfo.getPrecision();
        BigDecimal totalAmount = ZERO;
        BigDecimal totalTax = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        PurReturnsEntryCollection collection = info.getEntries();
        PurReturnsEntryInfo entryInfo = null;
        MaterialInfo materialInfo = null;
        int m = collection.size();
        for (int j = 0; j < m; ++j) {
            entryInfo = collection.get(j);
            materialInfo = entryInfo.getMaterial();
            if (materialInfo == null) continue;
            BigDecimal amount = entryInfo.getAmount() != null ? entryInfo.getAmount() : ZERO;
            BigDecimal tax = entryInfo.getTax() != null ? entryInfo.getTax() : ZERO;
            BigDecimal taxAmount = entryInfo.getTaxAmount() != null ? entryInfo.getTaxAmount() : ZERO;
            BigDecimal localAmount = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)amount, (int)localScale);
            BigDecimal localTax = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)tax, (int)localScale);
            BigDecimal localTaxAmount = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)taxAmount, (int)localScale);
            totalAmount = totalAmount.add(amount);
            totalTax = totalTax.add(tax);
            totalTaxAmount = totalTaxAmount.add(taxAmount);
            entryInfo.setLocalAmount(localAmount);
            entryInfo.setLocalTax(localTax);
            entryInfo.setLocalTaxAmount(localTaxAmount);
        }
        info.setTotalAmount(totalAmount);
        info.setTotalTax(totalTax);
        info.setTotalTaxAmount(totalTaxAmount);
    }

    protected SCMBizDataVO getParamSCMBizDataVO(Context ctx, PurReturnsInfo info) {
        SCMBizDataVO scmBizDataVO = new SCMBizDataVO(this.getMainBizOrgType(), this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)info), 0, this.getLoginUserInfo(ctx), null);
        scmBizDataVO.setBOSType(this.getBOSType().toString());
        scmBizDataVO.setParameters(this.getParameterNames());
        scmBizDataVO.setDelegatedOrgTypes(this.getDelegatedOrgTypes());
        PurEntryDataVO scmEntryDataVO = new PurEntryDataVO();
        scmEntryDataVO.setCurrencyInfo(info.getCurrency());
        scmEntryDataVO.setIsLoadingCurrency(true);
        scmEntryDataVO.setIsLoadingMou(true);
        scmEntryDataVO.setIsLoadingMmuPrecision(true);
        scmBizDataVO.setScmEntryDataVO((SCMEntryDataVO)scmEntryDataVO);
        this.initSCMBizDataVO(ctx, scmBizDataVO, info.getEntries());
        PurEntryDataVO purReturnsDataVO = (PurEntryDataVO)scmBizDataVO.getScmEntryDataVO();
        purReturnsDataVO.setMainOrgType(this.getMainBizOrgType());
        purReturnsDataVO.setMainOrg(this.getMainBizOrgUnit(ctx, (CoreBillBaseInfo)info));
        return scmBizDataVO;
    }

    protected String[] getParameterNames() {
        return new String[]{"PURORDER001"};
    }

    protected HashSet getDelegatedOrgTypes() {
        HashSet<OrgType> delegateOrgTypeSet = new HashSet<OrgType>();
        delegateOrgTypeSet.add(OrgType.Admin);
        delegateOrgTypeSet.add(OrgType.Company);
        delegateOrgTypeSet.add(OrgType.Storage);
        return delegateOrgTypeSet;
    }

    protected OrgUnitInfo getMainBizOrgUnit(Context ctx, CoreBillBaseInfo model) {
        return super.getMainBizOrgUnit(ctx, model);
    }

    protected OrgType getMainBizOrgType() {
        return OrgType.Purchase;
    }

    public String getParamCon4Audit() {
        return "PUREXA001";
    }

    public String getParamCon4UnAudit() {
        return "PUREXA002";
    }

    protected String getBatchMethodName(Context ctx, String name) throws BaseException {
        if (Boolean.FALSE.equals(ctx.get((Object)"CONTEXT_KEY_ISBATCHACTION"))) {
            return null;
        }
        return "batch" + name.substring(0, 1).toUpperCase() + name.substring(1);
    }

    protected void _submit(Context ctx, String id) throws BOSException, EASBizException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[1];
        Class[] parameterTypes = new Class[]{IObjectValue.class};
        PurReturnsInfo model = null;
        model = this.getPurReturnsInfo(ctx, (IObjectPK)new ObjectUuidPK(id), SCMSelectorFactory.getPurReturnsSelector((boolean)true));
        entries[0] = new BatchExecuteParamsEntry(parameterTypes, new Object[]{model});
        this.batchExecute(ctx, entries, BatchActionEnum.SUBMIT);
    }

    public BatchActionResults batchSubmitOrSave(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchAction) throws EASBizException, BOSException {
        return this.batchExecute(ctx, entries, batchAction);
    }

    protected BatchActionResults batchExecute(Context ctx, BatchExecuteParamsEntry[] entries, BatchActionEnum batchActionEnum) throws EASBizException, BOSException {
        IBusinessChainExecutor executor = BusinessChainExecutorFactory.getBusinessChainExecutor();
        ParamEntryExecuteContext executeContext = new ParamEntryExecuteContext(ctx, this.getBOSType(), batchActionEnum, (BizController)this, entries);
        executeContext.setBillTypeID(this.getBillTypeId());
        BatchActionResults batchResults = executor.batchExecute((ExecuteContext)executeContext);
        return batchResults;
    }

    protected void _passAudit(Context ctx, IObjectPK pk, IObjectValue model) throws EASBizException, BOSException {
        BatchExecuteParamsEntry[] entries = new BatchExecuteParamsEntry[]{new BatchExecuteParamsEntry(new Class[]{IObjectValue.class}, new Object[]{model})};
        this.batchExecute(ctx, entries, BatchActionEnum.AUDIT);
    }

    protected void calByUnitSource(Context ctx, SCMBillBaseInfo scmBillBaseInfo, SCMBillEntryBaseInfo scmBillEntryBaseInfo) throws BOSException, EASBizException {
        String sourceUnitId;
        super.calByUnitSource(ctx, scmBillBaseInfo, scmBillEntryBaseInfo);
        PurReturnsEntryInfo purReturnsEntryInfo = (PurReturnsEntryInfo)scmBillEntryBaseInfo;
        String sourceBillEntryId = purReturnsEntryInfo.getSourceBillEntryId();
        if (StringUtil.isEmpty((String)sourceBillEntryId)) {
            return;
        }
        if (!(this.sourceBillEntryMap.get(sourceBillEntryId) instanceof SCMBillEntryBaseInfo)) {
            return;
        }
        SCMBillEntryBaseInfo sourceBillEntryInfo = (SCMBillEntryBaseInfo)this.sourceBillEntryMap.get(sourceBillEntryId);
        String unitId = purReturnsEntryInfo.getUnit().getId().toString();
        if (unitId.equals(sourceUnitId = sourceBillEntryInfo.getUnit().getId().toString())) {
            return;
        }
        BigDecimal qty = BigDecimal.ZERO;
        qty = purReturnsEntryInfo.getBaseQty() != null ? SCMCommonUtil.calQtyByBaseQty((Context)ctx, (BigDecimal)purReturnsEntryInfo.getBaseQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo) : SCMCommonUtil.reCalQty((Context)ctx, (BigDecimal)purReturnsEntryInfo.getQty(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
        purReturnsEntryInfo.setQty(qty);
        PurReturnsInfo purReturnsInfo = (PurReturnsInfo)scmBillBaseInfo;
        PurContractCal purContractCal = new PurContractCal();
        purContractCal.setInTax(purReturnsInfo.isIsInTax());
        BigDecimal price = null;
        if (purReturnsInfo.isIsInTax()) {
            price = SCMCommonUtil.reCalPrice((Context)ctx, (BigDecimal)purReturnsEntryInfo.getTaxPrice(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
            purReturnsEntryInfo.setTaxPrice(price);
            purContractCal.calByEntryTaxPriceChange(purReturnsInfo, purReturnsEntryInfo);
        } else {
            price = SCMCommonUtil.reCalPrice((Context)ctx, (BigDecimal)purReturnsEntryInfo.getPrice(), (SCMBillEntryBaseInfo)scmBillEntryBaseInfo, (String)sourceUnitId);
            purReturnsEntryInfo.setPrice(price);
            purContractCal.calByEntryPriceChange(purReturnsInfo, purReturnsEntryInfo);
        }
    }

    protected String _getAssignUipk4Entity(Context ctx, IObjectPK id, IObjectValue model, String viewType) throws BOSException, EASBizException {
        if ("list".equalsIgnoreCase(viewType)) {
            return "com.kingdee.eas.scm.sm.pur.purReturnsListPage";
        }
        if ("edit".equalsIgnoreCase(viewType)) {
            return "com.kingdee.eas.scm.sm.pur.purReturnsEditPage";
        }
        return null;
    }

    protected void reCalcAmount(Context ctx, PurReturnsInfo info, SCMEntryDataVO vo, CurrencyInfo baseCurrencyInfo) throws BOSException, EASBizException {
        BigDecimal ZERO = BigDecimal.ZERO;
        BigDecimal HUNDRED = SCMConstant.BIGDECIMAL_ONEHUNDRED;
        CurrencyInfo currencyInfo = null;
        currencyInfo = info.getCurrency() != null ? info.getCurrency() : baseCurrencyInfo;
        ExchangeAuxInfo exchangeAuxInfo = vo.getExchangeAuxInfo();
        boolean isContainsTax = info.isIsInTax();
        if (baseCurrencyInfo == null) {
            baseCurrencyInfo = currencyInfo;
        }
        if (vo.getExchangeRateinfo() != null) {
            info.setExchangeRate(vo.getExchangeRateinfo().getConvertRate());
        }
        BigDecimal exchangeRate = info.getExchangeRate();
        int localScale = baseCurrencyInfo.getPrecision();
        int scale = currencyInfo.getPrecision();
        BigDecimal totalAmount = ZERO;
        BigDecimal totalTax = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        PurReturnsEntryCollection collection = info.getEntries();
        PurReturnsEntryInfo entryInfo = null;
        int m = collection.size();
        for (int j = 0; j < m; ++j) {
            entryInfo = collection.get(j);
            if (!PriceSourceEnum.PRICEFROMBOTP.equals((Object)info.getPriceSource())) continue;
            BigDecimal qty = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getQty());
            BigDecimal price = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getPrice());
            BigDecimal taxRate = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getTaxRate());
            BigDecimal taxPrice = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getTaxPrice());
            BigDecimal amount = ZERO;
            BigDecimal tax = ZERO;
            BigDecimal taxAmount = ZERO;
            BigDecimal localAmount = ZERO;
            BigDecimal localTax = ZERO;
            BigDecimal localTaxAmount = ZERO;
            if (isContainsTax) {
                taxAmount = CalculateUtils.calAmount((BigDecimal)qty, (BigDecimal)taxPrice, (int)scale);
                tax = taxAmount.multiply(taxRate).divide(HUNDRED.add(taxRate), scale, 4);
                amount = taxAmount.subtract(tax);
            } else {
                amount = CalculateUtils.calAmount((BigDecimal)qty, (BigDecimal)price, (int)scale);
                tax = CalculateUtils.calTax((BigDecimal)amount, (BigDecimal)taxRate, (int)scale);
                taxAmount = CalculateUtils.calTotalTaxAmount((BigDecimal)amount, (BigDecimal)tax, (int)scale);
            }
            localAmount = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)amount, (int)localScale);
            localTax = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)tax, (int)localScale);
            localTaxAmount = CalculateUtils.calcByExchangeRate((ExchangeAuxInfo)exchangeAuxInfo, (BigDecimal)exchangeRate, (BigDecimal)taxAmount, (int)localScale);
            totalAmount = totalAmount.add(amount);
            totalTax = totalTax.add(tax);
            totalTaxAmount = totalTaxAmount.add(taxAmount);
            entryInfo.setAmount(amount);
            entryInfo.setTax(tax);
            entryInfo.setTaxAmount(taxAmount);
            entryInfo.setLocalAmount(localAmount);
            entryInfo.setLocalTax(localTax);
            entryInfo.setLocalTaxAmount(localTaxAmount);
        }
        info.setTotalAmount(totalAmount);
        info.setTotalTax(totalTax);
        info.setTotalTaxAmount(totalTaxAmount);
    }
}

