/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.metadata.util.ViewParseUtils;
import com.kingdee.bos.sql.dom.expr.SqlExpr;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.codingrule.CodingRuleManagerFactory;
import com.kingdee.eas.base.codingrule.ICodingRuleManager;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.permission.IUser;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.base.permission.UserCollection;
import com.kingdee.eas.base.permission.UserFactory;
import com.kingdee.eas.base.permission.UserInfo;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.CurrencyCollection;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.assistant.ICurrency;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.app.DataImportTools;
import com.kingdee.eas.basedata.org.AdminOrgUnitCollection;
import com.kingdee.eas.basedata.org.AdminOrgUnitFactory;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.CtrlUnitCollection;
import com.kingdee.eas.basedata.org.CtrlUnitFactory;
import com.kingdee.eas.basedata.org.CtrlUnitInfo;
import com.kingdee.eas.basedata.org.IAdminOrgUnit;
import com.kingdee.eas.basedata.org.ICompanyOrgUnit;
import com.kingdee.eas.basedata.org.ICtrlUnit;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.IPurchaseOrgUnit;
import com.kingdee.eas.basedata.org.IStorageOrgUnit;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitCollection;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitCollection;
import com.kingdee.eas.basedata.org.StorageOrgUnitFactory;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.person.IPerson;
import com.kingdee.eas.basedata.person.PersonFactory;
import com.kingdee.eas.basedata.person.PersonInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IReasonCode;
import com.kingdee.eas.basedata.scm.common.ReasonCodeCollection;
import com.kingdee.eas.basedata.scm.common.ReasonCodeFactory;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.basedata.scm.im.inv.ILocation;
import com.kingdee.eas.basedata.scm.im.inv.IWarehouse;
import com.kingdee.eas.basedata.scm.im.inv.LocationCollection;
import com.kingdee.eas.basedata.scm.im.inv.LocationFactory;
import com.kingdee.eas.basedata.scm.im.inv.LocationInfo;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseCollection;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseFactory;
import com.kingdee.eas.basedata.scm.im.inv.WarehouseInfo;
import com.kingdee.eas.basedata.scm.sm.pur.PurchaseGroupInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.ICoreBase;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMDataImport;
import com.kingdee.eas.scm.common.util.CalculateUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.StringUtil;
import com.kingdee.eas.scm.im.inv.app.ImportDataCache;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import com.kingdee.eas.scm.sm.pur.app.FilterSqlUtils;
import com.kingdee.eas.scm.sm.pur.util.DataImportUtils;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.util.datetime.DateTimeUtil;
import com.kingdee.eas.tools.datatask.core.TaskExternalException;
import com.kingdee.eas.tools.datatask.runtime.DataToken;
import com.kingdee.eas.util.app.ContextUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.StringUtils;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class PurReturnsDataImport
extends SCMDataImport {
    private static Logger logger = Logger.getLogger(PurReturnsDataImport.class);
    String[] BIGDECIMAL_FIELDS = new String[]{"FExchangeRate", "FTotalAmount", "FTotalTax", "FTotalTaxAmount"};
    String[] BIGDECIMAL_OBJ = new String[]{"exchangeRate", "totalAmount", "totalTax", "totalTaxAmount"};
    String[] STRING_FIELDS = new String[]{"FDescription"};
    String[] STRING_OBJS = new String[]{"description"};
    String[] DATE_FIELDS = new String[]{"FAuditTime", "FBizDate", "FModificationTime", "FCreateTime"};
    String[] DATE_OBJS = new String[]{"auditTime", "bizDate", "modificationTime", "createTime"};
    String[] BOOLEAN_FIELDS = new String[]{"FHasEffected"};
    String[] BOOLEAN_OBJS = new String[]{"hasEffected"};
    String[] ENUM_FIELDS = new String[]{"FEntryBaseStatus"};
    String[] ENUM_OBJS = new String[]{"baseStatus"};
    String[] INTEGER_FIELDS = new String[]{"FYear", "FPeriod"};
    String[] INTEGER_OBJS = new String[]{"year", "period"};
    private static final BigDecimal zero = new BigDecimal("0.00");
    private static final BigDecimal one = new BigDecimal("1.00");
    private static final BigDecimal hundrud = new BigDecimal("100.00");
    String[] BIGDECIMAL_FIELDS_EN = new String[]{"FPrice", "FTaxPrice", "FAmount", "FTaxRate", "FTax", "FTaxAmount", "FQty", "FInvoicedQty", "FInvoicedAmount", "FReturnedQty", "FBaseQty"};
    String[] BIGDECIMAL_OBJ_EN = new String[]{"price", "taxPrice", "amount", "taxRate", "tax", "taxAmount", "qty", "invoicedQty", "invoicedAmount", "returnedQty", "baseQty"};
    String[] STRING_FIELDS_EN = new String[]{"FRemark", "FLot"};
    String[] STRING_OBJS_EN = new String[]{"remark", "lot"};
    String[] DATE_FIELDS_EN = new String[]{"FReturnsDate"};
    String[] DATE_OBJS_EN = new String[]{"returnsDate"};
    String[] BOOLEAN_FIELDS_EN = new String[]{"FIsPresent"};
    String[] BOOLEAN_OBJS_EN = new String[]{"isPresent"};
    String[] ENUM_FIELDS_EN = new String[]{"FEntryBaseStatus"};
    String[] ENUM_OBJS_EN = new String[]{"baseStatus"};
    ImportDataCache dataPool = new ImportDataCache();
    private Map<String, BizTypeInfo> bizTypeMap = new HashMap<String, BizTypeInfo>();
    private Map<String, CompanyOrgUnitInfo> companyBystorageMap = new HashMap<String, CompanyOrgUnitInfo>();
    private Map<String, StorageOrgUnitInfo> storageOrgMap = new HashMap<String, StorageOrgUnitInfo>();
    private Map<String, PurchaseOrgUnitInfo> purOrgMap = new HashMap<String, PurchaseOrgUnitInfo>();
    private Map<String, CurrencyInfo> basecurrencyMap = new HashMap<String, CurrencyInfo>();
    private Map<String, AdminOrgUnitInfo> adminOrgMap = new HashMap<String, AdminOrgUnitInfo>();
    private static final String RESOURCE = "com.kingdee.eas.scm.sm.pur.PurImportExportResource";
    private Map paramMap = new HashMap();

    protected ICoreBase getController(Context ctx) throws TaskExternalException {
        try {
            return PurReturnsFactory.getLocalInstance(ctx);
        }
        catch (BOSException bex) {
            throw new TaskExternalException("", (Throwable)bex);
        }
    }

    public String getImportPermissionItem() {
        return "pureturn_addnew";
    }

    private Object getData(String key, Hashtable hsData) {
        return ((DataToken)hsData.get((Object)key)).data;
    }

    private void checkCoddingRule(Context ctx, String purReturnsID, PurReturnsInfo purReturnsInfo) throws BOSException, SCMBillException, EASBizException {
        ICodingRuleManager iCodingRuleManager = CodingRuleManagerFactory.getLocalInstance((Context)ctx);
        if (!iCodingRuleManager.isExist((IObjectValue)purReturnsInfo, purReturnsID)) {
            throw new SCMBillException(SCMBillException.NOCORDRULE);
        }
        String number = iCodingRuleManager.getNumber((IObjectValue)purReturnsInfo, purReturnsID, "");
        purReturnsInfo.setNumber(number);
    }

    public CoreBaseInfo transmit(Hashtable hsData, Context ctx) throws TaskExternalException {
        PurReturnsInfo purReturnsInfo = new PurReturnsInfo();
        purReturnsInfo.setIsSysBill(false);
        Iterator rowIt1 = hsData.entrySet().iterator();
        Map.Entry entry1 = rowIt1.next();
        Hashtable innerTable1 = (Hashtable)entry1.getValue();
        boolean isImportDataByRule = DataImportUtils.getImportParam(ctx);
        String str = this.getData("FNumber", innerTable1).toString();
        boolean isNumberNull = StringUtil.isEmpty((String)str);
        purReturnsInfo.setNumber(str);
        try {
            this.loadPurchaseOrgUnit(purReturnsInfo, innerTable1, ctx);
            this.doNumber(ctx, purReturnsInfo, hsData);
        }
        catch (Exception e) {
            this.recycleNumber(ctx, purReturnsInfo);
            throw new TaskExternalException(e.getMessage(), (Throwable)e);
        }
        Iterator rowIt = hsData.entrySet().iterator();
        if (rowIt.hasNext()) {
            Map.Entry entry = rowIt.next();
            Hashtable innerTable = (Hashtable)entry.getValue();
            try {
                purReturnsInfo = this.setHeadInfo(ctx, purReturnsInfo, innerTable);
            }
            catch (TaskExternalException e) {
                this.recycleNumber(ctx, purReturnsInfo);
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
        }
        PurReturnsEntryInfo entryInfo = null;
        PurReturnsEntryCollection entryCollection = purReturnsInfo.getEntries();
        int size = hsData.size();
        for (int i = 0; i < size; ++i) {
            Hashtable innerTable = (Hashtable)hsData.get(i);
            entryInfo = new PurReturnsEntryInfo();
            entryInfo.setSeq(i + 1);
            entryInfo.setParent(purReturnsInfo);
            try {
                this.handleEntry(purReturnsInfo, entryInfo, innerTable, ctx);
            }
            catch (TaskExternalException e) {
                this.recycleNumber(ctx, purReturnsInfo);
                throw new TaskExternalException(e.getMessage(), (Throwable)e);
            }
            entryCollection.add(entryInfo);
            this.calEntry(purReturnsInfo, entryInfo);
            entryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
        BillTypeInfo billtype = new BillTypeInfo();
        billtype.setId(BOSUuid.read((String)"50957179-0105-1000-e006-6152c0a812fd463ED552"));
        purReturnsInfo.setBillType(billtype);
        return purReturnsInfo;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadPurchaseOrgUnit(PurReturnsInfo purReturnsInfo, Hashtable hsData, Context ctx) throws TaskExternalException, BOSException {
        Object souData = ((DataToken)hsData.get((Object)"FPurchaseOrgUnitNumber")).data;
        if (souData == null || souData.toString().trim().length() <= 0) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"PURQUOTATION_PUSCHORIG_NOTNULL", (Context)ctx));
        if (this.purOrgMap.containsKey(souData.toString().trim())) {
            purReturnsInfo.setPurchaseOrgUnit(this.purOrgMap.get(souData.toString().trim()));
            return;
        }
        PurchaseOrgUnitInfo info = this.dataPool.getPurchaseOrgUnitInfo(souData.toString().trim());
        UserInfo userInfo = ContextUtil.getCurrentUserInfo((Context)ctx);
        String userInfoID = null;
        if (userInfo != null) {
            userInfoID = userInfo.getId().toString();
        }
        if (info != null) return;
        IPurchaseOrgUnit ipurOrgUnit = PurchaseOrgUnitFactory.getLocalInstance((Context)ctx);
        PurchaseOrgUnitCollection collection = ipurOrgUnit.getPurchaseOrgUnitCollection(this.getFilter(souData.toString().trim()));
        if (collection == null || collection.size() <= 0) throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"PurchaseOrgUnitNotExists", (Context)ctx));
        info = collection.get(0);
        if (info == null) return;
        purReturnsInfo.setPurchaseOrgUnit(info);
        this.purOrgMap.put(souData.toString().trim(), info);
        try {
            if (userInfoID == null) return;
            PermissionFactory.getLocalInstance((Context)ctx).checkFunctionPermission((IObjectPK)new ObjectUuidPK(userInfoID), (IObjectPK)new ObjectUuidPK(info.getId().toString()), "purorder_addnew");
            return;
        }
        catch (EASBizException e) {
            throw new TaskExternalException(e.getMessage());
        }
    }

    private PurReturnsInfo setHeadInfo(Context ctx, PurReturnsInfo purReturnsInfo, Hashtable innerTable1) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        Object value2;
        String str = null;
        for (int i2 = 0; i2 < this.BIGDECIMAL_FIELDS.length; ++i2) {
            try {
                Object o2 = ((DataToken)innerTable1.get((Object)this.BIGDECIMAL_FIELDS[i2])).data;
                if (o2 == null || o2.toString().trim().length() <= 0 || (value2 = new BigDecimal(o2.toString())) == null) continue;
                purReturnsInfo.setBigDecimal(this.BIGDECIMAL_OBJ[i2], (BigDecimal)value2);
                continue;
            }
            catch (NumberFormatException nex) {
                throw new TaskExternalException(this.BIGDECIMAL_OBJ[i2] + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"numberFormatError", (Context)ctx));
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (i = 0; i < this.DATE_FIELDS.length; ++i) {
            o = ((DataToken)innerTable1.get((Object)this.DATE_FIELDS[i])).data;
            if (o == null || o.toString().length() <= 0) continue;
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                throw new TaskExternalException(PurUtil.getServerResource(RESOURCE, "InvalidDateFormat", ctx));
            }
            if (o == null || !(o instanceof Date) || (value = (Date)o) == null) continue;
            purReturnsInfo.setDate(this.DATE_OBJS[i], (Date)value);
        }
        for (i = 0; i < this.BOOLEAN_FIELDS.length; ++i) {
            o = ((DataToken)innerTable1.get((Object)this.BOOLEAN_FIELDS[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            purReturnsInfo.setBoolean(this.BOOLEAN_OBJS[i], this.getBooleanValue((String)value));
        }
        for (i = 0; i < this.STRING_FIELDS.length; ++i) {
            o = ((DataToken)innerTable1.get((Object)this.STRING_FIELDS[i])).data;
            if (o == null) continue;
            value = o.toString();
            if (((String)value).length() > 255) {
                value = ((String)value).substring(0, 255);
            }
            purReturnsInfo.setString(this.STRING_OBJS[i], (String)value);
        }
        for (i = 0; i < this.INTEGER_FIELDS.length; ++i) {
            try {
                o = ((DataToken)innerTable1.get((Object)this.INTEGER_FIELDS[i])).data;
                if (o == null || o.toString().equals("")) continue;
                value = new Integer(o.toString());
                purReturnsInfo.setInt(this.INTEGER_OBJS[i], (Integer)value);
                continue;
            }
            catch (NumberFormatException e) {
                throw new TaskExternalException(this.INTEGER_FIELDS[i] + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"numberFormatError", (Context)ctx));
            }
        }
        Object data = ((DataToken)innerTable1.get((Object)"FBaseStatus")).data;
        value2 = null;
        if (!StringUtils.isEmpty((String)((String)data))) {
            value2 = data.toString();
            if (value2 != null) {
                purReturnsInfo.setBaseStatus(this.getBaseStatusValue((String)value2));
            }
        } else {
            purReturnsInfo.setBaseStatus(BillBaseStatusEnum.TEMPORARILYSAVED);
        }
        try {
            IUser iuser = UserFactory.getLocalInstance((Context)ctx);
            UserInfo userInfo = null;
            data = ((DataToken)innerTable1.get((Object)"FCreatorNumber")).data;
            if (data != null) {
                str = data.toString();
                userInfo = this.getCreator(ctx, data);
                if (userInfo != null) {
                    purReturnsInfo.setCreator(userInfo);
                }
            }
            this.getCu(ctx, purReturnsInfo, innerTable1);
            data = ((DataToken)innerTable1.get((Object)"FAuditorNumber")).data;
            if (data != null && (userInfo = this.getUserFromNumber(iuser, str = data.toString())) != null) {
                purReturnsInfo.setAuditor(userInfo);
            }
            this.doPurchaseOrg(ctx, purReturnsInfo, innerTable1);
            CurrencyInfo localCurrency = null;
            PurchaseOrgUnitInfo purInfo = purReturnsInfo.getPurchaseOrgUnit();
            CompanyOrgUnitInfo comInfo = null;
            if (purInfo != null) {
                if (this.basecurrencyMap.containsKey(purInfo.getId().toString())) {
                    localCurrency = this.basecurrencyMap.get(purInfo.getId().toString());
                    comInfo = (CompanyOrgUnitInfo)purReturnsInfo.get("companyOrgUnit");
                } else {
                    EntityViewInfo ev = new EntityViewInfo();
                    FilterInfo fi = new FilterInfo();
                    fi.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)purInfo.getId().toString()));
                    fi.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)3));
                    fi.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
                    ev.setFilter(fi);
                    IOrgUnitRelation iRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                    OrgUnitRelationCollection relationCol = iRelation.getOrgUnitRelationCollection(ev);
                    if (relationCol != null && relationCol.size() > 0) {
                        String toUnitId = relationCol.get(0).getToUnit().getId().toString();
                        ev = new EntityViewInfo();
                        fi = new FilterInfo();
                        fi.getFilterItems().add(new FilterItemInfo("id", (Object)toUnitId));
                        SelectorItemCollection si = new SelectorItemCollection();
                        si.add(new SelectorItemInfo("id"));
                        si.add(new SelectorItemInfo("baseCurrency.*"));
                        ev.setFilter(fi);
                        ev.setSelector(si);
                        ICompanyOrgUnit icom = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
                        CompanyOrgUnitCollection comCol = icom.getCompanyOrgUnitCollection(ev);
                        if (comCol != null && comCol.size() > 0) {
                            comInfo = comCol.get(0);
                            localCurrency = comInfo.getBaseCurrency();
                            this.basecurrencyMap.put(purInfo.getId().toString(), localCurrency);
                            purReturnsInfo.put("companyOrgUnit", comInfo);
                        }
                    }
                }
            }
            this.doCurrency(ctx, purReturnsInfo, innerTable1, localCurrency);
            this.doExchangeRate(ctx, purReturnsInfo, innerTable1, localCurrency, comInfo);
            this.doSupplier(ctx, purReturnsInfo, innerTable1);
            this.doPurGroup(ctx, purReturnsInfo, innerTable1);
            this.doPurchasePerson(ctx, purReturnsInfo, innerTable1);
            str = this.doAdminOrgUnit(ctx, purReturnsInfo, innerTable1, str);
            this.doBizType(ctx, purReturnsInfo, innerTable1);
            data = ((DataToken)innerTable1.get((Object)"FModifierNumber")).data;
            if (data != null && (userInfo = this.getUserFromNumber(iuser, str = data.toString())) != null) {
                purReturnsInfo.setModifier(userInfo);
            }
        }
        catch (Exception e) {
            throw new TaskExternalException(e.getMessage());
        }
        data = this.getData("FIsInTax", innerTable1);
        purReturnsInfo.setIsInTax(this.getBooleanValue(data.toString(), ctx));
        Date day = new Date();
        purReturnsInfo.setCreateTime(new Timestamp(day.getTime()));
        return purReturnsInfo;
    }

    public void doBizType(Context ctx, PurReturnsInfo purReturnsInfo, Hashtable innerTable1) throws TaskExternalException {
        Object data = ((DataToken)innerTable1.get((Object)"FBizTypeNumber")).data;
        BizTypeInfo bizType = this.getBizType(ctx, "50957179-0105-1000-e006-6152c0a812fd463ED552", "number", data);
        purReturnsInfo.setBizType(bizType);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String doAdminOrgUnit(Context ctx, PurReturnsInfo purReturnsInfo, Hashtable innerTable1, String str) throws BOSException, EASBizException, TaskExternalException {
        int i;
        Object data = ((DataToken)innerTable1.get((Object)"FAdminOrgUnitNumber")).data;
        if (purReturnsInfo.getPurchasePerson() != null) {
            if (!this.paramMap.containsValue("PURORDER001")) {
                this.paramMap = ParamControlFactory.getLocalInstance((Context)ctx).getParamHashMap(new String[]{"PURORDER001"}, purReturnsInfo.getPurchaseOrgUnit().getId().toString());
            }
            if (this.isIntPurParam("PURORDER001", 0, 0, this.paramMap)) {
                IPerson iPerson = PersonFactory.getLocalInstance((Context)ctx);
                AdminOrgUnitInfo adminOrgUnitInfo = iPerson.getPrimaryAdminOrgUnit(purReturnsInfo.getPurchasePerson().getId());
                purReturnsInfo.setAdminOrgUnit(adminOrgUnitInfo);
            } else {
                purReturnsInfo.setAdminOrgUnit(null);
                HashSet<String> orgIdSet = new HashSet<String>();
                IOrgUnitRelation iour = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
                OrgUnitCollection ioc = iour.getToUnit(purReturnsInfo.getPurchaseOrgUnit().getId().toString(), 3, 0);
                if (ioc != null && ioc.size() > 0) {
                    for (i = 0; i < ioc.size(); ++i) {
                        orgIdSet.add(ioc.get(i).getNumber().toString());
                    }
                }
                if (orgIdSet.contains(data.toString())) {
                    purReturnsInfo.setAdminOrgUnit((AdminOrgUnitInfo)ioc.get(data));
                } else {
                    purReturnsInfo.setAdminOrgUnit((AdminOrgUnitInfo)ioc.get(0));
                }
            }
        }
        if (data == null || StringUtil.isEmpty((String)data.toString()) || purReturnsInfo.getAdminOrgUnit() != null) return str;
        str = data.toString();
        if (this.adminOrgMap.containsKey(str)) {
            purReturnsInfo.setAdminOrgUnit(this.adminOrgMap.get(str));
            return str;
        } else {
            IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitCollection orgUnitCollection = iOrgUnitRelation.getToUnit(purReturnsInfo.getPurchaseOrgUnit().getId().toString(), 3, 0);
            HashSet<String> orgIdSet = new HashSet<String>();
            if (orgUnitCollection == null || orgUnitCollection.size() <= 0) throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"purRelationAdmin", (Context)ctx));
            for (i = 0; i < orgUnitCollection.size(); ++i) {
                orgIdSet.add(orgUnitCollection.get(i).getId().toString());
            }
            IAdminOrgUnit iadminOrgUnit = AdminOrgUnitFactory.getLocalInstance((Context)ctx);
            AdminOrgUnitCollection collection = iadminOrgUnit.getAdminOrgUnitCollection(this.getFilterForAdmin(data.toString().trim(), orgIdSet));
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"AdminOrgUnitNotExists", (Context)ctx));
            AdminOrgUnitInfo info = collection.get(0);
            if (info == null) return str;
            purReturnsInfo.setAdminOrgUnit(info);
            this.adminOrgMap.put(str, info);
        }
        return str;
    }

    public void doPurchasePerson(Context ctx, PurReturnsInfo purReturnsInfo, Hashtable innerTable1) throws TaskExternalException {
        Object data = ((DataToken)innerTable1.get((Object)"FPurPersonNumber")).data;
        PersonInfo purchasePerson = this.getPurchasePerson(ctx, "number", purReturnsInfo.getPurchaseGroup(), data);
        purReturnsInfo.setPurchasePerson(purchasePerson);
    }

    public void doPurGroup(Context ctx, PurReturnsInfo purReturnsInfo, Hashtable innerTable1) throws TaskExternalException {
        Object data = ((DataToken)innerTable1.get((Object)"FPurGroupNumber")).data;
        PurchaseGroupInfo info = this.getPurchaseGroup(ctx, "number", purReturnsInfo.getPurchaseOrgUnit(), data, true);
        purReturnsInfo.setPurchaseGroup(info);
    }

    public void doSupplier(Context ctx, PurReturnsInfo purReturnsInfo, Hashtable innerTable1) throws TaskExternalException {
        Object data = ((DataToken)innerTable1.get((Object)"FSupplierNumber")).data;
        SupplierInfo supplierInfo = this.getSupplier(ctx, "number", data);
        purReturnsInfo.setSupplier(supplierInfo);
    }

    public void doExchangeRate(Context ctx, PurReturnsInfo purReturnsInfo, Hashtable innerTable1, CurrencyInfo localCurrency, CompanyOrgUnitInfo comInfo) throws TaskExternalException, EASBizException, BOSException {
        String str = ((DataToken)innerTable1.get((Object)"FExchangeRate")).data.toString();
        if (purReturnsInfo.getCurrency().getId().toString().equals(localCurrency.getId().toString())) {
            purReturnsInfo.setExchangeRate(BigDecimal.ONE);
        } else {
            if (StringUtil.isEmpty((String)str)) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"ExchangeRateNotExists", (Context)ctx));
            }
            try {
                ExchangeRateInfo exchangeRateInfo = this.getExchangeRate(ctx, comInfo, (IObjectPK)new ObjectUuidPK(localCurrency.getId().toString()), (IObjectPK)new ObjectUuidPK(purReturnsInfo.getCurrency().getId().toString()));
                int precision = purReturnsInfo.getCurrency().getPrecision();
                if (exchangeRateInfo != null) {
                    purReturnsInfo.setConvertMode(exchangeRateInfo.getConvertMode());
                    precision = exchangeRateInfo.getPrecision();
                }
                purReturnsInfo.setExchangeRate(new BigDecimal(str).setScale(precision, RoundingMode.HALF_UP));
            }
            catch (NumberFormatException e) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"ExchangeRateNotExists", (Context)ctx));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doCurrency(Context ctx, PurReturnsInfo purReturnsInfo, Hashtable innerTable1, CurrencyInfo localCurrency) throws BOSException, TaskExternalException {
        Object data = ((DataToken)innerTable1.get((Object)"FCurrencyNumber")).data;
        if (data != null) {
            String str = data.toString();
            if (str != null && str.trim().length() > 0) {
                ICurrency icurreny = CurrencyFactory.getLocalInstance((Context)ctx);
                CurrencyCollection collection = icurreny.getCurrencyCollection("where number='" + str + "'");
                if (collection == null || collection.size() <= 0) throw new TaskExternalException(str + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"CurrencyNotExists", (Context)ctx));
                CurrencyInfo info = collection.get(0);
                if (info == null) return;
                purReturnsInfo.setCurrency(info);
                return;
            } else {
                purReturnsInfo.setCurrency(localCurrency);
                purReturnsInfo.setExchangeRate(BigDecimal.ONE);
            }
            return;
        } else {
            purReturnsInfo.setCurrency(localCurrency);
        }
    }

    public void doPurchaseOrg(Context ctx, PurReturnsInfo purReturnsInfo, Hashtable innerTable1) throws TaskExternalException {
        Object data = ((DataToken)innerTable1.get((Object)"FPurchaseOrgUnitNumber")).data;
        PurchaseOrgUnitInfo info = this.getPurchaseOrgUnit(ctx, "number", data);
        purReturnsInfo.setPurchaseOrgUnit(info);
    }

    public void getCu(Context ctx, PurReturnsInfo purReturnsInfo, Hashtable innerTable1) throws BOSException {
        CtrlUnitInfo cuinfo;
        ICtrlUnit ictrlUnit;
        CtrlUnitCollection cuCollection;
        String str;
        Object data = ((DataToken)innerTable1.get((Object)"FControlUnitNumber")).data;
        if (data != null && (str = ((DataToken)innerTable1.get((Object)"FControlUnitNumber")).data.toString()) != null && str.length() > 0 && (cuCollection = (ictrlUnit = CtrlUnitFactory.getLocalInstance((Context)ctx)).getCtrlUnitCollection("where number='" + str + "'")) != null && cuCollection.size() > 0 && (cuinfo = cuCollection.get(0)) != null) {
            purReturnsInfo.setCU(cuinfo);
        }
    }

    private boolean getBooleanValue(String value, Context ctx) throws TaskExternalException {
        return (value = value.trim()).equals(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurUIResource", "yes", ctx)) || value.equalsIgnoreCase("true") || value.equalsIgnoreCase("yes") || value.equalsIgnoreCase("1");
    }

    private void calEntry(PurReturnsInfo purReturnsInfo, PurReturnsEntryInfo entryInfo) {
        boolean isInTax = purReturnsInfo.isIsInTax();
        if (isInTax) {
            entryInfo.setTaxPrice(entryInfo.getTaxPrice().setScale(this.getPricePre(entryInfo), 4));
            this.calEntryPriceByTaxPrice(purReturnsInfo, entryInfo);
            this.calEntryTaxAmount(purReturnsInfo, entryInfo);
            this.calEntryTax(purReturnsInfo, entryInfo);
            this.calEntryAmount(purReturnsInfo, entryInfo);
        } else {
            entryInfo.setPrice(entryInfo.getPrice().setScale(this.getPricePre(entryInfo), 4));
            this.calEntryTaxPricebyPrice(purReturnsInfo, entryInfo);
            this.calEntryAmount(purReturnsInfo, entryInfo);
            this.calEntryTax(purReturnsInfo, entryInfo);
            this.calEntryTaxAmount(purReturnsInfo, entryInfo);
        }
        this.calEntryLocalValue(purReturnsInfo, entryInfo);
        this.calTotalAmount(purReturnsInfo);
        this.calTotalTax(purReturnsInfo);
        this.calTotalTaxAmount(purReturnsInfo);
        this.calTotalValue(purReturnsInfo);
    }

    protected void calTotalValue(PurReturnsInfo purReturnsInfo) {
        BigDecimal localTotalAmount = zero;
        BigDecimal localTotalTaxAmount = zero;
        BigDecimal localTotalTax = zero;
        int count = purReturnsInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purReturnsInfo.getEntries().get(index).getAmount() != null) {
                localTotalAmount = localTotalAmount.add(purReturnsInfo.getEntries().get(index).getAmount());
            }
            if (purReturnsInfo.getEntries().get(index).getTaxAmount() != null) {
                localTotalTaxAmount = localTotalTaxAmount.add(purReturnsInfo.getEntries().get(index).getTaxAmount());
            }
            if (purReturnsInfo.getEntries().get(index).getTax() == null) continue;
            localTotalTax = localTotalTax.add(purReturnsInfo.getEntries().get(index).getTax());
        }
        purReturnsInfo.setLocalTotalAmount(localTotalAmount);
        purReturnsInfo.setLocalTotalTaxAmount(localTotalTaxAmount);
        purReturnsInfo.setLocalTotalTax(localTotalTax);
    }

    protected void calTotalAmount(PurReturnsInfo purReturnsInfo) {
        BigDecimal totalAmount = zero;
        int count = purReturnsInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purReturnsInfo.getEntries().get(index).getAmount() == null) continue;
            totalAmount = totalAmount.add(purReturnsInfo.getEntries().get(index).getAmount());
        }
        purReturnsInfo.setTotalAmount(totalAmount);
    }

    protected void calTotalTax(PurReturnsInfo purReturnsInfo) {
        BigDecimal totalTax = zero;
        int count = purReturnsInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purReturnsInfo.getEntries().get(index).getTax() == null) continue;
            totalTax = totalTax.add(purReturnsInfo.getEntries().get(index).getTax());
        }
        purReturnsInfo.setTotalTax(totalTax);
    }

    protected void calTotalTaxAmount(PurReturnsInfo purReturnsInfo) {
        BigDecimal totalTaxAmount = zero;
        int count = purReturnsInfo.getEntries().size();
        for (int index = 0; index < count; ++index) {
            if (purReturnsInfo.getEntries().get(index).getTaxAmount() == null) continue;
            totalTaxAmount = totalTaxAmount.add(purReturnsInfo.getEntries().get(index).getTaxAmount());
        }
        purReturnsInfo.setTotalTaxAmount(totalTaxAmount);
    }

    protected void calEntryLocalValue(PurReturnsInfo purReturnsInfo, PurReturnsEntryInfo entryInfo) {
        BigDecimal entryLocalAmount = zero;
        BigDecimal entryLocalTax = zero;
        BigDecimal entryLocalTaxAmount = zero;
        int currencyPrecision = 2;
        if (purReturnsInfo.getCurrency() != null) {
            currencyPrecision = purReturnsInfo.getCurrency().getPrecision();
        }
        BigDecimal amount = entryInfo.getAmount();
        BigDecimal tax = entryInfo.getTax();
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        BigDecimal exchangeRate = purReturnsInfo.getExchangeRate();
        ConvertModeEnum convertMode = purReturnsInfo.getConvertMode();
        if (amount != null && SysConstant.BIGZERO.compareTo(exchangeRate) != 0) {
            if (convertMode != null && convertMode == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entryLocalAmount = amount.multiply(exchangeRate).setScale(currencyPrecision, 4);
                entryLocalTax = tax.multiply(exchangeRate).setScale(currencyPrecision, 4);
                entryLocalTaxAmount = taxAmount.multiply(exchangeRate).setScale(currencyPrecision, 4);
            } else if (SysConstant.BIGZERO.compareTo(exchangeRate) != 0) {
                entryLocalAmount = amount.divide(exchangeRate, currencyPrecision, 4);
                entryLocalTax = tax.divide(exchangeRate, currencyPrecision, 4);
                entryLocalTaxAmount = taxAmount.divide(exchangeRate, currencyPrecision, 4);
            }
        }
        entryInfo.setLocalAmount(entryLocalAmount);
        entryInfo.setLocalTax(entryLocalTax);
        entryInfo.setLocalTaxAmount(entryLocalTaxAmount);
    }

    protected void calEntryTaxPricebyPrice(PurReturnsInfo purReturnsInfo, PurReturnsEntryInfo entryInfo) {
        BigDecimal price = entryInfo.getPrice();
        BigDecimal taxRate = entryInfo.getTaxRate();
        int materialPricePrecision = 2;
        if (entryInfo.getMaterial() != null) {
            materialPricePrecision = entryInfo.getMaterial().getPricePrecision();
        }
        BigDecimal taxPrice = CalculateUtils.calTaxPrice((BigDecimal)price, (BigDecimal)taxRate, (int)materialPricePrecision);
        entryInfo.setTaxPrice(taxPrice);
    }

    private int getPricePre(PurReturnsEntryInfo entryInfo) {
        int materialPricePrecision = 2;
        if (entryInfo.getMaterial() != null) {
            materialPricePrecision = entryInfo.getMaterial().getPricePrecision();
        }
        return materialPricePrecision;
    }

    protected void calEntryPriceByTaxPrice(PurReturnsInfo purReturnsInfo, PurReturnsEntryInfo entryInfo) {
        boolean isInTax = purReturnsInfo.isIsInTax();
        BigDecimal price = entryInfo.getPrice();
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        BigDecimal taxRate = entryInfo.getTaxRate();
        int materialPricePrecision = this.getPricePre(entryInfo);
        if (isInTax) {
            price = CalculateUtils.calPrice((BigDecimal)taxPrice, (BigDecimal)taxRate, (int)materialPricePrecision);
        }
        entryInfo.setPrice(price);
    }

    protected void calEntryTaxAmount(PurReturnsInfo purReturnsInfo, PurReturnsEntryInfo entryInfo) {
        boolean isInTax = purReturnsInfo.isIsInTax();
        BigDecimal taxPrice = entryInfo.getTaxPrice();
        BigDecimal amount = entryInfo.getAmount();
        BigDecimal taxAmount = zero;
        BigDecimal tax = entryInfo.getTax();
        BigDecimal returnsQty = entryInfo.getQty();
        int currencyPrecision = 2;
        if (purReturnsInfo.getCurrency() != null) {
            currencyPrecision = purReturnsInfo.getCurrency().getPrecision();
        }
        if (!isInTax) {
            amount = amount == null ? zero : amount;
            tax = tax == null ? zero : tax;
            taxAmount = amount.add(tax).setScale(currencyPrecision, 4);
            entryInfo.setTaxAmount(taxAmount);
        } else {
            returnsQty = returnsQty == null ? zero : returnsQty;
            taxPrice = taxPrice == null ? zero : taxPrice;
            taxAmount = taxPrice.multiply(returnsQty).setScale(currencyPrecision, 4);
            entryInfo.setTaxAmount(taxAmount);
        }
    }

    protected void calEntryTax(PurReturnsInfo purReturnsInfo, PurReturnsEntryInfo entryInfo) {
        boolean isInTax = purReturnsInfo.isIsInTax();
        BigDecimal amount = entryInfo.getAmount();
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        BigDecimal taxRate = entryInfo.getTaxRate();
        BigDecimal tax = zero;
        int currencyPrecision = 2;
        if (purReturnsInfo.getCurrency() != null) {
            currencyPrecision = purReturnsInfo.getCurrency().getPrecision();
        }
        if (!isInTax) {
            amount = amount == null ? zero : amount;
            taxRate = taxRate == null ? zero : taxRate.divide(hundrud, 10, 4);
            tax = amount.multiply(taxRate).setScale(currencyPrecision, 4);
            entryInfo.setTax(tax);
        } else {
            taxAmount = taxAmount == null ? zero : taxAmount;
            taxRate = taxRate == null ? zero : taxRate.divide(hundrud, 10, 4);
            tax = taxAmount.multiply(taxRate).divide(taxRate.add(one), 4);
            entryInfo.setTax(tax);
        }
    }

    protected void calEntryAmount(PurReturnsInfo purReturnsInfo, PurReturnsEntryInfo entryInfo) {
        boolean isInTax = purReturnsInfo.isIsInTax();
        BigDecimal returnsQty = entryInfo.getQty();
        BigDecimal price = entryInfo.getPrice();
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        BigDecimal tax = entryInfo.getTax();
        BigDecimal amount = zero;
        int currencyPrecision = 2;
        if (purReturnsInfo.getCurrency() != null) {
            currencyPrecision = purReturnsInfo.getCurrency().getPrecision();
        }
        if (!isInTax) {
            returnsQty = returnsQty == null ? zero : returnsQty;
            price = price == null ? zero : price;
            amount = price.multiply(returnsQty).setScale(currencyPrecision, 4);
            entryInfo.setAmount(amount);
        } else {
            taxAmount = taxAmount == null ? zero : taxAmount;
            tax = tax == null ? zero : tax;
            amount = taxAmount.subtract(tax).setScale(currencyPrecision, 4);
            entryInfo.setAmount(amount);
        }
    }

    private void handleEntry(PurReturnsInfo purReturnsInfo, PurReturnsEntryInfo entryInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        Object value;
        Object o;
        int i;
        Object value2;
        boolean isInTax = purReturnsInfo.isIsInTax();
        for (int i2 = 0; i2 < this.BIGDECIMAL_FIELDS_EN.length; ++i2) {
            try {
                Object o2 = ((DataToken)hsData.get((Object)this.BIGDECIMAL_FIELDS_EN[i2])).data;
                if (isInTax && this.BIGDECIMAL_FIELDS_EN[i2].equalsIgnoreCase("FTaxPrice") && (o2 == null || o2.toString().trim().length() <= 0)) {
                    throw new TaskExternalException(this.BIGDECIMAL_OBJ_EN[i2] + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"TAXPRICE", (Context)ctx));
                }
                if (!isInTax && this.BIGDECIMAL_FIELDS_EN[i2].equalsIgnoreCase("FPrice") && (o2 == null || o2.toString().trim().length() <= 0)) {
                    throw new TaskExternalException(this.BIGDECIMAL_OBJ_EN[i2] + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"PRICE_NULL", (Context)ctx));
                }
                if (o2 == null || o2.toString().trim().length() <= 0 || (value2 = new BigDecimal(o2.toString())) == null) continue;
                entryInfo.setBigDecimal(this.BIGDECIMAL_OBJ_EN[i2], (BigDecimal)value2);
                continue;
            }
            catch (NumberFormatException nex) {
                throw new TaskExternalException(this.BIGDECIMAL_OBJ_EN[i2] + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"numberFormatError", (Context)ctx));
            }
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd");
        for (i = 0; i < this.DATE_FIELDS_EN.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.DATE_FIELDS_EN[i])).data;
            if (o == null || o.toString().length() <= 0) continue;
            try {
                o = df.parse(o.toString());
            }
            catch (ParseException pex) {
                throw new TaskExternalException(PurUtil.getServerResource(RESOURCE, "InvalidDateFormat", ctx));
            }
            if (o == null || !(o instanceof Date) || (value = (Date)o) == null) continue;
            entryInfo.setDate(this.DATE_OBJS_EN[i], (Date)value);
        }
        for (i = 0; i < this.BOOLEAN_FIELDS_EN.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.BOOLEAN_FIELDS_EN[i])).data;
            if (o == null || o.toString().trim().length() <= 0 || (value = o.toString()) == null) continue;
            entryInfo.setBoolean(this.BOOLEAN_OBJS_EN[i], this.getBooleanValue((String)value));
        }
        for (i = 0; i < this.STRING_FIELDS_EN.length; ++i) {
            o = ((DataToken)hsData.get((Object)this.STRING_FIELDS_EN[i])).data;
            if (o == null) continue;
            value = o.toString();
            if (this.STRING_OBJS_EN[i].equalsIgnoreCase("lot") && ((String)value).length() > 80) {
                throw new TaskExternalException(SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"LOT_LENTH_OVER", (Context)ctx));
            }
            if (!StringUtil.isEmpty((String)value) && ((String)value).length() > 255) {
                value = ((String)value).substring(0, 255);
            }
            entryInfo.setString(this.STRING_OBJS_EN[i], (String)value);
        }
        Object data = ((DataToken)hsData.get((Object)"FEntryBaseStatus")).data;
        value2 = null;
        if (!StringUtils.isEmpty((String)((String)data))) {
            value2 = data.toString();
            if (value2 != null) {
                entryInfo.setBaseStatus(this.getEntryBaseStatusValue((String)value2));
            }
        } else {
            entryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
        }
        try {
            String str = null;
            this.doMaterial(purReturnsInfo, entryInfo, hsData, ctx);
            this.doUnit(entryInfo, hsData, ctx);
            this.doAssistProperty(entryInfo, hsData, ctx);
            this.doReturnsReason(entryInfo, hsData, ctx);
            str = this.doReasonCode(entryInfo, hsData, ctx, str);
            this.doStorageOrgUnit(entryInfo, hsData, ctx, str);
            this.doWarhouse(entryInfo, hsData, ctx);
            this.doLocation(entryInfo, hsData, ctx);
        }
        catch (Exception ex) {
            throw new TaskExternalException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void doLocation(PurReturnsEntryInfo entryInfo, Hashtable hsData, Context ctx) throws BOSException {
        String str;
        Object data = ((DataToken)hsData.get((Object)"FLocationNumber")).data;
        if (data != null && entryInfo.getWarehouse() != null && entryInfo.getWarehouse().isHasLocation() && (str = data.toString()) != null && str.trim().length() > 0) {
            if (this.dataPool.getLocation(str + entryInfo.getWarehouse().getId().toString()) == null) {
                LocationInfo info;
                ILocation iLocation = LocationFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("Warehouse.id", (Object)entryInfo.getWarehouse().getId().toString(), CompareType.EQUALS));
                viewInfo.setFilter(filter);
                LocationCollection collection = iLocation.getLocationCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    entryInfo.setLocation(info);
                    this.dataPool.setLocation(str + entryInfo.getWarehouse().getId().toString(), info);
                }
            } else {
                entryInfo.setLocation(this.dataPool.getLocation(str + entryInfo.getWarehouse().getId().toString()));
            }
        }
    }

    public void doWarhouse(PurReturnsEntryInfo entryInfo, Hashtable hsData, Context ctx) throws BOSException {
        String str;
        Object data = ((DataToken)hsData.get((Object)"FWarehouseNumber")).data;
        if (data != null && entryInfo.getStorageOrgUnit() != null && (str = data.toString()) != null && str.trim().length() > 0) {
            if (this.dataPool.getWarehouseInfo(str + entryInfo.getStorageOrgUnit().getId().toString()) == null) {
                WarehouseInfo info;
                IWarehouse iWarehouse = WarehouseFactory.getLocalInstance((Context)ctx);
                EntityViewInfo viewInfo = new EntityViewInfo();
                FilterInfo filter = new FilterInfo();
                filter.getFilterItems().add(new FilterItemInfo("number", (Object)str, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("storageOrg.id", (Object)entryInfo.getStorageOrgUnit().getId().toString(), CompareType.EQUALS));
                viewInfo.setFilter(filter);
                WarehouseCollection collection = iWarehouse.getWarehouseCollection(viewInfo);
                if (collection != null && collection.size() > 0 && (info = collection.get(0)) != null) {
                    entryInfo.setWarehouse(info);
                    this.dataPool.setWarehouseInfo(str + entryInfo.getStorageOrgUnit().getId().toString(), info);
                }
            } else {
                entryInfo.setWarehouse(this.dataPool.getWarehouseInfo(str + entryInfo.getStorageOrgUnit().getId().toString()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void doStorageOrgUnit(PurReturnsEntryInfo entryInfo, Hashtable hsData, Context ctx, String str) throws BOSException, TaskExternalException {
        Object data = ((DataToken)hsData.get((Object)"FStorageOrgUnitNumber")).data;
        if (data == null || StringUtil.isEmpty((String)data.toString())) throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"StorageOrgUnitNotExists", (Context)ctx));
        str = data.toString();
        if (this.storageOrgMap.containsKey(str)) {
            entryInfo.setStorageOrgUnit(this.storageOrgMap.get(str));
            entryInfo.setCompanyOrgUnit(this.companyBystorageMap.get(str));
            return;
        } else {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            IStorageOrgUnit istorageUnit = StorageOrgUnitFactory.getLocalInstance((Context)ctx);
            StorageOrgUnitCollection collection = istorageUnit.getStorageOrgUnitCollection(this.getFilter(data.toString().trim(), sic));
            if (collection == null || collection.size() <= 0) throw new TaskExternalException(str + " " + SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"StorageOrgUnitNotExists", (Context)ctx));
            StorageOrgUnitInfo info = collection.get(0);
            if (info == null) return;
            entryInfo.setStorageOrgUnit(info);
            this.storageOrgMap.put(str, info);
            EntityViewInfo ev = new EntityViewInfo();
            FilterInfo fi = new FilterInfo();
            fi.getFilterItems().add(new FilterItemInfo("fromUnit.id", (Object)info.getId().toString()));
            fi.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)4));
            fi.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)1));
            ev.setFilter(fi);
            IOrgUnitRelation iRelation = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
            OrgUnitRelationCollection relationCol = iRelation.getOrgUnitRelationCollection(ev);
            if (relationCol == null || relationCol.size() <= 0) return;
            String toUnitId = relationCol.get(0).getToUnit().getId().toString();
            ICompanyOrgUnit icom = CompanyOrgUnitFactory.getLocalInstance((Context)ctx);
            CompanyOrgUnitCollection comCol = icom.getCompanyOrgUnitCollection("where id = '" + toUnitId + "'");
            if (comCol == null || comCol.size() <= 0) return;
            entryInfo.setCompanyOrgUnit(comCol.get(0));
            this.companyBystorageMap.put(str, comCol.get(0));
        }
    }

    public String doReasonCode(PurReturnsEntryInfo entryInfo, Hashtable hsData, Context ctx, String str) throws BOSException {
        ReasonCodeInfo info;
        IReasonCode iReasonCode;
        ReasonCodeCollection collection;
        Object data = ((DataToken)hsData.get((Object)"FReasonCodeNumber")).data;
        if (data != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iReasonCode = ReasonCodeFactory.getLocalInstance((Context)ctx)).getReasonCodeCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
            entryInfo.setReasonCode(info);
        }
        return str;
    }

    public void doReturnsReason(PurReturnsEntryInfo entryInfo, Hashtable hsData, Context ctx) throws BOSException {
        ReasonCodeInfo info;
        IReasonCode iReasonCode;
        ReasonCodeCollection collection;
        String str;
        Object data = ((DataToken)hsData.get((Object)"FReturnsReasonNumber")).data;
        if (data != null && (str = data.toString()) != null && str.trim().length() > 0 && (collection = (iReasonCode = ReasonCodeFactory.getLocalInstance((Context)ctx)).getReasonCodeCollection("where number='" + str + "'")) != null && collection.size() > 0 && (info = collection.get(0)) != null) {
            entryInfo.setReturnsReason(info);
        }
    }

    public void doAssistProperty(PurReturnsEntryInfo entryInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        Object data = ((DataToken)hsData.get((Object)"FAssistPropertyNumber")).data;
        if (data != null && entryInfo.getMaterial() != null && entryInfo.getMaterial().getAssistAttr() != null) {
            MaterialInfo material = entryInfo.getMaterial();
            AsstAttrValueInfo info = this.getAsstAttr(ctx, data, material.getAssistAttr());
            entryInfo.setAssistProperty(info);
        }
    }

    public void doUnit(PurReturnsEntryInfo entryInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        Object data = ((DataToken)hsData.get((Object)"FUnitNumber")).data;
        MeasureUnitInfo unitInfo = this.getMeasureUnit(ctx, data, entryInfo.getMaterial());
        entryInfo.setUnit(unitInfo);
    }

    public void doMaterial(PurReturnsInfo purReturnsInfo, PurReturnsEntryInfo entryInfo, Hashtable hsData, Context ctx) throws TaskExternalException {
        Object data = ((DataToken)hsData.get((Object)"FMaterialNumber")).data;
        MaterialInfo info = this.getMaterial(ctx, "number", data, new OrgUnitInfo[]{purReturnsInfo.getPurchaseOrgUnit(), entryInfo.getStorageOrgUnit()});
        if (null != info && !UsedStatusEnum.APPROVED.equals((Object)info.getStatus())) {
            throw new TaskExternalException(PurUtil.getServerResource("com.kingdee.eas.scm.sm.pur.PurBizResource", "MATERIAL_NOT_APPROVED", new String[]{data.toString()}, ctx));
        }
        if (info != null) {
            entryInfo.setMaterial(info);
            entryInfo.setBaseUnit(info.getBaseUnit());
            entryInfo.setAssistUnit(info.getAssistUnit());
        }
    }

    private EntityViewInfo getFilter(String number, SelectorItemCollection sic) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (sic != null) {
            viewInfo.setSelector(sic);
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private EntityViewInfo getbizTypeFilter(String number, SelectorItemCollection sic) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        if (sic != null) {
            viewInfo.setSelector(sic);
        }
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)"select FBizTypeID from T_SCM_BillBizType where FBillTypeID ='50957179-0105-1000-e006-6152c0a812fd463ED552'", CompareType.INNER));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private boolean getBooleanValue(String str) {
        if (StringUtils.isEmpty((String)str)) {
            return false;
        }
        return (str = str.trim()).equals("Y") || str.equals("1") || str.equalsIgnoreCase("true");
    }

    private BillBaseStatusEnum getBaseStatusValue(String value) {
        BillBaseStatusEnum tSaved = BillBaseStatusEnum.TEMPORARILYSAVED;
        if (!StringUtils.isEmpty((String)value)) {
            value = value.trim();
            List EnumList = BillBaseStatusEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                BillBaseStatusEnum enumList = (BillBaseStatusEnum)EnumList.get(i);
                String enumValue = String.valueOf(enumList.getValue());
                String enumName = enumList.getName();
                String enumAlias = enumList.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = enumList;
                break;
            }
        }
        return tSaved;
    }

    private EntryBaseStatusEnum getEntryBaseStatusValue(String value) {
        EntryBaseStatusEnum tSaved = EntryBaseStatusEnum.TEMPORARILYSAVED;
        if (value != null) {
            value = value.trim();
            List EnumList = EntryBaseStatusEnum.getEnumList();
            int num = EnumList.size();
            for (int i = 0; i < num; ++i) {
                EntryBaseStatusEnum enumList = (EntryBaseStatusEnum)EnumList.get(i);
                String enumValue = String.valueOf(enumList.getValue());
                String enumName = enumList.getName();
                String enumAlias = enumList.getAlias();
                if (!enumValue.equalsIgnoreCase(value) && !enumName.equalsIgnoreCase(value) && !enumAlias.equalsIgnoreCase(value)) continue;
                tSaved = enumList;
                break;
            }
        }
        return tSaved;
    }

    private UserInfo getUserFromNumber(IUser iuser, String number) throws BOSException {
        UserCollection users;
        UserInfo userInfo = null;
        if (number != null && number.trim().length() > 0 && (users = iuser.getUserCollection("where number='" + number + "'")) != null && users.size() > 0) {
            userInfo = users.get(0);
        }
        return userInfo;
    }

    public boolean isSameBlock(Hashtable firstData, Hashtable currentData) {
        DataToken fndt = (DataToken)firstData.get("FNumber");
        String firstNumber = (String)fndt.data;
        DataToken ctdt = (DataToken)currentData.get("FNumber");
        String currentFnumber = (String)ctdt.data;
        if (firstData != null && currentData != null && firstNumber.equals(currentFnumber)) {
            return true;
        }
        return firstData != null && currentData != null && (currentFnumber == null || currentFnumber.length() == 0);
    }

    public int getSubmitType() {
        return 1;
    }

    public FilterInfo getExportFilterForQuery(Context ctx) {
        FilterInfo filterInfo;
        block10: {
            String filterItmesStr = (String)this.getContextMap().get("filterItems");
            filterInfo = null;
            if (filterItmesStr != null) {
                SqlExpr sqlExpr = null;
                try {
                    if (filterItmesStr.contains("{\"subject\"")) {
                        String filterItems = FilterSqlUtils.getFilterItems(ctx, filterItmesStr);
                        filterInfo = new FilterInfo(filterItems);
                        break block10;
                    }
                    sqlExpr = ViewParseUtils.parseFilterExpr((String)filterItmesStr);
                    filterInfo = new FilterInfo(sqlExpr);
                }
                catch (Exception e) {
                    logger.error((Object)e);
                }
            } else {
                filterInfo = new FilterInfo();
                CtrlUnitInfo cuInfo = ContextUtil.getCurrentCtrlUnit((Context)ctx);
                if (cuInfo == null) {
                    return filterInfo;
                }
                filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)cuInfo.getId().toString(), CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"11111111-1111-1111-1111-111111111111CCE7AED4", CompareType.EQUALS));
                filterInfo.getFilterItems().add(new FilterItemInfo("CU.id", (Object)"00000000-0000-0000-0000-000000000000CCE7AED4", CompareType.EQUALS));
                filterInfo.setMaskString("#0 or #1 or #2");
                Object parameter = this.getContextParameter("entries.id");
                if (parameter != null) {
                    filterInfo.getFilterItems().add(new FilterItemInfo("entries.id", parameter, CompareType.INCLUDE));
                }
            }
        }
        FilterInfo oldFilterInfo = (FilterInfo)this.getContextParameter("filter");
        if (filterInfo != null) {
            try {
                oldFilterInfo.mergeFilter(filterInfo, "and");
            }
            catch (BOSException e) {
                logger.error((Object)e);
            }
        }
        return oldFilterInfo;
    }

    public ExchangeRateInfo getExchangeRate(Context ctx, CompanyOrgUnitInfo companyOrgUnitInfo, IObjectPK sourceCurrPK, IObjectPK destCurrPK) throws EASBizException, BOSException {
        if (destCurrPK == null) {
            destCurrPK = sourceCurrPK;
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo == null) {
            return null;
        }
        excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        ExchangeRateInfo exchangeRateInfo = null;
        exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, sourceCurrPK, destCurrPK);
        return exchangeRateInfo;
    }

    public String getExportQueryInfo(Context ctx) {
        return "com.kingdee.eas.scm.sm.pur.PurReturnsPrintQuery";
    }

    public boolean isIntPurParam(String key, int defaultValue, int trueValue, Map<String, String> paramMap) {
        String strPurParam = paramMap.get(key);
        if (strPurParam != null && strPurParam.trim().length() != 0) {
            int value = Integer.parseInt(strPurParam);
            return value == trueValue;
        }
        return defaultValue == trueValue;
    }

    private EntityViewInfo getFilterForAdmin(String number, Set orgIdSet) {
        EntityViewInfo viewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("number", (Object)number, CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)orgIdSet, CompareType.INCLUDE));
        viewInfo.setFilter(filter);
        return viewInfo;
    }

    private void putTable(Hashtable htable, Object key, Object value) {
        DataImportTools.putToHashtable((Hashtable)htable, (Object)key, (Object)value);
    }

    public Hashtable exportTransmit(IRowSet rs, Context ctx) throws TaskExternalException {
        Hashtable result = new Hashtable();
        try {
            this.putTable(result, "FPurGroupNumber", rs.getString("purchaseGroup.number"));
            this.putTable(result, "FNumber", rs.getString("number"));
            this.putTable(result, "FBizTypeNumber", rs.getString("bizType.number"));
            this.putTable(result, "FBizDate", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("bizDate")));
            this.putTable(result, "FPurchaseOrgUnitNumber", rs.getString("purchaseOrgUnit.number"));
            this.putTable(result, "FPurPersonNumber", rs.getString("purchasePerson.number"));
            this.putTable(result, "FSupplierNumber", rs.getString("supplier.number"));
            this.putTable(result, "FCurrencyNumber", rs.getString("currency.number"));
            this.putTable(result, "FExchangeRate", rs.getBigDecimal("exchangeRate"));
            this.putTable(result, "FBaseStatus", rs.getString("baseStatus"));
            this.putTable(result, "FDescription", rs.getString("description"));
            this.putTable(result, "FAdminOrgUnitNumber", rs.getString("adminOrgUnit.number"));
            this.putTable(result, "FTotalAmount", rs.getBigDecimal("totalAmount"));
            this.putTable(result, "FTotalTax", rs.getBigDecimal("totalTax"));
            this.putTable(result, "FTotalTaxAmount", rs.getBigDecimal("totalTaxAmount"));
            this.putTable(result, "FSeq", rs.getString("ENTRIES.SEQ"));
            this.putTable(result, "FIsPresent", rs.getString("ENTRIES.isPresent"));
            this.putTable(result, "FMaterialNumber", rs.getString("material.number"));
            this.putTable(result, "FAssistPropertyNumber", rs.getString("assistProperty.number"));
            this.putTable(result, "FUnitNumber", rs.getString("unit.number"));
            this.putTable(result, "FQty", rs.getBigDecimal("ENTRIES.QTY"));
            this.putTable(result, "FStorageOrgUnitNumber", rs.getString("storageOrgUnit.number"));
            this.putTable(result, "FWarehouseNumber", rs.getString("warehouse.number"));
            this.putTable(result, "FLocationNumber", rs.getString("location.number"));
            this.putTable(result, "FLot", rs.getString("ENTRIES.lot"));
            this.putTable(result, "FCompanyOrgUnitNumber", rs.getString("companyOrgUnit.number"));
            this.putTable(result, "FAssistUnitNumber", rs.getString("assistUnit.number"));
            this.putTable(result, "FAssistQty", rs.getString("ENTRIES.assistQty"));
            this.putTable(result, "FIsInTax", rs.getString("isInTax"));
            this.putTable(result, "FPrice", rs.getBigDecimal("ENTRIES.price"));
            this.putTable(result, "FTaxRate", rs.getBigDecimal("ENTRIES.taxRate"));
            this.putTable(result, "FTaxPrice", rs.getBigDecimal("ENTRIES.taxPrice"));
            this.putTable(result, "FAmount", rs.getBigDecimal("ENTRIES.amount"));
            this.putTable(result, "FTax", rs.getBigDecimal("ENTRIES.tax"));
            this.putTable(result, "FTaxAmount", rs.getBigDecimal("ENTRIES.taxAmount"));
            this.putTable(result, "FReturnsDate", DateTimeUtil.getDateFmtString((Context)ctx, (String)rs.getString("ENTRIES.returnsDate")));
            this.putTable(result, "FRemark", rs.getString("ENTRIES.remark"));
            this.putTable(result, "FBaseUnitNumber", rs.getString("baseUnit.number"));
            this.putTable(result, "FBaseQty", rs.getBigDecimal("ENTRIES.baseQty"));
            this.putTable(result, "FReturnedQty", rs.getBigDecimal("ENTRIES.returnedQty"));
            this.putTable(result, "FInvoicedQty", rs.getBigDecimal("ENTRIES.invoicedQty"));
            this.putTable(result, "FInvoicedAmount", rs.getBigDecimal("ENTRIES.invoicedAmount"));
            this.putTable(result, "FEntryBaseStatus", rs.getString("ENTRIES.baseStatus"));
            this.putTable(result, "FReasonCodeNumber", rs.getString("reasonCode.number"));
            this.putTable(result, "FCreatorNumber", rs.getString("creator.number"));
            this.putTable(result, "FCreateTime", rs.getString("createTime"));
            this.putTable(result, "FAuditTime", rs.getString("auditTime"));
            this.putTable(result, "FModifierNumber", rs.getString("modifier.number"));
            this.putTable(result, "FModificationTime", rs.getString("modificationTime"));
            this.putTable(result, "FAuditorNumber", rs.getString("AUDITOR.NUMBER"));
            this.putTable(result, "FReturnsReasonNumber", rs.getString("returnsReason.number"));
        }
        catch (Exception e) {
            throw new TaskExternalException("", (Throwable)e);
        }
        return result;
    }
}

