/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectStringPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.common.ReasonCodeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.IPurInWarehsEntry;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryFactory;
import com.kingdee.eas.scm.im.inv.PurInWarehsEntryInfo;
import com.kingdee.eas.scm.sm.pur.IPurOrderEntry;
import com.kingdee.eas.scm.sm.pur.IPurReturns;
import com.kingdee.eas.scm.sm.pur.IPurReturnsEntry;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsCollection;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurReturnsException;
import com.kingdee.eas.scm.sm.pur.PurReturnsFactory;
import com.kingdee.eas.scm.sm.pur.PurReturnsInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurReturnsEntryControllerBean;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.Date;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurReturnsEntryControllerBean
extends AbstractPurReturnsEntryControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurReturnsEntryControllerBean");

    @Override
    protected void _close(Context ctx, IObjectPK[] pks) throws BOSException, PurReturnsException, EASBizException {
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pks[i];
            PurReturnsEntryInfo entryInfo = (PurReturnsEntryInfo)this.getValue(ctx, aPK);
            if (entryInfo.getId() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_ID);
            }
            entryInfo.setBaseStatus(EntryBaseStatusEnum.CLOSED);
            super.update(ctx, aPK, (CoreBaseInfo)entryInfo);
        }
        if (this.checkEntryCloseStatus(ctx, pks)) {
            this.autoClose(ctx, pks[0]);
        }
    }

    protected boolean checkEntryCloseStatus(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        boolean closeFlag = true;
        for (IObjectPK aPK : pks) {
            PurReturnsEntryInfo entryInfo = (PurReturnsEntryInfo)this.getValue(ctx, aPK);
            if (entryInfo.getBaseStatus() == EntryBaseStatusEnum.CLOSED) continue;
            closeFlag = false;
        }
        return closeFlag;
    }

    protected void autoClose(Context ctx, IObjectPK entryPk) throws BOSException, EASBizException {
        IPurReturnsEntry iPurReturnsEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
        PurReturnsEntryInfo purReturnsEntryInfo = iPurReturnsEntry.getPurReturnsEntryInfo(entryPk);
        IPurReturns iPurReturns = PurReturnsFactory.getLocalInstance(ctx);
        ObjectUuidPK aPK = new ObjectUuidPK(purReturnsEntryInfo.getParent().getId());
        PurReturnsInfo purReturnsInfo = iPurReturns.getPurReturnsInfo((IObjectPK)aPK);
        purReturnsInfo.setBaseStatus(BillBaseStatusEnum.CLOSED);
        iPurReturns.update((IObjectPK)new ObjectUuidPK(purReturnsInfo.getId()), (CoreBaseInfo)purReturnsInfo);
    }

    @Override
    protected void _block(Context ctx, IObjectPK[] pks) throws BOSException, PurReturnsException, EASBizException {
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pks[i];
            PurReturnsEntryInfo entryInfo = (PurReturnsEntryInfo)this.getValue(ctx, aPK);
            if (entryInfo.getId() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ENTRY_ID);
            }
            entryInfo.setBaseStatus(EntryBaseStatusEnum.BLOCKED);
            super.update(ctx, aPK, (CoreBaseInfo)entryInfo);
        }
        if (this.checkEntryBlockStatus(ctx, pks)) {
            this.autoBlock(ctx, pks[0]);
        }
    }

    protected boolean checkEntryBlockStatus(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        boolean closeFlag = true;
        for (IObjectPK aPK : pks) {
            PurReturnsEntryInfo entryInfo = (PurReturnsEntryInfo)this.getValue(ctx, aPK);
            if (entryInfo.getBaseStatus() == EntryBaseStatusEnum.BLOCKED) continue;
            closeFlag = false;
        }
        return closeFlag;
    }

    protected void autoBlock(Context ctx, IObjectPK entryPk) throws BOSException, EASBizException {
        IPurReturnsEntry iPurReturnsEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
        PurReturnsEntryInfo purReturnsEntryInfo = iPurReturnsEntry.getPurReturnsEntryInfo(entryPk);
        IPurReturns iPurReturns = PurReturnsFactory.getLocalInstance(ctx);
        ObjectUuidPK aPK = new ObjectUuidPK(purReturnsEntryInfo.getParent().getId());
        PurReturnsInfo purReturnsInfo = iPurReturns.getPurReturnsInfo((IObjectPK)aPK);
        purReturnsInfo.setBaseStatus(BillBaseStatusEnum.BLOCKED);
        iPurReturns.update((IObjectPK)new ObjectUuidPK(purReturnsInfo.getId()), (CoreBaseInfo)purReturnsInfo);
    }

    @Override
    protected void _unBlock(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        this._unBlock(ctx, new IObjectPK[]{pk});
    }

    @Override
    protected void _unBlock(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        this.handleEntryAction(ctx, pk, null, BatchActionEnum.UNFREEZE);
    }

    protected void autoUnBlock(Context ctx, PurReturnsInfo purReturnsInfo) throws BOSException, EASBizException {
        IPurReturns iPurReturns = PurReturnsFactory.getLocalInstance(ctx);
        PurReturnsInfo info = purReturnsInfo;
        ObjectUuidPK thePK = new ObjectUuidPK(info.getId());
        info.setBaseStatus(BillBaseStatusEnum.AUDITED);
        iPurReturns.update((IObjectPK)thePK, (CoreBaseInfo)info);
    }

    protected boolean checkEntryUnBlockStatus(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        boolean closeFlag = true;
        for (IObjectPK aPK : pks) {
            PurReturnsEntryInfo entryInfo = (PurReturnsEntryInfo)this.getValue(ctx, aPK);
            if (entryInfo.getBaseStatus() == EntryBaseStatusEnum.NULL) continue;
            closeFlag = false;
        }
        return closeFlag;
    }

    protected void autoUnBlock(Context ctx, IObjectPK entryPk) throws BOSException, EASBizException {
        IPurReturnsEntry iPurReturnsEntry = PurReturnsEntryFactory.getLocalInstance(ctx);
        PurReturnsEntryInfo purReturnsEntryInfo = iPurReturnsEntry.getPurReturnsEntryInfo(entryPk);
        IPurReturns iPurReturns = PurReturnsFactory.getLocalInstance(ctx);
        ObjectUuidPK aPK = new ObjectUuidPK(purReturnsEntryInfo.getParent().getId());
        PurReturnsInfo purReturnsInfo = iPurReturns.getPurReturnsInfo((IObjectPK)aPK);
        purReturnsInfo.setBaseStatus(BillBaseStatusEnum.AUDITED);
        iPurReturns.update((IObjectPK)new ObjectUuidPK(purReturnsInfo.getId()), (CoreBaseInfo)purReturnsInfo);
    }

    @Override
    protected void _closeWithReason(Context ctx, IObjectPK pk, String reasons) throws BOSException, EASBizException {
        this._closeWithReason(ctx, new IObjectPK[]{pk}, new String[]{reasons});
    }

    @Override
    protected void _closeWithReason(Context ctx, IObjectPK pk, IObjectValue value) throws BOSException, EASBizException {
        this._closeWithReason(ctx, new IObjectPK[]{pk}, new IObjectValue[]{value});
    }

    @Override
    protected void _closeWithReason(Context ctx, IObjectPK[] pks, IObjectValue[] values) throws BOSException, EASBizException {
        if (pks == null || pks.length == 0 || values == null || values.length == 0) {
            return;
        }
        String[] reason = new String[values.length];
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            reason[i] = values[i] == null ? null : ((ReasonCodeInfo)values[i]).getName();
        }
        this.handleEntryAction(ctx, pks, reason, BatchActionEnum.CLOSE);
    }

    @Override
    protected void _closeWithReason(Context ctx, IObjectPK[] pks, String[] reasons) throws BOSException, EASBizException {
        this.handleEntryAction(ctx, pks, reasons, BatchActionEnum.CLOSE);
    }

    protected void handleEntryAction(Context ctx, IObjectPK[] pks, String[] reasonCodes, BatchActionEnum action) throws BOSException, EASBizException {
        PurReturnsInfo info = null;
        PurReturnsEntryInfo entryInfo = null;
        PurReturnsEntryCollection entryColl = null;
        if (pks == null || pks.length == 0 || action == null) {
            return;
        }
        if (!(BatchActionEnum.CLOSE != action && BatchActionEnum.FREEZE != action || reasonCodes != null && reasonCodes.length != 0)) {
            return;
        }
        String tableName = "T_SM_PurReturnsEntry";
        HashSet<String> set = new HashSet<String>();
        int len = pks.length;
        for (int i = 0; i < len; ++i) {
            if (!BOSUuid.isValid((String)pks[i].toString(), (boolean)true)) {
                throw new IllegalArgumentException("parameter is [" + pks[i].toString() + "]");
            }
            set.add(pks[i].toString());
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)("SELECT FParentID FROM " + tableName + " WHERE FID IN " + PurUtil.setToString(set)));
        if (rs == null || rs.size() == 0) {
            return;
        }
        HashSet<String> billIdSet = new HashSet<String>();
        try {
            while (rs.next()) {
                billIdSet.add(rs.getString("FParentID"));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (billIdSet.size() == 0) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", billIdSet, CompareType.INCLUDE));
        view.setFilter(filter);
        PurReturnsCollection coll = PurReturnsFactory.getLocalInstance(ctx).getPurReturnsCollection(view);
        if (coll == null || coll.size() == 0) {
            return;
        }
        HashSet<String> idSet = new HashSet<String>();
        HashMap<String, PurReturnsEntryInfo> entryMap = new HashMap<String, PurReturnsEntryInfo>();
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            int n = info.getEntries().size();
            for (int j = 0; j < n; ++j) {
                entryInfo = info.getEntries().get(j);
                if (!set.contains(entryInfo.getId().toString())) continue;
                if (entryInfo.getId() == null) {
                    throw new PurReturnsException(PurReturnsException.NULL_ENTRY_ID);
                }
                if (BatchActionEnum.CLOSE == action) {
                    if (entryInfo.getBaseStatus().getValue() != 4) {
                        if (pks.length > 1) {
                            throw new PurReturnsException(PurReturnsException.PART_CANNOT_CLOSE);
                        }
                        throw new PurReturnsException(PurReturnsException.CLOSE_NEED_AUDIT);
                    }
                } else if (BatchActionEnum.UNCLOSE == action) {
                    if (entryInfo.getBaseStatus().getValue() != 7) {
                        if (n > 1) {
                            throw new PurReturnsException(PurReturnsException.PART_CANNOT_UNCLOSE);
                        }
                        throw new PurReturnsException(PurReturnsException.UNCLOSE_NEED_CLOSE);
                    }
                } else if (BatchActionEnum.FREEZE == action) {
                    if (entryInfo.getBaseStatus().getValue() != 4) {
                        if (n > 1) {
                            throw new PurReturnsException(PurReturnsException.PART_CANNOT_BLOCK);
                        }
                        throw new PurReturnsException(PurReturnsException.BLOCK_NEED_AUDIT);
                    }
                } else if (entryInfo.getBaseStatus().getValue() != 6) {
                    if (n > 1) {
                        throw new PurReturnsException(PurReturnsException.PART_CANNOT_UNBLOCK);
                    }
                    throw new PurReturnsException(PurReturnsException.UNBLOCK_NEED_BLOCK);
                }
                if (!set.contains(entryInfo.getId().toString())) continue;
                entryInfo.put("parentNum", info.getNumber());
                entryMap.put(entryInfo.getId().toString(), entryInfo);
                idSet.add(info.getId().toString());
            }
        }
        Map map = SCMServerUtils.getHasBizFlowValueBillEntryID((Context)ctx, (String)tableName, (IObjectPK[])pks);
        if (map.size() > 0) {
            int size2 = coll.size();
            for (int i = 0; i < size2; ++i) {
                info = coll.get(i);
                entryColl = (PurReturnsEntryCollection)((Object)info.getEntries().clone());
                info.getEntries().clear();
                int n = entryColl.size();
                for (int j = 0; j < n; ++j) {
                    entryInfo = entryColl.get(j);
                    if (map.size() <= 0 || !map.containsKey(entryInfo.getId().toString())) continue;
                    info.getEntries().add(entryInfo);
                }
                SCMServerUtils.executeBizFlow((Context)ctx, (IObjectValue)info, (BatchActionEnum)action);
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        String entryids = SCMServerUtils.parseArraytoString((String[])SCMServerUtils.getStringFromPK((IObjectPK[])pks));
        if (BatchActionEnum.CLOSE == action) {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(reasonCodes[0].toString());
            params.add(7);
            java.util.Date now = new java.util.Date();
            params.add(new Date(now.getTime()));
            DbUtil.execute((Context)ctx, (String)("Update T_SM_PurReturnsEntry Set FReason =?,FBaseStatus=?,FClosedDate=? Where FID In (" + entryids.toString() + ")"), (Object[])params.toArray());
        } else if (BatchActionEnum.UNCLOSE == action) {
            DbUtil.execute((Context)ctx, (String)("Update T_SM_PurReturnsEntry Set FReason =null,FBaseStatus=4,FClosedDate=null Where FID In (" + entryids.toString() + ")"));
        } else if (BatchActionEnum.FREEZE == action) {
            ArrayList<Object> params = new ArrayList<Object>();
            params.add(reasonCodes[0].toString());
            params.add(6);
            DbUtil.execute((Context)ctx, (String)("Update T_SM_PurReturnsEntry Set FReason =?,FBaseStatus=? Where FID In (" + entryids.toString() + ")"), (Object[])params.toArray());
        } else {
            DbUtil.execute((Context)ctx, (String)("Update T_SM_PurReturnsEntry Set FReason =null,FBaseStatus=4 Where FID In (" + entryids.toString() + ")"));
        }
        for (Map.Entry entry : entryMap.entrySet()) {
            entryInfo = (PurReturnsEntryInfo)entry.getValue();
            if (BatchActionEnum.CLOSE == action) {
                super.closeWithLog(ctx, entryInfo);
            } else if (BatchActionEnum.FREEZE == action) {
                super.blockWithLog(ctx, (IObjectValue)entryInfo);
            }
            if (BatchActionEnum.CLOSE != action || map.size() > 0 && map.containsKey(entryInfo.getId().toString())) continue;
            this.reverseClose(ctx, (IObjectValue)entryInfo.getParent(), (IObjectValue)entryInfo);
        }
        if (idSet.size() == 0) {
            return;
        }
        sql.setLength(0);
        String parentids = PurUtil.setToString(idSet);
        sql.append(" update T_SM_PurReturns set fbasestatus = ");
        if (BatchActionEnum.CLOSE == action) {
            sql.append(7);
        } else if (BatchActionEnum.UNCLOSE == action || BatchActionEnum.UNFREEZE == action) {
            sql.append(4);
        } else {
            sql.append(6);
        }
        sql.append(" where fid in ").append(parentids);
        sql.append(" and fid not in (select fparentid from T_SM_PurReturnsEntry where ");
        if (BatchActionEnum.CLOSE == action) {
            sql.append("fbasestatus <> 7");
        } else if (BatchActionEnum.UNCLOSE == action || BatchActionEnum.UNFREEZE == action) {
            sql.append("fbasestatus = -2 ");
        } else {
            sql.append("fbasestatus <> 6");
        }
        sql.append(" and fparentid in").append(parentids).append(")");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    protected void autoClose(Context ctx, PurReturnsInfo purReturnsInfo) throws BOSException, EASBizException {
        PurReturnsInfo info = purReturnsInfo;
        ObjectUuidPK thePK = new ObjectUuidPK(info.getId());
        PurReturnsEntryCollection entryInfos = info.getEntries();
        PurReturnsEntryInfo entry = null;
        boolean closeFlag = true;
        int num = entryInfos.size();
        for (int j = 0; j < num; ++j) {
            entry = entryInfos.get(j);
            if (entry.getBaseStatus().getValue() == 7) continue;
            closeFlag = false;
        }
        if (closeFlag) {
            info.setBaseStatus(BillBaseStatusEnum.CLOSED);
            super.update(ctx, (IObjectPK)thePK, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _closeWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    private void reverseClose(Context ctx, IObjectValue purReturnsInfo, IObjectValue purReturnsEntryInfo) throws BOSException, EASBizException {
        BigDecimal totalReturnedQty;
        BigDecimal qty;
        BigDecimal returnedQty;
        PurReturnsInfo pInfo = (PurReturnsInfo)purReturnsInfo;
        PurReturnsEntryInfo entryInfo = (PurReturnsEntryInfo)purReturnsEntryInfo;
        if (SCMUtils.isBotpBill((SCMBillBaseInfo)pInfo, (String)"510b6503-0105-1000-e000-010bc0a812fd463ED552")) {
            IPurOrderEntry ipurOrderEntry = PurOrderEntryFactory.getLocalInstance(ctx);
            ObjectStringPK orderEntryPK = new ObjectStringPK(entryInfo.getSourceBillEntryId().toString());
            PurOrderEntryInfo orderEntryInfo = ipurOrderEntry.getPurOrderEntryInfo((IObjectPK)orderEntryPK);
            returnedQty = entryInfo.getReturnedQty();
            qty = entryInfo.getQty();
            totalReturnedQty = orderEntryInfo.getTotalReturnedQty();
            if (returnedQty.compareTo(new BigDecimal("0.00")) == 0) {
                return;
            }
            orderEntryInfo.setTotalReturnedQty(totalReturnedQty.subtract(qty.subtract(returnedQty)));
            ipurOrderEntry.update((IObjectPK)orderEntryPK, (CoreBaseInfo)orderEntryInfo);
        }
        if (SCMUtils.isBotpBill((SCMBillBaseInfo)pInfo, (String)"50957179-0105-1000-e000-015fc0a812fd463ED552")) {
            IPurInWarehsEntry ipurInWarehsEntry = PurInWarehsEntryFactory.getLocalInstance((Context)ctx);
            ObjectStringPK inWarehsEntryPK = new ObjectStringPK(entryInfo.getSourceBillEntryId().toString());
            PurInWarehsEntryInfo inWarehsEntryInfo = ipurInWarehsEntry.getPurInWarehsEntryInfo((IObjectPK)inWarehsEntryPK);
            returnedQty = entryInfo.getReturnedQty();
            qty = entryInfo.getQty();
            totalReturnedQty = inWarehsEntryInfo.getReturnsQty();
            if (returnedQty.compareTo(new BigDecimal("0.00")) == 0) {
                return;
            }
            inWarehsEntryInfo.setReturnsQty(totalReturnedQty.subtract(qty.subtract(returnedQty)));
            ipurInWarehsEntry.update((IObjectPK)inWarehsEntryPK, (CoreBaseInfo)inWarehsEntryInfo);
        }
    }

    @Override
    protected void _blockWithReason(Context ctx, IObjectPK pk, IObjectValue value) throws BOSException, EASBizException {
        this._blockWithReason(ctx, new IObjectPK[]{pk}, new IObjectValue[]{value});
    }

    @Override
    protected void _blockWithReason(Context ctx, IObjectPK pk, String value) throws BOSException, EASBizException {
        this._blockWithReason(ctx, new IObjectPK[]{pk}, new String[]{value});
    }

    @Override
    protected void _blockWithReason(Context ctx, IObjectPK[] pks, IObjectValue[] values) throws BOSException, EASBizException {
        if (pks == null || pks.length == 0 || values == null || values.length == 0) {
            return;
        }
        String[] reason = new String[values.length];
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            reason[i] = values[i] == null ? null : ((ReasonCodeInfo)values[i]).getName();
        }
        this.handleEntryAction(ctx, pks, reason, BatchActionEnum.FREEZE);
    }

    @Override
    protected void _blockWithReason(Context ctx, IObjectPK[] pks, String[] values) throws BOSException, EASBizException {
        this.handleEntryAction(ctx, pks, values, BatchActionEnum.FREEZE);
    }

    protected void autoBlock(Context ctx, PurReturnsInfo purReturnsInfo) throws BOSException, EASBizException {
        PurReturnsInfo info = purReturnsInfo;
        ObjectUuidPK thePK = new ObjectUuidPK(info.getId());
        IPurReturns iPurReturns = PurReturnsFactory.getLocalInstance(ctx);
        if (info.getId() == null) {
            throw new PurReturnsException(PurReturnsException.NULL_ID);
        }
        if (info.getBaseStatus().getValue() != 4) {
            throw new PurReturnsException(PurReturnsException.BLOCK_NEED_AUDIT);
        }
        PurReturnsEntryCollection entryInfos = info.getEntries();
        PurReturnsEntryInfo entry = null;
        boolean closeFlag = true;
        int num = entryInfos.size();
        for (int j = 0; j < num; ++j) {
            entry = entryInfos.get(j);
            if (entry.getBaseStatus().getValue() == 6) continue;
            closeFlag = false;
        }
        if (closeFlag) {
            info.setBaseStatus(BillBaseStatusEnum.BLOCKED);
            iPurReturns.update((IObjectPK)thePK, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _blockWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK[] pks, IObjectValue[] values) throws BOSException, EASBizException {
        this.canCancel(ctx, pks);
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pks[i];
            PurReturnsInfo info = (PurReturnsInfo)this.getValue(ctx, aPK);
            ReasonCodeInfo reasonCodeInfo = (ReasonCodeInfo)values[i];
            info.setBaseStatus(BillBaseStatusEnum.DELETED);
            PurReturnsEntryCollection entryCol = info.getEntries();
            if (entryCol != null) {
                int size = entryCol.size();
                for (int j = 0; j < size; ++j) {
                    PurReturnsEntryInfo entryInfo = entryCol.get(j);
                    entryInfo.setReason(reasonCodeInfo.getName());
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.DELETED);
                }
            }
            super.update(ctx, aPK, (CoreBaseInfo)info);
        }
    }

    private void canCancel(Context ctx, IObjectPK[] pk) throws BOSException, EASBizException {
        int n = pk.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pk[i];
            PurReturnsInfo info = (PurReturnsInfo)this.getValue(ctx, aPK);
            if (info.getId() == null) {
                throw new PurReturnsException(PurReturnsException.NULL_ID);
            }
            if (info.getBaseStatus().getValue() == 2) continue;
            if (n > 1) {
                throw new PurReturnsException(PurReturnsException.PART_CANNOT_CANCEL);
            }
            throw new PurReturnsException(PurReturnsException.CANCEL_NEED_SUBMIT);
        }
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK[] pks, String[] values) throws BOSException, EASBizException {
        this.canCancel(ctx, pks);
        int n = pks.length;
        for (int i = 0; i < n; ++i) {
            IObjectPK aPK = pks[i];
            PurReturnsInfo info = (PurReturnsInfo)this.getValue(ctx, aPK);
            String reasonCodeInfo = values[i];
            info.setBaseStatus(BillBaseStatusEnum.DELETED);
            PurReturnsEntryCollection entryCol = info.getEntries();
            if (entryCol != null) {
                int size = entryCol.size();
                for (int j = 0; j < size; ++j) {
                    PurReturnsEntryInfo entryInfo = entryCol.get(j);
                    entryInfo.setReason(reasonCodeInfo);
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.DELETED);
                }
            }
            super.update(ctx, aPK, (CoreBaseInfo)info);
        }
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK pk, String value) throws BOSException, EASBizException {
        this._cancelWithReason(ctx, new IObjectPK[]{pk}, new String[]{value});
    }

    @Override
    protected void _cancelWithReason(Context ctx, IObjectPK pk, IObjectValue value) throws BOSException, EASBizException {
        this._cancelWithReason(ctx, new IObjectPK[]{pk}, new IObjectValue[]{value});
    }

    @Override
    protected void _cancelWithLog(Context ctx, IObjectValue model) throws BOSException, EASBizException {
    }

    protected String _getLogInfo(Context ctx, IObjectPK pk) throws BOSException, EASBizException {
        PurReturnsEntryInfo info = (PurReturnsEntryInfo)this.getValue(ctx, pk);
        PurReturnsInfo sInfo = PurReturnsFactory.getLocalInstance(ctx).getPurReturnsInfo((IObjectPK)new ObjectUuidPK(info.getParent().getId()));
        return sInfo.getNumber() + "  " + info.getSeq();
    }

    @Override
    protected void _unClose(Context ctx, IObjectPK[] pks) throws BOSException, PurReturnsException, EASBizException {
        this.handleEntryAction(ctx, pks, null, BatchActionEnum.UNCLOSE);
    }

    @Override
    protected void _unClose(Context ctx, IObjectPK pk) throws BOSException, PurReturnsException, EASBizException {
        this._unClose(ctx, new IObjectPK[]{pk});
    }
}

