/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.permission.IPermission;
import com.kingdee.eas.base.permission.PermissionFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.CheckPriceResult;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurServiceFacadeControllerBean;
import com.kingdee.eas.scm.sm.pur.app.ExchangeRateImpl;
import com.kingdee.eas.scm.sm.pur.app.IPurBusiness;
import com.kingdee.eas.scm.sm.pur.app.PurPersonWorkBenchForOrderImpl;
import com.kingdee.eas.scm.sm.pur.app.PurPersonWorkBenchImpl;
import com.kingdee.eas.scm.sm.pur.app.price.CheckPurPriceImpl;
import com.kingdee.eas.scm.sm.pur.app.price.FetchCtrlStrategyImpl;
import com.kingdee.eas.scm.sm.pur.app.price.FetchPurPriceImpl;
import com.kingdee.eas.scm.sm.pur.app.price.QueryPurPriceImpl;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurServiceFacadeControllerBean
extends AbstractPurServiceFacadeControllerBean {
    private static final long serialVersionUID = 2081712131959024633L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.PurServiceFacadeControllerBean");

    @Override
    protected PurPriceInfoCollection _fetchPrice(Context ctx, PurPriceParamCollection paramCol) throws BOSException, EASBizException {
        return this.getFetchPurPriceImpl(ctx, paramCol).doBusiness(paramCol);
    }

    protected IPurBusiness<PurPriceInfoCollection> getFetchPurPriceImpl(Context ctx, Object param) {
        return new FetchPurPriceImpl(ctx, param);
    }

    @Override
    protected CheckPriceResult _topPriceCtrl(Context ctx, PurPriceParamCollection paramCol) throws BOSException, EASBizException {
        return this.getCheckPurPriceImpl(ctx, paramCol).doBusiness(paramCol);
    }

    protected IPurBusiness<CheckPriceResult> getCheckPurPriceImpl(Context ctx, Object param) {
        return new CheckPurPriceImpl(ctx, param);
    }

    @Override
    protected PurPriceInfoCollection _fetchCtrlStrategy(Context ctx, PurPriceParamCollection paramCol) throws BOSException, EASBizException {
        return this.getFetchCtrlStrategyImpl(ctx, paramCol).doBusiness(paramCol);
    }

    protected IPurBusiness<PurPriceInfoCollection> getFetchCtrlStrategyImpl(Context ctx, Object param) {
        return new FetchCtrlStrategyImpl(ctx, param);
    }

    @Override
    protected PurPriceInfoCollection _queryPurPrice(Context ctx, PurPriceParamCollection paramCol) throws BOSException, EASBizException {
        return this.getQueryPurPriceImpl(ctx, paramCol).doBusiness(paramCol);
    }

    protected IPurBusiness<PurPriceInfoCollection> getQueryPurPriceImpl(Context ctx, Object param) {
        return new QueryPurPriceImpl(ctx, param);
    }

    @Override
    protected Map _getExchangeRatePrecision(Context ctx, String companyOrgUnitId, String baseCurrencyId, List currencyIds) throws BOSException, EASBizException {
        Object[] params = new Object[]{companyOrgUnitId, baseCurrencyId, currencyIds};
        return (Map)new ExchangeRateImpl(ctx, params).doBusiness(params);
    }

    @Override
    protected Map _getReqBillCountByType(Context ctx, String purOrgId, String dateFilter, int type) throws BOSException, EASBizException {
        Object[] params = new Object[]{purOrgId, dateFilter, type, "210"};
        return (Map)new PurPersonWorkBenchImpl(ctx, params).doBusiness(params);
    }

    @Override
    protected Map _getViewPermission(Context ctx, String purOrgId) throws BOSException, EASBizException {
        HashMap<String, Boolean> map = new HashMap<String, Boolean>();
        IPermission iPermission = PermissionFactory.getLocalInstance((Context)ctx);
        OrgUnitCollection orgUnitColl = OrgUnitRelationFactory.getRemoteInstance().getToUnit(purOrgId, 3, 1);
        if (orgUnitColl.size() > 0) {
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)orgUnitColl.get(0);
            map.put("purReq_view", iPermission.hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(companyOrgUnitInfo.getId()), "purreq_view"));
        } else {
            map.put("purReq_view", false);
        }
        map.put("purOrder_view", iPermission.hasFunctionPermission(ctx.getCaller(), (IObjectPK)new ObjectUuidPK(purOrgId), "purorder_view"));
        return map;
    }

    @Override
    protected Map _getOrderBillCountByType(Context ctx, String purOrgId, String dateFilter, int type) throws BOSException, EASBizException {
        Object[] params = new Object[]{purOrgId, dateFilter, type, "220"};
        return (Map)new PurPersonWorkBenchForOrderImpl(ctx, params).doBusiness(params);
    }

    @Override
    protected String _getApprovedSupplierFilterStr(Context ctx, String materialID, String purchaseOrg) throws BOSException, EASBizException {
        if (materialID == null || purchaseOrg == null) {
            return null;
        }
        StringBuffer str = new StringBuffer();
        str.append(" select FID,FPurchaseOrgID,FMaterialItemID,FSupplierID from T_SM_ApprovedSupplier where ");
        str.append(" FIsUseable = ").append(1);
        str.append(" and FPurchaseOrgID = '").append(purchaseOrg).append("'");
        str.append(" and FMaterialItemID = '").append(materialID).append("'");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)str.toString());
        boolean isFirst = true;
        String supplierID = null;
        str.setLength(0);
        try {
            while (rs.next()) {
                supplierID = rs.getString("FSupplierID");
                if (isFirst) {
                    str.append(supplierID);
                    isFirst = false;
                    continue;
                }
                str.append(",").append(supplierID);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return str.toString();
    }
}

