/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.org.DefaultOtherDealOrgChangeImpl;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.ICompanyOrgAfterDeal;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.srm.PurPriceStrategyCollection;
import com.kingdee.eas.basedata.scm.sm.srm.PurPriceStrategyFactory;
import com.kingdee.eas.basedata.scm.sm.srm.app.pricestrategy.IStrategyBuilder;
import com.kingdee.eas.basedata.scm.sm.srm.app.pricestrategy.StrategyBuilder1;
import com.kingdee.eas.basedata.scm.sm.srm.app.pricestrategy.StrategyBuilder2;
import com.kingdee.eas.basedata.scm.sm.srm.app.pricestrategy.StrategyBuilder3;
import com.kingdee.eas.basedata.scm.sm.srm.app.pricestrategy.StrategyBuilder4;
import com.kingdee.eas.basedata.scm.sm.srm.app.pricestrategy.StrategyBuilder5;
import com.kingdee.eas.basedata.scm.sm.srm.app.pricestrategy.StrategyBuilder6;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseCollection;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PurchaseOrgAfterDealService
extends DefaultOtherDealOrgChangeImpl
implements ICompanyOrgAfterDeal {
    private List<IStrategyBuilder> strategyBuilders = new ArrayList<IStrategyBuilder>();

    public void afterDeal(Context ctx, FullOrgUnitInfo model) throws BOSException, EASBizException {
        this.dealData(ctx, model);
    }

    private void setStrategyBuilders(Context ctx) {
        this.strategyBuilders.add((IStrategyBuilder)new StrategyBuilder1(ctx));
        this.strategyBuilders.add((IStrategyBuilder)new StrategyBuilder2(ctx));
        this.strategyBuilders.add((IStrategyBuilder)new StrategyBuilder3(ctx));
        this.strategyBuilders.add((IStrategyBuilder)new StrategyBuilder4(ctx));
        this.strategyBuilders.add((IStrategyBuilder)new StrategyBuilder5(ctx));
        this.strategyBuilders.add((IStrategyBuilder)new StrategyBuilder6(ctx));
    }

    private void dealData(Context ctx, FullOrgUnitInfo model) throws EASBizException, BOSException {
        if (model == null || model.getPartPurchase() == null || !model.getPartPurchase().isIsBizUnit()) {
            return;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)model.getId().toString()));
        view.setFilter(filter);
        PurPriceStrategyCollection col = PurPriceStrategyFactory.getLocalInstance((Context)ctx).getPurPriceStrategyCollection(view);
        if (col.size() > 0) {
            return;
        }
        this.setStrategyBuilders(ctx);
        PurchaseOrgUnitInfo purOrgUnit = new PurchaseOrgUnitInfo();
        purOrgUnit.setId(model.getId());
        CoreBaseCollection cols = new CoreBaseCollection();
        Iterator<IStrategyBuilder> iter = this.strategyBuilders.iterator();
        while (iter.hasNext()) {
            IObjectValue value = iter.next().build(purOrgUnit);
            cols.addObject(value);
        }
        PurPriceStrategyFactory.getLocalInstance((Context)ctx).addnew(cols);
    }

    public void afterOrgAddNew(Context ctx, FullOrgUnitInfo model) throws BOSException, EASBizException {
        String orgId = model.getId().toString();
        if (orgId != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit", (Object)orgId, CompareType.EQUALS));
            view.setFilter(filter);
            int count = PurPriceStrategyFactory.getLocalInstance((Context)ctx).getCount(view);
            if (count == 0) {
                this.dealData(ctx, model);
            }
        }
    }

    public void afterOrgDelete(Context ctx, FullOrgUnitInfo model) throws BOSException, EASBizException {
    }

    public void OrgUpdateAfter(Context ctx, FullOrgUnitInfo model) throws BOSException, EASBizException {
        String orgId = model.getId().toString();
        if (orgId != null) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit", (Object)orgId, CompareType.EQUALS));
            view.setFilter(filter);
            int count = PurPriceStrategyFactory.getLocalInstance((Context)ctx).getCount(view);
            if (count == 0) {
                this.dealData(ctx, model);
            }
        }
    }
}

