/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.AbstractObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.assistant.IMeasureUnit;
import com.kingdee.eas.basedata.assistant.MeasureUnitCollection;
import com.kingdee.eas.basedata.assistant.MeasureUnitFactory;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceParam;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.batchHandler.RequestContext;
import com.kingdee.eas.framework.batchHandler.ResponseContext;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.util.ListMap;
import com.kingdee.eas.scm.common.util.ObjectListMap;
import com.kingdee.util.StringUtils;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class SalePurHandlerUtil {
    public static final String STATUS_ALERT = "ALERT";
    public static final String STATUS_ADDNEW = "ADDNEW";
    public static final String STATUS_EDIT = "EDIT";
    public static final String STATUS_VIEW = "VIEW";
    public static final String SALECONTRACT_BILLTYPEID = "DEZBNUYZRM6ieHZ5GGlRc0Y+1VI=";

    public static boolean isBotpBill(String billTypeID, SCMBillBaseInfo scmInfo) {
        if (SalePurHandlerUtil.isBotpBill(scmInfo)) {
            return scmInfo.getSourceBillType().getId().toString().equals(billTypeID);
        }
        return false;
    }

    public static boolean isBotpBill(SCMBillBaseInfo scmInfo) {
        return scmInfo.getSourceBillType() != null;
    }

    public static void getParamAfterMainOrgChanged(String mainOrgID, Context context) throws Exception {
        IPriceParam iPriceParam = PriceParamFactory.getLocalInstance((Context)context);
        iPriceParam.getParameter(mainOrgID);
    }

    public static HashMap getMultiMeasureUnits(String[] materialId, String[] measureUnitId) throws BOSException {
        return null;
    }

    public static void formatQtyPrecision(AbstractObjectCollection entries, Method mtdGetQty, RequestContext request, ResponseContext response, Context context) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, EASBizException, BOSException {
        if (entries == null || entries.size() == 0) {
            return;
        }
        ObjectListMap materialsMap = new ObjectListMap(5);
        String[] materialInfos = new String[entries.size() * 2];
        String[] measureUnitInfos = new String[entries.size() * 2];
        Map<String, Object> unitIdMap = new HashMap();
        int idx = 0;
        BigDecimal zero = new BigDecimal(0.0);
        for (int i = 0; i < entries.size(); ++i) {
            SCMBillEntryBaseInfo entryInfo = (SCMBillEntryBaseInfo)entries.getObject(i);
            BigDecimal qty = (BigDecimal)mtdGetQty.invoke((Object)entryInfo, null);
            MaterialInfo materialInfo = entryInfo.getMaterial();
            MeasureUnitInfo unitInfo = entryInfo.getUnit();
            MeasureUnitInfo assistUnitInfo = entryInfo.getAssistUnit();
            MeasureUnitInfo baseunitInfo = entryInfo.getBaseUnit();
            if (materialInfo == null) continue;
            if (assistUnitInfo != null) {
                unitIdMap.put(assistUnitInfo.getId().toString(), null);
            }
            if (qty != null && qty.compareTo(zero) == 0) continue;
            if (qty != null && unitInfo != null && assistUnitInfo != null) {
                materialsMap.put2((Object)new Integer(i * 2), new Object[]{materialInfo.getId().toString(), unitInfo.getId().toString(), assistUnitInfo.getId().toString(), null, qty});
                materialInfos[idx] = materialInfo.getId().toString();
                measureUnitInfos[idx++] = assistUnitInfo.getId().toString();
            }
            if (qty == null || unitInfo == null || baseunitInfo == null) continue;
            materialsMap.put2((Object)new Integer(i * 2 + 1), new Object[]{materialInfo.getId().toString(), unitInfo.getId().toString(), null, null, qty});
            materialInfos[idx] = materialInfo.getId().toString();
            measureUnitInfos[idx++] = baseunitInfo.getId().toString();
        }
        if (unitIdMap.size() > 0) {
            unitIdMap = SalePurHandlerUtil.getMeasureUnitInfos(unitIdMap, request, response, context);
        }
        if (materialsMap.size() > 0) {
            SalePurHandlerUtil.fetchUOMRates((ListMap)materialsMap, request, response, context);
            String[] amaterialInfos = new String[materialsMap.size()];
            String[] ameasureUnitInfos = new String[materialsMap.size()];
            if (idx < entries.size() * 2) {
                System.arraycopy(materialInfos, 0, amaterialInfos, 0, idx);
                System.arraycopy(measureUnitInfos, 0, ameasureUnitInfos, 0, idx);
            } else {
                amaterialInfos = materialInfos;
                ameasureUnitInfos = measureUnitInfos;
            }
            SalePurHandlerUtil.getMultiMeasureUnits2(amaterialInfos, ameasureUnitInfos, request, response, context);
        }
    }

    public static Map getMeasureUnitInfos(Map unitIdMap, RequestContext request, ResponseContext response, Context context) throws BOSException {
        HashMap<String, MeasureUnitInfo> unitMap = new HashMap<String, MeasureUnitInfo>();
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        Iterator iter = unitIdMap.keySet().iterator();
        while (iter.hasNext()) {
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(iter.next());
        }
        filter.getFilterItems().add(new FilterItemInfo("id", (Object)sb.toString(), CompareType.INCLUDE));
        view.setFilter(filter);
        IMeasureUnit iunit = MeasureUnitFactory.getLocalInstance((Context)context);
        MeasureUnitCollection collection = iunit.getMeasureUnitCollection(view);
        if (collection != null) {
            for (int i = 0; i < collection.size(); ++i) {
                MeasureUnitInfo unit = collection.get(i);
                unitMap.put(unit.getId().toString(), unit);
            }
        }
        return unitMap;
    }

    public static void fetchUOMRates(ListMap convertMap, RequestContext request, ResponseContext response, Context context) throws BOSException, EASBizException {
        if (convertMap != null && convertMap.size() > 0) {
            ObjectListMap map = new ObjectListMap(2);
            Object[] keys = convertMap.keySet().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String key = (String)convertMap.get(keys[i], 0) + (String)convertMap.get(keys[i], 1);
                if (!map.containsKey((Object)key)) {
                    map.put2((Object)key, new Object[]{(String)convertMap.get(keys[i], 0), (String)convertMap.get(keys[i], 1)});
                }
                if (convertMap.get(keys[i], 2) == null || map.containsKey((Object)(key = (String)convertMap.get(keys[i], 0) + (String)convertMap.get(keys[i], 2)))) continue;
                map.put2((Object)key, new Object[]{(String)convertMap.get(keys[i], 0), (String)convertMap.get(keys[i], 2)});
            }
            if (map.size() > 0) {
                String[] materialIds = new String[map.size()];
                String[] unitIds = new String[map.size()];
                Iterator iter = map.keySet().iterator();
                int idx = 0;
                while (iter.hasNext()) {
                    Object akey = iter.next();
                    materialIds[idx] = (String)map.get(akey, 0);
                    unitIds[idx] = (String)map.get(akey, 1);
                    ++idx;
                }
                IMultiMeasureUnit iMultiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)context);
                Map rateMap = iMultiUnit.getConvRatesByMaterial(materialIds, unitIds);
                if (rateMap != null && rateMap.size() > 0) {
                    BigDecimal zero = new BigDecimal(0.0);
                    for (int i = 0; i < keys.length; ++i) {
                        String key = (String)convertMap.get(keys[i], 0) + (String)convertMap.get(keys[i], 1);
                        BigDecimal value1 = (BigDecimal)rateMap.get(key);
                        if (convertMap.get(keys[i], 2) != null) {
                            key = (String)convertMap.get(keys[i], 0) + (String)convertMap.get(keys[i], 2);
                            BigDecimal value2 = (BigDecimal)rateMap.get(key);
                            if (value1 == null || value2 == null || value2.compareTo(zero) == 0) continue;
                            BigDecimal value = value1.divide(value2, 10, 4);
                            convertMap.set(keys[i], 3, (Object)value);
                            continue;
                        }
                        convertMap.set(keys[i], 3, (Object)value1);
                    }
                }
            }
        }
    }

    public static HashMap getMultiMeasureUnits2(String[] materialId, String[] measureUnitId, RequestContext request, ResponseContext response, Context context) throws BOSException {
        IMultiMeasureUnit imultiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)context);
        String oqlWhere = SalePurHandlerUtil.getMultiMeasureUnitOQL(materialId, measureUnitId);
        HashMap<String, MultiMeasureUnitInfo> mulUnitsMap = new HashMap<String, MultiMeasureUnitInfo>();
        if (StringUtils.isEmpty((String)oqlWhere)) {
            return mulUnitsMap;
        }
        MultiMeasureUnitCollection mulUnits = imultiUnit.getMultiMeasureUnitCollection(oqlWhere);
        MultiMeasureUnitInfo mulUnitInfo = null;
        int num = mulUnits.size();
        for (int i = 0; i < num; ++i) {
            mulUnitInfo = mulUnits.get(i);
            mulUnitsMap.put(mulUnitInfo.getMaterial().getId().toString() + mulUnitInfo.getMeasureUnit().getId().toString(), mulUnitInfo);
        }
        return mulUnitsMap;
    }

    public static String getMultiMeasureUnitOQL(String[] matId, String[] mUnitId) {
        String oqlWhere = "material.id = null or measureUnit.id = null";
        boolean isFirst = true;
        int size = matId.length;
        for (int i = 0; i < size; ++i) {
            if (StringUtils.isEmpty((String)matId[i]) || StringUtils.isEmpty((String)mUnitId[i])) continue;
            if (isFirst) {
                isFirst = false;
                oqlWhere = "(material.id = '" + matId[i] + "' and measureUnit.id = '" + mUnitId[i] + "')";
                continue;
            }
            oqlWhere = oqlWhere + " or (material.id = '" + matId[i] + "' and measureUnit.id = '" + mUnitId[i] + "')";
        }
        if (StringUtils.isEmpty((String)oqlWhere)) {
            return oqlWhere;
        }
        oqlWhere = "select material.id, measureUnit.id, qtyPrecision,baseConvsRate where " + oqlWhere;
        return oqlWhere;
    }
}

