/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.ConvertModeEnum;
import com.kingdee.eas.basedata.assistant.ExchangeRateCollection;
import com.kingdee.eas.basedata.assistant.ExchangeRateFactory;
import com.kingdee.eas.basedata.assistant.ExchangeRateInfo;
import com.kingdee.eas.basedata.assistant.ExchangeTableInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierCompanyInfoInfo;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoCollection;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierPurchaseInfoInfo;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialCollection;
import com.kingdee.eas.basedata.master.material.MaterialFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierCollection;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoCollection;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.DataBaseInfo;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillCommonFacadeFactory;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.common.util.SortUtil;
import com.kingdee.eas.scm.sm.pur.PurPriceInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.scm.sm.pur.app.AbstractSubContractOrderPriceFacadeControllerBean;
import com.kingdee.eas.scm.sm.pur.calculate.PurOrderCal;
import com.kingdee.eas.scm.sm.sc.SubContractOrderCollection;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.eas.util.SysUtil;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class SubContractOrderPriceFacadeControllerBean
extends AbstractSubContractOrderPriceFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.SubContractOrderPriceFacadeControllerBean");
    private HashMap PURSUP008 = new HashMap();
    private HashMap PURORDER005 = new HashMap();
    private HashMap materialPurchaseInfo = new HashMap();
    private HashMap PURORDER004 = new HashMap();
    private HashMap PURSUP007 = new HashMap();
    private HashMap PURSUP001 = new HashMap();
    private HashMap PURORDER002 = new HashMap();
    private HashMap PURORDER003 = new HashMap();
    private HashMap pricePrecision = new HashMap();
    private HashMap localAmtPre = new HashMap();
    private static final String RESSOURCE = "com.kingdee.eas.scm.sm.pur.PurBizResource";

    @Override
    protected HashMap _getPrice(Context ctx, SubContractOrderCollection collection) throws BOSException, EASBizException {
        HashMap map = new HashMap();
        return map;
    }

    private void priceByMaterialPurchasingInfo(Context ctx, SubContractOrderEntryInfo entryInfo, String purchaseId, MaterialPurchasingInfo materialPurInfo, int pricePrecision, int amtPrecision) throws EASBizException, BOSException {
        BigDecimal ZERO;
        BigDecimal rate = null;
        BigDecimal ONE = SCMConstant.BIGDECIMAL_ONE;
        BigDecimal taxPrice = ZERO = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal price = ZERO;
        BigDecimal taxAmount = ZERO;
        BigDecimal tax = ZERO;
        BigDecimal amount = ZERO;
        BigDecimal actualTaxPrice = ZERO;
        BigDecimal actualPrice = ZERO;
        rate = entryInfo.getTaxRate().compareTo(ZERO) == 0 ? ZERO : entryInfo.getTaxRate().divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4);
        if (Boolean.valueOf(this.PURORDER002.get(purchaseId).toString()).booleanValue()) {
            taxPrice = materialPurInfo.getPrice();
            price = taxPrice.divide(rate.add(ONE), pricePrecision, 4);
            taxAmount = entryInfo.getBaseQty().multiply(taxPrice);
            taxAmount = taxAmount.setScale(amtPrecision, 4);
            tax = taxAmount.divide(rate.add(ONE), amtPrecision, 4).multiply(rate);
            tax = tax.setScale(amtPrecision, 4);
            amount = taxAmount.subtract(tax);
            amount = amount.setScale(amtPrecision, 4);
            actualTaxPrice = taxAmount.divide(entryInfo.getBaseQty(), pricePrecision, 4);
            actualPrice = amount.divide(entryInfo.getBaseQty(), pricePrecision, 4);
            entryInfo.setBoolean("isTax", true);
        } else {
            price = materialPurInfo.getPrice();
            taxPrice = price.multiply(rate.add(ONE)).setScale(pricePrecision, 4);
            amount = entryInfo.getBaseQty().multiply(price).setScale(amtPrecision, 4);
            tax = amount.multiply(rate).setScale(amtPrecision, 4);
            taxAmount = amount.add(tax);
            actualTaxPrice = taxAmount.divide(entryInfo.getBaseQty(), pricePrecision, 4);
            actualPrice = amount.divide(entryInfo.getBaseQty(), pricePrecision, 4);
            entryInfo.setBoolean("isTax", false);
        }
        entryInfo.setPrice(price);
        entryInfo.setTaxPrice(taxPrice);
        entryInfo.setActualPrice(actualPrice);
        entryInfo.setActualTaxPrice(actualTaxPrice);
        entryInfo.setAmount(amount);
        entryInfo.setTaxAmount(taxAmount);
        entryInfo.setTax(tax);
        entryInfo.setDiscount(ZERO);
        entryInfo.setDiscountAmount(ZERO);
    }

    private void initParams(Context ctx, SubContractOrderCollection collection) throws BOSException, EASBizException {
        String[] params = new String[]{"PURSUP008", "PURORDER005", "PURSUP007", "PURORDER002", "PURORDER004"};
        HashMap valueMap = new HashMap();
        ArrayList<String> purchaseList = new ArrayList<String>();
        HashMap purMaterialMap = new HashMap();
        HashSet<String> materialSet = new HashSet<String>();
        HashSet<String> purMaterialSet = null;
        SubContractOrderInfo orderInfo = null;
        SubContractOrderEntryInfo entryInfo = null;
        for (int k = 0; k < collection.size(); ++k) {
            orderInfo = collection.get(k);
            int count = orderInfo.getEntries().size();
            for (int i = 0; i < count; ++i) {
                entryInfo = orderInfo.getEntries().get(i);
                String materialId = entryInfo.getMaterial().getId().toString();
                String purchaseId = orderInfo.getPurchaseOrgUnit().getId().toString();
                if (!purchaseList.contains(purchaseId)) {
                    purchaseList.add(purchaseId);
                    valueMap = this.getParamControl(ctx).getParamHashMap(params, purchaseId);
                    if (valueMap != null) {
                        this.PURSUP008.put(purchaseId, valueMap.get("PURSUP008"));
                        this.PURORDER005.put(purchaseId, valueMap.get("PURORDER005"));
                        this.PURORDER004.put(purchaseId, valueMap.get("PURORDER004"));
                        this.PURSUP007.put(purchaseId, valueMap.get("PURSUP007"));
                        this.PURORDER002.put(purchaseId, valueMap.get("PURORDER002"));
                    }
                }
                if ((purMaterialSet = (HashSet<String>)purMaterialMap.get(purchaseId)) == null) {
                    purMaterialSet = new HashSet<String>();
                    purMaterialSet.add(materialId);
                    purMaterialMap.put(purchaseId, purMaterialSet);
                } else if (!purMaterialSet.contains(materialId)) {
                    purMaterialSet.add(materialId);
                }
                if (materialSet.contains(materialId)) continue;
                materialSet.add(materialId);
            }
        }
        EntityViewInfo view = null;
        FilterInfo filter = null;
        Iterator it = purMaterialMap.entrySet().iterator();
        while (it.hasNext()) {
            view = new EntityViewInfo();
            filter = new FilterInfo();
            Map.Entry entry = it.next();
            filter.getFilterItems().add(new FilterItemInfo("material", entry.getValue(), CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)entry.getKey().toString()));
            view.setFilter(filter);
            MaterialPurchasingCollection matPurColl = MaterialPurchasingFactory.getLocalInstance((Context)ctx).getMaterialPurchasingCollection(view);
            for (int i = 0; i < matPurColl.size(); ++i) {
                MaterialPurchasingInfo info = matPurColl.get(i);
                this.materialPurchaseInfo.put(info.getMaterial().getId().toString() + "+" + entry.getKey().toString(), info);
            }
        }
        view = new EntityViewInfo();
        filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", materialSet, CompareType.INCLUDE));
        view.setFilter(filter);
        MaterialCollection matColl = MaterialFactory.getLocalInstance((Context)ctx).getMaterialCollection(view);
        for (int i = 0; i < matColl.size(); ++i) {
            this.pricePrecision.put(matColl.get(i).getId().toString(), new Integer(matColl.get(i).getPricePrecision()));
        }
    }

    private void priceBySupplyInfo(SubContractOrderEntryInfo entryInfo, PurPriceInfo priceInfo, int pricePrecision, int amtPrecision) {
        BigDecimal ZERO;
        BigDecimal rate = null;
        BigDecimal ONE = SCMConstant.BIGDECIMAL_ONE;
        BigDecimal taxPrice = ZERO = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal price = ZERO;
        BigDecimal discountAmount = ZERO;
        BigDecimal taxAmount = ZERO;
        BigDecimal tax = ZERO;
        BigDecimal amount = ZERO;
        BigDecimal actualTaxPrice = ZERO;
        BigDecimal actualPrice = ZERO;
        BigDecimal discountRate = ZERO;
        rate = entryInfo.getTaxRate().compareTo(ZERO) == 0 ? ZERO : entryInfo.getTaxRate().divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4);
        discountRate = priceInfo.getDiscountRate();
        if (priceInfo.isInTaxPrice()) {
            taxPrice = priceInfo.getPrice() != null ? priceInfo.getPrice() : ZERO;
            price = taxPrice.divide(rate.add(ONE), pricePrecision, 4);
            discountAmount = taxPrice.multiply(entryInfo.getQty()).multiply(discountRate).divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, amtPrecision, 4);
            discountAmount = discountAmount.setScale(amtPrecision, 4);
            taxAmount = entryInfo.getQty().multiply(taxPrice).subtract(discountAmount);
            taxAmount = taxAmount.setScale(amtPrecision, 4);
            tax = taxAmount.divide(rate.add(ONE), amtPrecision, 4).multiply(rate);
            tax = tax.setScale(amtPrecision, 4);
            amount = taxAmount.subtract(tax);
            amount = amount.setScale(amtPrecision, 4);
            actualTaxPrice = taxAmount.divide(entryInfo.getQty(), pricePrecision, 4);
            actualPrice = amount.divide(entryInfo.getQty(), pricePrecision, 4);
            entryInfo.setBoolean("isTax", true);
        } else {
            price = priceInfo.getPrice() != null ? priceInfo.getPrice() : ZERO;
            taxPrice = price.multiply(rate.add(ONE));
            taxPrice = taxPrice.setScale(pricePrecision, 4);
            discountAmount = taxPrice.multiply(entryInfo.getQty()).multiply(priceInfo.getDiscountRate()).divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, amtPrecision, 4);
            discountAmount = discountAmount.setScale(amtPrecision, 4);
            amount = entryInfo.getQty().multiply(price);
            amount = amount.setScale(amtPrecision, 4);
            tax = amount.multiply(rate);
            tax = tax.setScale(amtPrecision, 4);
            taxAmount = amount.add(tax).setScale(amtPrecision, 4);
            actualTaxPrice = taxAmount.divide(entryInfo.getQty(), pricePrecision, 4);
            actualPrice = amount.divide(entryInfo.getQty(), pricePrecision, 4);
            entryInfo.setBoolean("isTax", false);
        }
        entryInfo.setPrice(price);
        entryInfo.setTaxPrice(taxPrice);
        entryInfo.setActualPrice(actualPrice);
        entryInfo.setActualTaxPrice(actualTaxPrice);
        entryInfo.setAmount(amount);
        entryInfo.setTaxAmount(taxAmount);
        entryInfo.setTax(tax);
        entryInfo.setDiscountAmount(discountAmount);
        entryInfo.setDiscount(discountRate);
    }

    private void calEntryLocalAmount(Context ctx, SubContractOrderInfo orderInfo, SubContractOrderEntryInfo entryInfo) throws BOSException, EASBizException {
        BigDecimal amount = entryInfo.getAmount();
        BigDecimal exchangerate = orderInfo.getExchangeRate();
        int scale = 2;
        CompanyOrgUnitInfo companyOrgUnitInfo = orderInfo.getCompanyOrgUnit();
        OrgUnitCollection collection = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Purchase, (OrgType)OrgType.Company, (String)orderInfo.getPurchaseOrgUnit().getId().toString());
        if (companyOrgUnitInfo == null && collection != null && collection.size() > 0) {
            Object[] objs = collection.toArray();
            OrgUnitInfo[] orgs = new OrgUnitInfo[objs.length];
            System.arraycopy(objs, 0, orgs, 0, objs.length);
            SortUtil.sortDataByNumber((DataBaseInfo[])orgs, (boolean)true);
            companyOrgUnitInfo = (CompanyOrgUnitInfo)orgs[0];
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo != null) {
            excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        }
        ObjectUuidPK sourceCurrPK = new ObjectUuidPK(orderInfo.getCurrency().getId().toString());
        ObjectUuidPK destCurrPK = new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId().toString());
        if (destCurrPK.toString().equals(sourceCurrPK.toString())) {
            entryInfo.setLocalAmount(amount);
            return;
        }
        ExchangeRateInfo exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK);
        if (entryInfo.getAmount() == null || exchangeRateInfo == null) {
            entryInfo.setLocalAmount(new BigDecimal(0));
        }
        if (amount != null && exchangeRateInfo != null && exchangerate != null) {
            if (exchangeRateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entryInfo.setLocalAmount(amount.multiply(exchangerate).setScale(scale, 4));
            } else {
                entryInfo.setLocalAmount(amount.divide(exchangerate, scale, 4));
            }
        } else {
            entryInfo.setLocalAmount(amount);
        }
    }

    private void calEntryLocalAmount(SubContractOrderEntryInfo entryInfo, ExchangeRateInfo rateInfo, int localAmtPrecision) {
        BigDecimal amount = entryInfo.getAmount();
        if (amount != null && rateInfo != null) {
            BigDecimal exchangerate = rateInfo.getConvertRate().setScale(rateInfo.getPrecision(), 4);
            if (rateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entryInfo.setLocalAmount(amount.multiply(exchangerate).setScale(localAmtPrecision, 4));
            } else {
                entryInfo.setLocalAmount(amount.divide(exchangerate, localAmtPrecision, 4));
            }
        }
    }

    private void calEntryLocalTaxAmount(Context ctx, SubContractOrderInfo orderInfo, SubContractOrderEntryInfo entryInfo) throws BOSException, EASBizException {
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        BigDecimal exchangerate = orderInfo.getExchangeRate();
        int scale = 2;
        CompanyOrgUnitInfo companyOrgUnitInfo = orderInfo.getCompanyOrgUnit();
        OrgUnitCollection collection = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Purchase, (OrgType)OrgType.Company, (String)orderInfo.getPurchaseOrgUnit().getId().toString());
        if (companyOrgUnitInfo == null && collection != null && collection.size() > 0) {
            Object[] objs = collection.toArray();
            OrgUnitInfo[] orgs = new OrgUnitInfo[objs.length];
            System.arraycopy(objs, 0, orgs, 0, objs.length);
            SortUtil.sortDataByNumber((DataBaseInfo[])orgs, (boolean)true);
            companyOrgUnitInfo = (CompanyOrgUnitInfo)orgs[0];
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo != null) {
            excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        }
        ObjectUuidPK sourceCurrPK = new ObjectUuidPK(orderInfo.getCurrency().getId().toString());
        ObjectUuidPK destCurrPK = new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId().toString());
        if (destCurrPK.toString().equals(sourceCurrPK.toString())) {
            entryInfo.setLocalTaxAmount(taxAmount);
            return;
        }
        ExchangeRateInfo exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK);
        if (entryInfo.getAmount() == null || exchangeRateInfo == null) {
            entryInfo.setLocalTaxAmount(new BigDecimal(0));
        }
        if (taxAmount != null && exchangeRateInfo != null && exchangerate != null) {
            if (exchangeRateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entryInfo.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(scale, 4));
            } else {
                entryInfo.setLocalTaxAmount(taxAmount.divide(exchangerate, scale, 4));
            }
        } else {
            entryInfo.setLocalTaxAmount(taxAmount);
        }
    }

    private void calEntryLocalTaxAmount(SubContractOrderEntryInfo entryInfo, ExchangeRateInfo rateInfo, int localAmtPrecision) {
        BigDecimal taxAmount = entryInfo.getTaxAmount();
        if (taxAmount != null && rateInfo != null) {
            BigDecimal exchangerate = rateInfo.getConvertRate().setScale(rateInfo.getPrecision(), 4);
            if (rateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entryInfo.setLocalTaxAmount(taxAmount.multiply(exchangerate).setScale(localAmtPrecision, 4));
            } else {
                entryInfo.setLocalTaxAmount(taxAmount.divide(exchangerate, localAmtPrecision, 4));
            }
        }
    }

    private void calEntryLocalTax(Context ctx, SubContractOrderInfo orderInfo, SubContractOrderEntryInfo entryInfo) throws BOSException, EASBizException {
        BigDecimal tax = entryInfo.getAmount();
        BigDecimal exchangerate = orderInfo.getExchangeRate();
        int scale = 2;
        CompanyOrgUnitInfo companyOrgUnitInfo = orderInfo.getCompanyOrgUnit();
        OrgUnitCollection collection = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Purchase, (OrgType)OrgType.Company, (String)orderInfo.getPurchaseOrgUnit().getId().toString());
        if (companyOrgUnitInfo == null && collection != null && collection.size() > 0) {
            Object[] objs = collection.toArray();
            OrgUnitInfo[] orgs = new OrgUnitInfo[objs.length];
            System.arraycopy(objs, 0, orgs, 0, objs.length);
            SortUtil.sortDataByNumber((DataBaseInfo[])orgs, (boolean)true);
            companyOrgUnitInfo = (CompanyOrgUnitInfo)orgs[0];
        }
        ExchangeTableInfo exchangeTableInfo = companyOrgUnitInfo.getBaseExchangeTable();
        ObjectUuidPK excTablepk = null;
        if (exchangeTableInfo != null) {
            excTablepk = new ObjectUuidPK(exchangeTableInfo.getId());
        }
        ObjectUuidPK sourceCurrPK = new ObjectUuidPK(orderInfo.getCurrency().getId().toString());
        ObjectUuidPK destCurrPK = new ObjectUuidPK(companyOrgUnitInfo.getBaseCurrency().getId().toString());
        if (destCurrPK.toString().equals(sourceCurrPK.toString())) {
            entryInfo.setLocalTax(tax);
            return;
        }
        ExchangeRateInfo exchangeRateInfo = SCMBillCommonFacadeFactory.getLocalInstance((Context)ctx).getCurrentExchangeRate((IObjectPK)excTablepk, (IObjectPK)sourceCurrPK, (IObjectPK)destCurrPK);
        if (entryInfo.getAmount() == null || exchangeRateInfo == null) {
            entryInfo.setLocalTax(new BigDecimal(0));
        }
        if (tax != null && exchangeRateInfo != null && exchangerate != null) {
            if (exchangeRateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entryInfo.setLocalTax(tax.multiply(exchangerate).setScale(scale, 4));
            } else {
                entryInfo.setLocalTax(tax.divide(exchangerate, scale, 4));
            }
        } else {
            entryInfo.setLocalTax(tax);
        }
    }

    private void calEntryLocalTax(SubContractOrderEntryInfo entryInfo, ExchangeRateInfo rateInfo, int localAmtPrecision) {
        BigDecimal tax = entryInfo.getAmount();
        if (tax != null && rateInfo != null) {
            BigDecimal exchangerate = rateInfo.getConvertRate().setScale(rateInfo.getPrecision(), 4);
            if (rateInfo.getExchangeAux().getConvertMode() == ConvertModeEnum.DIRECTEXCHANGERATE) {
                entryInfo.setLocalTax(tax.multiply(exchangerate).setScale(localAmtPrecision, 4));
            } else {
                entryInfo.setLocalTax(tax.divide(exchangerate, localAmtPrecision, 4));
            }
        }
    }

    private IParamControl getParamControl(Context ctx) throws BOSException {
        return ParamControlFactory.getLocalInstance((Context)ctx);
    }

    public Map getMaterialPurchases(Context ctx, Map map) throws BOSException {
        HashMap<String, MaterialPurchasingInfo> matPurchase = new HashMap<String, MaterialPurchasingInfo>();
        MaterialPurchasingInfo matPurchaseInfo = null;
        IMaterialPurchasing iMatPurchase = MaterialPurchasingFactory.getLocalInstance((Context)ctx);
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        String mateID = "";
        String orgID = "";
        String mskStr = "";
        String key = "";
        StringBuffer msk = new StringBuffer();
        int reaSize = 0;
        boolean isNeedSelect = false;
        List list = null;
        if (map == null) {
            return null;
        }
        Iterator iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            key = iterator.next().toString();
            list = (List)map.get(key);
            if (list == null || list.size() <= 0 || list.get(0) == null || list.get(1) == null) continue;
            orgID = list.get(0).toString();
            mateID = list.get(1).toString();
            filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)mateID, CompareType.EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)orgID, CompareType.EQUALS));
            msk.append("(#").append(2 * reaSize).append(" and #").append(2 * reaSize + 1).append(") or ");
            ++reaSize;
            isNeedSelect = true;
        }
        if (msk.length() > 0) {
            mskStr = msk.delete(msk.lastIndexOf("or"), msk.length() - 1).toString();
            if (reaSize > 1) {
                filter.setMaskString(mskStr);
            }
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("supplier.id"));
        sic.add(new SelectorItemInfo("supplier.name"));
        sic.add(new SelectorItemInfo("supplier.number"));
        sic.add(new SelectorItemInfo("supplier.taxRate"));
        sic.add(new SelectorItemInfo("supplier.isOuter"));
        sic.add(new SelectorItemInfo("material.id"));
        sic.add(new SelectorItemInfo("material.name"));
        sic.add(new SelectorItemInfo("material.number"));
        sic.add(new SelectorItemInfo("material.pricePrecision"));
        sic.add(new SelectorItemInfo("orgUnit.id"));
        sic.add(new SelectorItemInfo("orgUnit.name"));
        sic.add(new SelectorItemInfo("orgUnit.number"));
        sic.add(new SelectorItemInfo("useSupplyList"));
        sic.add(new SelectorItemInfo("useSupplyPrice"));
        sic.add(new SelectorItemInfo("price"));
        sic.add(new SelectorItemInfo("status"));
        view.setSelector(sic);
        view.setFilter(filter);
        if (isNeedSelect) {
            MaterialPurchasingCollection coll = iMatPurchase.getMaterialPurchasingCollection(view);
            int count = coll.size();
            for (int j = 0; j < count; ++j) {
                matPurchaseInfo = coll.get(j);
                if (matPurchaseInfo == null || matPurchaseInfo.getMaterial() == null || matPurchaseInfo.getOrgUnit() == null) continue;
                key = matPurchaseInfo.getMaterial().getId().toString() + matPurchaseInfo.getOrgUnit().getId().toString();
                if (!matPurchase.containsKey(key)) {
                    matPurchase.put(key, matPurchaseInfo);
                }
                if (this.pricePrecision.containsKey(matPurchaseInfo.getMaterial().getId().toString())) continue;
                this.pricePrecision.put(matPurchaseInfo.getMaterial().getId().toString(), new Integer(matPurchaseInfo.getMaterial().getPricePrecision()));
            }
        }
        return matPurchase;
    }

    @Override
    protected HashMap _getPriceWhenBotp(Context ctx, SubContractOrderCollection collection) throws BOSException, EASBizException {
        BigDecimal ZERO;
        HashMap<String, String> errorMap = new HashMap<String, String>();
        SubContractOrderInfo orderInfo = null;
        SubContractOrderEntryInfo entryInfo = null;
        Map map = new HashMap();
        HashMap materialPurMap = new HashMap();
        ArrayList<String> materialPurList = null;
        String orgID = "";
        String materialID = "";
        HashMap<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
        MaterialPurchasingInfo mpurInfo = null;
        SupplierPurchaseInfoInfo spurInfo = null;
        SupplierCompanyInfoInfo scomInfo = null;
        String supplierID = "";
        List list = null;
        ExchangeRateInfo rateInfo = null;
        String str = "";
        int localAmtPrecision = 0;
        BigDecimal exchangeRate = ZERO = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal totalAmout = ZERO;
        BigDecimal totalTax = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        BigDecimal localTotalAmount = ZERO;
        BigDecimal localTotalTaxAmount = ZERO;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            orderInfo = collection.get(i);
            if (orderInfo == null || orderInfo.getPurchaseOrgUnit() == null || orderInfo.getPurchaseOrgUnit() == null) continue;
            orgID = orderInfo.getPurchaseOrgUnit().getId().toString();
            if (orderInfo.getCompanyOrgUnit() != null && !companyMap.containsKey(orgID)) {
                companyMap.put(orgID, orderInfo.getCompanyOrgUnit());
            }
            if (orderInfo.getBizDate() == null) {
                orderInfo.setBizDate(SysUtil.getAppServerTime((Context)ctx));
            }
            int count = orderInfo.getEntries().size();
            for (int j = 0; j < count; ++j) {
                entryInfo = orderInfo.getEntries().get(j);
                if (entryInfo == null) continue;
                if (entryInfo.getMaterial() != null && !materialPurMap.containsKey((materialID = entryInfo.getMaterial().getId().toString()) + orgID)) {
                    materialPurList = new ArrayList<String>();
                    materialPurList.add(0, orgID);
                    materialPurList.add(1, materialID);
                    materialPurMap.put(materialID + orgID, materialPurList);
                }
                if (entryInfo.getDeliveryDate() == null) {
                    entryInfo.setDeliveryDate(orderInfo.getBizDate());
                }
                entryInfo.setUnReceiveBaseQty(entryInfo.getBaseQty());
                entryInfo.setUnReceiveQty(entryInfo.getQty());
            }
        }
        Map mpurMap = this.getMaterialPurchases(ctx, materialPurMap);
        Map supplierMap = this.getSupplier(ctx, mpurMap, materialPurMap, companyMap);
        Map supplierPurMap = this.getSupplierPurchase(ctx, supplierMap);
        Map supplierComMap = this.getSupplierCompany(ctx, supplierPurMap);
        Map exchangeMap = this.getExchangeRate(ctx, supplierComMap, companyMap);
        this.getParams(ctx, exchangeMap);
        map = this.getConditionMap(ctx, exchangeMap, mpurMap, collection);
        Map approvedMap = this.getApprovedSupplier(ctx, map);
        PurPriceParamCollection paramCol = new PurPriceParamCollection();
        paramCol.setBillTypeId("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=");
        int orderBaseSeq = 10000;
        int size2 = collection.size();
        for (int i = 0; i < size2; ++i) {
            orderInfo = collection.get(i);
            if (orderInfo == null || orderInfo.getPurchaseOrgUnit() == null) continue;
            orgID = orderInfo.getPurchaseOrgUnit().getId().toString();
            orderInfo.setIsTaxExcluded(true);
            if (orderInfo.getCompanyOrgUnit() != null && this.localAmtPre != null && this.localAmtPre.get(orderInfo.getCompanyOrgUnit().getId().toString()) != null) {
                localAmtPrecision = Integer.parseInt(this.localAmtPre.get(orderInfo.getCompanyOrgUnit().getId().toString()).toString());
            }
            totalAmout = ZERO;
            totalTax = ZERO;
            totalTaxAmount = ZERO;
            localTotalAmount = ZERO;
            localTotalTaxAmount = ZERO;
            int count = orderInfo.getEntries().size();
            for (int j = 0; j < count; ++j) {
                Object[] strs;
                entryInfo = orderInfo.getEntries().get(j);
                if (entryInfo == null || entryInfo.getMaterial() == null || entryInfo.getUnit() == null) continue;
                materialID = entryInfo.getMaterial().getId().toString();
                if (mpurMap == null || !mpurMap.containsKey(materialID + orgID)) {
                    strs = new String[]{entryInfo.getMaterial().getNumber(), orderInfo.getPurchaseOrgUnit().getNumber()};
                    str = MessageFormat.format(SCMUtils.getResource((String)RESSOURCE, (String)"setMaterialPurchaseInfo", (Context)ctx), strs);
                    errorMap.put(entryInfo.getSourceBillId(), str);
                    continue;
                }
                mpurInfo = (MaterialPurchasingInfo)mpurMap.get(materialID + orgID);
                if (mpurInfo.getSupplier() == null) {
                    strs = new String[]{mpurInfo.getMaterial().getNumber(), mpurInfo.getOrgUnit().getNumber()};
                    str = MessageFormat.format(SCMUtils.getResource((String)RESSOURCE, (String)"setMaterialPurchaseSupplier", (Context)ctx), strs);
                    errorMap.put(entryInfo.getSourceBillId(), str);
                    continue;
                }
                supplierID = mpurInfo.getSupplier().getId().toString();
                if (supplierMap == null || supplierMap.get(orgID + supplierID) == null) {
                    strs = new String[]{mpurInfo.getSupplier().getNumber()};
                    str = MessageFormat.format(SCMUtils.getResource((String)RESSOURCE, (String)"supplierNotSubContract", (Context)ctx), strs);
                    errorMap.put(entryInfo.getSourceBillId(), str);
                    continue;
                }
                if (supplierPurMap != null && supplierPurMap.containsKey(orgID + supplierID)) {
                    orderInfo.setSupplier(mpurInfo.getSupplier());
                    list = (List)supplierPurMap.get(orgID + supplierID);
                    if (list == null || list.size() < 5 || list.get(4) == null) continue;
                    spurInfo = (SupplierPurchaseInfoInfo)list.get(4);
                    orderInfo.setPurchaseGroup(spurInfo.getPurchaseGroup());
                    orderInfo.setPurchasePerson(spurInfo.getDefaultPurchaser());
                    if (supplierComMap != null && supplierComMap.containsKey(orgID + supplierID)) {
                        list = (List)supplierComMap.get(orgID + supplierID);
                        if (list == null || list.size() < 6 || list.get(5) == null) continue;
                        scomInfo = (SupplierCompanyInfoInfo)list.get(5);
                        orderInfo.setPaymentCondition(scomInfo.getPayCondition());
                        if (scomInfo.getPaymentType() != null && orderInfo.getPaymentType() == null) {
                            orderInfo.setPaymentType(scomInfo.getPaymentType());
                        }
                        if (orderInfo.getSettlementType() == null && scomInfo.getSettlementType() != null) {
                            orderInfo.setSettlementType(scomInfo.getSettlementType());
                        }
                        orderInfo.setCurrency(scomInfo.getSettlementCurrency());
                        if (scomInfo.getPayCondition() != null && scomInfo.getPayCondition().getPrepayRate() != null) {
                            orderInfo.setPrepaymentRate(scomInfo.getPayCondition().getPrepayRate());
                        }
                        if (exchangeMap != null && exchangeMap.containsKey(orgID + supplierID)) {
                            list = (List)exchangeMap.get(orgID + supplierID);
                            if (list != null && list.size() >= 7 && list.get(6) != null) {
                                if (list.get(6) instanceof BigDecimal) {
                                    exchangeRate = (BigDecimal)list.get(6);
                                    orderInfo.setExchangeRate(exchangeRate.setScale(2));
                                } else if (list.get(6) instanceof ExchangeRateInfo) {
                                    rateInfo = (ExchangeRateInfo)list.get(6);
                                    exchangeRate = rateInfo.getConvertRate().setScale(rateInfo.getPrecision(), 4);
                                    orderInfo.setExchangeRate(exchangeRate);
                                }
                                str = this.getInfoByApprovedSupplier(ctx, entryInfo, orgID, supplierID, materialID, mpurMap, approvedMap);
                                if (str.length() <= 0) continue;
                                errorMap.put(entryInfo.getSourceBillId(), str);
                                continue;
                            }
                            if (orderInfo.getCompanyOrgUnit().getBaseCurrency() == null || orderInfo.getCurrency() == null) continue;
                            strs = new String[]{orderInfo.getCurrency().getNumber(), orderInfo.getCompanyOrgUnit().getBaseCurrency().getNumber()};
                            str = MessageFormat.format(SCMUtils.getResource((String)RESSOURCE, (String)"setExchangeRate", (Context)ctx), strs);
                            errorMap.put(entryInfo.getSourceBillId(), str);
                            continue;
                        }
                        if (orderInfo.getCompanyOrgUnit().getBaseCurrency() == null || orderInfo.getCurrency() == null) continue;
                        strs = new String[]{orderInfo.getCurrency().getNumber(), orderInfo.getCompanyOrgUnit().getBaseCurrency().getNumber()};
                        str = MessageFormat.format(SCMUtils.getResource((String)RESSOURCE, (String)"setExchangeRate", (Context)ctx), strs);
                        errorMap.put(entryInfo.getSourceBillId(), str);
                        continue;
                    }
                    strs = new String[]{mpurInfo.getSupplier().getNumber(), orderInfo.getCompanyOrgUnit().getNumber()};
                    str = MessageFormat.format(SCMUtils.getResource((String)RESSOURCE, (String)"setSupplierCompany", (Context)ctx), strs);
                    errorMap.put(entryInfo.getSourceBillId(), str);
                    continue;
                }
                strs = new String[]{mpurInfo.getSupplier().getNumber(), orderInfo.getPurchaseOrgUnit().getNumber()};
                str = MessageFormat.format(SCMUtils.getResource((String)RESSOURCE, (String)"setSupplierPurchase", (Context)ctx), strs);
                errorMap.put(entryInfo.getSourceBillId(), str);
            }
            paramCol.setBizTypeId(orderInfo.getBizType() != null ? orderInfo.getBizType().getId().toString() : null);
            for (int k = 0; k < orderInfo.getEntries().size(); ++k) {
                entryInfo = orderInfo.getEntries().get(k);
                if (entryInfo.getMaterial() == null || entryInfo.isIsPresent()) continue;
                int seq = orderBaseSeq * (i + 1) + k;
                PurPriceParam param = this.getPriceParam(seq, orderInfo, entryInfo);
                paramCol.addPurPriceParam(param);
            }
        }
        this.fetchPrice(ctx, collection, paramCol, orderBaseSeq, exchangeMap, mpurMap);
        return errorMap;
    }

    private void fetchPrice(Context ctx, SubContractOrderCollection collection, PurPriceParamCollection paramCol, int orderBaseSeq, Map exchangeMap, Map mpurMap) throws BOSException, EASBizException {
        BigDecimal ZERO;
        SubContractOrderInfo orderInfo = null;
        SubContractOrderEntryInfo entryInfo = null;
        PurPriceInfoCollection cols = PurServiceFacadeFactory.getLocalInstance(ctx).fetchPrice(paramCol);
        BigDecimal exchangeRate = ZERO = new BigDecimal("0.00");
        ExchangeRateInfo rateInfo = null;
        BigDecimal totalAmout = ZERO;
        BigDecimal totalTax = ZERO;
        BigDecimal totalTaxAmount = ZERO;
        BigDecimal localTotalAmount = ZERO;
        BigDecimal localTotalTaxAmount = ZERO;
        int localAmtPrecision = 4;
        for (int i = 0; i < collection.size(); ++i) {
            orderInfo = collection.get(i);
            if (orderInfo == null || orderInfo.getPurchaseOrgUnit() == null) continue;
            for (int j = 0; j < orderInfo.getEntries().size(); ++j) {
                List list;
                entryInfo = orderInfo.getEntries().get(j);
                int seq = orderBaseSeq * (i + 1) + j;
                PurPriceInfo priceInfo = cols.getPurPriceInfoBySeq(seq);
                if (priceInfo != null && priceInfo.getPrice() != null) {
                    int amtPrecision = 4;
                    if (orderInfo.getCurrency() != null) {
                        amtPrecision = orderInfo.getCurrency().getPrecision();
                    }
                    PurOrderCal purCal = new PurOrderCal();
                    purCal.setISPRICE_EXCLUDE_TAX("isTaxExcluded");
                    purCal.setDISCOUNT("discount");
                    purCal.setInTax(priceInfo.isInTaxPrice());
                    this.setPrecision(priceInfo.getPricePrecision(), orderInfo, entryInfo);
                    entryInfo.setDiscount(priceInfo.getDiscountRate());
                    if (priceInfo.isInTaxPrice()) {
                        entryInfo.setTaxPrice(priceInfo.getPrice());
                        purCal.calByEntryTaxPriceChange((SCMBillBaseInfo)orderInfo, (SCMBillEntryBaseInfo)entryInfo);
                    } else {
                        entryInfo.setPrice(priceInfo.getPrice());
                        purCal.calByEntryPriceChange((SCMBillBaseInfo)orderInfo, (SCMBillEntryBaseInfo)entryInfo);
                    }
                }
                String orgID = orderInfo.getPurchaseOrgUnit().getId().toString();
                String materialID = entryInfo.getMaterial().getId().toString();
                String supplierID = null;
                MaterialPurchasingInfo mpurInfo = (MaterialPurchasingInfo)mpurMap.get(materialID + orgID);
                if (mpurInfo != null && mpurInfo.getSupplier() != null) {
                    supplierID = mpurInfo.getSupplier().getId().toString();
                }
                if (exchangeMap == null || !exchangeMap.containsKey(orgID + supplierID)) continue;
                if (orderInfo.getCompanyOrgUnit() != null && this.localAmtPre != null && this.localAmtPre.get(orderInfo.getCompanyOrgUnit().getId().toString()) != null) {
                    localAmtPrecision = Integer.parseInt(this.localAmtPre.get(orderInfo.getCompanyOrgUnit().getId().toString()).toString());
                }
                if ((list = (List)exchangeMap.get(orgID + supplierID)) == null || list.size() < 7 || list.get(6) == null) continue;
                if (list.get(6) instanceof BigDecimal) {
                    exchangeRate = (BigDecimal)list.get(6);
                    orderInfo.setExchangeRate(exchangeRate.setScale(2));
                } else if (list.get(6) instanceof ExchangeRateInfo) {
                    rateInfo = (ExchangeRateInfo)list.get(6);
                    if (rateInfo != null) {
                        exchangeRate = rateInfo.getConvertRate().setScale(rateInfo.getPrecision(), 4);
                    }
                    orderInfo.setExchangeRate(exchangeRate);
                }
                if (list.get(6) instanceof BigDecimal) {
                    entryInfo.setLocalAmount(entryInfo.getAmount());
                    entryInfo.setLocalTaxAmount(entryInfo.getTaxAmount());
                    entryInfo.setLocalTax(entryInfo.getTax());
                } else if (list.get(6) instanceof ExchangeRateInfo) {
                    this.calEntryLocalAmount(entryInfo, rateInfo, localAmtPrecision);
                    this.calEntryLocalTaxAmount(entryInfo, rateInfo, localAmtPrecision);
                    this.calEntryLocalTax(entryInfo, rateInfo, localAmtPrecision);
                }
                totalAmout = totalAmout.add(entryInfo.getAmount() == null ? ZERO : entryInfo.getAmount());
                totalTax = totalTax.add(entryInfo.getTax() == null ? ZERO : entryInfo.getTax());
                totalTaxAmount = totalTaxAmount.add(entryInfo.getTaxAmount() == null ? ZERO : entryInfo.getTaxAmount());
                localTotalAmount = localTotalAmount.add(entryInfo.getLocalAmount() == null ? ZERO : entryInfo.getLocalAmount());
                localTotalTaxAmount = localTotalTaxAmount.add(entryInfo.getLocalTaxAmount() == null ? ZERO : entryInfo.getLocalTaxAmount());
            }
            orderInfo.setTotalAmount(totalAmout);
            orderInfo.setTotalTax(totalTax);
            orderInfo.setTotalTaxAmount(totalTaxAmount);
            orderInfo.setLocalTotalAmount(localTotalAmount);
            orderInfo.setLocalTotalTaxAmount(localTotalTaxAmount);
        }
    }

    private PurPriceParam getPriceParam(int seq, SubContractOrderInfo info, SubContractOrderEntryInfo entryInfo) {
        PurPriceParam param = new PurPriceParam();
        param.setBillTypeId("kvQieV/4TJ+1ipJVFBlPx0Y+1VI=");
        param.setSeq(seq);
        param.setPurOrgUnitId(info.getPurchaseOrgUnit() != null ? info.getPurchaseOrgUnit().getId().toString() : null);
        param.setSupplierId(info.getSupplier() != null ? info.getSupplier().getId().toString() : null);
        param.setMaterialId(entryInfo.getMaterial() != null ? entryInfo.getMaterial().getId().toString() : null);
        param.setMaterialPurchaseType(1);
        param.setUnitId(entryInfo.getUnit() != null ? entryInfo.getUnit().getId().toString() : null);
        param.setCurrencyId(info.getCurrency() != null ? info.getCurrency().getId().toString() : null);
        param.setBizDate(info.getBizDate());
        param.setDeliveryDate(entryInfo.getDeliveryDate());
        param.setAssistPropertyId(entryInfo.getAssistProperty() != null ? entryInfo.getAssistProperty().getId().toString() : null);
        param.setQty(entryInfo.getQty());
        param.setBizTypeId(info.getBizType() != null ? info.getBizType().getId().toString() : null);
        return param;
    }

    private void setPrecision(int precision, SubContractOrderInfo info, SubContractOrderEntryInfo entryInfo) {
        BigDecimal zero = new BigDecimal("0.00000000");
        if (info.getCurrency() != null) {
            BigDecimal amountWithPrecision = zero.setScale(info.getCurrency().getPrecision(), 4);
            entryInfo.setTaxAmount(amountWithPrecision);
            entryInfo.setAmount(amountWithPrecision);
            entryInfo.setDiscountAmount(amountWithPrecision);
        }
        entryInfo.setPrice(zero.setScale(precision, 4));
        entryInfo.setTaxPrice(zero.setScale(precision, 4));
        entryInfo.setActualPrice(zero.setScale(precision, 4));
        entryInfo.setActualTaxPrice(zero.setScale(precision, 4));
    }

    private String getInfoByApprovedSupplier(Context ctx, SubContractOrderEntryInfo entryInfo, String orgID, String supplierID, String materialID, Map mpurMap, Map approvedMap) throws BOSException {
        String str = "";
        MaterialPurchasingInfo mpurInfo = null;
        ApprovedSupplierInfo asInfo = null;
        BigDecimal taxRate = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal deliverAdvanceDay = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal deliverDeferralDay = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal receiveOverRate = SCMConstant.BIGDECIMAL_ZERO;
        BigDecimal receiveOwingRate = SCMConstant.BIGDECIMAL_ZERO;
        boolean isQtyUnCtrl = false;
        boolean isTimeUnCtrl = false;
        int leadTime = 0;
        if (orgID != null && supplierID != null && materialID != null) {
            boolean isUseApprovedSupplier = Boolean.valueOf(this.PURSUP001.get(orgID).toString());
            boolean isUseApprovedByMaterialPur = false;
            if (mpurMap != null && mpurMap.get(materialID + orgID) != null) {
                mpurInfo = (MaterialPurchasingInfo)mpurMap.get(materialID + orgID);
                isUseApprovedByMaterialPur = mpurInfo.isUseSupplyList();
            }
            boolean isFirstGetTaxRate = Boolean.valueOf(this.PURORDER003.get(orgID).toString());
            if (isUseApprovedSupplier) {
                if (isUseApprovedByMaterialPur) {
                    if (approvedMap != null && approvedMap.containsKey(orgID + supplierID + materialID)) {
                        asInfo = (ApprovedSupplierInfo)approvedMap.get(orgID + supplierID + materialID);
                        if (isFirstGetTaxRate) {
                            taxRate = asInfo.getTaxRate();
                        } else if (mpurInfo != null && mpurInfo.getSupplier() != null) {
                            taxRate = mpurInfo.getSupplier().getTaxRate();
                        }
                        deliverAdvanceDay = asInfo.getDayTop();
                        deliverDeferralDay = asInfo.getDayBottom();
                        receiveOverRate = asInfo.getQtySupplyTop();
                        receiveOwingRate = asInfo.getQtySupplyBottom();
                        isQtyUnCtrl = asInfo.isQuantityUnCtrl();
                        isTimeUnCtrl = asInfo.isTimeUnCtrl();
                        leadTime = asInfo.getLeadtime();
                    } else if (mpurInfo != null) {
                        Object[] strs = new String[]{mpurInfo.getOrgUnit().getNumber(), mpurInfo.getSupplier().getNumber(), mpurInfo.getMaterial().getNumber()};
                        str = MessageFormat.format(SCMUtils.getResource((String)RESSOURCE, (String)"approvedSupplierNotExists", (Context)ctx), strs);
                    }
                } else if (approvedMap != null && approvedMap.containsKey(orgID + supplierID + materialID)) {
                    asInfo = (ApprovedSupplierInfo)approvedMap.get(orgID + supplierID + materialID);
                    if (isFirstGetTaxRate) {
                        taxRate = asInfo.getTaxRate();
                    } else if (mpurInfo != null && mpurInfo.getSupplier() != null) {
                        taxRate = mpurInfo.getSupplier().getTaxRate();
                    }
                    deliverAdvanceDay = asInfo.getDayTop();
                    deliverDeferralDay = asInfo.getDayBottom();
                    receiveOverRate = asInfo.getQtySupplyTop();
                    receiveOwingRate = asInfo.getQtySupplyBottom();
                    isQtyUnCtrl = asInfo.isQuantityUnCtrl();
                    isTimeUnCtrl = asInfo.isTimeUnCtrl();
                    leadTime = asInfo.getLeadtime();
                } else if (mpurInfo != null) {
                    if (mpurInfo.getSupplier() != null) {
                        taxRate = mpurInfo.getSupplier().getTaxRate();
                    }
                    deliverAdvanceDay = new BigDecimal(mpurInfo.getDaydAhead());
                    deliverDeferralDay = new BigDecimal(mpurInfo.getDaysDelay());
                    receiveOverRate = new BigDecimal(mpurInfo.getReceiveTopRatio());
                    receiveOwingRate = new BigDecimal(mpurInfo.getReceiveBottomRatio());
                    isQtyUnCtrl = mpurInfo.isIsNotControlQty();
                    isTimeUnCtrl = mpurInfo.isIsNotControlTime();
                }
            } else {
                if (approvedMap != null && approvedMap.containsKey(orgID + supplierID + materialID)) {
                    asInfo = (ApprovedSupplierInfo)approvedMap.get(orgID + supplierID + materialID);
                    if (isFirstGetTaxRate) {
                        taxRate = asInfo.getTaxRate();
                    }
                } else if (mpurInfo != null && mpurInfo.getSupplier() != null) {
                    taxRate = mpurInfo.getSupplier().getTaxRate();
                }
                if (mpurInfo != null) {
                    deliverAdvanceDay = new BigDecimal(mpurInfo.getDaydAhead());
                    deliverDeferralDay = new BigDecimal(mpurInfo.getDaysDelay());
                    receiveOverRate = new BigDecimal(mpurInfo.getReceiveTopRatio());
                    receiveOwingRate = new BigDecimal(mpurInfo.getReceiveBottomRatio());
                    isQtyUnCtrl = mpurInfo.isIsNotControlQty();
                    isTimeUnCtrl = mpurInfo.isIsNotControlTime();
                }
            }
            entryInfo.setTaxRate(taxRate);
            entryInfo.setDeliverAdvanceDay(deliverAdvanceDay);
            entryInfo.setDeliverDeferralDay(deliverDeferralDay);
            entryInfo.setReceiveOverRate(receiveOverRate);
            entryInfo.setReceiveOwingRate(receiveOwingRate);
            entryInfo.setIsQtyUnCtrl(isQtyUnCtrl);
            entryInfo.setIsTimeUnCtrl(isTimeUnCtrl);
            entryInfo.setPurAdvanceDays(leadTime);
        }
        return str;
    }

    private Map getSupplier(Context ctx, Map mpurMap, Map materialPurMap, Map companyMap) throws BOSException {
        HashMap supplierMap = new HashMap();
        String materialID = "";
        String orgID = "";
        String supplierID = "";
        String companyID = "";
        String key = "";
        if (mpurMap != null && mpurMap.size() > 0) {
            Iterator iterator = mpurMap.keySet().iterator();
            MaterialPurchasingInfo mpInfo = null;
            ArrayList<String> list = null;
            while (iterator.hasNext()) {
                key = iterator.next().toString();
                mpInfo = (MaterialPurchasingInfo)mpurMap.get(key);
                if (mpInfo == null || mpInfo.getSupplier() == null || mpInfo.getMaterial() == null || mpInfo.getOrgUnit() == null || !mpInfo.getSupplier().isIsOuter()) continue;
                materialID = mpInfo.getMaterial().getId().toString();
                orgID = mpInfo.getOrgUnit().getId().toString();
                supplierID = mpInfo.getSupplier().getId().toString();
                if (materialPurMap.containsKey(materialID + orgID)) {
                    materialPurMap.put(materialID + orgID, mpInfo);
                }
                if (supplierMap.containsKey(orgID + supplierID) || !companyMap.containsKey(orgID)) continue;
                list = new ArrayList<String>();
                list.add(0, orgID);
                list.add(1, supplierID);
                companyID = ((CompanyOrgUnitInfo)companyMap.get(orgID)).getId().toString();
                list.add(2, companyID);
                list.add(3, materialID);
                supplierMap.put(orgID + supplierID, list);
            }
        }
        return supplierMap;
    }

    private Map getSupplierPurchase(Context ctx, Map supplierMap) throws BOSException {
        HashMap<String, List> map = new HashMap<String, List>();
        String orgID = "";
        String supplierID = "";
        String key = "";
        if (supplierMap != null && supplierMap.size() > 0) {
            Iterator iterator = supplierMap.keySet().iterator();
            List list = null;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String mskStr = "";
            int reaSize = 0;
            StringBuffer msk = new StringBuffer();
            boolean isNeedSelect = false;
            while (iterator.hasNext()) {
                key = iterator.next().toString();
                list = (List)supplierMap.get(key);
                if (list == null || list.size() < 3 || list.get(0) == null || list.get(1) == null || list.get(2) == null) continue;
                orgID = list.get(0).toString();
                supplierID = list.get(1).toString();
                filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierID, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("purchaseOrgUnit.id", (Object)orgID, CompareType.EQUALS));
                msk.append("(#").append(2 * reaSize).append(" and #").append(2 * reaSize + 1).append(") or ");
                ++reaSize;
                isNeedSelect = true;
            }
            if (msk.length() > 0) {
                mskStr = msk.delete(msk.lastIndexOf("or"), msk.length() - 1).toString();
                if (reaSize > 1) {
                    filter.setMaskString(mskStr);
                }
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("supplier.id"));
            sic.add(new SelectorItemInfo("purchaseOrgUnit.id"));
            sic.add(new SelectorItemInfo("cashDiscount.id"));
            sic.add(new SelectorItemInfo("cashDiscount.name"));
            sic.add(new SelectorItemInfo("cashDiscount.number"));
            sic.add(new SelectorItemInfo("defaultPurchaser.id"));
            sic.add(new SelectorItemInfo("defaultPurchaser.name"));
            sic.add(new SelectorItemInfo("defaultPurchaser.number"));
            sic.add(new SelectorItemInfo("purchaseGroup.id"));
            sic.add(new SelectorItemInfo("purchaseGroup.name"));
            sic.add(new SelectorItemInfo("purchaseGroup.number"));
            view.setSelector(sic);
            view.setFilter(filter);
            if (isNeedSelect) {
                SupplierPurchaseInfoInfo info = null;
                SupplierPurchaseInfoCollection coll = SupplierPurchaseInfoFactory.getLocalInstance((Context)ctx).getSupplierPurchaseInfoCollection(view);
                int count = coll.size();
                for (int j = 0; j < count; ++j) {
                    info = coll.get(j);
                    if (info == null || info.getSupplier() == null || info.getPurchaseOrgUnit() == null) continue;
                    orgID = info.getPurchaseOrgUnit().getId().toString();
                    supplierID = info.getSupplier().getId().toString();
                    if (!supplierMap.containsKey(orgID + supplierID) || map.containsKey(orgID + supplierID)) continue;
                    list = (List)supplierMap.get(orgID + supplierID);
                    list.add(list.size(), info);
                    map.put(orgID + supplierID, list);
                }
            }
        }
        return map;
    }

    private Map getSupplierCompany(Context ctx, Map supplierMap) throws BOSException {
        HashMap<String, SupplierCompanyInfoInfo> map = new HashMap<String, SupplierCompanyInfoInfo>();
        HashMap<String, List> resultMap = new HashMap<String, List>();
        String orgID = "";
        String companyID = "";
        String supplierID = "";
        String key = "";
        if (supplierMap != null && supplierMap.size() > 0) {
            Iterator iterator = supplierMap.keySet().iterator();
            List list = null;
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            String mskStr = "";
            String materialID = "";
            int reaSize = 0;
            StringBuffer msk = new StringBuffer();
            boolean isNeedSelect = false;
            while (iterator.hasNext()) {
                key = iterator.next().toString();
                list = (List)supplierMap.get(key);
                if (list == null || list.size() < 3 || list.get(0) == null || list.get(1) == null || list.get(2) == null) continue;
                supplierID = list.get(1).toString();
                companyID = list.get(2).toString();
                filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierID, CompareType.EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)companyID, CompareType.EQUALS));
                msk.append("(#").append(2 * reaSize).append(" and #").append(2 * reaSize + 1).append(") or ");
                ++reaSize;
                isNeedSelect = true;
            }
            if (msk.length() > 0) {
                mskStr = msk.delete(msk.lastIndexOf("or"), msk.length() - 1).toString();
                if (reaSize > 1) {
                    filter.setMaskString(mskStr);
                }
            }
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("id"));
            sic.add(new SelectorItemInfo("supplier.id"));
            sic.add(new SelectorItemInfo("companyOrgUnit.id"));
            sic.add(new SelectorItemInfo("settlementCurrency.id"));
            sic.add(new SelectorItemInfo("settlementCurrency.name"));
            sic.add(new SelectorItemInfo("settlementCurrency.number"));
            sic.add(new SelectorItemInfo("settlementCurrency.precision"));
            sic.add(new SelectorItemInfo("settlementType.id"));
            sic.add(new SelectorItemInfo("settlementType.name"));
            sic.add(new SelectorItemInfo("settlementType.number"));
            sic.add(new SelectorItemInfo("paymentType.id"));
            sic.add(new SelectorItemInfo("paymentType.name"));
            sic.add(new SelectorItemInfo("settlementType.number"));
            sic.add(new SelectorItemInfo("payCondition.id"));
            sic.add(new SelectorItemInfo("payCondition.name"));
            sic.add(new SelectorItemInfo("payCondition.number"));
            sic.add(new SelectorItemInfo("payCondition.prepayRate"));
            view.setSelector(sic);
            view.setFilter(filter);
            if (isNeedSelect) {
                SupplierCompanyInfoInfo info = null;
                SupplierCompanyInfoCollection coll = SupplierCompanyInfoFactory.getLocalInstance((Context)ctx).getSupplierCompanyInfoCollection(view);
                int count = coll.size();
                for (int j = 0; j < count; ++j) {
                    info = coll.get(j);
                    if (info == null || info.getSupplier() == null || info.getCompanyOrgUnit() == null || info.getSettlementCurrency() == null) continue;
                    companyID = info.getCompanyOrgUnit().getId().toString();
                    supplierID = info.getSupplier().getId().toString();
                    if (map.containsKey(orgID)) continue;
                    map.put(companyID, info);
                }
            }
            iterator = supplierMap.keySet().iterator();
            while (iterator.hasNext()) {
                key = iterator.next().toString();
                list = (List)supplierMap.get(key);
                if (list == null || list.size() < 3 || list.get(2) == null || list.get(0) == null || list.get(1) == null) continue;
                orgID = list.get(0).toString();
                companyID = list.get(2).toString();
                if (map.containsKey(companyID)) {
                    list.add(list.size(), map.get(companyID));
                }
                materialID = list.get(3).toString();
                supplierID = list.get(1).toString();
                if (resultMap.containsKey(orgID + supplierID)) continue;
                resultMap.put(orgID + supplierID, list);
            }
        }
        return resultMap;
    }

    private Map getExchangeRate(Context ctx, Map supplierMap, Map companyMap) throws BOSException {
        HashMap<String, List<ExchangeRateInfo>> map = new HashMap<String, List<ExchangeRateInfo>>();
        String sourceCurrencyID = "";
        String destCurrencyID = "";
        String companyID = "";
        String exchangeTablePk = "";
        String orgID = "";
        String supplierID = "";
        String materialID = "";
        List<ExchangeRateInfo> resultList = null;
        String key = "";
        SupplierCompanyInfoInfo scInfo = null;
        if (supplierMap != null && supplierMap.size() > 0) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            Iterator iterator = supplierMap.keySet().iterator();
            List list = null;
            CompanyOrgUnitInfo companyInfo = null;
            int reaSize = 0;
            StringBuffer msk = new StringBuffer();
            String mskStr = "";
            boolean isNeedSelect = false;
            HashMap<String, String> exchangeMap = null;
            while (iterator.hasNext()) {
                key = iterator.next().toString();
                list = (List)supplierMap.get(key);
                if (list == null || list.size() < 6 || list.get(2) == null || list.get(5) == null || list.get(0) == null) continue;
                companyID = list.get(2).toString();
                orgID = list.get(0).toString();
                scInfo = (SupplierCompanyInfoInfo)list.get(5);
                if (scInfo != null && scInfo.getSettlementCurrency() != null) {
                    sourceCurrencyID = scInfo.getSettlementCurrency().getId().toString();
                }
                if (companyMap == null || !companyMap.containsKey(orgID) || (companyInfo = (CompanyOrgUnitInfo)companyMap.get(orgID)) == null || companyInfo.getBaseCurrency() == null) continue;
                destCurrencyID = companyInfo.getBaseCurrency().getId().toString();
                if (!this.localAmtPre.containsKey(companyID)) {
                    this.localAmtPre.put(companyID, new Integer(companyInfo.getBaseCurrency().getPrecision()));
                }
                if (list.get(1) == null || list.get(3) == null) continue;
                supplierID = list.get(1).toString();
                materialID = list.get(3).toString();
                if (sourceCurrencyID.length() > 0 && sourceCurrencyID.equals(destCurrencyID)) {
                    resultList = new ArrayList();
                    resultList = list;
                    resultList.add(list.size(), (ExchangeRateInfo)SCMConstant.BIGDECIMAL_ONE);
                    map.put(orgID + supplierID, resultList);
                    continue;
                }
                if (companyInfo.getBaseExchangeTable() == null || sourceCurrencyID.length() <= 0) continue;
                exchangeTablePk = companyInfo.getBaseExchangeTable().getId().toString();
                exchangeMap = new HashMap<String, String>();
                exchangeMap.put(exchangeTablePk + sourceCurrencyID + destCurrencyID, orgID + supplierID);
                filter.getFilterItems().add(new FilterItemInfo("exchangeAux.exchangeTable.id", (Object)exchangeTablePk.toString()));
                filter.getFilterItems().add(new FilterItemInfo("exchangeAux.sourceCurrency.id", (Object)sourceCurrencyID.toString()));
                filter.getFilterItems().add(new FilterItemInfo("exchangeAux.targetCurrency.id", (Object)destCurrencyID.toString()));
                filter.getFilterItems().add(new FilterItemInfo("isUsedBG", (Object)"0"));
                msk.append("(#").append(2 * reaSize).append(" and #").append(4 * reaSize + 1).append(") or ");
                ++reaSize;
                isNeedSelect = true;
            }
            if (isNeedSelect && msk.length() > 0) {
                mskStr = msk.delete(msk.lastIndexOf("or"), msk.length() - 1).toString();
                if (reaSize > 1) {
                    filter.setMaskString(mskStr);
                }
                evi.setFilter(filter);
                SorterItemInfo sortItem = new SorterItemInfo("availTime");
                sortItem.setSortType(SortType.DESCEND);
                evi.getSorter().add(sortItem);
                evi.getSelector().add(new SelectorItemInfo("id"));
                evi.getSelector().add(new SelectorItemInfo("convertRate"));
                evi.getSelector().add(new SelectorItemInfo("exchangeAux.precision"));
                evi.getSelector().add(new SelectorItemInfo("exchangeAux.exchangeTable.id"));
                evi.getSelector().add(new SelectorItemInfo("exchangeAux.sourceCurrency.id"));
                evi.getSelector().add(new SelectorItemInfo("exchangeAux.targetCurrency.id"));
                ExchangeRateInfo rateInfo = null;
                ExchangeRateCollection vos = ExchangeRateFactory.getLocalInstance((Context)ctx).getExchangeRateCollection(evi);
                if (vos != null && vos.size() > 0 && (rateInfo = vos.get(0)) != null && rateInfo.getExchangeAux() != null && rateInfo.getExchangeAux().getExchangeTable() != null && rateInfo.getExchangeAux().getSourceCurrency() != null && rateInfo.getExchangeAux().getTargetCurrency() != null) {
                    exchangeTablePk = rateInfo.getExchangeAux().getExchangeTable().getId().toString();
                    sourceCurrencyID = rateInfo.getExchangeAux().getSourceCurrency().getId().toString();
                    destCurrencyID = rateInfo.getExchangeAux().getTargetCurrency().getId().toString();
                    if (exchangeMap != null && exchangeMap.get(exchangeTablePk + sourceCurrencyID + destCurrencyID) != null && supplierMap.get(key = exchangeMap.get(exchangeTablePk + sourceCurrencyID + destCurrencyID).toString()) != null) {
                        resultList = (List)supplierMap.get(key);
                        if (list != null) {
                            resultList.add(list.size(), rateInfo);
                        }
                        map.put(key, resultList);
                    }
                }
            }
        }
        return map;
    }

    private void getParams(Context ctx, Map exchangeMap) throws BOSException, EASBizException {
        String[] params = new String[]{"PURSUP008", "PURORDER005", "PURSUP007", "PURORDER002", "PURORDER004", "PURSUP001", "PURORDER003"};
        HashMap valueMap = new HashMap();
        List list = null;
        String purchaseId = "";
        String key = "";
        if (exchangeMap != null && exchangeMap.size() > 0) {
            Iterator it = exchangeMap.keySet().iterator();
            while (it.hasNext()) {
                key = it.next().toString();
                list = (List)exchangeMap.get(key);
                if (list == null || list.size() < 4 || list.get(0) == null || list.get(3) == null) continue;
                purchaseId = list.get(0).toString();
                valueMap = this.getParamControl(ctx).getParamHashMap(params, purchaseId);
                if (valueMap == null) continue;
                this.PURSUP008.put(purchaseId, valueMap.get("PURSUP008"));
                this.PURORDER005.put(purchaseId, valueMap.get("PURORDER005"));
                this.PURORDER004.put(purchaseId, valueMap.get("PURORDER004"));
                this.PURSUP007.put(purchaseId, valueMap.get("PURSUP007"));
                this.PURORDER002.put(purchaseId, valueMap.get("PURORDER002"));
                this.PURSUP001.put(purchaseId, valueMap.get("PURSUP001"));
                this.PURORDER003.put(purchaseId, valueMap.get("PURORDER003"));
            }
        }
    }

    private Map getConditionMap(Context ctx, Map exchangeMap, Map mpurMap, SubContractOrderCollection collection) {
        HashMap map = new HashMap();
        SubContractOrderInfo orderInfo = null;
        SubContractOrderEntryInfo entryInfo = null;
        String orgID = "";
        String supplierID = "";
        String materialID = "";
        MaterialPurchasingInfo mpInfo = null;
        ArrayList<String> list = null;
        int size = collection.size();
        for (int i = 0; i < size; ++i) {
            orderInfo = collection.get(i);
            if (orderInfo == null || orderInfo.getPurchaseOrgUnit() == null || this.PURSUP001.get(orgID = orderInfo.getPurchaseOrgUnit().getId().toString()) == null || !Boolean.valueOf(this.PURSUP001.get(orgID).toString()).booleanValue()) continue;
            int count = orderInfo.getEntries().size();
            for (int j = 0; j < count; ++j) {
                entryInfo = orderInfo.getEntries().get(i);
                if (entryInfo == null || entryInfo.getMaterial() == null || entryInfo.getUnit() == null || !mpurMap.containsKey((materialID = entryInfo.getMaterial().getId().toString()) + orgID) || mpurMap.get(materialID + orgID) == null || (mpInfo = (MaterialPurchasingInfo)mpurMap.get(materialID + orgID)) == null || mpInfo.getSupplier() == null) continue;
                supplierID = mpInfo.getSupplier().getId().toString();
                if (!exchangeMap.containsKey(orgID + supplierID) || map.containsKey(orgID + supplierID)) continue;
                list = new ArrayList<String>();
                list.add(0, orgID);
                list.add(1, supplierID);
                list.add(2, materialID);
                map.put(orgID + supplierID + materialID, list);
            }
        }
        return map;
    }

    private Map getApprovedSupplier(Context ctx, Map map) throws BOSException {
        HashMap<String, ApprovedSupplierInfo> resultMap = new HashMap<String, ApprovedSupplierInfo>();
        List list = null;
        if (map != null && map.size() > 0) {
            EntityViewInfo evi = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            int reaSize = 0;
            StringBuffer msk = new StringBuffer();
            String mskStr = "";
            boolean isNeedSelect = false;
            String orgID = "";
            String supplierID = "";
            String materialID = "";
            Iterator it = map.keySet().iterator();
            String key = "";
            while (it.hasNext()) {
                key = it.next().toString();
                list = (List)map.get(key);
                if (list == null || list.size() < 3 || list.get(0) == null || list.get(1) == null || list.get(2) == null) continue;
                orgID = list.get(0).toString();
                supplierID = list.get(1).toString();
                materialID = list.get(2).toString();
                filter.getFilterItems().add(new FilterItemInfo("purchaseOrg.id", (Object)orgID));
                filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)supplierID));
                filter.getFilterItems().add(new FilterItemInfo("materialItem.id", (Object)materialID));
                filter.getFilterItems().add(new FilterItemInfo("isUseable", (Object)new Integer(1)));
                msk.append("(#").append(2 * reaSize).append(" and #").append(4 * reaSize + 1).append(") or ");
                ++reaSize;
                isNeedSelect = true;
            }
            if (isNeedSelect && msk.length() > 0) {
                mskStr = msk.delete(msk.lastIndexOf("or"), msk.length() - 1).toString();
                if (reaSize > 1) {
                    filter.setMaskString(mskStr);
                }
                evi.setFilter(filter);
                SorterItemInfo sortItem = new SorterItemInfo("auditDate");
                sortItem.setSortType(SortType.DESCEND);
                evi.getSorter().add(sortItem);
                evi.getSelector().add(new SelectorItemInfo("id"));
                evi.getSelector().add(new SelectorItemInfo("quantityUnCtrl"));
                evi.getSelector().add(new SelectorItemInfo("timeUnCtrl"));
                evi.getSelector().add(new SelectorItemInfo("dayTop"));
                evi.getSelector().add(new SelectorItemInfo("dayBottom"));
                evi.getSelector().add(new SelectorItemInfo("qtySupplyTop"));
                evi.getSelector().add(new SelectorItemInfo("qtySupplyBottom"));
                evi.getSelector().add(new SelectorItemInfo("taxRate"));
                evi.getSelector().add(new SelectorItemInfo("purchaseOrg.id"));
                evi.getSelector().add(new SelectorItemInfo("supplier.id"));
                evi.getSelector().add(new SelectorItemInfo("materialItem.id"));
                evi.getSelector().add(new SelectorItemInfo("leadtime"));
                ApprovedSupplierCollection coll = ApprovedSupplierFactory.getLocalInstance((Context)ctx).getApprovedSupplierCollection(evi);
                if (coll != null && coll.size() > 0) {
                    ApprovedSupplierInfo info = null;
                    int size = coll.size();
                    for (int i = 0; i < size; ++i) {
                        info = coll.get(i);
                        if (info == null || info.getMaterialItem() == null || info.getPurchaseOrg() == null || info.getSupplier() == null) continue;
                        orgID = info.getPurchaseOrg().getId().toString();
                        supplierID = info.getSupplier().getId().toString();
                        materialID = info.getMaterialItem().getId().toString();
                        key = orgID + supplierID + materialID;
                        if (resultMap.containsKey(key) || !map.containsKey(key)) continue;
                        resultMap.put(key, info);
                    }
                }
            }
        }
        return resultMap;
    }

    private SupplyInfoCollection getInfosWhenUsePrice(Context ctx, SubContractOrderInfo orderInfo, SubContractOrderEntryInfo entryInfo) throws BOSException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SupplyInfoCollection supplyColl = null;
        if (orderInfo.getPurchaseOrgUnit() != null && orderInfo.getSupplier() != null && entryInfo.getMaterial() != null && entryInfo.getUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo("materialItem.id", (Object)entryInfo.getMaterial().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isUseable", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)orderInfo.getSupplier().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("purchaseOrg.id", (Object)orderInfo.getPurchaseOrgUnit().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("purMeasureUnit.id", (Object)entryInfo.getUnit().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("materialPurchaseType", (Object)new Integer(1)));
            if (Boolean.valueOf(this.PURORDER004.get(orderInfo.getPurchaseOrgUnit().getId().toString()).toString()).booleanValue()) {
                filter.getFilterItems().add(new FilterItemInfo("effectualDate", (Object)entryInfo.getDeliveryDate(), CompareType.LESS_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("uneffectualDate", (Object)entryInfo.getDeliveryDate(), CompareType.GREATER_EQUALS));
            } else {
                filter.getFilterItems().add(new FilterItemInfo("effectualDate", (Object)new Timestamp(System.currentTimeMillis()), CompareType.LESS_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("uneffectualDate", (Object)new Timestamp(System.currentTimeMillis()), CompareType.GREATER_EQUALS));
            }
            if (Boolean.valueOf(this.PURSUP007.get(orderInfo.getPurchaseOrgUnit().getId().toString()).toString()).booleanValue()) {
                filter.getFilterItems().add(new FilterItemInfo("fromQty", (Object)entryInfo.getBaseQty(), CompareType.LESS_EQUALS));
                filter.getFilterItems().add(new FilterItemInfo("toQty", (Object)entryInfo.getBaseQty(), CompareType.GREATER_EQUALS));
            }
            envi.setFilter(filter);
            supplyColl = SupplyInfoFactory.getLocalInstance((Context)ctx).getSupplyInfoCollection(envi);
        }
        return supplyColl;
    }

    private void calcAmount(Context ctx, SubContractOrderInfo orderInfo) throws EASBizException, BOSException {
        BigDecimal totalAmout = new BigDecimal(0);
        BigDecimal totalTax = new BigDecimal(0);
        BigDecimal totalTaxAmount = new BigDecimal(0);
        BigDecimal localTotalAmount = new BigDecimal(0);
        BigDecimal localTotalTaxAmount = new BigDecimal(0);
        SubContractOrderEntryInfo entryInfo = null;
        int size = orderInfo.getEntries().size();
        for (int i = 0; i < size; ++i) {
            entryInfo = orderInfo.getEntries().get(i);
            if (entryInfo == null) continue;
            this.calEntryLocalAmount(ctx, orderInfo, entryInfo);
            this.calEntryLocalTaxAmount(ctx, orderInfo, entryInfo);
            this.calEntryLocalTax(ctx, orderInfo, entryInfo);
            if (entryInfo.getAmount() != null) {
                totalAmout = totalAmout.add(entryInfo.getAmount());
            }
            if (entryInfo.getTax() != null) {
                totalTax = totalTax.add(entryInfo.getTax());
            }
            totalTaxAmount = totalTaxAmount.add(totalAmout.add(totalTax));
            if (entryInfo.getLocalAmount() != null) {
                localTotalAmount = localTotalAmount.add(entryInfo.getLocalAmount());
            }
            if (entryInfo.getLocalTaxAmount() == null) continue;
            localTotalTaxAmount = localTotalTaxAmount.add(entryInfo.getLocalTaxAmount());
        }
        orderInfo.setTotalAmount(totalAmout);
        orderInfo.setTotalTax(totalTax);
        orderInfo.setTotalTaxAmount(totalTaxAmount);
        orderInfo.setLocalTotalAmount(localTotalAmount);
        orderInfo.setLocalTotalTaxAmount(localTotalTaxAmount);
    }

    private SupplyInfoCollection getInfosWhenNotUseMatPrice(Context ctx, SubContractOrderInfo orderInfo, SubContractOrderEntryInfo entryInfo) throws BOSException {
        EntityViewInfo envi = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        SupplyInfoCollection supplyColl = null;
        if (orderInfo != null && entryInfo != null && orderInfo.getSupplier() != null && orderInfo.getPurchaseOrgUnit() != null && entryInfo.getMaterial() != null && entryInfo.getUnit() != null) {
            filter.getFilterItems().add(new FilterItemInfo("materialItem.id", (Object)entryInfo.getMaterial().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("isUseable", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("materialPurchaseType", (Object)new Integer(1)));
            filter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)orderInfo.getSupplier().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("purchaseOrg.id", (Object)orderInfo.getPurchaseOrgUnit().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("purMeasureUnit.id", (Object)entryInfo.getUnit().getId().toString()));
            filter.getFilterItems().add(new FilterItemInfo("effectualDate", (Object)new Timestamp(System.currentTimeMillis()), CompareType.LESS_EQUALS));
            filter.getFilterItems().add(new FilterItemInfo("uneffectualDate", (Object)new Timestamp(System.currentTimeMillis()), CompareType.GREATER_EQUALS));
            envi.setFilter(filter);
            supplyColl = SupplyInfoFactory.getLocalInstance((Context)ctx).getSupplyInfoCollection(envi);
        }
        return supplyColl;
    }
}

