/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.customize.sm.IWSPurOrderExtendFacade;
import com.kingdee.eas.scm.customize.sm.WSPurOrderExtendFacadeFactory;
import com.kingdee.eas.scm.im.inv.ws.util.XMLUtil;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.app.AbstractWSPurOrderFacadeControllerBean;
import com.kingdee.eas.scm.sm.pur.constant.UIConstant;
import com.kingdee.eas.scm.sm.pur.util.DataImportUtils;
import com.kingdee.eas.scm.sm.pur.util.InfoUtil;
import com.kingdee.eas.util.client.ExceptionHandler;
import com.kingdee.util.NumericExceptionSubItem;
import java.math.BigDecimal;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;

public class WSPurOrderFacadeControllerBean
extends AbstractWSPurOrderFacadeControllerBean {
    private static final long serialVersionUID = -1076754172303800155L;
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.pur.app.app.WSPurOrderFacadeControllerBean");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected String[] _ImportData(Context ctx, String xmlData) throws BOSException {
        String[] msg = new String[2];
        try {
            Document doc = XMLUtil.builderDocument((String)xmlData);
            if (doc != null) {
                PurOrderInfo purOrderInfo = new PurOrderInfo();
                HashMap billHeadMap = XMLUtil.getBillHead((Document)doc);
                if (billHeadMap == null) {
                    msg[0] = "3000";
                    msg[1] = UIConstant.BILLHEAD_ERROR;
                    throw new BOSException(UIConstant.BILLHEAD_ERROR);
                }
                ArrayList billEntriesList = XMLUtil.getBillEntries((Document)doc);
                if (billEntriesList == null) {
                    msg[0] = "4000";
                    msg[1] = UIConstant.BILLENTRIES_ERROR;
                    throw new BOSException(UIConstant.BILLENTRIES_ERROR);
                }
                this.validateProperty(billHeadMap, billEntriesList);
                this.buildBillHead(ctx, purOrderInfo, billHeadMap);
                this.builBillEntries(ctx, purOrderInfo, billEntriesList);
                IWSPurOrderExtendFacade extendFacage = WSPurOrderExtendFacadeFactory.getLocalInstance((Context)ctx);
                extendFacage.extendField((IObjectValue)purOrderInfo, xmlData);
                ctx.put((Object)"disablePermissionForKScript", (Object)true);
                IPurOrder iPurOrder = PurOrderFactory.getLocalInstance(ctx);
                iPurOrder.save((CoreBaseInfo)purOrderInfo);
                msg[0] = "0000";
                msg[1] = UIConstant.SUCCESS;
                ctx.put((Object)"disablePermissionForKScript", (Object)false);
            }
        }
        catch (Exception exc) {
            msg[0] = "1111";
            msg[1] = "\nexc.getMessage():" + exc.getMessage() + "\nexc.toString():" + exc.toString();
            logger.error((Object)exc);
        }
        finally {
            ctx.put((Object)"disablePermissionForKScript", (Object)false);
        }
        return msg;
    }

    private void buildBillHead(Context ctx, PurOrderInfo info, HashMap billHeadMap) throws BOSException, ParseException {
        String[] string_Fields = new String[]{"number", "description", "sourcefunction", "sourcebillid", "suppliermaterialnumber", "supplieraddress", "supplierordernumber"};
        String[] boolean_Fields = new String[]{"haseffected", "iscentralbalance", "issysbill", "isinnersale", "supplierconfirm", "isdirectsend", "isInTax"};
        String[] bigDecimal_Fields = new String[]{"localtotaltaxamount", "localtotalamount", "unprepaidamount", "totaltaxamount", "totaltax", "totalamount", "paidamount", "invoicedamount", "prepaid", "prepayment", "prepaymentrate", "exchangerate"};
        String[] int_Fields = new String[]{"period", "year"};
        if (billHeadMap != null) {
            this.dealWithStringFields((CoreBaseInfo)info, billHeadMap, string_Fields);
            this.dealWithBooleanFields((CoreBaseInfo)info, billHeadMap, boolean_Fields);
            this.dealWithBigDecimalFields((CoreBaseInfo)info, billHeadMap, bigDecimal_Fields);
            this.dealWithIntFields((CoreBaseInfo)info, billHeadMap, int_Fields);
            this.dealwithOtherFields_Head(ctx, info, billHeadMap);
        }
    }

    private void dealwithOtherFields_Head(Context ctx, PurOrderInfo info, HashMap billHeadMap) throws BOSException, ParseException {
        Date bizDate;
        String strNumber = (String)billHeadMap.get("id");
        if (strNumber != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setId(BOSUuid.read((String)strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("cu")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setCU(DataImportUtils.getCtrlUnitInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("creator")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setCreator(DataImportUtils.getUserInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("createtime")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            try {
                Timestamp ts = Timestamp.valueOf(strNumber);
                info.setCreateTime(ts);
            }
            catch (IllegalArgumentException e) {
                info.setNull("createtime");
            }
        }
        if ((strNumber = (String)billHeadMap.get("lastupdateuser")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setLastUpdateUser(DataImportUtils.getUserInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("lastupdatetime")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            try {
                Timestamp lats = Timestamp.valueOf(strNumber);
                info.setCreateTime(lats);
            }
            catch (IllegalArgumentException e) {
                info.setNull("lastupdatetime");
            }
        }
        if ((strNumber = (String)billHeadMap.get("bizdate")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            bizDate = XMLUtil.convertStrToDate((String)strNumber, (String)"yyyy-MM-dd");
            info.setBizDate(bizDate);
        }
        if ((strNumber = (String)billHeadMap.get("handler")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setHandler(DataImportUtils.getUserInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("auditor")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setAuditor(DataImportUtils.getUserInfoFromNumber(ctx, strNumber));
        }
        strNumber = (String)billHeadMap.get("audittime");
        try {
            if (strNumber != null && strNumber.trim().length() > 0) {
                strNumber = strNumber.trim();
                Timestamp atts = Timestamp.valueOf(strNumber);
                info.setAuditTime(atts);
            }
        }
        catch (IllegalArgumentException e) {
            info.setNull("audittime");
        }
        strNumber = (String)billHeadMap.get("basestatus");
        if (strNumber != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            BillBaseStatusEnum bbse = BillBaseStatusEnum.getEnum((String)strNumber);
            info.setBaseStatus(bbse);
        }
        if ((strNumber = (String)billHeadMap.get("biztype")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setBizType(DataImportUtils.getBizTypeInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("sourcebilltype")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setSourceBillType(DataImportUtils.getBillTypeInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("billtype")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setBillType(DataImportUtils.getBillTypeInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("modifier")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setModifier(DataImportUtils.getUserInfoFromNumber(ctx, strNumber));
        }
        strNumber = (String)billHeadMap.get("modificationtime");
        try {
            if (strNumber != null && strNumber.trim().length() > 0) {
                strNumber = strNumber.trim();
                Timestamp mots = Timestamp.valueOf(strNumber);
                info.setModificationTime(mots);
            }
        }
        catch (IllegalArgumentException e) {
            info.setNull("modificationtime");
        }
        strNumber = (String)billHeadMap.get("purchaseorgunit");
        if (strNumber != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setPurchaseOrgUnit(DataImportUtils.getPurchaseUnitInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("purchasegroup")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setPurchaseGroup(DataImportUtils.getPurchaseGroupInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("purchaseperson")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setPurchasePerson(DataImportUtils.getPersonInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("supplier")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setSupplier(DataImportUtils.getSupplierInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("saleorgunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setSaleOrgUnit(DataImportUtils.getSaleOrgUnitInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("saleorder")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setSaleOrder(DataImportUtils.getSaleOrderInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("paymenttype")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setPaymentType(DataImportUtils.getPaymentTypeInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("settlementtype")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setSettlementType(DataImportUtils.getSettlementTypeInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("cashdiscount")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setCashDiscount(DataImportUtils.getCashDiscountInfoByNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("currency")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setCurrency(DataImportUtils.getCurrencyInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)billHeadMap.get("prepaymentrate")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            bizDate = XMLUtil.convertStrToDate((String)strNumber, (String)"yyyy-MM-dd");
            info.setBizDate(bizDate);
        }
        if ((strNumber = (String)billHeadMap.get("adminorgunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            info.setAdminOrgUnit(DataImportUtils.getAdminOrgUnitInfoFromNumber(ctx, strNumber));
        }
    }

    private void dealWithStringFields(CoreBaseInfo info, HashMap billHeadMap, String[] string_Fields) {
        int c = string_Fields.length;
        for (int i = 0; i < c; ++i) {
            if (billHeadMap.get(string_Fields[i]) == null) {
                info.setNull(string_Fields[i].toLowerCase().trim());
                continue;
            }
            String value = (String)billHeadMap.get(string_Fields[i]);
            info.setString(string_Fields[i].toLowerCase().trim(), value);
        }
    }

    private void dealWithBooleanFields(CoreBaseInfo info, HashMap billHeadMap, String[] boolean_Fields) {
        try {
            int c = boolean_Fields.length;
            for (int i = 0; i < c; ++i) {
                String fieldName = boolean_Fields[i].toLowerCase().trim();
                String fieldValue = (String)billHeadMap.get(boolean_Fields[i]);
                if (!(fieldValue != null && !fieldValue.trim().equals("") && fieldValue.trim().equals("true") && fieldValue.trim().equals("false") && fieldValue.trim().equals("1") && fieldValue.trim().equals("0"))) {
                    info.setNull(fieldName);
                    continue;
                }
                if (fieldValue.equals("1")) {
                    info.setBoolean(fieldName, true);
                }
                if (fieldValue.equals("0")) {
                    info.setBoolean(fieldName, false);
                }
                info.setBoolean(fieldName, Boolean.parseBoolean(fieldValue.trim()));
            }
        }
        catch (Exception e) {
            ExceptionHandler.handle((Throwable)e);
        }
    }

    private void dealWithBigDecimalFields(CoreBaseInfo info, HashMap billHeadMap, String[] bigDecimal_Fields) {
        int c = bigDecimal_Fields.length;
        for (int i = 0; i < c; ++i) {
            String fieldName = bigDecimal_Fields[i].toLowerCase().trim();
            String fieldValue = (String)billHeadMap.get(bigDecimal_Fields[i]);
            try {
                if (fieldValue == null || fieldValue.trim().equals("")) {
                    info.setNull(fieldName);
                    continue;
                }
                info.setBigDecimal(fieldName, new BigDecimal(fieldValue.trim()));
                continue;
            }
            catch (NumberFormatException ne) {
                info.setNull(fieldName);
            }
        }
    }

    private void dealWithIntFields(CoreBaseInfo info, HashMap billHeadMap, String[] int_Fields) {
        int c = int_Fields.length;
        for (int i = 0; i < c; ++i) {
            String fieldName = int_Fields[i].toLowerCase().trim();
            String fieldValue = (String)billHeadMap.get(int_Fields[i]);
            try {
                if (fieldValue == null || fieldValue.trim().equals("")) {
                    info.setNull(fieldName);
                    continue;
                }
                info.setInt(fieldName, Integer.parseInt(fieldValue.trim()));
                continue;
            }
            catch (NumberFormatException ne) {
                info.setNull(fieldName);
            }
        }
    }

    private void builBillEntries(Context ctx, PurOrderInfo info, ArrayList entriesList) throws BOSException, ParseException {
        String[] string_Fields = new String[]{"remark", "sourcebillentryid", "sourcebillnumber", "sourcebillid", "reason", "saleordernumber", "deliveryaddress", "tracknumber", "assetnumber", "suppliermaterialmodel", "suppliermaterialname", "suppliermaterialnumber"};
        String[] boolean_Fields = new String[]{"isrequesttoreceived", "issupinfo", "timeunctrl", "quantityunctrl", "ispresent"};
        String[] bigDecimal_Fields = new String[]{"associateqty", "associateqty", "totalinvoicedamt", "totalmoveqty", "prepaidamount", "localtaxamount", "localtax", "curseorderqty", "totalunreceiveqty", "totalunreceivebaseqty", "totalunreturnbaseqty", "totalinvoicedqty", "totalreturnedbaseqty", "totalreceiptbaseqty", "totalreceiptbaseqty", "totalreceivebaseqty", "totalexpense", "totalpaidamount", "totalinvoicedamount", "totalinvoicedqty", "totalreturnedqty", "totalreceiptqty", "totalreceiveqty", "baseqty", "deliverdeferralday", "deliveradvanceday", "receiveowingrate", "receiveoverrate", "discountamount", "taxamount", "tax", "localamount", "amount", "actualtaxprice", "taxprice", "taxrate", "actualprice", "discountrate", "price", "assistqty", "qty", "demandqty"};
        String[] int_Fields = new String[]{"seq", "sourcebillentryseq"};
        if (entriesList != null) {
            Object strNumber = null;
            for (int i = 0; i < entriesList.size(); ++i) {
                HashMap entryMap = (HashMap)entriesList.get(i);
                PurOrderEntryInfo purOrderEntryInfo = new PurOrderEntryInfo();
                this.dealWithStringFields((CoreBaseInfo)purOrderEntryInfo, entryMap, string_Fields);
                this.dealWithBooleanFields((CoreBaseInfo)purOrderEntryInfo, entryMap, boolean_Fields);
                this.dealWithBigDecimalFields((CoreBaseInfo)purOrderEntryInfo, entryMap, bigDecimal_Fields);
                this.dealWithIntFields((CoreBaseInfo)purOrderEntryInfo, entryMap, int_Fields);
                this.dealwithOtherFields_Entry(ctx, entryMap, purOrderEntryInfo);
                info.getEntries().add(purOrderEntryInfo);
            }
        }
    }

    private void dealwithOtherFields_Entry(Context ctx, HashMap entryMap, PurOrderEntryInfo purOrderEntryInfo) throws BOSException, ParseException {
        Date bizDate;
        String strNumber = (String)entryMap.get("material");
        if (strNumber != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            purOrderEntryInfo.setMaterial(DataImportUtils.getMaterialInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)entryMap.get("assistproperty")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            purOrderEntryInfo.setAssistProperty(DataImportUtils.getAsstAttrValueInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)entryMap.get("unit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            purOrderEntryInfo.setUnit(DataImportUtils.getMeasureUnitInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)entryMap.get("basestatus")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            EntryBaseStatusEnum enums = EntryBaseStatusEnum.getEnum((String)strNumber);
            purOrderEntryInfo.setBaseStatus(enums);
        }
        if ((strNumber = (String)entryMap.get("sourcebilltype")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            purOrderEntryInfo.setSourceBillType(DataImportUtils.getBillTypeInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)entryMap.get("baseunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            purOrderEntryInfo.setBaseUnit(DataImportUtils.getMeasureUnitInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)entryMap.get("assistunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            purOrderEntryInfo.setAssistUnit(DataImportUtils.getMeasureUnitInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)entryMap.get("reasoncode")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            purOrderEntryInfo.setReasonCode(DataImportUtils.getReasonCodeInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)entryMap.get("storageorgunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            purOrderEntryInfo.setStorageOrgUnit(DataImportUtils.getStorageOrgUnitInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)entryMap.get("adminorgunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            purOrderEntryInfo.setAdminOrgUnit(DataImportUtils.getAdminOrgUnitInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)entryMap.get("companyorgunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            purOrderEntryInfo.setCompanyOrgUnit(DataImportUtils.getCompanyOrgUnitInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)entryMap.get("deliverydate")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            bizDate = XMLUtil.convertStrToDate((String)strNumber, (String)"yyyy-MM-dd");
            purOrderEntryInfo.setDeliveryDate(bizDate);
        }
        if ((strNumber = (String)entryMap.get("closedate")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            bizDate = XMLUtil.convertStrToDate((String)strNumber, (String)"yyyy-MM-dd");
            purOrderEntryInfo.setCloseDate(bizDate);
        }
        if ((strNumber = (String)entryMap.get("requestorgunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            purOrderEntryInfo.setRequestOrgUnit(DataImportUtils.getStorageOrgUnitInfoFromNumber(ctx, strNumber));
        }
        if ((strNumber = (String)entryMap.get("requestcompanyorgunit")) != null && strNumber.trim().length() > 0) {
            strNumber = strNumber.trim();
            purOrderEntryInfo.setRequestCompanyOrgUnit(DataImportUtils.getCompanyOrgUnitInfoFromNumber(ctx, strNumber));
        }
    }

    private void validateProperty(HashMap billHeadMap, ArrayList billEntriesList) throws EASBizException {
        String[] bilHeadProps = this.getValidateBillHeadProps();
        for (int i = 0; i < bilHeadProps.length; ++i) {
            if (InfoUtil.validateProperty(billHeadMap, bilHeadProps[i])) continue;
            throw new EASBizException(new NumericExceptionSubItem("1000", bilHeadProps[i] + UIConstant.PROPNOTEMPT));
        }
        String[] bilEntriesProps = this.getValidateBillEntriesProps();
        HashMap entryMap = null;
        for (int i = 0; i < billEntriesList.size(); ++i) {
            entryMap = (HashMap)billEntriesList.get(i);
            for (int j = 0; j < bilEntriesProps.length; ++j) {
                if (InfoUtil.validateProperty(entryMap, bilEntriesProps[j])) continue;
                throw new EASBizException(new NumericExceptionSubItem("2000", bilEntriesProps[i] + UIConstant.PROPNOTEMPT));
            }
        }
    }

    private String[] getValidateBillHeadProps() {
        String[] props = new String[]{"number", "cu"};
        return props;
    }

    private String[] getValidateBillEntriesProps() {
        String[] props = new String[]{};
        return props;
    }
}

