/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.price;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurBusinessImpl;
import com.kingdee.eas.scm.sm.pur.app.price.FetchPurPriceUtil;
import com.kingdee.eas.scm.sm.pur.app.price.IPurPriceProvider;
import com.kingdee.eas.scm.sm.pur.app.price.UpDateTaxRate;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class FetchPurPriceImpl
extends AbstractPurBusinessImpl<PurPriceInfoCollection> {
    private String billTypeId = null;
    private String bizTypeId = null;
    private boolean isMerge = false;

    public FetchPurPriceImpl(Context ctx, Object param) {
        super(ctx, param);
        PurPriceParamCollection paramCol = (PurPriceParamCollection)param;
        this.billTypeId = paramCol.getBillTypeId();
        this.bizTypeId = paramCol.getBizTypeId();
        this.isMerge = paramCol.isMerge();
    }

    @Override
    protected PurPriceInfoCollection execute() throws EASBizException, BOSException {
        String initTempTable = null;
        PurPriceInfoCollection priceInfoCol = new PurPriceInfoCollection();
        try {
            initTempTable = FetchPurPriceUtil.createTempTable(this.ctx, (PurPriceParamCollection)this.getParam());
            FetchPurPriceUtil.insertData(this.ctx, initTempTable, (PurPriceParamCollection)this.getParam());
            FetchPurPriceUtil.getRelatedData(this.ctx, initTempTable);
            FetchPurPriceUtil.setPriceStrategy(this.ctx, initTempTable);
            priceInfoCol = this.fetchPrice(initTempTable);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (initTempTable != null) {
                FetchPurPriceUtil.releaseTempTable(this.ctx, initTempTable);
            }
        }
        return priceInfoCol;
    }

    @Override
    protected void beforeExecute() throws EASBizException, BOSException {
        super.beforeExecute();
    }

    @Override
    protected String getBusinessName() throws EASBizException, BOSException {
        return "Fetch Purchase Price";
    }

    private PurPriceInfoCollection fetchPrice(String initTempTable) throws BOSException, EASBizException, SQLException {
        PurPriceInfoCollection priceInfoCol = new PurPriceInfoCollection();
        String sql = "select FPurPriceStrategyId from " + initTempTable + " group by FPurPriceStrategyId";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        while (rs.next()) {
            String purPriceStrategyId = rs.getString("FPurPriceStrategyId");
            this.fetchPriceByStrategy(initTempTable, priceInfoCol, purPriceStrategyId);
        }
        return priceInfoCol;
    }

    protected void filterData(String tempTable) throws BOSException {
        PurPriceParamCollection paramCol = (PurPriceParamCollection)this.getParam();
        String source = paramCol.getSource();
        if (source == null) {
            return;
        }
        StringBuffer sql = new StringBuffer();
        sql.append("delete from ").append(tempTable).append(" \n");
        sql.append("where fid in (");
        sql.append("select t.fid from ").append(tempTable).append(" t \n");
        sql.append("inner join t_sm_purPriceStrategy t1 on t.FPurPriceStrategyId=t1.FID \n");
        sql.append("inner join t_sm_FetchPriceFactor t2 on t1.FId=t2.FParentID \n");
        this.appendFilterSql(source, sql);
        sql.append(") ");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    protected void appendFilterSql(String source, StringBuffer sql) {
        if ("deliveryDate".equals(source)) {
            sql.append(" and t2.FFactorItemId='").append("FG4E8AmTTg+j3LvjjKI6Fr7ReXM=").append("' ");
            sql.append(" and t2.FItemValueID<>'").append("0FX8sOWHRhS7t4aa0TLdPEEB5Ss=").append("' ");
        } else if ("bizDate".equals(source)) {
            sql.append(" and t2.FFactorItemId='").append("FG4E8AmTTg+j3LvjjKI6Fr7ReXM=").append("' ");
            sql.append(" and t2.FItemValueID<>'").append("C5tNT6G4Q52+cnnDhokRYkEB5Ss=").append("' ");
        } else if ("qty".equals(source)) {
            sql.append(" and t2.FFactorItemId='").append("m0WfjtCaQVikBC9WYhtqsb7ReXM=").append("' ");
            sql.append(" and t2.FItemValueID<>'").append("rkUSir0gSxKWNp4SKGJxekEB5Ss=").append("' ");
        } else if ("assistProperty".equals(source)) {
            sql.append(" and t2.FFactorItemId='").append("G+2sbzXkTHeIPVytXvvXqL7ReXM=").append("' ");
            sql.append(" and t2.FItemValueID<>'").append("6+vYk0VYSbS6/uLBxeNP+kEB5Ss=").append("' ");
        } else if ("receiveOrgUnit".equals(source)) {
            sql.append(" and t2.FFactorItemId='").append("UPd+gWSIT1SpsEBzsA/P2L7ReXM=").append("' ");
            sql.append(" and t2.FItemValueID<>'").append("A+W+PyV4SLyj38Lx3ENBy0EB5Ss=").append("' ");
        } else {
            sql.append(" where t.FID is null ");
        }
    }

    private void fetchPriceByStrategy(String initTempTable, PurPriceInfoCollection priceInfoCol, String purPriceStrategyId) throws BOSException {
        String tempTable;
        PurPriceInfoCollection priceInfoColPerStrategy;
        block6: {
            priceInfoColPerStrategy = new PurPriceInfoCollection();
            tempTable = null;
            tempTable = FetchPurPriceUtil.createTempTable(this.ctx, (PurPriceParamCollection)this.getParam());
            FetchPurPriceUtil.insertData(this.ctx, initTempTable, tempTable, purPriceStrategyId, (PurPriceParamCollection)this.getParam());
            this.filterData(tempTable);
            if (this.hasTodoEntries(tempTable)) break block6;
            FetchPurPriceUtil.releaseTempTable(this.ctx, tempTable);
            return;
        }
        try {
            if (this.isMerge) {
                this.mergeQty(tempTable, purPriceStrategyId);
            }
            this.providePrice(tempTable, purPriceStrategyId);
            this.convertPrice(tempTable);
            priceInfoColPerStrategy = this.readPriceInfoCol(tempTable);
            priceInfoCol.merge(priceInfoColPerStrategy);
        }
        catch (Exception e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                FetchPurPriceUtil.releaseTempTable(this.ctx, tempTable);
                throw throwable;
            }
        }
        FetchPurPriceUtil.releaseTempTable(this.ctx, tempTable);
    }

    private List<String> getGroupFieldsByStrategy(String purPriceStrategyId) throws BOSException {
        ArrayList<String> groupFields = new ArrayList<String>();
        StringBuffer sql = new StringBuffer();
        sql.append("select \n");
        sql.append("case when t3.FID='FG4E8AmTTg+j3LvjjKI6Fr7ReXM=' and ").append("t2.FItemValueId='C5tNT6G4Q52+cnnDhokRYkEB5Ss=' then 'FBizDate' \n");
        sql.append(" when t3.FID='FG4E8AmTTg+j3LvjjKI6Fr7ReXM=' and ").append("t2.FItemValueId='0FX8sOWHRhS7t4aa0TLdPEEB5Ss=' then 'FDeliveryDate' \n");
        sql.append(" when t3.FID='UPd+gWSIT1SpsEBzsA/P2L7ReXM=' and ").append("t2.FItemValueId='A+W+PyV4SLyj38Lx3ENBy0EB5Ss=' then 'FReceiveOrgUnitId' \n");
        sql.append(" when t3.FID='UPd+gWSIT1SpsEBzsA/P2L7ReXM=' and ").append("t2.FItemValueId='0FX8sOWHRhS7t4aa0TLdPEEB5Ss=' then null \n");
        sql.append(" when t3.FID='G+2sbzXkTHeIPVytXvvXqL7ReXM=' and ").append("t2.FItemValueId='6+vYk0VYSbS6/uLBxeNP+kEB5Ss=' then 'FAssistPropertyId' \n");
        sql.append(" when t3.FID='G+2sbzXkTHeIPVytXvvXqL7ReXM=' and ").append("t2.FItemValueId='2PEU5XooSu6M0rnPWzf0REEB5Ss=' then null end as FFieldName \n");
        sql.append(" from t_sm_purPriceStrategy t1 \n");
        sql.append("inner join t_sm_FetchPriceFactor t2 on t1.FId=t2.FParentID \n");
        sql.append("inner join t_sm_FetchPriceFactorItem t3 on t2.FFactorItemId=t3.FID \n");
        sql.append(" where t3.FID in (");
        sql.append("'FG4E8AmTTg+j3LvjjKI6Fr7ReXM=',");
        sql.append("'UPd+gWSIT1SpsEBzsA/P2L7ReXM=',");
        sql.append("'G+2sbzXkTHeIPVytXvvXqL7ReXM='");
        sql.append(") and t1.FID='").append(purPriceStrategyId).append("' ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        groupFields.add("FMaterialId");
        groupFields.add("FUnitId");
        String field = null;
        try {
            while (rs.next()) {
                field = rs.getString("FFieldName");
                if (field == null) continue;
                groupFields.add(field);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return groupFields;
    }

    private void mergeQty(String tempTable, String purPriceStrategyId) throws BOSException {
        int i;
        List<String> groupFields = this.getGroupFieldsByStrategy(purPriceStrategyId);
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tempTable).append(" t set (FQty, FBaseQty) = ");
        sql.append("(select tmp.FSumQty, tmp.FSumBaseQty from \n");
        sql.append(" (select sum(FQty) FSumQty, sum(FBaseQty) FSumBaseQty,  \n");
        for (i = 0; i < groupFields.size(); ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(groupFields.get(i)).append(" \n");
        }
        sql.append("  from ").append(tempTable);
        sql.append("  group by \n");
        for (i = 0; i < groupFields.size(); ++i) {
            if (i > 0) {
                sql.append(", ");
            }
            sql.append(groupFields.get(i)).append(" \n");
        }
        sql.append("  ) tmp \n");
        sql.append("where ");
        for (i = 0; i < groupFields.size(); ++i) {
            if (i > 0) {
                sql.append(" and ");
            }
            if ("FAssistPropertyId".equals(groupFields.get(i))) {
                sql.append("(t.FAssistPropertyId = tmp.FAssistPropertyId or t.FAssistPropertyId is null and tmp.FAssistPropertyId is null) ");
                continue;
            }
            if ("FReceiveOrgUnitId".equals(groupFields.get(i))) {
                sql.append("(t.FReceiveOrgUnitId = tmp.FReceiveOrgUnitId or t.FReceiveOrgUnitId is null and tmp.FReceiveOrgUnitId is null) ");
                continue;
            }
            sql.append("t.").append(groupFields.get(i)).append(" = tmp.").append(groupFields.get(i));
        }
        sql.append(") ");
        DbUtil.execute((Context)this.ctx, (String)sql.toString());
    }

    protected void providePrice(String tempTable, String purPriceStrategyId) throws BOSException, EASBizException {
        List<IPurPriceProvider> list = this.getPurPriceProviders(purPriceStrategyId);
        Iterator<IPurPriceProvider> iter = list.iterator();
        while (iter.hasNext() && this.hasTodoEntries(tempTable)) {
            iter.next().fetchPrice(this.ctx, tempTable, purPriceStrategyId);
        }
        if (list.size() == 0) {
            UpDateTaxRate upDateTaxRate = new UpDateTaxRate();
            upDateTaxRate.update(this.ctx, tempTable, true, false);
        }
    }

    protected boolean hasTodoEntries(String tempTable) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FID from ").append(tempTable).append(" \n");
        sql.append("where FPrice is null ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                return true;
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return false;
    }

    protected List<IPurPriceProvider> getPurPriceProviders(String purPriceStrategyId) throws BOSException {
        ArrayList<IPurPriceProvider> purPriceProviders = new ArrayList<IPurPriceProvider>();
        StringBuffer sql = new StringBuffer();
        sql.append("select t2.FExecuteClass FExecuteClass from T_SM_FetchPriceRule t \n");
        sql.append(" inner join t_sm_PriceProvider t1 on t.FPriceProviderID=t1.FId \n");
        sql.append(" inner join t_sm_relatedConfig t2 on t1.FID=t2.FParentId \n");
        sql.append("where t.FParentId='").append(purPriceStrategyId).append("' ");
        sql.append(" and t.FBillTypeId='").append(this.billTypeId).append("' ");
        sql.append(" and t.FBizTypeId='").append(this.bizTypeId).append("' ");
        sql.append(" order by t2.Fnumber asc ");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        try {
            while (rs.next()) {
                IPurPriceProvider provider = (IPurPriceProvider)Class.forName(rs.getString("FExecuteClass")).newInstance();
                purPriceProviders.add(provider);
            }
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return purPriceProviders;
    }

    protected void convertPrice(String tempTable) throws BOSException {
        FetchPurPriceUtil.convertPriceByUnit(this.ctx, tempTable);
        FetchPurPriceUtil.convertPriceByCurrency(this.ctx, tempTable);
    }

    protected PurPriceInfoCollection readPriceInfoCol(String tempTable) throws BOSException {
        return FetchPurPriceUtil.readPriceInfoCol(this.ctx, tempTable);
    }
}

