/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.price;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.PurPriceInfoCollection;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurBusinessImpl;
import com.kingdee.eas.scm.sm.pur.app.price.FetchPurPriceUtil;
import com.kingdee.eas.scm.sm.pur.app.price.IPurPriceProvider;
import com.kingdee.eas.scm.sm.pur.app.price.history.QueryHistoryPriceProvider;
import com.kingdee.eas.scm.sm.pur.app.price.supplier.QuerySupplierPriceProvider;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class QueryPurPriceImpl
extends AbstractPurBusinessImpl<PurPriceInfoCollection> {
    public QueryPurPriceImpl(Context ctx, Object param) {
        super(ctx, param);
    }

    @Override
    protected PurPriceInfoCollection execute() throws EASBizException, BOSException {
        String initTempTable = null;
        PurPriceInfoCollection priceInfoCol = new PurPriceInfoCollection();
        try {
            initTempTable = FetchPurPriceUtil.createTempTable(this.ctx, (PurPriceParamCollection)this.getParam());
            FetchPurPriceUtil.insertData(this.ctx, initTempTable, (PurPriceParamCollection)this.getParam());
            FetchPurPriceUtil.getRelatedData(this.ctx, initTempTable);
            FetchPurPriceUtil.setPriceStrategy(this.ctx, initTempTable);
            priceInfoCol = this.fetchPrice(initTempTable);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            if (initTempTable != null) {
                FetchPurPriceUtil.releaseTempTable(this.ctx, initTempTable);
            }
        }
        return priceInfoCol;
    }

    @Override
    protected String getBusinessName() throws EASBizException, BOSException {
        return "Query Purchase Price";
    }

    private PurPriceInfoCollection fetchPrice(String initTempTable) throws BOSException, EASBizException, SQLException {
        String purPriceStrategyId;
        PurPriceInfoCollection priceInfoCol = new PurPriceInfoCollection();
        String sql = "select FPurPriceStrategyId from " + initTempTable + " group by FPurPriceStrategyId";
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql);
        if (rs.next() && (purPriceStrategyId = rs.getString("FPurPriceStrategyId")) != null && !"".equals(purPriceStrategyId)) {
            this.providePrice(initTempTable, purPriceStrategyId, priceInfoCol);
        }
        return priceInfoCol;
    }

    protected void providePrice(String tempTable, String purPriceStrategyId, PurPriceInfoCollection priceInfoCol) throws BOSException, EASBizException {
        Iterator<IPurPriceProvider> iter = this.getPurPriceProviders(purPriceStrategyId).iterator();
        PurPriceInfoCollection cols = null;
        while (iter.hasNext()) {
            cols = (PurPriceInfoCollection)iter.next().fetchPrice(this.ctx, tempTable, purPriceStrategyId);
            priceInfoCol.merge(cols);
        }
    }

    protected List<IPurPriceProvider> getPurPriceProviders(String purPriceStrategyId) throws BOSException {
        ArrayList<IPurPriceProvider> purPriceProviders = new ArrayList<IPurPriceProvider>();
        IPurPriceProvider provider = new QueryHistoryPriceProvider((PurPriceParamCollection)this.getParam());
        purPriceProviders.add(provider);
        provider = new QuerySupplierPriceProvider((PurPriceParamCollection)this.getParam());
        purPriceProviders.add(provider);
        return purPriceProviders;
    }
}

