/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.price.history;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.sm.pur.app.price.FetchPurPriceUtil;
import com.kingdee.eas.scm.sm.pur.app.price.IPurPriceProvider;
import com.kingdee.eas.scm.sm.pur.util.SQLUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;

public class HistoryPriceProvider
implements IPurPriceProvider {
    @Override
    public Object fetchPrice(Context ctx, String tempTable, String purPriceStrategyId) throws BOSException, EASBizException {
        PurchaseTypeEnum purchaseType = this.getPurchaseType(ctx, tempTable);
        if (PurchaseTypeEnum.PURCHASE.equals((Object)purchaseType)) {
            this.getPurchasePrice(ctx, tempTable);
        } else {
            this.getSubContractPrice(ctx, tempTable);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void getPurchasePrice(Context ctx, String tempTable) throws BOSException {
        ResultSet rs;
        Statement statement;
        Connection conn;
        String tmpResultTable;
        block8: {
            block7: {
                tmpResultTable = this.createTempTable(ctx);
                conn = null;
                statement = null;
                rs = null;
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    statement = conn.createStatement();
                    rs = this.getPurchaseTempResult(ctx, tempTable, conn, statement);
                    List sqlParams = this.getResultParams(rs);
                    if (sqlParams.size() == 0) {
                        SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
                        break block7;
                    }
                    this.updatePrice(ctx, tempTable, tmpResultTable, sqlParams);
                    SQLUtils.cleanup((ResultSet)rs, (Statement)statement, (Connection)conn);
                    break block8;
                }
                catch (SQLException e1) {
                    e1.printStackTrace();
                    return;
                }
            }
            FetchPurPriceUtil.releaseTempTable(ctx, tmpResultTable);
            return;
        }
        FetchPurPriceUtil.releaseTempTable(ctx, tmpResultTable);
        return;
        finally {
            SQLUtils.cleanup(rs, (Statement)statement, (Connection)conn);
            FetchPurPriceUtil.releaseTempTable(ctx, tmpResultTable);
        }
    }

    private void getSubContractPrice(Context ctx, String tempTable) throws BOSException {
        String tmpResultTable = this.createTempTable(ctx);
        IRowSet rs = this.getSubContractTempResult(ctx, tempTable);
        List sqlParams = this.getResultParams((ResultSet)rs);
        if (sqlParams.size() == 0) {
            return;
        }
        try {
            this.updatePrice(ctx, tempTable, tmpResultTable, sqlParams);
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            FetchPurPriceUtil.releaseTempTable(ctx, tmpResultTable);
        }
    }

    private void updatePrice(Context ctx, String tempTable, String tmpResultTable, List sqlParams) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.setLength(0);
        sql.append("insert into ").append(tmpResultTable).append("  \n");
        sql.append("(FID, \n");
        sql.append("FTraceId, \n");
        sql.append("FBizDate,\n");
        sql.append("FAuditTime,\n");
        sql.append("FPrice,\n");
        sql.append("fTaxRate,\n");
        sql.append("FTaxPrice, \n");
        sql.append("FInPriceUnitId, \n");
        sql.append("FInPriceCurrencyId, \n");
        sql.append("FIsInTax, \n");
        sql.append("FSupplierId, \n");
        sql.append("FDiscountRate) \n");
        sql.append("values( ?,?,?,?,?,?,?,?,?,?,?,? ) ");
        SQLUtil.executeBatch(ctx, sql.toString(), sqlParams);
        sql.setLength(0);
        sql.append("update ").append(tempTable).append(" t0 set \n ");
        sql.append("(FPrice, \n");
        sql.append("FTaxRate, \n");
        sql.append("FInPriceUnitId, \n");
        sql.append("FInPriceCurrencyId, \n");
        sql.append("FIsInTax, \n");
        sql.append("FDiscountRate, \n");
        sql.append("FInPriceSupplierId, \n");
        sql.append("FInPriceSupplierName, \n");
        sql.append("FInPriceSupplierNumber) = \n");
        sql.append("(select case when tmp.FIsInTax=0 then tmp.FPrice else tmp.FTaxPrice end, tmp.FtaxRate, ");
        sql.append("  tmp.FInPriceUnitId, tmp.FInPriceCurrencyId, tmp.FIsInTax, tmp.FDiscountRate, \n ");
        sql.append("  s.FID, s.FName_").append(ctx.getLocale()).append(", s.FNumber \n");
        sql.append("from \n");
        sql.append(tmpResultTable).append(" tmp \n");
        sql.append("  left outer join t_bd_supplier s on tmp.FSupplierId=s.FID \n");
        sql.append("where t0.FID=tmp.FTraceId) \n");
        sql.append("where t0.FPrice is null ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private ResultSet getPurchaseTempResult(Context ctx, String tempTable, Connection conn, Statement statement) throws BOSException {
        StringBuffer sql = this.getPurchaseTempResultSql(tempTable);
        ResultSet rs = null;
        try {
            rs = statement.executeQuery(sql.toString());
        }
        catch (SQLException e) {
            throw new BOSException("Sql3 execute exception : " + sql, (Throwable)e);
        }
        return rs;
    }

    protected StringBuffer getPurchaseTempResultSql(String tempTable) {
        String date = this.getPreYearDate();
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(this.getTempResultSelectSql()).append(" \n");
        sql.append("tmp.FTraceId, \n");
        sql.append("tmp.FSeq, \n");
        sql.append("tmp.FBizDate, \n");
        sql.append("tmp.FAuditTime,\n");
        sql.append("tmp.FPrice, \n");
        sql.append("tmp.fTaxRate, \n");
        sql.append("tmp.FTaxPrice, \n");
        sql.append("tmp.FUnitId, \n");
        sql.append("tmp.FCurrencyId, \n");
        sql.append("tmp.FIsInTax, \n");
        sql.append("tmp.FSupplierId, \n");
        sql.append("tmp.FBillTypeId, \n");
        sql.append("tmp.FDiscountRate, \n");
        sql.append("tmp.FQty, \n");
        sql.append("tmp.FAssistPropertyId, \n");
        sql.append("tmp.FRecOrgUnitId \n");
        sql.append("from \n ");
        sql.append("(select t.FID FTraceId, t1.FPrice FPrice, t1.fTaxRate fTaxRate,t1.FUnitId FUnitId, t2.FCurrencyId FCurrencyId, ");
        sql.append("  t1.FSeq FSeq, \n");
        sql.append("  case when t.FBillTypeId='").append("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        sql.append("'   then t2.FIsInTax else t.FIsInTax end FIsInTax, \n");
        sql.append("  t1.FTaxPrice FTaxPrice, t2.FBizDate FBizDate, t2.FAuditTime FAuditTime, \n");
        sql.append("  t2.FSupplierId FSupplierId, t2.FBillTypeId FBillTypeId, t1.FDiscountRate FDiscountRate, \n");
        sql.append("  t1.FQty FQty, t1.FAssistPropertyId FAssistPropertyId, \n");
        sql.append("  t1.fStorageorgUnitId FRecOrgUnitId \n");
        sql.append("from ").append(tempTable).append(" t \n");
        sql.append("  inner join t_sm_purorderentry t1 on t.FMaterialId=t1.FmaterialId ");
        sql.append("    and (t1.FBaseStatus=4 or t1.FBaseStatus=7) and t1.FIsPresent=0 \n");
        sql.append("  inner join t_sm_purorder t2 on t1.FParentId=t2.FID ");
        sql.append("    and t.FPurchaseOrgUnitId=t2.FPurchaseOrgUnitId and t.FCurrencyId=t2.FCurrencyId \n");
        sql.append("    and t.FBizTypeId=t2.FbizTypeId \n");
        sql.append("where t2.FSupplierId = isnull(t.FSupplierId, t2.FSupplierId) and t1.FTaxPrice<>0 \n");
        sql.append(" and t2.FisSysBill=0 ");
        sql.append(this.getPurOrderFilterSql(date)).append(" \n");
        sql.append("union \n");
        sql.append("select t.FID FTraceId, t3.FPrice FPrice, t3.fTaxRate fTaxRate,t3.FUnitId FUnitId, t4.FCurrencyId FCurrencyId, ");
        sql.append("  t3.FSeq FSeq, \n");
        sql.append("  case when t.FBillTypeId='").append("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        sql.append("'   then t4.FIsInTax else t.FIsInTax end FIsInTax, \n");
        sql.append("  t3.FTaxPrice FTaxPrice, t4.FBizDate FBizDate, t4.FAuditTime FAuditTime, \n");
        sql.append("  t4.FSupplierId FSupplierId, t4.FBillTypeId FBillTypeId, t3.FDiscount FDiscountRate, \n");
        sql.append("  t3.FQty FQty, t3.FAssistPropertyId FAssistPropertyId, \n");
        sql.append("  t3.fStorageorgUnitId FRecOrgUnitId \n");
        sql.append("from ").append(tempTable).append(" t \n");
        sql.append("  inner join t_sm_purContractEntry t3 on t.FMaterialId=t3.FmaterialId ");
        sql.append("    and (t3.FBaseStatus=4 or t3.FBaseStatus=7) and t3.FIsPresent=0 \n");
        sql.append("  inner join t_sm_PurContract t4 on t3.FParentId=t4.FID ");
        sql.append("    and t.FPurchaseOrgUnitId=t4.FPurOrgUnitID and t.FCurrencyId=t4.FCurrencyId \n");
        sql.append("    and t.FBizTypeId=t4.FbizTypeId \n");
        sql.append("where t4.FSupplierId = isnull(t.FSupplierId, t4.FSupplierId) and t3.FTaxPrice<>0 \n");
        sql.append(this.getPurContractFilterSql(date)).append(" \n");
        sql.append("union \n");
        sql.append("select  t.FID FTraceId, t5.FPrice FPrice,t5.fTaxRate fTaxRate, t5.FMeasureUnitId FUnitId,  t6.FCurrencyId FCurrencyId,");
        sql.append("  t5.FSeq FSeq, \n");
        sql.append("  case when t.FBillTypeId='").append("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        sql.append("'   then t6.FIsInTax else t.FIsInTax end FIsInTax, \n");
        sql.append("  t5.FTaxPrice FTaxPrice, t6.FBillDate FBizDate, t6.FAuditDate FAuditTime,  \n");
        sql.append("  t6.FasstActID FSupplierId, 'otherBillTypeId' FBillTypeId, t5.FDiscountRate FDiscountRate, \n");
        sql.append("  t5.FQuantity FQty, t5.FAssistPropertyId FAssistPropertyId, \n");
        sql.append("  t5.frecsendorgunitid FRecOrgUnitId \n");
        sql.append("from ").append(tempTable).append(" t \n");
        sql.append("  inner join T_AP_OtherBillentry t5 on t.FmaterialId=t5.FMaterialId and t5.FIsPresent=0 \n");
        sql.append("  inner join T_AP_OtherBill t6 on t5.fparentid = t6.fid and t.FPurchaseOrgUnitId=t6.FPurOrgID ");
        sql.append("    and t.FCurrencyId=t6.FCurrencyId and t6.FBillStatus=3 \n");
        sql.append("where t6.FBillType=202 and t6.FBizTypeId=t.FBizTypeId ");
        sql.append("  and t6.FasstActID = isnull(t.FSupplierId, t6.FasstActID) and t5.FTaxPrice<>0 \n");
        sql.append(this.getOtherBillFilterSql(date)).append(" \n");
        sql.append("union \n");
        sql.append("select  t.FID FTraceId, t7.FPrice FPrice, t7.fTaxRate fTaxRate,t7.FUnitId FUnitId,  t8.FCurrencyId FCurrencyId,");
        sql.append("  t7.FSeq FSeq, \n");
        sql.append("  case when t.FBillTypeId='").append("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        sql.append("'   then t8.FIsInTax else t.FIsInTax end FIsInTax, \n");
        sql.append("  t7.FTaxPrice FTaxPrice, t8.FBizDate FBizDate, t8.FAuditTime FAuditTime,  \n");
        sql.append("  t8.FSupplierId FSupplierId, t8.FBillTypeId FBillTypeId, 0 FDiscountRate, \n");
        sql.append("  t7.FQty FQty, t7.FAssistPropertyId FAssistPropertyId, \n");
        sql.append("  t7.fStorageorgUnitId FRecOrgUnitId \n");
        sql.append("from ").append(tempTable).append(" t \n");
        sql.append("  inner join T_SM_PurreturnsEntry t7 on t.FmaterialId=t7.FMaterialId and t7.FIsPresent=0 \n");
        sql.append("  inner join T_SM_Purreturns t8 on t7.fparentid = t8.fid and t.FPurchaseOrgUnitId=t8.FPurchaseOrgUnitID ");
        sql.append("    and t.FCurrencyId=t8.FCurrencyId and (t8.FBaseStatus=4 or t8.FbaseStatus=7) \n");
        sql.append("where t8.FBizTypeId=t.FBizTypeId ");
        sql.append("  and t8.FSupplierId = isnull(t.FSupplierId, t8.FSupplierId) and t7.FTaxPrice<>0 \n");
        sql.append(this.getPurReturnsFilterSql(date)).append(" \n");
        sql.append(") tmp \n");
        sql.append(this.getTempResultOrderBySql());
        return sql;
    }

    private List getResultParams(ResultSet rs) throws BOSException {
        String latestTraceId = null;
        String preTraceId = null;
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
        Object[] obj = null;
        try {
            while (rs.next()) {
                latestTraceId = rs.getString("FTraceId");
                if (latestTraceId.equals(preTraceId)) continue;
                obj = new Object[]{BOSUuid.create((BOSObjectType)new BOSObjectType("406FDF31")).toString(), latestTraceId, rs.getTimestamp("FBizDate"), rs.getTimestamp("FAuditTime"), rs.getBigDecimal("FPrice"), rs.getBigDecimal("FTaxRate"), rs.getBigDecimal("FTaxPrice"), rs.getString("FUnitId"), rs.getString("FCurrencyId"), rs.getInt("FIsInTax"), rs.getString("FSupplierId"), rs.getBigDecimal("FDiscountRate")};
                sqlParams.add(obj);
                preTraceId = latestTraceId;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return sqlParams;
    }

    private IRowSet getSubContractTempResult(Context ctx, String tempTable) throws BOSException {
        StringBuffer sql = this.getSubContractTempResultSql(tempTable);
        return DbUtil.executeQuery((Context)ctx, (String)sql.toString());
    }

    protected StringBuffer getSubContractTempResultSql(String tempTable) {
        String date = this.getPreYearDate();
        StringBuffer sql = new StringBuffer();
        sql.append("select ").append(this.getTempResultSelectSql()).append(" \n");
        sql.append("tmp.FTraceId, \n");
        sql.append("tmp.FSeq, \n");
        sql.append("tmp.FBizDate, \n");
        sql.append("tmp.FAuditTime,\n");
        sql.append("tmp.FPrice, \n");
        sql.append("tmp.FTaxRate, \n");
        sql.append("tmp.FTaxPrice, \n");
        sql.append("tmp.FUnitId, \n");
        sql.append("tmp.FCurrencyId, \n");
        sql.append("tmp.FIsInTax, \n");
        sql.append("tmp.FSupplierId, \n");
        sql.append("tmp.FBillTypeId, \n");
        sql.append("tmp.FDiscountRate, \n");
        sql.append("tmp.FQty, \n");
        sql.append("tmp.FAssistPropertyId, \n");
        sql.append("tmp.FRecOrgUnitId \n");
        sql.append("from \n ");
        sql.append("(select t.FID FTraceId, t1.FPrice FPrice,t1.FTaxRate FTaxRate, t1.FUnitId FUnitId, t2.FCurrencyId FCurrencyId, ");
        sql.append("  t1.FSeq FSeq, \n");
        sql.append("  case when t.FBillTypeId='").append("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        sql.append("'   then t2.FIsInTax else t.FIsInTax end FIsInTax, \n");
        sql.append("  t1.FTaxPrice FTaxPrice, t2.FBizDate FBizDate, t2.FAuditTime FAuditTime, \n");
        sql.append("  t2.FSupplierId FSupplierId, t2.FBillTypeId FBillTypeId, t1.FDiscount FDiscountRate, \n");
        sql.append("  t1.FQty FQty, t1.FAssistPropertyId FAssistPropertyId, \n");
        sql.append("  t1.fReceiveorgUnitId FRecOrgUnitId \n");
        sql.append("from ").append(tempTable).append(" t \n");
        sql.append("  inner join t_sm_subcontractorderentry t1 on t.FMaterialId=t1.FmaterialId ");
        sql.append("    and (t1.FBaseStatus=4 or t1.FBaseStatus=7) and t1.FIsPresent=0 \n");
        sql.append("  inner join t_sm_subcontractorder t2 on t1.FParentId=t2.FID ");
        sql.append("    and t.FPurchaseOrgUnitId=t2.FPurchaseOrgUnitId and t.FCurrencyId=t2.FCurrencyId \n");
        sql.append("    and t.FBizTypeId=t2.FBizTypeId ");
        sql.append("where t2.FSupplierId = isnull(t.FSupplierId, t2.FSupplierId) and t1.FTaxPrice<>0 \n");
        sql.append(this.getSubContractOrderFilterSql(date)).append(" \n");
        sql.append("union \n");
        sql.append("select  t.FID FTraceId, t5.FPrice FPrice,t5.FTaxRate FTaxRate,  t5.FMeasureUnitId FUnitId,  t6.FCurrencyId FCurrencyId,");
        sql.append("  t5.FSeq FSeq, \n");
        sql.append("  case when t.FBillTypeId='").append("510b6503-0105-1000-e000-0107c0a812fd463ED552");
        sql.append("'   then t6.FIsInTax else t.FIsInTax end FIsInTax, \n");
        sql.append("  t5.FTaxPrice FTaxPrice, t6.FBillDate FBizDate, t6.FAuditDate FAuditTime, \n");
        sql.append("  t6.FasstActID FSupplierId, 'otherBillTypeId' FBillTypeId, t5.FDiscountRate FDiscountRate, \n");
        sql.append("  t5.FQuantity FQty, t5.FAssistPropertyId FAssistPropertyId, \n");
        sql.append("  t5.frecsendorgunitid FRecOrgUnitId \n");
        sql.append("from ").append(tempTable).append(" t \n");
        sql.append("  inner join T_AP_OtherBillentry t5 on t.FmaterialId=t5.FMaterialId and t5.FIsPresent=0 \n");
        sql.append("  inner join T_AP_OtherBill t6 on t5.fparentid = t6.fid and t.FPurchaseOrgUnitId=t6.FPurOrgID ");
        sql.append("    and t.FCurrencyId=t6.FCurrencyId and t6.FBillStatus=3 \n");
        sql.append("where t6.FBillType=202 and t6.FBizTypeId=t.FbizTypeId \n");
        sql.append("  and t6.FasstActID = isnull(t.FSupplierId, t6.FasstActID) and t5.FTaxPrice<>0 \n");
        sql.append(this.getOtherBillFilterSql(date)).append(" \n");
        sql.append(") tmp \n");
        sql.append(this.getTempResultOrderBySql());
        return sql;
    }

    protected PurchaseTypeEnum getPurchaseType(Context ctx, String tempTable) throws BOSException {
        PurchaseTypeEnum purchaseType = PurchaseTypeEnum.PURCHASE;
        int materialPurchaseType = 0;
        StringBuffer sql = new StringBuffer();
        sql.append("select top 1 FMaterialPurchaseType from ").append(tempTable);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        try {
            if (rs.next()) {
                materialPurchaseType = rs.getInt("FMaterialPurchaseType");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (materialPurchaseType == 1) {
            purchaseType = PurchaseTypeEnum.SUBCONTRACT;
        }
        return purchaseType;
    }

    private String createTempTable(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table SpplierPrice ( \n");
        sql.append("FID varchar(44) not null, \n");
        sql.append("FTraceId varchar(44), \n");
        sql.append("FBizDate dateTime, \n");
        sql.append("FAuditTime dateTime, \n");
        sql.append("FPrice numeric(21,8), \n");
        sql.append("FTaxRate numeric(21,8) not null default 0, \n");
        sql.append("FTaxPrice numeric(21,8), \n");
        sql.append("FInPriceUnitId  varchar(44), \n");
        sql.append("FInPriceCurrencyId  varchar(44), \n");
        sql.append("FIsInTax int not null default 0, \n");
        sql.append("FSupplierId varchar(44), \n");
        sql.append("FDiscountRate numeric(21,8), ");
        sql.append("CONSTRAINT ");
        sql.append(new UUTN("ZC").toString());
        sql.append(" PRIMARY KEY (FID) ) ");
        String table = null;
        try {
            table = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return table;
    }

    protected String getTempResultSelectSql() {
        return "";
    }

    protected String getTempResultOrderBySql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" order by tmp.FTraceId asc, tmp.FBizDate desc, tmp.FAuditTime desc, tmp.FSeq asc ");
        return sql.toString();
    }

    protected String getOtherBillFilterSql(String date) {
        return " and t6.FBillDate > {ts'" + date + "'} ";
    }

    protected String getPurReturnsFilterSql(String date) {
        return " and t8.FBizDate > {ts'" + date + "'} ";
    }

    protected String getPurOrderFilterSql(String date) {
        return " and t2.FBizDate > {ts'" + date + "'} ";
    }

    protected String getPurContractFilterSql(String date) {
        return " and t4.FBizDate > {ts'" + date + "'} ";
    }

    protected String getSubContractOrderFilterSql(String date) {
        return " and t2.FBizDate > {ts'" + date + "'} ";
    }

    private String getPreYearDate() {
        Calendar calendar = Calendar.getInstance();
        calendar.add(1, -1);
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
        return format.format(calendar.getTime());
    }
}

