/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.price.supplier;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.sql.util.UUTN;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.scm.sm.srm.FetchPriceFactorCollection;
import com.kingdee.eas.basedata.scm.sm.srm.FetchPriceFactorInfo;
import com.kingdee.eas.basedata.scm.sm.srm.PurPriceStrategyFactory;
import com.kingdee.eas.basedata.scm.sm.srm.PurPriceStrategyInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.app.price.FetchPurPriceUtil;
import com.kingdee.eas.scm.sm.pur.app.price.IPurPriceProvider;
import com.kingdee.eas.scm.sm.pur.app.price.UpDateTaxRate;
import com.kingdee.eas.scm.sm.pur.util.SQLUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;

public class SupplierPriceProvider
implements IPurPriceProvider {
    @Override
    public Object fetchPrice(Context ctx, String tempTable, String purPriceStrategyId) throws BOSException, EASBizException {
        StringBuffer oql = new StringBuffer();
        oql.append("select factorEntries.factorItem.id, factorEntries.itemValue.id, isPricetaxRate where id='");
        oql.append(purPriceStrategyId).append("' ");
        PurPriceStrategyInfo strategyInfo = PurPriceStrategyFactory.getLocalInstance((Context)ctx).getPurPriceStrategyInfo(oql.toString());
        FetchPriceFactorCollection factors = strategyInfo.getFactorEntries();
        boolean isSupplierTaxRate = strategyInfo.isIsPricetaxRate();
        String tmpResultTable = null;
        try {
            tmpResultTable = this.createTempTable(ctx);
            this.getTempResult(ctx, tempTable, factors, tmpResultTable, isSupplierTaxRate);
            this.getPrice(ctx, tempTable, tmpResultTable, isSupplierTaxRate);
            if (!isSupplierTaxRate) {
                UpDateTaxRate upDateTaxRate = new UpDateTaxRate();
                upDateTaxRate.update(ctx, tempTable, true, false);
            }
        }
        catch (BOSException e) {
            throw e;
        }
        finally {
            FetchPurPriceUtil.releaseTempTable(ctx, tmpResultTable);
        }
        return null;
    }

    private void getPrice(Context ctx, String tempTable, String tmpResultTable, boolean isSupplierTaxRate) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("update ").append(tempTable).append(" t0 set \n ");
        sql.append("(FPrice, \n");
        sql.append("FTaxRate, \n");
        sql.append("FInPriceUnitId, \n");
        sql.append("FInPriceCurrencyId, \n");
        sql.append("FIsInTax, \n");
        sql.append("FIsSupplierTaxRate, \n");
        sql.append("FDiscountRate, \n");
        sql.append("FInPriceSupplierTaxRate, \n");
        sql.append("FInPriceSupplierId, \n");
        sql.append("FInPriceSupplierName, \n");
        sql.append("FInPriceSupplierNumber) = \n");
        sql.append("(select \n");
        sql.append("tmp.FPrice, \n");
        sql.append("tmp.FTaxRate, \n");
        sql.append("tmp.FInPriceUnitId, \n");
        sql.append("tmp.FInPriceCurrencyId, \n");
        sql.append("tmp.FIsInTax, \n");
        if (isSupplierTaxRate) {
            sql.append(1).append(",\n");
        } else {
            sql.append(0).append(",\n");
        }
        sql.append("tmp.FDiscountRate, \n");
        sql.append("tmp.FInPriceSupplierTaxRate, \n");
        sql.append("tmp.FInPriceSupplierId, \n");
        sql.append("tmp.FInPriceSupplierName, \n");
        sql.append("tmp.FInPriceSupplierNumber \n");
        sql.append("from \n");
        sql.append(tmpResultTable).append(" tmp \n");
        sql.append("where t0.FID=tmp.FTraceId and tmp.FPrice<>0 ) \n");
        sql.append("where t0.FPrice is null ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void getTempResult(Context ctx, String tempTable, FetchPriceFactorCollection factors, String tmpResultTable, boolean isSupplierTaxRate) throws BOSException {
        IRowSet rs = this.getSupplierPriceTempResult(ctx, tempTable, factors);
        String latestTraceId = null;
        String preTraceId = null;
        ArrayList<Object[]> sqlParams = new ArrayList<Object[]>();
        Object[] obj = null;
        try {
            while (rs.next()) {
                latestTraceId = rs.getString("FTraceId");
                if (latestTraceId.equals(preTraceId)) continue;
                BigDecimal taxRate = rs.getBigDecimal("FTaxRate");
                if (!isSupplierTaxRate) {
                    taxRate = BigDecimal.ZERO;
                }
                obj = new Object[]{BOSUuid.create((BOSObjectType)new BOSObjectType("406FDF31")).toString(), latestTraceId, rs.getBigDecimal("FPrice"), taxRate, rs.getString("FPurMeasureUnitId"), rs.getString("FCurrencyId"), rs.getInt("FIsTaxPrice"), isSupplierTaxRate, rs.getBigDecimal("FDiscountRate"), rs.getBigDecimal("FInPriceSupplierTaxRate"), rs.getString("FInPriceSupplierId"), rs.getString("FInPriceSupplierName"), rs.getString("FInPriceSupplierNumber")};
                sqlParams.add(obj);
                preTraceId = latestTraceId;
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        StringBuffer getResultSql = new StringBuffer();
        getResultSql.append("insert into ").append(tmpResultTable).append("  \n");
        getResultSql.append("(FID, \n");
        getResultSql.append("FTraceId, \n");
        getResultSql.append("FPrice, \n");
        getResultSql.append("FTaxRate, \n");
        getResultSql.append("FInPriceUnitId, \n");
        getResultSql.append("FInPriceCurrencyId, \n");
        getResultSql.append("FIsInTax, \n");
        getResultSql.append("FIsSupplierTaxRate, \n");
        getResultSql.append("FDiscountRate, \n");
        getResultSql.append("FInPriceSupplierTaxRate, ");
        getResultSql.append("FInPriceSupplierId, ");
        getResultSql.append("FInPriceSupplierName, ");
        getResultSql.append("FInPriceSupplierNumber) ");
        getResultSql.append("values( ?,?,?,?,?,?,?,?,?,?,?,?,? ) ");
        SQLUtil.executeBatch(ctx, getResultSql.toString(), sqlParams);
    }

    protected IRowSet getSupplierPriceTempResult(Context ctx, String tempTable, FetchPriceFactorCollection factors) throws BOSException {
        StringBuffer getResultSql = this.createResultSql(ctx, tempTable, factors);
        return DbUtil.executeQuery((Context)ctx, (String)getResultSql.toString());
    }

    protected StringBuffer createResultSql(Context ctx, String tempTable, FetchPriceFactorCollection factors) {
        StringBuffer getResultSql = new StringBuffer();
        getResultSql.append("select ").append(this.getTempResultSelectSql()).append(" \n");
        getResultSql.append(" t.FID FTraceId, \n");
        getResultSql.append("round(decimal(t1.FFromQty*u.FBaseConvsRate, 21,8),bu.FQtyPrecision) FBaseFromQty, \n");
        getResultSql.append("case when t.FCurrencyId=t1.FCurrencyId then 1 else 0 end FIsCurrencyMatch, \n");
        getResultSql.append("case when t.FunitId=t1.FPurMeasureUnitId then 1 else 0 end FIsUnitMatch, \n");
        getResultSql.append("t1.FAuditDate,\n");
        getResultSql.append("t1.FPrice, \n");
        getResultSql.append("t1.FTaxRate, \n");
        getResultSql.append("t1.FPurMeasureUnitId, \n");
        getResultSql.append("t1.FCurrencyId, \n");
        getResultSql.append("t1.FIsTaxPrice, \n");
        getResultSql.append("t1.FDiscountRate, \n");
        getResultSql.append("s.ftaxrate FInPriceSupplierTaxRate, \n");
        getResultSql.append("s.FID FInPriceSupplierId, \n");
        getResultSql.append("s.FName_").append(ctx.getLocale()).append(" FInPriceSupplierName, \n");
        getResultSql.append("s.FNumber FInPriceSupplierNumber \n");
        getResultSql.append("from ").append(tempTable).append(" t \n");
        getResultSql.append("inner join t_sm_supplyInfo t1 on t.FMaterialId = t1.FMaterialItemId ");
        getResultSql.append("  and t.FPurchaseOrgUnitId = t1.FPurchaseOrgId and t1.FIsUseable = 1 \n");
        getResultSql.append("inner join t_bd_multiMeasureUnit u on t.FMaterialId=u.FMaterialId \n");
        getResultSql.append("  and t1.FPurMeasureUnitId=u.FMeasureUnitId \n");
        getResultSql.append("inner join t_bd_multiMeasureUnit bu on t.FMaterialId=bu.FMaterialId \n");
        getResultSql.append("  and t.FBaseUnitId=bu.FMeasureUnitId \n");
        getResultSql.append("inner join t_bd_supplier s on t1.fsupplierId=s.FID \n");
        getResultSql.append("where \n");
        getResultSql.append(this.getFilterSql(factors));
        if (this.isFetchByQty(factors)) {
            getResultSql.append(" order by t.FID asc, FIsCurrencyMatch desc, FIsUnitMatch desc, FBaseFromQty desc, t1.FAuditDate desc ");
        } else {
            getResultSql.append(" order by t.FID asc, FIsCurrencyMatch desc, FIsUnitMatch desc, t1.FAuditDate desc ");
        }
        return getResultSql;
    }

    protected String getFilterSql(FetchPriceFactorCollection factors) {
        StringBuffer sql = new StringBuffer();
        sql.append(" t1.FSupplierId = isnull(t.FSupplierId, t1.FSupplierId) \n");
        sql.append(this.getQtyFilterSql(factors));
        sql.append(this.getUnitFilterSql(factors));
        sql.append(this.getPurchaseTypeFilterSql());
        sql.append(this.getCurrencyFilterSql(factors));
        sql.append(this.getDateFilterSql(factors));
        sql.append(this.getAssistPropertyFilterSql(factors));
        sql.append(this.getReceiveOrgFilterSql(factors));
        return sql.toString();
    }

    private String getQtyFilterSql(FetchPriceFactorCollection factors) {
        StringBuffer sql = new StringBuffer();
        if (this.isFetchByQty(factors)) {
            sql.append(" and t.FBaseQty >= round(decimal(t1.FFromQty*u.FBaseConvsRate, 21,8),bu.FQtyPrecision)  \n");
        }
        return sql.toString();
    }

    private boolean isFetchByQty(FetchPriceFactorCollection factors) {
        FetchPriceFactorInfo factor = this.getFatorItemById(factors, "m0WfjtCaQVikBC9WYhtqsb7ReXM=");
        return "rkUSir0gSxKWNp4SKGJxekEB5Ss=".equals(factor.getItemValue().getId().toString());
    }

    private String getPurchaseTypeFilterSql() {
        StringBuffer sql = new StringBuffer();
        sql.append(" and t1.FMaterialPurchaseType=t.FMaterialPurchaseType ");
        return sql.toString();
    }

    protected String getUnitFilterSql(FetchPriceFactorCollection factors) {
        FetchPriceFactorInfo factor = this.getFatorItemById(factors, "1z3iX+dmQS2pCp/F50Hr1b7ReXM=");
        StringBuffer sql = new StringBuffer();
        if ("ks9H8ACfRZq3IvMyPWl2YkEB5Ss=".equals(factor.getItemValue().getId().toString())) {
            sql.append(" and t1.FPurMeasureUnitId=t.FUnitId \n");
        } else if ("pEwuQ0qFQCi79xWQ4EHXjEEB5Ss=".equals(factor.getItemValue().getId().toString())) {
            sql.append(" and t1.FPurMeasureUnitId=");
            sql.append(" (case when t.FUnitId=t1.FPurMeasureUnitId then t.FUnitId else t.FPurUnitId end) \n");
        } else {
            sql.append(" and t1.FPurMeasureUnitId=");
            sql.append(" (case when t.FUnitId=t1.FPurMeasureUnitId then t.FUnitId else t.FBaseUnitId end) \n");
        }
        return sql.toString();
    }

    protected String getCurrencyFilterSql(FetchPriceFactorCollection factors) {
        FetchPriceFactorInfo factor = this.getFatorItemById(factors, "QJIXUHbHRgWvScQq3M6w8L7ReXM=");
        StringBuffer sql = new StringBuffer();
        if ("Law0WpbQTA+0g7XNujKvnkEB5Ss=".equals(factor.getItemValue().getId().toString())) {
            sql.append(" and t1.FCurrencyId=t.FCurrencyId \n");
        } else {
            sql.append(" and t1.FCurrencyId=");
            sql.append(" (case when t.FCurrencyId=t1.FCurrencyId then t.FCurrencyId else t.FBaseCurrencyId end) \n");
        }
        return sql.toString();
    }

    protected String getDateFilterSql(FetchPriceFactorCollection factors) {
        FetchPriceFactorInfo factor = this.getFatorItemById(factors, "FG4E8AmTTg+j3LvjjKI6Fr7ReXM=");
        StringBuffer sql = new StringBuffer();
        if ("C5tNT6G4Q52+cnnDhokRYkEB5Ss=".equals(factor.getItemValue().getId().toString())) {
            sql.append(" and t1.FEffectualDate <= t.FBizDate and t1.FUnEffectualDate > t.FBizDate \n");
        } else {
            sql.append(" and t1.FEffectualDate <= t.FDeliveryDate and t1.FUnEffectualDate > t.FDeliveryDate \n");
        }
        return sql.toString();
    }

    protected String getAssistPropertyFilterSql(FetchPriceFactorCollection factors) {
        FetchPriceFactorInfo factor = this.getFatorItemById(factors, "G+2sbzXkTHeIPVytXvvXqL7ReXM=");
        StringBuffer sql = new StringBuffer();
        if ("6+vYk0VYSbS6/uLBxeNP+kEB5Ss=".equals(factor.getItemValue().getId().toString())) {
            sql.append(" and (t1.FAssistPropertyId = t.FAssistPropertyId or ");
            sql.append(" (t1.FAssistPropertyId is null and t.FAssistPropertyId is null)) \n");
        }
        return sql.toString();
    }

    protected String getReceiveOrgFilterSql(FetchPriceFactorCollection factors) {
        FetchPriceFactorInfo factor = this.getFatorItemById(factors, "UPd+gWSIT1SpsEBzsA/P2L7ReXM=");
        StringBuffer sql = new StringBuffer();
        if ("A+W+PyV4SLyj38Lx3ENBy0EB5Ss=".equals(factor.getItemValue().getId().toString())) {
            sql.append(" and t1.FRecOrgId = isnull(t.FReceiveOrgUnitId, t1.FRecOrgId) \n");
        }
        return sql.toString();
    }

    private FetchPriceFactorInfo getFatorItemById(FetchPriceFactorCollection factors, String id) {
        FetchPriceFactorInfo factor = null;
        for (int i = 0; !(i >= factors.size() || (factor = factors.get(i)).getFactorItem() != null && id.equals(factor.getFactorItem().getId().toString())); ++i) {
        }
        return factor;
    }

    protected String createTempTable(Context ctx) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table SpplierPrice ( \n");
        sql.append("FID varchar(44) not null, \n");
        sql.append("FTraceId varchar(44), \n");
        sql.append("FFromQty numeric(21,8), \n");
        sql.append("FAuditDate dateTime, \n");
        sql.append("FPrice numeric(21,8), \n");
        sql.append("FTaxRate numeric(21,8), \n");
        sql.append("FsupplierTaxRate numeric(21,8), \n");
        sql.append("FInPriceUnitId  varchar(44), \n");
        sql.append("FInPriceCurrencyId  varchar(44), \n");
        sql.append("FIsInTax int not null default 0, \n");
        sql.append("FIsSupplierTaxRate int not null default 0, \n");
        sql.append("FDiscountRate numeric(21,8), ");
        sql.append("FInPriceSupplierTaxRate numeric(21,8), \n");
        sql.append("FInPriceSupplierId varchar(44), \n");
        sql.append("FInPriceSupplierName Nvarchar(255), \n");
        sql.append("FInPriceSupplierNumber Nvarchar(80), \n");
        sql.append("CONSTRAINT ");
        sql.append(new UUTN("ZC").toString());
        sql.append(" PRIMARY KEY (FID) ) ");
        String table = null;
        try {
            table = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        return table;
    }

    protected String getTempResultSelectSql() {
        return "";
    }
}

