/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.quota;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.sm.pur.QuotaVO;
import com.kingdee.eas.scm.sm.pur.QuotaVOCollection;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurBusinessImpl;
import com.kingdee.eas.scm.sm.pur.app.quota.ProjectQuotaContext;
import com.kingdee.eas.scm.sm.pur.app.quota.policy.AbstractQuotaPolicy;
import com.kingdee.eas.scm.sm.pur.app.quota.policy.IQuotaPolicy;
import com.kingdee.eas.scm.sm.pur.app.quota.policy.ProjectFixedRatioPolicy;
import com.kingdee.eas.scm.sm.pur.app.quota.policy.ProjectManualPolicy;
import java.util.HashMap;
import java.util.Map;

public class ProjectQuotaAssignImpl
extends AbstractPurBusinessImpl<QuotaVOCollection> {
    private ProjectQuotaContext quotaCtx = null;
    private PurchaseTypeEnum purchaseType = null;
    private QuotaVOCollection quotaVOCol = null;
    Map<String, QuotaVO> quotaMap = null;
    private String fixedRatioPolicy = "lsh2t9LDQ5m+1uvNrwy/ZhRbtvQ=";
    private Map<String, IQuotaPolicy> cache = new HashMap<String, IQuotaPolicy>();

    public ProjectQuotaAssignImpl(Context ctx, Object param) {
        super(ctx, param);
        this.purchaseType = (PurchaseTypeEnum)((Object[])param)[0];
        this.quotaVOCol = (QuotaVOCollection)((Object[])param)[1];
        this.quotaMap = (Map)((Object[])param)[2];
        this.quotaCtx = new ProjectQuotaContext(ctx, this.purchaseType, this.quotaMap);
    }

    @Override
    protected QuotaVOCollection execute() throws EASBizException, BOSException {
        QuotaVOCollection quotaVOColAssign = new QuotaVOCollection();
        this.quotaCtx.init(this.quotaVOCol);
        AbstractQuotaPolicy executor = null;
        for (int i = 0; i < this.quotaVOCol.size(); ++i) {
            QuotaVO quotaVO = this.quotaVOCol.getQuotaVO(i);
            MaterialPurchasingInfo purInfo = this.quotaCtx.getMaterialPurInfo(quotaVO.getMaterialId(), quotaVO.getPurOrgUnitId());
            executor = purInfo != null && purInfo.getQuotaPolicy() != null && this.fixedRatioPolicy.equals(purInfo.getQuotaPolicy().getId().toString()) ? new ProjectFixedRatioPolicy(this.quotaCtx) : new ProjectManualPolicy(this.quotaCtx);
            if (executor == null) continue;
            QuotaVOCollection voCol = executor.assign(quotaVO);
            quotaVOColAssign.merge(voCol);
        }
        return quotaVOColAssign;
    }

    @Override
    protected String getBusinessName() throws EASBizException, BOSException {
        return " Quota Assign ";
    }
}

