/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.quota;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierCollection;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.sm.pur.QuotaVO;
import com.kingdee.eas.scm.sm.pur.QuotaVOCollection;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaContext;
import com.kingdee.eas.scm.util.string.StringUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ProjectQuotaContext
extends QuotaContext {
    private Map<String, QuotaVO> quotaMap = null;
    Map<String, SupplierInfo> historySupplierMap = null;
    private Map<String, List<ApprovedSupplierInfo>> supplierQuotaCol = new HashMap<String, List<ApprovedSupplierInfo>>();

    public Map<String, SupplierInfo> getHistorySupplierMap() {
        return this.historySupplierMap;
    }

    public void setHistorySupplierMap(Map<String, SupplierInfo> historySupplierMap) {
        this.historySupplierMap = historySupplierMap;
    }

    public ProjectQuotaContext(Context ctx, PurchaseTypeEnum purchaseType) {
        super(ctx, purchaseType);
    }

    public Map<String, QuotaVO> getQuotaMap() {
        return this.quotaMap;
    }

    public void setQuotaMap(Map<String, QuotaVO> quotaMap) {
        this.quotaMap = quotaMap;
    }

    public ProjectQuotaContext(Context ctx, PurchaseTypeEnum purchaseType, Map<String, QuotaVO> quotaMap) {
        super(ctx, purchaseType);
        this.quotaMap = quotaMap;
    }

    @Override
    public void init(QuotaVOCollection quotaVOCol) throws BOSException {
        super.init(quotaVOCol);
        this.initHistoryOrder(quotaVOCol);
    }

    protected void initHistoryOrder(QuotaVOCollection quotaVOCol) throws BOSException {
        for (int i = 0; i < quotaVOCol.size(); ++i) {
            StringBuffer sql = new StringBuffer();
            this.historySupplierMap = new HashMap<String, SupplierInfo>();
            String tmpTable = this.insertdata(this.getCtx(), quotaVOCol);
            sql.append(" select poe.FMATERIALID, poe.FTRACKNOID,poe.FPURCHASEORGUNITID,po.fsupplierid, ");
            sql.append(" supplier.fnumber,supplier.fname_").append(this.getCtx().getLocale()).append(" as fname ");
            sql.append(" from ").append(tmpTable).append(" tmp ");
            sql.append(" inner join T_SM_purorderentry poe on poe.FTRACKNOID = tmp.FTRACKNOID ");
            sql.append(" and poe.FMATERIALID = tmp.FMATERIALID");
            sql.append(" and poe.FPURCHASEORGUNITID = tmp.FPURCHASEORGUNITID ");
            sql.append(" inner join T_SM_purorder po on po.fid  = poe.fparentid ");
            sql.append(" inner join T_bd_Supplier supplier  on po.fsupplierid  = supplier.fid ");
            IRowSet rs = DbUtil.executeQuery((Context)this.getCtx(), (String)sql.toString());
            SupplierInfo supplierInfo = null;
            try {
                while (rs.next()) {
                    if (StringUtil.isEmpty((String)rs.getString("fsupplierid"))) continue;
                    String key = rs.getString("FPURCHASEORGUNITID") + rs.getString("FMATERIALID") + rs.getString("FTRACKNOID");
                    supplierInfo = new SupplierInfo();
                    supplierInfo.setId(BOSUuid.read((String)rs.getString("fsupplierid")));
                    supplierInfo.setName(rs.getString("fname"));
                    supplierInfo.setNumber(rs.getString("fnumber"));
                    this.historySupplierMap.put(key, supplierInfo);
                }
                continue;
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                if (tmpTable != null) {
                    TempTablePool.getInstance((Context)this.getCtx()).releaseTable(tmpTable);
                }
            }
        }
    }

    private String insertdata(Context ctx, QuotaVOCollection quotaVOCol) throws BOSException {
        StringBuffer sql = new StringBuffer();
        sql.append("create table purorder ( ");
        sql.append("FMATERIALID varchar(44),");
        sql.append("FTRACKNOID varchar(44),");
        sql.append("FPURCHASEORGUNITID varchar(44))");
        String table = null;
        try {
            table = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        }
        catch (Exception e) {
            throw new BOSException((Throwable)e);
        }
        sql.setLength(0);
        sql.append(" insert into ").append(table);
        sql.append(" (FMATERIALID,FTRACKNOID,FPURCHASEORGUNITID) values (?,?,?)");
        Connection conn = null;
        PreparedStatement stmt = null;
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            stmt = conn.prepareStatement(sql.toString());
            Iterator<String> it = this.quotaMap.keySet().iterator();
            while (it.hasNext()) {
                QuotaVO quotaVO = this.quotaMap.get(it.next());
                String purOrgUnitId = quotaVO.getPurOrgUnitId();
                String materialId = quotaVO.getMaterialId();
                if (quotaVO.getMaxTrackNumber() == null) continue;
                stmt.setString(1, materialId);
                stmt.setString(2, quotaVO.getMaxTrackNumber().getId().toString());
                stmt.setString(3, purOrgUnitId);
                stmt.addBatch();
            }
            stmt.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)stmt, (Connection)conn);
        return table;
    }

    @Override
    public List<ApprovedSupplierInfo> getSupplierQuotas(String materialId, String purOrgUnitId) {
        ArrayList supplierQuotas = this.supplierQuotaCol.get(materialId + purOrgUnitId);
        return supplierQuotas != null ? supplierQuotas : new ArrayList();
    }

    public List<ApprovedSupplierInfo> getSupplierQuotas(String materialId, String purOrgUnitId, String projectid) {
        List<Object> supplierQuotas = this.supplierQuotaCol.get(materialId + purOrgUnitId);
        supplierQuotas = StringUtil.isEmpty((String)projectid) ? this.supplierQuotaCol.get(materialId + purOrgUnitId) : this.supplierQuotaCol.get(materialId + purOrgUnitId + projectid);
        if (supplierQuotas == null) {
            supplierQuotas = this.supplierQuotaCol.get(materialId + purOrgUnitId);
        }
        return supplierQuotas != null ? supplierQuotas : new ArrayList();
    }

    @Override
    protected void initSupplierQuota(QuotaVOCollection quotaVOCol) throws BOSException {
        StringBuffer oql = new StringBuffer();
        String materialPurchaseType = "0";
        oql.append("select purMeasureUnit.id,purMeasureUnit.name,purMeasureUnit.number, purchaseOrg.id, materialItem.id, minPackingQty, \n");
        oql.append(" qtyOrderBottom, qtyOrderTop, supplyScope, supplier.number, supplier.name,project.id, \n");
        oql.append(" quotaRate, supplyPriority \n");
        oql.append(" where materialAttr = ").append(materialPurchaseType).append("  \n");
        oql.append("  and isUseable = ").append(1).append("  \n");
        oql.append("  and (id is null \n");
        for (int i = 0; i < quotaVOCol.size(); ++i) {
            QuotaVO quotaVO = quotaVOCol.getQuotaVO(i);
            String purOrgUnitId = quotaVO.getPurOrgUnitId();
            String materialId = quotaVO.getMaterialId();
            String projectid = quotaVO.getProjectid();
            String key = materialId + purOrgUnitId;
            LinkedList<String> keys = new LinkedList<String>();
            if (keys.contains(materialId + purOrgUnitId)) continue;
            keys.add(key);
            oql.append(" or (materialItem.id='").append(materialId);
            oql.append("' and purchaseOrg.id='").append(purOrgUnitId).append("')\n");
        }
        oql.append(") order by materialItem.id, purchaseOrg.id ,project.id ");
        ApprovedSupplierCollection supplierCol = ApprovedSupplierFactory.getLocalInstance((Context)this.getCtx()).getApprovedSupplierCollection(oql.toString());
        ArrayList<ApprovedSupplierInfo> suppliers = null;
        String lastKey = null;
        ProjectInfo project = null;
        for (int i = 0; i < supplierCol.size(); ++i) {
            ApprovedSupplierInfo supplierQuota = supplierCol.get(i);
            String key = supplierQuota.getMaterialItem().getId().toString() + supplierQuota.getPurchaseOrg().getId().toString();
            project = supplierQuota.getProject();
            if (project != null) {
                key = key + project.getId().toString();
            }
            if (lastKey == null || !lastKey.equals(key)) {
                if (i > 0) {
                    this.supplierQuotaCol.put(lastKey, suppliers);
                }
                suppliers = new ArrayList<ApprovedSupplierInfo>();
            }
            if (null != suppliers) {
                suppliers.add(supplierQuota);
            }
            lastKey = key;
        }
        this.supplierQuotaCol.put(lastKey, suppliers);
    }
}

