/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.quota;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.btp.BTPManagerFactory;
import com.kingdee.eas.base.btp.BTPTransformResult;
import com.kingdee.eas.base.btp.IBTPManager;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.IBatchExecute;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.framework.CoreBillBaseInfo;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.sm.pur.IQuotaTransfer;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.sm.pur.QuotaVO;
import com.kingdee.eas.scm.sm.pur.QuotaVOCollection;
import com.kingdee.eas.scm.sm.pur.app.AbstractPurBusinessImpl;
import com.kingdee.eas.scm.sm.pur.app.PurOrderControllerBean;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaUtil;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.sm.sc.app.SubContractOrderControllerBean;
import java.math.BigDecimal;

public class Quota2OrderImpl
extends AbstractPurBusinessImpl<BTPTransformResult> {
    private PurchaseTypeEnum purchaseType = null;
    private QuotaVOCollection quotaVOCol = null;
    private String botMappingId = null;

    public Quota2OrderImpl(Context ctx, Object param) {
        super(ctx, param);
        this.purchaseType = (PurchaseTypeEnum)((Object[])param)[0];
        this.quotaVOCol = (QuotaVOCollection)((Object[])param)[1];
        this.botMappingId = (String)((Object[])param)[2];
    }

    @Override
    protected BTPTransformResult execute() throws EASBizException, BOSException {
        IBTPManager btpInstance = BTPManagerFactory.getLocalInstance((Context)this.ctx);
        this.ctx.put((Object)"NO_SettingValue", (Object)"true");
        BTPTransformResult btpResult = btpInstance.transformForBotp(this.getSrcBillCollection(this.ctx, this.quotaVOCol), QuotaUtil.getTargetBOSType(this.purchaseType), (IObjectPK)new ObjectUuidPK(this.botMappingId));
        this.getQuotaTransfer().setDefaultValue(this.ctx, "SAVE", btpResult.getBills());
        this.saveRelations(btpResult, btpInstance);
        this.ctx.put((Object)"NO_SettingValue", null);
        return btpResult;
    }

    @Override
    protected String getBusinessName() throws EASBizException, BOSException {
        return " Quota to Bill ";
    }

    private void saveRelations(BTPTransformResult btpResult, IBTPManager btpInstance) throws EASBizException, BOSException {
        IObjectCollection targetBillCol = btpResult.getBills();
        for (int i = 0; i < targetBillCol.size(); ++i) {
            btpInstance.saveRelations((CoreBillBaseInfo)targetBillCol.getObject(i), btpResult.getBOTRelationCollection());
        }
    }

    private CoreBillBaseCollection getSrcBillCollection(Context ctx, QuotaVOCollection quotaVOCol) throws BOSException {
        CoreBillBaseCollection srcBillCol = QuotaUtil.getSrcBillCollection(ctx, quotaVOCol);
        quotaVOCol.sort();
        for (int i = 0; i < quotaVOCol.size(); ++i) {
            QuotaVO quotaVO = quotaVOCol.getQuotaVO(i);
            String srcBillId = quotaVO.getSrcBillId();
            String srcBillEntryId = quotaVO.getSrcBillEntryId();
            PurRequestInfo billInfo = (PurRequestInfo)PurUtil.getInfoById((IObjectCollection)srcBillCol, srcBillId);
            PurRequestEntryCollection entries = billInfo.getEntries();
            PurRequestEntryInfo entry = (PurRequestEntryInfo)PurUtil.getInfoById((IObjectCollection)entries, srcBillEntryId);
            if (quotaVO.isFirstPerEntry()) {
                this.setAjustedInfo(quotaVO, entry);
                continue;
            }
            PurRequestEntryInfo entryCloned = (PurRequestEntryInfo)entry.clone();
            this.setAjustedInfo(quotaVO, entryCloned);
            entries.addObjectDirect((IObjectValue)entryCloned);
        }
        return srcBillCol;
    }

    private void setAjustedInfo(QuotaVO quotaVO, PurRequestEntryInfo entryInfo) {
        BigDecimal orderedQty = new BigDecimal("0");
        if (entryInfo.getOrderedQty() != null) {
            orderedQty = entryInfo.getOrderedQty();
        }
        entryInfo.setSupplier(quotaVO.getSupplier());
        entryInfo.setQty(quotaVO.getSplitQty().add(orderedQty));
        entryInfo.setBaseQty(quotaVO.getSplitBaseQty());
        entryInfo.setUnit(quotaVO.getUnit());
    }

    private IQuotaTransfer getQuotaTransfer() throws BOSException {
        IBatchExecute transfer = new PurOrderControllerBean();
        if (PurchaseTypeEnum.SUBCONTRACT.equals((Object)this.purchaseType)) {
            transfer = new SubContractOrderControllerBean();
        }
        return transfer;
    }
}

