/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.quota;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.framework.CoreBillBaseCollection;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.QuotaVOCollection;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaContext;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.HashSet;

public class QuotaUtil {
    public static final int SCALE_RATIO = 4;

    public static String getTargetBOSType(PurchaseTypeEnum purchaseType) {
        Serializable targetBillInfo = new PurOrderInfo();
        if (PurchaseTypeEnum.SUBCONTRACT.equals((Object)purchaseType)) {
            targetBillInfo = new SubContractOrderInfo();
        }
        return targetBillInfo.getBOSType().toString();
    }

    public static CoreBillBaseCollection getSrcBillCollection(Context ctx, QuotaVOCollection quotaVOCol) throws BOSException {
        CoreBillBaseCollection col = PurRequestFactory.getLocalInstance(ctx).getCoreBillBaseCollection(QuotaUtil.getSrcBillFilter(quotaVOCol));
        return col;
    }

    public static EntityViewInfo getSrcBillFilter(QuotaVOCollection quotaVOCol) {
        HashSet<String> srcBillidSet = new HashSet<String>();
        HashSet<String> srcentryBillidSet = new HashSet<String>();
        for (int i = 0; i < quotaVOCol.size(); ++i) {
            String srcBillId = quotaVOCol.getQuotaVO(i).getSrcBillId();
            srcBillidSet.add(srcBillId);
            srcentryBillidSet.add(quotaVOCol.getQuotaVO(i).getSrcBillEntryId());
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", srcBillidSet, CompareType.INCLUDE));
        view.setFilter(filter);
        FilterInfo entryFilter = new FilterInfo();
        entryFilter.setEntryName("entries");
        entryFilter.getFilterItems().add(new FilterItemInfo("id", srcentryBillidSet, CompareType.INCLUDE));
        view.getEntryFilters().add(entryFilter);
        return view;
    }

    public static int getScale(QuotaContext quotaCtx, String materialId, String unitId) {
        int scale = 4;
        MultiMeasureUnitInfo multiMeasureUnit = quotaCtx.getMultiUnit(materialId, unitId);
        if (multiMeasureUnit != null) {
            scale = multiMeasureUnit.getQtyPrecision();
        }
        return scale;
    }

    public static BigDecimal getQtyByUnit(BigDecimal qty, MultiMeasureUnitInfo srcUnit, MultiMeasureUnitInfo targetUnit) {
        if (qty == null) {
            return new BigDecimal("0.00");
        }
        if (srcUnit == null || targetUnit == null) {
            return qty;
        }
        return qty.multiply(srcUnit.getBaseConvsRate()).divide(targetUnit.getBaseConvsRate(), targetUnit.getQtyPrecision(), 4);
    }
}

