/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.quota;

import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import java.math.BigDecimal;
import java.util.Comparator;

public class SupplierQuotaComparator {
    public static final Comparator<ApprovedSupplierInfo> SUPPLIER_QUOTA_PRIORITY_ASC = new SupplierQuotaPriorityAscComparator();
    public static final Comparator<ApprovedSupplierInfo> SUPPLIER_QUOTA_RATIO_EDSC = new SupplierQuotaRatioDescComparator();
    public static final Comparator<ApprovedSupplierInfo> DYNAMIC_RATIO_ASC = new DynamicRatioAscComparator();

    private static class SupplierQuotaRatioDescComparator
    implements Comparator<ApprovedSupplierInfo> {
        private SupplierQuotaRatioDescComparator() {
        }

        @Override
        public int compare(ApprovedSupplierInfo o1, ApprovedSupplierInfo o2) {
            BigDecimal ratio1 = o1.getQuotaRate();
            BigDecimal ratio2 = o2.getQuotaRate();
            if (ratio1 != null && ratio2 != null) {
                if (ratio1.compareTo(ratio2) > 0) {
                    return -1;
                }
                if (ratio1.compareTo(ratio2) < 0) {
                    return 1;
                }
            }
            return 0;
        }
    }

    private static class SupplierQuotaPriorityAscComparator
    implements Comparator<ApprovedSupplierInfo> {
        private SupplierQuotaPriorityAscComparator() {
        }

        @Override
        public int compare(ApprovedSupplierInfo o1, ApprovedSupplierInfo o2) {
            int priority2;
            int priority1 = o1.getSupplyPriority();
            if (priority1 > (priority2 = o2.getSupplyPriority())) {
                return 1;
            }
            if (priority1 < priority2) {
                return -1;
            }
            return 0;
        }
    }

    private static class DynamicRatioAscComparator
    implements Comparator<ApprovedSupplierInfo> {
        private DynamicRatioAscComparator() {
        }

        @Override
        public int compare(ApprovedSupplierInfo o1, ApprovedSupplierInfo o2) {
            BigDecimal ratio1 = o1.getBigDecimal("dynamicRatio");
            BigDecimal ratio2 = o2.getBigDecimal("dynamicRatio");
            if (ratio1 == null && ratio2 == null) {
                SupplierQuotaRatioDescComparator comparator = new SupplierQuotaRatioDescComparator();
                return comparator.compare(o1, o2);
            }
            if (ratio1 == null) {
                return 1;
            }
            if (ratio2 == null) {
                return -1;
            }
            if (ratio1.compareTo(ratio2) > 0) {
                return 1;
            }
            if (ratio1.compareTo(ratio2) < 0) {
                return -1;
            }
            if (ratio1.compareTo(ratio2) == 0) {
                SupplierQuotaRatioDescComparator comparator = new SupplierQuotaRatioDescComparator();
                return comparator.compare(o1, o2);
            }
            return 0;
        }
    }
}

