/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.quota.policy;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.QuotaPeriodEnum;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.PurchaseTypeEnum;
import com.kingdee.eas.scm.sm.pur.QuotaVO;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaContext;
import com.kingdee.eas.scm.sm.pur.app.quota.SupplierQuotaComparator;
import com.kingdee.eas.scm.sm.pur.app.quota.policy.AbstractQuotaPolicy;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;

public class DynamicRatioPolicy
extends AbstractQuotaPolicy {
    public DynamicRatioPolicy(QuotaContext quotaCtx) {
        super(quotaCtx);
    }

    @Override
    public QuotaVO assign4Supplier(QuotaVO quotaVO, ApprovedSupplierInfo supplierQuota, List<ApprovedSupplierInfo> supplierQuotas) throws BOSException, EASBizException {
        if (quotaVO.getRemainEntryQty().compareTo(ZERO) == 0) {
            return null;
        }
        BigDecimal splitQty = ZERO;
        BigDecimal minDivQty = this.getMinDivQty(quotaVO);
        splitQty = quotaVO.getEntryQty().compareTo(minDivQty) <= 0 ? quotaVO.getEntryQty() : quotaVO.getRemainEntryQty();
        QuotaVO voAssign = (QuotaVO)quotaVO.clone();
        voAssign.setSplitQty(splitQty);
        return voAssign;
    }

    @Override
    protected void sortSupplierQuotas(List<ApprovedSupplierInfo> supplierQuotas) {
        Collections.sort(supplierQuotas, SupplierQuotaComparator.DYNAMIC_RATIO_ASC);
    }

    @Override
    public List<ApprovedSupplierInfo> getSupplierQuotas(QuotaVO quotaVO) throws BOSException {
        List<ApprovedSupplierInfo> approvedSupplierInfos = this.quotaCtx.getSupplierQuotas(quotaVO.getMaterialId(), quotaVO.getPurOrgUnitId());
        BigDecimal dynamicRatio = null;
        ApprovedSupplierInfo supplierQuota = null;
        if (approvedSupplierInfos != null) {
            int size = approvedSupplierInfos.size();
            for (int i = 0; i < size; ++i) {
                supplierQuota = approvedSupplierInfos.get(i);
                dynamicRatio = this.calcDynamicRatio(quotaVO, supplierQuota);
                supplierQuota.put("dynamicRatio", (Object)dynamicRatio);
            }
        }
        return approvedSupplierInfos;
    }

    private BigDecimal calcDynamicRatio(QuotaVO quotaVO, ApprovedSupplierInfo supplierQuota) throws BOSException {
        BigDecimal dynamicRatio = null;
        BigDecimal totalQty = ZERO;
        BigDecimal ratio = supplierQuota.getQuotaRate();
        String supplierid = supplierQuota.getSupplier().getId().toString();
        totalQty = this.getTotalQty(quotaVO, supplierid);
        if (totalQty != null && ratio != null && ratio.compareTo(ZERO) > 0) {
            dynamicRatio = totalQty.divide(ratio, 8, 4);
        }
        if (totalQty.compareTo(ZERO) == 0) {
            dynamicRatio = ZERO;
        }
        return dynamicRatio;
    }

    private QuotaPeriodEnum getMaterialPurchase(QuotaVO quotaVO) {
        MaterialPurchasingInfo materialPurchaseInfo = this.quotaCtx.getMaterialPurInfo(quotaVO.getMaterialId(), quotaVO.getPurOrgUnitId());
        QuotaPeriodEnum quotaPeriodEnum = materialPurchaseInfo.getQuotaPeriod();
        return quotaPeriodEnum;
    }

    private BigDecimal getTotalQty(QuotaVO quotaVO, String supplierid) throws BOSException {
        String sql = null;
        BigDecimal qty = ZERO;
        QuotaPeriodEnum quotaPeriodEnum = this.getMaterialPurchase(quotaVO);
        sql = QuotaPeriodEnum.month.equals((Object)quotaPeriodEnum) ? this.getMonthSql(quotaVO) : (QuotaPeriodEnum.season.equals((Object)quotaPeriodEnum) ? this.getSeasonSql(quotaVO) : this.getYearSql(quotaVO));
        try {
            IRowSet rs = DbUtil.executeQuery((Context)this.quotaCtx.getCtx(), (String)sql, (Object[])new String[]{supplierid, quotaVO.getPurOrgUnitId(), quotaVO.getMaterialId()});
            if (rs.next()) {
                qty = rs.getBigDecimal("qty");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        if (qty == null) {
            return ZERO;
        }
        return qty;
    }

    private String getPurchaseSql(Date firstDate, Date lastDate) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String table = null;
        String entrytable = null;
        if (PurchaseTypeEnum.PURCHASE.equals((Object)this.quotaCtx.getPurchaseType())) {
            table = "T_SM_purorder";
            entrytable = "T_SM_purorderentry";
        } else {
            table = "T_SM_SubContractOrder";
            entrytable = "T_SM_SubContractOrderEntry";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" select sum(entry.fbaseqty) as qty from ").append(entrytable).append(" as entry ");
        sql.append(" inner join ").append(table).append(" as smorder on smorder.fid = entry.fparentid ");
        sql.append(" where smorder.fsupplierid = ? and smorder.fpurchaseOrgUnitid=?");
        sql.append(" and entry.fmaterialid =? ");
        sql.append(" and smorder.fbizDate >={").append(df.format(firstDate));
        sql.append("} and smorder.fbizDate <={").append(df.format(lastDate));
        sql.append("} and smorder.fbaseStatus <>3");
        sql.append(" and smorder.fbaseStatus <> -3");
        return sql.toString();
    }

    private String getMonthSql(QuotaVO quotaVO) throws BOSException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(quotaVO.getBizDate());
        int lastDay = calendar.getActualMaximum(5);
        calendar.set(5, 1);
        Date firstDate = calendar.getTime();
        calendar.set(5, lastDay);
        Date lastDate = calendar.getTime();
        String sql = this.getPurchaseSql(firstDate, lastDate);
        return sql;
    }

    private String getYearSql(QuotaVO quotaVO) throws BOSException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(quotaVO.getBizDate());
        calendar.set(2, 0);
        calendar.set(6, 1);
        Date firstDate = calendar.getTime();
        calendar.set(2, 11);
        calendar.set(5, 31);
        Date lastDate = calendar.getTime();
        String sql = this.getPurchaseSql(firstDate, lastDate);
        return sql;
    }

    private String getSeasonSql(QuotaVO quotaVO) throws BOSException {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(quotaVO.getBizDate());
        int bizmonth = calendar.get(2) + 1;
        int month = DynamicRatioPolicy.getQuarterInMonth(bizmonth, true);
        calendar.set(2, month);
        calendar.set(5, 1);
        Date firstDate = calendar.getTime();
        month = DynamicRatioPolicy.getQuarterInMonth(bizmonth, false);
        calendar.set(2, month);
        calendar.set(5, 0);
        Date lastDate = calendar.getTime();
        String sql = this.getPurchaseSql(firstDate, lastDate);
        return sql;
    }

    private static int getQuarterInMonth(int month, boolean isQuarterStart) {
        int[] months = new int[]{12, 3, 6, 9};
        if (!isQuarterStart) {
            months = new int[]{3, 6, 9, 12};
        }
        if (month >= 1 && month <= 3) {
            return months[0];
        }
        if (month >= 4 && month <= 6) {
            return months[1];
        }
        if (month >= 7 && month <= 9) {
            return months[2];
        }
        return months[3];
    }
}

