/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.quota.policy;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.QuotaVO;
import com.kingdee.eas.scm.sm.pur.QuotaVOCollection;
import com.kingdee.eas.scm.sm.pur.app.quota.ProjectQuotaContext;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaContext;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaUtil;
import com.kingdee.eas.scm.sm.pur.app.quota.SupplierQuotaComparator;
import com.kingdee.eas.scm.sm.pur.app.quota.policy.AbstractQuotaPolicy;
import java.math.BigDecimal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class ProjectFixedRatioPolicy
extends AbstractQuotaPolicy {
    public ProjectFixedRatioPolicy(QuotaContext quotaContext) {
        super(quotaContext);
    }

    @Override
    public QuotaVOCollection assign(QuotaVO quotaVO) throws BOSException, EASBizException {
        QuotaVOCollection quotaVOColAssign = null;
        QuotaVOCollection quotaVOColUnAssign = this.getAssignQuotaVOCollection(quotaVO);
        List<ApprovedSupplierInfo> supplierQuotas = this.getSupplierQuotas(quotaVO);
        quotaVOColAssign = quotaVO.getMaxTrackNumber() != null ? this.assign4TrackNumber(quotaVO, supplierQuotas, quotaVOColUnAssign) : this.assignNOTrackNumber(quotaVO, supplierQuotas, quotaVOColUnAssign);
        return quotaVOColAssign;
    }

    private QuotaVOCollection assignNOTrackNumber(QuotaVO quotaVO, List<ApprovedSupplierInfo> supplierQuotas, QuotaVOCollection quotaVOColUnAssign) throws BOSException, EASBizException {
        QuotaVOCollection quotaVOColAssign = new QuotaVOCollection();
        QuotaVO voAssign = null;
        if (supplierQuotas != null && supplierQuotas.size() > 0) {
            this.sortSupplierQuotas(supplierQuotas);
            Iterator<ApprovedSupplierInfo> quotaIter = supplierQuotas.iterator();
            ApprovedSupplierInfo approvedSupplierInfo = null;
            int scale = QuotaUtil.getScale(this.quotaCtx, quotaVO.getMaterialId(), quotaVO.getUnitId());
            int ratioScale = 6;
            int i = 0;
            BigDecimal totalRatio = this.getTotalRatio(supplierQuotas);
            BigDecimal splitQty = ZERO;
            BigDecimal unsplitQty = ZERO;
            BigDecimal totalsplitQty = ZERO;
            BigDecimal entryunsplitQty = ZERO;
            while (quotaIter.hasNext() && totalsplitQty.compareTo(quotaVO.getEntryQty()) < 0) {
                approvedSupplierInfo = quotaIter.next();
                BigDecimal ratio = approvedSupplierInfo.getQuotaRate().divide(totalRatio, ratioScale, 4);
                unsplitQty = splitQty = quotaVO.getEntryQty().multiply(ratio).setScale(scale, 4);
                while (unsplitQty.compareTo(ZERO) > 0 && i < quotaVOColUnAssign.size()) {
                    voAssign = (QuotaVO)quotaVOColUnAssign.getQuotaVO(i).clone();
                    if (entryunsplitQty.compareTo(ZERO) == 0) {
                        entryunsplitQty = voAssign.getEntryQty();
                    }
                    BigDecimal splitRatio = voAssign.getEntryQty().divide(quotaVO.getEntryQty(), ratioScale, 4);
                    voAssign.setSupplier(approvedSupplierInfo.getSupplier());
                    this.getRelatedData(voAssign, approvedSupplierInfo);
                    if (splitQty.compareTo(entryunsplitQty) > 0) {
                        voAssign.setSplitBaseQty(entryunsplitQty);
                        voAssign.setUnAssBaseOrderQty(quotaVO.getEntryQty());
                        voAssign.setSplitQty(entryunsplitQty);
                        unsplitQty = unsplitQty.subtract(entryunsplitQty);
                        entryunsplitQty = ZERO;
                        ++i;
                    } else {
                        voAssign.setSplitBaseQty(splitQty);
                        voAssign.setUnAssBaseOrderQty(quotaVO.getEntryQty());
                        voAssign.setSplitQty(splitQty);
                        voAssign.setSplitBaseQty(splitQty);
                        entryunsplitQty = splitQty.subtract(unsplitQty);
                        unsplitQty = ZERO;
                    }
                    voAssign.setSplitRatio(splitRatio);
                    voAssign.setMinseq(quotaVO.getMinseq());
                    voAssign.setMaxseq(quotaVO.getMaxseq());
                    quotaVOColAssign.addQuotaVO(voAssign);
                }
            }
        } else {
            for (int i = 0; i < quotaVOColUnAssign.size(); ++i) {
                voAssign = quotaVOColUnAssign.getQuotaVO(i);
                voAssign.setMinseq(quotaVO.getMinseq());
                voAssign.setMaxseq(quotaVO.getMaxseq());
                voAssign.setSplitBaseQty(voAssign.getEntryQty());
                voAssign.setUnAssBaseOrderQty(quotaVO.getEntryQty());
                this.getRelatedData(voAssign);
                quotaVOColAssign.addQuotaVO(voAssign);
            }
        }
        return quotaVOColAssign;
    }

    private QuotaVOCollection assign4TrackNumber(QuotaVO quotaVO, List<ApprovedSupplierInfo> supplierQuotas, QuotaVOCollection quotaVOColUnAssign) throws BOSException, EASBizException {
        int i;
        QuotaVOCollection quotaVOColAssign = new QuotaVOCollection();
        QuotaVO voAssign = null;
        String matreialid = quotaVO.getMaterialId();
        String purorgid = quotaVO.getPurOrgUnitId();
        String tracknumber = null;
        int ratioScale = 6;
        Map<String, SupplierInfo> historySupplierMap = ((ProjectQuotaContext)this.quotaCtx).getHistorySupplierMap();
        HashSet<Integer> historySet = new HashSet<Integer>();
        int size = quotaVOColUnAssign.size();
        for (i = 0; i < size; ++i) {
            voAssign = quotaVOColUnAssign.getQuotaVO(i);
            if (voAssign.getMinTrackNumber() == null) continue;
            tracknumber = voAssign.getMinTrackNumber().getId().toString();
            if (!historySupplierMap.containsKey(purorgid + matreialid + tracknumber)) continue;
            BigDecimal splitRatio = voAssign.getEntryQty().divide(quotaVO.getEntryQty(), ratioScale, 4);
            voAssign.setSupplier(historySupplierMap.get(purorgid + matreialid + tracknumber));
            this.getRelatedData(voAssign);
            voAssign.setSplitBaseQty(voAssign.getEntryQty());
            voAssign.setUnAssBaseOrderQty(quotaVO.getEntryQty());
            voAssign.setSplitRatio(splitRatio);
            voAssign.setMinseq(quotaVO.getMinseq());
            voAssign.setMaxseq(quotaVO.getMaxseq());
            voAssign.setSplitQty(voAssign.getEntryQty());
            voAssign.setSplitBaseQty(voAssign.getSplitBaseQty());
            quotaVOColAssign.addQuotaVO(voAssign);
            historySet.add(i);
        }
        if (supplierQuotas != null && supplierQuotas.size() > 0) {
            this.sortSupplierQuotas(supplierQuotas);
            Iterator<ApprovedSupplierInfo> quotaIter = supplierQuotas.iterator();
            ApprovedSupplierInfo approvedSupplierInfo = null;
            int scale = QuotaUtil.getScale(this.quotaCtx, quotaVO.getMaterialId(), quotaVO.getUnitId());
            int i2 = 0;
            BigDecimal totalRatio = this.getTotalRatio(supplierQuotas);
            BigDecimal splitQty = ZERO;
            BigDecimal totalQty = ZERO;
            while (quotaIter.hasNext() && quotaVOColAssign.size() < quotaVOColUnAssign.size()) {
                totalQty = ZERO;
                approvedSupplierInfo = quotaIter.next();
                BigDecimal ratio = approvedSupplierInfo.getQuotaRate().divide(totalRatio, ratioScale, 4);
                splitQty = quotaVO.getEntryQty().multiply(ratio).setScale(scale, 4);
                while (splitQty.compareTo(totalQty) > 0 && quotaVOColAssign.size() < quotaVOColUnAssign.size()) {
                    voAssign = (QuotaVO)quotaVOColUnAssign.getQuotaVO(i2).clone();
                    tracknumber = voAssign.getMinTrackNumber().getId().toString();
                    if (historySupplierMap.containsKey(purorgid + matreialid + tracknumber)) {
                        ++i2;
                        continue;
                    }
                    BigDecimal splitRatio = voAssign.getEntryQty().divide(quotaVO.getEntryQty(), ratioScale, 4);
                    voAssign.setSupplier(approvedSupplierInfo.getSupplier());
                    this.getRelatedData(voAssign, approvedSupplierInfo);
                    voAssign.setSplitBaseQty(voAssign.getEntryQty());
                    voAssign.setUnAssBaseOrderQty(quotaVO.getEntryQty());
                    voAssign.setSplitRatio(splitRatio);
                    voAssign.setMinseq(quotaVO.getMinseq());
                    voAssign.setMaxseq(quotaVO.getMaxseq());
                    voAssign.setSplitQty(voAssign.getEntryQty());
                    voAssign.setSplitBaseQty(voAssign.getSplitBaseQty());
                    quotaVOColAssign.addQuotaVO(voAssign);
                    totalQty = totalQty.add(voAssign.getEntryQty());
                    ++i2;
                }
            }
        } else {
            for (i = 0; i < quotaVOColUnAssign.size(); ++i) {
                voAssign = quotaVOColUnAssign.getQuotaVO(i);
                voAssign.setMinseq(quotaVO.getMinseq());
                voAssign.setMaxseq(quotaVO.getMaxseq());
                voAssign.setSplitBaseQty(voAssign.getEntryQty());
                voAssign.setUnAssBaseOrderQty(quotaVO.getEntryQty());
                this.getRelatedData(voAssign);
                quotaVOColAssign.addQuotaVO(voAssign);
            }
        }
        return quotaVOColAssign;
    }

    private QuotaVOCollection getAssignQuotaVOCollection(QuotaVO quotaVO) {
        QuotaVOCollection quotaVOColAssign = new QuotaVOCollection();
        String billid = quotaVO.getSrcBillId();
        int minseq = quotaVO.getMinseq();
        int maxseq = quotaVO.getMaxseq();
        String key = null;
        ProjectQuotaContext projectQuotaCtx = (ProjectQuotaContext)this.quotaCtx;
        Map<String, QuotaVO> quotaMap = projectQuotaCtx.getQuotaMap();
        for (int i = minseq; i <= maxseq; ++i) {
            key = billid + "_" + i;
            QuotaVO vo = quotaMap.get(key);
            quotaVOColAssign.addQuotaVO(vo);
        }
        quotaVOColAssign.sortForQty();
        return quotaVOColAssign;
    }

    @Override
    public QuotaVO assign4Supplier(QuotaVO quotaVO, ApprovedSupplierInfo supplierQuota, List<ApprovedSupplierInfo> supplierQuotas) throws BOSException {
        QuotaVO voAssign = (QuotaVO)quotaVO.clone();
        int scale = QuotaUtil.getScale(this.quotaCtx, quotaVO.getMaterialId(), quotaVO.getUnitId());
        int ratioScale = 6;
        BigDecimal totalRatio = this.getTotalRatio(supplierQuotas);
        BigDecimal splitQty = ZERO;
        BigDecimal minDivQty = this.getMinDivQty(quotaVO);
        if (quotaVO.getEntryQty().compareTo(minDivQty) <= 0) {
            splitQty = quotaVO.getEntryQty();
        } else if (totalRatio.compareTo(ZERO) != 0 && supplierQuota.getQuotaRate().compareTo(ZERO) != 0) {
            BigDecimal ratio = supplierQuota.getQuotaRate().divide(totalRatio, ratioScale, 4);
            splitQty = quotaVO.getEntryQty().multiply(ratio).setScale(scale, 4);
            int index = supplierQuotas.indexOf(supplierQuota);
            if (index == supplierQuotas.size() - 1) {
                splitQty = quotaVO.getRemainEntryQty();
            }
        }
        voAssign.setSplitQty(splitQty);
        return voAssign;
    }

    @Override
    public void sortSupplierQuotas(List<ApprovedSupplierInfo> supplierQuotas) {
        Collections.sort(supplierQuotas, SupplierQuotaComparator.SUPPLIER_QUOTA_RATIO_EDSC);
    }

    @Override
    public List<ApprovedSupplierInfo> getSupplierQuotas(QuotaVO quotaVO) throws BOSException {
        ProjectQuotaContext projectQuotaCtx = (ProjectQuotaContext)this.quotaCtx;
        List<ApprovedSupplierInfo> approvedSupplierList = projectQuotaCtx.getSupplierQuotas(quotaVO.getMaterialId(), quotaVO.getPurOrgUnitId(), quotaVO.getProjectid());
        return approvedSupplierList;
    }

    private BigDecimal getTotalRatio(List<ApprovedSupplierInfo> supplierQuotas) {
        BigDecimal totalRatio = ZERO;
        for (int i = 0; i < supplierQuotas.size(); ++i) {
            BigDecimal quotaRate = supplierQuotas.get(i).getQuotaRate() == null ? ZERO : supplierQuotas.get(i).getQuotaRate();
            totalRatio = totalRatio.add(quotaRate);
        }
        return totalRatio;
    }
}

