/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.quota.policy;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.QuotaVO;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaContext;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaUtil;
import com.kingdee.eas.scm.sm.pur.app.quota.policy.AbstractQuotaPolicy;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

public class SuppllyRangePolicy
extends AbstractQuotaPolicy {
    public SuppllyRangePolicy(QuotaContext quotaCtx) {
        super(quotaCtx);
    }

    @Override
    public QuotaVO assign4Supplier(QuotaVO quotaVO, ApprovedSupplierInfo supplierQuota, List<ApprovedSupplierInfo> supplierQuotas) throws BOSException, EASBizException {
        QuotaVO voAssign = (QuotaVO)quotaVO.clone();
        BigDecimal splitQty = quotaVO.getEntryQty();
        splitQty = this.ajustByOrderkQty(voAssign, splitQty, supplierQuota);
        voAssign.setSplitQty(splitQty);
        return voAssign;
    }

    protected BigDecimal ajustByOrderkQty(QuotaVO quotaVO, BigDecimal ajustQty, ApprovedSupplierInfo supplierQuota) {
        MultiMeasureUnitInfo billUnit = this.quotaCtx.getMultiUnit(quotaVO.getMaterialId(), quotaVO.getUnitId());
        MultiMeasureUnitInfo quotaUnit = this.quotaCtx.getMultiUnit(quotaVO.getMaterialId(), supplierQuota.getPurMeasureUnit().getId().toString());
        BigDecimal maxOrderQty = QuotaUtil.getQtyByUnit(supplierQuota.getQtyOrderTop(), quotaUnit, billUnit);
        BigDecimal minOrderQty = QuotaUtil.getQtyByUnit(supplierQuota.getQtyOrderBottom(), quotaUnit, billUnit);
        if (ajustQty.compareTo(minOrderQty) < 0) {
            ajustQty = quotaVO.isUnCtrlQty() ? minOrderQty : ZERO;
        }
        if (ajustQty.compareTo(maxOrderQty) > 0) {
            ajustQty = maxOrderQty;
        }
        return ajustQty;
    }

    @Override
    public List<ApprovedSupplierInfo> getSupplierQuotas(QuotaVO quotaVO) throws BOSException {
        List<ApprovedSupplierInfo> supplierQuotas = super.getSupplierQuotas(quotaVO);
        ArrayList<ApprovedSupplierInfo> suppliers = new ArrayList<ApprovedSupplierInfo>();
        for (int i = 0; i < supplierQuotas.size(); ++i) {
            ApprovedSupplierInfo candidate = supplierQuotas.get(i);
            String supplyScope = candidate.getSupplyScope();
            if (supplyScope == null) continue;
            String[] scopes = supplyScope.split(";");
            for (int j = 0; j < scopes.length; ++j) {
                if (!scopes[j].equals(quotaVO.getRecOrgUnitId())) continue;
                suppliers.add(candidate);
                return suppliers;
            }
        }
        return suppliers;
    }
}

