/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.app.quota.policy.ajust;

import com.kingdee.bos.BOSException;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.sm.pur.QuotaVO;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaContext;
import com.kingdee.eas.scm.sm.pur.app.quota.QuotaUtil;
import java.math.BigDecimal;

public class BatchAjustPolicy {
    public static final BigDecimal ZERO = new BigDecimal("0.00");
    public static final BigDecimal ONE = new BigDecimal("1.0");
    protected QuotaContext quotaCtx = null;

    public BatchAjustPolicy(QuotaContext quotaCtx) {
        this.quotaCtx = quotaCtx;
    }

    public QuotaVO ajustPolicy(QuotaVO quotaVO, QuotaVO voAssign, ApprovedSupplierInfo supplierQuota) throws BOSException, EASBizException {
        if (voAssign == null || voAssign.getSplitQty().compareTo(ZERO) == 0) {
            return voAssign;
        }
        BigDecimal ajustQty = voAssign.getSplitQty();
        MaterialPurchasingInfo purInfo = this.quotaCtx.getMaterialPurInfo(quotaVO.getMaterialId(), quotaVO.getPurOrgUnitId());
        MultiMeasureUnitInfo billUnit = this.quotaCtx.getMultiUnit(quotaVO.getMaterialId(), quotaVO.getUnitId());
        MultiMeasureUnitInfo quotaUnit = this.quotaCtx.getMultiUnit(quotaVO.getMaterialId(), supplierQuota.getPurMeasureUnit().getId().toString());
        MultiMeasureUnitInfo purUnit = this.quotaCtx.getMultiUnit(quotaVO.getMaterialId(), purInfo.getUnit().getId().toString());
        BigDecimal minDivQty = QuotaUtil.getQtyByUnit(purInfo.getMinDivisionQty(), purUnit, billUnit);
        BigDecimal minPackQty = QuotaUtil.getQtyByUnit(supplierQuota.getMinPackingQty(), quotaUnit, billUnit);
        BigDecimal minOrderQty = QuotaUtil.getQtyByUnit(supplierQuota.getQtyOrderBottom(), quotaUnit, billUnit);
        BigDecimal maxOrderQty = QuotaUtil.getQtyByUnit(supplierQuota.getQtyOrderTop(), quotaUnit, billUnit);
        if (voAssign.getEntryQty().compareTo(minDivQty) > 0) {
            ajustQty = this.ajustByOrderkQty(voAssign, ajustQty, minOrderQty, maxOrderQty);
        }
        if ((ajustQty = this.ajustByMinPackQty(quotaVO, ajustQty, minPackQty, minOrderQty, maxOrderQty)).compareTo(maxOrderQty) > 0 && minPackQty != null) {
            ajustQty = ajustQty.subtract(minPackQty);
        }
        voAssign.setSplitQty(ajustQty);
        return voAssign;
    }

    protected BigDecimal ajustByOrderkQty(QuotaVO voAssign, BigDecimal ajustQty, BigDecimal minOrderQty, BigDecimal maxOrderQty) {
        if (voAssign.getSplitQty() == null) {
            voAssign.setSplitQty(ZERO);
        }
        if (minOrderQty == null) {
            minOrderQty = ZERO;
        }
        if (maxOrderQty == null) {
            maxOrderQty = ZERO;
        }
        if (voAssign.getSplitQty().compareTo(minOrderQty) < 0) {
            ajustQty = voAssign.isUnCtrlQty() || voAssign.getRemainEntryQty().compareTo(minOrderQty) >= 0 ? minOrderQty : ZERO;
        }
        if (voAssign.getSplitQty().compareTo(maxOrderQty) > 0) {
            ajustQty = maxOrderQty;
        }
        return ajustQty;
    }

    private BigDecimal ajustByMinPackQty(QuotaVO quotaVO, BigDecimal ajustQty, BigDecimal minPackQty, BigDecimal minOrderQty, BigDecimal maxOrderQty) {
        BigDecimal[] divResult;
        if (minOrderQty == null) {
            minOrderQty = ZERO;
        }
        if (maxOrderQty == null) {
            maxOrderQty = ZERO;
        }
        if (minPackQty != null && minPackQty.compareTo(ZERO) != 0 && (divResult = ajustQty.divideAndRemainder(minPackQty))[1] != null && divResult[1].compareTo(ZERO) > 0) {
            BigDecimal multiple = divResult[0];
            BigDecimal multipleTop = ajustQty.divideToIntegralValue(minPackQty);
            if (multiple.compareTo(multipleTop) > 0) {
                multiple = multipleTop;
            }
            ajustQty = minPackQty.multiply(multiple);
            if (quotaVO.isUnCtrlQty()) {
                ajustQty = ajustQty.add(minPackQty);
            }
            if (ajustQty.compareTo(minOrderQty) == -1) {
                ajustQty = ZERO;
            } else if (maxOrderQty.compareTo(ajustQty) == -1) {
                while (ajustQty.compareTo(ZERO) > 0 && maxOrderQty.compareTo(ajustQty) == -1) {
                    ajustQty = ajustQty.subtract(minPackQty);
                }
            }
        }
        return ajustQty;
    }
}

