/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.vrule.app.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.cssp.SupplierInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BizTypeInfo;
import com.kingdee.eas.basedata.scm.common.IRowType;
import com.kingdee.eas.basedata.scm.common.RowTypeFactory;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.IApprovedSupplier;
import com.kingdee.eas.basedata.scm.sm.srm.ISupplyInfo;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoFactory;
import com.kingdee.eas.basedata.scm.sm.srm.SupplyInfoInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;

public class CheckDataValid4SubmitVRule
implements IVRule {
    Context ctx = null;

    public CheckDataValid4SubmitVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurOrderInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
    }

    protected void checkValidforSubmit(IObjectValue model, Context ctx) throws EASBizException, BOSException {
        PurOrderInfo purOrderInfo = (PurOrderInfo)model;
        StringBuffer errorSb = new StringBuffer();
        StringBuffer errorSbOther = new StringBuffer();
        boolean isError = false;
        if (purOrderInfo.getBizType() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_BIZTYPE", ctx));
            isError = true;
        }
        if (purOrderInfo.getBizDate() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_ORDERDATE", ctx));
            isError = true;
        }
        if (purOrderInfo.getPurchaseOrgUnit() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_PURCHASEORGUNIT", ctx));
            isError = true;
        }
        if (purOrderInfo.getSupplier() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_SUPPLIER", ctx));
            isError = true;
        }
        if (purOrderInfo.getSettlementType() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_SETTLEMENTTYPE", ctx));
            isError = true;
        }
        if (purOrderInfo.getPaymentType() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_PAYMENTTYPE", ctx));
            isError = true;
        }
        if (purOrderInfo.getCurrency() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_CURRENCY", ctx));
            isError = true;
        }
        if (purOrderInfo.getExchangeRate() == null) {
            if (isError) {
                errorSb.append(", ");
            }
            errorSb.append(this.getServerResource("ORDER_FIELD_EXCHANGERATE", ctx));
            isError = true;
        }
        if (!(purOrderInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.TEMPORARILYSAVED) || purOrderInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.SUBMITED) || purOrderInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.ADD))) {
            if (isError) {
                errorSbOther.append(", ");
            }
            errorSbOther.append(this.getServerResource("batchSumbit_checkStatus", ctx));
            isError = true;
            throw new PurOrderException(PurOrderException.BATCH_CHECK_STATUS, new String[]{purOrderInfo.getNumber().toString()});
        }
        if (isError) {
            throw new PurOrderException(PurOrderException.FIELD_CANNOT_EMPTY3, new String[]{purOrderInfo.getNumber().toString(), errorSb.toString()});
        }
        this.checkEntriesValidforSubmit(purOrderInfo, purOrderInfo.getEntries(), ctx);
    }

    private void checkEntriesValidforSubmit(PurOrderInfo purOrderInfo, PurOrderEntryCollection entries, Context ctx) throws EASBizException, BOSException {
        StringBuffer errorSb = new StringBuffer();
        StringBuffer errorSbOther = new StringBuffer();
        boolean isError = false;
        boolean isVerify = false;
        IApprovedSupplier iApprovedSupplier = ApprovedSupplierFactory.getLocalInstance((Context)ctx);
        ISupplyInfo iSupplier = SupplyInfoFactory.getLocalInstance((Context)ctx);
        SupplyInfoInfo supplyInfo = null;
        IRowType iRowType = RowTypeFactory.getLocalInstance((Context)ctx);
        RowTypeInfo rowTypeInfo = null;
        PurchaseOrgUnitInfo purOrg = null;
        SupplierInfo supplierInfo = null;
        purOrg = purOrderInfo.getPurchaseOrgUnit();
        supplierInfo = purOrderInfo.getSupplier();
        isVerify = this.isCheckSupplier(ctx, purOrg.getId().toString());
        int nrow = entries.size();
        if (nrow <= 0) {
            throw new PurOrderException(PurOrderException.ENTRY_CANNOT_EMPTY);
        }
        PurOrderEntryInfo purOrderEntryInfo = null;
        for (int row = 0; row < nrow; ++row) {
            BizTypeInfo bizTypeInfo;
            purOrderEntryInfo = entries.get(row);
            boolean isPresent = purOrderEntryInfo.isIsPresent();
            if (purOrderEntryInfo.getRowType() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_MATERIAL", ctx));
                isError = true;
                throw new PurOrderException(PurOrderException.BATCHSUMBIT_CHECK_ROWTYPE, new String[]{purOrderInfo.getNumber().toString(), String.valueOf(row + 1)});
            }
            rowTypeInfo = iRowType.getRowTypeInfo((IObjectPK)new ObjectUuidPK(purOrderEntryInfo.getRowType().getId()));
            if (purOrderEntryInfo.getRowType() != null && !rowTypeInfo.isIsHasMaterialNumber() && purOrderEntryInfo.getMaterialName() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("batchSumbit_checkMaterialName", ctx));
                isError = true;
            }
            if (purOrderEntryInfo.getRowType() != null && !rowTypeInfo.isIsHasMaterialNumber() && purOrderEntryInfo.getAdminOrgUnit() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_ADMINORGUNIT", ctx));
                isError = true;
            }
            if (purOrderEntryInfo.getRowType() != null && rowTypeInfo.isIsHasMaterialNumber() && purOrderEntryInfo.getRequestOrgUnit() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("batchSumbit_checkReqOrg", ctx));
                isError = true;
            }
            if (purOrderEntryInfo.getRowType() != null && rowTypeInfo.isIsHasMaterialNumber() && purOrderEntryInfo.getMaterial() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_MATERIAL", ctx));
                isError = true;
            }
            if ("d8e80652-0108-1000-e000-04c5c0a812202407435C".equalsIgnoreCase(purOrderInfo.getBizType().getId().toString()) && purOrderEntryInfo.getAssetNumber() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_ASSETNUM", ctx));
                isError = true;
            }
            if (!isPresent && purOrderEntryInfo.getAmount() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_AMOUNT", ctx));
                isError = true;
            }
            if (purOrderEntryInfo.getUnit() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_UNIT", ctx));
                isError = true;
            }
            if (purOrderEntryInfo.getQty() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_QUANTITY", ctx));
                isError = true;
            }
            if ((bizTypeInfo = purOrderInfo.getBizType()) != null && ("d8e80652-0108-1000-e000-04c5c0a812202407435C".equalsIgnoreCase(bizTypeInfo.getId().toString()) || "d8e80652-010c-1000-e000-04c5c0a812202407435C".equalsIgnoreCase(bizTypeInfo.getId().toString()) || "d8e80652-010a-1000-e000-04c5c0a812202407435C".equalsIgnoreCase(bizTypeInfo.getId().toString()))) {
                if (purOrderEntryInfo.getAdminOrgUnit() == null) {
                    if (isError) {
                        errorSb.append(", ");
                    }
                    errorSb.append(this.getServerResource("ORDER_FIELD_ADMINORGUNIT", ctx));
                    isError = true;
                }
            } else if (bizTypeInfo != null && ("d8e80652-0106-1000-e000-04c5c0a812202407435C".equalsIgnoreCase(bizTypeInfo.getId().toString()) || "d8e80652-010b-1001-e000-04c5c0a812202407435C".equalsIgnoreCase(bizTypeInfo.getId().toString())) && purOrderEntryInfo.getStorageOrgUnit() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_STORAGEORGUNIT_R", ctx));
                isError = true;
            }
            if (!isPresent && purOrderEntryInfo.getTaxPrice() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_TAXPRICE", ctx));
                isError = true;
            }
            if (!isPresent && purOrderEntryInfo.getPrice() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_PRICE", ctx));
                isError = true;
            }
            if (purOrderEntryInfo.getDeliveryDate() == null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_DELIVERYDATE", ctx));
                isError = true;
            }
            if (purOrderEntryInfo.getAssistQty() == null && purOrderEntryInfo.getAssistUnit() != null) {
                if (isError) {
                    errorSb.append(", ");
                }
                errorSb.append(this.getServerResource("ORDER_FIELD_ASSISTQUANTITY", ctx));
                isError = true;
            }
            if (isVerify && purOrderEntryInfo.getMaterial() != null) {
                if (iApprovedSupplier.checkHasApprovedSupplier(purOrg.getId().toString(), purOrderEntryInfo.getMaterial().getId().toString(), null, supplierInfo.getId().toString())) {
                    supplyInfo = iSupplier.getSupplyInfoValueWithoutDate((IObjectPK)new ObjectUuidPK(purOrderEntryInfo.getMaterial().getId()), (IObjectPK)new ObjectUuidPK(purOrg.getId()), (IObjectPK)new ObjectUuidPK(supplierInfo.getId()));
                    if (supplyInfo == null) {
                        if (isError) {
                            errorSbOther.append(", ");
                        }
                        errorSbOther.append(this.getServerResource("ORDERENTRY_SUPPLIERMUSTADDSUPPLYINFO", ctx));
                        isError = true;
                        throw new PurOrderException(PurOrderException.BATCHSUMBIT_CHECK_ASINFO, new String[]{purOrderInfo.getNumber().toString(), String.valueOf(row + 1)});
                    }
                } else {
                    throw new PurOrderException(PurOrderException.BATCHSUMBIT_CHECK_ASINFO, new String[]{purOrderInfo.getNumber().toString(), String.valueOf(row + 1)});
                }
            }
            if (!isError) continue;
            throw new PurOrderException(PurOrderException.FIELD_CANNOT_EMPTY2, new String[]{purOrderInfo.getNumber().toString(), String.valueOf(row + 1), errorSb.toString()});
        }
    }

    private boolean isCheckSupplier(Context ctx, String orgUnitID) {
        boolean isParamValue = false;
        try {
            String paramValue;
            IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK orgUnitPK = null;
            if (orgUnitID != null) {
                orgUnitPK = new ObjectUuidPK(orgUnitID);
            }
            if ((paramValue = paramControl.getParamValue(orgUnitPK, "PURSUP001")) != null) {
                isParamValue = "true".equalsIgnoreCase(paramValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isParamValue;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)key, (Context)ctx);
    }
}

