/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.vrule.app.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.IApprovedSupplier;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.util.client.EASResource;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CheckMaterialInApprovedSupplierVRule
implements IVRule {
    Context ctx = null;

    public CheckMaterialInApprovedSupplierVRule(Context ctx) {
        this.ctx = ctx;
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurOrderInfo.class.isAssignableFrom(clazz);
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        if (null != bean) {
            String paramValue;
            PurOrderInfo purOrderInfo = (PurOrderInfo)bean;
            PurOrderEntryCollection entries = purOrderInfo.getEntries();
            boolean isUsePurSup = false;
            if (purOrderInfo.getPurchaseOrgUnit() != null && (paramValue = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamValue((IObjectPK)new ObjectUuidPK(purOrderInfo.getPurchaseOrgUnit().getId().toString()), "PURSUP001")) != null) {
                isUsePurSup = "true".equalsIgnoreCase(paramValue);
            }
            Map<String, MaterialPurchasingInfo> matPurchaseMap = this.getMaterialPurchaseCollec((IObjectValue)purOrderInfo);
            if (entries != null) {
                PurOrderEntryInfo entry = null;
                int size = entries.size();
                for (int i = 0; i < size; ++i) {
                    entry = entries.get(i);
                    this.checkIsInApprovedSupplier(purOrderInfo, entry, isUsePurSup, matPurchaseMap, i);
                }
            }
        }
    }

    private void checkIsInApprovedSupplier(PurOrderInfo purOrderInfo, PurOrderEntryInfo entry, boolean isUsePurSup, Map matPurchaseMap, int row) throws BOSException, EASBizException {
        if (entry != null && entry.getRowType() != null && entry.getRowType().isIsHasMaterialNumber()) {
            boolean isInApprovedSupplier = false;
            String key = entry.getMaterial().getId().toString() + purOrderInfo.getPurchaseOrgUnit().getId().toString();
            MaterialPurchasingInfo materialPurchaseInfo = (MaterialPurchasingInfo)matPurchaseMap.get(key);
            if (isUsePurSup && materialPurchaseInfo.isUseSupplyList() || purOrderInfo.isIsApprovedMaterial()) {
                IApprovedSupplier iApprovedSupplier = ApprovedSupplierFactory.getLocalInstance((Context)this.ctx);
                FilterInfo tempfilter = new FilterInfo();
                tempfilter.getFilterItems().add(new FilterItemInfo("purchaseOrg.id", (Object)purOrderInfo.getPurchaseOrgUnit().getId().toString(), CompareType.EQUALS));
                tempfilter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)purOrderInfo.getSupplier().getId().toString(), CompareType.EQUALS));
                tempfilter.getFilterItems().add(new FilterItemInfo("materialItem.id", (Object)entry.getMaterial().getId().toString(), CompareType.EQUALS));
                tempfilter.getFilterItems().add(new FilterItemInfo("isUseable", (Object)"1", CompareType.EQUALS));
                if (purOrderInfo.getBizType().getId().toString().equals("LAdiD6Y5Sim6q6bmixITqSQHQ1w=")) {
                    tempfilter.getFilterItems().add(new FilterItemInfo("isVMI", (Object)"1", CompareType.EQUALS));
                }
                if (!(isInApprovedSupplier = iApprovedSupplier.exists(tempfilter))) {
                    String msg = EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"ENTRY_STRING") + "," + EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"APPROVE_SUPPLIER_NO_MATERIAL");
                    throw new PurOrderException(PurOrderException.THRROW, new String[]{String.valueOf(row + 1), msg});
                }
            }
        }
    }

    private Map<String, MaterialPurchasingInfo> getMaterialPurchaseCollec(IObjectValue bean) throws BOSException, EASBizException {
        HashMap<String, MaterialPurchasingInfo> matPurchase = new HashMap<String, MaterialPurchasingInfo>();
        if (bean == null) {
            return matPurchase;
        }
        PurOrderInfo info = (PurOrderInfo)bean;
        if (info.getPurchaseOrgUnit() == null) {
            return matPurchase;
        }
        PurOrderEntryCollection entries = info.getEntries();
        PurOrderEntryInfo entry = null;
        MaterialInfo material = null;
        MaterialPurchasingInfo matPurchaseInfo = null;
        RowTypeInfo rowTypeInfo = null;
        HashSet<String> materialSet = new HashSet<String>();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.get(i);
            rowTypeInfo = entry.getRowType();
            if (rowTypeInfo == null || !rowTypeInfo.isIsHasMaterialNumber() || (material = entry.getMaterial()) == null) continue;
            materialSet.add(material.getId().toString());
        }
        IMaterialPurchasing iMaterialPurchase = MaterialPurchasingFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)info.getPurchaseOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("isSequenceNo");
        selector.add("material.id");
        selector.add("orgUnit.id");
        selector.add("useSupplyList");
        entityViewInfo.setSelector(selector);
        MaterialPurchasingCollection col = iMaterialPurchase.getMaterialPurchasingCollection(entityViewInfo);
        for (int i = 0; i < col.size(); ++i) {
            matPurchaseInfo = col.get(i);
            String key = matPurchaseInfo.getMaterial().getId().toString() + matPurchaseInfo.getOrgUnit().getId().toString();
            matPurchase.put(key, matPurchaseInfo);
        }
        return matPurchase;
    }
}

