/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.vrule.app.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.scm.common.RequestOrgTypeEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.util.string.StringUtil;

public class CheckRowType4SubmitVRule
implements IVRule {
    Context ctx;

    public CheckRowType4SubmitVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurOrderInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        this.checkRowType(bean);
    }

    private void checkRowType(IObjectValue model) throws BOSException, EASBizException {
        PurOrderInfo bill = (PurOrderInfo)model;
        PurOrderEntryCollection col = bill.getEntries();
        PurOrderEntryInfo entry = null;
        RowTypeInfo rowType = null;
        if (col.size() > 0 && ((rowType = (entry = col.get(0)).getRowType()) == null || rowType.getRequestOrgType() == null)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("entries.rowType.*"));
            PurOrderInfo purOrderInfo = PurOrderFactory.getLocalInstance(this.ctx).getPurOrderInfo((IObjectPK)new ObjectUuidPK(bill.getId().toString()), sic);
            PurOrderEntryCollection entries = purOrderInfo.getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                col.get(i).setRowType(entries.get(i).getRowType());
            }
        }
        String bizTypeId = bill.getBizType().getId().toString();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            rowType = entry.getRowType();
            if (rowType == null) continue;
            if (!bizTypeId.equalsIgnoreCase("d8e80652-010b-1001-e000-04c5c0a812202407435C") && null != rowType.getRequestOrgType()) {
                if (rowType.getRequestOrgType().equals((Object)RequestOrgTypeEnum.STORAGEORGUNIT) && entry.getRequestOrgUnit() == null) {
                    throw new PurOrderException(PurOrderException.REQUESTORG_ISNULL, new Object[]{i + 1});
                }
                if (rowType.getRequestOrgType().equals((Object)RequestOrgTypeEnum.STORAGEORGUNIT) && entry.getStorageOrgUnit() == null) {
                    throw new PurOrderException(PurOrderException.STORAGEORG_ISNULL, new Object[]{i + 1});
                }
                if (rowType.getRequestOrgType().equals((Object)RequestOrgTypeEnum.ADMINORGUNIT) && entry.getAdminOrgUnit() == null) {
                    throw new PurOrderException(PurOrderException.ADMINORGUNIT_ISNULL, new Object[]{i + 1});
                }
                if (rowType.getRequestOrgType().equals((Object)RequestOrgTypeEnum.ADMINORGUNIT) && entry.getStorageOrgUnit() == null) {
                    throw new PurOrderException(PurOrderException.STORAGEORG_ISNULL, new Object[]{i + 1});
                }
            }
            if (rowType.isIsHasMaterialNumber() || !StringUtil.isEmpty((String)entry.getMaterialName())) continue;
            throw new PurReqException(PurReqException.MATERIALNAME_ISNULL, new Object[]{i + 1});
        }
    }
}

