/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.vrule.app.purrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.DataTypeEnum;
import com.kingdee.eas.scm.framework.validator.bizrule.app.AbstractServerVRule;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckMaterialPurchaseVRule
extends AbstractServerVRule {
    private static final Logger logger = LoggerFactory.getLogger(CheckMaterialPurchaseVRule.class);

    public CheckMaterialPurchaseVRule() {
        this(null);
    }

    public CheckMaterialPurchaseVRule(Context ctx) {
        super(ctx);
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurRequestInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        PurRequestInfo info = (PurRequestInfo)bean;
        if (info.getCompanyOrgUnit() == null) {
            return;
        }
        PurRequestEntryCollection col = info.getEntries();
        PurchaseOrgUnitInfo pou = null;
        String pouId = "";
        StringBuilder errors = new StringBuilder();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            PurRequestEntryInfo entry = (PurRequestEntryInfo)col.getObject(i);
            MaterialInfo materialInfo = entry.getMaterial();
            pou = entry.getPurchaseOrgUnit();
            if (materialInfo == null || pou == null) continue;
            pouId = pou.getId().toString();
            MaterialPurchasingInfo miInfo = this.getMaterialPurChaseInfo(materialInfo.getId().toString(), pouId);
            if (null != miInfo) continue;
            errors.append(materialInfo.getNumber()).append(",");
        }
        if (errors.length() > 0) {
            errors.setLength(errors.length() - 1);
            throw new PurReqException(PurReqException.MATERIAL_PURCHASING_UNAPPROVE, new Object[]{errors.toString()});
        }
    }

    private MaterialPurchasingInfo getMaterialPurChaseInfo(String materialId, String pouId) throws BOSException {
        assert (!StringUtils.isEmpty((String)pouId));
        assert (StringUtils.isEmpty((String)materialId));
        if (this.getDataCache().contain(materialId + pouId, DataTypeEnum.MATERIAL_PURCHASING)) {
            return (MaterialPurchasingInfo)this.getDataCache().get(materialId + pouId, DataTypeEnum.MATERIAL_PURCHASING);
        }
        if (logger.isWarnEnabled()) {
            logger.warn("\u6027\u80fd\u9690\u60a3\uff1a\u83b7\u53d6\u7269\u6599\u91c7\u8d2d\u9875\u7b7e\u65f6\uff0c\u6ca1\u6709\u547d\u4e2d\u4e1a\u52a1\u94fe\u7684\u6570\u636e\u7f13\u5b58\u3002class-method: com.kingdee.eas.scm.sm.pur.vrule.app.purrequest.CheckMaterialPurchaseVRule.getMaterialPurChaseInfo(String, String)");
        }
        IMaterialPurchasing iMaterialPurchase = MaterialPurchasingFactory.getLocalInstance((Context)this.getCtx());
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", (Object)materialId));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)pouId));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("isSequenceNo");
        entityViewInfo.setSelector(selector);
        MaterialPurchasingCollection col = iMaterialPurchase.getMaterialPurchasingCollection(entityViewInfo);
        MaterialPurchasingInfo info = null;
        if (col != null && col.size() > 0) {
            info = col.get(0);
        }
        this.getDataCache().put(materialId + pouId, (Object)info, DataTypeEnum.MATERIAL_PURCHASING);
        return info;
    }
}

