/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.vrule.app.purrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.ui.face.UIRuleUtil;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.scm.common.RequestOrgTypeEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestFactory;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import com.kingdee.eas.scm.util.string.StringUtil;

public class CheckRowType4SubmitVRule
implements IVRule {
    Context ctx;

    public CheckRowType4SubmitVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurRequestInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        this.checkRowType(bean);
    }

    private void checkRowType(IObjectValue model) throws BOSException, EASBizException {
        PurRequestInfo bill = (PurRequestInfo)model;
        PurRequestEntryCollection col = bill.getEntries();
        PurRequestEntryInfo entry = null;
        RowTypeInfo rowType = null;
        if (col.size() > 0 && ((rowType = (entry = col.get(0)).getRowType()) == null || rowType.getRequestOrgType() == null)) {
            SelectorItemCollection sic = new SelectorItemCollection();
            sic.add(new SelectorItemInfo("entries.rowType.*"));
            PurRequestInfo purRequestInfo = PurRequestFactory.getLocalInstance(this.ctx).getPurRequestInfo((IObjectPK)new ObjectUuidPK(bill.getId().toString()), sic);
            PurRequestEntryCollection entries = purRequestInfo.getEntries();
            for (int i = 0; i < entries.size(); ++i) {
                col.get(i).setRowType(entries.get(i).getRowType());
            }
        }
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            entry = col.get(i);
            rowType = entry.getRowType();
            if (rowType == null) continue;
            if (rowType.getRequestOrgType().equals((Object)RequestOrgTypeEnum.STORAGEORGUNIT) && entry.getStorageOrgUnit() == null) {
                throw new PurReqException(PurReqException.STORAGEORGUNIT_ISNULL, new Object[]{i + 1});
            }
            if (rowType.getRequestOrgType().equals((Object)RequestOrgTypeEnum.ADMINORGUNIT) && entry.getAdminOrgUnit() == null) {
                throw new PurReqException(PurOrderException.ADMINORGUNIT_ISNULL, new Object[]{i + 1});
            }
            if (rowType.isIsHasMaterialNumber()) {
                MaterialGroupInfo materialGroup = entry.getMaterialGroup1();
                MaterialInfo material = entry.getMaterial();
                if (!UIRuleUtil.isNull((Object)materialGroup) || !UIRuleUtil.isNull((Object)material)) continue;
                throw new PurReqException(PurReqException.MATERIALORGROUP_ISNULL, new Object[]{i + 1});
            }
            if (!StringUtil.isEmpty((String)entry.getMaterialName())) continue;
            throw new PurReqException(PurReqException.MATERIALNAME_ISNULL, new Object[]{i + 1});
        }
    }
}

