/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.vrule.app.purrequest;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sm.pur.PurReqException;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurRequestEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurRequestInfo;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class CheckValidData4SubmitVRule
implements IVRule {
    Context ctx = null;

    public CheckValidData4SubmitVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return PurRequestInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        this.checkValidData(bean);
    }

    private void checkValidData(IObjectValue model) throws BOSException, EASBizException {
        PurRequestInfo info = (PurRequestInfo)model;
        if (info.getBaseStatus().getValue() == 7) {
            throw new PurReqException(PurReqException.UPDATE_IS_CLOSED);
        }
        ObjectUuidPK pk = null;
        pk = new ObjectUuidPK(info.getId());
        this.checkUpdate(this.ctx, (IObjectPK)pk, model);
        if (null != info.getEntries() && info.getEntries().size() > 0) {
            IParamControl paramValue = ParamControlFactory.getLocalInstance((Context)this.ctx);
            StringBuffer error = new StringBuffer();
            HashMap<String, Boolean> map = new HashMap<String, Boolean>();
            for (int i = 0; i < info.getEntries().size(); ++i) {
                PurRequestEntryInfo entry = info.getEntries().get(i);
                if (entry.getPurchaseOrgUnit() == null) continue;
                String purOrgId = entry.getPurchaseOrgUnit().getId().toString();
                boolean flag = false;
                if (map.containsKey(purOrgId)) {
                    flag = (Boolean)map.get(purOrgId);
                } else {
                    String paramItem = paramValue.getParamValue((IObjectPK)new ObjectUuidPK(purOrgId), "PURORDER100");
                    flag = Boolean.parseBoolean(paramItem);
                    map.put(purOrgId, flag);
                }
                if (!flag && null == entry.getMaterialGroup1() && entry.getRowType().isIsHasMaterialNumber() && entry.getMaterial().getAssistAttr() != null && entry.getAssistProperty() == null) {
                    if (error.toString().equals("")) {
                        error.append(i + 1);
                    } else {
                        error.append(",").append(i + 1);
                    }
                }
                if (entry.getRequirementDate() == null) {
                    throw new PurReqException(PurReqException.REQDATENOTNULL, new Object[]{entry.getSeq()});
                }
                if (entry.getProposeDeliveryDate() != null) continue;
                throw new PurReqException(PurReqException.PRODELIDATENOTNULL, new Object[]{entry.getSeq()});
            }
            if (error != null && !error.toString().equals("")) {
                throw new PurReqException(PurReqException.ENTRY_ASSIST_NOTNULL, new String[]{error.toString()});
            }
        }
        this.checkProjectTrackIsNotNull(this.ctx, model);
    }

    private void checkUpdate(Context ctx, IObjectPK pk, IObjectValue model) throws BOSException, EASBizException {
        PurRequestInfo info = (PurRequestInfo)model;
        if (info.getBaseStatus() != null) {
            if (info.getBaseStatus().getValue() == 4) {
                throw new PurReqException(PurReqException.UPDATE_IS_AUDIT);
            }
            if (info.getBaseStatus().getValue() == 3) {
                throw new PurReqException(PurReqException.CANCEL_IS_SUBMIT);
            }
        }
    }

    private void checkProjectTrackIsNotNull(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurRequestInfo info = null;
        PurRequestEntryCollection entries = null;
        PurRequestEntryInfo entry = null;
        MaterialPlanInfo mpInfo = null;
        Map materialPlanMap = this.batchFetchMatPlanCol(ctx, model);
        info = (PurRequestInfo)model;
        boolean isBotp = false;
        if (info != null && info.getSourceBillType() != null) {
            isBotp = true;
        }
        entries = info.getEntries();
        entry = null;
        if (entries != null) {
            int count = entries.size();
            for (int j = 0; j < count; ++j) {
                entry = entries.get(j);
                if (entry == null || entry.getReceivedOrgUnit() == null || entry.getReceivedOrgUnit().getId() == null || entry.getMaterial() == null || entry.getMaterial().getId() == null || (mpInfo = (MaterialPlanInfo)materialPlanMap.get(entry.getMaterial().getId().toString() + entry.getReceivedOrgUnit().getId().toString())) == null) continue;
                InvServerUtils.checkProjectTrackIsNotNull((Context)ctx, (boolean)isBotp, (int)(j + 1), (MaterialPlanInfo)mpInfo, (ProjectInfo)entry.getProject(), (TrackNumberInfo)entry.getTrackNo());
            }
        }
    }

    private Map batchFetchMatPlanCol(Context ctx, IObjectValue model) throws BOSException {
        PurRequestInfo info = null;
        PurRequestEntryCollection entries = null;
        PurRequestEntryInfo entry = null;
        Map materialPlanMap = new HashMap();
        HashSet<String> storageIDs = new HashSet<String>();
        HashSet<String> materialIDs = new HashSet<String>();
        info = (PurRequestInfo)model;
        entries = info.getEntries();
        entry = null;
        if (entries != null) {
            int count = entries.size();
            for (int j = 0; j < count; ++j) {
                entry = entries.get(j);
                if (entry != null && entry.getMaterial() != null && entry.getMaterial().getId() != null) {
                    materialIDs.add(entry.getMaterial().getId().toString());
                }
                if (entry == null || entry.getReceivedOrgUnit() == null || entry.getReceivedOrgUnit().getId() == null) continue;
                storageIDs.add(entry.getReceivedOrgUnit().getId().toString());
            }
        }
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("manufactureStrategy"));
        sic.add(new SelectorItemInfo("isolatedRule"));
        sic.add(new SelectorItemInfo("status"));
        sic.add(new SelectorItemInfo("isolatedRule"));
        materialPlanMap = SCMServerUtils.getMaterialPlanCollec((Context)ctx, materialIDs, storageIDs, (SelectorItemCollection)sic);
        return materialPlanMap;
    }
}

