/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.pur.vrule.app.suborder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sm.sc.SubContractOrderException;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;

public class CheckQtyVRule
implements IVRule {
    Context ctx = null;

    public CheckQtyVRule(Context ctx) {
        this.ctx = ctx;
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SubContractOrderInfo.class.isAssignableFrom(clazz);
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        SubContractOrderInfo subContractOrderInfo;
        assert (bean != null);
        if (null != bean && null != (subContractOrderInfo = (SubContractOrderInfo)bean).getBaseStatus() && !subContractOrderInfo.getBaseStatus().equals((Object)BillBaseStatusEnum.ALTERING)) {
            CheckQtyVRule.CheckControlQty(this.ctx, subContractOrderInfo.getId().toString(), "T_SM_SubContractOrderEntry");
        }
    }

    public static void CheckControlQty(Context ctx, String infoID, String table) throws SubContractOrderException, BOSException {
        BigDecimal zero;
        BigDecimal diffBaseQty = zero = new BigDecimal("0.0");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        StringBuffer errorStr = new StringBuffer();
        Object[] errorArr = new String[1];
        try {
            conn = EJBFactory.getConnection((Context)ctx);
            sqlBuff.append(" SELECT PR.FUnorderedBaseQty, case when MMU.FMaterialID is null then ");
            sqlBuff.append("decimal(PO.FBaseQty - PR.FUnorderedBaseQty,17,2) else ");
            sqlBuff.append("decimal((PO.FBaseQty - PR.FUnorderedBaseQty)/MMU.FBaseConvsRate,17,8) end as FoverQty, PO.FSeq, ");
            sqlBuff.append(" PO.FSourceBillEntryID, ma.FName_L2 as FMaterialName, MMU.FMeasureUnitID,");
            sqlBuff.append(" MMU.FMaterialID, MMU.FBaseConvsRate, MMU.FQtyPrecision, MM.FName_L2 as FUnitName from ").append(table).append(" PO ");
            sqlBuff.append(" inner join T_SM_PURREQUESTENTRY PR on (PR.FID = PO.FSourceBillEntryID and PO.FBaseQty > PR.FUnorderedBaseQty) ");
            sqlBuff.append(" left join T_BD_MULTIMEASUREUNIT MMU on (PO.FUnitID=MMU.FMeasureUnitID and PR.FMaterialID = MMU.FMaterialID)");
            sqlBuff.append(" left join T_BD_material ma on ma.FID = PO.FmaterialID");
            sqlBuff.append(" left join T_BD_MeasureUnit MM on MM.FID = PO.FUnitID");
            sqlBuff.append(" where PR.FIsQuantityUnCtrl = 0 and PO.FSOURCEBILLTYPEID = '").append("510b6503-0105-1000-e000-0107c0a812fd463ED552");
            sqlBuff.append("' and PO.FParentId = '").append(infoID).append("'").append(" order by PO.FSeq");
            stmt = conn.prepareStatement(sqlBuff.toString());
            rs = stmt.executeQuery();
            String errorMsg = SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"QtyCheckError", (Context)ctx);
            while (rs.next()) {
                errorStr.append("\n");
                errorStr.append(MessageFormat.format(errorMsg, rs.getString("FSeq"), rs.getString("FMaterialName"), rs.getBigDecimal("FoverQty").toString(), rs.getString("FUnitName")));
            }
            if (!errorStr.toString().equals("")) {
                errorArr[0] = errorStr.toString();
                throw new SubContractOrderException(SubContractOrderException.SUBCONTRACTORDER_QTY_NOMATHCH, errorArr);
            }
        }
        catch (SQLException ex) {
            try {
                throw new BOSException((Throwable)ex);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(rs, stmt, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
    }
}

