/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.report.app.AbstractFMaterialABCFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class FMaterialABCFacadeControllerBean
extends AbstractFMaterialABCFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.report.app.FMaterialABCFacadeControllerBean");
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";
    private String purChaseUnitTempTableStr = "PurChaseUnitTempTable";
    private String leafPurChaseOrgUnitStr = "leafPurChaseOrgUnit";
    private String maxLevelStr = "maxLevelStr";

    protected RptParams _init(Context ctx, RptParams params) throws BOSException, EASBizException {
        RptParams pp = new RptParams();
        pp.setObject("title", (Object)new Timestamp(System.currentTimeMillis()));
        return pp;
    }

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        String isContainSysBill;
        String precision = params.getString("currPrecision");
        this.dropTable(params.getString("tempTable"), ctx);
        this.dropTempTable(params.getString("PurChaseUnitTempTable"), ctx);
        String purChaseUnitTempTable = this.getTempTableName(this.getServerResource("PurchaseORGUintTempTable", ctx), ctx);
        params.setString("PurChaseUnitTempTable", purChaseUnitTempTable);
        String tempTable = this.getTempTableName(this.getHeaderResource("ReportName", ctx), ctx);
        params.setString("tempTable", tempTable);
        params.getString("tempTable");
        this.buildStorageOrgTable(ctx, purChaseUnitTempTable, params);
        StringBuffer sqlField = new StringBuffer();
        StringBuffer sqlOrder = new StringBuffer();
        StringBuffer sqlCondition = new StringBuffer();
        StringBuffer sqlSon = new StringBuffer();
        StringBuffer sqlAll = new StringBuffer();
        if (params.getObject("dateBegin") != null) {
            sqlCondition.append(" PURORDER.FBizDate >= to_date(?) and ");
        }
        if (params.getObject("dateEnd") != null) {
            sqlCondition.append(" PURORDER.FBizDate <= to_date(?) and ");
        }
        if (params.getObject("materialNumBegin") != null) {
            String[] numberArray = SCMUtil.getF7Numbers((Object)params.getObject("materialNumBegin"));
            if (numberArray[1] != null) {
                sqlCondition.append(" Material.FNumber in (" + numberArray[1] + ") and ");
            } else if (numberArray[0] != null) {
                sqlCondition.append(" Material.FNumber >= '" + numberArray[0] + "' and ");
            }
        }
        if (params.getString("materialNumEnd") != null && params.getString("materialNumEnd").trim().length() > 0) {
            sqlCondition.append(" Material.FNumber <= ? and ");
        }
        if (params.getString("materialBaseClassBegin") != null && params.getString("materialBaseClassBegin").trim().length() > 0) {
            sqlCondition.append(" MATERIALTYPE.FNumber >= ? and ");
        }
        if (params.getString("materialBaseClassEnd") != null && params.getString("materialBaseClassEnd").trim().length() > 0) {
            sqlCondition.append(" MATERIALTYPE.FNumber <= ? and ");
        }
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String shortNameFrom = (String)params.getObject("shortNameFrom");
        String shortNameTo = (String)params.getObject("shortNameTo");
        if (ckBxShowMShortName) {
            if (shortNameFrom != null && shortNameFrom.trim().length() > 0) {
                if (shortNameFrom.indexOf("'") != -1) {
                    shortNameFrom = shortNameFrom.replaceAll("'", "''");
                }
                sqlCondition.append(" Material.FShortName >= ? and ");
            }
            if (shortNameTo != null && shortNameTo.trim().length() > 0) {
                if (shortNameTo.indexOf("'") != -1) {
                    shortNameTo = shortNameTo.replaceAll("'", "''");
                }
                sqlCondition.append(" Material.FShortName <= ? and ");
            }
        }
        if (params.getString("storageUnitBegin") != null && params.getString("storageUnitBegin").trim().length() > 0) {
            sqlCondition.append(" StorageOrgUnit.FNumber >= ? and ");
        }
        if (params.getString("storageUnitEnd") != null && params.getString("storageUnitEnd").trim().length() > 0) {
            sqlCondition.append(" StorageOrgUnit.FNumber <= ? and ");
        }
        if (!"-1".equals(params.getString("combStatus"))) {
            sqlCondition.append(" PurOrder.FBaseStatus = ? ");
        } else if (sqlCondition.length() > 0) {
            int delInfo = sqlCondition.lastIndexOf("and");
            sqlCondition.delete(delInfo, delInfo + 3);
        }
        if (sqlCondition.length() > 0) {
            sqlCondition.append(" and PurOrder.FBaseStatus<>-3 ");
        }
        if (params.getObject("ckBxIsContainSysBill") != null && (isContainSysBill = params.getObject("ckBxIsContainSysBill").toString()) != null && "false".equals(isContainSysBill.trim().toString()) && sqlCondition.length() > 0) {
            sqlCondition.append(" and PURORDER.FIsSysBill=0");
        }
        sqlSon.append("SELECT sum(TO_DECIMAL(ENTRIES.FTaxAmount*PURORDER.FExchangeRate,17,").append(precision).append(")) AS ALLTOTALTAXAMOUNT");
        sqlSon.append(" FROM T_SM_PurOrder   PURORDER");
        sqlSon.append(" INNER JOIN T_SM_PurOrderEntry ENTRIES ON ENTRIES.FParentID=PURORDER.FID");
        sqlSon.append("\r\n INNER JOIN ");
        sqlSon.append(params.getString("PurChaseUnitTempTable"));
        sqlSon.append(" ORG").append(" ON PURORDER.FPurchaseOrgUnitID = ORG.FID");
        sqlSon.append("  Inner JOIN T_BD_Material  Material ON ENTRIES.FMaterialID = Material.FID");
        if (params.getString("storageUnitBegin") != null && params.getString("storageUnitBegin").trim().length() > 0 || params.getString("storageUnitEnd") != null && params.getString("storageUnitEnd").trim().length() > 0) {
            sqlSon.append(" INNER JOIN T_ORG_Storage  STORAGEORGUNIT ON ENTRIES.FStorageOrgUnitID = StorageOrgUnit.FID");
        }
        sqlSon.append(" INNER JOIN T_BD_MaterialGroup AS MATERIALTYPE on Material.FMATERIALGROUPID = MATERIALTYPE.FID ");
        sqlSon.append(" where ");
        sqlSon.append(sqlCondition);
        BigDecimal total = new BigDecimal("0");
        ArrayList<Object> paramList = new ArrayList<Object>();
        if (params.getObject("dateBegin") != null) {
            paramList.add(params.getString("dateBegin").toString().substring(0, 10));
        }
        if (params.getObject("dateEnd") != null) {
            paramList.add(params.getString("dateEnd").toString().substring(0, 10));
        }
        if (params.getString("materialNumEnd") != null && params.getString("materialNumEnd").trim().length() > 0) {
            paramList.add(params.getString("materialNumEnd"));
        }
        if (params.getString("materialBaseClassBegin") != null && params.getString("materialBaseClassBegin").trim().length() > 0) {
            paramList.add(params.getString("materialBaseClassBegin"));
        }
        if (params.getString("materialBaseClassEnd") != null && params.getString("materialBaseClassEnd").trim().length() > 0) {
            paramList.add(params.getString("materialBaseClassEnd"));
        }
        if (ckBxShowMShortName) {
            if (shortNameFrom != null && shortNameFrom.trim().length() > 0) {
                paramList.add(shortNameFrom.trim());
            }
            if (shortNameTo != null && shortNameTo.trim().length() > 0) {
                paramList.add(shortNameTo.trim());
            }
        }
        if (params.getString("storageUnitBegin") != null && params.getString("storageUnitBegin").trim().length() > 0) {
            paramList.add(params.getString("storageUnitBegin"));
        }
        if (params.getString("storageUnitEnd") != null && params.getString("storageUnitEnd").trim().length() > 0) {
            paramList.add(params.getString("storageUnitEnd"));
        }
        if (!"-1".equals(params.getString("combStatus"))) {
            paramList.add(new Integer(params.getString("combStatus")));
        }
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlSon.toString(), (Object[])paramList.toArray());
        try {
            if (rs.next() && (total = rs.getBigDecimal(1)) != null) {
                total = total.setScale(4, 4);
            }
        }
        catch (SQLException e1) {
            throw new BOSException((Throwable)e1);
        }
        sqlField.append(" SELECT  MATERIAL.FNumber AS FNumber,MATERIAL.FName_").append(ctx.getLocale().getLanguage()).append(" AS FName,MATERIALTYPE.FNAME_").append(ctx.getLocale().getLanguage()).append(" AS MaterialBaseClass,");
        sqlField.append(" sum(TO_DECIMAL(ENTRIES.FTaxAmount*PURORDER.FExchangeRate,17,").append(2).append(")) AS FTotalTaxAmount,");
        sqlField.append(" round(TO_DECIMAL(sum(TO_DECIMAL(ENTRIES.FTaxAmount*PURORDER.FExchangeRate,17,").append(precision).append(")),17,4)/");
        if (total == null || total.compareTo(new BigDecimal("0")) == 0) {
            sqlField.append("1.0 ,4)as FPercentMaterial");
        } else {
            sqlField.append(total.toString()).append(" ,4)as FPercentMaterial");
        }
        sqlField.append(" FROM T_SM_PurOrder  PURORDER");
        sqlField.append(" INNER JOIN T_SM_PurOrderEntry ENTRIES ON ENTRIES.FParentID=PURORDER.FID");
        sqlField.append(" INNER JOIN ").append(params.getString("PurChaseUnitTempTable")).append(" PURCHASEORGUNIT ON PURORDER.FPurchaseOrgUnitID = PURCHASEORGUNIT.FID");
        sqlField.append(" Inner JOIN T_BD_Material   Material ON ENTRIES.FMaterialID = Material.FID");
        if (params.getString("storageUnitBegin") != null && params.getString("storageUnitBegin").trim().length() > 0 || params.getString("storageUnitEnd") != null && params.getString("storageUnitEnd").trim().length() > 0) {
            sqlField.append(" INNER JOIN T_ORG_Storage   STORAGEORGUNIT ON ENTRIES.FStorageOrgUnitID = StorageOrgUnit.FID ");
        }
        sqlField.append(" INNER JOIN T_BD_MaterialGroup AS MATERIALTYPE on Material.FMATERIALGROUPID = MATERIALTYPE.FID ");
        sqlField.append(" where ");
        sqlField.append(sqlCondition);
        sqlOrder.append(" GROUP BY  FMaterialID,MATERIAL.FNumber ,MATERIAL.FName_").append(ctx.getLocale().getLanguage()).append(" ,MATERIALTYPE.FNAME_").append(ctx.getLocale().getLanguage());
        sqlOrder.append(" HAVING sum(TO_DECIMAL(ENTRIES.FTaxAmount*PURORDER.FExchangeRate,17,2)) >0");
        sqlAll.append(sqlField);
        sqlAll.append(sqlOrder);
        String sqlQuey = sqlAll.toString();
        SqlParams sqlTest = new SqlParams();
        try {
            sqlTest.setParams(paramList.toArray());
            sqlTest.sql((Object)sqlQuey);
        }
        catch (SQLException e) {
            logger.error((Object)e);
        }
        StringBuffer tempSql = new StringBuffer();
        tempSql.append("create table ").append(tempTable).append("\n");
        tempSql.append("(FNUMBER varchar(255),");
        tempSql.append("FNAME nvarchar(255),");
        tempSql.append("MATERIALBASECLASS nvarchar(255),");
        tempSql.append("FTOTALTAXAMOUNT NUMERIC(19,4),");
        tempSql.append("FPERCENTMATERIAL NUMERIC(19,4))");
        this.executeSQL(ctx, tempSql.toString());
        tempSql.setLength(0);
        tempSql.append("insert into ").append(tempTable).append("(FNUMBER,FNAME,MATERIALBASECLASS,FTOTALTAXAMOUNT,FPERCENTMATERIAL) \n");
        DbUtil.execute((Context)ctx, (String)tempSql.append(sqlQuey).toString(), (Object[])paramList.toArray());
        String dsql = "select FNumber, FPercentMaterial from " + tempTable + " where FPercentMaterial > 0 order by FPercentMaterial DESC";
        IRowSet drs = DbUtil.executeQuery((Context)ctx, (String)dsql);
        BigDecimal sum = BigDecimal.valueOf(0.0);
        BigDecimal one = BigDecimal.valueOf(1.0);
        String fNumber = "";
        try {
            while (drs.next()) {
                BigDecimal percent = drs.getBigDecimal("FPercentMaterial");
                if ((sum = sum.add(percent)).compareTo(one) <= 0) continue;
                sum = sum.subtract(one);
                percent = percent.subtract(sum);
                fNumber = drs.getString("fNumber");
                dsql = "update " + tempTable + " set fPercentMaterial = ? where fNumber = ?";
                DbUtil.execute((Context)ctx, (String)dsql, (Object[])new Object[]{percent, fNumber});
                break;
            }
        }
        catch (SQLException ex) {
            throw new BOSException((Throwable)ex);
        }
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rsc = this.executeQuery(countSql, null, ctx);
        rsc.next();
        int count = rsc.getInt(0);
        RptTableHeader header = new RptTableHeader();
        RptTableColumn col = null;
        col = new RptTableColumn("FNumber");
        col.setWidth(200);
        header.addColumn(col);
        col = new RptTableColumn("FName");
        col.setWidth(200);
        header.addColumn(col);
        col = new RptTableColumn("MaterialBaseClass");
        col.setWidth(200);
        header.addColumn(col);
        if (ckBxShowMShortName) {
            col = new RptTableColumn("FShortName");
            col.setWidth(200);
            header.addColumn(col);
        }
        col = new RptTableColumn("FTotalTaxAmount");
        col.setWidth(200);
        col.setAligment(2);
        col.setFormatPattern(RptCellFormatter.getNumberFormat((int)2, (boolean)true));
        header.addColumn(col);
        col = new RptTableColumn("FPercentMaterial");
        col.setWidth(190);
        col.setAligment(2);
        col.setFormatPattern(RptCellFormatter.getNumberFormat((int)4, (boolean)true));
        header.addColumn(col);
        col = new RptTableColumn("FABC");
        col.setWidth(190);
        col.setAligment(2);
        col.setFormatPattern("@=?C:$_");
        header.addColumn(col);
        if (ckBxShowMShortName) {
            header.setLabels((Object[][])new Object[][]{{this.getHeaderResource("MaterialNumber", ctx), this.getHeaderResource("MaterialName", ctx), this.getHeaderResource("MaterialShortName", ctx), this.getHeaderResource("MaterialBaseClass", ctx), this.getHeaderResource("OrderAmount", ctx), this.getHeaderResource("OrderRate", ctx), this.getHeaderResource("VIEWABC", ctx)}});
        } else {
            header.setLabels((Object[][])new Object[][]{{this.getHeaderResource("MaterialNumber", ctx), this.getHeaderResource("MaterialName", ctx), this.getHeaderResource("MaterialBaseClass", ctx), this.getHeaderResource("OrderAmount", ctx), this.getHeaderResource("OrderRate", ctx), this.getHeaderResource("VIEWABC", ctx)}});
        }
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        return result;
    }

    private void buildStorageOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + orgTempTable + " (");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("fname_");
        sqlbf.append(params.getString("Language"));
        sqlbf.append(" varchar(100),");
        sqlbf.append("fparentid varchar(44),");
        sqlbf.append("flevel int,");
        sqlbf.append("fisleaf int");
        sqlbf.append(")");
        this.executeSQL(ctx, sqlbf.toString());
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] purChaseOrg = (Object[])params.getObject("fullOrgUnit");
        purChaseOrg = OrgUnitUtils.getPermissionOrg((Context)ctx, (Object[])purChaseOrg, (String)"materialABC_view");
        String[] sql = new String[purChaseOrg.length];
        int n = purChaseOrg.length;
        for (int i = 0; i < n; ++i) {
            sqlbf.delete(0, sqlbf.length());
            String fid = ((FullOrgUnitInfo)purChaseOrg[i]).get("id").toString();
            Integer flevel = (Integer)((FullOrgUnitInfo)purChaseOrg[i]).get("level");
            String fname = (String)((FullOrgUnitInfo)purChaseOrg[i]).get("name");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)purChaseOrg[i]).get("parent");
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)purChaseOrg[i]).get("isleaf");
            int fisleaf = isleaf != false ? 1 : 0;
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            sqlbf.append("insert into " + orgTempTable + "(");
            sqlbf.append("fid,fname_");
            sqlbf.append(params.getString("Language"));
            sqlbf.append(",fparentid,flevel,fisleaf) ");
            sqlbf.append("values(");
            sqlbf.append("'" + fid + "',");
            if (fname != null) {
                sqlbf.append("'" + fname + "',");
            } else {
                sqlbf.append("null,");
            }
            if (parent != null) {
                sqlbf.append("'" + parent.getId().toString() + "',");
            } else {
                sqlbf.append("null,");
            }
            sqlbf.append(flevel + ",");
            sqlbf.append(fisleaf + ") ");
            sql[i] = sqlbf.toString();
        }
        this.executeBatchUpdate(ctx, sql);
        params.setObject(this.leafPurChaseOrgUnitStr, (Object)v.toArray());
        params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    public String getHeaderResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("select temp.FNumber,temp.FName,");
        sqlbf.append(ckBxShowMShortName ? "Material.FShortName FShotrName," : "");
        sqlbf.append("temp.MATERIALBASECLASS,temp.FTotalTaxAmount,temp.FPercentMaterial , '' as FABC from ");
        sqlbf.append(params.getString("tempTable")).append(" AS temp ");
        sqlbf.append(ckBxShowMShortName ? " left outer join T_BD_Material  Material ON temp.FNumber = Material.FNumber " : "");
        sqlbf.append(" order by temp.FTotalTaxAmount DESC");
        RptRowSet rs = this.executeQuery(sqlbf.toString(), null, from, len, ctx);
        IRowSet rs2 = DbUtil.executeQuery((Context)ctx, (String)("select sum(FTotalTaxAmount) as FTotalOrderAmount from " + params.getString("tempTable")));
        BigDecimal totalOrderAmount = BigDecimal.ZERO;
        try {
            if (rs2.next()) {
                totalOrderAmount = rs2.getBigDecimal("FTotalOrderAmount");
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        pp.setObject("FTotalOrderAmount", (Object)totalOrderAmount);
        return pp;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }
}

