/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.eas.basedata.assistant.Currency;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.PeriodCollection;
import com.kingdee.eas.basedata.assistant.PeriodUtils;
import com.kingdee.eas.basedata.master.material.MaterialGroupInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.framework.report.util.ChartData;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.sm.report.SMReportException;
import com.kingdee.eas.scm.sm.report.app.AbstractPurPriceWMRPTFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PurPriceWMRPTFacadeControllerBean
extends AbstractPurPriceWMRPTFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.report.app.PurPriceWMRPTFacadeControllerBean");
    private static final Currency currency = null;
    private String purChaseUnitTempTableStr = "PurChaseUnitTempTable";
    private String leafPurChaseOrgUnitStr = "leafPurChaseOrgUnit";
    private String maxLevelStr = "maxLevelStr";
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("tempTable"), ctx);
        this.dropTable(params.getString("PurChaseUnitTempTable"), ctx);
        String tempTable = this.getTempTableName(this.getServerResource("PurchaseORGUintTempTable", ctx), ctx);
        String purChaseUnitTempTable = this.getTempTableName(this.getServerResource("PurchaseORGUintTempTable", ctx), ctx);
        params.setString("tempTable", tempTable);
        params.setString("PurChaseUnitTempTable", purChaseUnitTempTable);
        this.buildStorageOrgTable(ctx, purChaseUnitTempTable, params);
        this.createTempTableAndInsertData(ctx, tempTable, params);
        this.updateTotal(ctx, tempTable, purChaseUnitTempTable, params);
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setPurPriceWMRptHead(header, params, ctx);
        CurrencyInfo currencyInfo = null;
        try {
            currencyInfo = this.getCurrencyInfo(ctx, params);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setObject("ColList", params.getObject("ColList"));
        result.setObject("TitleList", params.getObject("TitleList"));
        result.setString(this.purChaseUnitTempTableStr, purChaseUnitTempTable);
        result.setObject("currencyInfo", (Object)currencyInfo);
        return result;
    }

    private CurrencyInfo getCurrencyInfo(Context ctx, RptParams params) throws BOSException, EASBizException, SQLException {
        CurrencyInfo currencyInfo = null;
        Object[] purchaseOrgs = (Object[])params.getObject("fullPurchaseOrgUnit");
        FullOrgUnitInfo purchaseOrg = null;
        StringBuffer purchaseOrgIds = new StringBuffer();
        purchaseOrgIds.append("'null'");
        if (null != purchaseOrgs) {
            for (int i = 0; i < purchaseOrgs.length; ++i) {
                if (purchaseOrgs[i] == null) continue;
                purchaseOrg = (FullOrgUnitInfo)purchaseOrgs[i];
                purchaseOrgIds.append(",'").append(purchaseOrg.getId().toString()).append("'");
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append("select FTOUnitID from T_ORG_UnitRelation where ftyperelationid='");
        sql.append("00000000-0000-0000-0000-0000000000030FE9F8B5").append("' \n");
        sql.append(" and FFromUnitID in (").append(purchaseOrgIds).append(") \n");
        sql.append(" group by FTOUnitID ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs.size() == 1) {
            rs.next();
            SelectorItemCollection selector = new SelectorItemCollection();
            selector.add(new SelectorItemInfo("baseCurrency.number"));
            selector.add(new SelectorItemInfo("baseCurrency.name"));
            CompanyOrgUnitInfo companyOrgUnit = CompanyOrgUnitFactory.getLocalInstance((Context)ctx).getCompanyOrgUnitInfo((IObjectPK)new ObjectUuidPK(rs.getString("FTOUnitID")), selector);
            if (companyOrgUnit != null) {
                currencyInfo = companyOrgUnit.getBaseCurrency();
            }
        }
        return currencyInfo;
    }

    private void buildStorageOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + orgTempTable + " (");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("fname_");
        sqlbf.append(params.getString("Language"));
        sqlbf.append(" varchar(100),");
        sqlbf.append("fparentid varchar(44),");
        sqlbf.append("flevel int,");
        sqlbf.append("fisleaf int");
        sqlbf.append(")");
        this.executeSQL(ctx, sqlbf.toString());
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] purChaseOrg = (Object[])params.getObject("fullPurchaseOrgUnit");
        purChaseOrg = OrgUnitUtils.getPermissionOrg((Context)ctx, (Object[])purChaseOrg, (String)"purpriceWMRpt_view");
        String[] sql = new String[purChaseOrg.length];
        int n = purChaseOrg.length;
        for (int i = 0; i < n; ++i) {
            sqlbf.delete(0, sqlbf.length());
            String fid = ((FullOrgUnitInfo)purChaseOrg[i]).get("id").toString();
            Integer flevel = (Integer)((FullOrgUnitInfo)purChaseOrg[i]).get("level");
            String fname = (String)((FullOrgUnitInfo)purChaseOrg[i]).get("name");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)purChaseOrg[i]).get("parent");
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)purChaseOrg[i]).get("isleaf");
            int fisleaf = isleaf != false ? 1 : 0;
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            sqlbf.append("insert into " + orgTempTable + "(");
            sqlbf.append("fid,fname_");
            sqlbf.append(params.getString("Language"));
            sqlbf.append(",fparentid,flevel,fisleaf) ");
            sqlbf.append("values(");
            sqlbf.append("'" + fid + "',");
            if (fname != null) {
                sqlbf.append("'" + fname + "',");
            } else {
                sqlbf.append("null,");
            }
            if (parent != null) {
                sqlbf.append("'" + parent.getId().toString() + "',");
            } else {
                sqlbf.append("null,");
            }
            sqlbf.append(flevel + ",");
            sqlbf.append(fisleaf + ") ");
            sql[i] = sqlbf.toString();
        }
        this.executeBatchUpdate(ctx, sql);
        params.setObject(this.leafPurChaseOrgUnitStr, (Object)v.toArray());
        params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        boolean isWeek = false;
        Calendar tempBDCalendar = Calendar.getInstance();
        Calendar tempEDCalendar = Calendar.getInstance();
        String bd = params.getString("dateStart");
        String ed = params.getString("dateEnd");
        tempBDCalendar.set(new Integer(bd.substring(0, 4)), new Integer(bd.substring(5, 7)) - 1, new Integer(bd.substring(8, 10)));
        tempEDCalendar.set(new Integer(ed.substring(0, 4)), new Integer(ed.substring(5, 7)) - 1, new Integer(ed.substring(8, 10)));
        Date beginDate = tempBDCalendar.getTime();
        Date endDate = tempEDCalendar.getTime();
        if ("true".equals(params.getString("Type"))) {
            isWeek = true;
        }
        if (isWeek) {
            this.setWeekList(beginDate, endDate, params, ctx);
        } else if ("true".equals(params.getString("Type1"))) {
            this.setPeriodList(beginDate, endDate, params, ctx);
        } else {
            this.setMonthList(beginDate, endDate, params, ctx);
        }
        String sql = this.getCreateTempTable(tempTable, params);
        this.executeSQL(ctx, sql);
        SqlParams sqlParams = new SqlParams();
        this.setPurPriceWMRPTData(sqlParams, params);
        sql = this.getPurPriceWMRptSql(params, tempTable, ctx);
        this.executeUpdate(sql, sqlParams, ctx);
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tempTable + "(\r\n");
        sql.append("FID Varchar(44)\r\n");
        sql.append(",FMaterialID Varchar(44)\r\n");
        sql.append(",FPurChaseUnitID Varchar(44)\r\n");
        sql.append(",FMaterialGroupID Varchar(44)\r\n");
        sql.append(",FSupplierID Varchar(44)\r\n");
        sql.append(",FUnitID Varchar(44)\r\n");
        sql.append(",fsupplyprice decimal(28,10)\r\n");
        sql.append(",FMaxPrice  Decimal(28,10)\r\n");
        sql.append(",FMinPrice  Decimal(28,10)\r\n");
        sql.append(",FCurrencyID varchar(44)\r\n");
        sql.append(",FFlag varchar(44)\r\n");
        sql.append(",FLevel int");
        List colList = (List)params.getObject("ColList");
        for (int i = 0; i < colList.size(); ++i) {
            String key = (String)colList.get(i);
            sql.append(",FQTY" + key + " Decimal(28,10)\r\n");
            sql.append(",FPrice" + key + " Decimal(28,10)\r\n");
        }
        sql.append(");\r\n");
        return sql.toString();
    }

    private void setPurPriceWMRPTData(SqlParams sqlParams, RptParams params) {
        int count = sqlParams.size() + 1;
        if (params.getString("materialTo") != null) {
            sqlParams.setString(count++, params.getString("materialTo"));
        }
        if (params.getString("MaterialGroupFrom") != null) {
            sqlParams.setString(count++, params.getString("MaterialGroupFrom"));
        }
        if (params.getString("MaterialGroupTo") != null) {
            sqlParams.setString(count++, params.getString("MaterialGroupTo"));
        }
    }

    private String getPurPriceWMRptSql(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        String sql = "";
        boolean isWeek = false;
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        Boolean IsTax = params.getBoolean("ckBIsTax");
        StringBuffer purOrderBuffer = new StringBuffer();
        int precision = params.getInt("Precision");
        String selectStr = "insert into " + tableName + " SELECT newbosid('88888888'),ENTRIES.FMaterialID,PURORDER.FPurChaseORGUnitID,MATERIALGROUP.FID,PURORDER.FSupplierID,ENTRIES.FBaseUnitID,si.Fprice";
        selectStr = IsTax != false ? selectStr + "\r\n ,max(ENTRIES.FTaxPrice)\r\n ,min(ENTRIES.FTaxPrice)\r\n ,null,null,ORG.flevel" : selectStr + "\r\n ,max(ENTRIES.FPrice)\r\n ,min(ENTRIES.FPrice)\r\n ,null,null,ORG.flevel";
        purOrderBuffer.append(selectStr);
        if ("true".equals(params.getString("Type"))) {
            isWeek = true;
        }
        List colList = (List)params.getObject("ColList");
        List firstDayList = (List)params.getObject("FirstDateList");
        List lastDayList = (List)params.getObject("LastDateList");
        for (int i = 0; i < colList.size(); ++i) {
            String key = (String)colList.get(i);
            String year = key.substring(0, key.indexOf("_"));
            String week = key.substring(key.indexOf("_") + 1);
            String firstDay = (String)firstDayList.get(i) + " 00:00:00";
            String lastDay = (String)lastDayList.get(i) + " 23:59:59";
            purOrderBuffer.append("\r\n ,SUM(CASE WHEN PURORDER.FBizDate >= ");
            purOrderBuffer.append("{").append(firstDay).append("}");
            purOrderBuffer.append(" AND PURORDER.FBizDate <=");
            purOrderBuffer.append("{").append(lastDay).append("}");
            purOrderBuffer.append(" THEN FBaseQty ELSE 0 END) AS ");
            purOrderBuffer.append("FQty").append(key);
            purOrderBuffer.append("\r\n ,CASE WHEN SUM(CASE WHEN PURORDER.FBizDate >=");
            purOrderBuffer.append("{").append(firstDay).append("}");
            purOrderBuffer.append(" AND  PURORDER.FBizDate <=");
            purOrderBuffer.append("{").append(lastDay).append("}");
            purOrderBuffer.append(" THEN FBaseQty ELSE 0 END)=0 THEN 0 ");
            purOrderBuffer.append(" ELSE (TO_DECIMAL(SUM(CASE WHEN PURORDER.FBizDate>=");
            purOrderBuffer.append("{").append(firstDay).append("}");
            purOrderBuffer.append(" AND  PURORDER.FBizDate <=");
            purOrderBuffer.append("{").append(lastDay).append("}");
            if (IsTax.booleanValue()) {
                purOrderBuffer.append(" THEN TO_DECIMAL((FTaxAmount)*(CASE WHEN FConvertMode=0 THEN PURORDER.FExchangeRate ELSE 1/PURORDER.FExchangeRate END)");
            } else {
                purOrderBuffer.append(" THEN TO_DECIMAL((FAmount)*(CASE WHEN FConvertMode=0 THEN PURORDER.FExchangeRate ELSE 1/PURORDER.FExchangeRate END)");
            }
            purOrderBuffer.append(",17,").append(precision).append(")+FTotalExpense ELSE 0 END),17,4)").append(")/TO_DECIMAL(SUM(CASE WHEN PURORDER.FBizDate>=").append("{").append(firstDay).append("}").append(" AND  PURORDER.FBizDate <=").append("{").append(lastDay).append("}").append(" THEN FBaseQty ELSE 0 END),21,8) END  AS ").append("FPrice").append(key);
        }
        purOrderBuffer.append("\r\n FROM T_SM_PurOrder AS PURORDER");
        purOrderBuffer.append("\r\n  INNER JOIN T_SM_PurOrderEntry AS ENTRIES");
        purOrderBuffer.append(" ON PURORDER.FID = ENTRIES.FParentID");
        purOrderBuffer.append("\r\n  INNER JOIN ");
        purOrderBuffer.append(params.getString("PurChaseUnitTempTable"));
        purOrderBuffer.append(" ORG");
        purOrderBuffer.append("  ON PURORDER.FPurchaseOrgUnitID = ORG.FID");
        purOrderBuffer.append("\r\n  INNER JOIN T_BD_Material AS MATERIAL ");
        purOrderBuffer.append(" ON ENTRIES.FMaterialID = MATERIAL.FID");
        purOrderBuffer.append("\r\n  LEFT OUTER JOIN T_BD_MaterialGroup AS MATERIALGROUP");
        purOrderBuffer.append(" ON MATERIAL.FMaterialGroupID = MATERIALGROUP.FID");
        purOrderBuffer.append("\r\n  INNER JOIN T_BD_MeasureUnit AS UNIT");
        purOrderBuffer.append(" ON ENTRIES.FBaseUnitID = UNIT.FID");
        purOrderBuffer.append(" left join (select z.fpurchaseorgid,z.fmaterialitemid,z.fsupplierid,z.fpurmeasureunitid,z.fprice ").append("from t_sm_supplyinfo as z ,").append(" (select fpurchaseorgid,fmaterialitemid,fsupplierid,fpurmeasureunitid,max(fauditdate) ").append(" as fauditdate from T_SM_SupplyInfo where fisuseable=1 and FMaterialPurchaseType=0 group by fpurchaseorgid,fmaterialitemid,fsupplierid,").append(" fpurmeasureunitid) as zv where z.fsupplierid=zv.fsupplierid and z.fmaterialitemid=zv.fmaterialitemid ").append(" and z.fpurchaseorgid=zv.fpurchaseorgid and z.fpurmeasureunitid=zv.fpurmeasureunitid and z.fauditdate=zv.fauditdate) ").append(" as si on purorder.FPurChaseOrgUnitID = si.fpurchaseorgid and si.fmaterialitemid=entries.fmaterialid ").append(" and purorder.fsupplierid=si.fsupplierid and entries.fbaseunitid=si.fpurmeasureunitid");
        String purOrderStr = this.getQueryStr(params, "purOrder", purOrderBuffer, ctx);
        sql = purOrderBuffer + "\r\n where " + purOrderStr + " and ORG.fisleaf = 1 \r\n group by ENTRIES.FMaterialID,MATERIALGROUP.FID,ENTRIES.FBaseUnitID,PURORDER.FSupplierID,PURORDER.FPurChaseORGUnitID,si.fprice,ORG.flevel\r\n having sum(FBaseQty)>0 ";
        if (!isWeek) {
            sql = sql.replaceAll("WEEK", "MONTH");
        }
        return sql;
    }

    private String getQueryStr(RptParams params, String purName, StringBuffer purBuffer, Context ctx) throws EASBizException, BOSException {
        StringBuffer queryStr = new StringBuffer();
        String bd = null;
        String ed = null;
        bd = params.getString("dateStart");
        ed = params.getString("dateEnd");
        queryStr.append(" (PURORDER.Fbasestatus =4 or PURORDER.Fbasestatus = 7 ) and ").append(purName + ".FBizDate  >= {" + bd + "} and " + purName + ".FBizDate <= {" + ed + "}");
        if (params.getObject("materialFrom") != null) {
            String[] numArray = SCMUtil.getF7Numbers((Object)params.getObject("materialFrom"));
            if (numArray[0] != null) {
                queryStr.append(" and material.FNumber >= '").append(numArray[0]).append("'");
            } else if (numArray[1] != null) {
                queryStr.append(" and material.FNumber in (").append(numArray[1]).append(")");
            }
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append(" inner join T_BD_Material material on material.fid = entry.fmaterialID ");
            }
        }
        if (params.getString("materialTo") != null) {
            queryStr.append(" and material.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append(" inner join T_BD_Material material on material.fid = entry.fmaterialID ");
            }
        }
        if (params.getString("MaterialGroupFrom") != null) {
            queryStr.append(" and materialGroup.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append(" inner join T_BD_Material material on material.fid = entry.fmaterialID ");
            }
            if (purBuffer.toString().indexOf("T_BD_Material") > 0 && purBuffer.toString().indexOf("T_BD_MaterialGroup") == -1) {
                purBuffer.append(" left outer join T_BD_MaterialGroup materialGroup on material.FMaterialGroupID = materialGroup.fid ");
            }
        }
        if (params.getString("MaterialGroupTo") != null) {
            queryStr.append(" and materialGroup.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append(" inner join T_BD_Material material on material.fid = entry.fmaterialID ");
            }
            if (purBuffer.toString().indexOf("T_BD_Material") > 0 && purBuffer.toString().indexOf("T_BD_MaterialGroup") == -1) {
                purBuffer.append(" left outer join T_BD_MaterialGroup materialGroup on material.FMaterialGroupID = materialGroup.fid ");
            }
        }
        return queryStr.toString();
    }

    private RptTableHeader setPurPriceWMRptHead(RptTableHeader header, RptParams params, Context ctx) {
        String materialNum = this.getServerResource("MaterialNumber", ctx);
        String materialName = this.getServerResource("MaterialName", ctx);
        String materialModel = this.getServerResource("MaterialModel", ctx);
        String supplyPrice = this.getServerResource("SupplyPrice", ctx);
        String materialGroup = this.getServerResource("MaterialGroup", ctx);
        String supplierName = this.getServerResource("supplierNameABC", ctx);
        String baseUnit = this.getServerResource("Unit", ctx);
        String maxPrice = this.getServerResource("MaxPrice", ctx);
        String minPrice = this.getServerResource("MinPrice", ctx);
        String purChaseUnitName = this.getServerResource("PurchaseUnit", ctx);
        String quatity = this.getServerResource("qty", ctx);
        String price = this.getServerResource("price", ctx);
        String materilShortName = this.getServerResource("MaterialShortName", ctx);
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        List titleList = (List)params.getObject("TitleList");
        int i = 9;
        if (ckBxShowMShortName) {
            i = 10;
        }
        Object[][] labels = new Object[3][i + 2 * titleList.size() + 8 + 1];
        String[] cols = new String[i + 2 * titleList.size() + 8 + 1];
        int m = 2;
        cols[0] = "MATERIAL_NUMBER";
        cols[1] = "MATERIAL_NAME";
        if (ckBxShowMShortName) {
            cols[m++] = "MATERIAL_SHORTNAME";
        }
        cols[m++] = "MATERIAL_MODEL";
        cols[m++] = "MATERIALGROUP_NAME";
        cols[m++] = "SUPPLIER_NAME";
        cols[m++] = "UNIT_NAME";
        cols[m++] = "SUPPLY_PRICE";
        cols[m++] = "MAX_PRICE";
        cols[m++] = "MIN_PRICE";
        cols[m++] = "PURCHASEORG_NAME";
        for (int j = 0; j < titleList.size(); ++j) {
            cols[++i] = "QTY" + j;
            cols[++i] = "PRICE" + j;
        }
        cols[i + 1] = "PURCHASEORG_ISLEAF";
        cols[i + 2] = "PURCHASEORG_LEVEL";
        cols[i + 3] = "PURCHASEORG_PARENTID";
        cols[i + 4] = "PURCHASEORG_FID";
        cols[i + 5] = "MATERIAL_FID";
        cols[i + 6] = "MATERIALGROUP_FID";
        cols[i + 7] = "CURRENCY_FID";
        ArrayList<String> hideCols = new ArrayList<String>();
        hideCols.add("PURCHASEORG_ISLEAF");
        hideCols.add("PURCHASEORG_LEVEL");
        hideCols.add("PURCHASEORG_PARENTID");
        hideCols.add("PURCHASEORG_FID");
        hideCols.add("MATERIAL_FID");
        hideCols.add("MATERIALGROUP_FID");
        hideCols.add("CURRENCY_FID");
        this.setHeaderColumns(header, cols, params, hideCols);
        labels[0][0] = materialNum;
        labels[1][0] = materialNum;
        labels[2][0] = materialNum;
        labels[0][1] = materialName;
        labels[1][1] = materialName;
        labels[2][1] = materialName;
        m = 2;
        if (ckBxShowMShortName) {
            labels[0][m] = materilShortName;
            labels[1][m] = materilShortName;
            labels[2][m++] = materilShortName;
        }
        labels[0][m] = materialModel;
        labels[1][m] = materialModel;
        labels[2][m++] = materialModel;
        labels[0][m] = materialGroup;
        labels[1][m] = materialGroup;
        labels[2][m++] = materialGroup;
        labels[0][m] = supplierName;
        labels[1][m] = supplierName;
        labels[2][m++] = supplierName;
        labels[0][m] = baseUnit;
        labels[1][m] = baseUnit;
        labels[2][m++] = baseUnit;
        labels[0][m] = supplyPrice;
        labels[1][m] = supplyPrice;
        labels[2][m++] = supplyPrice;
        labels[0][m] = maxPrice;
        labels[1][m] = maxPrice;
        labels[2][m++] = maxPrice;
        labels[0][m] = minPrice;
        labels[1][m] = minPrice;
        labels[2][m++] = minPrice;
        labels[0][m] = purChaseUnitName;
        labels[1][m] = purChaseUnitName;
        labels[2][m++] = purChaseUnitName;
        i = 9;
        if (ckBxShowMShortName) {
            i = 10;
        }
        List colList = (List)params.getObject("ColList");
        for (int j = 0; j < titleList.size(); ++j) {
            labels[0][++i] = colList.get(j).toString().substring(0, 4);
            labels[1][i] = titleList.get(j);
            labels[2][i] = quatity;
            labels[0][++i] = colList.get(j).toString().substring(0, 4);
            labels[1][i] = titleList.get(j);
            labels[2][i] = price;
        }
        labels[0][i + 1] = "PURCHASEORG_ISLEAF";
        labels[1][i + 1] = "PURCHASEORG_ISLEAF";
        labels[2][i + 1] = "PURCHASEORG_ISLEAF";
        labels[0][i + 2] = "PURCHASEORG_LEVEL";
        labels[1][i + 2] = "PURCHASEORG_LEVEL";
        labels[2][i + 2] = "PURCHASEORG_LEVEL";
        labels[0][i + 3] = "PURCHASEORG_PARENTID";
        labels[1][i + 3] = "PURCHASEORG_PARENTID";
        labels[2][i + 3] = "PURCHASEORG_PARENTID";
        labels[0][i + 4] = "PURCHASEORG_FID";
        labels[1][i + 4] = "PURCHASEORG_FID";
        labels[2][i + 4] = "PURCHASEORG_FID";
        labels[0][i + 5] = "MATERIAL_FID";
        labels[1][i + 5] = "MATERIAL_FID";
        labels[2][i + 5] = "MATERIAL_FID";
        labels[0][i + 6] = "MATERIALGROUP_FID";
        labels[1][i + 6] = "MATERIALGROUP_FID";
        labels[2][i + 6] = "MATERIALGROUP_FID";
        labels[0][i + 7] = "currencyName";
        labels[1][i + 7] = "currencyName";
        labels[2][i + 7] = "currencyName";
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params, List hideCols) {
        int precision = params.getInt("Precision");
        String prcFormat = RptCellFormatter.getNumberFormat((int)8, (boolean)false);
        String qtyFormat = RptCellFormatter.getNumberFormat((int)8, (boolean)false);
        RptTableColumn col = null;
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        int c = columns.length;
        for (int i = 0; i < c; ++i) {
            col = new RptTableColumn(columns[i]);
            if (ckBxShowMShortName) {
                if (i < 11) {
                    col.setWidth(-1);
                    if (i == 7 || i == 8 || i == 9) {
                        col.setWidth(120);
                        col.setAligment(2);
                        col.setFormatPattern(prcFormat);
                    }
                } else if (i < columns.length - 8) {
                    col.setWidth(120);
                    col.setAligment(2);
                    if (i % 2 == 1) {
                        col.setFormatPattern(prcFormat);
                    } else {
                        col.setFormatPattern(qtyFormat);
                    }
                } else {
                    col.setHided(true);
                }
            } else if (i < 10) {
                col.setWidth(-1);
                if (i == 6 || i == 7 || i == 8) {
                    col.setWidth(120);
                    col.setAligment(2);
                    col.setFormatPattern(prcFormat);
                }
            } else if (i < columns.length - 8) {
                col.setWidth(120);
                col.setAligment(2);
                if (i % 2 == 0) {
                    col.setFormatPattern(prcFormat);
                } else {
                    col.setFormatPattern(qtyFormat);
                }
            } else {
                col.setHided(true);
            }
            if (hideCols.contains(columns[i])) {
                col.setWidth(-1);
                col.setHided(true);
            }
            header.addColumn(col);
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String shortNameFrom = (String)params.getObject("shortNameFrom");
        String shortNameTo = (String)params.getObject("shortNameTo");
        StringBuffer sql = new StringBuffer();
        sql.append(this.querySql(params, ctx));
        sql.append(" where o.FLEVEL = 1  ");
        if (ckBxShowMShortName) {
            if (shortNameFrom != null && shortNameFrom.trim().length() > 0) {
                if (shortNameFrom.indexOf("'") != -1) {
                    shortNameFrom = shortNameFrom.replaceAll("'", "''");
                }
                sql.append(" and mat.FShortName >= '").append(shortNameFrom.trim()).append("' ");
            }
            if (shortNameTo != null && shortNameTo.trim().length() > 0) {
                if (shortNameTo.indexOf("'") != -1) {
                    shortNameTo = shortNameTo.replaceAll("'", "''");
                }
                sql.append(" and mat.FShortName <= '").append(shortNameTo.trim()).append("' ");
            }
        }
        sql.append(" order by mat.FNumber,a.FSupplierID,a.FPurChaseUnitID ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private void setWeekList(Date bDate, Date eDate, RptParams params, Context ctx) throws EASBizException, BOSException {
        Calendar firstCalendar = Calendar.getInstance();
        Calendar tempCalendar = Calendar.getInstance();
        ArrayList<String> titleList = new ArrayList<String>();
        ArrayList<String> firstDateList = new ArrayList<String>();
        ArrayList<String> lastDateList = new ArrayList<String>();
        ArrayList<String> colList = new ArrayList<String>();
        int year = 0;
        boolean week = false;
        int year2 = 0;
        boolean week2 = false;
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy.MM.dd");
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
        tempCalendar.setTime(bDate);
        firstCalendar.setTime(bDate);
        Date firstDay_of_year = bDate;
        Date firstDay_of_Week = bDate;
        year = firstCalendar.get(1);
        int n = 0;
        int w = 0;
        if (firstCalendar.get(7) > 1) {
            w = 8 - firstCalendar.get(7);
        }
        Map nationMap = PurUtil.getNationalMap(ctx);
        DateFormat format = (DateFormat)nationMap.get("dateFormat");
        while (!tempCalendar.getTime().after(eDate)) {
            tempCalendar.add(5, w);
            if (tempCalendar.getTime().after(eDate)) {
                tempCalendar.setTime(eDate);
            } else if (tempCalendar.get(1) > year) {
                tempCalendar.set(6, 1);
                tempCalendar.add(5, -1);
            }
            colList.add(year + "_" + n);
            titleList.add(format.format(firstCalendar.getTime()) + "_" + format.format(tempCalendar.getTime()));
            firstDateList.add(format2.format(firstCalendar.getTime()));
            lastDateList.add(format2.format(tempCalendar.getTime()));
            firstCalendar.setTime(tempCalendar.getTime());
            tempCalendar.add(5, 1);
            if (w != 6) {
                w = 6;
            }
            if ((year2 = tempCalendar.get(1)) > year) {
                colList.add(year + "_year");
                titleList.add(this.getServerResource("Year_Total", ctx));
                firstDateList.add(format2.format(firstDay_of_year));
                lastDateList.add(format2.format(firstCalendar.getTime()));
                firstDay_of_year = tempCalendar.getTime();
                year = year2;
                w = tempCalendar.get(7) > 1 ? 8 - tempCalendar.get(7) : 0;
            }
            firstCalendar.setTime(tempCalendar.getTime());
            year2 = tempCalendar.get(1);
            ++n;
        }
        if (year == year2 && tempCalendar.get(6) > 1) {
            colList.add(year + "_year");
            titleList.add(this.getServerResource("Year_Total", ctx));
            firstDateList.add(format2.format(firstDay_of_year));
            lastDateList.add(format2.format(eDate));
        }
        params.setObject("TitleList", titleList);
        params.setObject("FirstDateList", firstDateList);
        params.setObject("LastDateList", lastDateList);
        params.setObject("ColList", colList);
    }

    private void setPeriodList(Date bDate, Date eDate, RptParams params, Context ctx) throws EASBizException, BOSException {
        int i;
        OrgUnitCollection cols;
        Calendar firstCalendar = Calendar.getInstance();
        Calendar tempCalendar = Calendar.getInstance();
        tempCalendar.setTime(bDate);
        firstCalendar.setTime(bDate);
        Date firstDay_of_year = bDate;
        Object[] purchaseOrgs = (Object[])params.getObject("fullPurchaseOrgUnit");
        FullOrgUnitInfo purOrgInfo = (FullOrgUnitInfo)purchaseOrgs[0];
        CompanyOrgUnitInfo company = null;
        IOrgUnitRelation iorg = OrgUnitRelationFactory.getLocalInstance((Context)ctx);
        if (purOrgInfo != null && purOrgInfo.getId() != null && (cols = iorg.getToUnit(purOrgInfo.getId().toString(), 3, 1)) != null && cols.size() > 0) {
            company = (CompanyOrgUnitInfo)cols.get(0);
        }
        PeriodCollection perCollection = new PeriodCollection();
        try {
            perCollection = PeriodUtils.getPeriodCollection((Context)ctx, (Date)bDate, (Date)eDate, company);
        }
        catch (Exception e) {
            throw new SMReportException(SMReportException.TO_COMPANY_NULL);
        }
        ArrayList<String> titleList = new ArrayList<String>();
        ArrayList<String> firstDateList = new ArrayList<String>();
        ArrayList<String> lastDateList = new ArrayList<String>();
        ArrayList<String> colList = new ArrayList<String>();
        int year = 0;
        int month = 0;
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy.MM.dd");
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
        year = tempCalendar.get(1);
        ArrayList<Date> bDateList = new ArrayList<Date>();
        ArrayList<Timestamp> eDateList = new ArrayList<Timestamp>();
        ArrayList<Integer> yearList = new ArrayList<Integer>();
        for (i = perCollection.size() - 1; i >= 0; --i) {
            if (perCollection.get(i).isIsAdjustPeriod()) continue;
            bDateList.add(perCollection.get(i).getBeginDate());
            eDateList.add(perCollection.get(i).getEndDate());
            yearList.add(perCollection.get(i).getPeriodYear());
        }
        Collections.sort(bDateList);
        Collections.sort(eDateList);
        Collections.sort(yearList);
        for (i = 0; i < bDateList.size(); ++i) {
            tempCalendar.setTime((Date)eDateList.get(i));
            if (tempCalendar.getTime().after(eDate)) {
                tempCalendar.setTime(eDate);
            }
            year = (Integer)yearList.get(i);
            if (tempCalendar.getTime().after(eDate)) continue;
            if (i > 0 && ((Integer)yearList.get(i)).compareTo((Integer)yearList.get(i - 1)) > 0) {
                colList.add(yearList.get(i - 1) + "_year");
                titleList.add(this.getServerResource("Year_Total", ctx));
                firstDateList.add(format2.format(firstDay_of_year));
                lastDateList.add(format2.format((Date)eDateList.get(i - 1)));
                firstDay_of_year = (Date)bDateList.get(i);
            }
            colList.add(year + "_" + month);
            titleList.add(format1.format(firstCalendar.getTime()) + "_" + format1.format(tempCalendar.getTime()));
            firstDateList.add(format2.format(firstCalendar.getTime()));
            lastDateList.add(format2.format(tempCalendar.getTime()));
            firstCalendar.setTime((Date)eDateList.get(i));
            firstCalendar.add(5, 1);
            ++month;
        }
        if (tempCalendar.get(6) > 1) {
            colList.add(year + "_year");
            titleList.add(this.getServerResource("Year_Total", ctx));
            firstDateList.add(format2.format(firstDay_of_year));
            lastDateList.add(format2.format(eDate));
        }
        params.setObject("TitleList", titleList);
        params.setObject("FirstDateList", firstDateList);
        params.setObject("LastDateList", lastDateList);
        params.setObject("ColList", colList);
    }

    private void setMonthList(Date bDate, Date eDate, RptParams params, Context ctx) throws EASBizException, BOSException {
        Calendar firstCalendar = Calendar.getInstance();
        Calendar tempCalendar = Calendar.getInstance();
        tempCalendar.setTime(bDate);
        firstCalendar.setTime(bDate);
        Date firstDay_of_year = bDate;
        ArrayList<String> titleList = new ArrayList<String>();
        ArrayList<String> firstDateList = new ArrayList<String>();
        ArrayList<String> lastDateList = new ArrayList<String>();
        ArrayList<String> colList = new ArrayList<String>();
        int year = 0;
        int month = 0;
        int year2 = 0;
        SimpleDateFormat format1 = new SimpleDateFormat("yyyy.MM.dd");
        SimpleDateFormat format2 = new SimpleDateFormat("yyyy-MM-dd");
        Map nationMap = PurUtil.getNationalMap(ctx);
        DateFormat format = (DateFormat)nationMap.get("dateFormat");
        tempCalendar.set(5, 1);
        year = tempCalendar.get(1);
        while (!tempCalendar.getTime().after(eDate)) {
            tempCalendar.add(2, 1);
            tempCalendar.add(5, -1);
            if (tempCalendar.getTime().after(eDate)) {
                tempCalendar.setTime(eDate);
            } else if (tempCalendar.get(1) > year) {
                tempCalendar.set(6, 1);
                tempCalendar.add(5, -1);
            }
            colList.add(year + "_" + month);
            titleList.add(format.format(firstCalendar.getTime()) + "_" + format.format(tempCalendar.getTime()));
            firstDateList.add(format2.format(firstCalendar.getTime()));
            lastDateList.add(format2.format(tempCalendar.getTime()));
            firstCalendar.setTime(tempCalendar.getTime());
            tempCalendar.add(5, 1);
            year2 = tempCalendar.get(1);
            if (year2 > year) {
                colList.add(year + "_year");
                titleList.add(this.getServerResource("Year_Total", ctx));
                firstDateList.add(format2.format(firstDay_of_year));
                lastDateList.add(format2.format(firstCalendar.getTime()));
                firstDay_of_year = tempCalendar.getTime();
                year = year2;
            }
            firstCalendar.setTime(tempCalendar.getTime());
            year2 = tempCalendar.get(1);
            ++month;
        }
        if (year == year2 && tempCalendar.get(6) > 1) {
            colList.add(year + "_year");
            titleList.add(this.getServerResource("Year_Total", ctx));
            firstDateList.add(format2.format(firstDay_of_year));
            lastDateList.add(format2.format(eDate));
        }
        params.setObject("TitleList", titleList);
        params.setObject("FirstDateList", firstDateList);
        params.setObject("LastDateList", lastDateList);
        params.setObject("ColList", colList);
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    private void updateTotal(Context ctx, String tempTable, String orgTable, RptParams params) throws BOSException {
        String key;
        int i;
        StringBuffer sql = new StringBuffer();
        int level = (Integer)params.getObject(this.maxLevelStr);
        List colList = (List)params.getObject("ColList");
        sql.append("insert into " + tempTable);
        sql.append(" select t.FTEMPID,t.FMaterialID,t.fparentid,t.FMaterialGroupID,t.FSupplierID,t.FUnitID,t.fsupplyprice,t.FMaxPrice,t.FMinPrice,");
        sql.append("t.FCurrencyID,t.FFlag,t.flevel ");
        for (i = 0; i < colList.size(); ++i) {
            key = (String)colList.get(i);
            sql.append(",t.FQty").append(key);
            sql.append(",round(t.FPRICE").append(key).append(", m.FPricePrecision) ");
        }
        sql.append(" from ");
        sql.append(" (SELECT  newbosid('88888888') FTEMPID,temp.FMaterialID FMaterialID");
        sql.append(",org.fparentid fparentid,temp.FMaterialGroupID FMaterialGroupID,temp.FSupplierID FSupplierID,temp.FUnitID FUnitID,temp.fsupplyprice fsupplyprice");
        sql.append(",max(temp.FMaxPrice) FMaxPrice,min(temp.FMinPrice) FMinPrice");
        sql.append(",null as FCurrencyID,'nodel' as FFlag,org.flevel flevel ");
        for (i = 0; i < colList.size(); ++i) {
            key = (String)colList.get(i);
            sql.append(",sum(FQty").append(key).append(") FQTY").append(key).append(",case when sum(FQty").append(key).append(") =0 then 0 ").append("else decimal(sum(FQty").append(key).append("*FPrice").append(key).append(")").append("/sum(FQty").append(key).append("), 21, 8) END  FPRICE").append(key);
        }
        sql.append(" from  " + tempTable + " temp");
        sql.append(" \n inner join t_bd_material m on temp.FMaterialId=m.FID ");
        sql.append(" inner join ");
        sql.append(orgTable).append(" org on temp.FPurChaseUnitID = org.fid and org.flevel = ");
        String sqle = new String();
        for (int i2 = level; i2 > 1; --i2) {
            sqle = sql.toString() + i2 + " group by temp.FMaterialID,temp.FSupplierID,org.fparentid,temp.FMaterialGroupID,temp.FUnitID,temp.FCurrencyID,org.flevel,temp.fsupplyprice) as t inner join t_bd_material m on t.FMaterialId =m.FID ";
            this.executeSQL(ctx, sqle);
        }
        this.executeSQL(ctx, "delete " + tempTable + " where FFlag <> 'nodel'");
    }

    private String querySql(RptParams params, Context ctx) {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        List colList = (List)params.getObject("ColList");
        String purChaseUnitTempTable = params.getString(this.purChaseUnitTempTableStr);
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        sql.append(" SELECT mat.FNumber AS MATERIAL_NUMBER").append(",mat.FName_").append(params.getString("Language")).append(" AS MATERIAL_NAME,");
        sql.append(ckBxShowMShortName ? "mat.FShortName AS MATERIAL_SHORTNAME," : "");
        sql.append("mat.FModel AS MATERIAL_MODEL").append(",mg.FName_").append(params.getString("Language")).append(" AS MATERIALGROUP_NAME").append(",SUPPLIER.FName_").append(params.getString("Language")).append(" AS SUPPLIER_NAME").append(",UNIT.FName_").append(params.getString("Language")).append(" AS UNIT_NAME,a.fsupplyprice as supplyprice,a.FMaxPrice AS MAXPRICE,a.FMINPRICE AS MINPRICE,o.fname_").append(params.getString("Language")).append(" AS PURCHASEORG_NAME");
        for (int i = 0; i < colList.size(); ++i) {
            String key = (String)colList.get(i);
            sql.append(",(FQty").append(key).append("),(FPrice").append(key).append(")");
        }
        sql.append(",o.FIsleaf AS PURCHASEORG_ISLEAF,o.FLEVEL AS PURCHASEORG_LEVEL").append(",o.FPARENTID AS PURCHASEORG_PARENTID").append(",a.FPurChaseUnitID as PURCHASEORG_FID").append(",a.FMaterialID AS MATERIAL_FID,a.FMaterialGroupID").append(" AS MATERIALGROUP_FID,a.FCurrencyID as CURRENCY_FID").append(" from  " + tempTable + " a INNER JOIN ").append(purChaseUnitTempTable).append(" o ON a.FPurChaseUnitID = o.FID ").append(" INNER JOIN T_BD_Material mat on a.FMaterialID = mat.FID ").append(" LEFT OUTER JOIN T_BD_MaterialGroup mg on mat.FMaterialGroupID = mg.fid ").append(" \r\n INNER JOIN T_BD_Supplier AS SUPPLIER ON a.FSupplierID = SUPPLIER.FID ").append(" INNER JOIN T_BD_MeasureUnit AS UNIT ON a.FUnitID = UNIT.FID ");
        return sql.toString();
    }

    protected RptParams _findData(Context ctx, RptParams param, int start, int count, String tempTableName, Object treeTypeObject) throws BOSException, EASBizException {
        RptRowSet rs;
        String sql = "";
        if (start <= -1 && count <= -1) {
            sql = this.querySql(param, ctx) + " where mat.FNUMBER ='" + param.getString("fmaterialid") + "' and o.fparentid='" + param.getString("fparentid") + "' and supplier.Fname_" + param.getString("Language") + "='" + param.getString("fsupplier_name") + "' order by mat.FNumber,a.FSupplierID,a.FPurChaseUnitID ";
            rs = this.executeQuery(sql, null, ctx);
        } else {
            sql = this.querySql(param, ctx) + " where mat.FNUMBER ='" + param.getString("fmaterialid") + "' and o.fparentid='" + param.getString("fparentid") + "' and supplier.Fname_" + param.getString("Language") + "='" + param.getString("fsupplierName") + "' order by mat.FNumber,a.FSupplierID,a.FPurChaseUnitID ";
            rs = this.executeQuery(sql, null, ctx);
        }
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected RptParams _getChartDatas(Context ctx, RptParams params) throws BOSException, EASBizException {
        String key;
        StringBuffer sb = new StringBuffer();
        sb.append(this.querySql(params, ctx)).append(" where a.FMaterialID='").append(params.getString("MATERIAL_FID")).append("' and (o.fid='").append(params.getString("PURCHASEORG_PARENTID")).append("' or o.fparentid='").append(params.getString("PURCHASEORG_PARENTID")).append("') order by o.flevel");
        String sql = sb.toString();
        RptRowSet rs = this.executeQuery(sql, null, ctx);
        ArrayList<ChartData> list = new ArrayList<ChartData>();
        ChartData data = new ChartData();
        int count = rs.getRowCount();
        if (count == 0) {
            return null;
        }
        int cntGroup = 0;
        boolean i1 = false;
        int i2 = 0;
        int i3 = 0;
        List colList = (List)params.getObject("ColList");
        List titleList = (List)params.getObject("TitleList");
        String currency = params.getString("Currency");
        for (int i = 0; i < colList.size(); ++i) {
            key = (String)colList.get(i);
            if (key.indexOf("_0") != -1) continue;
            ++cntGroup;
        }
        data.setType(21);
        double[][][] values = new double[2][count][cntGroup];
        String[] titles = new String[2];
        String[] groups = new String[cntGroup];
        String[] series = new String[count];
        while (rs.next()) {
            if (titles[0] == null) {
                titles[0] = this.getServerResource("ChartPrice", ctx) + rs.getString("UNIT_NAME") + ")";
            }
            series[i2] = rs.getString("MATERIAL_NAME") + " " + rs.getString("purchaseorg_name");
            for (int i = 0; i < colList.size(); ++i) {
                key = (String)colList.get(i);
                if (key.indexOf("_0") != -1) continue;
                values[0][i2][i3] = rs.getBigDecimal("FQty" + key).doubleValue();
                values[1][i2][i3] = rs.getBigDecimal("FPrice" + key).doubleValue();
                groups[i3++] = (String)titleList.get(i);
            }
            ++i2;
            i3 = 0;
        }
        titles[1] = this.getServerResource("PurPriceUnit", ctx) + currency + ")";
        data.setCount(2);
        data.setTitle("");
        data.setSeriesKeys(series);
        data.setGroupsKeys(groups);
        data.setCombinedValues(values);
        data.setCombinedTitles(titles);
        RptParams result = new RptParams();
        list.add(data);
        result.setObject("Data", list);
        return result;
    }

    @Override
    protected int _check_Currency_unique(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        String beginDate = params.getString("dateStart");
        String endDate = params.getString("dateEnd");
        String purChaseUnitTempTable = this.getTempTableName(this.getServerResource("PurchaseORGUintTempTable", ctx), ctx);
        this.buildStorageOrgTable(ctx, purChaseUnitTempTable, params);
        sql.append(" SELECT  O.FBaseCurrencyID").append(" FROM T_SM_PurOrder AS PURORDER").append(" INNER JOIN T_SM_PurOrderEntry AS ENTRIES ").append(" ON PURORDER.FID = ENTRIES.FParentID ").append(" INNER JOIN T_Org_Company O").append(" ON ENTRIES.FCompanyOrgUnitID = O.FID").append(" INNER JOIN ").append(purChaseUnitTempTable).append(" ORG").append(" ON PURORDER.FPurchaseOrgUnitID = ORG.FID").append(" INNER JOIN T_BD_Material AS MATERIAL ").append(" ON ENTRIES.FMaterialID = MATERIAL.FID").append(" LEFT OUTER JOIN T_BD_MaterialGroup AS MATERIALGROUP ").append(" ON MATERIAL.FMaterialGroupID = MATERIALGROUP.FID").append(" INNER JOIN T_BD_MeasureUnit AS UNIT ").append(" ON ENTRIES.FBaseUnitID = UNIT.FID ").append(" where ORG.fisleaf = 1 ").append(" AND (PURORDER.FBizDate>={").append(beginDate).append("}").append(" AND  PURORDER.FBizDate <=").append("{").append(endDate).append("})").append(" AND (PURORDER.Fbasestatus =4 ").append(" or PURORDER.Fbasestatus = 7 ) ");
        if (params.getObject("MaterialFrom") != null) {
            String[] numArray = SCMUtil.getF7Numbers((Object)params.getObject("MaterialFrom"));
            if (numArray[0] != null) {
                sql.append(" and MATERIAL.FNumber >= '" + numArray[0] + "' ");
            } else if (numArray[1] != null) {
                sql.append(" and MATERIAL.FNumber in (" + numArray[1] + ") ");
            }
        }
        if (params.getString("MaterialTo") != null) {
            String materialNumber = ((MaterialInfo)params.getObject("MaterialTo")).getNumber();
            sql.append(" and MATERIAL.FNumber <= '" + materialNumber + "' ");
        }
        if (params.getString("MaterialGroupFrom") != null) {
            String materialTypeFrom = ((MaterialGroupInfo)params.getObject("MaterialGroupFrom")).getNumber();
            sql.append(" and MATERIALGROUP.Fnumber >= '" + materialTypeFrom + "'");
        }
        if (params.getString("MaterialGroupTo") != null) {
            String materialTypeTo = ((MaterialGroupInfo)params.getObject("MaterialGroupTo")).getNumber();
            sql.append(" and MATERIALGROUP.Fnumber >= '" + materialTypeTo + "'");
        }
        sql.append(" GROUP BY O.FBaseCurrencyID");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        this.dropTempTable(ctx, purChaseUnitTempTable);
        return rs.getRowCount();
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        String rsList = "select  s.fid from " + param.getString("tempTable") + " s inner join T_BD_Material m on s.FMaterialID=m.FID  inner join " + param.getString("PurChaseUnitTempTable") + " org  on s.FPurChaseUnitID = org.FID  where org.flevel = 1  order by m.FNumber";
        return DbUtil.executeQuery((Context)ctx, (String)rsList);
    }

    public RptParams getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException, EASBizException {
        return this.getDatas(ctx, params, idList, false);
    }

    private RptParams getDatas(Context ctx, RptParams params, List idList, boolean first) throws BOSException {
        int i;
        String subWhere;
        String orgTempTable = params.getString("PurChaseUnitTempTable");
        String TempTable = params.getString("tempTable");
        List colList = (List)params.getObject("ColList");
        boolean ckBxShowMShortName = params.getBoolean("ckBxShowMShortName");
        String shortNameFrom = (String)params.getObject("shortNameFrom");
        String shortNameTo = (String)params.getObject("shortNameTo");
        if (first) {
            subWhere = " org.flevel = 1 ";
        } else {
            StringBuffer fid = new StringBuffer("a.FId IN (  '").append(idList.get(0).toString()).append("'");
            int n = idList.size();
            for (i = 1; i < n; ++i) {
                fid.append(", '").append(idList.get(i).toString()).append("'");
            }
            fid.append(" ) ");
            subWhere = fid.toString();
        }
        if (ckBxShowMShortName) {
            if (shortNameFrom != null && shortNameFrom.trim().length() > 0) {
                if (shortNameFrom.indexOf("'") != -1) {
                    shortNameFrom = shortNameFrom.replaceAll("'", "''");
                }
                subWhere = subWhere + " and mat.FShortName >= '" + shortNameFrom.trim() + "' ";
            }
            if (shortNameTo != null && shortNameTo.trim().length() > 0) {
                if (shortNameTo.indexOf("'") != -1) {
                    shortNameTo = shortNameTo.replaceAll("'", "''");
                }
                subWhere = subWhere + " and mat.FShortName <= '" + shortNameTo.trim() + "' ";
            }
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT mat.FNumber AS MATERIAL_NUMBER").append(",mat.FName_").append(params.getString("Language")).append(" AS MATERIAL_NAME,");
        sql.append(ckBxShowMShortName ? "mat.FShortName AS MATERIAL_SHORTNAME," : "");
        sql.append("mat.FModel MATERIAL_MODEL").append(",mg.FName_").append(params.getString("Language")).append(" AS MATERIALGROUP_NAME").append(",supplier.FName_").append(params.getString("Language")).append(" AS SUPPLIER_NAME").append(",UNIT.FName_").append(params.getString("Language")).append(" AS UNIT_NAME,a.fsupplyprice as supplyprice,a.FMaxPrice AS MAXPRICE,a.FMINPRICE AS MINPRICE,org.fname_").append(params.getString("Language")).append(" AS PURCHASEORG_NAME");
        for (i = 0; i < colList.size(); ++i) {
            String key = (String)colList.get(i);
            sql.append(",(FQty").append(key).append("),(FPrice").append(key).append(")");
        }
        sql.append(",org.FIsleaf AS PURCHASEORG_ISLEAF").append(",org.FLEVEL AS PURCHASEORG_LEVEL").append(",org.FPARENTID AS PURCHASEORG_PARENTID").append(",a.FPurChaseUnitID as PURCHASEORG_FID").append(",a.FMaterialID AS MATERIAL_FID").append(",a.FMaterialGroupID as MATERIALGROUP_FID").append(",a.FCurrencyID as CURRENCY_FID").append(" from  " + TempTable + " AS a ").append(" INNER JOIN ").append(orgTempTable).append(" AS org ON a.FPurChaseUnitID = org.FID ").append(" INNER JOIN T_BD_Material mat on a.FMaterialID = mat.FID ").append(" LEFT OUTER JOIN T_BD_MaterialGroup mg on mat.FMaterialGroupID = mg.fid ").append(" INNER JOIN T_BD_Supplier AS SUPPLIER ON a.FSupplierID = SUPPLIER.FID ").append(" INNER JOIN T_BD_MeasureUnit AS UNIT ON a.FUnitID = UNIT.FID ").append(" where ").append(subWhere).append(" order by mat.FNumber");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }
}

