/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.report.ReportTitles;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.sm.report.app.AbstractPurRequestExecuteFacadeControllerBean;
import com.kingdee.eas.util.ResourceBase;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.util.BaseException;
import java.sql.SQLException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.Map;
import org.apache.log4j.Logger;

public class PurRequestExecuteFacadeControllerBean
extends AbstractPurRequestExecuteFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.report.app.PurRequestExecuteFacadeControllerBean");
    private String tempTableStr = "";
    private Context context;
    public static final String SIGN = "\r\n";
    private static final String locLan = SysContext.getSysContext().getLocale().getLanguage();

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.context = ctx;
        String purchaseType = (String)params.getObject("purchaseType");
        try {
            this.tempTableStr = TempTablePool.getInstance((Context)this.getContext()).createTempTable(this.getCreateTempTableSql());
        }
        catch (Exception e1) {
            throw new BOSException((Throwable)e1);
        }
        String resultSql = "";
        if (purchaseType != null) {
            try {
                String wherePartSql = this.getWherePartSql(ctx, params);
                if (purchaseType.equals("0")) {
                    this.insertPurDataToTempTable(params, wherePartSql);
                } else {
                    this.insertWWDataToTempTable(params, wherePartSql);
                }
                params.setString("queryType", "count");
                resultSql = this.getResultSql(params);
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        RptRowSet rs = this.executeQuery(resultSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptParams result = new RptParams();
        result.setString("tempTable", this.tempTableStr);
        result.setInt("verticalCount", count);
        return result;
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        this.tempTableStr = params.getString("tempTable");
        params.remove("queryType");
        RptRowSet rs = this.executeQuery(this.getResultSql(params), null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected RptParams _query(Context ctx, RptParams params) throws BOSException, EASBizException {
        return super._query(ctx, params);
    }

    private Context getContext() {
        return this.context;
    }

    private String getCreateTempTableSql() {
        StringBuffer sql = new StringBuffer();
        sql.append("CREATE TABLE Temp_PurRequestExecute ").append(SIGN);
        sql.append("(F1 NVARCHAR(80),").append(SIGN);
        sql.append("F2 INT,").append(SIGN);
        sql.append("FRowTypeID VARCHAR(44),").append(SIGN);
        sql.append("FMaterialGroupID VARCHAR(44),").append(SIGN);
        sql.append("F3 NVARCHAR(80),").append(SIGN);
        sql.append("F4 NVARCHAR(255),").append(SIGN);
        sql.append("F5 NVARCHAR(255),").append(SIGN);
        sql.append("FAssistPropertyID VARCHAR(44),").append(SIGN);
        sql.append("FUnitID VARCHAR(44),").append(SIGN);
        sql.append("FrequestQty Decimal(21,8) DEFAULT 0,").append(SIGN);
        sql.append("F8 Decimal(21,8) DEFAULT 0,").append(SIGN);
        sql.append("FreqBizDate varchar(255),").append(SIGN);
        sql.append("FrequirementDate varchar(255),").append(SIGN);
        sql.append("FreqBillDate varchar(255),").append(SIGN);
        sql.append("F9 NVARCHAR(80),").append(SIGN);
        sql.append("F10 INT,").append(SIGN);
        sql.append("F11 Decimal(21,8) DEFAULT 0,").append(SIGN);
        sql.append("FConBillDate varchar(255),").append(SIGN);
        sql.append("F12 NVARCHAR(80),").append(SIGN);
        sql.append("F13 INT,").append(SIGN);
        sql.append("F14 Decimal(21,8) DEFAULT 0,").append(SIGN);
        sql.append("ForderBillDate varchar(255),").append(SIGN);
        sql.append("F15 NVARCHAR(80),").append(SIGN);
        sql.append("F16 INT,").append(SIGN);
        sql.append("F17 Decimal(21,8) DEFAULT 0,").append(SIGN);
        sql.append("FpurRecBillDate varchar(255),").append(SIGN);
        sql.append("F18 Decimal(21,8) DEFAULT 0,").append(SIGN);
        sql.append("F19 Decimal(21,8) DEFAULT 0,").append(SIGN);
        sql.append("F20 NVARCHAR(80),").append(SIGN);
        sql.append("F21 INT,").append(SIGN);
        sql.append("F22 Decimal(21,8) DEFAULT 0,").append(SIGN);
        sql.append("F23 NVARCHAR(80),").append(SIGN);
        sql.append("F24 NVARCHAR(80),").append(SIGN);
        sql.append("FpurInBillDate varchar(255),").append(SIGN);
        sql.append("FPurOrgID VARCHAR(44),").append(SIGN);
        sql.append("FStorageOrgID VARCHAR(44),").append(SIGN);
        sql.append("FComOrgID VARCHAR(44),").append(SIGN);
        sql.append("FAdminOrgID VARCHAR(44),").append(SIGN);
        sql.append("FPersonID VARCHAR(44),").append(SIGN);
        sql.append("FQtyPrc Integer DEFAULT(4),");
        sql.append("FisMergeBill int,");
        sql.append("FPurchasePersonID VARCHAR(44))");
        return sql.toString();
    }

    private void insertPurDataToTempTable(RptParams params, String wherePartSql) throws BOSException, SQLException {
        this.insertPurDataToTab1(params, wherePartSql);
        this.insertPurDataToTab2(params, wherePartSql);
        this.insertPurDataToTab3(params, wherePartSql);
        this.insertPurDataToTab4(params, wherePartSql);
        this.insertPurDataToTab6(params, wherePartSql);
        this.insertPurDataToTab7(params, wherePartSql);
        this.insertPurDataToTab8(params, wherePartSql);
        this.insertPurDataToTab5(params, wherePartSql);
    }

    private void insertPurDataToTab1(RptParams params, String wherePartSql) throws BOSException, SQLException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(this.getInsertSql());
        insertSql.append(this.getPurSelectedSql1(params, wherePartSql));
        insertSql.append(" and ( purrec_h.FBaseStatus=4 or purin_h.FBaseStatus=4 ) ");
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
    }

    private void insertPurDataToTab2(RptParams params, String wherePartSql) throws BOSException, SQLException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(this.getInsertSql());
        insertSql.append(this.getPurSelectedsql(params, wherePartSql));
        insertSql.append(" and purin_h.FBaseStatus=4  ");
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
    }

    private void insertPurDataToTab3(RptParams params, String wherePartSql) throws BOSException, SQLException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(this.getInsertSql());
        insertSql.append(this.getPurSelectedSql3(params, wherePartSql));
        insertSql.append(" and ( purrec_h.FBaseStatus=4 or purin_h.FBaseStatus=4 ) ");
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
    }

    private void insertPurDataToTab4(RptParams params, String wherePartSql) throws BOSException, SQLException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(this.getInsertSql());
        insertSql.append(this.getPurSelectedSql4(params, wherePartSql));
        insertSql.append(" and purin_h.FBaseStatus=4  ");
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
    }

    private void insertPurDataToTab6(RptParams params, String wherePartSql) throws BOSException, SQLException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(this.getInsertSql());
        insertSql.append(this.getPurSelectedSql6(params, wherePartSql));
        insertSql.append(" and purord_h.FBaseStatus=4  ");
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
    }

    private void insertPurDataToTab7(RptParams params, String wherePartSql) throws BOSException, SQLException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(this.getInsertSql());
        insertSql.append(this.getPurSelectedSql7(params, wherePartSql));
        insertSql.append(" and purcont_h.FBaseStatus=4  ");
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
    }

    private void insertPurDataToTab8(RptParams params, String wherePartSql) throws BOSException, SQLException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(this.getInsertSql());
        insertSql.append(this.getPurSelectedSql8(params, wherePartSql));
        insertSql.append(" and purord_h.FBaseStatus=4  ");
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
    }

    private void insertPurDataToTab5(RptParams params, String wherePartSql) throws BOSException, SQLException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(this.getInsertSql());
        insertSql.append(this.getPurSelectedSql5(params, wherePartSql));
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
    }

    private String getPurSelectedSql1(RptParams params, String wherePartSql) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select h.fnumber as F1,e.fseq as F2,e.FRowTypeID as FRowTypeID,").append(SIGN);
        sql.append("e.FMaterialGroupID as FMaterialGroupID,mt.fnumber as F3,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.FName_").append(locLan).append(" else e.FmaterialName end)").append(" as F4,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.Fmodel else e.Fnonummaterialmodel end)").append(" as F5,").append(SIGN);
        sql.append("e.fassistpropertyid as FAssistPropertyID,").append(SIGN);
        sql.append("e.fbaseunitid as FUnitID,").append(SIGN);
        sql.append(" (case when e.fmaterialid is not null then round(decimal(e.FrequestQty*t1.FBaseConvsRate,21,8),t2.FQtyPrecision)");
        sql.append(" else e.FrequestQty end) as FrequestQty,").append(SIGN);
        sql.append("e.fbaseqty as F8, to_char(h.fbizDate,'yyyy-mm-dd') as FreqBizDate,to_char(e.frequirementDate,'yyyy-mm-dd') as ").append(SIGN);
        sql.append("FrequirementDate,to_char(h.faudittime,'yyyy-mm-dd') as FreqBillDate,").append(SIGN);
        sql.append("purcon_h.fnumber as F9,isnull(purcon_e.fseq ,0) as F10,isnull(purcon_e.fbaseqty,0) as F11,").append(SIGN);
        sql.append("to_char(purcon_h.faudittime,'yyyy-mm-dd') as FConBillDate,po.fnumber as F12,po.fseq as F13,").append(SIGN);
        sql.append("isnull(po.fbaseqty,0) as F14,to_char(po.faudittime,'yyyy-mm-dd') as ForderBillDate,").append(SIGN);
        sql.append("purrec_h.fnumber as F15,isnull(purrec_e.fseq,0) as F16,").append(SIGN);
        sql.append("isnull(purrec_e.fbaseqty,0) as F17,to_char(purrec_h.faudittime,'yyyy-mm-dd') as FpurRecBillDate,").append(SIGN);
        sql.append("isnull(purrec_e.fqualifiedBaseQty ,0) as F18,isnull(purrec_e.funqualifiedBaseQty,0) as F19,").append(SIGN);
        sql.append("purin_h.fnumber as F20,purin_e.fseq as F21,isnull(purin_e.fbaseqty,0) as F22,").append(SIGN);
        sql.append("mp.fnumber as F23,tn.fnumber as F24,").append(SIGN);
        sql.append("to_char(purin_h.faudittime,'yyyy-mm-dd') as FpurInBillDate,").append(SIGN);
        sql.append("e.FPurchaseOrgUnitID as FPurOrgID,e.FStorageOrgUnitID as FStorageOrgID,h.FCompanyOrgUnitID as FComOrgID,").append(SIGN);
        sql.append("e.FUseAdminOrgUnitID as FAdminOrgID,h.FPersonID as FPersonID, ").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then t2.FQtyPrecision else bu.FQtyPrecision end) as FQtyPrc ,h.FIsMergeBill as FisMergeBill , e.FPurchasePersonID as FPurchasePersonID").append(SIGN);
        sql.append(" from t_sm_purrequest h ").append(SIGN);
        sql.append(" inner join t_sm_purrequestEntry e on h.fid=e.fparentid and h.fbasestatus in (4,7) ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_Project mp on e.FPROJECTID=mp.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_TrackNumber tn on e.FTRACKNOID=tn.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_material mt on e.fmaterialid=mt.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t1 on e.fmaterialid=t1.fMaterialId and e.FUnitId=t1.FMeasureUnitId ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t2 on e.fmaterialid=t2.fMaterialId and e.FBaseUnitId=t2.FMeasureUnitId ").append(SIGN);
        sql.append(" inner join t_bd_measureUnit bu on e.FBaseUnitId=bu.FID ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_ORG_Company comorg on h.FCompanyOrgUnitID=comorg.fid ").append(SIGN);
        sql.append(" inner join t_sm_purcontractEntry purcon_e ");
        sql.append(" on (purcon_e.fsourcebillentryid=e.fid or purcon_e.fpurrequestentryid=e.fid) and purcon_e.FBaseStatus in (4,7) ").append(SIGN);
        sql.append(" inner join t_sm_purcontract purcon_h on purcon_h.fid=purcon_e.fparentid ").append(SIGN);
        sql.append(" left join (select purord_e.fid as fid,purord_h.fnumber,purord_e.fseq,purord_e.fbaseqty,").append(SIGN);
        sql.append(" purord_h.faudittime,purord_e.fsourcebillentryid from t_sm_purorderEntry ").append(SIGN);
        sql.append(" purord_e inner join t_sm_purorder purord_h on purord_e.fparentid=purord_h.fid ").append(SIGN);
        sql.append(" where purord_e.fbasestatus in (4,7)) po on po.fsourcebillentryid=purcon_e.fid ").append(SIGN);
        sql.append(" left join t_im_purreceivalEntry purrec_e on purrec_e.fsourcebillentryid=po.fid ").append(SIGN);
        sql.append(" left join t_im_purreceivalBill purrec_h on purrec_h.fid=purrec_e.fparentid ").append(SIGN);
        sql.append(" left join t_im_purinwarehsEntry purin_e on purin_e.fsourcebillentryid=purrec_e.fid ").append(SIGN);
        sql.append(" left join t_im_purinwarehsBill purin_h on purin_h.fid=purin_e.fparentid  ").append(SIGN);
        sql.append(wherePartSql);
        return sql.toString();
    }

    private String getPurSelectedsql(RptParams params, String wherePartSql) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select h.fnumber as F1,e.fseq as F2,e.FRowTypeID as FRowTypeID,").append(SIGN);
        sql.append("e.FMaterialGroupID as FMaterialGroupID,mt.fnumber as F3,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.FName_").append(locLan).append(" else e.FmaterialName end)").append(" as F4,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.Fmodel else e.Fnonummaterialmodel end)").append(" as F5,").append(SIGN);
        sql.append("e.fassistpropertyid as FAssistPropertyID,").append(SIGN);
        sql.append("e.fbaseunitid as FUnitID,");
        sql.append(" (case when e.fmaterialid is not null then round(decimal(e.FrequestQty*t1.FBaseConvsRate,21,8),t2.FQtyPrecision)");
        sql.append(" else e.FrequestQty end) as FrequestQty,").append(SIGN);
        sql.append("e.fbaseqty as F8, to_char(h.fbizDate,'yyyy-mm-dd') as FreqBizDate,to_char(e.frequirementDate,'yyyy-mm-dd') ").append(SIGN);
        sql.append("as FrequirementDate,to_char(h.faudittime,'yyyy-mm-dd') as FreqBillDate,").append(SIGN);
        sql.append("purcon_h.fnumber as F9,isnull(purcon_e.fseq ,0) as F10,isnull(purcon_e.fbaseqty,0) as F11,").append(SIGN);
        sql.append("to_char(purcon_h.faudittime,'yyyy-mm-dd') as FConBillDate,po.fnumber as F12,po.fseq as F13,").append(SIGN);
        sql.append("isnull(po.fbaseqty,0) as F14,to_char(po.faudittime,'yyyy-mm-dd') as ForderBillDate,").append(SIGN);
        sql.append("null as F15,0 as F16,0 as F17,null as FpurRecBillDate,0 as F18,0 as F19,").append(SIGN);
        sql.append("purin_h.fnumber as F20,purin_e.fseq as F21,isnull(purin_e.fbaseqty,0) as F22,").append(SIGN);
        sql.append("mp.fnumber as F23,tn.fnumber as F24,").append(SIGN);
        sql.append("to_char(purin_h.faudittime,'yyyy-mm-dd') as FpurInBillDate,e.FPurchaseOrgUnitID as FPurOrgID,").append(SIGN);
        sql.append("e.FStorageOrgUnitID as FStorageOrgID,h.FCompanyOrgUnitID as FComOrgID,").append(SIGN);
        sql.append("e.FUseAdminOrgUnitID as FAdminOrgID,h.FPersonID as FPersonID, ").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then t2.FQtyPrecision else bu.FQtyPrecision end) as FQtyPrc ,h.FIsMergeBill as FisMergeBill, e.FPurchasePersonID as FPurchasePersonID").append(SIGN);
        sql.append(" from t_sm_purrequest h ").append(SIGN);
        sql.append(" inner join t_sm_purrequestEntry e on h.fid=e.fparentid and h.fbasestatus in (4,7) ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_Project mp on e.FPROJECTID=mp.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_TrackNumber tn on e.FTRACKNOID=tn.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_material mt on e.fmaterialid=mt.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t1 on e.fmaterialid=t1.fMaterialId and e.FUnitId=t1.FMeasureUnitId ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t2 on e.fmaterialid=t2.fMaterialId and e.FBaseUnitId=t2.FMeasureUnitId ").append(SIGN);
        sql.append(" inner join t_bd_measureUnit bu on e.FBaseUnitId=bu.FID ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_ORG_Company comorg on h.FCompanyOrgUnitID=comorg.fid ").append(SIGN);
        sql.append(" inner join t_sm_purcontractEntry purcon_e ");
        sql.append(" on (purcon_e.fsourcebillentryid=e.fid or purcon_e.fpurrequestentryid=e.fid) and purcon_e.FBaseStatus in (4,7) ").append(SIGN);
        sql.append(" inner join t_sm_purcontract purcon_h on purcon_h.fid=purcon_e.fparentid ").append(SIGN);
        sql.append(" inner join (select purord_e.fid as fid,purord_h.fnumber,purord_e.fseq,purord_e.fbaseqty,").append(SIGN);
        sql.append(" purord_h.faudittime,purord_e.fsourcebillentryid from t_sm_purorderEntry ").append(SIGN);
        sql.append(" purord_e inner join t_sm_purorder purord_h on purord_e.fparentid=purord_h.fid ").append(SIGN);
        sql.append(" where purord_e.fbasestatus in (4,7)) po on po.fsourcebillentryid=purcon_e.fid ").append(SIGN);
        sql.append(" left outer join t_im_purinwarehsEntry purin_e on purin_e.fsourcebillentryid=po.fid ").append(SIGN);
        sql.append(" left outer join t_im_purinwarehsBill purin_h on purin_h.fid=purin_e.fparentid ").append(SIGN);
        sql.append(wherePartSql);
        return sql.toString();
    }

    private String getPurSelectedSql3(RptParams params, String wherePartSql) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select h.fnumber as F1,e.fseq as F2,e.FRowTypeID as FRowTypeID,").append(SIGN);
        sql.append("e.FMaterialGroupID as FMaterialGroupID,mt.fnumber as F3,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.FName_").append(locLan).append(" else e.FmaterialName end)").append(" as F4,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.Fmodel else e.Fnonummaterialmodel end)").append(" as F5,").append(SIGN);
        sql.append("e.fassistpropertyid as FAssistPropertyID,").append(SIGN);
        sql.append("e.fbaseunitid as FUnitID,").append(SIGN);
        sql.append(" (case when e.fmaterialid is not null then round(decimal(e.FrequestQty*t1.FBaseConvsRate,21,8),t2.FQtyPrecision)");
        sql.append(" else e.FrequestQty end) as FrequestQty,").append(SIGN);
        sql.append("e.fbaseqty as F8, to_char(h.fbizDate,'yyyy-mm-dd') as FreqBizDate,to_char(e.frequirementDate,'yyyy-mm-dd') ").append(SIGN);
        sql.append("as FrequirementDate,to_char(h.faudittime,'yyyy-mm-dd') as FreqBillDate,null as F9,0 as F10,0 as F11,").append(SIGN);
        sql.append("null as FConBillDate,purord_h.fnumber as F12,purord_e.fseq as F13,isnull(purord_e.fbaseqty,0) as F14,").append(SIGN);
        sql.append("to_char(purord_h.faudittime,'yyyy-mm-dd') as ForderBillDate,purrec_h.fnumber as F15,").append(SIGN);
        sql.append("isnull(purrec_e.fseq,0)as F16,isnull(purrec_e.fbaseqty,0) as F17,").append(SIGN);
        sql.append("to_char(purrec_h.faudittime,'yyyy-mm-dd') as FpurRecBillDate,").append(SIGN);
        sql.append("isnull(purrec_e.fqualifiedBaseQty ,0) as F18,isnull(purrec_e.funqualifiedBaseQty,0) as F19,").append(SIGN);
        sql.append("purin_h.fnumber as F20,purin_e.fseq as F21,isnull(purin_e.fbaseqty,0) as F22,").append(SIGN);
        sql.append("mp.fnumber as F23,tn.fnumber as F24,").append(SIGN);
        sql.append("to_char(purin_h.faudittime,'yyyy-mm-dd') as FpurInBillDate,").append(SIGN);
        sql.append("e.FPurchaseOrgUnitID as FPurOrgID,e.FStorageOrgUnitID as FStorageOrgID,h.FCompanyOrgUnitID as FComOrgID,").append(SIGN);
        sql.append("e.FUseAdminOrgUnitID as FAdminOrgID,h.FPersonID as FPersonID, ").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then t2.FQtyPrecision else bu.FQtyPrecision end) as FQtyPrc ,h.FIsMergeBill as FisMergeBill, e.FPurchasePersonID as FPurchasePersonID").append(SIGN);
        sql.append(" from t_sm_purrequest h ").append(SIGN);
        sql.append(" inner join t_sm_purrequestEntry e on h.fid=e.fparentid and h.fbasestatus in (4,7) ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_Project mp on e.FPROJECTID=mp.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_TrackNumber tn on e.FTRACKNOID=tn.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_material mt on e.fmaterialid=mt.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t1 on e.fmaterialid=t1.fMaterialId and e.FUnitId=t1.FMeasureUnitId ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t2 on e.fmaterialid=t2.fMaterialId and e.FBaseUnitId=t2.FMeasureUnitId ").append(SIGN);
        sql.append(" inner join t_bd_measureUnit bu on e.FBaseUnitId=bu.FID ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_ORG_Company comorg on h.FCompanyOrgUnitID=comorg.fid ").append(SIGN);
        sql.append(" inner join t_sm_purorderEntry purord_e ");
        sql.append(" on (purord_e.fsourcebillentryid=e.fid or purord_e.fpurrequestentryid=e.fid) and purord_e.fbasestatus in (4,7) ").append(SIGN);
        sql.append(" inner join t_sm_purorder purord_h on purord_h.fid=purord_e.fparentid ").append(SIGN);
        sql.append(" left join t_im_purreceivalEntry purrec_e on purrec_e.fsourcebillentryid=purord_e.fid ").append(SIGN);
        sql.append(" left join t_im_purreceivalBill purrec_h on purrec_h.fid=purrec_e.fparentid ").append(SIGN);
        sql.append(" left join t_im_purinwarehsEntry purin_e on purin_e.fsourcebillentryid=purrec_e.fid ").append(SIGN);
        sql.append(" left join t_im_purinwarehsBill purin_h on purin_h.fid=purin_e.fparentid ").append(SIGN);
        sql.append(wherePartSql).append(SIGN);
        sql.append(" and (purin_e.fsourcebillentryid<>purord_e.fid or (purin_e.fsourcebillentryid is null)) ");
        sql.append(" and purord_h.fsourcebilltypeid in ");
        sql.append(" ('510b6503-0105-1000-e000-0107c0a812fd463ED552','510b6503-0105-1000-e000-010bc0b814fd463ED552','510b6503-0105-1000-e000-010bc0a814fd463ED552') ");
        return sql.toString();
    }

    private String getPurSelectedSql4(RptParams params, String wherePartSql) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select h.fnumber as F1,e.fseq as F2,e.FRowTypeID as FRowTypeID,").append(SIGN);
        sql.append("e.FMaterialGroupID as FMaterialGroupID,mt.fnumber as F3,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.FName_").append(locLan).append(" else e.FmaterialName end)").append(" as F4,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.Fmodel else e.Fnonummaterialmodel end)").append(" as F5,").append(SIGN);
        sql.append("e.fassistpropertyid as FAssistPropertyID,").append(SIGN);
        sql.append("e.fbaseunitid as FUnitID,").append(SIGN);
        sql.append(" (case when e.fmaterialid is not null then round(decimal(e.FrequestQty*t1.FBaseConvsRate,21,8),t2.FQtyPrecision)");
        sql.append(" else e.FrequestQty end) as FrequestQty,").append(SIGN);
        sql.append("e.fbaseqty as F8, to_char(h.fbizDate,'yyyy-mm-dd') as FreqBizDate,to_char(e.frequirementDate,'yyyy-mm-dd') as ").append(SIGN);
        sql.append("FrequirementDate,to_char(h.faudittime,'yyyy-mm-dd') as FreqBillDate,null as F9,0 as F10,0 as F11,").append(SIGN);
        sql.append("null as FConBillDate,purord_h.fnumber as F12,purord_e.fseq as F13,isnull(purord_e.fbaseqty,0) as F14,").append(SIGN);
        sql.append("to_char(purord_h.faudittime,'yyyy-mm-dd') as ForderBillDate,null as F15,0 as F16,0 as F17,null as FpurRecBillDate,").append(SIGN);
        sql.append("0 as F18,0 as F19,purin_h.fnumber as F20,purin_e.fseq as F21,isnull(purin_e.fbaseqty,0) as F22,").append(SIGN);
        sql.append("mp.fnumber as F23,tn.fnumber as F24,").append(SIGN);
        sql.append("to_char(purin_h.faudittime,'yyyy-mm-dd') as FpurInBillDate,e.FPurchaseOrgUnitID as FPurOrgID,").append(SIGN);
        sql.append("e.FStorageOrgUnitID as FStorageOrgID,h.FCompanyOrgUnitID as FComOrgID,").append(SIGN);
        sql.append("e.FUseAdminOrgUnitID as FAdminOrgID,h.FPersonID as FPersonID, ").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then t2.FQtyPrecision else bu.FQtyPrecision end) as FQtyPrc ,h.FIsMergeBill as FisMergeBill, e.FPurchasePersonID as FPurchasePersonID").append(SIGN);
        sql.append(" from t_sm_purrequest h ").append(SIGN);
        sql.append(" inner join t_sm_purrequestEntry e on h.fid=e.fparentid and h.fbasestatus in (4,7) ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_Project mp on e.FPROJECTID=mp.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_TrackNumber tn on e.FTRACKNOID=tn.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_material mt on e.fmaterialid=mt.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t1 on e.fmaterialid=t1.fMaterialId and e.FUnitId=t1.FMeasureUnitId ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t2 on e.fmaterialid=t2.fMaterialId and e.FBaseUnitId=t2.FMeasureUnitId ").append(SIGN);
        sql.append(" inner join t_bd_measureUnit bu on e.FBaseUnitId=bu.FID ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_ORG_Company comorg on h.FCompanyOrgUnitID=comorg.fid ").append(SIGN);
        sql.append(" inner join t_sm_purorderEntry purord_e ");
        sql.append(" on (purord_e.fsourcebillentryid=e.fid or purord_e.fpurrequestentryid=e.fid) and purord_e.fbasestatus in (4,7) ").append(SIGN);
        sql.append(" left outer join t_sm_purorder purord_h on purord_h.fid=purord_e.fparentid ").append(SIGN);
        sql.append(" inner join t_im_purinwarehsEntry purin_e on purin_e.fsourcebillentryid=purord_e.fid ").append(SIGN);
        sql.append(" left outer join t_im_purinwarehsBill purin_h on purin_h.fid=purin_e.fparentid ").append(SIGN);
        sql.append(wherePartSql);
        sql.append(" and purord_h.fsourcebilltypeid in ");
        sql.append(" ('510b6503-0105-1000-e000-0107c0a812fd463ED552','510b6503-0105-1000-e000-010bc0b814fd463ED552','510b6503-0105-1000-e000-010bc0a814fd463ED552') ");
        return sql.toString();
    }

    private String getPurSelectedSql6(RptParams params, String wherePartSql) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select h.fnumber as F1,e.fseq as F2,e.FRowTypeID as FRowTypeID,").append(SIGN);
        sql.append("e.FMaterialGroupID as FMaterialGroupID,mt.fnumber as F3,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.FName_").append(locLan).append(" else e.FmaterialName end)").append(" as F4,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.Fmodel else e.Fnonummaterialmodel end)").append(" as F5,").append(SIGN);
        sql.append("e.fassistpropertyid as FAssistPropertyID,").append(SIGN);
        sql.append("e.fbaseunitid as FUnitID,").append(SIGN);
        sql.append(" (case when e.fmaterialid is not null then round(decimal(e.FrequestQty*t1.FBaseConvsRate,21,8),t2.FQtyPrecision)");
        sql.append(" else e.FrequestQty end) as FrequestQty,").append(SIGN);
        sql.append("e.fbaseqty as F8, to_char(h.fbizDate,'yyyy-mm-dd') as FreqBizDate,to_char(e.frequirementDate,'yyyy-mm-dd') as ").append(SIGN);
        sql.append("FrequirementDate,to_char(h.faudittime,'yyyy-mm-dd') as FreqBillDate,null as F9,0 as F10,0 as F11,").append(SIGN);
        sql.append("null as FConBillDate,purord_h.fnumber as F12,purord_e.fseq as F13,isnull(purord_e.fbaseqty,0) as F14,").append(SIGN);
        sql.append("to_char(purord_h.faudittime,'yyyy-mm-dd') as ForderBillDate,null as F15,0 as F16,0 as F17,null as FpurRecBillDate,").append(SIGN);
        sql.append("0 as F18,0 as F19,null as F20,0 as F21,0 as F22,").append(SIGN);
        sql.append("mp.fnumber as F23,tn.fnumber as F24,").append(SIGN);
        sql.append("null as FpurInBillDate,e.FPurchaseOrgUnitID as FPurOrgID,e.FStorageOrgUnitID as FStorageOrgID,").append(SIGN);
        sql.append("h.FCompanyOrgUnitID as FComOrgID,e.FUseAdminOrgUnitID as FAdminOrgID,").append(SIGN);
        sql.append("h.FPersonID as FPersonID, ").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then t2.FQtyPrecision else bu.FQtyPrecision end) as FQtyPrc ,h.FIsMergeBill as FisMergeBill, e.FPurchasePersonID as FPurchasePersonID").append(SIGN);
        sql.append(" from t_sm_purrequest h ").append(SIGN);
        sql.append(" inner join t_sm_purrequestEntry e on h.fid=e.fparentid and h.fbasestatus in (4,7) ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_Project mp on e.FPROJECTID=mp.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_TrackNumber tn on e.FTRACKNOID=tn.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_material mt on e.fmaterialid=mt.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t1 on e.fmaterialid=t1.fMaterialId and e.FUnitId=t1.FMeasureUnitId ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t2 on e.fmaterialid=t2.fMaterialId and e.FBaseUnitId=t2.FMeasureUnitId ").append(SIGN);
        sql.append(" inner join t_bd_measureUnit bu on e.FBaseUnitId=bu.FID ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_ORG_Company comorg on h.FCompanyOrgUnitID=comorg.fid ").append(SIGN);
        sql.append(" inner join t_sm_purorderEntry purord_e ");
        sql.append(" on (purord_e.fsourcebillentryid=e.fid or purord_e.fpurrequestentryid=e.fid) and purord_e.fbasestatus in (4,7) ").append(SIGN);
        sql.append(" left outer join t_sm_purorder purord_h on purord_h.fid=purord_e.fparentid").append(SIGN);
        sql.append(wherePartSql).append(SIGN);
        sql.append("  and (purord_e.FTOTALRECEIVEQTY is null or purord_e.FTOTALRECEIVEQTY+1=1) and (purord_e.FTOTALRECEIPTQTY is null or purord_e.FTOTALRECEIPTQTY+1=1)\n");
        sql.append(" and purord_h.fsourcebilltypeid in ");
        sql.append(" ('510b6503-0105-1000-e000-0107c0a812fd463ED552','510b6503-0105-1000-e000-010bc0b814fd463ED552','510b6503-0105-1000-e000-010bc0a814fd463ED552') ");
        return sql.toString();
    }

    private String getPurSelectedSql5(RptParams params, String wherePartSql) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select h.fnumber as F1,e.fseq as F2,e.FRowTypeID as FRowTypeID,").append(SIGN);
        sql.append("e.FMaterialGroupID as FMaterialGroupID,mt.fnumber as F3,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.FName_").append(locLan).append(" else e.FmaterialName end)").append(" as F4,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.Fmodel else e.Fnonummaterialmodel end)").append(" as F5,").append(SIGN);
        sql.append("e.fassistpropertyid as FAssistPropertyID,").append(SIGN);
        sql.append("e.fbaseunitid as FUnitID,").append(SIGN);
        sql.append(" (case when e.fmaterialid is not null then round(decimal(e.FrequestQty*t1.FBaseConvsRate,21,8),t2.FQtyPrecision)");
        sql.append(" else e.FrequestQty end) as FrequestQty,").append(SIGN);
        sql.append("e.fbaseqty as F8, to_char(h.fbizDate,'yyyy-mm-dd') as FreqBizDate,to_char(e.frequirementDate,'yyyy-mm-dd') as ").append(SIGN);
        sql.append("FrequirementDate,to_char(h.faudittime,'yyyy-mm-dd') as FreqBillDate,null as F9,0 as F10,0 as F11,").append(SIGN);
        sql.append("null as FConBillDate,null as F12,0 as F13,0 as F14, ").append(SIGN);
        sql.append("null as ForderBillDate,null as F15,0 as F16,0 as F17,null as FpurRecBillDate,0 as F18,0 as F19,").append(SIGN);
        sql.append("null as F20,0 as F21,0 as F22,").append(SIGN);
        sql.append("mp.fnumber as F23,tn.fnumber as F24,").append(SIGN);
        sql.append("null as FpurInBillDate,e.FPurchaseOrgUnitID as FPurOrgID,e.FStorageOrgUnitID as FStorageOrgID,").append(SIGN);
        sql.append("h.FCompanyOrgUnitID as FComOrgID,e.FUseAdminOrgUnitID as FAdminOrgID,").append(SIGN);
        sql.append("h.FPersonID as FPersonID, ").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then t2.FQtyPrecision else bu.FQtyPrecision end) as FQtyPrc ,h.FIsMergeBill as FisMergeBill, e.FPurchasePersonID as FPurchasePersonID").append(SIGN);
        sql.append(" from t_sm_purrequest h ").append(SIGN);
        sql.append(" inner join t_sm_purrequestEntry e on h.fid=e.fparentid and h.fbasestatus in (4,7) ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_Project mp on e.FPROJECTID=mp.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_TrackNumber tn on e.FTRACKNOID=tn.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_material mt on e.fmaterialid=mt.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t1 on e.fmaterialid=t1.fMaterialId and e.FUnitId=t1.FMeasureUnitId ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t2 on e.fmaterialid=t2.fMaterialId and e.FBaseUnitId=t2.FMeasureUnitId ").append(SIGN);
        sql.append(" inner join t_bd_measureUnit bu on e.FBaseUnitId=bu.FID ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_ORG_Company comorg on h.FCompanyOrgUnitID=comorg.fid ").append(SIGN);
        sql.append(wherePartSql).append(SIGN);
        sql.append(" and e.fpurContractID is null and (e.ftotalRequQty is null or e.ftotalRequQty+1=1) and (e.forderedQty is null or e.forderedQty+1=1)\n");
        sql.append(" and isnull(e.FQuotationTimes,0) = 0\n");
        sql.append(" and h.FBASESTATUS = 4\n");
        return sql.toString();
    }

    private String getPurSelectedSql7(RptParams params, String wherePartSql) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select h.fnumber as F1,e.fseq as F2,e.FRowTypeID as FRowTypeID,").append(SIGN);
        sql.append("e.FMaterialGroupID as FMaterialGroupID,mt.fnumber as F3,").append(SIGN);
        sql.append("mt.FName_").append(locLan).append(" as F4,mt.Fmodel as F5,e.fassistpropertyid as FAssistPropertyID,").append(SIGN);
        sql.append("e.fbaseunitid as FUnitID,").append(SIGN);
        sql.append(" (case when e.fmaterialid is not null then round(decimal(e.FrequestQty*t1.FBaseConvsRate,21,8),t2.FQtyPrecision)");
        sql.append(" else e.FrequestQty end) as FrequestQty,").append(SIGN);
        sql.append("e.fbaseqty as F8, to_char(h.fbizDate,'yyyy-mm-dd') as FreqBizDate,to_char(e.frequirementDate,'yyyy-mm-dd') as ").append(SIGN);
        sql.append("FrequirementDate,to_char(h.faudittime,'yyyy-mm-dd') as FreqBillDate,purcont_h.fnumber as F9,purcont_e.fseq as F10,isnull(purcont_e.fbaseqty,0) as F11,").append(SIGN);
        sql.append("to_char(purcont_h.faudittime,'yyyy-mm-dd') as FConBillDate,null as F12,0 as F13,0 as F14,").append(SIGN);
        sql.append("null as ForderBillDate,null as F15,0 as F16,0 as F17,null as FpurRecBillDate,").append(SIGN);
        sql.append("0 as F18,0 as F19,null as F20,0 as F21,0 as F22,").append(SIGN);
        sql.append("mp.fnumber as F23,tn.fnumber as F24,").append(SIGN);
        sql.append("null as FpurInBillDate,e.FPurchaseOrgUnitID as FPurOrgID,e.FStorageOrgUnitID as FStorageOrgID,").append(SIGN);
        sql.append("h.FCompanyOrgUnitID as FComOrgID,e.FUseAdminOrgUnitID as FAdminOrgID,").append(SIGN);
        sql.append("h.FPersonID as FPersonID, ").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then t2.FQtyPrecision else bu.FQtyPrecision end) as FQtyPrc ,h.FIsMergeBill as FisMergeBill, e.FPurchasePersonID as FPurchasePersonID").append(SIGN);
        sql.append(" from t_sm_purrequest h ").append(SIGN);
        sql.append(" inner join t_sm_purrequestEntry e on h.fid=e.fparentid and h.fbasestatus in (4,7) ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_Project mp on e.FPROJECTID=mp.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_TrackNumber tn on e.FTRACKNOID=tn.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_material mt on e.fmaterialid=mt.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t1 on e.fmaterialid=t1.fMaterialId and e.FUnitId=t1.FMeasureUnitId ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t2 on e.fmaterialid=t2.fMaterialId and e.FBaseUnitId=t2.FMeasureUnitId ").append(SIGN);
        sql.append(" inner join t_bd_measureUnit bu on e.FBaseUnitId=bu.FID ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_ORG_Company comorg on h.FCompanyOrgUnitID=comorg.fid ").append(SIGN);
        sql.append(" inner join t_sm_purcontractEntry purcont_e ");
        sql.append(" on (purcont_e.fsourcebillentryid=e.fid or purcont_e.fpurrequestentryid=e.fid) and purcont_e.fbasestatus in (4,7) ").append(SIGN);
        sql.append(" left outer join t_sm_purcontract purcont_h on purcont_h.fid=purcont_e.fparentid ").append(SIGN);
        sql.append(wherePartSql).append(SIGN);
        sql.append("  and (purcont_e.ftotalOrderQty is null or purcont_e.ftotalOrderQty+1=1)\n");
        return sql.toString();
    }

    private String getPurSelectedSql8(RptParams params, String wherePartSql) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select h.fnumber as F1,e.fseq as F2,e.FRowTypeID as FRowTypeID,").append(SIGN);
        sql.append("e.FMaterialGroupID as FMaterialGroupID,mt.fnumber as F3,").append(SIGN);
        sql.append("mt.FName_").append(locLan).append(" as F4,mt.Fmodel as F5,e.fassistpropertyid as FAssistPropertyID,").append(SIGN);
        sql.append("e.fbaseunitid as FUnitID,").append(SIGN);
        sql.append(" (case when e.fmaterialid is not null then round(decimal(e.FrequestQty*t1.FBaseConvsRate,21,8),t2.FQtyPrecision)");
        sql.append(" else e.FrequestQty end) as FrequestQty,").append(SIGN);
        sql.append("e.fbaseqty as F8, to_char(h.fbizDate,'yyyy-mm-dd') as FreqBizDate,to_char(e.frequirementDate,'yyyy-mm-dd') as ").append(SIGN);
        sql.append("FrequirementDate,to_char(h.faudittime,'yyyy-mm-dd') as FreqBillDate,purcont_h.fnumber as F9,purcont_e.fseq as F10,isnull(purcont_e.fbaseqty,0) as F11,").append(SIGN);
        sql.append("to_char(purcont_h.faudittime,'yyyy-mm-dd') as FConBillDate,purord_h.fnumber as F12,purord_e.fseq as F13,isnull(purord_e.fbaseqty,0) as F14,").append(SIGN);
        sql.append("to_char(purord_h.faudittime,'yyyy-mm-dd') as ForderBillDate,null as F15,0 as F16,0 as F17,null as FpurRecBillDate,").append(SIGN);
        sql.append("0 as F18,0 as F19,null as F20,0 as F21,0 as F22,").append(SIGN);
        sql.append("mp.fnumber as F23,tn.fnumber as F24,").append(SIGN);
        sql.append("null as FpurInBillDate,e.FPurchaseOrgUnitID as FPurOrgID,e.FStorageOrgUnitID as FStorageOrgID,").append(SIGN);
        sql.append("h.FCompanyOrgUnitID as FComOrgID,e.FUseAdminOrgUnitID as FAdminOrgID,").append(SIGN);
        sql.append("h.FPersonID as FPersonID, ").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then t2.FQtyPrecision else bu.FQtyPrecision end) as FQtyPrc ,h.FIsMergeBill as FisMergeBill, e.FPurchasePersonID as FPurchasePersonID").append(SIGN);
        sql.append(" from t_sm_purrequest h ").append(SIGN);
        sql.append(" inner join t_sm_purrequestEntry e on h.fid=e.fparentid and h.fbasestatus in (4,7) ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_Project mp on e.FPROJECTID=mp.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_TrackNumber tn on e.FTRACKNOID=tn.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_material mt on e.fmaterialid=mt.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t1 on e.fmaterialid=t1.fMaterialId and e.FUnitId=t1.FMeasureUnitId ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t2 on e.fmaterialid=t2.fMaterialId and e.FBaseUnitId=t2.FMeasureUnitId ").append(SIGN);
        sql.append(" inner join t_bd_measureUnit bu on e.FBaseUnitId=bu.FID ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_ORG_Company comorg on h.FCompanyOrgUnitID=comorg.fid ").append(SIGN);
        sql.append(" inner join t_sm_purcontractEntry purcont_e ");
        sql.append(" on (purcont_e.fsourcebillentryid=e.fid or purcont_e.fpurrequestentryid=e.fid) and purcont_e.fbasestatus in (4,7) ").append(SIGN);
        sql.append(" left outer join t_sm_purcontract purcont_h on purcont_h.fid=purcont_e.fparentid ").append(SIGN);
        sql.append(" inner join t_sm_purorderEntry purord_e on purord_e.fsourcebillentryid=purcont_e.fid ").append(SIGN);
        sql.append(" left outer join t_sm_purorder purord_h on purord_h.fid=purord_e.fparentid ").append(SIGN);
        sql.append(wherePartSql);
        sql.append("  and (purord_e.FTOTALRECEIVEQTY is null or purord_e.FTOTALRECEIVEQTY+1=1) and (purord_e.FTOTALRECEIPTQTY is null or purord_e.FTOTALRECEIPTQTY+1=1)\n");
        return sql.toString();
    }

    private void insertWWDataToTempTable(RptParams params, String wherePartSql) throws BOSException, SQLException {
        this.insertWWDataTOTab1(params, wherePartSql);
        this.insertWWDataTOTab2(params, wherePartSql);
        this.insertSubData(params, wherePartSql);
    }

    private void insertWWDataTOTab1(RptParams params, String wherePartSql) throws BOSException, SQLException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(this.getInsertSql());
        insertSql.append(this.getWWSelectedSql1(params, wherePartSql));
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
    }

    private void insertWWDataTOTab2(RptParams params, String wherePartSql) throws BOSException, SQLException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(this.getInsertSql());
        insertSql.append(this.getWWSelectedsql(params, wherePartSql));
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
    }

    private void insertSubData(RptParams params, String wherePartSql) throws BOSException, SQLException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append(this.getInsertSql());
        insertSql.append(this.getPurSelectedSql5(params, wherePartSql));
        DbUtil.execute((Context)this.getContext(), (String)insertSql.toString());
    }

    private String getWWSelectedSql1(RptParams params, String wherePartSql) {
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT H.FNUMBER AS F1,E.FSEQ AS F2,E.FROWTYPEID AS FRowTypeID,").append(SIGN);
        sql.append("E.FMATERIALGROUPID AS FMaterialGroupID,MT.FNUMBER AS F3,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.FName_").append(locLan).append(" else e.FmaterialName end)").append(" as F4,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.Fmodel else e.Fnonummaterialmodel end)").append(" as F5,").append(SIGN);
        sql.append("E.FASSISTPROPERTYID AS FAssistPropertyID,").append(SIGN);
        sql.append("E.FBASEUNITID AS FUnitID,").append(SIGN);
        sql.append(" (case when e.fmaterialid is not null then round(decimal(e.FrequestQty*t1.FBaseConvsRate,21,8),t2.FQtyPrecision)");
        sql.append(" else e.FrequestQty end) as FrequestQty,").append(SIGN);
        sql.append("E.FBASEQTY AS F8,to_char(H.FBIZDATE,'yyyy-mm-dd') AS FREQBIZDATE,to_char(E.FREQUIREMENTDATE,'yyyy-mm-dd') ").append(SIGN);
        sql.append("AS FREQUIREMENTDATE,to_char(H.FAUDITTIME,'yyyy-mm-dd') AS FREQBILLDATE,NULL AS F9,NULL AS F10,0 AS F11,").append(SIGN);
        sql.append("NULL AS FCONBILLDATE,SUBORD_H.FNUMBER AS F12,SUBORD_E.FSEQ AS F13,ISNULL(SUBORD_E.FBASEQTY,0) AS F14,").append(SIGN);
        sql.append("to_char(SUBORD_H.FAUDITTIME,'yyyy-mm-dd') AS FORDERBILLDATE,PURREC_H.FNUMBER AS F15,ISNULL(PURREC_E.FSEQ,0) AS F16,").append(SIGN);
        sql.append("ISNULL(PURREC_E.FBASEQTY,0) AS F17,to_char(PURREC_H.FAUDITTIME,'yyyy-mm-dd') AS FPURRECBILLDATE,").append(SIGN);
        sql.append("ISNULL(PURREC_E.FQUALIFIEDBASEQTY ,0) AS F18,ISNULL(PURREC_E.FUNQUALIFIEDBASEQTY,0) AS F19,").append(SIGN);
        sql.append("PURIN_H.FNUMBER AS F20,PURIN_E.FSEQ AS F21,ISNULL(PURIN_E.FBASEQTY,0) AS F22,").append(SIGN);
        sql.append("mp.fnumber as F23,tn.fnumber as F24,").append(SIGN);
        sql.append("to_char(PURIN_H.FAUDITTIME,'yyyy-mm-dd') AS FPURINBILLDATE,E.FPURCHASEORGUNITID AS FPurOrgID,").append(SIGN);
        sql.append("E.FSTORAGEORGUNITID as FStorageOrgID,H.FCOMPANYORGUNITID as FComOrgID,").append(SIGN);
        sql.append("E.FUSEADMINORGUNITID as FAdminOrgID,H.FPERSONID as FPersonID, ").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then t2.FQtyPrecision else bu.FQtyPrecision end) as FQtyPrc ,h.FIsMergeBill as FisMergeBill,e.FPurchasePersonID as FPurchasePersonID").append(SIGN);
        sql.append(" FROM T_SM_PURREQUEST H ").append(SIGN);
        sql.append(" INNER JOIN T_SM_PURREQUESTENTRY E ON H.FID=E.FPARENTID AND H.FBASESTATUS IN (4,7) ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_Project mp on e.FPROJECTID=mp.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_TrackNumber tn on e.FTRACKNOID=tn.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_BD_MATERIAL MT ON E.FMATERIALID=MT.FID ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t1 on e.fmaterialid=t1.fMaterialId and e.FUnitId=t1.FMeasureUnitId ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t2 on e.fmaterialid=t2.fMaterialId and e.FBaseUnitId=t2.FMeasureUnitId ").append(SIGN);
        sql.append(" inner join t_bd_measureUnit bu on e.FBaseUnitId=bu.FID ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_ORG_COMPANY COMORG ON H.FCOMPANYORGUNITID=COMORG.FID ").append(SIGN);
        sql.append(" INNER JOIN T_SM_SUBCONTRACTORDERENTRY SUBORD_E ON SUBORD_E.FSOURCEBILLENTRYID=E.FID AND SUBORD_E.FBASESTATUS IN (4,7) ").append(SIGN);
        sql.append(" LEFT JOIN T_SM_SUBCONTRACTORDER SUBORD_H ON SUBORD_H.FID=SUBORD_E.FPARENTID ").append(SIGN);
        sql.append(" LEFT JOIN T_IM_PURRECEIVALENTRY PURREC_E ON PURREC_E.FSOURCEBILLENTRYID=SUBORD_E.FID ").append(SIGN);
        sql.append(" LEFT JOIN T_IM_PURRECEIVALBILL PURREC_H ON PURREC_H.FID=PURREC_E.FPARENTID AND PURREC_H.FBASESTATUS=4 ").append(SIGN);
        sql.append(" LEFT JOIN T_IM_PURINWAREHSENTRY PURIN_E ON PURIN_E.FSOURCEBILLENTRYID=PURREC_E.FID ").append(SIGN);
        sql.append(" LEFT JOIN T_IM_PURINWAREHSBILL PURIN_H ON PURIN_H.FID=PURIN_E.FPARENTID AND PURIN_H.FBASESTATUS=4 ").append(SIGN);
        sql.append(wherePartSql);
        sql.append(" and (purin_e.fsourcebillentryid<>purrec_e.fid or (purin_e.fsourcebillentryid is null and purrec_e.fid is null)) ");
        return sql.toString();
    }

    private String getWWSelectedsql(RptParams params, String wherePartSql) {
        StringBuffer sql = new StringBuffer();
        sql.append(" select h.fnumber as F1,e.fseq as F2,e.FRowTypeID as FRowTypeID,").append(SIGN);
        sql.append("e.FMaterialGroupID as FMaterialGroupID,mt.fnumber as F3,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.FName_").append(locLan).append(" else e.FmaterialName end)").append(" as F4,").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then ");
        sql.append("mt.Fmodel else e.Fnonummaterialmodel end)").append(" as F5,").append(SIGN);
        sql.append("e.fassistpropertyid as FAssistPropertyID,").append(SIGN);
        sql.append("e.fbaseunitid as FUnitID,").append(SIGN);
        sql.append(" (case when e.fmaterialid is not null then round(decimal(e.FrequestQty*t1.FBaseConvsRate,21,8),t2.FQtyPrecision)");
        sql.append(" else e.FrequestQty end) as FrequestQty,").append(SIGN);
        sql.append("e.fbaseqty as F8,to_char(h.fbizDate,'yyyy-mm-dd') as FreqBizDate,to_char(e.frequirementDate,'yyyy-mm-dd') ").append(SIGN);
        sql.append("as FrequirementDate,to_char(h.faudittime,'yyyy-mm-dd') as FreqBillDate,null as F9,null as F10,0 as F11,").append(SIGN);
        sql.append("null as FConBillDate,subord_h.fnumber as F12,subord_e.fseq as F13,isnull(subord_e.fbaseqty,0) as F14,").append(SIGN);
        sql.append("to_char(subord_h.faudittime,'yyyy-mm-dd') as ForderBillDate,null as F15,0 as F16,0 as F17,null as FpurRecBillDate, ").append(SIGN);
        sql.append("0 as F18,0 as F19,purin_h.fnumber as F20,purin_e.fseq as F21,isnull(purin_e.fbaseqty,0) as F22,").append(SIGN);
        sql.append("mp.fnumber as F23,tn.fnumber as F24,").append(SIGN);
        sql.append("to_char(purin_h.faudittime,'yyyy-mm-dd') as FpurInBillDate,e.FPurchaseOrgUnitID as FPurOrgID,").append(SIGN);
        sql.append("e.FStorageOrgUnitID as FStorageOrgID,h.FCompanyOrgUnitID as FComOrgID,").append(SIGN);
        sql.append("e.FUseAdminOrgUnitID as FAdminOrgID,h.FPersonID as FPersonID, ").append(SIGN);
        sql.append("(case when e.fmaterialid is not null then t2.FQtyPrecision else bu.FQtyPrecision end) as FQtyPrc ,h.FIsMergeBill as FisMergeBill,e.FPurchasePersonID as FPurchasePersonID").append(SIGN);
        sql.append(" from t_sm_purrequest h ").append(SIGN);
        sql.append(" inner join t_sm_purrequestEntry e on h.fid=e.fparentid and h.fbasestatus in (4,7) ").append(SIGN).append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_Project mp on e.FPROJECTID=mp.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_MM_TrackNumber tn on e.FTRACKNOID=tn.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_material mt on e.fmaterialid=mt.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t1 on e.fmaterialid=t1.fMaterialId and e.FUnitId=t1.FMeasureUnitId ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_multimeasureunit t2 on e.fmaterialid=t2.fMaterialId and e.FBaseUnitId=t2.FMeasureUnitId ").append(SIGN);
        sql.append(" inner join t_bd_measureUnit bu on e.FBaseUnitId=bu.FID ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_ORG_Company comorg on h.FCompanyOrgUnitID=comorg.fid ").append(SIGN);
        sql.append(" inner join t_sm_subcontractorderentry subord_e on subord_e.fsourcebillentryid=e.fid and ").append(SIGN);
        sql.append("subord_e.fbasestatus in (4,7) ").append(SIGN);
        sql.append(" left join t_sm_subcontractorder subord_h on subord_h.fid=subord_e.fparentid ").append(SIGN);
        sql.append(" left join t_im_purinwarehsEntry purin_e on purin_e.fsourcebillentryid=subord_e.fid ").append(SIGN);
        sql.append(" left join t_im_purinwarehsBill purin_h on purin_h.fid=purin_e.fparentid and purin_h.fbasestatus=4 ").append(SIGN);
        sql.append(wherePartSql);
        return sql.toString();
    }

    private String getResultSql(RptParams arg1) {
        String purchaseOrgUnitNumber = (String)arg1.getObject("purchaseOrgUnit.number");
        String storageOrgUnitNumber = (String)arg1.getObject("storageOrgUnit.number");
        String adminOrgUnitNumber = (String)arg1.getObject("adminOrgUnitNumber");
        String proposerFrom = (String)arg1.getObject("proposerFrom");
        String proposerTo = (String)arg1.getObject("proposerTo");
        StringBuffer sql = new StringBuffer();
        if (null != arg1.getString("queryType") && arg1.getString("queryType").equalsIgnoreCase("count")) {
            sql.append("select  count(1) cc");
        } else {
            sql.append("select distinct F1, F2,rt.FName_").append(locLan).append(" as rowTypeName,").append(SIGN);
            sql.append("mg.FName_").append(locLan).append(" as FmaterailGroupName,F3,F4,F5,").append(SIGN);
            sql.append("aav.FName_").append(locLan).append(" as F6,unit.FName_").append(locLan).append(" as F7,").append(SIGN);
            sql.append("FrequestQty,F8,FreqBizDate,FrequirementDate,FreqBillDate,").append(SIGN);
            sql.append("F9, case when F10=0 then null else F10 end as F10, F11, FConBillDate,F12, case when F13=0 then null else F13 end as F13,").append(SIGN);
            sql.append(" F14,ForderBillDate,F15,case when F16=0 then null else F16 end as F16,").append(SIGN);
            sql.append("F17,FpurRecBillDate,F18,F19,F20,case when F21=0 then null else F21 end as F21,F22,F23,F24,FpurInBillDate,FQtyPrc,FisMergeBill,").append(SIGN);
            sql.append("strorg.FName_").append(locLan).append(" as FStorageOrgName, ");
            sql.append("purorg.FName_").append(locLan).append(" as FPurchaseOrgName, per2.FName_").append(locLan).append(" as FPurchasePersonName").append(SIGN);
            sql.append("").append(SIGN);
        }
        sql.append(" from ").append(this.tempTableStr).append(SIGN);
        sql.append(" LEFT OUTER JOIN T_SCM_RowType rt on FRowTypeID=rt.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_BD_MaterialGroup mg on FMaterialGroupID=mg.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_BD_AsstAttrValue aav on FAssistPropertyID=aav.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN t_bd_measureunit unit on FUnitID=unit.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_ORG_Purchase purorg on FPurOrgID=purorg.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_ORG_Storage strorg on FStorageOrgID=strorg.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_ORG_Admin admorg on FAdminOrgID=admorg.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_BD_Person per on FPersonID=per.fid ").append(SIGN);
        sql.append(" LEFT OUTER JOIN T_BD_Person per2 on FPurchasePersonID=per2.fid ").append(SIGN);
        StringBuffer sb = new StringBuffer();
        if (purchaseOrgUnitNumber != null && !purchaseOrgUnitNumber.equals("")) {
            sb.append(" purorg.fnumber='" + purchaseOrgUnitNumber + "' ").append(SIGN);
        }
        if (storageOrgUnitNumber != null && !storageOrgUnitNumber.equals("")) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(" strorg.fnumber='" + storageOrgUnitNumber + "' ").append(SIGN);
        }
        if (adminOrgUnitNumber != null && !adminOrgUnitNumber.equals("")) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(" admorg.fnumber='" + adminOrgUnitNumber + "' ").append(SIGN);
        }
        if (proposerFrom != null && proposerTo != null && !proposerFrom.equals("") && !proposerTo.equals("")) {
            if (sb.length() > 0) {
                sb.append(" and ");
            }
            sb.append(" per.fnumber>='" + proposerFrom + "' and per.fnumber<='" + proposerTo + "' ").append(SIGN);
        }
        if (sb.length() > 0) {
            sql.append("where ").append(sb.toString()).append(SIGN);
        }
        if (null == arg1.getString("queryType") || !arg1.getString("queryType").equalsIgnoreCase("count")) {
            StringBuffer newSql = new StringBuffer();
            newSql.append("select t.F1,t.F2,max(t.ROWTYPENAME) rowTypeName,max(t.FMATERAILGROUPNAME) FmaterailGroupName,max(t.F3) F3,max(t.F4) F4,max(t.F5) F5,max(t.F6) F6,max(t.F7) F7,max(t.FREQUESTQTY) FrequestQty,max(t.F8) F8,max(t.FREQBIZDATE) FreqBizDate,max(t.FREQUIREMENTDATE) FrequirementDate,max(t.FREQBILLDATE) FreqBillDate,max(t.F9) F9,max(t.F10) F10,max(t.F11) F11,max(t.FCONBILLDATE) FConBillDate,max(t.F12) F12,max(t.F13) F13,max(t.F14) F14,max(t.FORDERBILLDATE) ForderBillDate,max(t.F15) F15,max(t.F16) F16,max(t.F17) F17,max(t.FPURRECBILLDATE) FpurRecBillDate,max(t.F18) F18,max(t.F19) F19,max(t.F20) F20,max(t.F21) F21,max(t.F22) F22,max(t.F23) F23,max(t.F24) F24, max(t.FPURINBILLDATE) FpurInBillDate,max(t.FQTYPRC) FQtyPrc, ");
            newSql.append("max(t.FStorageOrgName) FStorageOrgName, max(t.FPurchaseOrgName) FPurchaseOrgName, max(t.FPurchasePersonName) FPurchasePersonName from(").append(sql.toString()).append(") t");
            newSql.append(" group by t.F1,t.F2,f9,f10,f12,f13,f15,f16,f20,f21 order by t.F1,t.F2,f9,f10,f12,f13,f15,f16,f20,f21 ").append(SIGN);
            sql = newSql;
        }
        return sql.toString();
    }

    private String getWherePartSql(Context ctx, RptParams arg1) throws BOSException, SQLException {
        String numberFrom = (String)arg1.getObject("numberFrom");
        String numberTo = (String)arg1.getObject("numberTo");
        String materialNumFrom = (String)arg1.getObject("materialNumFrom");
        String materialNumTo = (String)arg1.getObject("materialNumTo");
        String purchaseType = (String)arg1.getObject("purchaseType");
        Boolean isMergeBill = arg1.getBoolean("isMergeBill");
        Object[] companyOrgUnit = (Object[])arg1.getObject("companyOrgUnitNumber");
        companyOrgUnit = OrgUnitUtils.getPermissionOrg((Context)ctx, (Object[])companyOrgUnit, (String)"PurRequestExecuteReportView");
        String bizDateFrom = (String)arg1.getObject("bizDateFrom");
        String bizDateTo = (String)arg1.getObject("bizDateTo");
        if (bizDateFrom != null && !bizDateFrom.equals("")) {
            bizDateFrom = bizDateFrom.substring(0, bizDateFrom.indexOf(" "));
        }
        if (bizDateTo != null && !bizDateTo.equals("")) {
            bizDateTo = bizDateTo.substring(0, bizDateTo.indexOf(" "));
        }
        StringBuffer companyOrgUnitStrList = new StringBuffer();
        if (companyOrgUnit != null && companyOrgUnit.length > 0) {
            int n = companyOrgUnit.length;
            for (int i = 0; i < n; ++i) {
                boolean fisleaf = (Boolean)((FullOrgUnitInfo)companyOrgUnit[i]).get("isleaf");
                if (!fisleaf) continue;
                companyOrgUnitStrList.append("'" + ((FullOrgUnitInfo)companyOrgUnit[i]).getNumber() + "'");
                companyOrgUnitStrList.append(",");
            }
            companyOrgUnitStrList.delete(companyOrgUnitStrList.length() - 1, companyOrgUnitStrList.length());
        } else {
            companyOrgUnitStrList.append("'xxx_xx'");
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" where comorg.fnumber in(" + companyOrgUnitStrList + ") ").append(SIGN);
        if (purchaseType != null) {
            if (purchaseType.equals("0")) {
                sql.append("and h.FPurchaseType = 0 ").append(SIGN);
            } else {
                sql.append("and h.FPurchaseType = 1 ").append(SIGN);
            }
        }
        if (numberFrom != null && numberTo != null && !numberFrom.equals("") && !numberTo.equals("")) {
            sql.append(" and h.fnumber>='" + numberFrom + "' and h.fnumber<='" + numberTo + "' ").append(SIGN);
        }
        if (materialNumFrom != null && materialNumTo != null && !materialNumFrom.equals("") && !materialNumTo.equals("")) {
            sql.append(" and mt.fnumber>='" + materialNumFrom + "' and mt.fnumber<='" + materialNumTo + "' ").append(SIGN);
        }
        if (isMergeBill != null && !isMergeBill.booleanValue()) {
            sql.append(" and e.FMergeBillNumber is null ").append(SIGN);
        }
        if (bizDateFrom != null && !bizDateFrom.equals("")) {
            sql.append(" and h.fbizDate>={ts'" + bizDateFrom + "'} ").append(SIGN);
        }
        if (bizDateTo != null && !bizDateTo.equals("")) {
            sql.append(" and h.fbizDate<={ts'" + bizDateTo + "'} ").append(SIGN);
        }
        return sql.toString();
    }

    private String getInsertSql() throws BOSException, SQLException {
        StringBuffer insertSql = new StringBuffer();
        insertSql.append("insert into ").append(this.tempTableStr).append(SIGN);
        insertSql.append(" (F1,F2,FRowTypeID,FMaterialGroupID,F3,F4,F5,FAssistPropertyID,FUnitID,FrequestQty,F8,").append(SIGN);
        insertSql.append("FreqBizDate,FrequirementDate,FreqBillDate,F9,F10,F11,FConBillDate,").append(SIGN);
        insertSql.append("F12,F13,F14,ForderBillDate,F15,F16,F17,FpurRecBillDate,F18,F19,").append(SIGN);
        insertSql.append("F20,F21,F22,F23,F24,FpurInBillDate,FPurOrgID,FStorageOrgID,FComOrgID,FAdminOrgID,FPersonID,FQtyPrc,FisMergeBill, FPurchasePersonID) ");
        return insertSql.toString();
    }

    protected ReportTitles getReportTitles(String arg0, RptParams arg1) throws BaseException {
        Object[] companyOrgUnit = (Object[])arg1.getObject("companyOrgUnitNumber");
        StringBuffer companyOrgUnitStrList = new StringBuffer();
        if (companyOrgUnit != null && companyOrgUnit.length > 0) {
            int n = companyOrgUnit.length;
            for (int i = 0; i < n; ++i) {
                boolean fisleaf = (Boolean)((FullOrgUnitInfo)companyOrgUnit[i]).get("isleaf");
                if (!fisleaf) continue;
                companyOrgUnitStrList.append(((FullOrgUnitInfo)companyOrgUnit[i]).getName(this.getContext().getLocale()));
                companyOrgUnitStrList.append(";");
            }
        }
        companyOrgUnitStrList.delete(companyOrgUnitStrList.length() - 1, companyOrgUnitStrList.length());
        String bizDateFrom = (String)arg1.getObject("bizDateFrom");
        String bizDateTo = (String)arg1.getObject("bizDateTo");
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        Map nationMap = PurUtil.getNationalMap(this.getContext());
        DateFormat format = (DateFormat)nationMap.get("dateFormat");
        if (bizDateFrom != null && !bizDateFrom.equals("")) {
            bizDateFrom = bizDateFrom.substring(0, bizDateFrom.indexOf(" "));
        }
        if (bizDateTo != null && !bizDateTo.equals("")) {
            bizDateTo = bizDateTo.substring(0, bizDateTo.indexOf(" "));
        }
        ReportTitles titles = new ReportTitles();
        titles.AddTitle(0, ResourceBase.getString((String)"com.kingdee.eas.scm.sm.report.SMReportResource", (String)"CompanyOrgUnit", (Locale)this.getContext().getOriginLocale()) + companyOrgUnitStrList.toString());
        try {
            if (bizDateFrom != null && !bizDateFrom.equals("") && bizDateTo != null && !bizDateTo.equals("")) {
                titles.AddTitle(2, PurUtil.getServerResource("com.kingdee.eas.scm.sm.report.SMReportResource", "156_RANGE_FROM", new String[]{format.format(dateFormat.parse(bizDateFrom)), format.format(dateFormat.parse(bizDateTo))}, this.getContext()));
            } else {
                titles.AddTitle(2, ResourceBase.getString((String)"com.kingdee.eas.scm.sm.report.SMReportResource", (String)"TIME_BY_SPAN_ALL", (Locale)this.getContext().getOriginLocale()));
            }
        }
        catch (ParseException e) {
            throw new BaseException((Throwable)e);
        }
        return titles;
    }
}

