/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.report.SMReportException;
import com.kingdee.eas.scm.sm.report.app.AbstractPurRequestTrackRptFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class PurRequestTrackRptFacadeControllerBean
extends AbstractPurRequestTrackRptFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.report.app.PurRequestTrackRptFacadeControllerBean");
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";
    private boolean isFromDialog = true;
    private String leafCompanyOrgUnitStr = "leafCompanyOrgUnit";
    private static final String locLan = SysContext.getSysContext().getLocale().getLanguage();
    private String maxLevelStr = "maxLevelStr";

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("TempTableName"), ctx);
        String tempTable = this.getTempTableName(this.getServerResource("CompanyORGUintTempTable", ctx), ctx);
        String orgUnitTempTable = this.getTempTableName(this.getServerResource("ORGUintTempTable", ctx), ctx);
        params.setString("TempTableName", tempTable);
        params.setString("OrgTempTable", orgUnitTempTable);
        this.buildOrgTempTable(ctx, orgUnitTempTable, params);
        this.createTempTableAndInsertData(ctx, tempTable, params);
        String countSql = "select count(1) cc from " + tempTable;
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setTableHead(header, params, ctx);
        RptParams result = new RptParams();
        result.setString("TempTableName", tempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setString("OrgTempTable", orgUnitTempTable);
        return result;
    }

    private void buildOrgTempTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + orgTempTable + " (");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("fname_");
        sqlbf.append(locLan);
        sqlbf.append(" varchar(100),");
        sqlbf.append("fparentid varchar(44),");
        sqlbf.append("flevel int,");
        sqlbf.append("fisleaf int");
        sqlbf.append(")");
        this.executeSQL(ctx, sqlbf.toString());
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] CompanyOrg = (Object[])params.getObject("fullOrgUnit");
        String[] sql = new String[CompanyOrg.length];
        int n = CompanyOrg.length;
        for (int i = 0; i < n; ++i) {
            sqlbf.delete(0, sqlbf.length());
            String fid = ((FullOrgUnitInfo)CompanyOrg[i]).get("id").toString();
            Integer flevel = (Integer)((FullOrgUnitInfo)CompanyOrg[i]).get("level");
            String fname = (String)((FullOrgUnitInfo)CompanyOrg[i]).get("name");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)CompanyOrg[i]).get("parent");
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)CompanyOrg[i]).get("isleaf");
            int fisleaf = isleaf != false ? 1 : 0;
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            sqlbf.append("insert into " + orgTempTable + "(");
            sqlbf.append("fid,fname_");
            sqlbf.append(locLan);
            sqlbf.append(",fparentid,flevel,fisleaf) ");
            sqlbf.append("values(");
            sqlbf.append("'" + fid + "',");
            if (fname != null) {
                sqlbf.append("'" + fname + "',");
            } else {
                sqlbf.append("null,");
            }
            if (parent != null) {
                sqlbf.append("'" + parent.getId().toString() + "',");
            } else {
                sqlbf.append("null,");
            }
            sqlbf.append(flevel + ",");
            sqlbf.append(fisleaf + ") ");
            sql[i] = sqlbf.toString();
        }
        this.executeBatchUpdate(ctx, sql);
        params.setObject(this.leafCompanyOrgUnitStr, (Object)v.toArray());
        params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String sql = this.getCreateTempTable(tempTable, params);
        this.executeSQL(ctx, sql);
        StringBuffer sbLink = new StringBuffer();
        String whereCls = this.getWhereCls(params, sbLink);
        String link = sbLink.toString();
        String sumTempTbName = this.getTempTableName(this.getServerResource("RPTTempTable", ctx), ctx);
        sql = this.getCreatSumTempTbSql(sumTempTbName);
        this.executeUpdate(sql, null, ctx);
        String inserSumTempTbSql = this.getInsertSumTempTb(params, sumTempTbName, whereCls, link);
        this.executeUpdate(inserSumTempTbSql, null, ctx);
        sql = this.getAllSQL(params, tempTable, sumTempTbName);
        this.executeUpdate(sql, null, ctx);
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tempTable + "(\r\n");
        sql.append("FID Varchar(44) \r\n");
        sql.append(",FRequestNumber Varchar(80) \r\n");
        sql.append(",FSeq INT \r\n");
        sql.append(",FDeliveryDate DateTime \r\n");
        sql.append(",FCompanyOrgUnitID Varchar(44)\r\n");
        sql.append(",FMaterialID Varchar(44)\r\n");
        sql.append(",FUnitID Varchar(44)\r\n");
        sql.append(",FRequestQty  Decimal(28,10)\r\n");
        sql.append(",FOrderNumber Varchar(80) \r\n");
        sql.append(",FOrderSeq INT \r\n");
        sql.append(",FOrderStatus int \r\n");
        sql.append(",FOrderQty  Decimal(28,10)\r\n");
        sql.append(",FOrderUnitID Varchar(44)\r\n");
        sql.append(",FTotalPurReceivalQty  Decimal(28,10)\r\n");
        sql.append(",FTotalInWarehsQty  Decimal(28,10)\r\n");
        sql.append(");\r\n");
        return sql.toString();
    }

    private String getCreatSumTempTbSql(String tempTable) {
        StringBuffer sb = new StringBuffer();
        sb.append("create table ");
        sb.append(tempTable);
        sb.append(" (fid varchar(44),");
        sb.append("fentryid varchar(44),");
        sb.append("FTotalPurReceivalQty decimal (28, 10),");
        sb.append("FTotalInWarehsQty decimal (28, 10))");
        return sb.toString();
    }

    private String getWhereCls(RptParams params, StringBuffer purBuffer) throws EASBizException, BOSException {
        StringBuffer queryStr = new StringBuffer();
        String bd = null;
        String ed = null;
        bd = params.getString("dateStart");
        ed = params.getString("dateEnd");
        queryStr.append(" PurRequest.FBizDate").append("  >= {").append(bd).append("} and ").append("PurRequest.FBizDate").append(" <= {").append(ed).append("}");
        queryStr.append(" and PurRequest.fbasestatus IN (4,6)");
        String deliveryDate1 = params.getString("deliveryDateStart");
        String deliveryDate2 = params.getString("deliveryDateEnd");
        if (deliveryDate1 != null) {
            queryStr.append("\r\n and ");
            queryStr.append("OrderEntry.FDeliveryDate  >= {" + deliveryDate1 + "} ");
        }
        if (deliveryDate2 != null) {
            queryStr.append(" and OrderEntry.FDeliveryDate <= {" + deliveryDate2 + " }");
        }
        if (params.getString("PurRequestFrom") != null) {
            queryStr.append(" and PurRequest.FNumber >= '");
            queryStr.append(params.getString("PurRequestFrom"));
            queryStr.append("'");
        }
        if (params.getString("PurRequestTo") != null) {
            queryStr.append(" and PurRequest.FNumber <= '");
            queryStr.append(params.getString("PurRequestTo"));
            queryStr.append("'");
        }
        if (params.getString("MaterialFrom") != null) {
            queryStr.append(" and material.FNumber >= '");
            queryStr.append(params.getString("MaterialFrom"));
            queryStr.append("'");
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = entry.FMATERIALID ");
            }
        }
        if (params.getString("MaterialTo") != null) {
            queryStr.append(" and material.FNumber <= '");
            queryStr.append(params.getString("MaterialTo"));
            queryStr.append("'");
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = entry.FMATERIALID ");
            }
        }
        if (params.getString("bizTypeFrom") != null) {
            queryStr.append(" and BIZTYPE.FNumber >= '");
            queryStr.append(params.getString("bizTypeFrom"));
            queryStr.append("'");
            if (purBuffer.toString().indexOf("T_SCM_BizType") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ");
                purBuffer.append(" ON PurRequest.FBizTypeID = BIZTYPE.FID ");
            }
        }
        if (params.getString("bizTypeTo") != null) {
            queryStr.append(" and BIZTYPE.FNumber <= '");
            queryStr.append(params.getString("bizTypeTo"));
            queryStr.append("'");
            if (purBuffer.toString().indexOf("T_SCM_BizType") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ");
                purBuffer.append(" ON PurRequest.FBizTypeID = BIZTYPE.FID ");
            }
        }
        return queryStr.toString();
    }

    private String getInsertSumTempTb(RptParams params, String tempTable, String whereCls, String link) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(tempTable).append("\r\n");
        sb.append(" SELECT fid,fentryid,").append("\r\n");
        sb.append("        Sum(FTotalPurReceivalQty) FTotalPurReceivalQty,").append("\r\n");
        sb.append("        Sum(FTotalInWarehsQty) FTotalInWarehsQty");
        sb.append("\r\n");
        sb.append("FROM (").append("\r\n");
        sb.append(this.getSQLOnShiping(params, whereCls, link)).append("\r\n");
        sb.append(" UNION ALL ").append("\r\n");
        sb.append(this.getSQLOnIssuing(params, whereCls, link)).append("\r\n");
        sb.append(" ) src ").append("GROUP BY fid,").append("\r\n");
        sb.append("         fentryid");
        return sb.toString();
    }

    private String getSQLOnShiping(RptParams params, String whereCls, String link) {
        StringBuffer sb = new StringBuffer();
        sb.append("               SELECT   PurOrder.fid,").append("\r\n").append("                        OrderEntry.fid fentryid,").append("\r\n").append("                        ISNULL(CASE ").append("                              WHEN OrderEntry.funitid = ReceivalEntry.funitid THEN (CASE WHEN PurReceivalBill.fbasestatus = 4 THEN ReceivalEntry.fqty ELSE (ReceivalEntry.fqty - ReceivalEntry.FReverseQty) END) ").append("\r\n").append("                              ELSE ((CASE WHEN PurReceivalBill.fbasestatus = 4 THEN  ReceivalEntry.fbaseqty ELSE (ReceivalEntry.fbaseqty - ReceivalEntry.FReverseBaseQty) END) / unit.fbaseconvsrate) ").append("\r\n").append("                            END,0) FTotalPurReceivalQty,").append("\r\n").append("                        0 FTotalInWarehsQty").append("\r\n").append("               FROM     T_SM_PurRequest PurRequest").append("\r\n").append("                        INNER JOIN T_SM_PurRequestEntry entry").append("\r\n").append("                        ON PurRequest.fid = entry.fparentid").append("\r\n").append("                        INNER JOIN ").append(params.getString("OrgTempTable")).append(" org ").append("\r\n").append("                        ON PurRequest.FCompanyOrgUnitID = org.fid").append("\r\n").append("                        INNER JOIN T_SM_PurOrderEntry OrderEntry").append("\r\n").append("                        ON (OrderEntry.fsourcebillid = PurRequest.fid").append("\r\n").append("                        AND OrderEntry.fsourcebillentryid = entry.fid)").append("\r\n").append("                        INNER JOIN T_SM_PurOrder PurOrder").append("\r\n").append("                        ON OrderEntry.fparentid = PurOrder.fid").append("\r\n").append("                        INNER JOIN T_IM_PurReceivalEntry ReceivalEntry").append("\r\n").append("                        ON (OrderEntry.fparentid = ReceivalEntry.FPurOrderid").append("\r\n").append("                        AND ReceivalEntry.FPurOrderentryid = OrderEntry.fid)").append("\r\n").append("                        INNER JOIN T_IM_PurReceivalBill PurReceivalBill").append("\r\n").append("                        ON PurReceivalBill.fid = ReceivalEntry.fparentid").append("\r\n").append("                        INNER JOIN t_bd_multimeasureunit unit ").append("\r\n").append("                        ON (ReceivalEntry.fmaterialid = unit.fmaterialid ").append("\r\n").append("                        AND OrderEntry.funitid = unit.fmeasureunitid) ").append("\r\n").append(link).append("\r\n").append(" WHERE    PurReceivalBill.fbasestatus IN (").append(this.splitByComma((String[])params.getObject("baseStatus"))).append(") AND ").append("\r\n").append(whereCls);
        return sb.toString();
    }

    private String getSQLOnIssuing(RptParams params, String whereCls, String link) {
        StringBuffer sb = new StringBuffer();
        sb.append("               SELECT   PurOrder.fid,").append("\r\n").append("                        OrderEntry.fid fentryid,").append("\r\n").append("                        0 FTotalPurReceivalQty,").append("\r\n").append("                        ISNULL(CASE ").append("\r\n").append("                              WHEN OrderEntry.funitid = InWarehsEntry.funitid THEN InWarehsEntry.fqty ").append("\r\n").append("                              ELSE (InWarehsEntry.fbaseqty / unit.fbaseconvsrate) ").append("\r\n").append("                            END,0) FTotalInWarehsQty").append("\r\n").append("\r\n").append("               FROM     T_SM_PurRequest PurRequest").append("\r\n").append("                        INNER JOIN T_SM_PurRequestEntry entry").append("\r\n").append("                                ON PurRequest.fid = entry.fparentid").append("\r\n").append("                        INNER JOIN ").append(params.getString("OrgTempTable")).append(" org ").append("\r\n").append("                                ON PurRequest.FCompanyOrgUnitID = org.fid").append("\r\n").append("                        INNER JOIN T_SM_PurOrderEntry OrderEntry").append("\r\n").append("                                ON (OrderEntry.fsourcebillid = PurRequest.fid").append("\r\n").append("                                    AND OrderEntry.fsourcebillentryid = entry.fid)").append("\r\n").append("                        INNER JOIN T_SM_PurOrder PurOrder").append("\r\n").append("                                ON OrderEntry.fparentid = PurOrder.fid").append("\r\n").append("                        INNER JOIN T_IM_PurInWarehsEntry InWarehsEntry").append("\r\n").append("                                ON (OrderEntry.fparentid = InWarehsEntry.FPurOrderid").append("\r\n").append("                                    AND InWarehsEntry.FPurOrderentryid = OrderEntry.fid)").append("\r\n").append("                        INNER JOIN T_IM_PurInWarehsBill PurInWarehsBill").append("\r\n").append("                                ON PurInWarehsBill.fid = InWarehsEntry.fparentid").append("\r\n").append("                        INNER JOIN t_bd_multimeasureunit unit").append("\r\n").append("                                ON (InWarehsEntry.fmaterialid = unit.fmaterialid").append("\r\n").append("                                    AND OrderEntry.funitid = unit.fmeasureunitid)").append("\r\n").append(link).append("\r\n").append("               WHERE    PurInWarehsBill.fbasestatus IN (").append(this.splitByComma((String[])params.getObject("baseStatus"))).append(") AND ").append("\r\n").append(whereCls);
        return sb.toString();
    }

    public String splitByComma(String[] status) {
        if (status == null) {
            return "99";
        }
        if (status.length > 0) {
            StringBuffer sb = new StringBuffer();
            sb.append(status[0]);
            for (int i = 1; i < status.length; ++i) {
                sb.append(",");
                sb.append(status[i]);
            }
            return sb.toString();
        }
        return null;
    }

    public String transformByComma(String[] status) {
        if (status == null) {
            return "99";
        }
        if (status.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < status.length; ++i) {
                if (i > 0 && i < status.length) {
                    sb.append(",");
                }
                if (status[i].equals("1")) {
                    sb.append(" 1 ");
                    continue;
                }
                if (status[i].equals("2")) {
                    sb.append(" 2 ");
                    continue;
                }
                if (!status[i].equals("4")) continue;
                sb.append(" 3 ");
            }
            return sb.toString();
        }
        return null;
    }

    public String transformByComma2(String[] status) {
        if (status == null) {
            return "99";
        }
        if (status.length > 0) {
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < status.length; ++i) {
                if (i > 0 && i < status.length) {
                    sb.append(",");
                }
                if (status[i].equals("1")) {
                    sb.append(" 10 ");
                    continue;
                }
                if (status[i].equals("2")) {
                    sb.append(" 11 ");
                    continue;
                }
                if (!status[i].equals("4")) continue;
                sb.append(" 12 ");
            }
            return sb.toString();
        }
        return null;
    }

    private String getAllSQL(RptParams params, String tempTable, String sumTempTable) throws EASBizException, BOSException {
        StringBuffer sb = new StringBuffer();
        StringBuffer sbLink = new StringBuffer();
        String whereCls = this.getWhereCls(params, sbLink);
        String link = sbLink.toString();
        sb.append("INSERT INTO ").append(tempTable).append("\r\n").append(" SELECT Newbosid('88888888'),").append("\r\n").append("   PurRequest.fnumber,").append("\r\n").append("   Entry.fseq,").append("\r\n").append("   org.fid,").append("\r\n").append("   Entry.fmaterialid,").append("\r\n").append("   Entry.funitid,").append("\r\n").append("   Entry.fqty,").append("\r\n").append("   PurOrder.fnumber,").append("\r\n").append("   OrderEntry.fseq,").append("\r\n").append("   OrderEntry.fqty ftotalqty,").append("\r\n").append("   OrderEntry.funitid,").append("\r\n").append("   ISNULL(datafrom.FTotalPurReceivalQty,0),").append("\r\n").append("   ISNULL(datafrom.FTotalInWarehsQty,0)").append("\r\n").append(" FROM   T_SM_PurRequest PurRequest ").append("\r\n").append("   INNER JOIN T_SM_PurRequestentry Entry ").append("\r\n").append("       ON PurRequest.fid = Entry.fparentid ").append("\r\n").append("   INNER JOIN ").append(params.getString("OrgTempTable")).append("   org ").append("\r\n").append("       ON PurRequest.FCompanyOrgUnitID = org.fid ").append("\r\n").append("   INNER JOIN T_SM_Purorderentry OrderEntry ").append("\r\n").append("       ON (OrderEntry.fsourcebillid = PurRequest.fid ").append("\r\n").append("       AND OrderEntry.fsourcebillentryid = Entry.fid) ").append("\r\n").append("   INNER JOIN T_SM_Purorder PurOrder ").append("\r\n").append("       ON OrderEntry.fparentid = PurOrder.fid ").append("\r\n").append(link).append("\r\n").append("   LEFT OUTER JOIN ").append(sumTempTable).append(" datafrom ").append("\r\n").append("   ON datafrom.fid = PurOrder.fid ").append("\r\n").append("   AND datafrom.fentryid = OrderEntry.fid ").append("\r\n").append("WHERE ").append(whereCls);
        return sb.toString();
    }

    private void setRPTData(SqlParams sqlParams, RptParams params) {
        int count = sqlParams.size() + 1;
        if (params.getString("PurRequestFrom") != null) {
            sqlParams.setString(count++, params.getString("PurRequestFrom"));
        }
        if (params.getString("PurRequestTo") != null) {
            sqlParams.setString(count++, params.getString("PurRequestFrom"));
        }
        if (params.getString("MaterialFrom") != null) {
            sqlParams.setString(count++, params.getString("SupplierFrom"));
        }
        if (params.getString("MaterialTo") != null) {
            sqlParams.setString(count++, params.getString("MaterialTo"));
        }
        if (params.getString("bizTypeFrom") != null) {
            sqlParams.setString(count++, params.getString("bizTypeFrom"));
        }
        if (params.getString("bizTypeTo") != null) {
            sqlParams.setString(count++, params.getString("bizTypeTo"));
        }
    }

    private RptTableHeader setTableHead(RptTableHeader header, RptParams params, Context ctx) {
        String billNum = this.getServerResource("RequestNumber", ctx);
        String seq = this.getServerResource("Seq", ctx);
        String deliverydate = this.getServerResource("RequestDeliveryDate", ctx);
        String PurOrgName = this.getServerResource("CompanyUnit", ctx);
        String materialNum = this.getServerResource("MaterialNumber", ctx);
        String materialName = this.getServerResource("MaterialName", ctx);
        String materialModel = this.getServerResource("MaterialModel", ctx);
        String baseUnit = this.getServerResource("Unit_PurPricRecord", ctx);
        String qty = this.getServerResource("RequestQty", ctx);
        String orderNumber = this.getServerResource("OrderNumber", ctx);
        String orderseq = this.getServerResource("Seq", ctx);
        String orderQtyUnit = this.getServerResource("OrderEntryQtyUnit", ctx);
        String orderQty = this.getServerResource("OrderEntryQty", ctx);
        String totalPurReceivalQty = this.getServerResource("TotalShippingQty", ctx);
        String totalInWarehsQty = this.getServerResource("TotalPostRequisitionQty", ctx);
        String FCompanyUnitID = "FCompanyUnitID";
        Object[][] labels = new Object[1][23];
        String[] cols = new String[23];
        cols[0] = "RequestNumber";
        cols[1] = "Seq";
        cols[2] = "RequestDeliveryDate";
        cols[5] = "PurOrg";
        cols[6] = "MaterialNum";
        cols[7] = "MaterialName";
        cols[8] = "MaterialMod";
        cols[9] = "Unit";
        cols[10] = "RequestQty";
        cols[13] = "OrderNumber";
        cols[1] = "Seq";
        cols[15] = "OrderEntryQtyUnit";
        cols[14] = "OrderEntryQty";
        cols[17] = "TotalPurReceivalQty";
        cols[18] = "TotalInWarehsQty";
        cols[22] = "PurOrg_ID";
        this.setHeaderColumns(header, cols, params);
        labels[0][0] = billNum;
        labels[0][1] = seq;
        labels[0][2] = deliverydate;
        labels[0][5] = PurOrgName;
        labels[0][6] = materialNum;
        labels[0][7] = materialName;
        labels[0][8] = materialModel;
        labels[0][9] = baseUnit;
        labels[0][10] = qty;
        labels[0][13] = orderNumber;
        labels[0][1] = seq;
        labels[0][14] = orderQty;
        labels[0][15] = orderQtyUnit;
        labels[0][17] = totalPurReceivalQty;
        labels[0][18] = totalInWarehsQty;
        labels[0][22] = FCompanyUnitID;
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) {
        String qtyFormat = RptCellFormatter.getNumberFormat((int)4, (boolean)false);
        String dateFormat = RptCellFormatter.getDateFormat((String)"yyyy-MM-dd");
        RptTableColumn col = null;
        for (int i = 0; i < 23; ++i) {
            col = new RptTableColumn(columns[i]);
            if (i == 2) {
                col.setFormatPattern(dateFormat);
            }
            if (i == 10 || i == 14 || i >= 16 && i <= 21) {
                col.setFormatPattern(qtyFormat);
            }
            header.addColumn(col);
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptRowSet rs = this.executeQuery(this.querySql(params, ctx) + " order by temp.FRequestNumber,temp.FSeq,temp.FCompanyOrgUnitID,temp.FMaterialID", null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private String querySql(RptParams params, Context ctx) {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("TempTableName");
        String orgUnitTempTable = params.getString("OrgTempTable");
        sql.append(" SELECT temp.FRequestNumber,temp.FSeq,temp.FDeliveryDate");
        sql.append("\r\n ,org.fname_").append(locLan).append(" AS CompanyORG_NAME");
        sql.append(",mat.FNumber AS MATERIAL_NUMBER");
        sql.append(",mat.FName_").append(locLan).append(" AS MATERIAL_NAME,mat.FModel AS MATERIAL_MODEL");
        sql.append("\r\n ,UNIT.FName_").append(locLan).append(" AS UNIT_NAME");
        sql.append("\r\n ,temp.FRequestQty QTY");
        sql.append("\r\n ,FOrderNumber OrderNumber");
        sql.append(",temp.ForderQty orderQTY");
        sql.append("\r\n ,UNIT2.FName_");
        sql.append(locLan);
        sql.append(" ORDERUNITNAME");
        sql.append(",temp.FTotalPurReceivalQty");
        sql.append(",temp.TotalInWarehsQty");
        sql.append(",temp.FCompanyOrgUnitID");
        sql.append(" FROM  " + tempTable + " temp \r\n INNER JOIN ");
        sql.append(orgUnitTempTable);
        sql.append(" org ON temp.FCompanyOrgUnitID = org.FID ");
        sql.append("\r\n INNER JOIN T_BD_Currency CURRENCY on temp.FCurrencyID = CURRENCY.FID ");
        sql.append("\r\n INNER JOIN T_BD_Material mat on temp.FMaterialID = mat.FID ");
        sql.append(" \r\n INNER JOIN T_BD_Supplier AS SUPPLIER ON temp.FSupplierID = SUPPLIER.FID ");
        sql.append("\r\n INNER JOIN T_BD_MeasureUnit AS UNIT ON temp.FUnitID = UNIT.FID ");
        sql.append("\r\n INNER JOIN T_BD_MeasureUnit AS UNIT2 ON temp.ForderUnitID = UNIT2.FID ");
        return sql.toString();
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        StringBuffer rsList = new StringBuffer();
        rsList.append("select  temp.fid from " + param.getString("TempTableName"));
        rsList.append(" temp LEFT OUTER JOIN " + param.getString("OrgTempTable"));
        rsList.append(" org ON temp.FCompanyOrgUnitID = org.FID  ");
        rsList.append("\r\n order by temp.FRequestNumber,temp.FSeq,temp.FSupplierID,temp.FCompanyOrgUnitID,temp.FMaterialID");
        rsList.append(" asc ");
        return DbUtil.executeQuery((Context)ctx, (String)rsList.toString());
    }

    public RptParams getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException, EASBizException {
        return this.getDatas(ctx, params, idList, false);
    }

    private RptParams getDatas(Context ctx, RptParams params, List idList, boolean first) throws BOSException {
        String subWhere;
        if (first) {
            subWhere = " ";
        } else {
            StringBuffer fid = new StringBuffer(" where temp.FId IN (  '").append(idList.get(0).toString()).append("'");
            int n = idList.size();
            for (int i = 1; i < n; ++i) {
                fid.append(", '").append(idList.get(i).toString()).append("'");
            }
            fid.append(" )  order by temp.FRequestNumber,temp.FSeq,temp.FSupplierID,temp.FCompanyOrgUnitID,temp.FMaterialID");
            subWhere = fid.toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(this.querySql(params, ctx));
        sql.append(subWhere);
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    protected String getOrgListId(Object[] infos) throws EASBizException {
        StringBuffer OrgunitId = new StringBuffer();
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            Integer fisleaf = (Integer)((FullOrgUnitInfo)infos[i]).get("isleaf");
            if (fisleaf != 1) continue;
            OrgunitId.append(",'" + ((FullOrgUnitInfo)infos[i]).getId().toString() + "'");
        }
        String orgunitListId = new String();
        if (OrgunitId.toString().length() <= 1) {
            throw new SMReportException(SMReportException.NO_ENTITY_STORAGEID);
        }
        orgunitListId = OrgunitId.toString().substring(1, OrgunitId.toString().length());
        return orgunitListId;
    }
}

