/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.eas.basedata.assistant.CurrencyFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.scm.common.util.OrgUnitUtils;
import com.kingdee.eas.scm.common.util.SCMUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.report.app.AbstractSupplierTradeFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.Date;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SupplierTradeFacadeControllerBean
extends AbstractSupplierTradeFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.report.app.SupplierTradeFacadeControllerBean");
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";
    private String leafPurChaseOrgUnitStr = "leafPurChaseOrgUnit";
    private String maxLevelStr = "maxLevelStr";
    private static final String locLan = SysContext.getSysContext().getLocale().getLanguage();

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTable(params.getString("tempTable"), ctx);
        String tempTable = this.getTempTableName(SCMUtils.getResource((String)resClassName, (String)"purPriceWMRptUI", (Context)ctx) + "_derekee", ctx);
        String purChaseUnitTempTable = this.getTempTableName(this.getServerResource("PurchaseORGUintTempTable", ctx), ctx);
        params.setString("tempTable", tempTable);
        params.setString("PurChaseUnitTempTable", purChaseUnitTempTable);
        this.buildPurchaseOrgTable(ctx, purChaseUnitTempTable, params);
        this.createTempTableAndInsertData(ctx, tempTable, params);
        this.updateTotal(ctx, tempTable, purChaseUnitTempTable, params);
        String countSql = "select count(1) cc from " + tempTable;
        if (null != params.getString("queryType") && params.getString("queryType").equals("web")) {
            StringBuffer str = new StringBuffer();
            str.append("select  count(1) cc from ");
            str.append(tempTable).append(" temp ");
            str.append(" INNER JOIN ");
            str.append(purChaseUnitTempTable).append(" org ");
            str.append("on temp.FPurChaseUnitID = org.FID ");
            str.append(" INNER JOIN T_BD_Supplier Supplier ON temp.FSupplierID = Supplier.FID ");
            str.append(" where org.FLevel =1 ");
            countSql = str.toString();
        }
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        try {
            this.setRptHead(header, params, ctx);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        RptParams result = new RptParams();
        result.setString("tempTable", tempTable);
        result.setString("PurChaseUnitTempTable", purChaseUnitTempTable);
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setBoolean("IsSelectStorageORG", params.getBoolean("IsSelectStorageORG"));
        result.setString("StorageOrgunitListId", params.getString("StorageOrgunitListId"));
        return result;
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        boolean isWeek = false;
        Date beginDate = (Date)params.getObject("DateStart");
        Date endDate = (Date)params.getObject("DateEnd");
        String sql = this.getCreateTempTable(tempTable, params);
        this.executeSQL(ctx, sql);
        sql = this.getRptSql(params, tempTable, ctx);
        this.executeUpdate(sql, null, ctx);
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tempTable + "(\r\n");
        sql.append("FID Varchar(44)\r\n");
        sql.append(",FPurChaseUnitID Varchar(44)\r\n");
        sql.append(",FSupplierID Varchar(44)\r\n");
        sql.append(",FFlag varchar(44)\r\n");
        sql.append(",FLevel int");
        sql.append(",FTotalPurAmount Decimal(28,10)\r\n");
        sql.append(",FTotalPurTax Decimal(28,10)\r\n");
        sql.append(",FTotalPurTaxAmount Decimal(28,10)\r\n");
        sql.append(",FTotalReceiptAmount Decimal(28,10)\r\n");
        sql.append(",FTotalReceiptTaxAmount Decimal(28,10)\r\n");
        sql.append(",FTotalInvoicedAmount Decimal(28,10)\r\n");
        sql.append(",FTotalPaidAmount Decimal(28,10)\r\n");
        sql.append(",FTotalReturnTaxAmount Decimal(28,10)\r\n");
        sql.append(");\r\n");
        return sql.toString();
    }

    private String getRptSql(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        String sql = "";
        boolean isSelectStorageORG = false;
        Date beginDate = (Date)params.getObject("DateStart");
        Date endDate = (Date)params.getObject("DateEnd");
        Object[] storageOrg = (Object[])params.getObject("fullStorageOrgUnit");
        StringBuffer storageOrgunitListIds = new StringBuffer();
        StringBuffer storageOrgunitListId = new StringBuffer();
        if (storageOrg != null && storageOrg.length > 0) {
            isSelectStorageORG = true;
            storageOrgunitListId.append(this.getStorageOrgunitListId(storageOrg));
            storageOrgunitListIds.append(this.getpurOrgunitListId(storageOrg));
        }
        if (isSelectStorageORG) {
            params.setString("StorageOrgunitListId", storageOrgunitListId.toString());
        }
        params.setBoolean("IsSelectStorageORG", isSelectStorageORG);
        StringBuffer purOrderbf = new StringBuffer();
        String orgTempTable = params.getString("PurChaseUnitTempTable");
        String purOrderWhere = this.getQueryCondition(params, "purorder", ctx);
        purOrderbf.append("insert into ");
        purOrderbf.append(tableName);
        purOrderbf.append(" SELECT newbosid('88888888')");
        purOrderbf.append(",purdata.FPurchaseOrgUnitID");
        purOrderbf.append(",purdata.FsupplierID");
        purOrderbf.append(",'DEL',purchase.Flevel");
        purOrderbf.append("\r\n,sum(purdata.FLocalAmount)");
        purOrderbf.append(",sum(purdata.FLocalTax)");
        purOrderbf.append(",sum(purdata.FLocalTaxAmount)");
        purOrderbf.append("\r\n,sum(purdata.purInLocalAmt)");
        purOrderbf.append("\r\n,sum(purdata.purInLocalTaxAmt)");
        purOrderbf.append("\r\n,decimal(sum(decimal(purdata.FtotalInvoicedAmount*(case when purdata.FConvertMode=0 then ");
        purOrderbf.append("purdata.FExchangeRate else decimal(1/purdata.FExchangeRate,17,4) end),17,4)),17,4)");
        purOrderbf.append("\r\n,decimal(sum(decimal(purdata.FTotalPaidAmount");
        purOrderbf.append("*(case when purdata.FConvertMode=0 then purdata.FExchangeRate else decimal(1/purdata.FExchangeRate,17,4) end),17,4)),17,4)");
        purOrderbf.append("\r\n,decimal(sum(decimal(purdata.FTotalCancelledStockQty*purdata.FActualTaxPrice,17,4)");
        purOrderbf.append("*(case when purdata.FConvertMode=0 then ");
        purOrderbf.append("purdata.FExchangeRate else decimal(1/purdata.FExchangeRate,17,4) end)),17,4)");
        purOrderbf.append("\r\n FROM (");
        purOrderbf.append("\r\n SELECT purInTmp.purInLocalAmt,purInTmp.purInLocalTaxAmt,");
        purOrderbf.append("\r\n entry.FStorageOrgUnitID,purorder.Fbasestatus,purorder.FBizDate,purorder.FPurchaseOrgUnitID,");
        purOrderbf.append("\r\n purorder.FsupplierID,entry.FLocalAmount,entry.FLocalTax,entry.FLocalTaxAmount");
        purOrderbf.append("\r\n ,entry.FTotalReceiptQty,entry.FActualPrice,entry.FActualTaxPrice,purorder.FConvertMode,purorder.FExchangeRate");
        purOrderbf.append("\r\n ,entry.FtotalInvoicedAmount,entry.FTotalPaidAmount,entry.FTotalCancelledStockQty,purorder.FIsSysBill");
        purOrderbf.append("\r\n FROM t_sm_purorder purorder");
        purOrderbf.append("\r\n INNER JOIN t_sm_purorderentry  entry on purorder.fid = entry.fparentid");
        purOrderbf.append("\r\n left join (select entry.fid, sum(isnull(pen.flocaltaxamount,0) - isnull(pen.flocaltax,0)) as purInLocalAmt, ");
        purOrderbf.append("\r\n     sum(isnull(pen.flocaltaxamount,0)) as purInLocalTaxAmt from t_sm_purorder purorder");
        purOrderbf.append("\r\n     INNER JOIN t_sm_purorderentry  entry on purorder.fid = entry.fparentid");
        purOrderbf.append("\r\n     INNER JOIN t_im_purinwarehsentry pen on pen.fpurorderentryid = entry.fid");
        purOrderbf.append("\r\n     INNER JOIN t_im_purinwarehsbill pbill on pbill.fid = pen.fparentid");
        purOrderbf.append("\r\n     INNER JOIN " + orgTempTable + " purchase on purorder.FPurchaseOrgUnitID = purchase.FID ");
        purOrderbf.append("\r\n \tINNER JOIN T_BD_Supplier Supplier ON purorder.FSupplierID = Supplier.FID ");
        purOrderbf.append("\r\n \twhere pbill.fbasestatus = 4 and ").append(purOrderWhere);
        purOrderbf.append("\r\n\t\tgroup by entry.fid");
        purOrderbf.append("\r\n ) as purInTmp on purInTmp.fid = entry.fid");
        purOrderbf.append("\r\n UNION ALL ");
        purOrderbf.append("\r\n SELECT decimal(0,17,4) as purInLocalAmt,decimal(0,17,4) as purInLocalTaxAmt");
        purOrderbf.append("\r\n ,entry.FStorageOrgUnitID,purReturns.Fbasestatus,purReturns.FBizDate,purReturns.FPurchaseOrgUnitID,purReturns.FsupplierID,decimal(0,17,4) as FLocalAmount,decimal(0,17,4) as FLocalTax,decimal(0,17,4) as FLocalTaxAmount");
        purOrderbf.append("\r\n ,decimal(0,17,4) as FTotalReceiptQty,decimal(0,17,4) as FActualPrice,FTaxPrice as FActualTaxPrice,purReturns.FConvertMode,purReturns.FExchangeRate");
        purOrderbf.append("\r\n ,-1*entry.FinvoicedAmount as FtotalInvoicedAmount,-1*entry.FTotalReturnAmt as FTotalPaidAmount,entry.FReturnedQty as FTotalCancelledStockQty,purReturns.FIsSysBill");
        purOrderbf.append("\r\n FROM T_SM_PurReturns purReturns");
        purOrderbf.append("\r\n INNER JOIN T_SM_PurReturnsEntry  entry on purReturns.fid = entry.fparentid ");
        purOrderbf.append("where fpurOrderNumber is null \r\n ");
        purOrderbf.append(") purdata \r\n ");
        purOrderbf.append("\r\n left outer join T_ORG_Storage Storage on purdata.FStorageOrgUnitID = Storage.FID ");
        purOrderbf.append("\r\n INNER JOIN T_BD_Supplier Supplier ON purdata.FSupplierID = Supplier.FID ");
        purOrderbf.append("\r\n INNER JOIN " + orgTempTable + " purchase on purdata.FPurchaseOrgUnitID = purchase.FID ");
        String purOrderStr = this.getQueryCondition(params, "purdata", ctx);
        if (isSelectStorageORG) {
            purOrderStr = purOrderStr + " and Storage.Fid in (" + storageOrgunitListIds.toString() + ")";
        }
        sql = purOrderbf.toString() + "\r\n where " + purOrderStr + "\r\n group by purdata.FPurchaseOrgUnitID,purdata.FsupplierID,purchase.Flevel";
        return sql;
    }

    private String getQueryCondition(RptParams params, String purName, Context ctx) throws EASBizException, BOSException {
        StringBuffer queryStr = new StringBuffer();
        String bd = null;
        String ed = null;
        bd = params.getString("dateStart");
        ed = params.getString("dateEnd");
        if ("true".equals(params.getObject("IsBlock").toString())) {
            queryStr.append(" (" + purName + ".Fbasestatus =4 or ");
            queryStr.append(purName + ".Fbasestatus = 7 or ");
            queryStr.append(purName + ".Fbasestatus = 6 ) and ");
        } else {
            queryStr.append(" (" + purName + ".Fbasestatus =4 or ");
            queryStr.append(purName + ".Fbasestatus = 7 ) and ");
            queryStr.append(purName + ".Fbasestatus <> 6  and ");
        }
        queryStr.append(purName + ".FBizDate  >= {" + bd + "} and ");
        queryStr.append(purName + ".FBizDate <= {" + ed + "}");
        if (params.getObject("SupplierFrom") != null) {
            String[] numArray = SCMUtil.getF7Numbers((Object)params.getObject("SupplierFrom"));
            if (numArray[0] != null) {
                queryStr.append(" and Supplier.FNumber >= '").append(numArray[0]).append("'");
            } else if (numArray[1] != null) {
                queryStr.append(" and Supplier.FNumber in (").append(numArray[1]).append(")");
            }
        }
        if (params.getString("SupplierTo") != null) {
            queryStr.append(" and Supplier.FNumber <= '").append(params.getString("SupplierTo")).append("'");
        }
        return queryStr.toString();
    }

    private void updateTotal(Context ctx, String tempTable, String orgTable, RptParams params) throws BOSException {
        StringBuffer sql = new StringBuffer();
        int level = (Integer)params.getObject(this.maxLevelStr);
        sql.append("insert into " + tempTable);
        sql.append(" SELECT  newbosid('88888888'),org.fparentid");
        sql.append(",temp.FSupplierID,'NODEL',org.flevel ");
        sql.append(",CASE WHEN sum(FTotalPurAmount) IS NULL THEN 0 ELSE sum(FTotalPurAmount) END");
        sql.append(",CASE WHEN sum(FTotalPurTax) IS NULL THEN 0 ELSE sum(FTotalPurTax) END");
        sql.append(",CASE WHEN sum(FTotalPurTaxAmount) IS NULL THEN 0 ELSE sum(FTotalPurTaxAmount) END");
        sql.append(",CASE WHEN sum(FTotalReceiptAmount) IS NULL THEN 0 ELSE sum(FTotalReceiptAmount) END");
        sql.append(",CASE WHEN sum(FTotalReceiptTaxAmount) IS NULL THEN 0 ELSE sum(FTotalReceiptTaxAmount) END");
        sql.append(",CASE WHEN sum(FTotalInvoicedAmount) IS NULL THEN 0 ELSE sum(FTotalInvoicedAmount) END");
        sql.append(",CASE WHEN sum(FTotalPaidAmount) IS NULL THEN 0 ELSE sum(FTotalPaidAmount) END");
        sql.append(",CASE WHEN sum(FTotalReturnTaxAmount) IS NULL THEN 0 ELSE sum(FTotalReturnTaxAmount) END");
        sql.append(" from  " + tempTable + " temp");
        sql.append(" inner join ");
        sql.append(orgTable).append(" org on temp.FPurChaseUnitID = org.fid and org.flevel = ");
        String sqle = new String();
        for (int i = level; i > 1; --i) {
            sqle = sql.toString() + i + " group by temp.FSupplierID,org.fparentid,org.flevel ";
            this.executeSQL(ctx, sqle);
        }
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    private RptTableHeader setRptHead(RptTableHeader header, RptParams params, Context ctx) throws Exception {
        String SUPPLIER_NUMBER = this.getServerResource("SupplierNumber", ctx);
        String SUPPLIER_NAME = this.getServerResource("supplierNameABC", ctx);
        String PURCHASE_NAME = this.getServerResource("PurchaseUnit", ctx);
        String FTotalPurAmount = this.getServerResource("FTotalPurAmount", ctx);
        String FTotalPurTax = this.getServerResource("FTotalPurTax", ctx);
        String FTotalPurTaxAmount = this.getServerResource("FTotalPurTaxAmount", ctx);
        String FTotalReceiptAmount = this.getServerResource("FTotalReceiptAmount", ctx);
        String FTotalReceiptTaxAmount = this.getServerResource("FTotalReceiptTaxAmount", ctx);
        String FTotalInvoicedAmount = this.getServerResource("FTotalInvoicedAmount", ctx);
        String FTotalPaidAmount = this.getServerResource("FTotalPaidAmount", ctx);
        String FTotalReturnTaxAmount = this.getServerResource("FTotalReturnTaxAmount", ctx);
        String FPurChaseUnitID = "FPurChaseUnitID";
        String PURCHASEORG_ISLEAF = "FStorageOrgUnitID";
        String PURCHASEORG_LEVEL = "FSupplierID";
        String FStorageOrgUnitID = "FStorageOrgUnitID";
        String FSupplierID = "FSupplierID";
        Object[][] labels = new Object[1][15];
        String[] cols = new String[]{"STORAGE_NUMBER", "SUPPLIER_NAME", "PURCHASE_NAME", "FTotalPurAmount", "FTotalPurTax", "FTotalPurTaxAmount", "FTotalReceiptAmount", "FTotalReceiptTaxAmount", "FTotalInvoicedAmount", "FTotalPaidAmount", "FTotalReturnTaxAmount", "FPurChaseUnitID", "PURCHASEORG_ISLEAF", "PURCHASEORG_LEVEL", "FSupplierID"};
        this.setHeaderColumns(header, cols, params);
        labels[0][0] = SUPPLIER_NUMBER;
        labels[0][1] = SUPPLIER_NAME;
        labels[0][2] = PURCHASE_NAME;
        labels[0][3] = FTotalPurAmount;
        labels[0][4] = FTotalPurTax;
        labels[0][5] = FTotalPurTaxAmount;
        labels[0][6] = FTotalReceiptAmount;
        labels[0][7] = FTotalReceiptTaxAmount;
        labels[0][8] = FTotalInvoicedAmount;
        labels[0][9] = FTotalPaidAmount;
        labels[0][10] = FTotalReturnTaxAmount;
        labels[0][11] = FPurChaseUnitID;
        labels[0][12] = PURCHASEORG_ISLEAF;
        labels[0][13] = PURCHASEORG_LEVEL;
        labels[0][14] = FSupplierID;
        header.setLabels(labels, true);
        return header;
    }

    private void setExchangeRate(RptParams param) throws Exception {
        int precision = 2;
        CompanyOrgUnitInfo ficompanyOrgInfo = SysContext.getSysContext().getCurrentFIUnit();
        if (ficompanyOrgInfo != null && ficompanyOrgInfo.getBaseCurrency() != null) {
            CurrencyInfo baseCurrInfo = CurrencyFactory.getRemoteInstance().getCurrencyInfo((IObjectPK)new ObjectUuidPK(ficompanyOrgInfo.getBaseCurrency().getId()));
            precision = baseCurrInfo.getPrecision();
        }
        param.setInt("Precision", precision);
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) throws Exception {
        this.setExchangeRate(params);
        String prcFormat = this.getFormatPattern(params.getInt("Precision"));
        RptTableColumn col = null;
        int c = 15;
        for (int i = 0; i < c; ++i) {
            col = new RptTableColumn(columns[i]);
            if (i <= 2) {
                col.setWidth(-1);
            } else if (i < 11) {
                col.setWidth(120);
                col.setAligment(2);
                col.setFormatPattern(prcFormat);
            } else {
                col.setHided(true);
            }
            if (col.getName().equals("FSupplierID")) {
                col.setWidth(-1);
                col.setHided(true);
            }
            if (col.getName().equals("PURCHASEORG_ISLEAF")) {
                col.setWidth(-1);
                col.setHided(true);
            }
            if (col.getName().equals("PURCHASEORG_LEVEL")) {
                col.setWidth(-1);
                col.setHided(true);
            }
            if (col.getName().equals("FPurChaseUnitID")) {
                col.setWidth(-1);
                col.setHided(true);
            }
            header.addColumn(col);
        }
    }

    private String querySql(RptParams params, Context ctx) {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String purChaseUnitTempTable = params.getString("PurChaseUnitTempTable");
        sql.append(" SELECT Supplier.FNumber,Supplier.FName_").append(ctx.getLocale().getLanguage());
        sql.append(" AS SUPPLIER_NAME");
        sql.append(",org.FName_").append(ctx.getLocale().getLanguage());
        sql.append(" AS PURCHASE_NAME");
        sql.append(",temp.FTotalPurAmount AS FTotalPurAmount");
        sql.append(",temp.FTotalPurTax AS FTotalPurTax");
        sql.append(",temp.FTotalPurTaxAmount AS FTotalPurTaxAmount");
        sql.append(",temp.FTotalReceiptAmount AS FTotalReceiptAmount");
        sql.append(",temp.FTotalReceiptTaxAmount AS FTotalReceiptTaxAmount");
        sql.append(",temp.FTotalInvoicedAmount AS FTotalInvoicedAmount");
        sql.append(",temp.FTotalPaidAmount AS FTotalPaidAmount");
        sql.append(",temp.FTotalReturnTaxAmount AS FTotalReturnTaxAmount");
        sql.append(",temp.FPurChaseUnitID AS FPurChaseUnitID");
        if (null != params.getString("queryType") && params.getString("queryType").equals("web")) {
            sql.append(",org.FIsleaf AS PURCHASEORG_ISLEAF");
            sql.append(",org.FLevel AS PURCHASEORG_LEVEL");
            sql.append(",org.FParentID AS PURCHASEORG_PARENT");
        } else {
            sql.append(",org.FIsleaf AS PURCHASEORG_ISLEAF");
            sql.append(",org.FLevel AS PURCHASEORG_LEVEL");
        }
        sql.append(",temp.FSupplierID AS FSupplierID");
        sql.append(" from  " + tempTable + " temp ");
        sql.append(" INNER JOIN " + purChaseUnitTempTable + " org on temp.FPurChaseUnitID = org.FID ");
        sql.append(" INNER JOIN T_BD_Supplier Supplier ON temp.FSupplierID = Supplier.FID ");
        return sql.toString();
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptRowSet rs = this.executeQuery(this.querySql(params, ctx) + "where org.FLevel =1 order by Supplier.FNumber", null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        String rsList = "select  temp.fid from " + param.getString("tempTable") + " temp INNER JOIN T_BD_Supplier Supplier ON temp.FSupplierID = Supplier.FID  inner join " + param.getString("PurChaseUnitTempTable") + " org  on temp.FPurChaseUnitID = org.FID  where org.flevel = 1  order by Supplier.FNumber";
        return DbUtil.executeQuery((Context)ctx, (String)rsList);
    }

    protected RptParams _findData(Context ctx, RptParams param, int start, int count, String tempTableName, Object treeTypeObject) throws BOSException, EASBizException {
        RptRowSet rs;
        String sql = "";
        if (start <= -1 && count <= -1) {
            sql = this.querySql(param, ctx) + " where  temp.FSupplierID = '" + param.getString("FSupplierID") + "' and org.fparentid='" + param.getString("fparentid") + "'";
            rs = this.executeQuery(sql, null, ctx);
        } else {
            sql = this.querySql(param, ctx) + " where temp.FSupplierID = '" + param.getString("fparentid") + "' and org.fparentid='" + param.getString("fparentid") + "'";
            rs = this.executeQuery(sql, null, start, count, ctx);
        }
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    public RptParams getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException, EASBizException {
        return this.getDatas(ctx, params, idList, false);
    }

    private RptParams getDatas(Context ctx, RptParams params, List idList, boolean first) throws BOSException {
        String subWhere;
        String orgTempTable = params.getString("PurChaseUnitTempTable");
        String TempTable = params.getString("tempTable");
        if (first) {
            subWhere = "where org.flevel = 1 order by Supplier.FNumber";
        } else {
            StringBuffer fid = new StringBuffer("where temp.FId IN (  '").append(idList.get(0).toString()).append("'");
            int n = idList.size();
            for (int i = 1; i < n; ++i) {
                fid.append(", '").append(idList.get(i).toString()).append("'");
            }
            fid.append(" ) ");
            subWhere = fid.toString() + " order by Supplier.FNumber";
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT Supplier.FNumber,Supplier.FName_").append(ctx.getLocale().getLanguage());
        sql.append(" AS SUPPLIER_NAME");
        sql.append(",org.FName_").append(ctx.getLocale().getLanguage());
        sql.append(" AS PURCHASE_NAME");
        sql.append(",temp.FTotalPurAmount AS FTotalPurAmount");
        sql.append(",temp.FTotalPurTax AS FTotalPurTax");
        sql.append(",temp.FTotalPurTaxAmount AS FTotalPurTaxAmount");
        sql.append(",temp.FTotalReceiptAmount AS FTotalReceiptAmount");
        sql.append(",temp.FTotalReceiptTaxAmount AS FTotalReceiptTaxAmount");
        sql.append(",temp.FTotalInvoicedAmount AS FTotalInvoicedAmount");
        sql.append(",temp.FTotalPaidAmount AS FTotalPaidAmount");
        sql.append(",temp.FTotalReturnTaxAmount AS FTotalReturnTaxAmount");
        sql.append(",temp.FPurChaseUnitID AS FPurChaseUnitID");
        sql.append(",org.FIsleaf AS PURCHASEORG_ISLEAF");
        sql.append(",org.FLevel AS PURCHASEORG_LEVEL");
        sql.append(",temp.FSupplierID AS FSupplierID");
        sql.append(" from  " + TempTable + " temp ");
        sql.append(" INNER JOIN " + orgTempTable + " org on temp.FPurChaseUnitID = org.FID ");
        sql.append(" INNER JOIN T_BD_Supplier Supplier ON temp.FSupplierID = Supplier.FID ");
        RptRowSet rs = this.executeQuery(sql.append(subWhere).toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    @Override
    protected int _check_Currency_unique(Context ctx, RptParams params) throws BOSException, EASBizException {
        StringBuffer sql = new StringBuffer();
        Object[] purChaseOrg = (Object[])params.getObject("fullPurchaseOrgUnit");
        String purOrgunitListId = this.getpurOrgunitListId(purChaseOrg);
        sql.append(" select currency.fid,count(currency.fid) ");
        sql.append(" from ( ");
        sql.append(" select r.FToUnitID FToUnitID ");
        sql.append(" from T_ORG_purchase pur,T_ORG_UnitRelation r,T_ORG_TypeRelation t  ");
        sql.append(" where pur.FID=r.FFromUnitID and r.FTypeRelationID=t.FID and t.FFromType=3 and t.FToType=1");
        sql.append(" and pur.FID in (" + purOrgunitListId + ")");
        sql.append(" ) kk ");
        sql.append(" inner join T_ORG_company company on kk.FToUnitID = company.fid ");
        sql.append(" inner join T_bd_currency currency on company.FBaseCurrencyID = currency.fid ");
        sql.append(" group by currency.fid ");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        return rs.getRowCount();
    }

    protected String getpurOrgunitListId(Object[] infos) {
        StringBuffer purOrgunitId = new StringBuffer();
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            boolean fisleaf = (Boolean)((FullOrgUnitInfo)infos[i]).get("isleaf");
            if (!fisleaf) continue;
            purOrgunitId.append(",'" + ((FullOrgUnitInfo)infos[i]).getId().toString() + "'");
        }
        String purOrgunitListId = purOrgunitId.toString().substring(1, purOrgunitId.toString().length());
        return purOrgunitListId;
    }

    protected String getStorageOrgunitListId(Object[] infos) {
        StringBuffer storageOrgunitId = new StringBuffer();
        int n = infos.length;
        for (int i = 0; i < n; ++i) {
            boolean fisleaf = (Boolean)((FullOrgUnitInfo)infos[i]).get("isleaf");
            if (!fisleaf) continue;
            storageOrgunitId.append("," + ((FullOrgUnitInfo)infos[i]).getId().toString());
        }
        String purOrgunitListId = storageOrgunitId.toString().substring(1, storageOrgunitId.toString().length());
        return purOrgunitListId;
    }

    private void buildPurchaseOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + orgTempTable + " (");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("fname_");
        sqlbf.append(ctx.getLocale().getLanguage());
        sqlbf.append(" varchar(255),");
        sqlbf.append("fLongNumber varchar(255),");
        sqlbf.append("fparentid varchar(44),");
        sqlbf.append("flevel int,");
        sqlbf.append("fisleaf int");
        sqlbf.append(")");
        this.executeSQL(ctx, sqlbf.toString());
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] purChaseOrg = (Object[])params.getObject("fullPurchaseOrgUnit");
        purChaseOrg = OrgUnitUtils.getPermissionOrg((Context)ctx, (Object[])purChaseOrg, (String)"supplierTrade_view");
        String[] sql = new String[purChaseOrg.length];
        int n = purChaseOrg.length;
        for (int i = 0; i < n; ++i) {
            sqlbf.delete(0, sqlbf.length());
            String fid = ((FullOrgUnitInfo)purChaseOrg[i]).get("id").toString();
            Integer flevel = (Integer)((FullOrgUnitInfo)purChaseOrg[i]).get("level");
            String fname = (String)((FullOrgUnitInfo)purChaseOrg[i]).get("name");
            String fLongNumber = (String)((FullOrgUnitInfo)purChaseOrg[i]).get("longnumber");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)purChaseOrg[i]).get("parent");
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)purChaseOrg[i]).get("isleaf");
            int fisleaf = isleaf != false ? 1 : 0;
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            sqlbf.append("insert into " + orgTempTable + "(");
            sqlbf.append("fid,fname_");
            sqlbf.append(ctx.getLocale().getLanguage());
            sqlbf.append(",fLongNumber,fparentid,flevel,fisleaf) ");
            sqlbf.append("values(");
            sqlbf.append("'" + fid + "',");
            if (fname != null) {
                sqlbf.append("'" + fname + "',");
            } else {
                sqlbf.append("null,");
            }
            if (fLongNumber != null) {
                sqlbf.append("'" + fLongNumber + "',");
            } else {
                sqlbf.append("null,");
            }
            if (parent != null) {
                sqlbf.append("'" + parent.getId().toString() + "',");
            } else {
                sqlbf.append("null,");
            }
            sqlbf.append(flevel + ",");
            sqlbf.append(fisleaf + ") ");
            sql[i] = sqlbf.toString();
        }
        this.executeBatchUpdate(ctx, sql);
        params.setObject(this.leafPurChaseOrgUnitStr, (Object)v.toArray());
        params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
    }

    @Override
    protected String _getOrgEntityIDS(Context ctx, RptParams params, String orgUnitID) throws BOSException, EASBizException {
        String longNumbersql = " select flongnumber  from " + params.getString("PurChaseUnitTempTable") + " where fid ='" + orgUnitID + "'";
        RptRowSet rs = this.executeQuery(longNumbersql.toString(), null, ctx);
        StringBuffer orgUnitIDS = new StringBuffer();
        if (rs.next()) {
            String longNumber = rs.getString("flongnumber");
            String iDSsql = " select fid from " + params.getString("PurChaseUnitTempTable") + " where   (flongnumber like  '" + longNumber + "!%' or flongnumber = '" + longNumber + "') and fisleaf =1";
            RptRowSet rs_new = this.executeQuery(iDSsql, null, ctx);
            while (rs_new.next()) {
                orgUnitIDS.append(rs_new.getString("fid"));
                orgUnitIDS.append(",");
            }
            if (orgUnitIDS.length() == 0) {
                return orgUnitID;
            }
            return orgUnitIDS.toString().substring(0, orgUnitIDS.toString().length() - 1);
        }
        return null;
    }

    private String getFormatPattern(int scale) {
        String pattern = null;
        String temp = "000000000000000000";
        String end = temp.substring(0, scale);
        pattern = scale == 0 ? "#,##0" : "#,##0." + end;
        pattern = pattern + ";-" + pattern + ";" + pattern + ";";
        return pattern;
    }
}

