/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.sc.report.app;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.basedata.org.FullOrgUnitInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.client.SysContext;
import com.kingdee.eas.framework.report.util.RptCellFormatter;
import com.kingdee.eas.framework.report.util.RptParams;
import com.kingdee.eas.framework.report.util.RptRowSet;
import com.kingdee.eas.framework.report.util.RptTableColumn;
import com.kingdee.eas.framework.report.util.RptTableHeader;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.sc.report.app.AbstractSubMaterialTotalBillRpFacadeControllerBean;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.util.List;
import java.util.Vector;
import org.apache.log4j.Logger;

public class SubMaterialTotalBillRpFacadeControllerBean
extends AbstractSubMaterialTotalBillRpFacadeControllerBean {
    private static Logger logger = Logger.getLogger((String)"com.kingdee.eas.scm.sm.sc.report.app.SubMaterialTotalBillRpFacadeControllerBean");
    private String purChaseUnitTempTableStr = "PurChaseUnitTempTable";
    private String leafPurChaseOrgUnitStr = "leafPurChaseOrgUnit";
    private String maxLevelStr = "maxLevelStr";
    boolean isReceivale = true;
    private static final String resClassName = "com.kingdee.eas.scm.sm.report.SMReportResource";
    private static final String locLan = SysContext.getSysContext().getLocale().getLanguage();

    protected RptParams _createTempTable(Context ctx, RptParams params) throws BOSException, EASBizException {
        this.dropTempTable(params.getString("tempTable"), ctx);
        this.dropTempTable(params.getString("PurChaseUnitTempTable"), ctx);
        if (params.getBoolean("IsInWarehs")) {
            this.isReceivale = false;
        }
        this.buildStorageOrgTable(ctx, "purChaseUnitTempTable", params);
        this.createTempTableAndInsertData(ctx, "tempTable", params);
        String countSql = "select count(1) cc from " + params.getString("tempTable");
        RptRowSet rs = this.executeQuery(countSql, null, ctx);
        rs.next();
        int count = rs.getInt(0);
        RptTableHeader header = new RptTableHeader();
        this.setPurOrderRptHead(header, params, ctx);
        RptParams result = new RptParams();
        result.setString("tempTable", params.getString("tempTable"));
        result.setObject("header", (Object)header);
        result.setInt("verticalCount", count);
        result.setString(this.purChaseUnitTempTableStr, params.getString("PurChaseUnitTempTable"));
        return result;
    }

    private void buildStorageOrgTable(Context ctx, String orgTempTable, RptParams params) throws BOSException {
        StringBuffer sqlbf = new StringBuffer();
        sqlbf.append("create table " + orgTempTable + " (");
        sqlbf.append("fid varchar(44),");
        sqlbf.append("fname_");
        sqlbf.append(locLan);
        sqlbf.append(" varchar(100),");
        sqlbf.append("fparentid varchar(44),");
        sqlbf.append("flevel int,");
        sqlbf.append("fisleaf int");
        sqlbf.append(")");
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            String tableName = pool.createTempTable(sqlbf.toString());
            params.remove("purChaseUnitTempTable");
            params.setString("purChaseUnitTempTable", tableName);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        Vector<String> v = new Vector<String>();
        int maxLevel = 0;
        Object[] purChaseOrg = (Object[])params.getObject("fullOrgUnit");
        String[] sql = new String[purChaseOrg.length];
        int n = purChaseOrg.length;
        for (int i = 0; i < n; ++i) {
            sqlbf.delete(0, sqlbf.length());
            String fid = ((FullOrgUnitInfo)purChaseOrg[i]).get("id").toString();
            Integer flevel = (Integer)((FullOrgUnitInfo)purChaseOrg[i]).get("level");
            String fname = (String)((FullOrgUnitInfo)purChaseOrg[i]).get("name");
            FullOrgUnitInfo parent = (FullOrgUnitInfo)((FullOrgUnitInfo)purChaseOrg[i]).get("parent");
            Boolean isleaf = (Boolean)((FullOrgUnitInfo)purChaseOrg[i]).get("isleaf");
            int fisleaf = isleaf != false ? 1 : 0;
            if (fisleaf == 1) {
                v.add(fid);
            }
            if (flevel > maxLevel) {
                maxLevel = flevel;
            }
            sqlbf.append("insert into " + params.getString("purChaseUnitTempTable") + "(");
            sqlbf.append("fid,fname_");
            sqlbf.append(locLan);
            sqlbf.append(",fparentid,flevel,fisleaf) ");
            sqlbf.append("values(");
            sqlbf.append("'" + fid + "',");
            if (fname != null) {
                sqlbf.append("'" + fname + "',");
            } else {
                sqlbf.append("null,");
            }
            if (parent != null) {
                sqlbf.append("'" + parent.getId().toString() + "',");
            } else {
                sqlbf.append("null,");
            }
            sqlbf.append(flevel + ",");
            sqlbf.append(fisleaf + ") ");
            sql[i] = sqlbf.toString();
        }
        this.executeBatchUpdate(ctx, sql);
        params.setObject(this.leafPurChaseOrgUnitStr, (Object)v.toArray());
        params.setObject(this.maxLevelStr, (Object)new Integer(maxLevel));
    }

    private void createTempTableAndInsertData(Context ctx, String tempTable, RptParams params) throws BOSException, EASBizException {
        String sql = this.getCreateTempTable(tempTable, params);
        TempTablePool pool = TempTablePool.getInstance((Context)ctx);
        try {
            String tableName = pool.createTempTable(sql.toString());
            params.remove("tempTable");
            params.setString("tempTable", tableName);
        }
        catch (Exception e) {
            logger.error((Object)e);
        }
        SqlParams sqlParams = new SqlParams();
        this.setRPTData(sqlParams, params);
        sql = this.getSubOrderRptSql(params, tempTable, ctx);
        this.executeUpdate(sql, sqlParams, ctx);
    }

    private String getCreateTempTable(String tempTable, RptParams params) {
        StringBuffer sql = new StringBuffer();
        sql.append("Create Table " + tempTable + "(\r\n");
        sql.append("FID Varchar(44) \r\n");
        sql.append(",FSuborderNumber Varchar(88) \r\n");
        sql.append(",FSupplierID Varchar(44)\r\n");
        sql.append(",FProcessMaterialID Varchar(44)\r\n");
        sql.append(",FProAssisPropertyID Varchar(44)\r\n");
        sql.append(",FMaterialID Varchar(44)\r\n");
        sql.append(",FAssisPropertyID Varchar(44)\r\n");
        sql.append(",FBaseUnitID Varchar(44)\r\n");
        sql.append(",FQtyRate Decimal(28,10)\r\n");
        sql.append(",FLossRate Decimal(28,10) \r\n");
        sql.append(",FQty Decimal(28,10) \r\n");
        sql.append(",FStorageOrgUnitID Decimal(28,10) \r\n");
        sql.append(",FTotalIssueQty Decimal(28,10) \r\n");
        sql.append(",FQty Decimal(28,10) \r\n");
        sql.append(",FUnIssueQty Decimal(28,10) \r\n");
        sql.append(");\r\n");
        return sql.toString();
    }

    private void setRPTData(SqlParams sqlParams, RptParams params) {
        int count = sqlParams.size() + 1;
        if (params.getString("materialFrom") != null) {
            sqlParams.setString(count++, params.getString("materialFrom"));
        }
        if (params.getString("materialTo") != null) {
            sqlParams.setString(count++, params.getString("materialTo"));
        }
        if (params.getString("SupplierFrom") != null) {
            sqlParams.setString(count++, params.getString("SupplierFrom"));
        }
        if (params.getString("SupplierTo") != null) {
            sqlParams.setString(count++, params.getString("SupplierTo"));
        }
        if (params.getString("BiztypeFrom") != null) {
            sqlParams.setString(count++, params.getString("BiztypeFrom"));
        }
        if (params.getString("BiztypeTo") != null) {
            sqlParams.setString(count++, params.getString("BiztypeTo"));
        }
    }

    private String getSubOrderRptSql(RptParams params, String tableName, Context ctx) throws BOSException, EASBizException {
        String sql = "";
        StringBuffer subOrderBuffer = new StringBuffer();
        StringBuffer selectStr = new StringBuffer();
        selectStr.append("INSERT INTO ");
        selectStr.append(tableName);
        selectStr.append(" \r\n SELECT");
        selectStr.append(" \r\n  newbosid('88888888'),SUBORDER.FNumber");
        selectStr.append(" \r\n ,SUBORDER.FSupplierID");
        selectStr.append(" \r\n  ,SubMaterialList.FMaterialID,SubMaterialList.FBaseUnitID");
        selectStr.append(" \r\n  ,sum(SubMaterialList.FBaseQty)");
        if (this.isReceivale) {
            selectStr.append(" \r\n ,sum(Receivalentry.FBaseQty )");
            selectStr.append(" \r\n ,sum(Receivalentry.FBaseQty - 5 )");
        } else {
            selectStr.append(" \r\n ,sum(InWarehsentry.FBaseQty )");
            selectStr.append(" \r\n ,sum(InWarehsentry.FBaseQty - 5 )");
        }
        subOrderBuffer.append(selectStr);
        subOrderBuffer.append("\r\n FROM T_SM_SubContractOrder AS SUBORDER");
        subOrderBuffer.append("\r\n  INNER JOIN T_SM_SubContractOrderEntry AS ENTRIES");
        subOrderBuffer.append(" ON SUBORDER.FID = ENTRIES.FParentID");
        subOrderBuffer.append("\r\n  INNER JOIN T_SM_SubMaterialList AS SubMaterialList");
        subOrderBuffer.append(" ON ENTRIES.FID = SubMaterialList.FParentID");
        subOrderBuffer.append("\r\n  INNER JOIN ");
        subOrderBuffer.append(params.getString("PurChaseUnitTempTable"));
        subOrderBuffer.append(" ORG");
        subOrderBuffer.append("  ON SUBORDER.FPurchaseOrgUnitID = ORG.FID");
        if (this.isReceivale) {
            subOrderBuffer.append("\r\n  INNER JOIN T_IM_PurReceivalEntry AS Receivalentry");
            subOrderBuffer.append(" ON SUBORDER.FID = Receivalentry.FPurOrderID");
            subOrderBuffer.append(" ON ENTRIES.FID = Receivalentry.FPurOrderEntryID");
            subOrderBuffer.append(" INNER JOIN T_IM_PurReceivalBill AS Receival");
            subOrderBuffer.append(" ON ENTRIES.FParentID = Receival.FID");
            subOrderBuffer.append(" AND ( Receival.FBaseStatus = 1 ");
            subOrderBuffer.append(" OR Receival.FBaseStatus =  2 ");
            subOrderBuffer.append(" OR Receival.FBaseStatus = 4) ");
        } else {
            subOrderBuffer.append("\r\n  INNER JOIN T_IM_PurInWarehsEntry AS InWarehsentry");
            subOrderBuffer.append(" ON SUBORDER.FID = InWarehsentry.FPurOrderID");
            subOrderBuffer.append(" ON ENTRIES.FID = InWarehsentry.FPurOrderEntryID");
            subOrderBuffer.append(" INNER JOIN T_IM_PurInWarehsBill AS InWarehs");
            subOrderBuffer.append(" ON InWarehsentry.FParentID = InWarehs.FID");
            subOrderBuffer.append(" AND ( Receival.FBaseStatus = 1 ");
            subOrderBuffer.append(" OR Receival.FBaseStatus =  2 ");
            subOrderBuffer.append(" OR Receival.FBaseStatus = 4) ");
        }
        String subOrderStr = this.getQueryStr(params, "ENTRIES", subOrderBuffer, ctx) + "\r\n group by SUBORDER.FNumber,SUBORDER.FBizTypeID \r\n ,SUBORDER.FSupplierID,ORG.FID\r\n ,SubMaterialList.FMaterialID,SubMaterialList.FBaseUnitID";
        sql = subOrderBuffer + subOrderStr;
        return sql;
    }

    private String getQueryFromReceival(RptParams params) throws EASBizException, BOSException {
        StringBuffer tatolFromReceivale = new StringBuffer();
        tatolFromReceivale.append("\r\n left outer join (");
        tatolFromReceivale.append("\r\n  select receival.FPurOrderID FPurOrderID");
        tatolFromReceivale.append(",receival.FPurOrderEntrySeq FPurOrderEntrySeq");
        tatolFromReceivale.append("\r\n  ,sum(case when o.funitid = receival.funitid then ");
        tatolFromReceivale.append("\r\n receival.FQty else receival.fqty*FBaseConvsRate end ");
        tatolFromReceivale.append("\r\n ) FtotalReceiveQty ");
        tatolFromReceivale.append("\r\n from T_IM_PurReceivalBill xx ");
        tatolFromReceivale.append("\r\n inner join T_IM_PurReceivalentry receival on xx.fid=receival.FParentID");
        tatolFromReceivale.append("\r\n inner join T_SM_PurOrderEntry o on o.fparentid=receival.fpurorderid ");
        tatolFromReceivale.append(" and receival.FPurOrderEntrySeq=o.fseq");
        tatolFromReceivale.append("\r\n left outer join T_BD_MultiMeasureUnit unit ");
        tatolFromReceivale.append("\r\n on receival.FMaterialID = unit.FmaterialID and o.funitid=unit.FMeasureUnitID");
        tatolFromReceivale.append("\r\n where (xx.Fbasestatus =4 or xx.Fbasestatus =2  or xx.Fbasestatus =1 )");
        tatolFromReceivale.append("\r\n group by receival.FPurOrderID,receival.FPurOrderEntrySeq ");
        tatolFromReceivale.append("\r\n )  DataFrom on PURORDER.FID = DataFrom.FPurOrderID and ENTRIES.FSeq= DataFrom.FPurOrderEntrySeq");
        return tatolFromReceivale.toString();
    }

    private String getQueryFromInwarehs(RptParams params) throws EASBizException, BOSException {
        StringBuffer tatolFromInwarehs = new StringBuffer();
        tatolFromInwarehs.append("\r\n left outer join (");
        tatolFromInwarehs.append("\r\n  select InWarehs.FPurOrderID FPurOrderID");
        tatolFromInwarehs.append(",InWarehs.FPurOrderEntrySeq FPurOrderEntrySeq");
        tatolFromInwarehs.append("\r\n  ,sum(case when o.funitid = InWarehs.funitid then ");
        tatolFromInwarehs.append("\r\n InWarehs.FQty else InWarehs.fqty*FBaseConvsRate end ");
        tatolFromInwarehs.append("\r\n ) FtotalReceiveQty ");
        tatolFromInwarehs.append("\r\n from T_IM_PurInWarehsBill xx ");
        tatolFromInwarehs.append("\r\n inner join T_IM_PurInWarehsEntry InWarehs on xx.FID = InWarehs.FParentID");
        tatolFromInwarehs.append("\r\n inner join T_SM_PurOrderEntry o on o.fparentid=InWarehs.fpurorderid ");
        tatolFromInwarehs.append(" and InWarehs.FPurOrderEntrySeq=o.fseq");
        tatolFromInwarehs.append("\r\n left outer join T_BD_MultiMeasureUnit unit ");
        tatolFromInwarehs.append("\r\n on InWarehs.FMaterialID = unit.FmaterialID and o.funitid=unit.FMeasureUnitID");
        tatolFromInwarehs.append("\r\n where (xx.Fbasestatus =4 or xx.Fbasestatus =2 or xx.Fbasestatus =1 )");
        tatolFromInwarehs.append("\r\n group by InWarehs.FPurOrderID,InWarehs.FPurOrderEntrySeq ");
        tatolFromInwarehs.append("\r\n )  DataFrom on PURORDER.FID = DataFrom.FPurOrderID and ENTRIES.FSeq= DataFrom.FPurOrderEntrySeq");
        return tatolFromInwarehs.toString();
    }

    private String getQueryStr(RptParams params, String purOrderEntryName, StringBuffer purBuffer, Context ctx) throws EASBizException, BOSException {
        StringBuffer queryStr = new StringBuffer();
        String bd = null;
        String ed = null;
        bd = params.getString("dateStart");
        ed = params.getString("dateEnd");
        queryStr.append("\r\n where ");
        queryStr.append(" ENTRIES.Fbasestatus =4  and ").append(purOrderEntryName + ".FDeliveryDate  >= {" + bd + "} and " + purOrderEntryName + ".FDeliveryDate <= {" + ed + "}");
        if (params.getString("materialFrom") != null) {
            queryStr.append(" and material.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = ENTRIES.FMaterialID ");
            }
        }
        if (params.getString("materialTo") != null) {
            queryStr.append(" and material.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Material") == -1) {
                purBuffer.append("\r\n inner join T_BD_Material material ");
                purBuffer.append(" on material.fid = ENTRIES.FMaterialID ");
            }
        }
        if (params.getString("SupplierFrom") != null) {
            queryStr.append(" and Supplier.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_BD_Supplier") == -1) {
                purBuffer.append("\r\n inner join T_BD_Supplier Supplier ");
                purBuffer.append(" on Supplier.fid = PURORDER.FSupplierID ");
            }
        }
        if (params.getString("SupplierTo") != null) {
            queryStr.append(" and Supplier.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_BD_Supplier") == -1) {
                purBuffer.append("\r\n inner join T_BD_Supplier Supplier ");
                purBuffer.append(" on Supplier.fid = PURORDER.FSupplierID ");
            }
        }
        if (params.getString("BiztypeFrom") != null) {
            queryStr.append(" and BIZTYPE.FNumber >= ? ");
            if (purBuffer.toString().indexOf("T_SCM_BizType") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ");
                purBuffer.append(" ON PURORDER.FBizTypeID = BIZTYPE.FID ");
            }
        }
        if (params.getString("BiztypeTo") != null) {
            queryStr.append(" and BIZTYPE.FNumber <= ? ");
            if (purBuffer.toString().indexOf("T_SCM_BizType") == -1) {
                purBuffer.append("\r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE ");
                purBuffer.append(" ON PURORDER.FBizTypeID = BIZTYPE.FID ");
            }
        }
        return queryStr.toString();
    }

    private RptTableHeader setPurOrderRptHead(RptTableHeader header, RptParams params, Context ctx) {
        String billNum = this.getServerResource("BillNumber", ctx);
        String deliverydate = this.getServerResource("DeliveryDate", ctx);
        String billStatus = this.getServerResource("BillStatus", ctx);
        String bizType = this.getServerResource("BizType", ctx);
        String supplierName = this.getServerResource("supplierNameABC", ctx);
        String purChaseUnitName = this.getServerResource("PurchaseUnit", ctx);
        String materialNum = this.getServerResource("MaterialNumber", ctx);
        String materialName = this.getServerResource("MaterialName", ctx);
        String materialModel = this.getServerResource("MaterialModel", ctx);
        String baseUnit = this.getServerResource("Unit", ctx);
        String quatity = this.getServerResource("qty", ctx);
        String totalReceiveQty = this.getServerResource("TotalReceiveQty", ctx);
        String totalInwarehsQty = this.getServerResource("TotalInWarehsQty", ctx);
        String noInWarehsQty = this.getServerResource("NoInWarehsQty", ctx);
        Object[][] labels = new Object[1][15];
        String[] cols = new String[]{"ORDER_NUM", "DELIVERYDATE", "BASESTATUS", "BIZTYPE", "SUPPLIER_NAME", "PURCHASEORG_NAME", "MATERIAL_NUMBER", "MATERIAL_NAME", "MATERIAL_MODEL", "UNIT_NAME", "ORDER_QTY", "TOTALRECEIVE_QTY", "NOINWAREHS_QTY", "PURCHASEORG_FID", "MATERIAL_FID"};
        this.setHeaderColumns(header, cols, params);
        labels[0][0] = billNum;
        labels[0][1] = deliverydate;
        labels[0][2] = billStatus;
        labels[0][3] = bizType;
        labels[0][4] = supplierName;
        labels[0][5] = purChaseUnitName;
        labels[0][6] = materialNum;
        labels[0][7] = materialName;
        labels[0][8] = materialModel;
        labels[0][9] = baseUnit;
        labels[0][10] = quatity;
        labels[0][11] = this.isReceivale ? totalReceiveQty : totalInwarehsQty;
        labels[0][12] = noInWarehsQty;
        labels[0][13] = "PURCHASEORG_FID";
        labels[0][14] = "MATERIAL_FID";
        header.setLabels(labels, true);
        return header;
    }

    private void setHeaderColumns(RptTableHeader header, String[] columns, RptParams params) {
        String dateFormat = RptCellFormatter.getDateFormat((String)"yyyy-MM-dd");
        String qtyFormat = RptCellFormatter.getNumberFormat((int)4, (boolean)false);
        RptTableColumn col = null;
        int c = columns.length;
        for (int i = 0; i < c; ++i) {
            col = new RptTableColumn(columns[i]);
            col.setWidth(-1);
            if (i == 1) {
                col.setFormatPattern(dateFormat);
            }
            if (i == 10 || i == 11 || i == 12) {
                col.setWidth(120);
                col.setAligment(2);
                col.setFormatPattern(qtyFormat);
            }
            if (i == 13 || i == 14) {
                col.setHided(true);
            }
            header.addColumn(col);
        }
    }

    protected RptParams _query(Context ctx, RptParams params, int from, int len) throws BOSException, EASBizException {
        RptRowSet rs = this.executeQuery(this.querySql(params, ctx) + " order by temp.FPurorderNumber,temp.FSupplierID,temp.FPurChaseUnitID,temp.FMaterialID", null, from, len, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    private void executeSQL(Context ctx, String sql) throws BOSException {
        if (sql != null && sql.trim().length() > 0) {
            this.executeUpdate(sql, null, ctx);
        }
    }

    private String querySql(RptParams params, Context ctx) {
        StringBuffer sql = new StringBuffer();
        String tempTable = params.getString("tempTable");
        String purChaseUnitTempTable = params.getString("PurChaseUnitTempTable");
        sql.append(" SELECT temp.FPurorderNumber,temp.FDeliveryDate,temp.FBaseStatus");
        sql.append(",BIZTYPE.FName_").append(locLan).append(",SUPPLIER.FName_").append(locLan).append(" AS SUPPLIER_NAME");
        sql.append("\r\n ,org.fname_").append(locLan).append(" AS PURCHASEORG_NAME");
        sql.append(",mat.FNumber AS MATERIAL_NUMBER").append(",mat.FName_").append(locLan).append(" AS MATERIAL_NAME,mat.FModel AS MATERIAL_MODEL");
        sql.append("\r\n ,UNIT.FName_").append(locLan).append(" AS UNIT_NAME").append("\r\n ,temp.FQty QTY,temp.FTotalReceiveQty TOTALRECEIVE_QTY,temp.FNonWarehsQty NONWAREHS_QTY").append(",temp.FPurChaseUnitID as PURCHASEORG_FID").append(",temp.FMaterialID AS MATERIAL_FID").append(" from  " + tempTable + " temp INNER JOIN ").append(purChaseUnitTempTable).append(" org ON temp.FPurChaseUnitID = org.FID ").append(" INNER JOIN T_BD_Material mat on temp.FMaterialID = mat.FID ").append(" \r\n INNER JOIN T_BD_Supplier AS SUPPLIER ON temp.FSupplierID = SUPPLIER.FID ").append(" \r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE\tON temp.FBIZTYPEID = BIZTYPE.FID ").append(" INNER JOIN T_BD_MeasureUnit AS UNIT ON temp.FUnitID = UNIT.FID ").append(" where temp.FNonWarehsQty > 0  ");
        return sql.toString();
    }

    protected IRowSet _getIdList(Context ctx, RptParams param) throws BOSException {
        String rsList = "select  s.fid from " + param.getString("tempTable") + " s inner join T_BD_Material m on s.FMaterialID=m.FID  inner join " + param.getString("PurChaseUnitTempTable") + " org  on s.FPurChaseUnitID = org.FID  where s.FNonWarehsQty > 0 order by s.FPurorderNumber,s.FSupplierID,s.FPurChaseUnitID,s.FMaterialID";
        return DbUtil.executeQuery((Context)ctx, (String)rsList);
    }

    public RptParams getDataForIdList(Context ctx, List idList, RptParams params) throws BOSException, EASBizException {
        return this.getDatas(ctx, params, idList, false);
    }

    private RptParams getDatas(Context ctx, RptParams params, List idList, boolean first) throws BOSException {
        String subWhere;
        String orgTempTable = params.getString("PurChaseUnitTempTable");
        String tempTable = params.getString("tempTable");
        if (first) {
            subWhere = " ";
        } else {
            StringBuffer fid = new StringBuffer(" where temp.FId IN (  '").append(idList.get(0).toString()).append("'");
            int n = idList.size();
            for (int i = 1; i < n; ++i) {
                fid.append(", '").append(idList.get(i).toString()).append("'");
            }
            fid.append(" ) ");
            subWhere = fid.toString();
        }
        StringBuffer sql = new StringBuffer();
        sql.append(" SELECT temp.FPurorderNumber,temp.FDeliveryDate,temp.FBaseStatus");
        sql.append(",BIZTYPE.FName_").append(locLan).append(",SUPPLIER.FName_").append(locLan).append(" AS SUPPLIER_NAME");
        sql.append("\r\n ,org.fname_").append(locLan).append(" AS PURCHASEORG_NAME");
        sql.append(",mat.FNumber AS MATERIAL_NUMBER").append(",mat.FName_").append(locLan).append(" AS MATERIAL_NAME,mat.FModel AS MATERIAL_MODEL");
        sql.append("\r\n ,UNIT.FName_").append(locLan).append(" AS UNIT_NAME").append("\r\n ,temp.FQty QTY,temp.FTotalReceiveQty TOTALRECEIVE_QTY,temp.FNonWarehsQty NONWAREHS_QTY").append(",temp.FPurChaseUnitID as PURCHASEORG_FID").append(",temp.FMaterialID AS MATERIAL_FID").append(" from  " + tempTable + " temp INNER JOIN ").append(orgTempTable).append(" org ON temp.FPurChaseUnitID = org.FID ").append(" INNER JOIN T_BD_Material mat on temp.FMaterialID = mat.FID ").append(" \r\n INNER JOIN T_BD_Supplier AS SUPPLIER ON temp.FSupplierID = SUPPLIER.FID ").append(" \r\n LEFT OUTER JOIN T_SCM_BizType AS BIZTYPE\tON temp.FBIZTYPEID = BIZTYPE.FID ").append(" INNER JOIN T_BD_MeasureUnit AS UNIT ON temp.FUnitID = UNIT.FID ").append(subWhere).append(" order by temp.FPurorderNumber,temp.FSupplierID,temp.FPurChaseUnitID,temp.FMaterialID");
        RptRowSet rs = this.executeQuery(sql.toString(), null, ctx);
        RptParams pp = new RptParams();
        pp.setObject("rowset", (Object)rs);
        return pp;
    }

    public String getServerResource(String key, Context ctx) {
        return SCMUtils.getResource((String)resClassName, (String)key, (Context)ctx);
    }
}

