/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.sc.vrule.app.order;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.IOrgUnitRelation;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.sm.sc.DosingTypeEnum;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryCollection;
import com.kingdee.eas.scm.sm.sc.SubContractOrderEntryInfo;
import com.kingdee.eas.scm.sm.sc.SubContractOrderException;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

public class CheckValidData4SubmitVRule
implements IVRule {
    Context ctx;
    Map orgRelationCache;

    public CheckValidData4SubmitVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SubContractOrderInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        assert (bean != null);
        this.check4Submit(bean);
    }

    private void check4Submit(IObjectValue bean) throws BOSException, EASBizException {
        SubContractOrderInfo sc = (SubContractOrderInfo)bean;
        BillBaseStatusEnum baseStatus = sc.getBaseStatus();
        if (BillBaseStatusEnum.ALTERING.equals((Object)baseStatus)) {
            this.validateAlertSubmit(bean);
        }
        this.validateSubmit(bean);
        this.checkSubmit((SubContractOrderInfo)bean);
    }

    private boolean isBotpBill(SCMBillBaseInfo info) {
        if (info == null) {
            return false;
        }
        BillTypeInfo billType = info.getSourceBillType();
        return billType != null;
    }

    private void validateSubmit(IObjectValue bean) throws BOSException, EASBizException {
        SubContractOrderInfo sc = (SubContractOrderInfo)bean;
        if (this.isBotpBill((SCMBillBaseInfo)sc)) {
            boolean flag = false;
            PurchaseOrgUnitInfo purchaseOrgUnitInfo = sc.getPurchaseOrgUnit();
            SubContractOrderEntryCollection entries = sc.getEntries();
            SubContractOrderEntryInfo entry = null;
            int size = entries.size();
            for (int i = 0; i < size; ++i) {
                entry = entries.get(i);
                if (entry.getRequestOrgUnit() == null) continue;
                StorageOrgUnitInfo storageOrgUnitInfo = entry.getRequestOrgUnit();
                OrgUnitCollection orgUnitColl = null;
                try {
                    String purOrgId;
                    if (this.orgRelationCache == null) {
                        this.orgRelationCache = new HashMap();
                    }
                    if (this.orgRelationCache.get(purOrgId = purchaseOrgUnitInfo.getId().toString()) == null) {
                        IOrgUnitRelation iOrgUnitRelation = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx);
                        OrgUnitCollection orgUnitCollection = iOrgUnitRelation.getToUnit(purOrgId, 3, 1);
                        if (orgUnitCollection != null && orgUnitCollection.size() > 0) {
                            CompanyOrgUnitInfo companyOrg = (CompanyOrgUnitInfo)orgUnitCollection.get(0);
                            orgUnitColl = iOrgUnitRelation.getFromUnit(companyOrg.getId().toString(), 1, 4);
                            this.orgRelationCache.put(purOrgId, orgUnitColl);
                        }
                    } else {
                        orgUnitColl = (OrgUnitCollection)this.orgRelationCache.get(purOrgId);
                    }
                    if (orgUnitColl != null && orgUnitColl.size() > 0) {
                        int count = orgUnitColl.size();
                        for (int j = 0; j < count; ++j) {
                            if (!storageOrgUnitInfo.getId().toString().trim().equals(orgUnitColl.get(j).getId().toString().trim())) continue;
                            flag = true;
                        }
                    }
                    if (flag) continue;
                    throw new SubContractOrderException(SubContractOrderException.REQUESTORG_NOTMATCH, new Object[]{entry.getSeq()});
                }
                catch (Exception e) {
                    throw new BOSException((Throwable)e);
                }
            }
        }
    }

    private void validateAlertSubmit(IObjectValue bean) throws BOSException, EASBizException {
        SubContractOrderInfo sc = (SubContractOrderInfo)bean;
        SubContractOrderEntryCollection entries = sc.getEntries();
        SubContractOrderEntryInfo entry = null;
        DosingTypeEnum doThingType = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            int j;
            entry = entries.get(i);
            doThingType = entry.getDosingType();
            if (!DosingTypeEnum.BOM.equals((Object)doThingType) && !DosingTypeEnum.HISTORY.equals((Object)doThingType) && !DosingTypeEnum.MANUAL.equals((Object)doThingType)) continue;
            for (j = 0; j < entry.getEntries1().size() && entry.getEntries1().get(j).getMaterial() == null; ++j) {
            }
            if (entry.getEntries1().size() != 0 && j != entry.getEntries1().size()) continue;
            throw new SubContractOrderException(SubContractOrderException.ENTRY1_CANNOT_NULL, new Object[]{entry.getSeq()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkSubmit(SubContractOrderInfo info) throws BOSException, EASBizException {
        int baseStatusValue;
        if (info != null && info.getBaseStatus() != null && (baseStatusValue = info.getBaseStatus().getValue()) != 0 && baseStatusValue != 1 && baseStatusValue != 2) {
            throw new SubContractOrderException(SubContractOrderException.CANNOT_SUBMIT, new String[]{info.getBaseStatus().getAlias()});
        }
        if (info != null && info.getPurchaseOrgUnit() != null) {
            this.checkEntryAssistAttr(this.ctx, info);
            boolean isUsePurSup = false;
            isUsePurSup = this.isUsePurSup(this.ctx, info.getPurchaseOrgUnit().getId().toString());
            if (isUsePurSup) {
                StringBuffer tempTableSql = new StringBuffer();
                StringBuffer insertSql = new StringBuffer();
                StringBuffer updateTableSql = new StringBuffer();
                StringBuffer selectSql = new StringBuffer();
                SubContractOrderEntryCollection entries = info.getEntries();
                tempTableSql.append("CREATE TABLE PUORDER_TEMP (FLINENUM INT,FBASEQTY Decimal(28,10),");
                tempTableSql.append("FMaterialID VARCHAR(44),FSupplierID VARCHAR(44),FPurchaseOrgID VARCHAR(44))");
                String tempTableName = "";
                try {
                    try {
                        tempTableName = TempTablePool.getInstance((Context)this.ctx).createTempTable(tempTableSql.toString());
                    }
                    catch (Exception e) {
                        throw new BOSException((Throwable)e);
                    }
                    insertSql.append("INSERT INTO ").append(tempTableName).append(" ");
                    insertSql.append("(FLINENUM,FBASEQTY,FMaterialID,FSupplierID,FPurchaseOrgID) ");
                    insertSql.append("values(?,?,?,?,?)");
                    ArrayList<Object[]> paramList = new ArrayList<Object[]>();
                    if (entries != null) {
                        for (int i = 0; i < entries.size(); ++i) {
                            SubContractOrderEntryInfo entry = entries.get(i);
                            Object[] obj = new Object[]{i, entry.getBaseQty(), entry.getMaterial().getId().toString(), info.getSupplier().getId().toString(), info.getPurchaseOrgUnit().getId().toString()};
                            paramList.add(obj);
                        }
                    }
                    DbUtil.executeBatch((Context)this.ctx, (String)insertSql.toString(), paramList);
                    updateTableSql.append("update ").append(tempTableName).append(" as t set FBASEQTY= (select t2.FSumQty ");
                    updateTableSql.append("from (select sum(t1.FBASEQTY) FSumQty, t1.FmaterialId  FMaterialID from ");
                    updateTableSql.append(tempTableName).append(" as t1 group by fmaterialid) as t2 where t.FmaterialId = t2.FMaterialId)");
                    DbUtil.execute((Context)this.ctx, (String)updateTableSql.toString());
                    selectSql.append("select FLINENUM, ");
                    selectSql.append("case when temp.FBASEQTY < (appSup.FqtyOrderBottom*unit.FBaseConvsRate) then 1 else 2 end as flag  from ");
                    selectSql.append(tempTableName).append(" as temp ");
                    selectSql.append("inner join T_SM_ApprovedSupplier as appSup on appSup.FPurchaseOrgID=temp.FPurchaseOrgID");
                    selectSql.append(" and appSup.FSupplierID=temp.FSupplierID and\tappSup.FMaterialItemID=temp.FMaterialID ");
                    selectSql.append(" and appSup.FMaterialAttr=1 ");
                    selectSql.append("inner join t_bd_multimeasureunit as unit on unit.fmaterialid=appSup.FMaterialItemID ");
                    selectSql.append("and unit.fmeasureunitid=appSup.FPurMeasureUnitID ");
                    selectSql.append("where temp.FBASEQTY<(appSup.FqtyOrderBottom*unit.FBaseConvsRate) or  temp.FBASEQTY>(appSup.FqtyOrderTop*unit.FBaseConvsRate)");
                    IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)selectSql.toString());
                    try {
                        StringBuffer stringBuffer = new StringBuffer();
                        String NoString = PurUtil.getUIResource("NO");
                        String RowString = PurUtil.getUIResource("ROW");
                        while (rs.next()) {
                            if (rs.getString("flag").equals("1")) {
                                stringBuffer.append(NoString).append(Integer.parseInt(rs.getString("FLINENUM")) + 1).append(RowString).append(PurUtil.getUIResource("QTY_APPROVEDSUPPLIERBOTTOMQTY")).append("\n");
                            }
                            if (!rs.getString("flag").equals("2")) continue;
                            stringBuffer.append(NoString).append(Integer.parseInt(rs.getString("FLINENUM")) + 1).append(RowString).append(PurUtil.getUIResource("QTY_APPROVEDSUPPLIERTOPQTY")).append("\n");
                        }
                        if (stringBuffer.length() > 0) {
                            throw new PurOrderException(PurOrderException.ENTRY_FIELD_QTY_APPROVEDSUPPLIERQTY, new String[]{stringBuffer.toString()});
                        }
                    }
                    catch (SQLException e) {
                        throw new BOSException((Throwable)e);
                    }
                }
                finally {
                    if (tempTableName != null) {
                        TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
                        pool.releaseTable(tempTableName);
                    }
                }
            }
        }
    }

    private boolean isUsePurSup(Context ctx, String orgUnitID) {
        boolean isParamValue = false;
        try {
            String paramValue;
            IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK orgUnitPK = null;
            if (orgUnitID != null) {
                orgUnitPK = new ObjectUuidPK(orgUnitID);
            }
            if ((paramValue = paramControl.getParamValue(orgUnitPK, "PURSUP001")) != null) {
                isParamValue = "true".equalsIgnoreCase(paramValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isParamValue;
    }

    private void checkEntryAssistAttr(Context ctx, SubContractOrderInfo info) throws BOSException, EASBizException {
        if (info == null || info.getPurchaseOrgUnit() == null) {
            return;
        }
        boolean isEnableAssistAttr = this.isEnableOrderAssistAttr(ctx, info.getPurchaseOrgUnit().getId().toString());
        if (isEnableAssistAttr) {
            return;
        }
        SubContractOrderEntryCollection entries = info.getEntries();
        SubContractOrderEntryInfo entry = null;
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.get(i);
            if (entry == null || entry.getMaterial() == null || entry.getMaterial().getAssistAttr() == null || entry.getAssistProperty() != null) continue;
            throw new SubContractOrderException(SubContractOrderException.ENTRY_ASSISTATTR_ISNULL, new Object[]{entry.getSeq()});
        }
    }

    private boolean isEnableOrderAssistAttr(Context ctx, String orgUnitID) {
        boolean isParamValue = false;
        try {
            String paramValue;
            IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK orgUnitPK = null;
            if (orgUnitID != null) {
                orgUnitPK = new ObjectUuidPK(orgUnitID);
            }
            if ((paramValue = paramControl.getParamValue(orgUnitPK, "PURORDER100")) != null) {
                isParamValue = "true".equalsIgnoreCase(paramValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isParamValue;
    }
}

