/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.sc.vrule.app.order;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.framework.dataloader.IDataCache;
import com.kingdee.eas.scm.framework.validator.IVRule;
import com.kingdee.eas.scm.sm.sc.SubContractOrderException;
import com.kingdee.eas.scm.sm.sc.SubContractOrderInfo;

public class CheckValidData4UnAuditVRule
implements IVRule {
    Context ctx;

    public CheckValidData4UnAuditVRule(Context ctx) {
        this.ctx = ctx;
    }

    public void setInjectData(IDataCache dataCache) {
    }

    public boolean supports(Class<? extends IObjectValue> clazz) {
        return SubContractOrderInfo.class.isAssignableFrom(clazz);
    }

    public void validate(IObjectValue bean) throws BOSException, EASBizException {
        this.checkUnAudit(bean);
    }

    protected void checkUnAudit(IObjectValue bean) throws BOSException, EASBizException {
        int orgType;
        int baseStatusValue;
        SubContractOrderInfo info = (SubContractOrderInfo)bean;
        if (info != null && info.getBaseStatus() != null && (baseStatusValue = info.getBaseStatus().getValue()) != 4) {
            throw new SubContractOrderException(SubContractOrderException.CANNOT_UNAUDIT, new String[]{info.getBaseStatus().getAlias()});
        }
        String orgUnitID = info.getPurchaseOrgUnit().getId().toString();
        if (!SCMServerUtils.isUnAuditInParam((Context)this.ctx, (SCMBillBaseInfo)info, (String)orgUnitID, (int)(orgType = 3))) {
            throw new SCMBillException(SCMBillException.ISUNAUDITINPARAM);
        }
        SCMServerUtils.checkAlter((Context)this.ctx, (SCMBillBaseInfo)info);
        SCMServerUtils.checkDownriver((Context)this.ctx, (SCMBillBaseInfo)info);
        int size = info.getEntries().size();
        for (int j = 0; j < size; ++j) {
            if (info.getEntries().get(j).getBaseStatus().equals((Object)EntryBaseStatusEnum.AUDITED)) continue;
            throw new SCMBillException(SCMBillException.ENTRIESISNOTAUDIT_CANNOTUNAUDIT);
        }
    }
}

