/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.BillTypeUtils;
import com.kingdee.eas.scm.im.inv.InvBillBaseEntryCollection;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.util.app.db.KsqlUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public class LockBillProcessor
extends AbstractBusinessProcessor {
    public LockBillProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public LockBillProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public LockBillProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        assert (batchResults != null);
        IObjectCollection objCol = batchResults.getObjCollection();
        if (objCol == null || objCol.size() == 0) {
            return;
        }
        if (!BatchActionEnum.AUDIT.equals((Object)this.batchAction) && !BatchActionEnum.UNAUDIT.equals((Object)this.batchAction)) {
            return;
        }
        int size = objCol.size();
        for (int i = 0; i < size; ++i) {
            SCMBillBaseInfo info = (SCMBillBaseInfo)objCol.getObject(i);
            this.lockBill(info);
        }
    }

    private void lockBill(SCMBillBaseInfo info) throws EASBizException, BOSException {
        String srcTempTable = null;
        String corTempTable = null;
        try {
            if (info == null || info.getBillType() == null) {
                return;
            }
            Map coreBillType = null;
            coreBillType = this.getCoreBillType(this.ctx, info);
            if (coreBillType != null && coreBillType.size() > 0) {
                coreBillType = BillTypeUtils.getBillEntryTableName((Context)this.ctx, coreBillType);
            }
            String billTable = BillTypeUtils.getBillHeadTableName((Context)this.ctx, (String)info.getBillType().getId().toString());
            ArrayList<String> sqlUpdate = new ArrayList<String>();
            IObjectCollection entrys = this.getEntryCollection(info);
            String tmp = null;
            StringBuffer createSql = new StringBuffer();
            HashSet srcId = new HashSet(entrys.size());
            HashSet<String> srcBillId = new HashSet<String>();
            String insql = null;
            for (int i = 0; i < entrys.size(); ++i) {
                if (((SCMBillEntryBaseInfo)entrys.getObject(i)).getSourceBillId() == null) continue;
                tmp = ((SCMBillEntryBaseInfo)entrys.getObject(i)).getSourceBillId().toString();
                srcBillId.add(tmp);
            }
            if (srcBillId.size() > 800) {
                createSql.append("create table temptable ( FSrcBillID varchar(44) ); ");
                srcTempTable = KsqlUtil.createTempTableWithNewTx((Context)this.ctx, (String)createSql.toString());
                KsqlUtil.insertTempTable((Context)this.ctx, (String)srcTempTable, (String)"FSrcBillID", srcBillId);
                insql = "select FSrcBillID from " + srcTempTable;
            } else if (srcBillId.size() > 0) {
                insql = InvServerUtils.getSqlIdsStrForColl(srcBillId);
            }
            BillTypeInfo sourceBillType = ((SCMBillEntryBaseInfo)entrys.getObject(0)).getSourceBillType();
            if (sourceBillType != null && sourceBillType.getId() != null && srcBillId.size() > 0 && (tmp = BillTypeUtils.getBillEntryTableName((Context)this.ctx, (String)sourceBillType.getId().toString())) != null && tmp.trim().length() > 0) {
                sqlUpdate.add(" UPDATE " + tmp + " SET FID = FID WHERE FPARENTID IN ( " + insql + ")");
            }
            if (sqlUpdate.size() > 0) {
                String[] updSql = new String[sqlUpdate.size()];
                for (int i = 0; i < sqlUpdate.size(); ++i) {
                    updSql[i] = (String)sqlUpdate.get(i);
                }
                DBUtil.executeBatch((Context)this.ctx, (String[])updSql);
            }
            KsqlUtil.releaseTempTable((Context)this.ctx, (String)srcTempTable);
        }
        catch (EASBizException e1) {
            throw e1;
        }
        catch (BOSException e2) {
            throw e2;
        }
        finally {
            KsqlUtil.releaseTempTable((Context)this.ctx, srcTempTable);
            KsqlUtil.releaseTempTable((Context)this.ctx, corTempTable);
        }
        KsqlUtil.releaseTempTable((Context)this.ctx, corTempTable);
    }

    protected Map<String, String> getCoreBillType(Context ctx, SCMBillBaseInfo info) throws EASBizException, BOSException {
        if (null == info || info.getEntries() == null || info.getEntries().size() == 0) {
            return null;
        }
        IObjectCollection entryCol = info.getEntries();
        HashMap<String, String> coreBillTypeMap = new HashMap<String, String>(entryCol.size());
        int size = entryCol.size();
        for (int i = 0; i < size; ++i) {
            BillTypeInfo billTypeInfo = (BillTypeInfo)entryCol.getObject(i).get("coreBillType");
            if (null == billTypeInfo || billTypeInfo.getId() == null) continue;
            coreBillTypeMap.put(billTypeInfo.getId().toString(), billTypeInfo.getId().toString());
        }
        return coreBillTypeMap;
    }

    protected IObjectCollection getEntryCollection(SCMBillBaseInfo info) {
        if (info == null) {
            return new InvBillBaseEntryCollection();
        }
        return info.getEntries();
    }
}

