/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.EASResource;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.dynbusiness.util.DBUtil;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.util.array.ArrayUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class POWriteBack4AuditProcessor
extends AbstractBusinessProcessor {
    public POWriteBack4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public POWriteBack4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public POWriteBack4AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectPK[] pks = batchResults.getToDoPkArray();
        Set flowSet = SCMServerUtils.getHasBizFlowValueBillID((Context)this.ctx, (String)"T_SM_PurOrderEntry", (IObjectPK[])pks);
        HashSet<String> ids = new HashSet<String>();
        int size = pks.length;
        for (int j = 0; j < size; ++j) {
            if (flowSet != null && flowSet.contains(pks[j].toString())) continue;
            ids.add(pks[j].toString());
        }
        if (ids.isEmpty()) {
            return;
        }
        this.writeBackSourceBill(batchResults);
    }

    private void writeBackSourceBill(BatchActionResults batchResults) throws BOSException, EASBizException {
        String[] ids = batchResults.getToDoIdsArray();
        try {
            ArrayList<String> matGroupEntryId = new ArrayList<String>();
            ArrayList<String> matEntryId = new ArrayList<String>();
            String sourceBillTypeID = null;
            StringBuffer sql = new StringBuffer();
            sql.append(" select entry.fid, entry.fmaterialgroupid, bill.FSourceBillTypeID ");
            sql.append(" from t_sm_purorder bill ");
            sql.append(" inner join t_sm_purorderentry entry on entry.fparentid = bill.fid");
            sql.append(" where bill.fid in ").append(ArrayUtil.getInStringFromArray((String[])ids));
            sql.append(" and bill.fbasestatus = 4 ");
            IRowSet rs = DBUtil.executeQuery((Context)this.ctx, (String)sql.toString(), null);
            while (rs.next()) {
                sourceBillTypeID = rs.getString("FSourceBillTypeID");
                if (rs.getString("fmaterialgroupid") != null) {
                    matGroupEntryId.add(rs.getString("fid"));
                    continue;
                }
                matEntryId.add(rs.getString("fid"));
            }
            if (matGroupEntryId.isEmpty() && matEntryId.isEmpty()) {
                return;
            }
            if ("510b6503-0105-1000-e000-010bc0a813fd463ED552".equals(sourceBillTypeID)) {
                this.writeBackPurContract(ids, matGroupEntryId, matEntryId);
            } else if ("510b6503-0105-1000-e000-0107c0a812fd463ED552".equals(sourceBillTypeID)) {
                this.writeBackPurRequest(ids, matGroupEntryId, matEntryId);
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private void writeBackPurRequest(String[] ids, ArrayList<String> matGroupEntryId, ArrayList<String> matEntryId) throws BOSException, EASBizException {
        Connection con = null;
        Statement statement = null;
        String tableName = null;
        String alterTableName = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            statement = con.createStatement();
            String entryTable = "t_sm_purorderentry";
            boolean isAlter = this.isAlter(ids);
            if (isAlter) {
                entryTable = alterTableName = this.getAlterTable(ids, statement);
            }
            StringBuilder sql = new StringBuilder();
            sql.append(" CREATE TABLE TempTable (FSourceBillEntryId varchar(44),FSourceBillId varchar(44),");
            sql.append(" FOrderedQty Decimal(21,8), FOrderedBaseQty Decimal(21,8), FUnOrderedQty Decimal(21,8), FUnOrderedBaseQty Decimal(21,8))");
            tableName = DBUtil.createTempTable((Context)this.ctx, (String)sql.toString());
            if (matGroupEntryId.size() > 0) {
                sql.setLength(0);
                sql.append(" Insert into ").append(tableName).append("(FSourceBillEntryId,FSourceBillId, FOrderedQty, FOrderedBaseQty, FUnOrderedQty, FUnOrderedBaseQty)").append("\n");
                sql.append(" (SELECT entry.FSourceBillEntryId,entry.FSourceBillId, max(srce.FOrderedQty)+SUM(entry.FBaseQty) FOrderedQty,").append("\n");
                sql.append(" max(srce.FOrderedBaseQty) + SUM(entry.FBaseQty) FOrderedBaseQty,").append("\n");
                sql.append(" max(srce.FUnOrderedQty) - SUM(entry.FBaseQty) FUnOrderedQty,").append("\n");
                sql.append(" max(srce.FUnOrderedBaseQty) - SUM(entry.FBaseQty) FUnOrderedBaseQty").append("\n");
                sql.append(" FROM ").append(entryTable).append(" entry").append("\n");
                sql.append(" INNER JOIN T_SM_PurRequestEntry srce ON entry.FSourceBillEntryId=srce.FID").append("\n");
                sql.append(" WHERE entry.fid in ").append(PurUtil.getInStringFromList(matGroupEntryId)).append("\n");
                sql.append(" GROUP BY entry.FSourceBillEntryId,entry.FSourceBillId)");
                statement.execute(sql.toString());
            }
            if (matEntryId.size() > 0) {
                sql.setLength(0);
                sql.append(" Insert into ").append(tableName).append("(FSourceBillEntryId,FSourceBillId, FOrderedQty, FOrderedBaseQty, FUnOrderedQty, FUnOrderedBaseQty)").append("\n");
                sql.append(" (SELECT entry.FSourceBillEntryId, entry.FSourceBillId,").append("\n");
                sql.append(" max(srce.FOrderedQty) + SUM(CASE WHEN entry.FUnitID = srce.FUnitID THEN entry.FQty").append("\n");
                sql.append("   ELSE Round(Decimal(entry.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END) FOrderedQty,").append("\n");
                sql.append(" max(srce.FOrderedBaseQty) + SUM(entry.FBaseQty) FOrderedBaseQty,").append("\n");
                sql.append(" max(srce.FUnOrderedQty) - SUM(CASE WHEN entry.FUnitID = srce.FUnitID THEN entry.FQty").append("\n");
                sql.append("   ELSE Round(Decimal(entry.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END) FUnOrderedQty,").append("\n");
                sql.append(" max(srce.FUnOrderedBaseQty) - SUM(entry.FBaseQty) FUnOrderedBaseQty").append("\n");
                sql.append(" FROM ").append(entryTable).append(" entry").append("\n");
                sql.append(" INNER JOIN T_SM_PurRequestEntry srce ON entry.FSourceBillEntryId=srce.FID").append("\n");
                sql.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON srce.FMaterialID = mmu.FMaterialID AND srce.FUnitID=mmu.FMeasureUnitID").append("\n");
                sql.append(" WHERE entry.fid in ").append(PurUtil.getInStringFromList(matEntryId)).append("\n");
                sql.append(" GROUP BY entry.FSourceBillEntryId,entry.FSourceBillId)");
                statement.execute(sql.toString());
            }
            sql.setLength(0);
            sql.append(" UPDATE T_SM_PurRequestEntry set (FOrderedQty, FOrderedBaseQty, FUnOrderedQty, FUnOrderedBaseQty) = ").append("\n");
            sql.append("(SELECT t.FOrderedQty, t.FOrderedBaseQty, t.FUnOrderedQty, t.FUnOrderedBaseQty from ").append(tableName).append(" t ").append("\n");
            sql.append(" WHERE t.FSourceBillEntryId = T_SM_PurRequestEntry.fid)");
            statement.addBatch(sql.toString());
            sql.setLength(0);
            sql.append(" UPDATE T_SM_PurRequestEntry set fbasestatus = 7 ").append("\n");
            sql.append(" where fid in (SELECT FSourceBillEntryId from ").append(tableName).append(")").append("\n");
            sql.append(" and FUnOrderedQty <= 0");
            statement.addBatch(sql.toString());
            sql.setLength(0);
            sql.append(" UPDATE T_SM_PurRequest set fbasestatus = 7 ").append("\n");
            sql.append(" where exists (SELECT 1 from ").append(tableName).append(" t where t.FSourceBillId = T_SM_PurRequest.fid)").append("\n");
            sql.append(" and not exists (SELECT 1 from ").append(tableName).append(" t ").append("\n");
            sql.append(" inner join T_SM_PurRequestEntry srce on srce.fid = t.FSourceBillEntryId ").append("\n");
            sql.append(" where srce.fbasestatus <> 7 and t.FSourceBillId = T_SM_PurRequest.fid)");
            statement.addBatch(sql.toString());
            if (isAlter) {
                sql.setLength(0);
                sql.append(" UPDATE T_SM_PurRequestEntry set fbasestatus = 4 ").append("\n");
                sql.append(" where fid in (SELECT FSourceBillEntryId from ").append(tableName).append(")").append("\n");
                sql.append(" and FUnOrderedQty > 0");
                statement.addBatch(sql.toString());
                sql.setLength(0);
                sql.append(" UPDATE T_SM_PurRequest set fbasestatus = 4 ").append("\n");
                sql.append(" where exists (SELECT 1 from ").append(tableName).append(" t where t.FSourceBillId = T_SM_PurRequest.fid)").append("\n");
                sql.append(" and exists (SELECT 1 from ").append(tableName).append(" t ").append("\n");
                sql.append(" inner join T_SM_PurRequestEntry srce on srce.fid = t.FSourceBillEntryId ").append("\n");
                sql.append(" where srce.fbasestatus = 4 and t.FSourceBillId = T_SM_PurRequest.fid)");
                statement.addBatch(sql.toString());
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)con);
                DBUtil.releaseTempTable((Context)this.ctx, tableName);
                DBUtil.releaseTempTable((Context)this.ctx, alterTableName);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)con);
        DBUtil.releaseTempTable((Context)this.ctx, (String)tableName);
        DBUtil.releaseTempTable((Context)this.ctx, (String)alterTableName);
    }

    private void writeBackPurContract(String[] ids, ArrayList<String> matGroupEntryId, ArrayList<String> matEntryId) throws BOSException, EASBizException {
        Connection con = null;
        Statement statement = null;
        String tableName = null;
        String alterTableName = null;
        try {
            con = EJBFactory.getConnection((Context)this.ctx);
            statement = con.createStatement();
            String entryTable = "t_sm_purorderentry";
            boolean isAlter = this.isAlter(ids);
            if (isAlter) {
                entryTable = alterTableName = this.getAlterTable(ids, statement);
            }
            StringBuilder sql = new StringBuilder();
            sql.append(" CREATE TABLE TempTable (FSourceBillEntryId varchar(44),FSourceBillId varchar(44),");
            sql.append(" FTotalOrderQty Decimal(21,8), FTotalOrderAmount Decimal(21,8))");
            tableName = DBUtil.createTempTable((Context)this.ctx, (String)sql.toString());
            if (matGroupEntryId.size() > 0) {
                sql.setLength(0);
                sql.append(" Insert into ").append(tableName).append("(FSourceBillEntryId,FSourceBillId, FTotalOrderQty, FTotalOrderAmount)").append("\n");
                sql.append(" (SELECT entry.FSourceBillEntryId,entry.FSourceBillId, max(srce.FTotalOrderQty)+SUM(entry.FBaseQty) FTotalOrderQty,").append("\n");
                sql.append(" max(srce.FTotalOrderAmount) + SUM(entry.FTaxAmount) FTotalOrderAmount").append("\n");
                sql.append(" FROM ").append(entryTable).append(" entry").append("\n");
                sql.append(" INNER JOIN T_SM_PurContractEntry srce ON entry.FSourceBillEntryId=srce.FID").append("\n");
                sql.append(" WHERE entry.fid in ").append(PurUtil.getInStringFromList(matGroupEntryId)).append("\n");
                sql.append(" GROUP BY entry.FSourceBillEntryId,entry.FSourceBillId)");
                statement.execute(sql.toString());
            }
            if (matEntryId.size() > 0) {
                sql.setLength(0);
                sql.append(" Insert into ").append(tableName).append("(FSourceBillEntryId,FSourceBillId, FTotalOrderQty, FTotalOrderAmount)").append("\n");
                sql.append(" (SELECT entry.FSourceBillEntryId, entry.FSourceBillId, max(srce.FTotalOrderQty)+SUM(CASE WHEN entry.FUnitID = srce.FUnitID THEN entry.FQty").append("\n");
                sql.append(" ELSE Round(Decimal(entry.FBaseQty/mmu.FBaseConvsRate,21,8),mmu.FQtyPrecision) END) FTotalOrderQty,").append("\n");
                sql.append(" max(srce.FTotalOrderAmount)+SUM(entry.FTaxAmount) FTotalOrderAmount").append("\n");
                sql.append(" FROM ").append(entryTable).append(" entry").append("\n");
                sql.append(" INNER JOIN T_SM_PurContractEntry srce ON entry.FSourceBillEntryId=srce.FID").append("\n");
                sql.append(" LEFT OUTER JOIN T_BD_MultiMeasureUnit mmu ON srce.FMaterialID = mmu.FMaterialID AND srce.FUnitID=mmu.FMeasureUnitID").append("\n");
                sql.append(" WHERE entry.fid in ").append(PurUtil.getInStringFromList(matEntryId)).append("\n");
                sql.append(" GROUP BY entry.FSourceBillEntryId,entry.FSourceBillId)");
                statement.execute(sql.toString());
            }
            this.checkTotalOrderQty(tableName);
            sql.setLength(0);
            sql.append(" UPDATE T_SM_PurContractEntry set (FTotalOrderQty,FTotalOrderAmount) = ").append("\n");
            sql.append("(SELECT t.FTotalOrderQty,t.FTotalOrderAmount from ").append(tableName).append(" t ").append("\n");
            sql.append(" WHERE t.FSourceBillEntryId = T_SM_PurContractEntry.fid)");
            statement.addBatch(sql.toString());
            sql.setLength(0);
            sql.append(" UPDATE T_SM_PurContractEntry set fbasestatus = 7 ").append("\n");
            sql.append(" where fid in (SELECT FSourceBillEntryId from ").append(tableName).append(")").append("\n");
            sql.append(" and FQty != 0 and FTotalOrderQty >= FQty");
            statement.addBatch(sql.toString());
            sql.setLength(0);
            sql.append(" UPDATE T_SM_PurContract set fbasestatus = 7 ").append("\n");
            sql.append(" where exists (SELECT 1 from ").append(tableName).append(" t where t.FSourceBillId = T_SM_PurContract.fid)").append("\n");
            sql.append(" and not exists (SELECT 1 from T_SM_PurContractEntry srce inner join ").append(tableName).append(" t ").append("\n");
            sql.append("  on srce.fparentId = t.FSourceBillId ").append("\n");
            sql.append(" where srce.fbasestatus <> 7 and t.FSourceBillId = T_SM_PurContract.fid)");
            statement.addBatch(sql.toString());
            if (isAlter) {
                sql.setLength(0);
                sql.append(" UPDATE T_SM_PurContractEntry set fbasestatus = 4 ").append("\n");
                sql.append(" where fid in (SELECT FSourceBillEntryId from ").append(tableName).append(")").append("\n");
                sql.append(" and FQty != 0 and FTotalOrderQty < FQty");
                statement.addBatch(sql.toString());
                sql.setLength(0);
                sql.append(" UPDATE T_SM_PurContract set fbasestatus = 4 ").append("\n");
                sql.append(" where exists (SELECT 1 from ").append(tableName).append(" t where t.FSourceBillId = T_SM_PurContract.fid)").append("\n");
                sql.append(" and exists (SELECT 1 from ").append(tableName).append(" t ").append("\n");
                sql.append(" inner join T_SM_PurContractEntry srce on srce.fid = t.FSourceBillEntryId ").append("\n");
                sql.append(" where srce.fbasestatus = 4 and t.FSourceBillId = T_SM_PurContract.fid)");
                statement.addBatch(sql.toString());
            }
            statement.executeBatch();
        }
        catch (SQLException e) {
            try {
                throw new BOSException((Throwable)e);
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement);
                SQLUtils.cleanup((Connection)con);
                DBUtil.releaseTempTable((Context)this.ctx, tableName);
                DBUtil.releaseTempTable((Context)this.ctx, alterTableName);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement);
        SQLUtils.cleanup((Connection)con);
        DBUtil.releaseTempTable((Context)this.ctx, (String)tableName);
        DBUtil.releaseTempTable((Context)this.ctx, (String)alterTableName);
    }

    private boolean isAlter(String[] ids) {
        if (this.ctx.get((Object)"statusAlterMap") != null) {
            Map statusAlterMap = (Map)this.ctx.get((Object)"statusAlterMap");
            for (int i = 0; i < ids.length; ++i) {
                if (!BillBaseStatusEnum.ALTERING.equals(statusAlterMap.get(ids[i]))) continue;
                return true;
            }
        }
        return false;
    }

    private String getAlterTable(String[] ids, Statement statement) throws BOSException, SQLException {
        String tablename = null;
        StringBuffer sql = new StringBuffer();
        sql.append(" CREATE TABLE TempTable (FId varchar(44), FSourceBillEntryId varchar(44), FSourceBillId varchar(44),");
        sql.append(" FQty Decimal(21,8), FTaxAmount Decimal(21,8), FBaseQty Decimal(21,8), FUnitId varchar(44))");
        tablename = DBUtil.createTempTable((Context)this.ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(" Insert into ").append(tablename).append("(FId,FSourceBillEntryId,FSourceBillId, FQty, FTaxAmount, FBaseQty,FUnitId)").append("\n");
        sql.append(" (SELECT entry.FID,entry.FSourceBillEntryId,entry.FSourceBillId, SUM(entry.FQty)-SUM(oentry.FQty) FQty,").append("\n");
        sql.append(" SUM(entry.FTaxAmount)-SUM(oentry.FTaxAmount) FTaxAmount, SUM(entry.FBaseQty)-SUM(oentry.FBaseQty) FBaseQty, entry.FUnitId").append("\n");
        sql.append(" FROM T_SM_PurOrder head").append("\n");
        sql.append(" INNER JOIN T_SM_PurOrderEntry entry ON head.FID=entry.FParentID").append("\n");
        sql.append(" INNER JOIN T_SM_PurOrderEntry oentry ON oentry.FOldID=entry.FID").append("\n");
        sql.append(" INNER JOIN T_SM_PurOrder ohead ON ohead.FID=oentry.FParentID AND ohead.FVersion=head.FVersion-1").append("\n");
        sql.append(" WHERE entry.fparentid in ").append(ArrayUtil.getInStringFromArray((String[])ids)).append("\n");
        sql.append(" GROUP BY entry.FID,entry.FSourceBillEntryId,entry.FSourceBillId, entry.FUnitId").append("\n");
        sql.append(" UNION ALL").append("\n");
        sql.append(" SELECT entry.FID,entry.FSourceBillEntryId,entry.FSourceBillId, SUM(entry.FQty), SUM(entry.FTaxAmount), SUM(entry.FBaseQty), entry.FUnitId").append("\n");
        sql.append(" FROM T_SM_PurOrder head").append("\n");
        sql.append(" INNER JOIN T_SM_PurOrderEntry entry ON head.FID=entry.FParentID").append("\n");
        sql.append(" WHERE entry.fparentid in ").append(ArrayUtil.getInStringFromArray((String[])ids)).append("\n");
        sql.append(" AND NOT EXISTS(SELECT 1 FROM T_SM_PurOrderEntry oentry WHERE oentry.FOldID=entry.FID)").append("\n");
        sql.append(" GROUP BY entry.FID,entry.FSourceBillEntryId,entry.FSourceBillId, entry.FUnitId)").append("\n");
        statement.execute(sql.toString());
        return tablename;
    }

    private void checkTotalOrderQty(String tableName) throws BOSException, EASBizException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" SELECT 1 from " + tableName + " t ").append("\n");
        sql.append(" INNER JOIN T_SM_PurContractEntry srce ON t.FSourceBillEntryId=srce.FID").append("\n");
        sql.append(" WHERE srce.FQualityUnCtrl <> 1 and t.FTotalOrderQty > srce.FQty");
        IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)sql.toString());
        if (rs.next()) {
            throw new EASBizException(new NumericExceptionSubItem("", EASResource.getString((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"ORDERREQ_UNORDERQTY_GREAT_THAN_QTYFORWRITINGBACK", (Locale)this.ctx.getOriginLocale())));
        }
    }
}

