/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.im.inv.StockReqFacadeFactory;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.util.SCMSelectorFactory;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class PurOrder2StockReq4AuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = -8761855289768095922L;

    public PurOrder2StockReq4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurOrder2StockReq4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurOrder2StockReq4AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        this.checkStockReq(batchResults);
    }

    private void checkStockReq(BatchActionResults batchResults) throws BOSException, EASBizException {
        int size;
        IObjectPK[] pks = batchResults.getToDoPkArray();
        if (pks.length == 0) {
            return;
        }
        if (pks == null || pks.length == 0) {
            return;
        }
        Set flowSet = SCMServerUtils.getHasBizFlowValueBillID((Context)this.ctx, (String)"T_SM_PurOrderEntry", (IObjectPK[])pks);
        HashSet<IObjectPK> idsSet = new HashSet<IObjectPK>();
        StringBuffer params = new StringBuffer();
        for (int i = 0; i < pks.length; ++i) {
            if (flowSet != null && flowSet.contains(pks[i].toString())) continue;
            idsSet.add(pks[i]);
        }
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance((Context)this.ctx);
        PurOrderInfo updatePurOrderInfo = null;
        PurOrderCollection coll = null;
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("id", idsSet, CompareType.INCLUDE));
        view.setFilter(filter);
        view.setSelector(SCMSelectorFactory.getPurOrderSelector((boolean)true));
        coll = iPurOrder.getPurOrderCollection(view);
        ArrayList<String> list = new ArrayList<String>();
        if (coll != null && coll.size() > 0) {
            int count = coll.size();
            for (int i = 0; i < count; ++i) {
                updatePurOrderInfo = coll.get(i);
                if (updatePurOrderInfo == null || updatePurOrderInfo.getBaseStatus() != BillBaseStatusEnum.AUDITED || updatePurOrderInfo.getVersion() <= 1 || updatePurOrderInfo.getSourceBillType() == null || !"MmEE6VBsR0KaUDQmebwhP0Y+1VI=".equals(updatePurOrderInfo.getSourceBillType().getId().toString())) continue;
                list.add(updatePurOrderInfo.getId().toString());
            }
        }
        if ((size = list.size()) > 0) {
            String[] purIds = new String[size];
            for (int i = 0; i < size; ++i) {
                purIds[i] = (String)list.get(i);
            }
            StockReqFacadeFactory.getLocalInstance((Context)this.ctx).batchCheckSrcBillStockReqAudit(purIds);
        }
    }
}

