/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.ctrl.kdf.data.logging.Logger;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.framework.ejb.EJBFactory;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.ICustomer;
import com.kingdee.eas.basedata.master.cssp.SupplierFactory;
import com.kingdee.eas.basedata.master.material.IMaterialInventory;
import com.kingdee.eas.basedata.master.material.IMaterialPurchasing;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialInventoryCollection;
import com.kingdee.eas.basedata.master.material.MaterialInventoryFactory;
import com.kingdee.eas.basedata.master.material.MaterialInventoryInfo;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingCollection;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingFactory;
import com.kingdee.eas.basedata.master.material.MaterialPurchasingInfo;
import com.kingdee.eas.basedata.master.material.UsedStatusEnum;
import com.kingdee.eas.basedata.org.AdminOrgUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.PurchaseOrgUnitInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.DestinationTypeEnum;
import com.kingdee.eas.basedata.scm.common.RowTypeInfo;
import com.kingdee.eas.basedata.scm.sm.srm.ApprovedSupplierFactory;
import com.kingdee.eas.basedata.scm.sm.srm.IApprovedSupplier;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillException;
import com.kingdee.eas.scm.common.SCMParamFacadeFactory;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.sm.app.bizprocess.processor.SDSMBizDataCheckProcessor;
import com.kingdee.eas.scm.sm.pur.CheckPriceResult;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderExpenseEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderExpenseEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.PurPriceParam;
import com.kingdee.eas.scm.sm.pur.PurPriceParamCollection;
import com.kingdee.eas.scm.sm.pur.PurServiceFacadeFactory;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import com.kingdee.eas.scm.util.SCMUtil;
import com.kingdee.eas.scm.util.filehandle.ResourceUtil;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.NumericExceptionSubItem;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PurOrderBizDataCheckProcessor
extends SDSMBizDataCheckProcessor {
    private static final long serialVersionUID = 1L;
    private Map<String, CompanyOrgUnitInfo> companyMap = new HashMap<String, CompanyOrgUnitInfo>();
    Map<String, String> storageOrgUnitMap = new HashMap<String, String>();
    Map<String, String> adminOrgUnitMap = new HashMap<String, String>();
    String typeStorageRelation = null;
    String typeAdminRelation = null;

    public PurOrderBizDataCheckProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurOrderBizDataCheckProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        super.doProcessing(batchResults);
        this.doCheck(batchResults);
    }

    private void doCheck(BatchActionResults batchResults) throws EASBizException, BOSException {
        int i;
        PurOrderEntryInfo entry;
        PurOrderEntryCollection entries;
        PurOrderInfo purOrderInfo;
        BatchExecuteParamsEntry[] collection = batchResults.getParamEntries();
        if (collection == null) {
            return;
        }
        int nrow = 0;
        Map<String, MaterialInventoryInfo> matInventoryMap = null;
        Map<Object, Object> matPurchaseMap = new HashMap(0);
        Map<String, CompanyOrgUnitInfo> storageCompany = null;
        ArrayList<String> matIdList = new ArrayList<String>();
        ArrayList<BOSUuid> storageOrgIdList = new ArrayList<BOSUuid>();
        int len = collection[0].toArray().length;
        String[] pOrgIds = new String[len];
        boolean isRequired = false;
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = null;
        RowTypeInfo rowTypeInfo = null;
        boolean isPurOrderPriceZero = false;
        boolean isUsePurSup = false;
        String[] keys = new String[]{"PURORDERPRICE001"};
        HashMap map = SCMParamFacadeFactory.getLocalInstance((Context)this.ctx).getScmSpecialParams(keys);
        BigDecimal zero = SysConstant.BIGZERO;
        for (int i2 = 0; i2 < len; ++i2) {
            if (!(collection[0].toArray()[i2] instanceof PurOrderInfo) || (purOrderInfo = (PurOrderInfo)collection[0].toArray()[i2]) == null) continue;
            purchaseOrgUnitInfo = purOrderInfo.getPurchaseOrgUnit();
            matPurchaseMap = this.getMaterialPurchaseCollec((IObjectValue)purOrderInfo);
            entries = purOrderInfo.getEntries();
            entry = null;
            pOrgIds[i2] = purOrderInfo.getPurchaseOrgUnit() != null ? purOrderInfo.getPurchaseOrgUnit().getId().toString() : null;
            if (entries == null) continue;
            int count = entries.size();
            for (int j = 0; j < count; ++j) {
                entry = entries.get(j);
                if (entry == null || entry.getMaterial() == null) continue;
                matIdList.add(entry.getMaterial().getId().toString());
                if (entry.getStorageOrgUnit() == null || entry.getStorageOrgUnit().getId() == null) continue;
                storageOrgIdList.add(entry.getStorageOrgUnit().getId());
            }
        }
        int leng = matIdList.size();
        String[] matIds = new String[leng];
        String[] storageOrgIds = new String[leng];
        for (i = 0; i < leng; ++i) {
            matIds[i] = matIdList.get(i) != null ? ((String)matIdList.get(i)).toString() : null;
            if (storageOrgIdList == null || storageOrgIdList.size() <= 0) continue;
            storageOrgIds[i] = i < storageOrgIdList.size() && storageOrgIdList.get(i) != null ? ((BOSUuid)storageOrgIdList.get(i)).toString() : null;
        }
        matInventoryMap = this.getMaterialInventoryCollection(matIds, storageOrgIds);
        if (this.companyMap == null || this.companyMap.size() == 0) {
            this.companyMap = this.getCompanyInfos(pOrgIds, OrgType.Purchase, OrgType.Company);
        } else {
            boolean isRevalue = false;
            int size = pOrgIds.length;
            for (int i3 = 0; i3 < size; ++i3) {
                if (pOrgIds[i3] == null || this.companyMap.get(pOrgIds[i3]) != null) continue;
                isRevalue = true;
                break;
            }
            if (isRevalue) {
                this.companyMap = this.getCompanyInfos(pOrgIds, OrgType.Purchase, OrgType.Company);
            }
        }
        storageCompany = this.getCompanyInfos(storageOrgIds, OrgType.Storage, OrgType.Company);
        isPurOrderPriceZero = map.get("PURORDERPRICE001") == null ? false : (Boolean)map.get("PURORDERPRICE001");
        int size = len;
        for (i = 0; i < size; ++i) {
            CheckPriceResult checkResult;
            String paramValue;
            if (!(collection[0].toArray()[i] instanceof PurOrderInfo) || (purOrderInfo = (PurOrderInfo)collection[0].toArray()[i]) == null) continue;
            entries = purOrderInfo.getEntries();
            entry = null;
            if (purOrderInfo.getPurchaseOrgUnit() != null && (paramValue = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamValue((IObjectPK)new ObjectUuidPK(purOrderInfo.getPurchaseOrgUnit().getId().toString()), "PURSUP001")) != null) {
                isUsePurSup = "true".equalsIgnoreCase(paramValue);
            }
            if (this.batchAction.equals((Object)BatchActionEnum.SAVE)) {
                if (purOrderInfo.getPurchaseOrgUnit() == null) {
                    throw new PurOrderException(PurOrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"ORDER_FIELD_PURCHASEORGUNIT", (Context)this.ctx)});
                }
                if (purOrderInfo.getBaseStatus().getValue() == 0 || purOrderInfo.getBaseStatus().getValue() == 1) continue;
                throw new PurOrderException(PurOrderException.ORDER_ONLYTEMP_CANBE_SAVE);
            }
            if (!this.batchAction.equals((Object)BatchActionEnum.SUBMIT)) continue;
            if (purOrderInfo.getBaseStatus().getValue() != 0 && purOrderInfo.getBaseStatus().getValue() != 1 && purOrderInfo.getBaseStatus().getValue() != 2 && purOrderInfo.getBaseStatus().getValue() != -2) {
                throw new PurOrderException(PurOrderException.ORDER_CANNOT_UPDATE, (Object[])new String[]{purOrderInfo.getBaseStatus().toString()});
            }
            if (purOrderInfo.getPurchaseOrgUnit() == null) {
                throw new PurOrderException(PurOrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"ORDER_FIELD_PURCHASEORGUNIT", (Context)this.ctx)});
            }
            if (purOrderInfo.getSupplier() == null) {
                throw new PurOrderException(PurOrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"ORDER_FIELD_SUPPLIER", (Context)this.ctx)});
            }
            if (purOrderInfo.getBizDate() == null) {
                throw new PurOrderException(PurOrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"ORDER_FIELD_ORDERDATE", (Context)this.ctx)});
            }
            if (purOrderInfo.getCurrency() == null) {
                throw new PurOrderException(PurOrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"ORDER_FIELD_CURRENCY", (Context)this.ctx)});
            }
            if (purOrderInfo.getExchangeRate() == null) {
                throw new PurOrderException(PurOrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"ORDER_FIELD_EXCHANGERATE", (Context)this.ctx)});
            }
            if (purOrderInfo.getPaymentType() == null) {
                throw new PurOrderException(PurOrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"ORDER_FIELD_PAYMENTTYPE", (Context)this.ctx)});
            }
            if (purOrderInfo.isIsCentralBalance() && purOrderInfo.getStorageOrgUnit() == null) {
                throw new PurOrderException(PurOrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getUIResource((String)"ORDER_FIELD_STORAGEORGUNIT")});
            }
            if (purOrderInfo.isIsCentralBalance() && purOrderInfo.getBizType() != null && purOrderInfo.getBizType().getId().toString().equals("d8e80652-0106-1000-e000-04c5c0a812202407435C") && this.companyMap.get(purOrderInfo.getPurchaseOrgUnit().getId().toString()) != null) {
                CompanyOrgUnitInfo company = null;
                company = this.companyMap.get(purOrderInfo.getPurchaseOrgUnit().getId().toString());
                if (!SupplierFactory.getLocalInstance((Context)this.ctx).isExistSupplierByInter(company.getId().toString())) {
                    throw new PurOrderException(PurOrderException.COMPANY_NOHAS_INTERSUPP);
                }
            }
            String bizTypeId = null;
            if (purOrderInfo.getBizType() != null) {
                bizTypeId = purOrderInfo.getBizType().getId().toString();
            }
            if ((nrow = purOrderInfo.getEntries().size()) <= 0) {
                throw new PurOrderException(PurOrderException.ENTRY_CANNOT_EMPTY);
            }
            if (isUsePurSup) {
                this.checkApprovedQty(purOrderInfo);
            }
            PurPriceParamCollection paramCol = new PurPriceParamCollection();
            paramCol.setBillTypeId(purOrderInfo.getBillType().getId().toString());
            paramCol.setBizTypeId(purOrderInfo.getBizType().getId().toString());
            if (entries != null) {
                ICustomer iCustomer = CustomerFactory.getLocalInstance((Context)this.ctx);
                CompanyOrgUnitInfo company = null;
                boolean isUseAssit = false;
                StringBuffer bf = new StringBuffer();
                if (purOrderInfo.getPurchaseOrgUnit() != null && (paramValue = ParamControlFactory.getLocalInstance((Context)this.ctx).getParamValue((IObjectPK)new ObjectUuidPK(purOrderInfo.getPurchaseOrgUnit().getId().toString()), "PURORDER100")) != null) {
                    isUseAssit = "true".equalsIgnoreCase(paramValue);
                }
                int count = entries.size();
                for (int j = 0; j < count; ++j) {
                    entry = entries.get(j);
                    if (entry != null) {
                        boolean checkStorage;
                        if (entry.getRowType() == null) {
                            throw new PurOrderException(PurOrderException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ROWTYPE", (Context)this.ctx)});
                        }
                        rowTypeInfo = entry.getRowType();
                        if (rowTypeInfo.isIsHasMaterialNumber() && entry.getMaterial() == null) {
                            throw new PurOrderException(PurOrderException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ORDER_FIELD_MATERIAL", (Context)this.ctx)});
                        }
                        if (!rowTypeInfo.isIsHasMaterialNumber() && entry.getMaterialName() == null) {
                            throw new PurOrderException(PurOrderException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"batchSumbit_checkMaterialName", (Context)this.ctx)});
                        }
                        if (!isUseAssit && rowTypeInfo.isIsHasMaterialNumber() && entry.getMaterial() != null && entry.getMaterial().getAssistAttr() != null && entry.getAssistProperty() == null) {
                            throw new PurOrderException(PurOrderException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ASSISTPRO", (Context)this.ctx)});
                        }
                        if (entry.getUnit() == null) {
                            throw new PurOrderException(PurOrderException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ORDER_FIELD_UNIT", (Context)this.ctx)});
                        }
                        if (entry.getQty() == null || entry.getQty().compareTo(zero) == 0) {
                            throw new PurOrderException(PurOrderException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ORDER_FIELD_QUANTITY", (Context)this.ctx)});
                        }
                        if (!(isPurOrderPriceZero || this.isBizVMI(bizTypeId) || entry.isIsPresent())) {
                            if (!purOrderInfo.isIsInTax()) {
                                if (entry.getPrice() == null || entry.getPrice().compareTo(zero) == 0) {
                                    throw new PurOrderException(PurOrderException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ORDER_FIELD_PRICE", (Context)this.ctx)});
                                }
                            } else if (entry.getTaxPrice() == null || entry.getTaxPrice().compareTo(zero) == 0) {
                                throw new PurOrderException(PurOrderException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"TAXPRICE", (Context)this.ctx)});
                            }
                        }
                        if (entry.getDeliveryDate() == null) {
                            throw new PurOrderException(PurOrderException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ORDER_FIELD_DELIVERYDATE", (Context)this.ctx)});
                        }
                        if (entry.getStorageOrgUnit() != null) {
                            isRequired = true;
                        }
                        if (!(checkStorage = this.checkStorageOrgUnitIsInMaterial(purOrderInfo, entry, matInventoryMap))) {
                            String msg = new PurOrderException(PurOrderException.ORDERENTRY_STORAGEORGNOTINMATERIAL).getMessage();
                            throw new PurOrderException(PurOrderException.THRROW, (Object[])new String[]{String.valueOf(j + 1), msg});
                        }
                        if (purchaseOrgUnitInfo != null && rowTypeInfo.isIsHasMaterialNumber() && entry.getMaterial() != null && entry.getMaterial().getId() != null && !matPurchaseMap.containsKey(entry.getMaterial().getId().toString())) {
                            throw new PurOrderException(PurOrderException.THRROW, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ENTRY_STRING", (Context)this.ctx) + PurUtil.getServerResource((String)"MaterialNotMaintainPurOrg", (Context)this.ctx)});
                        }
                        if (purOrderInfo.getBizType() != null && !"d8e80652-010b-1001-e000-04c5c0a812202407435C".equals(purOrderInfo.getBizType().getId().toString())) {
                            if (rowTypeInfo.getDestinationType() != null && DestinationTypeEnum.STORAGE.equals((Object)rowTypeInfo.getDestinationType()) && entry.getRequestOrgUnit() == null) {
                                throw new PurOrderException(PurOrderException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"batchSumbit_checkReqOrg", (Context)this.ctx)});
                            }
                            if (entry.getStorageOrgUnit() == null) {
                                throw new PurOrderException(PurOrderException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ORDER_FIELD_STORAGEORGUNIT_R", (Context)this.ctx)});
                            }
                            if (entry.getCompanyOrgUnit() == null && entry.getStorageOrgUnit() != null) {
                                CompanyOrgUnitInfo companyOrgUnitInfo = null;
                                if (storageCompany != null && storageCompany.size() > 0 && entry.getStorageOrgUnit() != null && entry.getStorageOrgUnit().getId() != null) {
                                    companyOrgUnitInfo = storageCompany.get(entry.getStorageOrgUnit().getId().toString());
                                }
                                if (companyOrgUnitInfo == null) {
                                    throw new PurOrderException(PurOrderException.THRROW, (Object[])new String[]{String.valueOf(j + 1), PurUtil.getServerResource((String)"ENTRY_STRING", (Context)this.ctx) + PurUtil.getBizResource((String)"COMPANYORGUNIT_IS_NOT_EXIST", (Context)this.ctx)});
                                }
                            }
                        }
                        if (DestinationTypeEnum.COSTS.equals((Object)rowTypeInfo.getDestinationType()) && entry.getAdminOrgUnit() == null) {
                            throw new PurOrderException(PurOrderException.ENTRY_FIELD_CANNOT_EMPTY, (Object[])new String[]{String.valueOf(entry.getSeq() + 1), PurUtil.getServerResource((String)"ORDER_FIELD_ADMINORGUNIT", (Context)this.ctx)});
                        }
                    }
                    this.checkIsInApprovedSupplier(purOrderInfo, entry, isUsePurSup, matPurchaseMap, j, bf);
                    PurOrderBizDataCheckProcessor.checkOrderExpense(entry);
                    if (purOrderInfo.isIsCentralBalance() && purOrderInfo.getBizType() != null && purOrderInfo.getBizType().getId().toString().equals("d8e80652-0106-1000-e000-04c5c0a812202407435C") && !purOrderInfo.getCompanyOrgUnit().getId().toString().equals(entry.getCompanyOrgUnit().getId().toString()) && (company = entry.getCompanyOrgUnit()) != null && !iCustomer.isExistCustomerByInter(company.getId().toString())) {
                        throw new PurOrderException(PurOrderException.COMPANY_NOHAS_INTERCUSTOMER, new Object[]{entry.getSeq() + j + 1});
                    }
                    if (entry.getMaterial() == null) continue;
                    PurPriceParam param = this.getParam4FetchStrategy(purOrderInfo, entry);
                    paramCol.addPurPriceParam(param);
                }
                if (bf.length() > 0) {
                    bf.insert(0, PurUtil.getUIResource((String)"SUPPLYLIST_NOT") + "\uff1a ");
                    throw new SCMBillException(SCMBillException.EX_MSG_FOR_RPC, (Object[])new String[]{bf.toString()});
                }
            }
            if (paramCol.size() > 0 && (checkResult = PurServiceFacadeFactory.getLocalInstance((Context)this.ctx).topPriceCtrl(paramCol)).hasErrorMsg() && checkResult.getMessageType() == 1) {
                throw new PurOrderException(new NumericExceptionSubItem("11022022", checkResult.getDetailMsg()));
            }
            if (isRequired && purOrderInfo.isIsCentralBalance() && purOrderInfo.getStorageOrgUnit() == null) {
                throw new PurOrderException(PurOrderException.FIELD_CANNOT_EMPTY, (Object[])new String[]{PurUtil.getServerResource((String)"ORDER_FIELD_STORAGEORGUNIT", (Context)this.ctx)});
            }
            this.checkOrgRelation(this.ctx, purOrderInfo);
        }
    }

    private void checkIsInApprovedSupplier(PurOrderInfo purOrderInfo, PurOrderEntryInfo entry, boolean isUsePurSup, Map matPurchaseMap, int row, StringBuffer bf) throws BOSException, EASBizException {
        if (entry != null && entry.getRowType() != null && entry.getRowType().isIsHasMaterialNumber()) {
            boolean isInApprovedSupplier = false;
            String key = entry.getMaterial().getId().toString();
            MaterialPurchasingInfo materialPurchaseInfo = (MaterialPurchasingInfo)matPurchaseMap.get(key);
            if (isUsePurSup && materialPurchaseInfo.isUseSupplyList() || purOrderInfo.isIsApprovedMaterial()) {
                IApprovedSupplier iApprovedSupplier = ApprovedSupplierFactory.getLocalInstance((Context)this.ctx);
                FilterInfo tempfilter = new FilterInfo();
                tempfilter.getFilterItems().add(new FilterItemInfo("purchaseOrg.id", (Object)purOrderInfo.getPurchaseOrgUnit().getId().toString(), CompareType.EQUALS));
                tempfilter.getFilterItems().add(new FilterItemInfo("supplier.id", (Object)purOrderInfo.getSupplier().getId().toString(), CompareType.EQUALS));
                tempfilter.getFilterItems().add(new FilterItemInfo("materialItem.id", (Object)entry.getMaterial().getId().toString(), CompareType.EQUALS));
                tempfilter.getFilterItems().add(new FilterItemInfo("isUseable", (Object)"1", CompareType.EQUALS));
                if (purOrderInfo.getBizType().getId().toString().equals("LAdiD6Y5Sim6q6bmixITqSQHQ1w=")) {
                    tempfilter.getFilterItems().add(new FilterItemInfo("isVMI", (Object)"1", CompareType.EQUALS));
                }
                if (!(isInApprovedSupplier = iApprovedSupplier.exists(tempfilter))) {
                    bf.append(ResourceUtil.getMessage((String)"com.kingdee.eas.scm.sm.pur.PurUIResource", (String)"SUPPLYLIST_CONTENT_ROW", (String[])new String[]{String.valueOf(row + 1), entry.getMaterial().getNumber(), entry.getMaterial().getName()}));
                }
            }
        }
    }

    private void CheckControlQty(Context ctx, PurOrderInfo purOrderInfo) throws BOSException, EASBizException {
        BigDecimal zero;
        BigDecimal diffBaseQty = zero = new BigDecimal("0.0");
        Connection conn = null;
        PreparedStatement stmt = null;
        ResultSet rs = null;
        StringBuffer sqlBuff = new StringBuffer();
        StringBuffer errorStr = new StringBuffer();
        HashMap<String, BigDecimal> hsPurOrder = new HashMap<String, BigDecimal>();
        Object[] errorArr = new String[1];
        LinkedHashMap<String, String> hsSeq = new LinkedHashMap<String, String>();
        HashMap<String, List<String>> hsContent = new HashMap<String, List<String>>();
        List<String> contentList = null;
        int errors = 0;
        String purOrderID = purOrderInfo.getId().toString();
        if (SCMUtils.isBotpBill((SCMBillBaseInfo)purOrderInfo, (String)"510b6503-0105-1000-e000-0107c0a812fd463ED552")) {
            block11: {
                try {
                    conn = EJBFactory.getConnection((Context)ctx);
                    sqlBuff.append(" SELECT PR.FUnorderedBaseQty, PO.FBaseQty, PO.FSeq, ");
                    sqlBuff.append(" PO.FSourceBillEntryID, PO.FMaterialName, MMU.FMeasureUnitID,");
                    sqlBuff.append(" MMU.FMaterialID, MMU.FBaseConvsRate, MMU.FQtyPrecision, MM.FName_L2 as FUnitName from T_SM_PURORDERENTRY PO ");
                    sqlBuff.append(" left join T_SM_PURREQUESTENTRY PR on PR.FID = PO.FSourceBillEntryID  ");
                    sqlBuff.append(" left join T_BD_MULTIMEASUREUNIT MMU on (PO.FUnitID=MMU.FMeasureUnitID and PR.FMaterialID = MMU.FMaterialID)");
                    sqlBuff.append(" left join T_BD_MeasureUnit MM on MM.FID = PO.FUnitID");
                    sqlBuff.append(" where PR.FIsQuantityUnCtrl = 0 and PO.FParentId = '");
                    sqlBuff.append(purOrderID).append("'");
                    sqlBuff.append(" order by PO.FSeq");
                    stmt = conn.prepareStatement(sqlBuff.toString());
                    rs = stmt.executeQuery();
                    PurOrderEntryCollection entryCollection = purOrderInfo.getEntries();
                    PurOrderEntryInfo entryInfo = null;
                    while (rs.next()) {
                        entryInfo = entryCollection.get(rs.getInt("FSeq") - 1);
                        diffBaseQty = rs.getBigDecimal("FUnorderedBaseQty").subtract(entryInfo.getBaseQty());
                        if (diffBaseQty.signum() != -1) continue;
                        String sourceBillEntryId = rs.getString("FSourceBillEntryID");
                        hsPurOrder.put(sourceBillEntryId, diffBaseQty);
                        if (hsSeq.containsKey(sourceBillEntryId)) {
                            String fseq = (String)hsSeq.get(sourceBillEntryId);
                            fseq = fseq + "," + String.valueOf(rs.getInt("FSeq"));
                            hsSeq.put(sourceBillEntryId, fseq);
                        } else {
                            hsSeq.put(sourceBillEntryId, String.valueOf(rs.getInt("FSeq")));
                            contentList = new ArrayList();
                            contentList.add(0, rs.getString("FMaterialName"));
                            BigDecimal qty = (BigDecimal)hsPurOrder.get(sourceBillEntryId);
                            MeasureUnitInfo unit = new MeasureUnitInfo();
                            MeasureUnitInfo baseUnit = new MeasureUnitInfo();
                            unit.setId(BOSUuid.read((String)entryInfo.getUnit().getId().toString()));
                            baseUnit.setId(BOSUuid.read((String)entryInfo.getBaseUnit().getId().toString()));
                            if (purOrderInfo.getEntries().get(0).getRowType().isIsHasMaterialNumber()) {
                                qty = qty.abs().divide(rs.getBigDecimal("FBaseConvsRate"), rs.getInt("FQtyPrecision"), 4);
                                qty = SCMUtil.getExchangeQtyForClient((Context)ctx, (String)entryInfo.getMaterial().getId().toString(), (MeasureUnitInfo)baseUnit, (MeasureUnitInfo)unit, (BigDecimal)qty);
                                boolean bl = false;
                            } else {
                                qty = qty.abs().setScale(2, 4);
                            }
                            String qtyStr = qty.toPlainString();
                            contentList.add(1, qtyStr);
                            contentList.add(2, entryInfo.getUnit().toString());
                            hsContent.put(sourceBillEntryId, contentList);
                        }
                        ++errors;
                    }
                    if (errors <= 0) break block11;
                    Set keyset = hsSeq.keySet();
                    Iterator it = keyset.iterator();
                    String errorMsg = SCMUtils.getResource((String)"com.kingdee.eas.scm.sm.pur.PurBizResource", (String)"QtyCheckError", (Context)ctx);
                    while (it.hasNext()) {
                        String billEntryId = (String)it.next();
                        errorStr.append("\n");
                        if (hsSeq.get(billEntryId) == null || hsContent.get(billEntryId) == null || !(hsContent.get(billEntryId) instanceof List)) continue;
                        contentList = new ArrayList<String>();
                        contentList = (List)hsContent.get(billEntryId);
                        errorStr.append(MessageFormat.format(errorMsg, (String)hsSeq.get(billEntryId), contentList.get(0), contentList.get(1), contentList.get(2)));
                    }
                    errorArr[0] = errorStr.toString();
                    throw new PurOrderException(PurOrderException.PURORDER_QTY_NOMATHCH, errorArr);
                }
                catch (SQLException ex) {
                    try {
                        throw new BOSException((Throwable)ex);
                    }
                    catch (Throwable throwable) {
                        SQLUtils.cleanup(rs, stmt, (Connection)conn);
                        throw throwable;
                    }
                }
            }
            SQLUtils.cleanup((ResultSet)rs, (Statement)stmt, (Connection)conn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkApprovedQty(PurOrderInfo purOrderInfo) throws BOSException, EASBizException {
        StringBuffer tempTableSql = new StringBuffer();
        StringBuffer insertSql = new StringBuffer();
        StringBuffer updateTableSql = new StringBuffer();
        StringBuffer selectSql = new StringBuffer();
        PurOrderEntryCollection entries = purOrderInfo.getEntries();
        tempTableSql.append("CREATE TABLE PUORDER_TEMP (FLINENUM INT,FBASEQTY Decimal(28,10),");
        tempTableSql.append("FMaterialID VARCHAR(44),FSupplierID VARCHAR(44),FPurchaseOrgID VARCHAR(44))");
        String tempTableName = "";
        try {
            try {
                tempTableName = TempTablePool.getInstance((Context)this.ctx).createTempTable(tempTableSql.toString());
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            insertSql.append("INSERT INTO ").append(tempTableName).append(" ");
            insertSql.append("(FLINENUM,FBASEQTY,FMaterialID,FSupplierID,FPurchaseOrgID) ");
            insertSql.append("values(?,?,?,?,?)");
            ArrayList<Object[]> paramList = new ArrayList<Object[]>();
            if (entries != null) {
                for (int i = 0; i < entries.size(); ++i) {
                    PurOrderEntryInfo entry = entries.get(i);
                    if (entry.getMaterial() == null || purOrderInfo.getSupplier() == null || purOrderInfo.getPurchaseOrgUnit() == null) continue;
                    Object[] obj = new Object[]{i, entry.getBaseQty(), entry.getMaterial().getId().toString(), purOrderInfo.getSupplier().getId().toString(), purOrderInfo.getPurchaseOrgUnit().getId().toString()};
                    paramList.add(obj);
                }
            }
            if (paramList.isEmpty() && paramList.size() <= 0) {
                return;
            }
            DbUtil.executeBatch((Context)this.ctx, (String)insertSql.toString(), paramList);
            updateTableSql.append("update ").append(tempTableName).append(" as t set FBASEQTY= (select t2.FSumQty ");
            updateTableSql.append("from (select sum(t1.FBASEQTY) FSumQty, t1.FmaterialId  FMaterialID from ");
            updateTableSql.append(tempTableName).append(" as t1 group by fmaterialid) as t2 where t.FmaterialId = t2.FMaterialId)");
            DbUtil.execute((Context)this.ctx, (String)updateTableSql.toString());
            selectSql.append("select FLINENUM, ");
            selectSql.append("case when temp.FBASEQTY < (appSup.FqtyOrderBottom*unit.FBaseConvsRate) then 1 else 2 end as flag from ");
            selectSql.append(tempTableName).append(" as temp ");
            selectSql.append("inner join T_SM_ApprovedSupplier as appSup on appSup.FPurchaseOrgID=temp.FPurchaseOrgID");
            selectSql.append(" and appSup.FSupplierID=temp.FSupplierID and\tappSup.FMaterialItemID=temp.FMaterialID ");
            selectSql.append(" and appSup.FMaterialAttr=0 ");
            selectSql.append("inner join t_bd_multimeasureunit as unit on unit.fmaterialid=appSup.FMaterialItemID ");
            selectSql.append("and unit.fmeasureunitid=appSup.FPurMeasureUnitID ");
            selectSql.append("where appSup.FISUSEABLE =1 and (temp.FBASEQTY<(appSup.FqtyOrderBottom*unit.FBaseConvsRate) or  temp.FBASEQTY>(appSup.FqtyOrderTop*unit.FBaseConvsRate))");
            IRowSet rs = DbUtil.executeQuery((Context)this.ctx, (String)selectSql.toString());
            try {
                StringBuffer stringBuffer = new StringBuffer();
                String NoString = PurUtil.getServerResource((String)"NO", (Context)this.ctx);
                String RowString = PurUtil.getServerResource((String)"ROW", (Context)this.ctx);
                while (rs.next()) {
                    if (rs.getString("flag").equals("1")) {
                        stringBuffer.append(NoString).append(Integer.parseInt(rs.getString("FLINENUM")) + 1).append(RowString).append(PurUtil.getServerResource((String)"QTY_APPROVEDSUPPLIERBOTTOMQTY", (Context)this.ctx)).append("\n");
                    }
                    if (!rs.getString("flag").equals("2")) continue;
                    stringBuffer.append(NoString).append(Integer.parseInt(rs.getString("FLINENUM")) + 1).append(RowString).append(PurUtil.getServerResource((String)"QTY_APPROVEDSUPPLIERTOPQTY", (Context)this.ctx)).append("\n");
                }
                if (stringBuffer.length() > 0) {
                    throw new PurOrderException(PurOrderException.ENTRY_FIELD_QTY_APPROVEDSUPPLIERQTY, (Object[])new String[]{stringBuffer.toString()});
                }
            }
            catch (SQLException e) {
                throw new BOSException((Throwable)e);
            }
        }
        finally {
            if (tempTableName != null) {
                TempTablePool pool = TempTablePool.getInstance((Context)this.ctx);
                pool.releaseTable(tempTableName);
            }
        }
    }

    public static void checkOrderExpense(PurOrderEntryInfo entryInfo) throws PurOrderException {
        PurOrderExpenseEntryCollection expenseEntryCollection = null;
        expenseEntryCollection = entryInfo.getEntries();
        PurOrderExpenseEntryInfo info = null;
        BigDecimal entryExpense = SysConstant.BIGZERO;
        BigDecimal zeroPone = new BigDecimal("0.1");
        Iterator iterator = expenseEntryCollection.iterator();
        while (iterator.hasNext()) {
            info = (PurOrderExpenseEntryInfo)iterator.next();
            if (info == null) continue;
            if (info.getExpenseItem() == null && info.getExpenseAmount() != null && info.getExpenseAmount().compareTo(SysConstant.BIGZERO) > 0) {
                throw new PurOrderException(PurOrderException.ORDER_EXPENSEITEM_NULL);
            }
            if (info.getExpenseItem() != null && (info.getUnitExpense() == null || info.getUnitExpense().compareTo(SysConstant.BIGZERO) == 0 || info.getExpenseAmount() == null || info.getExpenseAmount().compareTo(SysConstant.BIGZERO) == 0)) {
                throw new PurOrderException(PurOrderException.ORDER_EXPENSE_AMOUNT_NULL);
            }
            if (info.getExpenseItem() != null || info.getUnitExpense() != null && info.getUnitExpense().compareTo(SysConstant.BIGZERO) != 0 && info.getExpenseAmount() != null && info.getExpenseAmount().compareTo(SysConstant.BIGZERO) != 0) continue;
            iterator.remove();
            entryExpense = entryInfo.getTotalExpense().subtract(info.getExpenseAmount());
            if (entryExpense.abs().compareTo(zeroPone.pow(entryExpense.precision())) == 0) {
                entryExpense = SysConstant.BIGZERO;
            }
            entryInfo.setTotalExpense(entryExpense);
        }
    }

    protected Map<String, CompanyOrgUnitInfo> getCompanyInfos(String[] orgIds, OrgType fromType, OrgType toType) throws BOSException, EASBizException {
        HashMap<String, CompanyOrgUnitInfo> map = new HashMap<String, CompanyOrgUnitInfo>(orgIds.length);
        HashMap<String, String> couMap = new HashMap<String, String>(orgIds.length);
        HashSet<String> souIdSet = new HashSet<String>(orgIds.length);
        int length = orgIds.length;
        for (int i = 0; i < length && orgIds[i] != null; ++i) {
            couMap.put(orgIds[i].toString(), null);
            souIdSet.add(orgIds[i]);
        }
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("toUnit"));
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("fromUnit", souIdSet, CompareType.INCLUDE));
        filter.appendFilterItem("typeRelation.fromType", (Object)new Integer(fromType.getValue()));
        filter.appendFilterItem("typeRelation.toType", (Object)new Integer(toType.getValue()));
        filter.setMaskString("#0 and #1 and #2");
        view.setFilter(filter);
        view.getSelector().add("toUnit.id");
        view.getSelector().add("fromUnit.id");
        OrgUnitRelationCollection ourCol = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx).getOrgUnitRelationCollection(view);
        if (ourCol.size() > 0) {
            HashSet<BOSUuid> couIdSet = new HashSet<BOSUuid>(ourCol.size());
            int size = ourCol.size();
            for (int i = 0; i < size; ++i) {
                OrgUnitRelationInfo ourInfo = ourCol.get(i);
                couMap.put(ourInfo.getFromUnit().getId().toString(), ourInfo.getToUnit().getId().toString());
                couIdSet.add(ourInfo.getToUnit().getId());
            }
            FilterInfo couFilter = new FilterInfo();
            couFilter.getFilterItems().add(new FilterItemInfo("id", couIdSet, CompareType.INCLUDE));
            EntityViewInfo couView = new EntityViewInfo();
            couView.setFilter(couFilter);
            CompanyOrgUnitCollection couCol = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(couView);
            HashMap<String, CompanyOrgUnitInfo> couMap2 = new HashMap<String, CompanyOrgUnitInfo>();
            int size2 = couCol.size();
            for (int i = 0; i < size2; ++i) {
                couMap2.put(couCol.get(i).getId().toString(), couCol.get(i));
            }
            for (String key : couMap.keySet()) {
                if (couMap.get(key) == null) continue;
                map.put(key, (CompanyOrgUnitInfo)couMap2.get(couMap.get(key)));
            }
        }
        return map;
    }

    private Map<String, MaterialPurchasingInfo> getMaterialPurchaseCollec(IObjectValue bean) throws BOSException, EASBizException {
        HashMap<String, MaterialPurchasingInfo> matPurchase = new HashMap<String, MaterialPurchasingInfo>();
        if (bean == null) {
            return matPurchase;
        }
        PurOrderInfo info = (PurOrderInfo)bean;
        if (info.getPurchaseOrgUnit() == null) {
            return matPurchase;
        }
        PurOrderEntryCollection entries = info.getEntries();
        PurOrderEntryInfo entry = null;
        MaterialInfo material = null;
        MaterialPurchasingInfo matPurchaseInfo = null;
        RowTypeInfo rowTypeInfo = null;
        HashSet<String> materialSet = new HashSet<String>();
        int size = entries.size();
        for (int i = 0; i < size; ++i) {
            entry = entries.get(i);
            rowTypeInfo = entry.getRowType();
            if (rowTypeInfo == null || !rowTypeInfo.isIsHasMaterialNumber() || (material = entry.getMaterial()) == null) continue;
            materialSet.add(material.getId().toString());
        }
        IMaterialPurchasing iMaterialPurchase = MaterialPurchasingFactory.getLocalInstance((Context)this.ctx);
        EntityViewInfo entityViewInfo = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", materialSet, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", (Object)info.getPurchaseOrgUnit().getId().toString()));
        filter.getFilterItems().add(new FilterItemInfo("status", (Object)UsedStatusEnum.APPROVED));
        entityViewInfo.setFilter(filter);
        SelectorItemCollection selector = new SelectorItemCollection();
        selector.add("id");
        selector.add("number");
        selector.add("isSequenceNo");
        selector.add("material.id");
        selector.add("orgUnit.id");
        selector.add("useSupplyList");
        entityViewInfo.setSelector(selector);
        MaterialPurchasingCollection col = iMaterialPurchase.getMaterialPurchasingCollection(entityViewInfo);
        for (int i = 0; i < col.size(); ++i) {
            matPurchaseInfo = col.get(i);
            matPurchase.put(matPurchaseInfo.getMaterial().getId().toString(), matPurchaseInfo);
        }
        return matPurchase;
    }

    protected Map<String, MaterialInventoryInfo> getMaterialInventoryCollection(String[] materialIDS, String[] orgIDs) throws BOSException {
        int i;
        Map<String, MaterialInventoryInfo> matInventory = new HashMap<String, MaterialInventoryInfo>();
        HashSet<String> keySet = new HashSet<String>();
        FilterInfo filter = new FilterInfo();
        StringBuffer sb = new StringBuffer();
        HashSet<String> materialSet = new HashSet<String>();
        HashSet<String> orgSet = new HashSet<String>();
        int size = materialIDS.length;
        for (i = 0; i < size; ++i) {
            if (orgIDs[i] == null) continue;
            orgSet.add(orgIDs[i]);
        }
        if (orgSet.size() > 10) {
            String key = "";
            if (materialIDS != null && orgIDs != null) {
                int size2 = materialIDS.length;
                for (int i2 = 0; i2 < size2; ++i2) {
                    if (materialIDS[i2] == null || orgIDs[i2] == null || keySet.contains(key = materialIDS[i2] + orgIDs[i2])) continue;
                    filter.getFilterItems().add(new FilterItemInfo("material", (Object)materialIDS[i2], CompareType.EQUALS));
                    filter.getFilterItems().add(new FilterItemInfo("orgUnit", (Object)orgIDs[i2], CompareType.EQUALS));
                    if (sb.length() > 0) {
                        sb.append(" OR ");
                    }
                    sb.append("(#").append(filter.getFilterItems().size() - 2).append(" AND #").append(filter.getFilterItems().size() - 1).append(")");
                    keySet.add(key);
                    if (keySet.size() % 300 != 299) continue;
                    if (sb.length() > 0) {
                        filter.setMaskString(sb.toString());
                    }
                    matInventory = this.getMaterialInventorys(filter, matInventory);
                    filter = new FilterInfo();
                    sb.setLength(0);
                }
                if (sb.length() > 0) {
                    filter.setMaskString(sb.toString());
                }
                matInventory = this.getMaterialInventorys(filter, matInventory);
            }
        } else if (materialIDS != null) {
            size = materialIDS.length;
            for (i = 0; i < size; ++i) {
                if (materialIDS[i] == null) continue;
                materialSet.add(materialIDS[i]);
                if (materialSet.size() % 800 != 799) continue;
                filter.getFilterItems().add(new FilterItemInfo("material.id", materialSet, CompareType.INCLUDE));
                filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgSet, CompareType.INCLUDE));
                matInventory = this.getMaterialInventorys(filter, matInventory);
                filter = new FilterInfo();
                materialSet.clear();
            }
            filter.getFilterItems().add(new FilterItemInfo("material.id", materialSet, CompareType.INCLUDE));
            filter.getFilterItems().add(new FilterItemInfo("orgUnit.id", orgSet, CompareType.INCLUDE));
            matInventory = this.getMaterialInventorys(filter, matInventory);
        }
        return matInventory;
    }

    private Map<String, MaterialInventoryInfo> getMaterialInventorys(FilterInfo filter, Map<String, MaterialInventoryInfo> matInventory) throws BOSException {
        EntityViewInfo view = new EntityViewInfo();
        MaterialInventoryInfo materialInventoryInfo = null;
        String key = "";
        IMaterialInventory iMaterialInventory = MaterialInventoryFactory.getLocalInstance((Context)this.ctx);
        view.setFilter(filter);
        MaterialInventoryCollection coll = iMaterialInventory.getMaterialInventoryCollection(view);
        if (coll != null) {
            for (int j = 0; j < coll.size(); ++j) {
                materialInventoryInfo = coll.get(j);
                if (materialInventoryInfo == null || materialInventoryInfo.getMaterial() == null || materialInventoryInfo.getOrgUnit() == null) continue;
                key = materialInventoryInfo.getMaterial().getId().toString() + materialInventoryInfo.getOrgUnit().getId().toString();
                matInventory.put(key, materialInventoryInfo);
            }
        }
        return matInventory;
    }

    private boolean isAdminOrgUnit(PurOrderInfo purOrderInfo) {
        return purOrderInfo.getBizType() != null && ("d8e80652-0108-1000-e000-04c5c0a812202407435C".equalsIgnoreCase(purOrderInfo.getBizType().getId().toString()) || "d8e80652-010c-1000-e000-04c5c0a812202407435C".equalsIgnoreCase(purOrderInfo.getBizType().getId().toString()) || "d8e80652-010a-1000-e000-04c5c0a812202407435C".equalsIgnoreCase(purOrderInfo.getBizType().getId().toString()));
    }

    protected boolean checkStorageOrgUnitIsInMaterial(PurOrderInfo orderInfo, PurOrderEntryInfo entryInfo, Map<String, MaterialInventoryInfo> materialStorageMap) throws EASBizException {
        if (!this.isAdminOrgUnit(orderInfo)) {
            if (entryInfo.getMaterial() == null && entryInfo.getMaterialName() == null || entryInfo.getStorageOrgUnit() == null) {
                return true;
            }
            if (entryInfo.getMaterial() != null && entryInfo.getMaterial().getId() != null && entryInfo.getStorageOrgUnit() != null && entryInfo.getStorageOrgUnit().getId() != null) {
                if (!materialStorageMap.containsKey(entryInfo.getMaterial().getId().toString() + entryInfo.getStorageOrgUnit().getId().toString())) {
                    return false;
                }
                MaterialInventoryInfo info = materialStorageMap.get(entryInfo.getMaterial().getId().toString() + entryInfo.getStorageOrgUnit().getId().toString());
                if (info == null || info.getStatus().getValue() != 1) {
                    return false;
                }
            }
            return true;
        }
        return true;
    }

    protected void checkOrgRelation(Context ctx, PurOrderInfo purOrderInfo) throws EASBizException, BOSException {
        PurOrderEntryCollection tmpEntries = purOrderInfo.getEntries();
        PurOrderEntryInfo poEntryInfo = null;
        StorageOrgUnitInfo requestOrgUnitInfo = null;
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        AdminOrgUnitInfo adminOrgUnitInfo = null;
        String requestOrgUnitID = null;
        String storageOrgUnitID = null;
        String adminOrgUnitID = null;
        PurchaseOrgUnitInfo purchaseOrgUnitInfo = purOrderInfo.getPurchaseOrgUnit();
        String[] purchaseOrgUnitID = new String[1];
        if (purchaseOrgUnitInfo != null) {
            purchaseOrgUnitID[0] = purchaseOrgUnitInfo.getId().toString();
        }
        if (this.typeStorageRelation == null) {
            this.typeStorageRelation = this.getOrgTypeRelation(ctx, OrgType.Storage, OrgType.Purchase);
        }
        if (this.typeAdminRelation == null) {
            this.typeAdminRelation = this.getOrgTypeRelation(ctx, OrgType.Admin, OrgType.Purchase);
        }
        if (this.typeStorageRelation != null && !this.typeStorageRelation.equals("")) {
            this.storageOrgUnitMap = this.getCouOrgUnit(ctx, purchaseOrgUnitID, this.typeStorageRelation);
        }
        if (this.typeAdminRelation != null && !this.typeAdminRelation.equals("")) {
            this.adminOrgUnitMap = this.getCouOrgUnit(ctx, purchaseOrgUnitID, this.typeAdminRelation);
        }
        int count = tmpEntries.size();
        for (int i = 0; i < count; ++i) {
            poEntryInfo = tmpEntries.get(i);
            requestOrgUnitInfo = poEntryInfo.getRequestOrgUnit();
            storageOrgUnitInfo = poEntryInfo.getStorageOrgUnit();
            adminOrgUnitInfo = poEntryInfo.getAdminOrgUnit();
            if (requestOrgUnitInfo != null && !this.storageOrgUnitMap.containsKey(requestOrgUnitID = requestOrgUnitInfo.getId().toString())) {
                throw new PurOrderException(PurOrderException.REQUEST_RELATION_ERROR, (Object[])new String[]{i + 1 + ""});
            }
            if (storageOrgUnitInfo != null && !this.storageOrgUnitMap.containsKey(storageOrgUnitID = storageOrgUnitInfo.getId().toString())) {
                throw new PurOrderException(PurOrderException.STORAGE_RELATION_ERROR, (Object[])new String[]{i + 1 + ""});
            }
            if (adminOrgUnitInfo == null || this.adminOrgUnitMap.containsKey(adminOrgUnitID = adminOrgUnitInfo.getId().toString())) continue;
            throw new PurOrderException(PurOrderException.ADMIN_RELATION_ERROR, (Object[])new String[]{i + 1 + ""});
        }
    }

    protected String getOrgTypeRelation(Context ctx, OrgType fromType, OrgType toType) throws BOSException, EASBizException {
        Connection con = null;
        Statement batchStatement = null;
        ResultSet rs = null;
        StringBuffer sql = new StringBuffer();
        String typeRelation = null;
        sql.append("select orgType.FID from T_ORG_TypeRelation orgType where orgType.FFromType = " + fromType.getValue() + " and orgType.FToType = " + toType.getValue());
        try {
            con = this.getConnection(ctx);
            batchStatement = con.createStatement();
            rs = batchStatement.executeQuery(sql.toString());
            while (rs.next()) {
                typeRelation = rs.getString(1);
            }
            sql = null;
        }
        catch (SQLException e) {
            try {
                Logger.error((Throwable)e);
                throw new BOSException();
            }
            catch (Throwable throwable) {
                sql = null;
                SQLUtils.cleanup(rs);
                SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
                SQLUtils.cleanup((Connection)con);
                throw throwable;
            }
        }
        SQLUtils.cleanup((ResultSet)rs);
        SQLUtils.cleanup((Statement)batchStatement, (Connection)con);
        SQLUtils.cleanup((Connection)con);
        return typeRelation;
    }

    protected Map<String, String> getCouOrgUnit(Context ctx, String[] toUnitID, String typeRelation) throws BOSException, EASBizException {
        IRowSet rs = null;
        StringBuffer sql = new StringBuffer();
        HashMap<String, String> map = new HashMap<String, String>();
        sql.append("select orgRe.FFromUnitID ,orgRe.FTOUnitID from T_ORG_UnitRelation orgRe where orgRe.FToUnitID in (");
        for (int i = 0; i < toUnitID.length; ++i) {
            sql.append("'");
            sql.append(toUnitID[i]);
            if (i != toUnitID.length - 1) {
                sql.append("' , ");
                continue;
            }
            sql.append("' )");
        }
        sql.append("  and orgRe.ftyperelationid='");
        sql.append(typeRelation);
        sql.append("'  ");
        try {
            rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
            while (rs.next()) {
                map.put(rs.getString(1), rs.getString(2));
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        finally {
            sql = null;
            SQLUtils.cleanup((ResultSet)rs);
        }
        return map;
    }

    @Override
    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurOrderInfo orderInfo = (PurOrderInfo)model;
        PurOrderEntryCollection iObjectCollection = orderInfo.getEntries();
        if (iObjectCollection != null && iObjectCollection.size() > 0) {
            PurOrderEntryInfo entryInfo = (PurOrderEntryInfo)iObjectCollection.getObject(0);
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = entryInfo.getCompanyOrgUnit();
            return aCompanyOrgUnitInfo;
        }
        return null;
    }

    public PurPriceParam getParam4FetchStrategy(PurOrderInfo info, PurOrderEntryInfo entry) {
        PurPriceParam param = new PurPriceParam();
        param.setMaterialPurchaseType(0);
        param.setBillTypeId("510b6503-0105-1000-e000-010bc0a812fd463ED552");
        param.setSeq(entry.getSeq());
        PurchaseOrgUnitInfo purchaseOrgUnit = info.getPurchaseOrgUnit();
        CurrencyInfo currency = info.getCurrency();
        param.setPurOrgUnitId(purchaseOrgUnit != null ? purchaseOrgUnit.getId().toString() : null);
        param.setCurrencyId(currency != null ? currency.getId().toString() : null);
        MaterialInfo material = entry.getMaterial();
        param.setMaterialId(material != null ? material.getId().toString() : null);
        MeasureUnitInfo unit = entry.getUnit();
        param.setUnitId(unit != null ? unit.getId().toString() : null);
        BigDecimal actualPrice = entry.getActualPrice();
        param.setActualPrice(actualPrice);
        BigDecimal actualTaxPrice = entry.getActualTaxPrice();
        param.setActualTaxPrice(actualTaxPrice);
        param.setBizTypeId(info.getBizType().getId().toString());
        return param;
    }

    private boolean isBizVMI(String bizTypeId) {
        boolean isVMI = false;
        if (bizTypeId != null) {
            isVMI = "LAdiD6Y5Sim6q6bmixITqSQHQ1w=".equals(bizTypeId);
        }
        return isVMI;
    }
}

