/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectCollection;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.BillBaseStatusEnum;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.PurOrderCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import java.util.HashMap;
import java.util.HashSet;

public class PurOrderDataPre4AuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 1L;

    public PurOrderDataPre4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurOrderDataPre4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurOrderDataPre4AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        this.dataPrepare(batchResults);
    }

    private void dataPrepare(BatchActionResults batchResults) throws BOSException, EASBizException {
        IObjectCollection col = batchResults.getObjCollection();
        PurOrderInfo info = null;
        HashSet<String> idsSet = new HashSet<String>();
        int size = col.size();
        for (int i = 0; i < size; ++i) {
            info = (PurOrderInfo)col.getObject(i);
            if (info == null) continue;
            idsSet.add(info.getId().toString());
        }
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance((Context)this.ctx);
        PurOrderInfo purOrder = null;
        PurOrderCollection coll = null;
        HashMap<String, BillBaseStatusEnum> statusAlterMap = new HashMap<String, BillBaseStatusEnum>();
        if (idsSet != null && idsSet.size() > 0) {
            EntityViewInfo view = new EntityViewInfo();
            FilterInfo filter = new FilterInfo();
            filter.getFilterItems().add(new FilterItemInfo("id", idsSet, CompareType.INCLUDE));
            view.setFilter(filter);
            SelectorItemCollection selectColl = new SelectorItemCollection();
            selectColl.add(new SelectorItemInfo("id"));
            selectColl.add(new SelectorItemInfo("baseStatus"));
            view.setSelector(selectColl);
            coll = iPurOrder.getPurOrderCollection(view);
            if (coll != null && coll.size() > 0) {
                int count = coll.size();
                for (int i = 0; i < count; ++i) {
                    purOrder = coll.get(i);
                    if (purOrder == null || purOrder.getBaseStatus() != BillBaseStatusEnum.ALTERING) continue;
                    statusAlterMap.put(purOrder.getId().toString(), BillBaseStatusEnum.ALTERING);
                }
            }
            this.ctx.put((Object)"statusAlterMap", statusAlterMap);
        }
    }
}

