/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.db.TempTablePool;
import com.kingdee.bos.metadata.data.SortType;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.entity.SorterItemCollection;
import com.kingdee.bos.metadata.entity.SorterItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.base.param.IParamControl;
import com.kingdee.eas.base.param.ParamControlFactory;
import com.kingdee.eas.base.param.util.ParamManager;
import com.kingdee.eas.basedata.assistant.CurrencyInfo;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.assistant.PeriodInfo;
import com.kingdee.eas.basedata.master.cssp.CustomerCollection;
import com.kingdee.eas.basedata.master.cssp.CustomerFactory;
import com.kingdee.eas.basedata.master.cssp.CustomerInfo;
import com.kingdee.eas.basedata.master.cssp.UsedStatusEnum;
import com.kingdee.eas.basedata.master.material.AsstAttrValueInfo;
import com.kingdee.eas.basedata.master.material.MaterialInfo;
import com.kingdee.eas.basedata.master.material.MaterialSalesFactory;
import com.kingdee.eas.basedata.master.material.MaterialSalesInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitCollection;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.SaleOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.UseStatusEnum;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceParam;
import com.kingdee.eas.basedata.scm.sd.sale.IPriceProvider;
import com.kingdee.eas.basedata.scm.sd.sale.PriceCondition;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamFactory;
import com.kingdee.eas.basedata.scm.sd.sale.PriceParamInfo;
import com.kingdee.eas.basedata.scm.sd.sale.PriceProviderFactory;
import com.kingdee.eas.basedata.scm.sd.sale.SalePriceTO;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.SystemEnum;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.scm.common.app.SCMGroupServerUtils;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.common.loadmass.app.DataLoaderHelper;
import com.kingdee.eas.scm.im.inv.InnerCostRuleEnum;
import com.kingdee.eas.scm.im.inv.InventoryBalanceCollection;
import com.kingdee.eas.scm.im.inv.InventoryBalanceFactory;
import com.kingdee.eas.scm.im.inv.InventoryBalanceInfo;
import com.kingdee.eas.scm.im.inv.TransferRule2Collection;
import com.kingdee.eas.scm.im.inv.TransferRule2Factory;
import com.kingdee.eas.scm.im.inv.TransferRule2Info;
import com.kingdee.eas.scm.sm.pur.IPurOrder;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.util.constant.SCMConstant;
import com.kingdee.eas.util.app.DbUtil;
import com.kingdee.jdbc.rowset.IRowSet;
import com.kingdee.util.LocaleUtils;
import com.kingdee.util.StringUtils;
import com.kingdee.util.UuidException;
import com.kingdee.util.db.SQLUtils;
import java.math.BigDecimal;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class PurOrderDealInnerPrice4AuditProcessor
extends AbstractBusinessProcessor {
    private static final long serialVersionUID = 1L;
    private static final String LINE = "\n";
    private int discountScale = -1;
    private String loc = "";
    private static final String SPLITSIGN = "&&";

    public PurOrderDealInnerPrice4AuditProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public PurOrderDealInnerPrice4AuditProcessor(ExecuteContext executeContext) {
        super(executeContext);
    }

    public PurOrderDealInnerPrice4AuditProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        this.dealInnerPrice(batchResults);
    }

    private void dealInnerPrice(BatchActionResults batchResults) throws BOSException, EASBizException {
        IPurOrder iPurOrder = PurOrderFactory.getLocalInstance((Context)this.ctx);
        IObjectPK[] pks = batchResults.getToDoPkArray();
        PurOrderInfo orderInfo = null;
        if (pks == null || pks.length <= 0) {
            return;
        }
        orderInfo = iPurOrder.getPurOrderInfo(pks[0]);
        if (!iPurOrder.isInnerDealPrice()) {
            if (orderInfo.isIsReCalInnerPrice()) {
                this.clearInnerDealPrice(this.ctx, pks);
                this.caculateInnerDealPrice(this.ctx, pks);
            }
        } else {
            iPurOrder.getCaculateInnerDealPrice(pks);
        }
    }

    private boolean hasSettlementRelationData(Context ctx) throws BOSException {
        boolean hasData = false;
        StringBuilder sql = new StringBuilder();
        sql.append("select fid from T_SCM_SettlementRelation where FBaseStatus = 2");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() > 0) {
            hasData = true;
        }
        return hasData;
    }

    private String createTempTable(Context ctx) throws Exception {
        StringBuilder sql = new StringBuilder();
        sql.append("create table purInnerPriceTable ( ").append(LINE);
        sql.append("FPurOrderEntryID varchar(44),").append(LINE);
        sql.append("FPurOrderID varchar(44),").append(LINE);
        sql.append("FRowTypeID varchar(44),").append(LINE);
        sql.append("FMaterialID varchar(44),").append(LINE);
        sql.append("FMaterialName NVarchar(255),").append(LINE);
        sql.append("FUnitID varchar(44),").append(LINE);
        sql.append("FBaseUnitID varchar(44),").append(LINE);
        sql.append("FAssisPropertyID varchar(44),").append(LINE);
        sql.append("FPrice numeric(21,8) default 0,").append(LINE);
        sql.append("FTaxPrice numeric(21,8) default 0,").append(LINE);
        sql.append("FTaxRate numeric(28,10) default 0,").append(LINE);
        sql.append("FQty numeric(21,8) default 0,").append(LINE);
        sql.append("FDiscountMode int default 0,").append(LINE);
        sql.append("FDiscount numeric(28,10) default 0,").append(LINE);
        sql.append("FSettlementRelationID varchar(44),").append(LINE);
        sql.append("FRelationEntryID varchar(44),").append(LINE);
        sql.append("FSettlementRuleID varchar(44),").append(LINE);
        sql.append("FRuleEntryID varchar(44),").append(LINE);
        sql.append("FCurrencyID varchar(44),").append(LINE);
        sql.append("FExchangeRate numeric(28,16) default 0,").append(LINE);
        sql.append("FFlag int default 0").append(LINE);
        sql.append(")");
        String tempTable = TempTablePool.getInstance((Context)ctx).createTempTable(sql.toString());
        return tempTable;
    }

    private void insertDataIntoTempTable(Context ctx, String tempTable, IObjectPK[] pks) throws BOSException, SQLException {
        if (pks == null || pks.length == 0) {
            return;
        }
        this.insertRelationDataToTable(ctx, tempTable, pks);
        this.insertRelationEntryDataToTable(ctx, tempTable);
        this.insertRuleEntryDataToTable(ctx, tempTable);
    }

    private void insertRelationDataToTable(Context ctx, String tempTable, IObjectPK[] pks) throws BOSException {
        if (pks == null || pks.length == 0) {
            return;
        }
        String params = SCMBizProcessorUtil.convertToString((Object[])pks);
        StringBuilder sql = new StringBuilder();
        sql.append("insert into ").append(tempTable).append(" (FPurOrderEntryID,FPurOrderID,FRowTypeID,FMaterialID,").append(LINE);
        sql.append("FMaterialName,FUnitID,FBaseUnitID,FAssisPropertyID,FPrice,FTaxPrice,FTaxRate,FQty,FDiscountMode,").append(LINE);
        sql.append("FDiscount,FSettlementRelationID,FCurrencyID,FExchangeRate) ").append(LINE);
        sql.append(" select poe.fid,po.FID,poe.FRowTypeID,poe.FMaterialID,").append(LINE);
        sql.append("case when poe.FMaterialID is null then poe.FMaterialName else m.FName_").append(this.loc).append(" end,");
        sql.append("poe.FUnitID,poe.FBaseUnitID,poe.FAssistPropertyID,poe.FActualPrice,poe.FActualTaxPrice,poe.FTaxRate,").append(LINE);
        sql.append("poe.FQty,0,poe.FDiscountRate,sr.FID,po.FCurrencyID,po.FExchangeRate ").append(LINE);
        sql.append(" FROM T_SM_PurOrderEntry poe").append(LINE);
        sql.append(" inner join T_SM_PurOrder po on poe.fparentid = po.fid").append(LINE);
        sql.append(" left join T_BD_Material m on m.FID = poe.FMaterialID").append(LINE);
        sql.append(" inner join T_SCM_SettlementRelation sr on (sr.FBizTypeID = po.FBizTypeID").append(LINE);
        sql.append(" and sr.FBizRelationType = 1 ").append(LINE);
        sql.append(" and sr.FSupCompanyOrgID = po.FCompanyOrgUnitID").append(LINE);
        sql.append(" and sr.FReqCompanyOrgID = poe.FCompanyOrgUnitID ").append(LINE);
        sql.append(" and (sr.FRowTypeID = poe.FRowTypeID or sr.FRowTypeID is null))").append(LINE);
        sql.append(" where sr.FBaseStatus = 2 and po.FIsCentralBalance = 1 and poe.FIsBetweenCompanyRec = 1 ").append(LINE);
        sql.append(" and poe.FIsPresent = 0 and po.FID in (").append(params).append(")").append(LINE);
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void insertRelationEntryDataToTable(Context ctx, String tempTable) throws BOSException, SQLException {
        StringBuilder sql1 = new StringBuilder();
        sql1.append("insert into ").append(tempTable).append(" (FPurOrderEntryID,FPurOrderID,FRowTypeID,FMaterialID,").append(LINE);
        sql1.append("FMaterialName,FUnitID,FBaseUnitID,FAssisPropertyID,FPrice,FTaxPrice,FTaxRate,FQty,FDiscountMode,").append(LINE);
        sql1.append("FDiscount,FSettlementRelationID,FRelationEntryID,FSettlementRuleID,FCurrencyID,FExchangeRate,FFlag) ").append(LINE);
        StringBuilder selectSql = new StringBuilder();
        selectSql.append(" select temp.FPurOrderEntryID,temp.FPurOrderID,temp.FRowTypeID,temp.FMaterialID,").append(LINE);
        selectSql.append("temp.FMaterialName,temp.FUnitID,temp.FBaseUnitID,temp.FAssisPropertyID,").append(LINE);
        selectSql.append("temp.FPrice,temp.FTaxPrice,temp.FTaxRate,temp.FQty,temp.FDiscountMode,temp.FDiscount,").append(LINE);
        selectSql.append("temp.FSettlementRelationID,sre.FID,sre.FSettlementRuleID,temp.FCurrencyID,temp.FExchangeRate,1 ").append(LINE);
        selectSql.append(" from ").append(tempTable).append(" temp").append(LINE);
        this.dealRelationEntryByMGroup(ctx, tempTable);
        StringBuilder sql = new StringBuilder();
        sql.append(sql1.toString());
        sql.append(selectSql.toString());
        sql.append(" inner join T_SCM_SettlementRelation sr on sr.FID = temp.FSettlementRelationID").append(LINE);
        sql.append(" inner join T_SCM_SettlementRelationEntry sre on sr.FID = sre.FParentID").append(LINE);
        sql.append(" where FFlag = 1 ");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(sql1.toString());
        sql.append(selectSql.toString());
        sql.append(" inner join T_SCM_SettlementRelation sr on sr.FID = temp.FSettlementRelationID").append(LINE);
        sql.append(" inner join T_SCM_SettlementRelationEntry sre on sr.FID = sre.FParentID").append(LINE);
        sql.append(" where sr.FMaterialGroupID is null and temp.FRelationEntryID is null and FFlag = 0");
        sql.append(" and temp.FPurOrderEntryID not in (select t.FPurOrderEntryID from ").append(tempTable);
        sql.append(" t where t.FRelationEntryID is not null)");
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("delete from ").append(tempTable).append(" where FRelationEntryID is null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void dealRelationEntryByMGroup(Context ctx, String tempTable) throws BOSException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select temp.FPurOrderEntryID,temp.FSettlementRelationID,mg1.fnumber mnum,").append(LINE);
        sql.append("mg1.FLongNumber longNumber,mg.fnumber number1,mg.FLongNumber longNumber1").append(LINE);
        sql.append(" from ").append(tempTable).append(" temp ").append(LINE);
        sql.append(" inner join T_SCM_SettlementRelation sr on sr.FID = temp.FSettlementRelationID").append(LINE);
        sql.append(" inner join T_BD_MATERIALGROUP mg on mg.FID = sr.FMaterialGroupID").append(LINE);
        sql.append(" inner join T_BD_MaterialGroupDetial mgd on mgd.FMaterialID = temp.FMaterialID ");
        sql.append(" and mgd.FMaterialGroupStandardID = sr.FMaterialGroupStandardID ").append(LINE);
        sql.append(" inner join T_BD_MATERIALGROUP mg1 on mg1.fid = mgd.FMATERIALGROUPID ");
        sql.append(" where mg.flongnumber=mg1.FLONGNUMBER or charindex(mg.flongnumber || '!',mg1.FLONGNUMBER)>0");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() > 0) {
            String key = "";
            HashSet<String> set = new HashSet<String>();
            String longNumber = "";
            String ruleNum = "";
            block0: while (rs.next()) {
                key = rs.getString("FPurOrderEntryID") + rs.getString("FSettlementRelationID");
                longNumber = rs.getString("longNumber");
                ruleNum = rs.getString("number1");
                String[] longNumbers = longNumber.split("!");
                for (int i = longNumbers.length - 1; i >= 0; --i) {
                    if (!longNumbers[i].equals(ruleNum) || set.contains(key)) continue;
                    set.add(key);
                    continue block0;
                }
            }
            if (set.size() == 0) {
                return;
            }
            sql.setLength(0);
            sql.append("update ").append(tempTable).append(" set FFlag = 1 where FPurOrderEntryID || FSettlementRelationID in ");
            sql.append(SCMServerUtils.getInStringFromSet(set)).append(LINE);
            DbUtil.execute((Context)ctx, (String)sql.toString());
        }
    }

    private void insertRuleEntryDataToTable(Context ctx, String tempTable) throws BOSException, SQLException {
        StringBuilder insertSql = new StringBuilder();
        insertSql.append("insert into ").append(tempTable).append(" (FPurOrderEntryID,FPurOrderID,FRowTypeID,FMaterialID,").append(LINE);
        insertSql.append("FMaterialName,FUnitID,FBaseUnitID,FAssisPropertyID,FPrice,FTaxPrice,FTaxRate,FQty,FDiscountMode,").append(LINE);
        insertSql.append("FDiscount,FSettlementRelationID,FRelationEntryID,FSettlementRuleID,FRuleEntryID,FCurrencyID,");
        insertSql.append("FExchangeRate)").append(LINE);
        StringBuilder selectSql = new StringBuilder();
        selectSql.append(" select temp.FPurOrderEntryID,temp.FPurOrderID,temp.FRowTypeID,temp.FMaterialID,").append(LINE);
        selectSql.append("temp.FMaterialName,temp.FUnitID,temp.FBaseUnitID,temp.FAssisPropertyID,").append(LINE);
        selectSql.append("temp.FPrice,temp.FTaxPrice,temp.FTaxRate,temp.FQty,temp.FDiscountMode,temp.FDiscount,").append(LINE);
        selectSql.append("temp.FSettlementRelationID,temp.FRelationEntryID,temp.FSettlementRuleID,ruleEntry.FID,").append(LINE);
        selectSql.append("temp.FCurrencyID,temp.FExchangeRate from ").append(tempTable).append(" temp").append(LINE);
        selectSql.append(" inner join T_SCM_SettlementRule sr on sr.FID = temp.FSettlementRuleID and sr.FBaseStatus = 2").append(LINE);
        selectSql.append(" inner join T_SCM_SettlementRuleEntry ruleEntry on sr.FID = ruleEntry.FParentID").append(LINE);
        StringBuilder partSql = new StringBuilder();
        partSql.append(" and temp.FPurOrderEntryID || temp.FRelationEntryID || temp.FSettlementRuleID not in (");
        partSql.append(" select t.FPurOrderEntryID || t.FRelationEntryID || t.FSettlementRuleID from ").append(tempTable).append(LINE);
        partSql.append(" t where t.FRuleEntryID is not null)").append(LINE);
        StringBuilder sql = new StringBuilder();
        sql.append(insertSql.toString()).append(selectSql.toString());
        sql.append(" and ruleEntry.FRowTypeID = temp.FRowTypeID  and ruleEntry.FMATERIALID  = temp.FMaterialid").append(LINE);
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(insertSql.toString()).append(selectSql.toString());
        sql.append(" and ruleEntry.FRowTypeID is null and ruleEntry.FMATERIALID  = temp.FMaterialid").append(LINE);
        sql.append(partSql.toString());
        DbUtil.execute((Context)ctx, (String)sql.toString());
        this.dealRuleEntryByMGroup(ctx, tempTable, insertSql.toString(), partSql.toString());
        sql.setLength(0);
        sql.append(insertSql.toString()).append(selectSql.toString());
        sql.append("and ruleEntry.FRowTypeID = temp.FRowTypeID and ruleEntry.FMATERIALID is null and ruleEntry.FMATERIALGROUPID  is null").append(LINE);
        sql.append(partSql.toString());
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append(insertSql.toString()).append(selectSql.toString());
        sql.append("and ruleEntry.FRowTypeID is null and ruleEntry.FMATERIALID is null and ruleEntry.FMATERIALGROUPID  is null").append(LINE);
        sql.append(partSql.toString());
        DbUtil.execute((Context)ctx, (String)sql.toString());
        sql.setLength(0);
        sql.append("delete from ").append(tempTable).append(" where FRuleEntryID is null");
        DbUtil.execute((Context)ctx, (String)sql.toString());
    }

    private void dealRuleEntryByMGroup(Context ctx, String tempTable, String insertSql, String partSql) throws BOSException, SQLException {
        Map<String, String> map = this.getRuleEntryMapByMGroup(ctx, tempTable, partSql);
        this.insertDataToRuleEntryByMap(ctx, tempTable, map);
    }

    private Map<String, String> getRuleEntryMapByMGroup(Context ctx, String tempTable, String partSql) throws BOSException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append(" select distinct temp.FPurOrderEntryID,temp.FRelationEntryID,temp.FSettlementRuleID,").append(LINE);
        sql.append("ruleEntry.FID ruleEntryID,ruleEntry.FRowTypeID,mg1.fnumber mnum,mg1.FLongNumber longNumber,").append(LINE);
        sql.append("mg.fnumber number1,mg.FLongNumber longNumber1").append(LINE);
        sql.append(" from ").append(tempTable).append(" temp").append(LINE);
        sql.append(" inner join T_SCM_SettlementRule sr on sr.FID = temp.FSettlementRuleID and sr.FBaseStatus = 2").append(LINE);
        sql.append(" inner join T_SCM_SettlementRuleEntry ruleEntry on sr.FID = ruleEntry.FParentID").append(LINE);
        sql.append(" and (ruleEntry.FRowTypeID = temp.FRowTypeID or ruleEntry.FRowTypeID is null)").append(LINE);
        sql.append(" inner join T_BD_MATERIALGROUP mg on mg.fid = ruleEntry.FMATERIALGROUPID").append(LINE);
        sql.append(" inner join T_BD_MaterialGroupDetial mgd on mgd.FMaterialID = temp.FMaterialID ").append(LINE);
        sql.append(" inner join T_BD_MATERIALGROUP mg1 on mg1.fid = mgd.FMATERIALGROUPID ").append(LINE);
        sql.append(" where (mg.flongnumber=mg1.FLONGNUMBER or charindex(mg.flongnumber || '!',mg1.FLONGNUMBER)>0) ").append(LINE);
        sql.append(partSql);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() > 0) {
            String key = "";
            String value = "";
            HashMap<String, String> map = new HashMap<String, String>();
            String longNumber = "";
            String ruleNum = "";
            block0: while (rs.next()) {
                key = rs.getString("FPurOrderEntryID") + rs.getString("FRelationEntryID") + rs.getString("FSettlementRuleID");
                value = rs.getString("ruleEntryID");
                longNumber = rs.getString("longNumber");
                ruleNum = rs.getString("number1");
                String[] longNumbers = longNumber.split("!");
                for (int i = longNumbers.length - 1; i >= 0; --i) {
                    if (!longNumbers[i].equals(ruleNum) || map.containsKey(key)) continue;
                    map.put(key, value);
                    continue block0;
                }
            }
            return map;
        }
        return null;
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertDataToRuleEntryByMap(Context ctx, String tempTable, Map<String, String> map) throws BOSException {
        if (map == null) return;
        if (map.size() == 0) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("update ").append(tempTable).append(" set FRuleEntryID = ? where ").append(LINE);
        sql.append("(FPurOrderEntryID || FRelationEntryID || FSettlementRuleID) = ? ").append(LINE);
        sql.append("and FRuleEntryID is null ").append(LINE);
        sql.append(" and FPurOrderEntryID ||FRelationEntryID || FSettlementRuleID not in (");
        sql.append(" select t.FPurOrderEntryID || t.FRelationEntryID || t.FSettlementRuleID from ").append(tempTable).append(LINE);
        sql.append(" t where t.FRuleEntryID is not null)").append(LINE);
        Connection conn = null;
        PreparedStatement ps = null;
        try {
            conn = SCMBizProcessorUtil.getConnection((Context)ctx);
            ps = conn.prepareStatement(sql.toString());
            for (Map.Entry<String, String> entry : map.entrySet()) {
                ps.setString(1, entry.getValue());
                ps.setString(2, entry.getKey());
                ps.addBatch();
            }
            if (ps != null) {
                ps.executeBatch();
            }
        }
        catch (SQLDataException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(ps, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)ps, (Connection)conn);
    }

    private void caculateInnerDealPrice(Context ctx, IObjectPK[] pks) throws BOSException, EASBizException {
        if (pks == null || pks.length == 0) {
            return;
        }
        this.loc = LocaleUtils.getLocaleString((Locale)ctx.getLocale());
        ArrayList<String> sqlList = new ArrayList<String>();
        if (!this.hasSettlementRelationData(ctx)) {
            this.calcInnerPriceWithoutRelation(ctx, pks, sqlList, null);
        } else {
            String tempTable = "";
            try {
                tempTable = this.createTempTable(ctx);
                this.insertDataIntoTempTable(ctx, tempTable, pks);
                Set<String> entryIds = this.getHasRelationEntryIds(ctx, tempTable);
                if (entryIds == null || entryIds.size() == 0) {
                    this.calcInnerPriceWithoutRelation(ctx, pks, sqlList, null);
                } else {
                    this.getPriceAndInsertToTable(ctx, tempTable, sqlList);
                    this.calcInnerPriceWithoutRelation(ctx, pks, sqlList, entryIds);
                }
            }
            catch (Exception e) {
                throw new BOSException((Throwable)e);
            }
            finally {
                TempTablePool.getInstance((Context)ctx).releaseTable(tempTable);
            }
        }
        this.batchExecuteSql(ctx, sqlList);
    }

    private void clearInnerDealPrice(Context ctx, IObjectPK[] pks) throws BOSException {
        StringBuffer str = new StringBuffer();
        try {
            String params = SCMBizProcessorUtil.convertToString((Object[])pks);
            str.append(" delete ").append(" T_SM_PurInnerDealPrice ").append(" where FPurOrderId in (").append(params).append(")");
            DbUtil.execute((Context)ctx, (String)str.toString());
        }
        catch (BOSException er) {
            throw new BOSException("sql Execute Error :", (Throwable)er);
        }
    }

    private void getPriceAndInsertToTable(Context ctx, String tempTable, List<String> sqlList) throws BOSException, EASBizException {
        IRowSet rs = this.getDataFromTempTable(ctx, tempTable);
        if (rs == null || rs.size() == 0) {
            return;
        }
        try {
            List<ResultTo> resultList = this.putSettlementResultToList(rs);
            if (resultList == null || resultList.size() == 0) {
                return;
            }
            this.setValueToResultList(ctx, resultList);
            Map<String, List<Object>> exchangeRateMap = this.cacheExchangeRate(ctx, resultList);
            this.dealWithSalePrice(ctx, sqlList, resultList, exchangeRateMap);
            this.dealWithCostPrice(ctx, sqlList, resultList, exchangeRateMap);
            this.dealWithOrderPrice(ctx, sqlList, resultList, exchangeRateMap);
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
    }

    private Map<String, List<Object>> cacheExchangeRate(Context ctx, List<ResultTo> resultList) throws BOSException, SQLException {
        if (resultList == null || resultList.size() == 0) {
            return null;
        }
        ResultTo to = null;
        HashSet<String> companyIdSet = new HashSet<String>();
        HashSet<String> currencySet = new HashSet<String>();
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            to = resultList.get(i);
            if (to == null || StringUtils.isEmpty((String)to.currencyid) || StringUtils.isEmpty((String)to.ruleCurrencyID) || StringUtils.isEmpty((String)to.companyOrgUnitID) || to.currencyid.equals(to.ruleCurrencyID)) continue;
            companyIdSet.add(to.companyOrgUnitID);
            currencySet.add(to.currencyid);
            currencySet.add(to.ruleCurrencyID);
        }
        if (companyIdSet.size() == 0 || currencySet.size() == 0) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select c.FID FCompanyOrgID,aux.FSourceCurrencyID,aux.FTargetCurrencyID,exRate.FConvertRate,").append(LINE);
        sql.append("aux.FConvertMode,aux.FPrecision from T_BD_ExchangeRate exRate").append(LINE);
        sql.append(" inner join T_BD_ExchangeAux aux on exRate.FExchangeAuxID = aux.FID").append(LINE);
        sql.append(" inner join T_BD_ExchangeTable exTable on exTable.FID = aux.FExchangeTableId").append(LINE);
        sql.append(" inner join T_ORG_Company c on c.FBaseExgTableID = exTable.FID").append(LINE);
        sql.append(" where c.FID in ").append(SCMServerUtils.getInStringFromSet(companyIdSet)).append(LINE);
        sql.append(" and aux.FSourceCurrencyID in ").append(SCMServerUtils.getInStringFromSet(currencySet));
        sql.append(" and aux.FTargetCurrencyID in ").append(SCMServerUtils.getInStringFromSet(currencySet)).append(LINE);
        sql.append(" order by exRate.FAvailTime desc ");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs == null || rs.size() == 0) {
            return null;
        }
        HashMap<String, List<Object>> exchangeRateMap = new HashMap<String, List<Object>>();
        String key = "";
        ArrayList<Number> list = null;
        while (rs.next()) {
            key = rs.getString("FCompanyOrgID") + rs.getString("FSourceCurrencyID") + rs.getString("FTargetCurrencyID");
            if (exchangeRateMap.containsKey(key)) continue;
            list = new ArrayList<Number>();
            list.add(0, rs.getBigDecimal("FConvertRate"));
            list.add(1, rs.getInt("FConvertMode"));
            list.add(2, rs.getInt("FPrecision"));
            exchangeRateMap.put(key, list);
        }
        return exchangeRateMap;
    }

    private void dealWithSalePrice(Context ctx, List<String> sqlList, List<ResultTo> resultList, Map<String, List<Object>> exchangeRateMap) throws BOSException, EASBizException, SQLException {
        if (resultList == null || resultList.size() == 0) {
            return;
        }
        ResultTo to = null;
        HashSet<String> recCompanyIdSet = new HashSet<String>();
        ArrayList<ResultTo> saleList = new ArrayList<ResultTo>();
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            to = resultList.get(i);
            if (to == null || to.materialId == null || to.priceRule != 0 || StringUtils.isEmpty((String)to.recCompanyOrgID)) continue;
            recCompanyIdSet.add(to.recCompanyOrgID);
            saleList.add(to);
        }
        Map<String, CustomerInfo> customerMap = this.getInnerCustomerByCompany(ctx, recCompanyIdSet);
        Map<String, List<PriceCondition>> priceConditionMap = this.getPriceConditionMapByResultList(ctx, saleList, customerMap);
        Map<String, List> priceResultMap = this.getPrice(ctx, priceConditionMap);
        this.insertSalePriceToTable(ctx, sqlList, saleList, priceResultMap, exchangeRateMap);
    }

    private void insertSalePriceToTable(Context ctx, List<String> sqlList, List<ResultTo> resultToList, Map<String, List> priceResultMap, Map<String, List<Object>> exchangeRateMap) throws EASBizException, BOSException, SQLException {
        List tempList = null;
        if (resultToList == null || resultToList.size() == 0) {
            return;
        }
        int precision = 0;
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal dPriceValue = BigDecimal.ZERO;
        BigDecimal discountValue = BigDecimal.ZERO;
        BigDecimal taxRate = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        PriceParamInfo priceparamInfo = null;
        IPriceParam iPriceParam = PriceParamFactory.getLocalInstance((Context)ctx);
        SalePriceTO salePriceTo = null;
        Map materialLNMaps = this.getMaterialLongNumMaps(ctx, resultToList);
        for (ResultTo to : resultToList) {
            if (priceResultMap != null && priceResultMap.containsKey(to.companyOrgUnitID + SPLITSIGN + to.customerId)) {
                tempList = priceResultMap.get(to.companyOrgUnitID + SPLITSIGN + to.customerId);
                salePriceTo = this.matchSalePriceTo(materialLNMaps, tempList, to, true);
            }
            precision = to.pricePrecision;
            StringBuilder sql = new StringBuilder();
            sql.append(this.getInsertSql());
            sql.append(" values(newbosid('").append("2C90FD08'),'");
            sql.append(to.id + "','" + to.entryId + "'");
            if (salePriceTo != null) {
                List<Object> list;
                String discountMode;
                priceparamInfo = iPriceParam.getParameter(to.saleOrgID);
                if (salePriceTo.price != null) {
                    dPriceValue = salePriceTo.price;
                }
                if (salePriceTo.discountValue != null) {
                    if (this.discountScale == -1) {
                        String rateScale = ParamManager.getParamByNumber((Context)ctx, (String)"DISCOUNTRATEPRECISION").getDefaultValue();
                        this.discountScale = Integer.parseInt(rateScale);
                    }
                    discountValue = salePriceTo.discountValue;
                }
                String string = discountMode = salePriceTo.discountMode != null ? salePriceTo.discountMode.toString() : "";
                if (discountValue.unscaledValue().intValue() == 0) {
                    discountValue = BigDecimal.ZERO;
                }
                taxRate = to.taxRate.unscaledValue().intValue() == 0 ? BigDecimal.ZERO : to.taxRate;
                if (discountMode.equals("1")) {
                    discountValue = discountValue.divide(dPriceValue, this.discountScale, 4).multiply(SCMConstant.BIGDECIMAL_ONEHUNDRED).setScale(this.discountScale, 4);
                }
                BigDecimal transferTaxRate = taxRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4).add(SCMConstant.BIGDECIMAL_ONE);
                if (priceparamInfo != null && priceparamInfo.isContainTax()) {
                    taxPrice = dPriceValue;
                    if (to.addRate != null && to.addRate.compareTo(BigDecimal.ZERO) != 0) {
                        taxPrice = taxPrice.multiply(BigDecimal.ONE.add(to.addRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4))).setScale(precision, 4);
                    } else if (to.addPrice != null && to.addPrice.compareTo(BigDecimal.ZERO) != 0) {
                        taxPrice = taxPrice.add(to.addPrice).setScale(precision, 4);
                    }
                    price = taxPrice.divide(transferTaxRate, precision, 4);
                } else {
                    price = dPriceValue;
                    if (to.addRate != null && to.addRate.compareTo(BigDecimal.ZERO) != 0) {
                        price = price.multiply(BigDecimal.ONE.add(to.addRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4))).setScale(precision, 4);
                    } else if (to.addPrice != null && to.addPrice.compareTo(BigDecimal.ZERO) != 0) {
                        price = price.add(to.addPrice).setScale(precision, 4);
                    }
                    taxPrice = price.multiply(transferTaxRate).setScale(precision, 4);
                }
                if (to.currencySource == 1) {
                    to.currencyid = to.ruleCurrencyID;
                    to.exchangeRate = BigDecimal.ONE;
                } else if (exchangeRateMap != null && exchangeRateMap.containsKey(to.companyOrgUnitID + to.currencyid + to.ruleCurrencyID) && (list = exchangeRateMap.get(to.companyOrgUnitID + to.currencyid + to.ruleCurrencyID)) != null && list.size() == 3) {
                    to.exchangeRate = (BigDecimal)list.get(0);
                }
                sql.append("," + price + "," + 0 + "," + discountValue).append("," + taxRate + "," + taxPrice);
                sql.append(this.getOtherInsertSql(to));
                sqlList.add(sql.toString());
                continue;
            }
            this.writeOrderPrice(ctx, sqlList, to, exchangeRateMap, true);
        }
    }

    private Map<String, CustomerInfo> getInnerCustomerByCompany(Context ctx, Set<String> set) throws BOSException {
        if (set == null || set.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filterInfo = new FilterInfo();
        filterInfo.getFilterItems().add(new FilterItemInfo("internalCompany.id", set, CompareType.INCLUDE));
        filterInfo.getFilterItems().add(new FilterItemInfo("usedStatus", (Object)String.valueOf(UsedStatusEnum.APPROVED.getValue()), CompareType.EQUALS));
        view.setFilter(filterInfo);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("name"));
        sic.add(new SelectorItemInfo("number"));
        sic.add(new SelectorItemInfo("internalCompany.id"));
        view.setSelector(sic);
        CustomerCollection innerCustomerColl = CustomerFactory.getLocalInstance((Context)ctx).getCustomerCollection(view);
        if (innerCustomerColl == null || innerCustomerColl.size() == 0) {
            return null;
        }
        HashMap<String, CustomerInfo> customerMap = new HashMap<String, CustomerInfo>();
        int size = innerCustomerColl.size();
        for (int i = 0; i < size; ++i) {
            if (innerCustomerColl.get(i) == null || innerCustomerColl.get(i).getInternalCompany() == null) continue;
            customerMap.put(innerCustomerColl.get(i).getInternalCompany().getId().toString(), innerCustomerColl.get(i));
        }
        return customerMap;
    }

    private Map<String, String> getStorageOrgsByCompany(Context ctx, Set<String> set) throws BOSException {
        OrgUnitRelationCollection couOrgColl = this.getOrgUnitRelationColl(ctx, set, 4, 1, "toUnit.id", "fromUnit.number");
        if (couOrgColl == null || couOrgColl.size() == 0) {
            return null;
        }
        HashMap<String, String> storageOrgMap = new HashMap<String, String>();
        int size = couOrgColl.size();
        for (int i = 0; i < size; ++i) {
            if (couOrgColl.get(i) == null || couOrgColl.get(i).getFromUnit() == null || couOrgColl.get(i).getToUnit() == null || storageOrgMap.containsKey(couOrgColl.get(i).getToUnit().getId().toString())) continue;
            storageOrgMap.put(couOrgColl.get(i).getToUnit().getId().toString(), couOrgColl.get(i).getFromUnit().getId().toString());
        }
        return storageOrgMap;
    }

    private OrgUnitRelationCollection getOrgUnitRelationColl(Context ctx, Set<String> set, int fromType, int toType, String filterPoperty, String sorterProperty) throws BOSException {
        if (set == null || set.size() == 0 || StringUtils.isEmpty((String)filterPoperty)) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo(filterPoperty, set, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.fromType", (Object)new Integer(fromType), CompareType.EQUALS));
        filter.getFilterItems().add(new FilterItemInfo("typeRelation.toType", (Object)new Integer(toType), CompareType.EQUALS));
        filter.setMaskString("#0 and #1 and #2");
        view.setFilter(filter);
        SorterItemCollection sortColl = new SorterItemCollection();
        SorterItemInfo sortItem = new SorterItemInfo(filterPoperty);
        sortItem.setSortType(SortType.ASCEND);
        sortColl.add(sortItem);
        if (!StringUtils.isEmpty((String)sorterProperty)) {
            SorterItemInfo sortItem1 = new SorterItemInfo(sorterProperty);
            sortItem1.setSortType(SortType.ASCEND);
            sortColl.add(sortItem1);
        }
        view.setSorter(sortColl);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("fromUnit.id"));
        sic.add(new SelectorItemInfo("fromUnit.name"));
        sic.add(new SelectorItemInfo("fromUnit.number"));
        sic.add(new SelectorItemInfo("fromUnit.longNumber"));
        sic.add(new SelectorItemInfo("toUnit.id"));
        sic.add(new SelectorItemInfo("toUnit.name"));
        sic.add(new SelectorItemInfo("toUnit.number"));
        sic.add(new SelectorItemInfo("toUnit.longNumber"));
        sic.add(new SelectorItemInfo("isDefault"));
        view.setSelector(sic);
        OrgUnitRelationCollection orgColl = OrgUnitRelationFactory.getLocalInstance((Context)ctx).getOrgUnitRelationCollection(view);
        return orgColl;
    }

    private Map<String, List<PriceCondition>> getPriceConditionMapByResultList(Context ctx, List<ResultTo> resultList, Map<String, CustomerInfo> customerMap) {
        if (resultList == null || resultList.size() == 0 || customerMap == null || customerMap.size() == 0) {
            return null;
        }
        PriceCondition priceCondition = null;
        List<Object> priceConditions = null;
        ResultTo to = null;
        HashMap<String, List<PriceCondition>> priceConditionMap = new HashMap<String, List<PriceCondition>>();
        Calendar cal = Calendar.getInstance();
        Timestamp ts = new Timestamp(cal.getTimeInMillis());
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            to = resultList.get(i);
            if (to == null || StringUtils.isEmpty((String)to.materialId) || to.priceRule != 0 || !customerMap.containsKey(to.recCompanyOrgID) || StringUtils.isEmpty((String)to.saleOrgID)) continue;
            priceCondition = new PriceCondition();
            SaleOrgUnitInfo sou = new SaleOrgUnitInfo();
            sou.setId(BOSUuid.read((String)to.saleOrgID));
            priceCondition.setSaleOrg(sou);
            CustomerInfo customerInfo = customerMap.get(to.recCompanyOrgID);
            priceCondition.setCustomerInfo(customerInfo);
            MaterialInfo materialInfo = new MaterialInfo();
            materialInfo.setId(BOSUuid.read((String)to.materialId));
            MeasureUnitInfo baseUnitInfo = new MeasureUnitInfo();
            baseUnitInfo.setId(BOSUuid.read((String)to.baseUnitId));
            materialInfo.setBaseUnit(baseUnitInfo);
            priceCondition.setMaterialInfo(materialInfo);
            CompanyOrgUnitInfo companyOrgInfo = new CompanyOrgUnitInfo();
            companyOrgInfo.setId(BOSUuid.read((String)to.companyOrgUnitID));
            priceCondition.setCompanyOrg(companyOrgInfo);
            CurrencyInfo currencyInfo = new CurrencyInfo();
            if (to.currencySource == 1) {
                currencyInfo.setId(BOSUuid.read((String)to.ruleCurrencyID));
            } else {
                currencyInfo.setId(BOSUuid.read((String)to.currencyid));
            }
            priceCondition.setCurrencyInfo(currencyInfo);
            priceCondition.setOrderQty(to.qty);
            priceCondition.setMeasureUnit(to.unitId);
            priceCondition.setCurDate((Date)ts);
            priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
            if (!StringUtils.isEmpty((String)to.assistPropertyID)) {
                AsstAttrValueInfo asstValueInfo = new AsstAttrValueInfo();
                asstValueInfo.setId(BOSUuid.read((String)to.assistPropertyID));
                priceCondition.setAssiProperty(asstValueInfo);
            }
            priceConditions = priceConditionMap.containsKey(companyOrgInfo.getId().toString() + SPLITSIGN + customerInfo.getId().toString()) ? (List)priceConditionMap.get(companyOrgInfo.getId().toString() + SPLITSIGN + customerInfo.getId().toString()) : new ArrayList<PriceCondition>();
            priceConditions.add(priceCondition);
            priceConditionMap.put(companyOrgInfo.getId().toString() + SPLITSIGN + customerInfo.getId().toString(), priceConditions);
            to.customerId = customerInfo.getId().toString();
        }
        return priceConditionMap;
    }

    private void dealWithCostPrice(Context ctx, List<String> sqlList, List<ResultTo> resultList, Map<String, List<Object>> exchangeRateMap) throws BOSException, SQLException {
        if (resultList == null || resultList.size() == 0) {
            return;
        }
        ResultTo to = null;
        ArrayList<ResultTo> costList = new ArrayList<ResultTo>();
        ArrayList<ResultTo> balanceList = new ArrayList<ResultTo>();
        HashSet<String> mset = new HashSet<String>();
        HashSet<String> uset = new HashSet<String>();
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            to = resultList.get(i);
            if (to == null || StringUtils.isEmpty((String)to.materialId) || to.priceRule != 1) continue;
            if (to.accountType == 1) {
                costList.add(to);
            } else {
                balanceList.add(to);
            }
            if (to.unitId.equals(to.baseUnitId)) continue;
            mset.add(to.materialId);
            uset.add(to.unitId);
        }
        Map<String, BigDecimal> rateMap = this.cacheConvertRate(ctx, mset, uset);
        this.getRecentCostPrice(ctx, sqlList, costList, rateMap, exchangeRateMap);
        this.getInventoryBalancePrice(ctx, sqlList, balanceList, rateMap, exchangeRateMap);
    }

    private Map<String, BigDecimal> cacheConvertRate(Context ctx, Set<String> mset, Set<String> uset) throws BOSException {
        if (mset == null || mset.size() == 0 || uset == null || uset.size() == 0) {
            return null;
        }
        EntityViewInfo view = new EntityViewInfo();
        FilterInfo filter = new FilterInfo();
        filter.getFilterItems().add(new FilterItemInfo("material.id", mset, CompareType.INCLUDE));
        filter.getFilterItems().add(new FilterItemInfo("measureUnit.id", uset, CompareType.INCLUDE));
        view.setFilter(filter);
        MultiMeasureUnitCollection coll = MultiMeasureUnitFactory.getLocalInstance((Context)ctx).getMultiMeasureUnitCollection(view);
        if (coll == null || coll.size() == 0) {
            return null;
        }
        HashMap<String, BigDecimal> rateMap = new HashMap<String, BigDecimal>();
        MultiMeasureUnitInfo info = null;
        int size = coll.size();
        for (int i = 0; i < size; ++i) {
            info = coll.get(i);
            if (info.getMaterial() == null || info.getMeasureUnit() == null) continue;
            rateMap.put(info.getMaterial().getId().toString() + info.getMeasureUnit().getId().toString(), info.getBaseConvsRate());
        }
        return rateMap;
    }

    private void getRecentCostPrice(Context ctx, List<String> sqlList, List<ResultTo> costList, Map<String, BigDecimal> rateMap, Map<String, List<Object>> exchangeRateMap) throws BOSException, SQLException {
        if (costList == null || costList.size() == 0) {
            return;
        }
        ResultTo to = null;
        HashSet<String> companySet = new HashSet<String>();
        int size = costList.size();
        for (int i = 0; i < size; ++i) {
            to = costList.get(i);
            companySet.add(to.companyOrgUnitID);
        }
        Map<String, String> paramMap = this.getParamValueByComapny(ctx, companySet);
        Map<String, BigDecimal> costMap = this.cacheRecentCostPrice(ctx, paramMap, costList);
        this.writeRecentCostPrice(ctx, sqlList, costList, paramMap, costMap, rateMap, exchangeRateMap);
    }

    private void getInventoryBalancePrice(Context ctx, List<String> sqlList, List<ResultTo> balanceList, Map<String, BigDecimal> rateMap, Map<String, List<Object>> exchangeRateMap) throws BOSException {
        if (balanceList == null || balanceList.size() == 0) {
            return;
        }
        ResultTo to = null;
        HashSet<String> companySet = new HashSet<String>();
        Set<String> mset = null;
        HashMap<String, Set<String>> map = new HashMap<String, Set<String>>();
        int size = balanceList.size();
        for (int i = 0; i < size; ++i) {
            to = balanceList.get(i);
            companySet.add(to.companyOrgUnitID);
            mset = map.containsKey(to.companyOrgUnitID) ? (Set)map.get(to.companyOrgUnitID) : new HashSet<String>();
            mset.add(to.materialId);
            map.put(to.companyOrgUnitID, mset);
        }
        Map<String, PeriodInfo> periodMap = this.cachePeriodInfoByCompany(ctx, companySet);
        Map<String, BigDecimal> balanceMap = this.cacheBalancePrice(ctx, map, periodMap);
        this.writeBalanceCostPrice(ctx, sqlList, balanceList, balanceMap, rateMap, exchangeRateMap);
    }

    private Map<String, PeriodInfo> cachePeriodInfoByCompany(Context ctx, Set<String> companySet) throws BOSException {
        if (companySet == null || companySet.size() == 0) {
            return null;
        }
        String[] companyIds = new String[companySet.size()];
        Iterator<String> iterator = companySet.iterator();
        int i = 0;
        while (iterator.hasNext()) {
            companyIds[i] = iterator.next().toString();
            ++i;
        }
        Map periodMap = DataLoaderHelper.loadCurrenPeriod((Context)ctx, (SystemEnum)SystemEnum.INVENTORYMANAGEMENT, (String[])companyIds);
        return periodMap;
    }

    private Map<String, BigDecimal> cacheBalancePrice(Context ctx, Map<String, Set<String>> map, Map<String, PeriodInfo> periodMap) throws BOSException {
        if (map == null || map.size() == 0 || periodMap == null || periodMap.size() == 0) {
            return null;
        }
        PeriodInfo periodInfo = null;
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        for (Map.Entry<String, Set<String>> entry : map.entrySet()) {
            if (!periodMap.containsKey(entry.getKey() + SystemEnum.INVENTORYMANAGEMENT) || (periodInfo = periodMap.get(entry.getKey() + SystemEnum.INVENTORYMANAGEMENT)) == null) continue;
            fi.getFilterItems().add(new FilterItemInfo("companyOrgUnit.id", (Object)entry.getKey()));
            fi.getFilterItems().add(new FilterItemInfo("materialID.id", entry.getValue(), CompareType.INCLUDE));
            fi.getFilterItems().add(new FilterItemInfo("period", (Object)periodInfo.getPeriodNumber()));
            fi.getFilterItems().add(new FilterItemInfo("year", (Object)periodInfo.getPeriodYear()));
        }
        if (fi.getFilterItems().size() == 0) {
            return null;
        }
        StringBuffer maskString = new StringBuffer();
        int size = fi.getFilterItems().size();
        for (int i = 0; i < size; i += 4) {
            maskString.append("(#").append(i).append(" and #").append(i + 1).append(" and #").append(i + 2).append(" and #").append(i + 3).append(")");
            if (i + 4 >= size) continue;
            maskString.append(" or ");
        }
        fi.setMaskString(maskString.toString());
        evi.setFilter(fi);
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add(new SelectorItemInfo("id"));
        sic.add(new SelectorItemInfo("companyOrgUnit.id"));
        sic.add(new SelectorItemInfo("materialID.id"));
        sic.add(new SelectorItemInfo("materialID.pricePrecision"));
        sic.add(new SelectorItemInfo("period"));
        sic.add(new SelectorItemInfo("year"));
        sic.add(new SelectorItemInfo("periodBeginQty"));
        sic.add(new SelectorItemInfo("periodBeginBalance"));
        evi.setSelector(sic);
        InventoryBalanceCollection ibc = InventoryBalanceFactory.getLocalInstance((Context)ctx).getInventoryBalanceCollection(evi);
        if (ibc == null || ibc.size() == 0) {
            return null;
        }
        HashMap<String, InventoryBalanceCollection> collMap = new HashMap<String, InventoryBalanceCollection>();
        InventoryBalanceCollection balanceColl = null;
        InventoryBalanceInfo balanceInfo = null;
        String key = "";
        int size2 = ibc.size();
        for (int i = 0; i < size2; ++i) {
            balanceInfo = ibc.get(i);
            if (balanceInfo.getCompanyOrgUnit() == null || balanceInfo.getMaterialID() == null) continue;
            key = balanceInfo.getCompanyOrgUnit().getId().toString() + balanceInfo.getMaterialID().getId().toString();
            balanceColl = collMap.containsKey(key) ? (InventoryBalanceCollection)collMap.get(key) : new InventoryBalanceCollection();
            balanceColl.add(balanceInfo);
            collMap.put(key, balanceColl);
        }
        if (collMap == null || collMap.size() == 0) {
            return null;
        }
        HashMap<String, BigDecimal> balanceMap = new HashMap<String, BigDecimal>();
        BigDecimal totalQty = BigDecimal.ZERO;
        BigDecimal totalAmount = BigDecimal.ZERO;
        for (Map.Entry entry : collMap.entrySet()) {
            balanceColl = (InventoryBalanceCollection)entry.getValue();
            totalQty = BigDecimal.ZERO;
            totalAmount = BigDecimal.ZERO;
            if (balanceColl == null || balanceColl.size() == 0) continue;
            int size3 = balanceColl.size();
            for (int i = 0; i < size3; ++i) {
                balanceInfo = balanceColl.get(i);
                totalQty = totalQty.add(balanceInfo.getPeriodBeginQty());
                totalAmount = totalAmount.add(balanceInfo.getPeriodBeginBalance());
            }
            if (totalQty.compareTo(BigDecimal.ZERO) == 0 || totalAmount.compareTo(BigDecimal.ZERO) == 0) {
                balanceMap.put((String)entry.getKey(), BigDecimal.ZERO);
                continue;
            }
            balanceMap.put((String)entry.getKey(), totalAmount.divide(totalQty, balanceInfo.getMaterialID().getPricePrecision(), 4));
        }
        return balanceMap;
    }

    private void writeBalanceCostPrice(Context ctx, List<String> sqlList, List<ResultTo> balanceList, Map<String, BigDecimal> balanceMap, Map<String, BigDecimal> rateMap, Map<String, List<Object>> exchangeRateMap) {
        if (balanceList == null || balanceList.size() == 0) {
            return;
        }
        String key = "";
        ResultTo to = null;
        BigDecimal balancePrice = BigDecimal.ZERO;
        int size = balanceList.size();
        for (int i = 0; i < size; ++i) {
            to = balanceList.get(i);
            key = to.companyOrgUnitID + to.materialId;
            if (balanceMap != null && balanceMap.containsKey(key)) {
                balancePrice = balanceMap.get(key);
                if (balancePrice.compareTo(BigDecimal.ZERO) == 0) {
                    this.writeOrderPrice(ctx, sqlList, to, exchangeRateMap, true);
                    continue;
                }
                this.insertCostOrBalancePrice(ctx, sqlList, to, balancePrice, rateMap, exchangeRateMap);
                continue;
            }
            this.writeOrderPrice(ctx, sqlList, to, exchangeRateMap, true);
        }
    }

    private void writeRecentCostPrice(Context ctx, List<String> sqlList, List<ResultTo> costList, Map<String, String> paramMap, Map<String, BigDecimal> costMap, Map<String, BigDecimal> rateMap, Map<String, List<Object>> exchangeRateMap) {
        if (costList == null || costList.size() == 0 || paramMap == null || paramMap.size() == 0) {
            return;
        }
        String calType = "";
        String key = "";
        ResultTo to = null;
        BigDecimal costPrice = BigDecimal.ZERO;
        int size = costList.size();
        for (int i = 0; i < size; ++i) {
            to = costList.get(i);
            if (!paramMap.containsKey(to.companyOrgUnitID)) {
                this.writeOrderPrice(ctx, sqlList, to, exchangeRateMap, true);
                continue;
            }
            calType = paramMap.get(to.companyOrgUnitID);
            if (calType.equals("2") && StringUtils.isEmpty((String)to.supWareHouseID)) {
                this.writeOrderPrice(ctx, sqlList, to, exchangeRateMap, true);
                continue;
            }
            if (calType.equals("1") && StringUtils.isEmpty((String)to.supStorageOrgID)) {
                this.writeOrderPrice(ctx, sqlList, to, exchangeRateMap, true);
                continue;
            }
            key = to.materialId + to.companyOrgUnitID;
            if (calType.equals("1")) {
                key = key + to.supStorageOrgID;
            } else if (calType.equals("2")) {
                key = key + to.supStorageOrgID + to.supWareHouseID;
            }
            if (costMap != null && costMap.containsKey(key)) {
                costPrice = costMap.get(key);
                if (costPrice.compareTo(BigDecimal.ZERO) == 0) {
                    this.writeOrderPrice(ctx, sqlList, to, exchangeRateMap, true);
                    continue;
                }
                this.insertCostOrBalancePrice(ctx, sqlList, to, costPrice, rateMap, exchangeRateMap);
                continue;
            }
            this.writeOrderPrice(ctx, sqlList, to, exchangeRateMap, true);
        }
    }

    private void insertCostOrBalancePrice(Context ctx, List<String> sqlList, ResultTo to, BigDecimal basePrice, Map<String, BigDecimal> rateMap, Map<String, List<Object>> exchangeRateMap) {
        if (to == null) {
            return;
        }
        if (!to.unitId.equals(to.baseUnitId) && rateMap != null && rateMap.containsKey(to.materialId + to.unitId)) {
            BigDecimal convertRate = rateMap.get(to.materialId + to.unitId);
            basePrice = basePrice.divide(convertRate, to.pricePrecision, 4);
        }
        to.price = basePrice;
        if (to.currencySource == 2 && !to.currencyid.equals(to.ruleCurrencyID)) {
            List<Object> list;
            if (exchangeRateMap != null && exchangeRateMap.containsKey(to.companyOrgUnitID + to.ruleCurrencyID + to.currencyid) && (list = exchangeRateMap.get(to.companyOrgUnitID + to.ruleCurrencyID + to.currencyid)) != null && list.size() == 3) {
                BigDecimal rateValue = (BigDecimal)list.get(0);
                int convertMode = Integer.parseInt(list.get(1).toString());
                basePrice = convertMode == 0 ? basePrice.divide(rateValue, to.pricePrecision, 4) : basePrice.multiply(rateValue).setScale(to.pricePrecision, 4);
            }
        } else if (to.currencySource == 1) {
            to.currencyid = to.ruleCurrencyID;
            to.exchangeRate = BigDecimal.ONE;
        }
        this.writeOrderPrice(ctx, sqlList, to, exchangeRateMap, false);
    }

    private Map<String, BigDecimal> cacheRecentCostPrice(Context ctx, Map<String, String> paramMap, List<ResultTo> costList) throws BOSException, SQLException {
        String calType = "";
        ResultTo to = null;
        StringBuilder sql = new StringBuilder();
        int size = costList.size();
        for (int i = 0; i < size; ++i) {
            to = costList.get(i);
            if (paramMap == null || paramMap.size() == 0 || !paramMap.containsKey(to.companyOrgUnitID) || (calType = paramMap.get(to.companyOrgUnitID)).equals("2") && StringUtils.isEmpty((String)to.supWareHouseID) || calType.equals("1") && StringUtils.isEmpty((String)to.supStorageOrgID)) continue;
            sql.append("(FMaterialID = '");
            sql.append(to.materialId);
            sql.append("' and FCompanyOrgUnitID = '");
            sql.append(to.companyOrgUnitID);
            if (calType.equals("1")) {
                sql.append("' and FStorageOrgUnitID = '");
                sql.append(to.supStorageOrgID);
            } else if (calType.equals("2")) {
                sql.append("' and FStorageOrgUnitID = '");
                sql.append(to.supStorageOrgID);
                sql.append("' and FWarehouseID = '");
                sql.append(to.supWareHouseID);
            }
            sql.append("') or ");
        }
        if (sql.length() == 0) {
            return null;
        }
        StringBuilder sqlStr = new StringBuilder();
        sqlStr.append("select FMaterialID,FCompanyOrgUnitID,FStorageOrgUnitID,FWarehouseID,FPrice from T_CL_RecentCost where ");
        sqlStr.append(sql.toString().substring(0, sql.length() - 3));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sqlStr.toString());
        HashMap<String, BigDecimal> costMap = new HashMap<String, BigDecimal>();
        String key = "";
        while (rs.next()) {
            if (paramMap == null || paramMap.size() == 0 || !paramMap.containsKey(rs.getString("FCompanyOrgUnitID"))) continue;
            calType = paramMap.get(rs.getString("FCompanyOrgUnitID"));
            key = rs.getString("FMaterialID") + rs.getString("FCompanyOrgUnitID");
            if (calType.equals("1")) {
                key = key + rs.getString("FStorageOrgUnitID");
            } else if (calType.equals("2")) {
                key = key + rs.getString("FStorageOrgUnitID") + rs.getString("FWarehouseID");
            }
            costMap.put(key, rs.getBigDecimal("FPrice"));
        }
        return costMap;
    }

    private Map<String, String> getParamValueByComapny(Context ctx, Set<String> companySet) throws BOSException, SQLException {
        if (companySet == null || companySet.size() == 0) {
            return null;
        }
        HashMap<String, String> paramMap = new HashMap<String, String>();
        StringBuilder sql = new StringBuilder();
        sql.append("select item.FValue_").append(this.loc).append(" FValue,item.FOrgUnitID as FOrgUnitID from T_BAS_ParamItem item ");
        sql.append("inner join T_BAS_Param p on p.FID = item.FKeyID ");
        sql.append("where p.FNumber = '").append("SCM_CAL_002").append("' and item.FOrgUnitID in ");
        sql.append(SCMServerUtils.getInStringFromSet(companySet));
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        while (rs.next()) {
            paramMap.put(rs.getString("FOrgUnitID"), rs.getString("FValue"));
        }
        return paramMap;
    }

    private void dealWithOrderPrice(Context ctx, List<String> sqlList, List<ResultTo> resultList, Map<String, List<Object>> exchangeRateMap) {
        if (resultList == null || resultList.size() == 0) {
            return;
        }
        ResultTo to = null;
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            to = resultList.get(i);
            if (to == null || to.priceRule != 2 && (to.materialId != null || to.priceRule != 0 && to.priceRule != 1)) continue;
            this.writeOrderPrice(ctx, sqlList, to, exchangeRateMap, true);
        }
    }

    private void writeOrderPrice(Context ctx, List<String> sqlList, ResultTo to, Map<String, List<Object>> exchangeRateMap, boolean isConvert) {
        List<Object> list;
        if (to == null) {
            return;
        }
        StringBuilder sql = new StringBuilder();
        sql.append(this.getInsertSql());
        sql.append(" values(newbosid('").append("2C90FD08'),'");
        sql.append(to.id + "','" + to.entryId + "'");
        BigDecimal price = BigDecimal.ZERO;
        BigDecimal taxPrice = BigDecimal.ZERO;
        BigDecimal basePrice = to.price;
        if (isConvert && to.currencySource == 1) {
            if (!to.currencyid.equals(to.ruleCurrencyID) && exchangeRateMap != null && exchangeRateMap.containsKey(to.companyOrgUnitID + to.currencyid + to.ruleCurrencyID) && (list = exchangeRateMap.get(to.companyOrgUnitID + to.currencyid + to.ruleCurrencyID)) != null && list.size() == 3) {
                BigDecimal rateValue = (BigDecimal)list.get(0);
                int convertMode = Integer.parseInt(list.get(1).toString());
                basePrice = convertMode == 1 ? basePrice.divide(rateValue, to.pricePrecision, 4) : basePrice.multiply(rateValue).setScale(to.pricePrecision, 4);
            }
            to.currencyid = to.ruleCurrencyID;
            to.exchangeRate = BigDecimal.ONE;
        }
        if (to.currencySource == 2) {
            if (!to.currencyid.equals(to.ruleCurrencyID)) {
                if (exchangeRateMap != null && exchangeRateMap.containsKey(to.companyOrgUnitID + to.currencyid + to.ruleCurrencyID) && (list = exchangeRateMap.get(to.companyOrgUnitID + to.currencyid + to.ruleCurrencyID)) != null && list.size() == 3) {
                    to.exchangeRate = (BigDecimal)list.get(0);
                }
            } else {
                to.exchangeRate = BigDecimal.ONE;
            }
        }
        if (to.addRate != null && to.addRate.compareTo(BigDecimal.ZERO) != 0) {
            price = basePrice.multiply(BigDecimal.ONE.add(to.addRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4))).setScale(to.pricePrecision, 4);
            taxPrice = price.multiply(BigDecimal.ONE.add(to.taxRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4))).setScale(to.pricePrecision, 4);
        } else if (to.addPrice != null && to.addPrice.compareTo(BigDecimal.ZERO) != 0) {
            price = basePrice.add(to.addPrice).setScale(to.pricePrecision, 4);
            taxPrice = price.multiply(BigDecimal.ONE.add(to.taxRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4))).setScale(to.pricePrecision, 4);
        } else {
            price = basePrice;
            taxPrice = price.multiply(BigDecimal.ONE.add(to.taxRate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4))).setScale(to.pricePrecision, 4);
        }
        sql.append(",").append(price).append(",0,").append(to.discount).append(",").append(to.taxRate).append(",").append(taxPrice);
        sql.append(this.getOtherInsertSql(to));
        sqlList.add(sql.toString());
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void batchExecuteSql(Context ctx, List<String> sqlList) throws BOSException {
        if (sqlList == null) return;
        if (sqlList.size() == 0) {
            return;
        }
        Connection conn = null;
        Statement statement = null;
        try {
            conn = SCMBizProcessorUtil.getConnection((Context)ctx);
            statement = conn.createStatement();
            int size = sqlList.size();
            for (int i = 0; i < size; ++i) {
                statement.addBatch(sqlList.get(i));
            }
            statement.executeBatch();
        }
        catch (SQLDataException e) {
            try {
                throw new BOSException((Throwable)e);
                catch (SQLException e2) {
                    throw new BOSException((Throwable)e2);
                }
            }
            catch (Throwable throwable) {
                SQLUtils.cleanup(statement, (Connection)conn);
                throw throwable;
            }
        }
        SQLUtils.cleanup((Statement)statement, (Connection)conn);
    }

    private IRowSet getDataFromTempTable(Context ctx, String tempTable) throws BOSException, EASBizException {
        StringBuilder sql = new StringBuilder();
        sql.append("select temp.FPurOrderEntryID,temp.FPurOrderID,temp.FRowTypeID,temp.FMaterialID,temp.FMaterialName,").append(LINE);
        sql.append("temp.FUnitID,temp.FBaseUnitID,temp.FAssisPropertyID,temp.FPrice,temp.FTaxPrice,s.FTaxRate,").append(LINE);
        sql.append("temp.FQty,temp.FDiscountMode,temp.FDiscount,temp.FSettlementRelationID,temp.FRelationEntryID,").append(LINE);
        sql.append("temp.FSettlementRuleID,temp.FRuleEntryID,temp.FCurrencyID billCurrencyID,ruleEntry.FCurrencySource,").append(LINE);
        sql.append("relationEntry.FProCompanyOrgID FSupCompanyOrgID,relationEntry.FProProfitCenterID FSupProfitCenterID,").append(LINE);
        sql.append("CASE WHEN relationEntry.FProCompanyOrgID = bill.FCompanyOrgUnitID THEN bill.FStorageOrgUnitID ELSE ");
        sql.append("relationEntry.FProStroageOrgID END as FSupStorageOrgID,").append(LINE);
        sql.append("CASE WHEN relationEntry.FProCompanyOrgID = bill.FCompanyOrgUnitID THEN bill.FWareHouseID ELSE ");
        sql.append("relationEntry.FProWareHouseID END as FSupWareHouseID,").append(LINE);
        sql.append("relationEntry.FAccCompanyOrgID FRecCompanyOrgID,relationEntry.FAccProfitCenterID FRecProfitCenterID,").append(LINE);
        sql.append("CASE WHEN relationEntry.FAccCompanyOrgID = entry.FCompanyOrgUnitID THEN entry.FStorageOrgUnitID ELSE ");
        sql.append("relationEntry.FAccStorageOrgID END as FRecStorageOrgID,").append(LINE);
        sql.append("CASE WHEN relationEntry.FAccCompanyOrgID = entry.FCompanyOrgUnitID THEN entry.FWareHouseID ELSE ");
        sql.append("relationEntry.FAccWareHouseID END as FRecWareHouseID,").append(LINE);
        sql.append("relationEntry.FSaleOrgUnitID,ruleEntry.FPriceRule,ruleEntry.FAdditionRate,ruleEntry.FAddConstantPrice,");
        sql.append("case when temp.FMaterialID is null then rowType.FPrecision else m.FPricePrecision end as pricePrecision,").append(LINE);
        sql.append("c.FBaseCurrencyID as ruleCurrencyID,temp.FExchangeRate,").append(LINE);
        sql.append("case when temp.FMaterialID is null then 0 else mc.FAccountType end as accountType ").append(LINE);
        sql.append(" from ").append(tempTable).append(" temp ").append(LINE);
        sql.append(" inner join T_SCM_RowType rowType on rowType.FID = temp.FRowTypeID").append(LINE);
        sql.append(" left join T_BD_Material m on m.FID = temp.FMaterialID ").append(LINE);
        sql.append(" inner join T_SCM_SettlementRelationEntry relationEntry on temp.FRelationEntryID = relationEntry.FID").append(LINE);
        sql.append(" inner join T_ORG_Company c on c.FID = relationEntry.FProCompanyOrgID").append(LINE);
        sql.append(" inner join t_scm_settlementruleentry ruleEntry on temp.FruleEntryid = ruleEntry.fid").append(LINE);
        sql.append(" inner join T_BD_Supplier s on s.FIsInternalCompany = 1 and s.FInternalCompanyID = c.FID").append(LINE);
        sql.append(" inner join T_SM_PurOrder bill on bill.FID = temp.FPurOrderID ").append(LINE);
        sql.append(" inner join T_SM_PurOrderEntry entry on entry.FID = temp.FPurOrderEntryID ").append(LINE);
        sql.append(" left join T_BD_MaterialCompanyInfo mc on mc.FMaterialID = m.FID and mc.FCompanyID = relationEntry.FProCompanyOrgID");
        sql.append(" order by ruleEntry.FPriceRule");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs == null || rs.size() == 0) {
            return null;
        }
        return rs;
    }

    private Set<String> getHasRelationEntryIds(Context ctx, String tempTable) throws BOSException, SQLException {
        StringBuilder sql = new StringBuilder();
        sql.append("select FPurOrderEntryID as FEntryID from ").append(tempTable);
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs != null && rs.size() > 0) {
            HashSet<String> entryIds = new HashSet<String>();
            while (rs.next()) {
                entryIds.add(rs.getString("FEntryID"));
            }
            return entryIds;
        }
        return null;
    }

    private void calcInnerPriceWithoutRelation(Context ctx, IObjectPK[] pks, List<String> sqlList, Set<String> entryIds) throws BOSException, EASBizException {
        try {
            if (pks == null || pks.length == 0) {
                return;
            }
            IRowSet result = DbUtil.executeQuery((Context)ctx, (String)this.getSql(ctx, pks, entryIds));
            List<PriceCondition> priceConditions = null;
            HashMap<String, List<PriceCondition>> priceConditionMap = new HashMap<String, List<PriceCondition>>();
            boolean isCostAdd = false;
            HashSet<String> souSet = new HashSet<String>();
            HashSet<String> couSet = new HashSet<String>();
            Calendar cal = Calendar.getInstance();
            Timestamp ts = new Timestamp(cal.getTimeInMillis());
            ArrayList<ResultTo> resultToList = new ArrayList<ResultTo>();
            Map<String, TransferRule2Info> transferRuleMap = null;
            boolean isStartParam = this.isStartParam(ctx, result);
            result.first();
            result.previous();
            if (isStartParam) {
                transferRuleMap = this.getTrasferRuleMap(ctx, result);
                result.first();
                result.previous();
            }
            Map<String, String> whMap = this.getWareHouseWithoutRelation(ctx, result);
            result.first();
            result.previous();
            while (result.next()) {
                BigDecimal addRate = BigDecimal.ZERO;
                String recieveStorageId = result.getString("recievestorageorgunitid");
                String issueStorageId = result.getString("issuestorageorgunitid");
                TransferRule2Info ruleInfo = null;
                if (isStartParam && transferRuleMap != null && transferRuleMap.containsKey(issueStorageId + recieveStorageId)) {
                    ruleInfo = transferRuleMap.get(issueStorageId + recieveStorageId);
                }
                InnerCostRuleEnum CostRule = null;
                if (ruleInfo != null) {
                    isCostAdd = ruleInfo.isIssueIsCostBalance();
                    CostRule = ruleInfo.getIssueCostRule();
                    addRate = this.getAddRate(ctx, CostRule, ruleInfo, result);
                }
                if (isStartParam && isCostAdd) {
                    this.calcAddRatePrice(ctx, result, addRate, sqlList, whMap);
                    continue;
                }
                souSet.add(result.getString("issuestorageorgunitid"));
                couSet.add(result.getString("companyOrgUntiID"));
                this.getPriceConditionMap(result, priceConditions, priceConditionMap, ts);
                this.getResultToList(result, resultToList, whMap);
            }
            this.addPurInnerPrice(ctx, resultToList, priceConditionMap, souSet, couSet, sqlList);
        }
        catch (SQLException er) {
            throw new BOSException("sql Execute Error :", (Throwable)er);
        }
    }

    private BigDecimal getAddRate(Context ctx, InnerCostRuleEnum CostRule, TransferRule2Info ruleInfo, IRowSet result) throws BOSException, EASBizException, SQLException {
        BigDecimal addRate = BigDecimal.ZERO;
        if (CostRule.equals((Object)InnerCostRuleEnum.RATEBYMATERIAL)) {
            String materialID = result.getString("materialid");
            String saleouID = ruleInfo.getIssueSaleOrgUnit().getId().toString();
            MaterialSalesInfo materiaSalesInfo = MaterialSalesFactory.getLocalInstance((Context)ctx).getSalesInfo(materialID, saleouID);
            addRate = BigDecimal.valueOf(materiaSalesInfo.getInnerPriceRate());
        } else {
            addRate = this.getAddPrice(ctx, ruleInfo, result.getString("entryid"));
        }
        return addRate;
    }

    private Map<String, String> getWareHouseWithoutRelation(Context ctx, IRowSet result) throws SQLException, BOSException {
        HashSet<String> idSet = new HashSet<String>();
        while (result.next()) {
            if (StringUtils.isEmpty((String)result.getString("wareHouseID_e"))) {
                idSet.add(result.getString("recievestorageorgunitid"));
            }
            if (!StringUtils.isEmpty((String)result.getString("wareHouseID"))) continue;
            idSet.add(result.getString("issuestorageorgunitid"));
        }
        return this.getWareHouseByStorageOrg(ctx, idSet);
    }

    private String getSql(Context ctx, IObjectPK[] pks, Set<String> entryIds) {
        StringBuilder sql = new StringBuilder();
        String params = SCMBizProcessorUtil.convertToString((Object[])pks);
        sql.append("select distinct po.fid id,pe.fid entryid,po.FPurchaseOrgUnitID purOrgUntiID,");
        sql.append("po.FCompanyOrgUnitID companyOrgUntiID,po.FCurrencyID currencyid,pe.FMaterialID materialid,");
        sql.append("case when pe.FMaterialID is null then pe.FMaterialName else material.FName_").append(this.loc).append(" end as materialName,");
        sql.append("pe.FUnitID unitid,pe.FAssistPropertyID assistProperyID,");
        sql.append("cus.fid customerid,pe.FQty qty,pe.FTaxRate taxrate,pe.FPrice price,0 discounttype,");
        sql.append("pe.FDiscountRate discount,pe.FTaxPrice taxprice,material.FPricePrecision priceprecision,");
        sql.append("pe.FActualPrice actualprice,pe.FActualTaxPrice actualtaxprice,");
        sql.append("po.FStorageOrgUnitID issuestorageorgunitid,pe.FStorageOrgUnitID recievestorageorgunitid,");
        sql.append("po.FWareHouseID wareHouseID,pe.FWareHouseID wareHouseID_e,pe.FCompanyOrgUnitID companyOrgUnitID_e,");
        sql.append("pe.FRowTypeID rowTypeID,pe.FBaseUnitID baseUnitID,pe.FIsPresent isPresent, po.FExchangeRate exchangeRate ");
        sql.append(" from T_SM_PurOrder po ");
        sql.append(" inner join T_SM_PurOrderEntry pe on pe.FParentID = po.FID ");
        sql.append(" inner join T_BD_Customer cus on cus.FInternalCompanyID = pe.FCompanyOrgUnitID ");
        sql.append(" left join T_BD_Material material on pe.FMaterialID = material.FID ");
        sql.append(" where po.FID in (");
        sql.append(params);
        sql.append(") and po.FIsCentralBalance = 1 and pe.FIsBetweenCompanyRec = 1");
        if (entryIds != null && entryIds.size() > 0) {
            sql.append(" and pe.FID not in ").append(SCMServerUtils.getInStringFromSet(entryIds));
        }
        return sql.toString();
    }

    private String getInsertSql() {
        StringBuilder insertStr = new StringBuilder();
        insertStr.append(" insert into T_SM_PurInnerDealPrice(FID,FPurOrderID,FPurOrderEntryID,FPrice,");
        insertStr.append("FDiscountMode,FDiscount,FTaxRate,FTaxPrice,");
        insertStr.append("FRowTypeID,FMaterialID,FMaterialName,FUnitID,FBaseUnitID,FAssistPropertyID,");
        insertStr.append("FSupCompanyOrgID,FSupProfitCenterID,FSupStorageOrgID,FSupWareHouseID,FRecCompanyOrgID,");
        insertStr.append("FRecProfitCenterID,FRecStorageOrgID,FRecWareHouseID,FSettlementRuleID,FCurrencyID,FExchangeRate,FSaleOrgUnitID");
        insertStr.append(")");
        return insertStr.toString();
    }

    private boolean isStartParam(Context ctx, IRowSet result) throws SQLException {
        boolean paramValue = false;
        if (result != null && result.next()) {
            String orgUnitID = result.getString("purOrgUntiID");
            paramValue = this.isStartInnerPricePoly(ctx, orgUnitID);
        }
        return paramValue;
    }

    private Map<String, TransferRule2Info> getTrasferRuleMap(Context ctx, IRowSet result) throws SQLException, BOSException {
        TransferRule2Info ruleInfo = null;
        String issueStorageId = "";
        HashSet<String> recieveStorageIdSet = new HashSet<String>();
        while (result.next()) {
            if (StringUtils.isEmpty((String)issueStorageId)) {
                issueStorageId = result.getString("issuestorageorgunitid");
            }
            recieveStorageIdSet.add(result.getString("recievestorageorgunitid"));
        }
        TransferRule2Collection coll = this.getTransferRuleCollection(ctx, issueStorageId, recieveStorageIdSet);
        if (coll != null && coll.size() > 0) {
            HashMap<String, TransferRule2Info> ruleMap = new HashMap<String, TransferRule2Info>();
            int size = coll.size();
            for (int i = 0; i < size; ++i) {
                ruleInfo = coll.get(i);
                if (ruleInfo == null || ruleInfo.getSupplyRelation() == null || ruleMap.containsKey(ruleInfo.getSupplyRelation().getIssueStorageOrgUnit().getId().toString() + ruleInfo.getSupplyRelation().getReceiveStorageOrgUnit().getId().toString())) continue;
                ruleMap.put(ruleInfo.getSupplyRelation().getIssueStorageOrgUnit().getId().toString() + ruleInfo.getSupplyRelation().getReceiveStorageOrgUnit().getId().toString(), ruleInfo);
            }
            return ruleMap;
        }
        return null;
    }

    private void calcAddRatePrice(Context ctx, IRowSet result, BigDecimal addRate, List<String> sqlList, Map<String, String> whMap) throws SQLException {
        StringBuilder insertStr = new StringBuilder();
        insertStr.append(this.getInsertSql());
        int precision = result.getInt("priceprecision");
        BigDecimal actualPrice = BigDecimal.ZERO.setScale(precision, 4);
        BigDecimal price = BigDecimal.ZERO.setScale(precision, 4);
        insertStr.append(" values(newbosid('").append("2C90FD08'),'");
        insertStr.append(result.getString("id") + "','" + result.getString("entryid") + "'");
        addRate = addRate.multiply(new BigDecimal("0.01"));
        actualPrice = result.getBigDecimal("actualprice");
        BigDecimal orderTaxRate = result.getBigDecimal("taxrate");
        if (orderTaxRate.unscaledValue().intValue() == 0) {
            orderTaxRate = BigDecimal.ZERO;
        }
        BigDecimal taxPrice = BigDecimal.ZERO.setScale(precision, 4);
        price = actualPrice.multiply(addRate.add(SCMConstant.BIGDECIMAL_ONE)).setScale(precision, 4);
        taxPrice = price.multiply(orderTaxRate.multiply(new BigDecimal("0.01")).add(SCMConstant.BIGDECIMAL_ONE)).setScale(precision, 4);
        insertStr.append(",").append(price);
        insertStr.append(",").append(0);
        insertStr.append(",0");
        insertStr.append(",").append(orderTaxRate);
        insertStr.append(",").append(taxPrice);
        insertStr.append(",").append(this.getStringValue(result.getString("rowTypeID")));
        insertStr.append(",").append(this.getStringValue(result.getString("materialid")));
        insertStr.append(",").append(this.getStringValue(result.getString("materialName")));
        insertStr.append(",").append(this.getStringValue(result.getString("unitid")));
        insertStr.append(",").append(this.getStringValue(result.getString("baseUnitID")));
        insertStr.append(",").append(this.getStringValue(result.getString("assistProperyID")));
        insertStr.append(",").append(this.getStringValue(result.getString("companyOrgUntiID")));
        insertStr.append(",").append("''");
        insertStr.append(",").append(this.getStringValue(result.getString("issuestorageorgunitid")));
        if (StringUtils.isEmpty((String)result.getString("wareHouseID")) && whMap != null && whMap.containsKey(result.getString("issuestorageorgunitid"))) {
            insertStr.append(",").append(this.getStringValue(whMap.get(result.getString("issuestorageorgunitid"))));
        } else {
            insertStr.append(",").append(this.getStringValue(result.getString("wareHouseID")));
        }
        insertStr.append(",").append(this.getStringValue(result.getString("companyOrgUnitID_e")));
        insertStr.append(",").append("''");
        insertStr.append(",").append(this.getStringValue(result.getString("recievestorageorgunitid")));
        if (StringUtils.isEmpty((String)result.getString("wareHouseID_e")) && whMap != null && whMap.containsKey(result.getString("recievestorageorgunitid"))) {
            insertStr.append(",").append(this.getStringValue(whMap.get(result.getString("recievestorageorgunitid"))));
        } else {
            insertStr.append(",").append(this.getStringValue(result.getString("wareHouseID_e")));
        }
        insertStr.append(",").append("''");
        insertStr.append(",").append(this.getStringValue(result.getString("currencyid")));
        insertStr.append(",").append(result.getBigDecimal("exchangeRate"));
        insertStr.append(",").append("''");
        insertStr.append(")");
        sqlList.add(insertStr.toString());
    }

    private String getStringValue(String value) {
        if (StringUtils.isEmpty((String)value)) {
            return "''";
        }
        return "'" + value + "'";
    }

    private void getPriceConditionMap(IRowSet result, List<PriceCondition> priceConditions, Map<String, List<PriceCondition>> priceConditionMap, Timestamp ts) throws UuidException, SQLException {
        if (StringUtils.isEmpty((String)result.getString("materialid"))) {
            return;
        }
        PriceCondition priceCondition = new PriceCondition();
        CustomerInfo customerInfo = new CustomerInfo();
        customerInfo.setId(BOSUuid.read((String)result.getString("customerid")));
        priceCondition.setCustomerInfo(customerInfo);
        MaterialInfo materialInfo = new MaterialInfo();
        materialInfo.setId(BOSUuid.read((String)result.getString("materialid")));
        MeasureUnitInfo baseUnitInfo = new MeasureUnitInfo();
        baseUnitInfo.setId(BOSUuid.read((String)result.getString("baseUnitID")));
        materialInfo.setBaseUnit(baseUnitInfo);
        priceCondition.setMaterialInfo(materialInfo);
        CompanyOrgUnitInfo companyOrgInfo = new CompanyOrgUnitInfo();
        companyOrgInfo.setId(BOSUuid.read((String)result.getString("companyOrgUntiID")));
        priceCondition.setCompanyOrg(companyOrgInfo);
        CurrencyInfo currencyInfo = new CurrencyInfo();
        currencyInfo.setId(BOSUuid.read((String)result.getString("currencyid")));
        priceCondition.setCurrencyInfo(currencyInfo);
        priceCondition.setOrderQty(result.getBigDecimal("qty"));
        priceCondition.setMeasureUnit(result.getString("unitid"));
        priceCondition.setCurDate((Date)ts);
        priceCondition.setPriceTypeID("00000000-0000-0000-0000-0000000000036A61CE8D");
        if (!StringUtils.isEmpty((String)result.getString("assistProperyID"))) {
            AsstAttrValueInfo asstValueInfo = new AsstAttrValueInfo();
            asstValueInfo.setId(BOSUuid.read((String)result.getString("assistProperyID")));
            priceCondition.setAssiProperty(asstValueInfo);
        }
        priceConditions = priceConditionMap.containsKey(companyOrgInfo.getId().toString() + SPLITSIGN + customerInfo.getId().toString()) ? priceConditionMap.get(companyOrgInfo.getId().toString() + SPLITSIGN + customerInfo.getId().toString()) : new ArrayList<PriceCondition>();
        priceConditions.add(priceCondition);
        priceConditionMap.put(companyOrgInfo.getId().toString() + SPLITSIGN + customerInfo.getId().toString(), priceConditions);
    }

    private void getResultToList(IRowSet result, List<ResultTo> resultToList, Map<String, String> whMap) throws SQLException {
        ResultTo to = new ResultTo();
        to.id = result.getString("id");
        to.entryId = result.getString("entryid");
        to.companyOrgUnitID = result.getString("companyOrgUntiID");
        to.supProfitCenterID = "";
        to.supStorageOrgID = result.getString("issuestorageorgunitid");
        to.supWareHouseID = StringUtils.isEmpty((String)result.getString("wareHouseID")) && whMap != null && whMap.containsKey(to.supStorageOrgID) ? whMap.get(to.supStorageOrgID) : result.getString("wareHouseID");
        to.recCompanyOrgID = result.getString("companyOrgUnitID_e");
        to.recProfitCenterID = "";
        to.storageOrgUnitID = result.getString("recievestorageorgunitid");
        to.recWareHouseID = StringUtils.isEmpty((String)result.getString("wareHouseID_e")) && whMap != null && whMap.containsKey(to.storageOrgUnitID) ? whMap.get(to.storageOrgUnitID) : result.getString("wareHouseID_e");
        to.settlementRuleID = "";
        to.pricePrecision = result.getInt("priceprecision");
        to.discount = result.getBigDecimal("discount");
        to.taxRate = result.getBigDecimal("taxrate");
        to.taxPrice = result.getBigDecimal("taxprice");
        to.actualTaxPrice = result.getBigDecimal("actualtaxprice");
        to.customerId = result.getString("customerid");
        to.rowTypeId = result.getString("rowTypeID");
        to.materialId = result.getString("materialid");
        to.materialName = result.getString("materialName");
        to.unitId = result.getString("unitid");
        to.baseUnitId = result.getString("baseUnitID");
        to.qty = result.getBigDecimal("qty");
        to.currencyid = result.getString("currencyid");
        to.exchangeRate = result.getBigDecimal("exchangeRate");
        to.price = result.getBigDecimal("price");
        to.actualPrice = result.getBigDecimal("actualprice");
        to.discountType = result.getInt("discounttype");
        to.isPresent = result.getInt("isPresent");
        if (!StringUtils.isEmpty((String)result.getString("assistProperyID"))) {
            to.assistPropertyID = result.getString("assistProperyID");
        }
        resultToList.add(to);
    }

    private List<ResultTo> putSettlementResultToList(IRowSet result) throws SQLException, BOSException {
        if (result == null || result.size() == 0) {
            return null;
        }
        ArrayList<ResultTo> resultToList = new ArrayList<ResultTo>();
        ResultTo to = null;
        while (result.next()) {
            to = new ResultTo();
            to.id = result.getString("FPurOrderID");
            to.entryId = result.getString("FPurOrderEntryID");
            to.companyOrgUnitID = result.getString("FSupCompanyOrgID");
            to.supProfitCenterID = result.getString("FSupProfitCenterID");
            to.supStorageOrgID = result.getString("FSupStorageOrgID");
            to.supWareHouseID = result.getString("FSupWareHouseID");
            to.recCompanyOrgID = result.getString("FRecCompanyOrgID");
            to.recProfitCenterID = result.getString("FRecProfitCenterID");
            to.storageOrgUnitID = result.getString("FRecStorageOrgID");
            to.recWareHouseID = result.getString("FRecWareHouseID");
            to.settlementRuleID = result.getString("FSettlementRuleID");
            to.ruleEntryID = result.getString("FRuleEntryID");
            to.ruleCurrencyID = result.getString("ruleCurrencyID");
            to.relationEntryID = result.getString("FRelationEntryID");
            to.saleOrgID = result.getString("FSaleOrgUnitID");
            to.pricePrecision = result.getInt("pricePrecision");
            to.discount = result.getBigDecimal("FDiscount");
            if (to.discount.unscaledValue().intValue() == 0) {
                to.discount = BigDecimal.ZERO;
            }
            to.taxRate = result.getBigDecimal("FTaxRate");
            if (to.taxRate.unscaledValue().intValue() == 0) {
                to.taxRate = BigDecimal.ZERO;
            }
            to.taxPrice = result.getBigDecimal("FTaxPrice");
            to.customerId = "";
            to.rowTypeId = result.getString("FRowTypeID");
            to.materialId = result.getString("FMaterialID");
            to.materialName = result.getString("FMaterialName");
            to.unitId = result.getString("FUnitID");
            to.baseUnitId = result.getString("FBaseUnitID");
            to.qty = result.getBigDecimal("FQty");
            to.currencyid = result.getString("billCurrencyID");
            to.price = result.getBigDecimal("FPrice");
            to.discountType = result.getInt("FDiscountMode");
            if (!StringUtils.isEmpty((String)result.getString("FAssisPropertyID"))) {
                to.assistPropertyID = result.getString("FAssisPropertyID");
            }
            to.priceRule = result.getInt("FPriceRule");
            to.addRate = result.getBigDecimal("FAdditionRate");
            to.addPrice = result.getBigDecimal("FAddConstantPrice");
            to.accountType = result.getInt("accountType");
            to.currencySource = result.getInt("FCurrencySource");
            to.exchangeRate = result.getBigDecimal("FExchangeRate");
            resultToList.add(to);
        }
        return resultToList;
    }

    private void setValueToResultList(Context ctx, List<ResultTo> resultList) throws BOSException, SQLException {
        this.setStorageOrgToResultList(ctx, resultList);
        this.setWareHouseToResultList(ctx, resultList);
        this.setSaleOrgToResultList(ctx, resultList);
    }

    private void setStorageOrgToResultList(Context ctx, List<ResultTo> resultList) throws BOSException {
        if (resultList == null || resultList.size() == 0) {
            return;
        }
        ResultTo to = null;
        HashSet<String> companyIdSet = new HashSet<String>();
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            to = resultList.get(i);
            if (StringUtils.isEmpty((String)to.supStorageOrgID) && !StringUtils.isEmpty((String)to.companyOrgUnitID)) {
                companyIdSet.add(to.companyOrgUnitID);
            }
            if (!StringUtils.isEmpty((String)to.storageOrgUnitID) || StringUtils.isEmpty((String)to.recCompanyOrgID)) continue;
            companyIdSet.add(to.recCompanyOrgID);
        }
        Map<String, String> storageOrgMap = this.getStorageOrgsByCompany(ctx, companyIdSet);
        if (storageOrgMap != null && storageOrgMap.size() > 0) {
            int size2 = resultList.size();
            for (int i = 0; i < size2; ++i) {
                to = resultList.get(i);
                if (StringUtils.isEmpty((String)to.supStorageOrgID) && !StringUtils.isEmpty((String)to.companyOrgUnitID) && storageOrgMap.containsKey(to.companyOrgUnitID)) {
                    to.supStorageOrgID = storageOrgMap.get(to.companyOrgUnitID).toString();
                }
                if (!StringUtils.isEmpty((String)to.storageOrgUnitID) || StringUtils.isEmpty((String)to.recCompanyOrgID) || !storageOrgMap.containsKey(to.recCompanyOrgID)) continue;
                to.storageOrgUnitID = storageOrgMap.get(to.recCompanyOrgID).toString();
            }
        }
    }

    private void setSaleOrgToResultList(Context ctx, List<ResultTo> resultList) throws BOSException {
        if (resultList == null || resultList.size() == 0) {
            return;
        }
        ResultTo to = null;
        HashSet<String> storageIdSet = new HashSet<String>();
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            to = resultList.get(i);
            if (!StringUtils.isEmpty((String)to.saleOrgID) || StringUtils.isEmpty((String)to.supStorageOrgID)) continue;
            storageIdSet.add(to.supStorageOrgID);
        }
        OrgUnitRelationCollection relCol = this.getOrgUnitRelationColl(ctx, storageIdSet, 4, 2, "fromUnit.id", "toUnit.number");
        if (relCol != null && relCol.size() > 0) {
            HashSet<String> ids = new HashSet<String>();
            HashMap map = new HashMap();
            List<String> slist = null;
            OrgUnitRelationInfo relInfo = null;
            int n = relCol.size();
            for (int i = 0; i < n; ++i) {
                relInfo = relCol.get(i);
                ids.add(relInfo.getToUnit().getId().toString());
                slist = map.containsKey(relInfo.getFromUnit().getId().toString()) ? (List)map.get(relInfo.getFromUnit().getId().toString()) : new ArrayList<String>();
                slist.add(relInfo.getToUnit().getId().toString());
                map.put(relInfo.getFromUnit().getId().toString(), slist);
            }
            OrgUnitRelationCollection couOrgColl = this.getOrgUnitRelationColl(ctx, ids, 2, 1, "fromUnit.id", "toUnit.number");
            if (couOrgColl != null && couOrgColl.size() > 0) {
                int i;
                HashMap<String, String> smap = new HashMap<String, String>();
                int size2 = couOrgColl.size();
                for (i = 0; i < size2; ++i) {
                    relInfo = couOrgColl.get(i);
                    smap.put(relInfo.getFromUnit().getId().toString(), relInfo.getToUnit().getId().toString());
                }
                size2 = resultList.size();
                block3: for (i = 0; i < size2; ++i) {
                    to = resultList.get(i);
                    if (!StringUtils.isEmpty((String)to.saleOrgID) || StringUtils.isEmpty((String)to.supStorageOrgID) || !map.containsKey(to.supStorageOrgID)) continue;
                    slist = (List)map.get(to.supStorageOrgID);
                    int n2 = slist.size();
                    for (int j = 0; j < n2; ++j) {
                        if (!smap.containsKey(slist.get(j)) || !to.companyOrgUnitID.equals(smap.get(slist.get(j)))) continue;
                        to.saleOrgID = (String)slist.get(j);
                        continue block3;
                    }
                }
            }
        }
    }

    private void setWareHouseToResultList(Context ctx, List<ResultTo> resultList) throws BOSException, SQLException {
        if (resultList == null || resultList.size() == 0) {
            return;
        }
        ResultTo to = null;
        HashSet<String> storageIdSet = new HashSet<String>();
        int size = resultList.size();
        for (int i = 0; i < size; ++i) {
            to = resultList.get(i);
            if (StringUtils.isEmpty((String)to.supWareHouseID) && !StringUtils.isEmpty((String)to.supStorageOrgID)) {
                storageIdSet.add(to.supStorageOrgID);
            }
            if (!StringUtils.isEmpty((String)to.recWareHouseID) || StringUtils.isEmpty((String)to.storageOrgUnitID)) continue;
            storageIdSet.add(to.storageOrgUnitID);
        }
        Map<String, String> map = this.getWareHouseByStorageOrg(ctx, storageIdSet);
        if (map != null && map.size() > 0) {
            int size2 = resultList.size();
            for (int i = 0; i < size2; ++i) {
                to = resultList.get(i);
                if (StringUtils.isEmpty((String)to.supWareHouseID) && !StringUtils.isEmpty((String)to.supStorageOrgID) && map.containsKey(to.supStorageOrgID)) {
                    to.supWareHouseID = map.get(to.supStorageOrgID);
                }
                if (!StringUtils.isEmpty((String)to.recWareHouseID) || StringUtils.isEmpty((String)to.storageOrgUnitID) || !map.containsKey(to.storageOrgUnitID)) continue;
                to.recWareHouseID = map.get(to.storageOrgUnitID);
            }
        }
    }

    private Map<String, String> getWareHouseByStorageOrg(Context ctx, Set<String> ids) throws BOSException, SQLException {
        if (ids == null || ids.size() == 0) {
            return null;
        }
        StringBuilder sql = new StringBuilder();
        sql.append("select fid,FStorageOrgID from T_DB_WareHouse where FStorageOrgID in ").append(SCMServerUtils.getInStringFromSet(ids));
        sql.append(" and FWHState = '1' order by FStorageOrgID,FNumber");
        IRowSet rs = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        if (rs == null || rs.size() == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        while (rs.next()) {
            if (map.containsKey(rs.getString("FStorageOrgID"))) continue;
            map.put(rs.getString("FStorageOrgID"), rs.getString("fid"));
        }
        return map;
    }

    private String getOtherInsertSql(ResultTo to) {
        if (to == null) {
            return "";
        }
        StringBuilder sql = new StringBuilder();
        String materialName = StringUtils.replace((String)to.materialName, (String)"'", (String)"''");
        sql.append(",").append(this.getStringValue(to.rowTypeId));
        sql.append(",").append(this.getStringValue(to.materialId));
        sql.append(",").append(this.getStringValue(materialName));
        sql.append(",").append(this.getStringValue(to.unitId));
        sql.append(",").append(this.getStringValue(to.baseUnitId));
        sql.append(",").append(this.getStringValue(to.assistPropertyID));
        sql.append(",").append(this.getStringValue(to.companyOrgUnitID));
        sql.append(",").append(this.getStringValue(to.supProfitCenterID));
        sql.append(",").append(this.getStringValue(to.supStorageOrgID));
        sql.append(",").append(this.getStringValue(to.supWareHouseID));
        sql.append(",").append(this.getStringValue(to.recCompanyOrgID));
        sql.append(",").append(this.getStringValue(to.recProfitCenterID));
        sql.append(",").append(this.getStringValue(to.storageOrgUnitID));
        sql.append(",").append(this.getStringValue(to.recWareHouseID));
        sql.append(",").append(this.getStringValue(to.settlementRuleID));
        sql.append(",").append(this.getStringValue(to.currencyid));
        sql.append(",").append(to.exchangeRate);
        sql.append(",").append(this.getStringValue(to.saleOrgID));
        sql.append(")");
        return sql.toString();
    }

    private Map getMaterialLongNumMaps(Context ctx, List<ResultTo> resultToList) throws BOSException {
        HashMap<String, String> map = new HashMap<String, String>();
        if (resultToList == null || resultToList.size() == 0) {
            return map;
        }
        StringBuffer ids = new StringBuffer("");
        int n = resultToList.size();
        for (int i = 0; i < n; ++i) {
            if (i > 0) {
                ids.append(",");
            }
            ids.append("'");
            ids.append(resultToList.get((int)i).materialId);
            ids.append("'");
        }
        IRowSet resultSet = null;
        String sql = null;
        sql = "select mlgd.fmaterialid materialid,mlg.flongnumber longnumber from t_bd_materialgroup mlg inner join T_BD_MATERIALGROUPDETIAL mlgd on mlg.fid = mlgd.fmaterialgroupid where fmaterialid  in (" + ids + ")";
        resultSet = DbUtil.executeQuery((Context)ctx, (String)sql.toString());
        String materialId = "";
        try {
            while (resultSet.next()) {
                materialId = resultSet.getObject("materialid").toString();
                if (map.containsKey(materialId)) {
                    map.put(materialId, map.get(materialId) + "@" + resultSet.getObject("longnumber").toString());
                    continue;
                }
                map.put(materialId, resultSet.getObject("longnumber").toString());
            }
        }
        catch (SQLException e) {
            throw new BOSException((Throwable)e);
        }
        return map;
    }

    private void addPurInnerPrice(Context ctx, List<ResultTo> resultToList, Map<String, List<PriceCondition>> priceConditionMap, Set<String> souSet, Set<String> couSet, List<String> sqlList) throws EASBizException, BOSException, SQLException {
        List tempList = null;
        Map<String, List> priceResultMap = this.getPrice(ctx, priceConditionMap, souSet, couSet);
        if (resultToList == null || resultToList.size() == 0) {
            return;
        }
        Map materialLNMaps = this.getMaterialLongNumMaps(ctx, resultToList);
        StringBuilder insertStr = new StringBuilder();
        int precision = 0;
        BigDecimal dPriceValue = BigDecimal.ZERO;
        BigDecimal discountValue = BigDecimal.ZERO;
        BigDecimal taxrate = BigDecimal.ZERO;
        BigDecimal price = BigDecimal.ZERO;
        PriceParamInfo priceparamInfo = null;
        IPriceParam iPriceParam = PriceParamFactory.getLocalInstance((Context)ctx);
        String insertSql = this.getInsertSql();
        SalePriceTO salePriceTo = null;
        Iterator<ResultTo> it = resultToList.iterator();
        while (it.hasNext()) {
            dPriceValue = BigDecimal.ZERO;
            discountValue = BigDecimal.ZERO;
            taxrate = BigDecimal.ZERO;
            price = BigDecimal.ZERO;
            priceparamInfo = null;
            ResultTo to = it.next();
            if (priceResultMap != null && priceResultMap.containsKey(to.companyOrgUnitID + SPLITSIGN + to.customerId) && to.isPresent != 1) {
                tempList = priceResultMap.get(to.companyOrgUnitID + SPLITSIGN + to.customerId);
                salePriceTo = this.matchSalePriceTo(materialLNMaps, tempList, to, false);
            }
            precision = to.pricePrecision;
            insertStr.delete(0, insertStr.length());
            insertStr.append(insertSql);
            insertStr.append(" values(newbosid('").append("2C90FD08'),");
            insertStr.append("'").append(to.id).append("',");
            insertStr.append("'").append(to.entryId).append("'");
            if (salePriceTo != null) {
                if (salePriceTo.priceType != null && salePriceTo.priceType.equals("basePrice")) {
                    OrgUnitCollection orgUnitCollection = SCMGroupServerUtils.getOrgsByRelation((Context)ctx, (OrgType)OrgType.Company, (OrgType)OrgType.Sale, (String)to.companyOrgUnitID);
                    int c = orgUnitCollection.size();
                    for (int i = 0; i < c; ++i) {
                        String cuid = orgUnitCollection.get(i).getId().toString();
                        PriceParamInfo tempInfo = iPriceParam.getParameter(cuid);
                        if (!tempInfo.isStartPriceDiscountM()) continue;
                        priceparamInfo = tempInfo;
                        to.saleOrgID = cuid;
                        break;
                    }
                } else {
                    priceparamInfo = iPriceParam.getParameter(salePriceTo.saleOrgUniID);
                    to.saleOrgID = salePriceTo.saleOrgUniID;
                }
                if (salePriceTo.price != null) {
                    dPriceValue = salePriceTo.price;
                }
                if (salePriceTo.discountValue != null) {
                    if (this.discountScale == -1) {
                        String rateScale = ParamManager.getParamByNumber((Context)ctx, (String)"DISCOUNTRATEPRECISION").getDefaultValue();
                        this.discountScale = Integer.parseInt(rateScale);
                    }
                    discountValue = salePriceTo.discountValue;
                }
                String discountMode = salePriceTo.discountMode != null ? salePriceTo.discountMode.toString() : "";
                taxrate = to.taxRate.unscaledValue().intValue() == 0 ? BigDecimal.ZERO : to.taxRate;
                BigDecimal transferTaxRate = taxrate.divide(SCMConstant.BIGDECIMAL_ONEHUNDRED, 10, 4).add(SCMConstant.BIGDECIMAL_ONE);
                if (discountMode.equals("1")) {
                    discountValue = discountValue.divide(dPriceValue, this.discountScale, 4).multiply(SCMConstant.BIGDECIMAL_ONEHUNDRED).setScale(this.discountScale, 4);
                }
                if (priceparamInfo != null && priceparamInfo.isContainTax()) {
                    price = dPriceValue.divide(transferTaxRate, precision, 4);
                    insertStr.append("," + price + "," + 0 + "," + discountValue).append("," + taxrate + "," + dPriceValue);
                } else {
                    price = dPriceValue.multiply(transferTaxRate).setScale(precision, 4);
                    insertStr.append("," + dPriceValue + "," + 0 + "," + discountValue).append("," + taxrate + "," + price);
                }
            } else {
                dPriceValue = to.actualPrice.unscaledValue().intValue() == 0 ? BigDecimal.ZERO : to.actualPrice;
                discountValue = to.discount.unscaledValue().intValue() == 0 ? BigDecimal.ZERO : to.discount;
                taxrate = to.taxRate.unscaledValue().intValue() == 0 ? BigDecimal.ZERO : to.taxRate;
                price = to.actualTaxPrice.unscaledValue().intValue() == 0 ? BigDecimal.ZERO : to.actualTaxPrice;
                insertStr.append("," + dPriceValue + "," + 0 + "," + discountValue).append("," + taxrate + "," + price);
            }
            insertStr.append(this.getOtherInsertSql(to));
            sqlList.add(insertStr.toString());
        }
    }

    private boolean isStartInnerPricePoly(Context ctx, String orgUnitID) {
        boolean isParamValue = false;
        try {
            String paramValue;
            IParamControl paramControl = ParamControlFactory.getLocalInstance((Context)ctx);
            ObjectUuidPK orgUnitPK = null;
            if (orgUnitID != null) {
                orgUnitPK = new ObjectUuidPK(orgUnitID);
            }
            if ((paramValue = paramControl.getParamValue(orgUnitPK, "PURORDER102")) != null) {
                isParamValue = "true".equalsIgnoreCase(paramValue);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return isParamValue;
    }

    private TransferRule2Collection getTransferRuleCollection(Context ctx, String issueStorageId, Set<String> receiveStorageIdSet) throws BOSException {
        EntityViewInfo evi = new EntityViewInfo();
        FilterInfo fi = new FilterInfo();
        evi.setFilter(fi);
        fi.getFilterItems().add(new FilterItemInfo("supplyRelation.issueStorageOrgUnit", (Object)issueStorageId));
        fi.getFilterItems().add(new FilterItemInfo("supplyRelation.receiveStorageOrgUnit", receiveStorageIdSet, CompareType.INCLUDE));
        fi.appendFilterItem("status", (Object)UseStatusEnum.ACTIVE);
        evi.getSelector().add("id");
        evi.getSelector().add("issueCostRate");
        evi.getSelector().add("issueCostRule");
        evi.getSelector().add("issueIsCostBalance");
        evi.getSelector().add("issueSaleOrgUnit");
        evi.getSelector().add("supplyRelation.id");
        evi.getSelector().add("supplyRelation.issueStorageOrgUnit.id");
        evi.getSelector().add("supplyRelation.receiveStorageOrgUnit.id");
        TransferRule2Collection tr2Col = TransferRule2Factory.getLocalInstance((Context)ctx).getTransferRule2Collection(evi);
        if (tr2Col != null && tr2Col.size() > 0) {
            return tr2Col;
        }
        return null;
    }

    protected BigDecimal getAddPrice(Context ctx, TransferRule2Info rule, String entryid) {
        return rule.getIssueCostRate();
    }

    private Map<String, List> getPrice(Context ctx, Map<String, List<PriceCondition>> priceConditionMap, Set<String> souSet, Set<String> couSet) throws BOSException, EASBizException {
        if (couSet == null || couSet.size() == 0 || priceConditionMap == null || priceConditionMap.size() == 0) {
            return null;
        }
        List<PriceCondition> priceList = null;
        ArrayList<PriceCondition> newPriceList = new ArrayList<PriceCondition>();
        PriceCondition priceCondition = null;
        List<String> list = null;
        HashMap<String, List> priceResultMap = new HashMap<String, List>();
        ArrayList tempList = null;
        Map<String, List<String>> map = this.getToOrgUnit(ctx, souSet, couSet);
        IPriceProvider iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
        for (Map.Entry<String, List<PriceCondition>> entry : priceConditionMap.entrySet()) {
            priceList = entry.getValue();
            String[] str = entry.getKey().split(SPLITSIGN);
            if (priceList != null && priceList.size() > 0 && map.containsKey(str[0])) {
                list = map.get(str[0]);
                newPriceList = new ArrayList();
                int size = priceList.size();
                for (int i = 0; i < size; ++i) {
                    priceCondition = priceList.get(i);
                    int count = list.size();
                    for (int j = 0; j < count; ++j) {
                        PriceCondition newPrice = new PriceCondition();
                        newPrice.setCustomerInfo(priceCondition.getCustomerInfo());
                        newPrice.setMaterialInfo(priceCondition.getMaterialInfo());
                        newPrice.setMeasureUnit(priceCondition.getMeasureUnit());
                        newPrice.setCompanyOrg(priceCondition.getCompanyOrg());
                        newPrice.setOrderQty(priceCondition.getOrderQty());
                        newPrice.setCurrencyInfo(priceCondition.getCurrencyInfo());
                        newPrice.setCurDate(priceCondition.getCurDate());
                        newPrice.setPriceTypeID(priceCondition.getPriceTypeID());
                        newPrice.setAssiProperty(priceCondition.getAssisProperty());
                        SaleOrgUnitInfo sou = new SaleOrgUnitInfo();
                        sou.setId(BOSUuid.read((String)list.get(j)));
                        newPrice.setSaleOrg(sou);
                        newPriceList.add(newPrice);
                    }
                }
            }
            int num = newPriceList.size() > 0 ? newPriceList.size() : 1;
            PriceCondition[] priceConditions = new PriceCondition[num];
            int p = 0;
            Iterator it = newPriceList.iterator();
            while (it.hasNext()) {
                priceConditions[p++] = (PriceCondition)it.next();
            }
            tempList = new ArrayList();
            List[] list1 = iProvider.getPrices(priceConditions);
            if (list1 != null) {
                for (List priceToList : list1) {
                    if (priceToList == null || priceToList.size() <= 0) continue;
                    tempList.addAll(priceToList);
                }
            }
            priceResultMap.put(entry.getKey(), tempList);
        }
        return priceResultMap;
    }

    private Map<String, List> getPrice(Context ctx, Map<String, List<PriceCondition>> priceConditionMap) throws BOSException, EASBizException {
        if (priceConditionMap == null || priceConditionMap.size() == 0) {
            return null;
        }
        List<PriceCondition> priceList = null;
        HashMap<String, List> priceResultMap = new HashMap<String, List>();
        ArrayList tempList = null;
        IPriceProvider iProvider = PriceProviderFactory.getLocalInstance((Context)ctx);
        for (Map.Entry<String, List<PriceCondition>> entry : priceConditionMap.entrySet()) {
            priceList = entry.getValue();
            int num = priceList.size() > 0 ? priceList.size() : 1;
            PriceCondition[] priceConditions = new PriceCondition[num];
            int p = 0;
            Iterator<PriceCondition> it = priceList.iterator();
            while (it.hasNext()) {
                priceConditions[p++] = it.next();
            }
            tempList = new ArrayList();
            for (List priceToList : iProvider.getPrices(priceConditions)) {
                if (priceToList == null || priceToList.size() <= 0) continue;
                tempList.addAll(priceToList);
            }
            priceResultMap.put(entry.getKey(), tempList);
        }
        return priceResultMap;
    }

    private Map<String, List<String>> getToOrgUnit(Context ctx, Set<String> ids, Set<String> cids) throws BOSException, EASBizException {
        HashMap<String, List<String>> toOrgUnitMap = new HashMap<String, List<String>>();
        if (ids == null || ids.size() == 0 || cids == null || cids.size() == 0) {
            return toOrgUnitMap;
        }
        OrgUnitRelationCollection relCol = this.getOrgUnitRelationColl(ctx, ids, 4, 2, "fromUnit.id", "toUnit.number");
        if (relCol != null && relCol.size() > 0) {
            ids.clear();
            int n = relCol.size();
            for (int i = 0; i < n; ++i) {
                OrgUnitRelationInfo relInfo = relCol.get(i);
                ids.add(relInfo.getToUnit().getId().toString());
            }
            if (ids.size() == 0) {
                return toOrgUnitMap;
            }
            OrgUnitRelationCollection couOrgColl = this.getOrgUnitRelationColl(ctx, ids, 2, 1, "fromUnit.id", "toUnit.number");
            if (couOrgColl == null || couOrgColl.size() == 0) {
                return toOrgUnitMap;
            }
            List<String> saleOrgList = null;
            int n2 = couOrgColl.size();
            for (int i = 0; i < n2; ++i) {
                OrgUnitRelationInfo relInfo = couOrgColl.get(i);
                if (!cids.contains(relInfo.getToUnit().getId().toString())) continue;
                if (toOrgUnitMap.get(relInfo.getToUnit().getId().toString()) != null) {
                    saleOrgList = (List)toOrgUnitMap.get(relInfo.getToUnit().getId().toString());
                    saleOrgList.add(relInfo.getFromUnit().getId().toString());
                    continue;
                }
                saleOrgList = new ArrayList<String>();
                saleOrgList.add(relInfo.getFromUnit().getId().toString());
                toOrgUnitMap.put(relInfo.getToUnit().getId().toString(), saleOrgList);
            }
            return toOrgUnitMap;
        }
        return toOrgUnitMap;
    }

    private SalePriceTO matchSalePriceTo(Map materialLNMaps, List priceList, ResultTo to, boolean checkSaleOrg) {
        SalePriceTO includeAssistPropertyPrice = null;
        SalePriceTO noAssistPropertyPrice = null;
        SalePriceTO includeAndFindAssistPropertyPrice = null;
        SalePriceTO noAssistAndNoPropertyPrice = null;
        boolean curMaterailIncludeAssistProperty = false;
        boolean priceFoundAssistAttr = false;
        if (to.assistPropertyID != null) {
            curMaterailIncludeAssistProperty = true;
        }
        boolean found = true;
        String matlongnumber = null;
        Iterator it = priceList.iterator();
        while (it.hasNext()) {
            found = true;
            SalePriceTO priceTo = (SalePriceTO)it.next();
            if (priceTo.material != null && !priceTo.material.equals(to.materialId)) {
                found = false;
                continue;
            }
            matlongnumber = materialLNMaps.get(to.materialId).toString();
            if (priceTo.material == null && priceTo.matlongnumber != null && !matlongnumber.contains(priceTo.matlongnumber)) {
                found = false;
                continue;
            }
            if (checkSaleOrg && !StringUtils.isEmpty((String)priceTo.saleOrgUniID) && !StringUtils.isEmpty((String)to.saleOrgID) && !priceTo.saleOrgUniID.equals(to.saleOrgID)) {
                found = false;
                continue;
            }
            if (priceTo.measureUnit != null && !priceTo.measureUnit.equals(to.unitId)) {
                found = false;
                continue;
            }
            if (priceTo.assistProperty != null && to.assistPropertyID != null) {
                if (!priceTo.assistProperty.equals(to.assistPropertyID)) {
                    found = false;
                    continue;
                }
                priceFoundAssistAttr = true;
            }
            if (found && to.qty != null) {
                BigDecimal entryQty = to.qty;
                BigDecimal qty1 = priceTo.qtyFrom;
                BigDecimal qty2 = priceTo.qtyTo;
                if (qty1 != null && entryQty.compareTo(qty1) < 0 || qty2 != null && entryQty.compareTo(qty2) > 0) {
                    found = false;
                    continue;
                }
            }
            if (!found) continue;
            if (curMaterailIncludeAssistProperty && priceFoundAssistAttr) {
                if (includeAndFindAssistPropertyPrice != null) continue;
                includeAndFindAssistPropertyPrice = priceTo;
                continue;
            }
            if (curMaterailIncludeAssistProperty && !priceFoundAssistAttr) {
                includeAssistPropertyPrice = priceTo;
                continue;
            }
            if (!curMaterailIncludeAssistProperty && priceTo.assistProperty != null) {
                noAssistPropertyPrice = priceTo;
                continue;
            }
            if (curMaterailIncludeAssistProperty || priceTo.assistProperty != null || noAssistAndNoPropertyPrice != null) continue;
            noAssistAndNoPropertyPrice = priceTo;
        }
        if (curMaterailIncludeAssistProperty) {
            if (includeAndFindAssistPropertyPrice != null) {
                return includeAndFindAssistPropertyPrice;
            }
            return includeAssistPropertyPrice != null ? includeAssistPropertyPrice : noAssistPropertyPrice;
        }
        if (noAssistAndNoPropertyPrice != null) {
            return noAssistAndNoPropertyPrice;
        }
        return noAssistPropertyPrice != null ? noAssistPropertyPrice : includeAssistPropertyPrice;
    }

    static class ResultTo {
        public String id;
        public String entryId;
        public String companyOrgUnitID;
        public String supProfitCenterID;
        public String supStorageOrgID;
        public String supWareHouseID;
        public String recCompanyOrgID;
        public String recProfitCenterID;
        public String storageOrgUnitID;
        public String recWareHouseID;
        public String settlementRuleID;
        public int pricePrecision;
        public String assistPropertyID;
        public BigDecimal discount;
        public BigDecimal taxRate;
        public BigDecimal taxPrice;
        public BigDecimal actualTaxPrice;
        public String customerId;
        public String rowTypeId;
        public String materialId;
        public String materialName;
        public String unitId;
        public String baseUnitId;
        public BigDecimal qty;
        public String currencyid;
        public BigDecimal price;
        public BigDecimal actualPrice;
        public int discountType;
        public String saleOrgID;
        public BigDecimal addRate;
        public BigDecimal addPrice;
        public int priceRule;
        public String relationEntryID;
        public String ruleEntryID;
        public String ruleCurrencyID;
        public int currencySource;
        public BigDecimal exchangeRate;
        public int accountType;
        public int isPresent;

        ResultTo() {
        }
    }
}

