/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.dao.IObjectValue;
import com.kingdee.bos.framework.batch.BatchExecuteParamsEntry;
import com.kingdee.bos.metadata.entity.EntityViewInfo;
import com.kingdee.bos.metadata.entity.FilterInfo;
import com.kingdee.bos.metadata.entity.FilterItemInfo;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.bos.metadata.entity.SelectorItemInfo;
import com.kingdee.bos.metadata.query.util.CompareType;
import com.kingdee.bos.util.BOSObjectType;
import com.kingdee.bos.util.BOSUuid;
import com.kingdee.eas.basedata.assistant.MeasureUnitInfo;
import com.kingdee.eas.basedata.master.material.IMultiMeasureUnit;
import com.kingdee.eas.basedata.master.material.MaterialPlanInfo;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitFactory;
import com.kingdee.eas.basedata.master.material.MultiMeasureUnitInfo;
import com.kingdee.eas.basedata.org.CompanyOrgUnitCollection;
import com.kingdee.eas.basedata.org.CompanyOrgUnitFactory;
import com.kingdee.eas.basedata.org.CompanyOrgUnitInfo;
import com.kingdee.eas.basedata.org.OrgType;
import com.kingdee.eas.basedata.org.OrgUnitRelationCollection;
import com.kingdee.eas.basedata.org.OrgUnitRelationFactory;
import com.kingdee.eas.basedata.org.OrgUnitRelationInfo;
import com.kingdee.eas.basedata.org.StorageOrgUnitInfo;
import com.kingdee.eas.basedata.scm.common.BillTypeInfo;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.common.SysConstant;
import com.kingdee.eas.dynbusiness.ProcessorExecutionModeEnum;
import com.kingdee.eas.dynbusiness.TransactionModeEnum;
import com.kingdee.eas.dynbusiness.app.processor.ExecuteContext;
import com.kingdee.eas.dynbusiness.condition.Conditions;
import com.kingdee.eas.framework.batchaction.BatchActionEnum;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.mm.basedata.TrackNumberInfo;
import com.kingdee.eas.mm.project.ProjectInfo;
import com.kingdee.eas.scm.common.EntryBaseStatusEnum;
import com.kingdee.eas.scm.common.SCMBillBaseInfo;
import com.kingdee.eas.scm.common.SCMBillEntryBaseInfo;
import com.kingdee.eas.scm.common.app.SCMServerUtils;
import com.kingdee.eas.scm.common.app.bizprocess.util.SCMBizProcessorUtil;
import com.kingdee.eas.scm.common.util.SCMUtils;
import com.kingdee.eas.scm.im.inv.app.InvServerUtils;
import com.kingdee.eas.scm.sm.app.bizprocess.processor.SDSMDefaultValueProcessor;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderException;
import com.kingdee.eas.scm.sm.pur.PurOrderExpenseEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderExpenseEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import com.kingdee.eas.scm.sm.pur.app.PurAlgorithmForPurOrder;
import com.kingdee.eas.scm.sm.pur.util.PurUtil;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PurOrderDefaultValueProcessor
extends SDSMDefaultValueProcessor {
    private static final long serialVersionUID = 1L;
    private Map storageCompany = new HashMap();
    private Map companyMap = new HashMap();

    public PurOrderDefaultValueProcessor(ExecuteContext executeContext, ProcessorExecutionModeEnum executeMode, Conditions conditions, TransactionModeEnum transactionMode) {
        super(executeContext, executeMode, conditions, transactionMode);
    }

    public PurOrderDefaultValueProcessor(Context ctx, BOSObjectType bosType, BatchActionEnum batchAction, String billTypeID, OrgType mainOrgType) {
        super(ctx, bosType, batchAction, billTypeID, mainOrgType);
    }

    public Set<String> getStorageOrgUnitIDs(PurOrderEntryCollection entries) {
        HashSet<String> storageOrgIds = new HashSet<String>();
        PurOrderEntryInfo entryInfo = null;
        StorageOrgUnitInfo storageOrgUnitInfo = null;
        int count = entries.size();
        for (int j = 0; j < count; ++j) {
            entryInfo = entries.get(j);
            storageOrgUnitInfo = entryInfo.getStorageOrgUnit();
            if (storageOrgUnitInfo != null) {
                storageOrgIds.add(storageOrgUnitInfo.getId().toString());
            }
            if (entryInfo.getRequestOrgUnit() == null) continue;
            storageOrgIds.add(entryInfo.getRequestOrgUnit().getId().toString());
        }
        return storageOrgIds;
    }

    @Override
    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        int i;
        super.doProcessing(batchResults);
        if (batchResults == null) {
            return;
        }
        BatchExecuteParamsEntry[] collection = batchResults.getParamEntries();
        if (collection == null || collection.length <= 0) {
            return;
        }
        boolean isFromGui = false;
        int len = collection[0].toArray().length;
        String[] pOrgIds = new String[len];
        for (i = 0; i < len; ++i) {
            PurOrderInfo purOrderInfo;
            if (!(collection[0].toArray()[i] instanceof PurOrderInfo) || (purOrderInfo = (PurOrderInfo)collection[0].toArray()[i]) == null) continue;
            pOrgIds[i] = purOrderInfo.getPurchaseOrgUnit() != null ? purOrderInfo.getPurchaseOrgUnit().getId().toString() : null;
        }
        if (this.companyMap == null || this.companyMap.size() == 0) {
            this.companyMap = this.getCompanyInfos(pOrgIds, OrgType.Purchase, OrgType.Company);
        } else {
            boolean isRevalue = false;
            int size = pOrgIds.length;
            for (int i2 = 0; i2 < size; ++i2) {
                if (pOrgIds[i2] == null || this.companyMap.get(pOrgIds[i2]) != null) continue;
                isRevalue = true;
                break;
            }
            if (isRevalue) {
                this.companyMap = this.getCompanyInfos(pOrgIds, OrgType.Purchase, OrgType.Company);
            }
        }
        if (BatchActionEnum.SAVE.equals((Object)this.batchAction)) {
            for (i = 0; i < len; ++i) {
                PurOrderInfo info;
                if (!(collection[0].toArray()[i] instanceof PurOrderInfo) || (info = (PurOrderInfo)collection[0].toArray()[i]) == null) continue;
                info.put("CONTEXT_KEY_CALLBACK_4_DAO", (Object)true);
                if (info.getCU() == null) {
                    info.setCU(info.getPurchaseOrgUnit().getCU());
                }
                info.setPrepaid(this.nullToZero(info.getPrepaid()));
                if (info.getBillType() == null) {
                    info.setBillType(this.getBillType());
                }
                if (info.getPrepaymentRate() == null) {
                    info.setPrepaymentRate(BigDecimal.ZERO);
                }
                if (info.getPrepayment() == null) {
                    info.setPrepayment(BigDecimal.ZERO);
                }
                PurOrderEntryCollection entries = info.getEntries();
                Set<String> storageOrgIds = this.getStorageOrgUnitIDs(entries);
                if (this.storageCompany == null || this.storageCompany.size() == 0) {
                    this.storageCompany = this.getCompanyInfos(storageOrgIds, OrgType.Storage, OrgType.Company);
                } else {
                    boolean isRevalue = false;
                    String key = null;
                    int size = storageOrgIds.size();
                    for (int j = 0; j < size; ++j) {
                        key = storageOrgIds.toArray()[j].toString();
                        if (this.storageCompany.get(key) != null) continue;
                        isRevalue = true;
                        break;
                    }
                    if (isRevalue) {
                        this.storageCompany = this.getCompanyInfos(storageOrgIds, OrgType.Storage, OrgType.Company);
                    }
                }
                CompanyOrgUnitInfo companyOrgUnitInfo = null;
                PurOrderEntryInfo entryInfo = null;
                StorageOrgUnitInfo storageOrgUnitInfo = null;
                BigDecimal localTotalAmount = SysConstant.BIGZERO;
                BigDecimal localTotalTaxAmount = SysConstant.BIGZERO;
                BigDecimal totalAmount = SysConstant.BIGZERO;
                BigDecimal totalTaxAmount = SysConstant.BIGZERO;
                BigDecimal totalTax = SysConstant.BIGZERO;
                int count = entries.size();
                for (int j = 0; j < count; ++j) {
                    entryInfo = entries.get(j);
                    entryInfo.setUnOrderedQty(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getQty()));
                    entryInfo.setAssociateQty(entryInfo.getQty());
                    this.setDefaultZero((SCMBillBaseInfo)info, (SCMBillEntryBaseInfo)entryInfo);
                    storageOrgUnitInfo = entryInfo.getStorageOrgUnit();
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.TEMPORARILYSAVED);
                    if (storageOrgUnitInfo != null && entryInfo.getCompanyOrgUnit() == null && (companyOrgUnitInfo = (CompanyOrgUnitInfo)this.storageCompany.get(storageOrgUnitInfo.getId().toString())) != null) {
                        entryInfo.setCompanyOrgUnit(companyOrgUnitInfo);
                    }
                    if (entryInfo.getRequestOrgUnit() != null) {
                        entryInfo.setRequestCompanyOrgUnit((CompanyOrgUnitInfo)this.storageCompany.get(entryInfo.getRequestOrgUnit().getId().toString()));
                    }
                    this.setDefaultExpense(entryInfo);
                    localTotalAmount = localTotalAmount.add(this.nullToZero(entryInfo.getLocalAmount()));
                    localTotalTaxAmount = localTotalTaxAmount.add(this.nullToZero(entryInfo.getLocalTaxAmount()));
                    totalAmount = totalAmount.add(this.nullToZero(entryInfo.getAmount()));
                    totalTaxAmount = totalTaxAmount.add(this.nullToZero(entryInfo.getTaxAmount()));
                    totalTax = totalTax.add(this.nullToZero(entryInfo.getTax()));
                }
                if (info.getPrepayment() != null && info.getPrepaid() != null) {
                    info.setUnPrepaidAmount(info.getPrepayment().subtract(info.getPrepaid()));
                }
                if (localTotalAmount.compareTo(PurUtil.MAXVAL) > 0) {
                    Object[] params = new String[]{PurUtil.getServerResource((String)"localAmount", (Context)this.ctx), localTotalAmount.toString()};
                    throw new PurOrderException(PurOrderException.BACKGROUND_FIELD_TOO_LONG, params);
                }
                if (localTotalTaxAmount.compareTo(PurUtil.MAXVAL) > 0) {
                    Object[] params = new String[]{PurUtil.getServerResource((String)"localTaxAmount", (Context)this.ctx), localTotalTaxAmount.toString()};
                    throw new PurOrderException(PurOrderException.BACKGROUND_FIELD_TOO_LONG, params);
                }
                info.setLocalTotalAmount(localTotalAmount);
                info.setLocalTotalTaxAmount(localTotalTaxAmount);
                info.setTotalAmount(totalAmount);
                info.setTotalTaxAmount(totalTaxAmount);
                info.setTotalTax(totalTax);
            }
        } else if (BatchActionEnum.SUBMIT.equals((Object)this.batchAction)) {
            BigDecimal baseQty = null;
            BigDecimal Qty = null;
            for (int i3 = 0; i3 < collection.length; ++i3) {
                if (!(collection[0].toArray()[i3] instanceof PurOrderInfo)) continue;
                PurOrderInfo info = (PurOrderInfo)collection[0].toArray()[i3];
                if (info.getCU() == null) {
                    info.setCU(info.getPurchaseOrgUnit().getCU());
                }
                if (info.getBillType() == null) {
                    info.setBillType(this.getBillType());
                }
                if (info.getPrepaymentRate() == null) {
                    info.setPrepaymentRate(BigDecimal.ZERO);
                }
                if (info.getPrepayment() == null) {
                    info.setPrepayment(BigDecimal.ZERO);
                }
                info.setPrepaid(this.nullToZero(info.getPrepaid()));
                if (i3 == 0 && info.get("isFromGui") == null) {
                    isFromGui = true;
                    info.remove("isFromGui");
                }
                PurOrderEntryCollection entries = info.getEntries();
                HashSet<String> storageOrgIds = new HashSet();
                storageOrgIds = this.getStorageOrgUnitIDs(entries);
                if (this.storageCompany == null || this.storageCompany.size() == 0) {
                    this.storageCompany = this.getCompanyInfos(storageOrgIds, OrgType.Storage, OrgType.Company);
                } else {
                    boolean isRevalue = false;
                    int size = storageOrgIds.size();
                    for (int j = 0; j < size; ++j) {
                        if (this.storageCompany.containsKey(storageOrgIds.toArray()[j])) continue;
                        isRevalue = true;
                        break;
                    }
                    if (isRevalue) {
                        this.storageCompany = this.getCompanyInfos(storageOrgIds, OrgType.Storage, OrgType.Company);
                    }
                }
                PurOrderEntryInfo entryInfo = null;
                StorageOrgUnitInfo storageOrgUnitInfo = null;
                CompanyOrgUnitInfo companyOrgUnitInfo = null;
                BigDecimal localTotalAmount = SysConstant.BIGZERO;
                BigDecimal localTotalTaxAmount = SysConstant.BIGZERO;
                BigDecimal totalAmount = SysConstant.BIGZERO;
                BigDecimal totalTaxAmount = SysConstant.BIGZERO;
                BigDecimal totalTax = SysConstant.BIGZERO;
                boolean isBotp = false;
                if (info != null && info.getSourceBillType() != null) {
                    isBotp = true;
                }
                HashSet<String> storageIDs = new HashSet<String>();
                HashSet<String> materialIDs = new HashSet<String>();
                PurOrderEntryInfo entry = null;
                int nsize = entries.size();
                for (int n = 0; n < nsize; ++n) {
                    entry = entries.get(n);
                    if (entry != null && entry.getMaterial() != null && entry.getMaterial().getId() != null) {
                        materialIDs.add(entry.getMaterial().getId().toString());
                    }
                    if (entry == null || entry.getStorageOrgUnit() == null || entry.getStorageOrgUnit().getId() == null) continue;
                    storageIDs.add(entry.getStorageOrgUnit().getId().toString());
                }
                Map materialPlanMap = new HashMap();
                boolean isOrderBotp = SCMBizProcessorUtil.isBotpBill((SCMBillBaseInfo)info, (String)"9XXvbVGlRtym/0qtqeIXXrhE1B8=");
                MaterialPlanInfo mpInfo = null;
                SelectorItemCollection col = new SelectorItemCollection();
                col.add(new SelectorItemInfo("manufactureStrategy"));
                col.add(new SelectorItemInfo("isolatedRule"));
                col.add(new SelectorItemInfo("status"));
                col.add(new SelectorItemInfo("isolatedRule"));
                materialPlanMap = SCMServerUtils.getMaterialPlanCollec((Context)this.ctx, materialIDs, storageIDs, (SelectorItemCollection)col);
                int count = entries.size();
                for (int j = 0; j < count; ++j) {
                    entryInfo = entries.get(j);
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
                    this.setDefaultZero((SCMBillBaseInfo)info, (SCMBillEntryBaseInfo)entryInfo);
                    baseQty = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getBaseQty());
                    Qty = SCMUtils.effectualNumeric((BigDecimal)entryInfo.getQty());
                    entryInfo.setAssociateQty(baseQty);
                    entryInfo.setTotalUnReceiveBaseQty(baseQty.subtract(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getTotalReceiveBaseQty())));
                    entryInfo.setTotalUnReceiveQty(Qty.subtract(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getTotalReceiveQty())));
                    entryInfo.setTotalUnReceiveQty(Qty.subtract(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getTotalReceiptQty())));
                    entryInfo.setTotalUnReceiveBaseQty(baseQty.subtract(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getTotalReceiveBaseQty())));
                    entryInfo.setTotalUnReturnBaseQty(baseQty.subtract(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getTotalReturnedBaseQty())));
                    entryInfo.setUnPrereceivedAm(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getPrepayment()).subtract(SCMUtils.effectualNumeric((BigDecimal)entryInfo.getPreReceived())));
                    entryInfo.setCanInvMoveQty(Qty);
                    entryInfo.setUnOrderedQty(Qty);
                    entryInfo.setVersion(0);
                    entryInfo.setOldID(null);
                    storageOrgUnitInfo = entryInfo.getStorageOrgUnit();
                    if (storageOrgUnitInfo != null && entryInfo.getCompanyOrgUnit() == null && (companyOrgUnitInfo = (CompanyOrgUnitInfo)this.storageCompany.get(storageOrgUnitInfo.getId().toString())) != null) {
                        entryInfo.setCompanyOrgUnit(companyOrgUnitInfo);
                    }
                    if (entryInfo.getRequestOrgUnit() != null) {
                        entryInfo.setRequestCompanyOrgUnit((CompanyOrgUnitInfo)this.storageCompany.get(entryInfo.getRequestOrgUnit().getId().toString()));
                    }
                    this.setDefaultExpense(entryInfo);
                    localTotalAmount = localTotalAmount.add(this.nullToZero(entryInfo.getLocalAmount()));
                    localTotalTaxAmount = localTotalTaxAmount.add(this.nullToZero(entryInfo.getLocalTaxAmount()));
                    totalAmount = totalAmount.add(this.nullToZero(entryInfo.getAmount()));
                    totalTaxAmount = totalTaxAmount.add(this.nullToZero(entryInfo.getTaxAmount()));
                    totalTax = totalTax.add(this.nullToZero(entryInfo.getTax()));
                    if (entryInfo != null && entryInfo.getStorageOrgUnit() != null && entryInfo.getStorageOrgUnit().getId() != null && entryInfo.getMaterial() != null && entryInfo.getMaterial().getId() != null && (mpInfo = (MaterialPlanInfo)materialPlanMap.get(entryInfo.getMaterial().getId().toString() + entryInfo.getStorageOrgUnit().getId().toString())) != null) {
                        InvServerUtils.checkProjectTrackIsNotNull((Context)this.ctx, (boolean)isBotp, (int)(j + 1), (MaterialPlanInfo)mpInfo, (ProjectInfo)entryInfo.getProject(), (TrackNumberInfo)entryInfo.getTrackNo());
                    }
                    if (!isOrderBotp) continue;
                    if (entryInfo.getAssistUnit() != null && (entryInfo.getAssistQty() == null || entryInfo.getAssistQty().compareTo(SysConstant.BIGZERO) == 0)) {
                        BigDecimal assistQty = this.getExchangeQtyForClient(this.ctx, entryInfo.getMaterial().getId().toString(), entryInfo.getUnit(), entryInfo.getAssistUnit(), entryInfo.getQty());
                        entryInfo.setAssistQty(assistQty);
                    }
                    entryInfo.setBaseStatus(EntryBaseStatusEnum.SUBMITED);
                }
                if (info.getPrepayment() != null && info.getPrepaid() != null) {
                    info.setUnPrepaidAmount(info.getPrepayment().subtract(info.getPrepaid()));
                }
                info.setLocalTotalAmount(localTotalAmount);
                info.setLocalTotalTaxAmount(localTotalTaxAmount);
                info.setTotalAmount(totalAmount);
                info.setTotalTaxAmount(totalTaxAmount);
                info.setTotalTax(totalTax);
                if (isFromGui) continue;
                new PurAlgorithmForPurOrder(info, this.ctx).revalue();
            }
        } else if (BatchActionEnum.AUDIT.equals((Object)this.batchAction)) {
            // empty if block
        }
    }

    @Override
    public BillTypeInfo getBillType() {
        BillTypeInfo info = new BillTypeInfo();
        info.setId(BOSUuid.read((String)"510b6503-0105-1000-e000-010bc0a812fd463ED552"));
        info.setNumber("220");
        return info;
    }

    @Override
    protected void setDefaultZero(SCMBillBaseInfo order, SCMBillEntryBaseInfo entry) {
        super.setDefaultZero(order, entry);
        PurOrderEntryInfo entryInfo = (PurOrderEntryInfo)entry;
        PurOrderInfo orderInfo = (PurOrderInfo)order;
        entryInfo.setQty(this.nullToZero(entryInfo.getQty()));
        entryInfo.setBaseQty(this.nullToZero(entryInfo.getBaseQty()));
        entryInfo.setPrice(this.nullToZero(entryInfo.getPrice()));
        entryInfo.setTaxPrice(this.nullToZero(entryInfo.getTaxPrice()));
        entryInfo.setActualPrice(this.nullToZero(entryInfo.getActualPrice()));
        entryInfo.setActualTaxPrice(this.nullToZero(entryInfo.getActualTaxPrice()));
        entryInfo.setAmount(this.nullToZero(entryInfo.getAmount()));
        entryInfo.setTaxAmount(this.nullToZero(entryInfo.getTaxAmount()));
        entryInfo.setAssistQty(this.nullToZero(entryInfo.getAssistQty()));
        entryInfo.setDiscountRate(this.nullToZero(entryInfo.getDiscountRate()));
        entryInfo.setTaxRate(this.nullToZero(entryInfo.getTaxRate()));
        entryInfo.setDiscountAmount(this.nullToZero(entryInfo.getDiscountAmount()));
        entryInfo.setTax(this.nullToZero(entryInfo.getTax()));
        entryInfo.setTotalExpense(this.nullToZero(entryInfo.getTotalExpense()));
        entryInfo.setDeliverAdvanceDay(this.nullToZero(entryInfo.getDeliverAdvanceDay()));
        entryInfo.setDeliverDeferralDay(this.nullToZero(entryInfo.getDeliverDeferralDay()));
        entryInfo.setReceiveOverRate(this.nullToZero(entryInfo.getReceiveOverRate()));
        entryInfo.setReceiveOwingRate(this.nullToZero(entryInfo.getReceiveOwingRate()));
        if (entryInfo.get("isPresent") == null) {
            entryInfo.setIsPresent(false);
        }
        if (entryInfo.get("quantityUnCtrl") == null) {
            entryInfo.setQuantityUnCtrl(false);
        }
        if (entryInfo.get("timeUnCtrl") == null) {
            entryInfo.setTimeUnCtrl(false);
        }
        if (entryInfo.get("isBetweenCompanyRec") == null) {
            entryInfo.setIsBetweenCompanyRec(false);
        }
        if (entryInfo.getStorageOrgUnit() != null) {
            CompanyOrgUnitInfo companyOrgUnitInfo = (CompanyOrgUnitInfo)this.storageCompany.get(entryInfo.getStorageOrgUnit().getId().toString());
            entryInfo.setCompanyOrgUnit(companyOrgUnitInfo);
        }
        if (entryInfo.getCompanyOrgUnit() != null && orderInfo.getCompanyOrgUnit() != null) {
            if (entryInfo.getCompanyOrgUnit().getId().equals((Object)orderInfo.getCompanyOrgUnit().getId())) {
                entryInfo.setIsBetweenCompanyRec(false);
            } else {
                entryInfo.setIsBetweenCompanyRec(true);
            }
        }
        if (entryInfo.getRequestOrgUnit() != null && entryInfo.getStorageOrgUnit() != null) {
            if (entryInfo.getRequestOrgUnit().getId().equals((Object)entryInfo.getStorageOrgUnit().getId())) {
                entryInfo.setIsRequestToReceived(true);
            } else {
                entryInfo.setIsRequestToReceived(false);
            }
        }
        entryInfo.setTotalReceiveQty(this.nullToZero(entryInfo.getTotalReceiveQty()));
        entryInfo.setTotalReceiveBaseQty(this.nullToZero(entryInfo.getTotalReceiveBaseQty()));
        entryInfo.setPlanReceiveQty(this.nullToZero(entryInfo.getPlanReceiveQty()));
        entryInfo.setTotalReceiptQty(this.nullToZero(entryInfo.getTotalReceiptQty()));
        entryInfo.setTotalReceiptBaseQty(this.nullToZero(entryInfo.getTotalReceiptBaseQty()));
        entryInfo.setTotalReturnedQty(this.nullToZero(entryInfo.getTotalReturnedQty()));
        entryInfo.setTotalCacelledStockQty(this.nullToZero(entryInfo.getTotalCacelledStockQty()));
        entryInfo.setTotalReturnedBaseQty(this.nullToZero(entryInfo.getTotalReturnedBaseQty()));
        entryInfo.setTotalUnReturnBaseQty(this.nullToZero(entryInfo.getTotalUnReturnBaseQty()));
        entryInfo.setTotalUnReceiveBaseQty(this.nullToZero(entryInfo.getTotalUnReceiveBaseQty()));
        entryInfo.setTotalUnReceiveQty(this.nullToZero(entryInfo.getTotalUnReceiveQty()));
        entryInfo.setTotalMoveQty(this.nullToZero(entryInfo.getTotalMoveQty()));
        entryInfo.setTotalInvoicedQty(this.nullToZero(entryInfo.getTotalInvoicedQty()));
        entryInfo.setTotalInvoicedBaseQty(this.nullToZero(entryInfo.getTotalInvoicedBaseQty()));
        entryInfo.setTotalInvoicedAmount(this.nullToZero(entryInfo.getTotalInvoicedAmount()));
        entryInfo.setTotalReqPayAmt(this.nullToZero(entryInfo.getTotalReqPayAmt()));
        entryInfo.setTotalPaidAmount(this.nullToZero(entryInfo.getTotalPaidAmount()));
        entryInfo.setLocalTax(this.nullToZero(entryInfo.getLocalTax()));
        entryInfo.setLocalTaxAmount(this.nullToZero(entryInfo.getLocalTaxAmount()));
        entryInfo.setTotalInvoicedAmt(this.nullToZero(entryInfo.getTotalInvoicedAmt()));
        entryInfo.setTotalPrePayAmt(this.nullToZero(entryInfo.getTotalPrePayAmt()));
        entryInfo.setPrepayment(this.nullToZero(entryInfo.getPrepayment()));
        entryInfo.setPreReceived(this.nullToZero(entryInfo.getPreReceived()));
        entryInfo.setUnPrereceivedAm(this.nullToZero(entryInfo.getUnPrereceivedAm()));
        entryInfo.setTotalSupplyStockQty(this.nullToZero(entryInfo.getTotalSupplyStockQty()));
        entryInfo.setTotalSupplyStockBaseQty(this.nullToZero(entryInfo.getTotalSupplyStockBaseQty()));
        entryInfo.setCanInvMoveQty(this.nullToZero(entryInfo.getCanInvMoveQty()));
        if (entryInfo.get("isReqComEqlRecCom") == null) {
            entryInfo.setIsReqComEqlRecCom(false);
        }
        if (entryInfo.getRequestCompanyOrgUnit() != null && entryInfo.getCompanyOrgUnit() != null && entryInfo.getRequestCompanyOrgUnit().getId().toString().equals(entryInfo.getCompanyOrgUnit().getId().toString())) {
            entryInfo.setIsReqComEqlRecCom(true);
        }
        if (entryInfo.get("isReqPrePayGTprePay") == null) {
            entryInfo.setIsReqPrePayGTprePay(0);
        }
        entryInfo.setMatchedAmount(this.nullToZero(entryInfo.getMatchedAmount()));
        if (orderInfo != null) {
            if (orderInfo.getBizDate() != null) {
                entryInfo.setBizDate(orderInfo.getBizDate());
            }
            if (orderInfo.getPurchaseOrgUnit() != null && orderInfo.getPurchaseOrgUnit().getId() != null) {
                entryInfo.setPurchaseOrgUnit(orderInfo.getPurchaseOrgUnit().getId().toString());
            }
        }
    }

    private void setDefaultExpense(PurOrderEntryInfo purOrderEntryInfo) {
        PurOrderExpenseEntryCollection expenseEntryCollection = null;
        expenseEntryCollection = purOrderEntryInfo.getEntries();
        PurOrderExpenseEntryInfo info = null;
        for (int i = 0; i < expenseEntryCollection.size(); ++i) {
            info = expenseEntryCollection.get(i);
            info.setTax(this.nullToZero(info.getTax()));
            info.setTaxRate(this.nullToZero(info.getTaxRate()));
            info.setUnitExpense(this.nullToZero(info.getUnitExpense()));
            info.setExpenseAmount(this.nullToZero(info.getExpenseAmount()));
        }
    }

    @Override
    protected CompanyOrgUnitInfo getCompanyOrgUnit(Context ctx, IObjectValue model) throws BOSException, EASBizException {
        PurOrderInfo orderInfo = (PurOrderInfo)model;
        PurOrderEntryCollection iObjectCollection = orderInfo.getEntries();
        if (iObjectCollection != null && iObjectCollection.size() > 0) {
            PurOrderEntryInfo entryInfo = (PurOrderEntryInfo)iObjectCollection.getObject(0);
            if (entryInfo.getCompanyOrgUnit() == null) {
                entryInfo.setCompanyOrgUnit((CompanyOrgUnitInfo)this.companyMap.get(orderInfo.getPurchaseOrgUnit().getId().toString()));
            }
            CompanyOrgUnitInfo aCompanyOrgUnitInfo = entryInfo.getCompanyOrgUnit();
            return aCompanyOrgUnitInfo;
        }
        return null;
    }

    protected Map getCompanyInfos(Set<String> souIdSet, OrgType fromType, OrgType toType) throws BOSException, EASBizException {
        HashMap<String, String> couMap = new HashMap<String, String>();
        EntityViewInfo view = new EntityViewInfo();
        view.getSelector().add(new SelectorItemInfo("toUnit"));
        FilterInfo filter = new FilterInfo();
        filter.appendFilterItem("typeRelation.fromType", (Object)new Integer(fromType.getValue()));
        filter.getFilterItems().add(new FilterItemInfo("fromUnit", souIdSet, CompareType.INCLUDE));
        filter.appendFilterItem("typeRelation.toType", (Object)new Integer(toType.getValue()));
        filter.setMaskString("#0 and #1 and #2");
        view.setFilter(filter);
        view.getSelector().add("toUnit.id");
        view.getSelector().add("fromUnit.id");
        OrgUnitRelationCollection ourCol = OrgUnitRelationFactory.getLocalInstance((Context)this.ctx).getOrgUnitRelationCollection(view);
        if (ourCol.size() > 0) {
            HashSet<String> couIdSet = new HashSet<String>();
            int size = ourCol.size();
            for (int i = 0; i < size; ++i) {
                OrgUnitRelationInfo ourInfo = ourCol.get(i);
                couMap.put(ourInfo.getFromUnit().getId().toString(), ourInfo.getToUnit().getId().toString());
                couIdSet.add(ourInfo.getToUnit().getId().toString());
            }
            FilterInfo couFilter = new FilterInfo();
            couFilter.getFilterItems().add(new FilterItemInfo("id", couIdSet, CompareType.INCLUDE));
            EntityViewInfo couView = new EntityViewInfo();
            couView.setFilter(couFilter);
            CompanyOrgUnitCollection couCol = CompanyOrgUnitFactory.getLocalInstance((Context)this.ctx).getCompanyOrgUnitCollection(couView);
            HashMap<String, CompanyOrgUnitInfo> couMap2 = new HashMap<String, CompanyOrgUnitInfo>();
            int size2 = couCol.size();
            for (int i = 0; i < size2; ++i) {
                couMap2.put(couCol.get(i).getId().toString(), couCol.get(i));
            }
            for (Object key : couMap.keySet()) {
                if (couMap.get(key) == null) continue;
                couMap.put((String)key, (String)couMap2.get(couMap.get(key)));
            }
        }
        return couMap;
    }

    protected Map getCompanyInfos(String[] orgIds, OrgType fromType, OrgType toType) throws BOSException, EASBizException {
        HashSet<String> souIdSet = new HashSet<String>();
        int length = orgIds.length;
        for (int i = 0; i < length && orgIds[i] != null; ++i) {
            souIdSet.add(orgIds[i]);
        }
        return this.getCompanyInfos(souIdSet, fromType, toType);
    }

    @Override
    protected List getSelectorList() {
        ArrayList<SelectorItemInfo> selectorList = new ArrayList<SelectorItemInfo>();
        SelectorItemInfo s0 = new SelectorItemInfo("*");
        SelectorItemInfo s1 = new SelectorItemInfo("entries.*");
        SelectorItemInfo s2 = new SelectorItemInfo("entries.material.*");
        SelectorItemInfo s3 = new SelectorItemInfo("entries.rowType.*");
        SelectorItemInfo s4 = new SelectorItemInfo("bizType.*");
        selectorList.add(s0);
        selectorList.add(s1);
        selectorList.add(s2);
        selectorList.add(s3);
        selectorList.add(s4);
        return selectorList;
    }

    @Override
    protected String getEntryName() {
        return "entries";
    }

    private BigDecimal getExchangeQtyForClient(Context ctx, String materialID, MeasureUnitInfo unitInfo, MeasureUnitInfo otherUnitInfo, BigDecimal qty) throws BOSException, EASBizException {
        if (materialID == null) {
            throw new IllegalArgumentException();
        }
        IMultiMeasureUnit multiUnit = MultiMeasureUnitFactory.getLocalInstance((Context)ctx);
        MultiMeasureUnitInfo multiUnifInfo = multiUnit.getMultiUnit(materialID, unitInfo.getId().toString());
        MultiMeasureUnitInfo othermultiUnifInfo = multiUnit.getMultiUnit(materialID, otherUnitInfo.getId().toString());
        return SCMUtils.getExchangeQtyForClient((MultiMeasureUnitInfo)multiUnifInfo, (MultiMeasureUnitInfo)othermultiUnifInfo, (BigDecimal)qty);
    }
}

