/*
 * Decompiled with CFR 0.152.
 */
package com.kingdee.eas.scm.sm.app.bizprocess.processor.purorder;

import com.kingdee.bos.BOSException;
import com.kingdee.bos.Context;
import com.kingdee.bos.SQLDataException;
import com.kingdee.bos.dao.IObjectPK;
import com.kingdee.bos.dao.ormapping.ObjectUuidPK;
import com.kingdee.bos.metadata.entity.SelectorItemCollection;
import com.kingdee.eas.common.EASBizException;
import com.kingdee.eas.dynbusiness.ProcessorExecutionMode;
import com.kingdee.eas.dynbusiness.app.processor.AbstractBusinessProcessor;
import com.kingdee.eas.dynbusiness.app.processor.ProcessorConstructParam;
import com.kingdee.eas.framework.CoreBaseInfo;
import com.kingdee.eas.framework.batchaction.BatchActionResults;
import com.kingdee.eas.framework.report.util.DBUtilx;
import com.kingdee.eas.framework.report.util.SqlParams;
import com.kingdee.eas.scm.common.util.SCMConstant;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryCollection;
import com.kingdee.eas.scm.sm.pur.PurOrderEntryInfo;
import com.kingdee.eas.scm.sm.pur.PurOrderFactory;
import com.kingdee.eas.scm.sm.pur.PurOrderInfo;
import java.math.BigDecimal;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class PurOrderPaymentMatchProcessor
extends AbstractBusinessProcessor {
    private static Logger logger = Logger.getLogger((String)PurOrderPaymentMatchProcessor.class.getName());
    private static final BigDecimal zero = SCMConstant.BIGDECIMAL_ZERO;

    public PurOrderPaymentMatchProcessor(ProcessorConstructParam param) {
        super(param);
    }

    protected void doProcessing(BatchActionResults batchResults) throws BOSException, EASBizException {
        String purOrderID = (String)this.getExecuteContext().getApplicationContext().getData("purOrderID");
        BigDecimal matchedAmount = (BigDecimal)this.getExecuteContext().getApplicationContext().getData("matchedAmount");
        SelectorItemCollection sic = new SelectorItemCollection();
        sic.add("*");
        sic.add("companyOrgUnit.*");
        sic.add("entries.*");
        sic.add("entries.paymentCustomer.*");
        PurOrderInfo purOrder = (PurOrderInfo)PurOrderFactory.getLocalInstance((Context)this.ctx).getValue((IObjectPK)new ObjectUuidPK(purOrderID), sic);
        String sql = "delete from t_pur_paymentmatch where FPurOrderID=?";
        SqlParams sp = new SqlParams().addString(purOrder.getId().toString());
        try {
            DBUtilx.executeUpdate((String)sql, (SqlParams)sp, (Context)this.ctx);
        }
        catch (SQLException e) {
            throw new SQLDataException(e);
        }
        if (purOrder.getPrepaid() != null && purOrder.getPrepaid().compareTo(zero) > 0) {
            purOrder.setPrepaid(matchedAmount.add(purOrder.getPrepaid()));
        } else {
            purOrder.setPrepaid(matchedAmount);
        }
        purOrder.setIsMatched(true);
        PurOrderEntryCollection sc = purOrder.getEntries();
        BigDecimal u = zero;
        BigDecimal preReceived = zero;
        int n = sc.size();
        for (int i = 0; i < n; ++i) {
            PurOrderEntryInfo e = sc.get(i);
            BigDecimal bigDecimal = u = e.getUnPrereceivedAm() == null ? zero : e.getUnPrereceivedAm();
            if (matchedAmount.doubleValue() > u.doubleValue()) {
                if (i == n - 1) {
                    if (e.getPreReceived() != null) {
                        preReceived = e.getPreReceived();
                    }
                    e.setPreReceived(matchedAmount.add(preReceived));
                    if (e.getPrepayment() == null || e.getPreReceived() == null) break;
                    e.setUnPrereceivedAm(e.getPrepayment().subtract(e.getPreReceived()));
                    break;
                }
                if (e.getPreReceived() != null) {
                    preReceived = e.getPreReceived();
                }
            } else {
                u = u.subtract(matchedAmount);
                e.setUnPrereceivedAm(u);
                if (e.getPreReceived() != null) {
                    preReceived = e.getPreReceived();
                }
                e.setPreReceived(matchedAmount.add(preReceived));
                break;
            }
            e.setPreReceived(u.add(preReceived));
            e.setUnPrereceivedAm(e.getPrepayment().subtract(e.getPreReceived()));
            matchedAmount = matchedAmount.subtract(u);
        }
        PurOrderFactory.getLocalInstance((Context)this.ctx).update((IObjectPK)new ObjectUuidPK(purOrder.getId().toString()), (CoreBaseInfo)purOrder);
    }

    public ProcessorExecutionMode supportExecutionMode() throws BOSException {
        return null;
    }
}

